<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Frontpage file.
 *
 * @package     theme_trema
 * @copyright   2019-2025 Trema - {@link https://trema.tech/}
 * @copyright   2024-2025 TNG Consulting Inc. - {@link https://www.tngconsulting.ca/}
 * @author      Rodrigo Mady
 * @author      Trevor Furtado
 * @author      Michael Milette
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once("$CFG->dirroot/theme/trema/locallib.php");
require_once($CFG->libdir . '/behat/lib.php');

// Add block button in editing mode.
$addblockbutton = $OUTPUT->addblockbutton();
$forceblockdraweropen = $OUTPUT->firstview_fakeblocks();
$pluginsettings = get_config("theme_trema");

if (isloggedin()) {
    $blockdraweropen = (get_user_preferences('drawer-open-block') == true);
} else if (isset($pluginsettings->frontpagedraweropen) && $pluginsettings->frontpagedraweropen) {
    $blockdraweropen = true;
} else {
    $blockdraweropen = false;
}

if (defined('BEHAT_SITE_RUNNING') && get_user_preferences('behat_keep_drawer_closed') != 1) {
    $blockdraweropen = true;
}

$extraclasses = ['uses-drawers'];
if ($blockdraweropen) {
    $extraclasses[] = 'drawer-open-block';
}
$bodyattributes = $OUTPUT->body_attributes($extraclasses);
$blockshtml = $OUTPUT->blocks('side-pre');
$hasblocks = (strpos($blockshtml, 'data-block=') !== false || !empty($addblockbutton));
if (!$hasblocks) {
    $blockdraweropen = false;
}

$secondarynavigation = false;
$overflow = '';
if ($PAGE->has_secondary_navigation()) {
    $moremenu = new \core\navigation\output\more_menu($PAGE->secondarynav, 'nav-tabs');
    $secondarynavigation = $moremenu->export_for_template($OUTPUT);
    $overflowdata = $PAGE->secondarynav->get_overflow_menu_data();
    if (!is_null($overflowdata)) {
        $overflow = $overflowdata->export_for_template($OUTPUT);
    }
}

if ($CFG->branch > 400) {
    $primary = new theme_trema\output\primary_navigation($PAGE);
} else {
    $primary = new core\navigation\output\primary($PAGE);
}

$renderer = $PAGE->get_renderer('core');
$primarymenu = $primary->export_for_template($renderer);
$buildregionmainsettings = !$PAGE->include_region_main_settings_in_header_actions()  && !$PAGE->has_secondary_navigation();
// If the settings menu will be included in the header then don't add it here.
$regionmainsettingsmenu = $buildregionmainsettings ? $OUTPUT->region_main_settings_menu() : false;

$header = $PAGE->activityheader;
$headercontent = $header->export_for_template($renderer);

$adminblockshtml = $OUTPUT->blocks('side-admin');
$numberofimages = $pluginsettings->numberofimages;
$overlayimage   = $OUTPUT->image_url('frontpage/overlay', 'theme');
// Frontpage images.
if ($numberofimages > 1) {
    $frontpagecarrousel = [];
    $active = true;
    for ($i = 1; $i <= $numberofimages; $i++) {
        $title = "carrouseltitle{$i}";
        $subtitle = "carrouselsubtitle{$i}";
        $btntext = "carrouselbtntext{$i}";
        $btnhref = "carrouselbtnhref{$i}";
        $btnclass = "carrouselbtnclass{$i}";
        $url = theme_trema_setting_file_url("frontpageimage{$i}", "frontpageimage{$i}", $PAGE->theme);

        if (!empty($url)) {
            $frontpagecarrousel[$i]['image'] = !empty($pluginsettings->frontpageenabledarkoverlay) ?
            "background-image: url('$overlayimage'), url('$url');" :
            "background-image: url('$url')";
        } else {
            $frontpagecarrousel[$i]['image'] = $OUTPUT->image_url('frontpage/banner2', 'theme');
        }
        $frontpagecarrousel[$i]['index']    = $i - 1;
        $frontpagecarrousel[$i]['title']    = !empty($pluginsettings->$title) ? \format_string($pluginsettings->$title) : '';
        $frontpagecarrousel[$i]['subtitle'] = !empty($pluginsettings->$subtitle) ? \format_string($pluginsettings->$subtitle) : '';
        $frontpagecarrousel[$i]['btntext']  = !empty($pluginsettings->$btntext) ? \format_string($pluginsettings->$btntext) : '';
        $frontpagecarrousel[$i]['btnhref']  = !empty($pluginsettings->$btnhref) ? $pluginsettings->$btnhref : '';
        $frontpagecarrousel[$i]['btnclass'] = !empty($pluginsettings->$btnclass) ? $pluginsettings->$btnclass : '';
        // Must have just one slide active.
        if ($active) {
            $frontpagecarrousel[$i]['active'] = "active";
            $active = false;
        }
    }
    $frontpagecarrousel = array_values($frontpagecarrousel);
} else {
    $frontpagecarrousel = false;
}

$regionmainsettingsmenu = $OUTPUT->region_main_settings_menu();
$context = \context_system::instance();
$databs = $CFG->branch >= 500 ? 'bs-' : '';

$templatecontext = [
    'sitename' => \format_string($SITE->shortname, true, ['context' => $context, 'escape' => false]),
    'output' => $OUTPUT,
    'sidepreblocks' => $blockshtml,
    'sideadminblocks' => $adminblockshtml,
    'hasblocks' => $hasblocks,
    'hasadminblocks' => is_siteadmin(),
    'blockdraweropen' => $blockdraweropen,
    'forceblockdraweropen' => $forceblockdraweropen,
    'bodyattributes' => $bodyattributes,
    'primarymoremenu' => $primarymenu['moremenu'],
    'secondarymoremenu' => $secondarynavigation ?: false,
    'mobileprimarynav' => $primarymenu['mobileprimarynav'],
    'usermenu' => $primarymenu['user'],
    'langmenu' => $primarymenu['lang'],
    'regionmainsettingsmenu' => $regionmainsettingsmenu,
    'hasregionmainsettingsmenu' => !empty($regionmainsettingsmenu),
    'headercontent' => $headercontent,
    'overflow' => $overflow,
    'addblockbutton' => $addblockbutton,
    'defaultfrontpagebody' => !empty($pluginsettings->defaultfrontpagebody) ?
            \format_text($pluginsettings->defaultfrontpagebody, FORMAT_HTML, ['context' => $context]) : '',
    'defaultfooter' => !empty($pluginsettings->defaultfooter) ?
            \format_text($pluginsettings->defaultfooter, FORMAT_HTML, ['context' => $context]) : '',
    'showbanner' => ($numberofimages > 0),
    'frontpagecarrousel' => $frontpagecarrousel,
    'ifcarrousel' => ($numberofimages > 1),
    'frontpagetitle' => !empty($pluginsettings->frontpagetitle) ?
        \format_string($pluginsettings->frontpagetitle) : '',
    'frontpagesubtitle' => !empty($pluginsettings->frontpagesubtitle) ?
        \format_string($pluginsettings->frontpagesubtitle) : '',
    'frontpagebuttontext' => !empty($pluginsettings->frontpagebuttontext) ?
        \format_string($pluginsettings->frontpagebuttontext) : '',
    'frontpagebuttonclass' => !empty($pluginsettings->frontpagebuttonclass) ?
        $pluginsettings->frontpagebuttonclass : '',
    'frontpagebuttonhref' => !empty($pluginsettings->frontpagebuttonhref) ?
        $pluginsettings->frontpagebuttonhref : '',
    'hascards' => !empty($pluginsettings->frontpageenablecards),
    'cardstitle' => !empty($pluginsettings->frontpagecardstitle) ?
        \format_string($pluginsettings->frontpagecardstitle) : '',
    'cardssubtitle' => !empty($pluginsettings->frontpagecardssubtitle) ?
        \format_string($pluginsettings->frontpagecardssubtitle) : '',
    'cardssettings' => theme_trema_get_cards_settings(),
    'enabletremafooter' => $pluginsettings->enabletremafooter,
    'footerinfo' => !empty($pluginsettings->enablefooterinfo),
    'showbranding' => !empty($pluginsettings->showbranding),
    'databs' => $databs,
];

echo $OUTPUT->render_from_template('theme_trema/frontpage', $templatecontext);
