Adaptable - the most adaptable moodle theme
===========================================
Adaptable is a highly customizable responsive two column moodle theme based on the popular BCU theme adding:

- Customizable fonts (Google Fonts)
- Fully customizable colors
- Fully customizable block styles (including FA icons)
- Fully customizable buttons
- Additional header navigation
- News Ticker
- Alternative jQuery slider
- Alternative front page course styles
- Additional customizable marketing blocks
- Additional layout settings for width, slider width, padding of
  various elements
- Social icons
- Mobile settings (customize how theme looks on mobile devices)
- Dismissible bootstrap alerts
- Option to add login form in header on front page
- Logo and Favicon uploader
- Modern emojis (thanks to EmojiOne)
- Front Page layout builder
- Dashboard layout builder
- Course layout builder
- Activities status
- Privacy API (compatible with GDPR)
- 2 and 3 row header style options 
- 2 User profile layouts

In addition many fields (menus, news items, alerts and help links) can be targeted using custom profile fields, thus it is possible
to present different users with different navigation items and notices. It is also possible for individual users to customize where
they want top menu navigation to appear (disable, home pages only, site wide) using custom profile fields.

Adaptable has a lot of settings and may seem daunting at first, our advice is to simply install with the default settings and play
with it afterwards.

With a little time you should be able to setup an attractive Moodle site with a high degree of individuality without without
knowing any CSS.

Current developer:
G J Barnard MSc. BSc(Hons)(Sndw). MBCS. CEng. CITP. PGCE.  [Moodle profile](https://moodle.org/user/profile.php?id=442195) and [Web profile](https://about.me/gjbarnard)

This theme has been developed by the following:

- Jeremy Hopkins (Coventry University)
- Fernando Acedo (3bits elearning solutions)
- Manoj Solanki (Coventry University)
- G J Barnard MSc. BSc(Hons)(Sndw). MBCS. CEng. CITP. PGCE.

Required release of Moodle
==========================
This version works with Moodle 4.3 version 2023100900.00 (Build: 20231009) and above within the MOODLE_403_STABLE branch until the
next release.

Please ensure that your hardware and software complies with 'Requirements' in '[Installing Moodle](https://docs.moodle.org/403/en/Installing_Moodle)'.

Installation
============
 1. Ensure you have the release of Moodle as stated above in 'Required release of Moodle'.  This is essential as the
    theme relies on underlying core code that is out of my control.
 2. Login as an administrator and put Moodle in 'Maintenance Mode' so that there are no users using it bar you as the administrator.
 3. Copy the extracted 'adaptable' folder to the '/theme/' folder.
 4. Go to 'Site administration' -> 'Notifications' and follow standard the 'plugin' update notification.
 5. Select as the theme for the site.
 6. Put Moodle out of Maintenance Mode.

Upgrading
=========
 1. Ensure you have the release of Moodle as stated above in 'Required release of Moodle'.  This is essential as the
    theme relies on underlying core code that is out of my control.
 2. Login as an administrator and put Moodle in 'Maintenance Mode' so that there are no users using it bar you as the administrator.
 3. Make a backup of your old 'adaptable' folder in '/theme/' and then delete the folder.
 4. Copy the replacement extracted 'adaptable' folder to the '/theme/' folder.
 5. Go to 'Site administration' -> 'Notifications' and follow standard the 'plugin' update notification.
 6. If automatic 'Purge all caches' appears not to work by lack of display etc. then perform a manual 'Purge all caches'
    under 'Home -> Site administration -> Development -> Purge all caches'.
 7. Put Moodle out of Maintenance Mode.

Uninstallation
==============
 1. Put Moodle in 'Maintenance Mode' so that there are no users using it bar you as the administrator.
 2. Change the theme to another theme of your choice.
 3. In '/theme/' remove the folder 'adaptable'.
 4. Go to 'Site administration' -> 'Notifications' and follow standard the 'plugin' update notification.
 5. Put Moodle out of Maintenance Mode.

Versioning
==========
Adaptable is maintained under the Semantic Versioning 2.0.0 guidelines as much as possible. Releases will be numbered with the
following format:

major.minor.patch

and following these guidelines:

- Breaking backward compatibility bumps the major (and resets the minor and patch)
- New additions without breaking backward compatibility bumps the minor (and resets the patch)
- Bug fixes and misc changes bumps the patch

For more information on SemVer, please visit http://semver.org.


Acknowledgments
===============
Development contributions from:

- Justin Hunt
- Leonid Chernyavskiy
- COMETE (UniversitÃ© Paris Nanterre)
- Marina Glancy
- Nick Phillips
- BjÃ¶rn BettzÃ¼che
- Michael Milette
- Bas Brands
- Gareth Barnard
- KonrÃ¡d LÅ‘rinczi
- Mathieu Domingo

Testing:

- Andrew Walding
- Alexander Goryntsev

Translation:

- GermÃ¡n Valero (EspaÃ±ol - MÃ©xico)
- Jordi Rodilla (CatalÃ   - Andorra)

Licenses
========
Adaptable is licensed under:

- [GPL v3 (GNU General Public License)](http://www.gnu.org/licenses)

Google Fonts released under:

- [SIL Open Font License v1.1](http://scripts.sil.org/OFL)
- [Apache 2 license](https://www.apache.org/licenses/LICENSE-2.0)
- The Ubuntu fonts use the [Ubuntu Font License v1.0](http://font.ubuntu.com/ufl/ubuntu-font-licence-1.0.txt)

The Font Awesome font (by Dave Gandy) http://fontawesome.io, is licensed under:

- Fonts: [SIL Open Font License v1.1](http://scripts.sil.org/OFL)
- Documentation: CC BY 3.0
- CSS, LESS, and SASS files are licensed under:
[MIT License](https://opensource.org/licenses/mit-license.html)

Emoji icons provided free by [EmojiOne](http://emojione.com) released under:

- [Creative Commons Attribution 4.0 International](https://creativecommons.org/licenses/by/4.0/)
