function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)
/**
 * jquery.textarea-highlighter.js - jQuery plugin for highlighting text in textarea.
 * @version v0.6.3
 * @link https://github.com/marexandre/jquery.textarea-highlighter.js
 * @author alexandre.kirillov@gmail.com
 * @license MIT license. http://opensource.org/licenses/MIT
 */}var factory;factory=function(jQuery){var marexandre;!function(marexandre){var Helper=function(){function Helper(){}return Helper.prototype.orderBy=function(list,type){return list.sort((function(a,b){return parseInt(a[type],10)-parseInt(b[type],10)}))},Helper.prototype.removeOverlapingIndecies=function(list){for(var item,next,a=[],i=0,imax=list.length;i<imax;i++){item=list[i];for(var j=i+1;j<imax;j++)next=list[j],this.isOverlap(item,next)&&a.push(j)}return list.slice(0).filter((function(elem,pos){return-1===a.indexOf(pos)}))},Helper.prototype.isOverlap=function(x,y){return x.start<y.end&&y.start<x.end},Helper.prototype.cleanupOnWordBoundary=function(text,list,useWordBoundary){useWordBoundary=useWordBoundary||!0;for(var o,w,ww,a=[],i=0,imax=list.length;i<imax;i++)o=list[i],w=text.slice(o.start,o.end),ww=text.slice(o.start-1,o.end+1),useWordBoundary&&this.isWrappedByASCII(w)&&!this.checkWordBoundary(w,ww)&&a.push(i);return list.slice(0).filter((function(elem,pos){return-1===a.indexOf(pos)}))},Helper.prototype.makeTokenized=function(text,indecies){for(var o,a=[],s=0,ss=0,i=0,imax=indecies.length;i<imax;i++)(o=indecies[i]).end<o.start||((ss=o.start)>s&&a.push({value:text.slice(s,ss),type:"text"}),a.push({value:text.slice(ss,o.end),type:o.type}),s=o.end);return s<text.length&&a.push({value:text.slice(s,text.length),type:"text"}),a},Helper.prototype.checkWordBoundary=function(w,ww){return new RegExp("\\b"+this.escapeRegExp(w)+"\\b").test(ww)},Helper.prototype.isWrappedByASCII=function(str){return/^\w.*\w$|^\w+$/.test(str)},Helper.prototype.escapeHTML=function(str){return str.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")},Helper.prototype.escapeRegExp=function(str){return str.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&")},Helper.prototype.sanitizeBreakLines=function(str){return str.replace(/\r\n/g,"\n").replace(/\r/g,"\n")},Helper.prototype.getUniqueArray=function(a){return a.filter((function(elem,pos,self){return""!==elem&&self.indexOf(elem)===pos}))},Helper.prototype.createHTML=function(tokenized){for(var a=[],i=0,imax=tokenized.length;i<imax;i++)"text"===tokenized[i].type?a.push(tokenized[i].value):a.push(this.getTextInSpan(tokenized[i].type,tokenized[i].value));return a.join("")},Helper.prototype.getTextInSpan=function(className,text){return'<span class="'+className+'">'+text+"</span>"},Helper.prototype.browser=function(){var userAgent=navigator.userAgent,msie=/(msie|trident)/i.test(userAgent),chrome=/chrome/i.test(userAgent),firefox=/firefox/i.test(userAgent),safari=/safari/i.test(userAgent)&&!chrome,iphone=/iphone/i.test(userAgent);return msie?{msie:!0}:chrome?{chrome:!0}:firefox?{firefox:!0}:iphone?{iphone:!0}:safari?{safari:!0}:{msie:!1,chrome:!1,firefox:!1,safari:!1,iphone:!1}},Helper}();marexandre.Helper=Helper}(marexandre||(marexandre={})),function($,window,document,undefined$1){var pluginName="textareaHighlighter",helper=new marexandre.Helper,TextareaHighlighter=function TextareaHighlighter($el,options){this.$element=$el,this.element=this.$element[0],this.settings=$.extend({},TextareaHighlighter.DEFAULTS,this.$element.data(),options),this.$wrapDiv=$(document.createElement("div")).addClass("textarea-highlighter-wrap"),this.$backgroundDiv=$(document.createElement("div")).addClass("background-div "+this.$element.attr("class")),this.$autoSize=$('<pre><div class="autosize"></div></pre>').addClass(this.$element.attr("class")).hide(),this.$autoSizeElement=this.$autoSize.find(".autosize"),this.init()};TextareaHighlighter.DEFAULTS={matches:[],isAutoExpand:!0,typingDelay:30,debug:!1},TextareaHighlighter.prototype.init=function(){var $this=this.$element,settings=this.settings,$wrapDiv=this.$wrapDiv,$backgroundDiv=this.$backgroundDiv;this.updateStyle(),$this.wrap($wrapDiv).before($backgroundDiv),settings.isAutoExpand&&$this.after(this.$autoSize),this.updateHeight(),this.bindEvents(),this.highlight()},TextareaHighlighter.prototype.bindEvents=function(){var _this=this,$this=this.$element;if($this.data("highlighterTimerId",-1).on("scroll.textarea.highlighter",(function(){_this.$backgroundDiv.scrollTop($this.scrollTop())})),"onpropertychange"in _this.element){var lastUpdate=(new Date).getTime(),timeDiff=0,abs=Math.abs;$this.on("input.textarea.highlighter keyup.textarea.highlighter",(function(e){(timeDiff=abs(lastUpdate-(new Date).getTime()))>10&&(_this.change(e),lastUpdate=(new Date).getTime())})),$this.on("keydown.textarea.highlighter",(function(e){timeDiff=abs(lastUpdate-(new Date).getTime()),8===e.which&&(timeDiff<10||250<timeDiff)&&(_this.change(e),lastUpdate=(new Date).getTime())}))}else $this.on("input.textarea.highlighter",(function(e){_this.change(e)}))},TextareaHighlighter.prototype.change=function(e){var _this=this;if(/(37|38|39|40)/.test(e.keyCode))return!0;_this.updateHeight(),-1!==_this.$element.data("highlighterTimerId")&&(clearTimeout(_this.$element.data("highlighterTimerId")),_this.$element.data("highlighterTimerId",-1));var changeId=setTimeout((function(){_this.highlight()}),_this.settings.typingDelay);_this.$element.data("highlighterTimerId",changeId)},TextareaHighlighter.prototype.highlight=function(){var text=this.$element.val();this.settings,text=this.getHighlightedContent(text),this.$backgroundDiv.html(text),this.updateHeight(),this.$element.trigger("textarea.highlighter.highlight")},TextareaHighlighter.prototype.getHighlightedContent=function(text){for(var list=JSON.parse(JSON.stringify(this.settings.matches)),i=0,imax=list.length;i<imax;i++)list[i].end++;list=helper.orderBy(list,"start"),list=helper.removeOverlapingIndecies(list);var tokens=helper.makeTokenized(text,list);for(i=0,imax=tokens.length;i<imax;i++)tokens[i].value=helper.escapeHTML(tokens[i].value);return helper.createHTML(tokens)},TextareaHighlighter.prototype.updateMatches=function(matches){this.settings.matches=matches,this.highlight()},TextareaHighlighter.prototype.updateStyle=function(){var $this=this.$element,settings=this.settings,style={paddingTop:parseInt($this.css("padding-top"),10),paddingRight:parseInt($this.css("padding-right"),10),paddingBottom:parseInt($this.css("padding-bottom"),10),paddingLeft:parseInt($this.css("padding-left"),10)};helper.browser().iphone&&(style.paddingRight+=3,style.paddingLeft+=3),this.$wrapDiv.css({position:"relative"}),this.$backgroundDiv.css({position:"absolute",height:"100%","font-family":"inherit",color:settings.debug?"#f00":"transparent","padding-top":style.paddingTop,"padding-right":style.paddingRight,"padding-bottom":style.paddingBottom,"padding-left":style.paddingLeft}),this.cloneCSSToTarget(this.$backgroundDiv),settings.isAutoExpand&&(this.$autoSize.css({top:0,left:0,"font-family":"inherit",position:"absolute","padding-top":style.paddingTop,"padding-right":style.paddingRight,"padding-bottom":style.paddingBottom,"padding-left":style.paddingLeft}),this.cloneCSSToTarget(this.$autoSize)),$this.css({color:settings.debug?"rgba(0,0,0,0.5)":"inherit",position:"relative",background:"none"})},TextareaHighlighter.prototype.updateHeight=function(){if(this.settings.isAutoExpand){this.$autoSizeElement.html(helper.escapeHTML(helper.sanitizeBreakLines(this.$element.val()))+" ");var h=this.$autoSize.height();this.$element.height()!==h&&(this.$element.height(h),this.$backgroundDiv.height(h))}},TextareaHighlighter.prototype.cloneCSSToTarget=function($t){var $element=this.$element,val=null;$.each(["lineHeight","textDecoration","letterSpacing","fontSize","fontStyle","fontWeight","textTransform","textAlign","direction","wordSpacing","fontSizeAdjust","wordWrap","word-break","marginLeft","marginRight","marginTop","marginBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth","boxSizing","webkitBoxSizing","mozBoxSizing","msBoxSizing"],(function(i,p){val=$element.css(p),$t.css(p)!==val&&$t.css(p,val)}))},TextareaHighlighter.prototype.destroy=function(){$.data(this.element,"plugin_"+pluginName,!1),this.$backgroundDiv.remove(),this.$autoSize.remove(),this.$element.data("highlighterTimerId",-1).off("scroll.textarea.highlighter").off("input.textarea.highlighter").off("keyup.textarea.highlighter").off("propertychange.textarea.highlighter").attr("style","").unwrap()},TextareaHighlighter.prototype.debugModeOn=function(){this.settings.debug=!0,this.$backgroundDiv.css({color:"#f00"}),this.$element.css({color:"rgba(0,0,0,0.5)"})},TextareaHighlighter.prototype.debugModeOff=function(){this.settings.debug=!1,this.$backgroundDiv.css({color:"transparent"}),this.$element.css({color:"inherit"})},$.fn.textareaHighlighter=function(option){var args=arguments;return this.each((function(){var $this=$(this),data=$this.data(pluginName),options="object"===_typeof(option)&&option;if(option&&(data||"string"!=typeof option)&&(data||(data=new TextareaHighlighter($this,options),$this.data(pluginName,data)),"string"==typeof option)){if(!data[option])throw"Unknown method: "+option;data[option].apply(data,Array.prototype.slice.call(args,1))}}))}}(jQuery,window,document)},"function"==typeof define&&define.amd?define("qtype_poasquestion/jquery.textarea-highlighter",["jquery"],factory):"object"===("undefined"==typeof exports?"undefined":_typeof(exports))?module.exports=factory(require("jquery")):factory(jQuery);

//# sourceMappingURL=jquery.textarea-highlighter.min.js.map