<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace mod_studentquiz\question\bank;

/**
 * A column type for the name of the question name.
 *
 * @package    mod_studentquiz
 * @copyright  2017 HSR (http://www.hsr.ch)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class question_text_row extends \core_question\local\bank\row_base {
    /**
     * @var string formatoptions
     */
    protected $formatoptions;

    /**
     * Get the column name
     * @return string questiontext
     */
    public function get_name() {
        return 'questiontext';
    }

    /**
     * Override parent function to don't show the title
     */
    public function get_title() {
    }

    /**
     * Override parent function to don't show content
     * @param object $question empty
     * @param string $rowclasses empty
     */
    protected function display_content($question, $rowclasses) {
    }

    /**
     * Override parent function to don't show content
     * @param object $question the row from the $question table, augmented with extra information.
     * @param string $rowclasses CSS class names that should be applied to this row of output.
     */
    public function display($question, $rowclasses): void {

    }

    /**
     * Get the extra join text
     * @return array join text
     */
    public function get_extra_joins(): array {
        return array();
    }

    /**
     * Get required fields
     * @return array get all required fields
     */
    public function get_required_fields(): array {
        return array('q.id', 'q.questiontext', 'q.questiontextformat', 'qc.contextid');
    }
}
