/**
 * The CloudPoodll JS for loading recorders into iframe based on data-attributes on the container div
 *
 * @module     mod_readaloud/cloudpoodll
 * @copyright  2025 Justin Hunt <justin@poodll.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(["jquery","core/log"],(function($,log){return{version:"1.3.4",baseURL:"https://cloud.poodll.com/local/cpapi/fastpoodllloader.php",params:["parent","appid","timelimit","type","media","updatecontrol","width","height","id","iframeclass","transcode","transcoder","transcribe","subtitle","language","transcribevocab","expiredays","owner","region","token","localloader","localloading","notificationurl","sourcemimetype","speechevents","hints","alreadyparsed","fallback","cloudpoodllurl"],setBaseUrl:function(cloudpoodllurl){this.baseURL=cloudpoodllurl+"/local/cpapi/fastpoodllloader.php"},fetchContainers:function(classname){return document.getElementsByClassName(classname)},autoCreateRecorders:function(classname){classname||(classname="cloudpoodll");for(var containers=this.fetchContainers(classname),ctr=0;ctr<containers.length;ctr++)this.insertRecorder(containers[ctr])},createRecorder:function(elementid){var theelement=document.getElementById(elementid);this.insertRecorder(theelement)},insertRecorder:function(container,attributes){null==attributes&&(attributes=this.parseAttributes(container));var iframe=this.createIframe(attributes);iframe&&(container.appendChild(iframe),container.setAttribute("data-alreadyparsed","true"))},parseAttributes:function(container){for(var attributes={},i=0;i<this.params.length;i++){var attr=container.getAttribute("data-"+this.params[i]);null!==attr&&(attributes[this.params[i]]=attr)}return attributes},createIframe:function(attributes){if(attributes.hasOwnProperty("alreadyparsed")&&"true"==attributes.alreadyparsed)return!1;attributes.hasOwnProperty("cloudpoodllurl")&&this.setBaseUrl(attributes.cloudpoodllurl),attributes.hasOwnProperty("parent")||(attributes.parent=window.location.protocol+"//"+window.location.hostname),attributes.hasOwnProperty("media")||(attributes.media="audio"),attributes.sourcemimetype=this.guess_mimetype(attributes.media,attributes.transcribe,attributes.hints);var iframe=document.createElement("iframe");if(attributes.hasOwnProperty("localloader"))localloading=attributes.hasOwnProperty("localloading")?attributes.localloading:"auto";else var localloading="never";switch(localloading){case"always":var iframeurl=attributes.parent+attributes.localloader+"?cloudpoodllurl="+attributes.cloudpoodllurl+"&";break;case"never":iframeurl=this.baseURL+"?";break;default:if(this.is_ios()||this.is_safari())iframeurl=attributes.parent+attributes.localloader+"?cloudpoodllurl="+attributes.cloudpoodllurl+"&";else iframeurl=this.baseURL+"?"}for(var property in attributes)iframeurl=iframeurl+property+"="+attributes[property]+"&";return iframe.setAttribute("src",iframeurl),attributes.hasOwnProperty("iframeclass")?iframe.setAttribute("class",attributes.iframeclass):(attributes.hasOwnProperty("width")||(attributes.width=350),iframe.setAttribute("width",attributes.width),attributes.hasOwnProperty("height")||("audio"==attributes.media?attributes.height=250:attributes.height=550),iframe.setAttribute("height",attributes.height)),iframe.setAttribute("frameBorder",0),iframe.setAttribute("allow","camera; microphone; display-capture"),iframe},theCallback:function(data){switch(data.type){case"filesubmitted":var inputControl=data.updatecontrol,pokeInput=document.getElementById(inputControl),theurl=data.mediaurl;pokeInput&&(pokeInput.value=theurl);break;case"error":alert("ERROR:".data.message)}},initEvents:function(){var that=this;window.addEventListener("message",(function(e){var data=e.data;data&&data.hasOwnProperty("id")&&data.hasOwnProperty("type")&&that.theCallback(data)}))},sendMessage:function(containerid,messageObject){messageObject.hasOwnProperty("type")&&document.getElementById(containerid).getElementsByTagName("iframe")[0].contentWindow.postMessage(messageObject)},fetchroot:function(){return root},is_safari:function(){return/^((?!chrome|android).)*safari/i.test(navigator.userAgent)},is_ios:function(){return/iPad|iPhone|iPod/.test(navigator.userAgent)&&!window.MSStream},guess_mimetype:function(mediatype,transcribe,hints){if(2==transcribe)return"audio/wav";if(hints&&hints.includes("stereoaudio"))return"audio/wav";navigator.appVersion;var nameOffset,verOffset,nAgt=navigator.userAgent,browserName=navigator.appName,fullVersion=""+parseFloat(navigator.appVersion);null!==nAgt.match("(?:Edge|EdgA|EdgiOS)")?browserName="Edge":-1!=(verOffset=nAgt.indexOf("Opera"))?browserName="Opera":-1!=(verOffset=nAgt.indexOf("MSIE"))?browserName="IE":-1!=(verOffset=nAgt.indexOf("Chrome"))?browserName="Chrome":-1!=(verOffset=nAgt.indexOf("Safari"))?browserName="Safari":-1!=(verOffset=nAgt.indexOf("Firefox"))?browserName="Firefox":(nameOffset=nAgt.lastIndexOf(" ")+1)<(verOffset=nAgt.lastIndexOf("/"))&&(browserName=nAgt.substring(nameOffset,verOffset)).toLowerCase()==browserName.toUpperCase()&&(browserName=navigator.appName);var OS="Unknown OS";-1!=navigator.userAgent.indexOf("Win")&&(OS="Windows"),-1!=navigator.userAgent.indexOf("Mac")&&(OS="Macintosh"),-1!=navigator.userAgent.indexOf("Linux")&&(OS="Linux"),-1!=navigator.userAgent.indexOf("Android")&&(OS="Android"),-1!=navigator.userAgent.indexOf("like Mac")&&(OS="iOS");var browser={};browser.name=browserName,browser.version=fullVersion,browser.OS=OS;var mimetype="unsupported/unsupported";if("video"==mediatype)switch(browser.name){case"Edge":case"MSIE":case"Firefox":case"Chrome":case"Opera":default:mimetype="video/webm";break;case"Safari":mimetype="video/quicktime"}else switch(browser.name){case"MSIE":mimetype="audio/wav";break;case"Safari":mimetype="audio/wav",mimetype="audio/mpa";break;case"Firefox":mimetype="audio/ogg";break;default:mimetype="audio/webm"}return mimetype}}}));

//# sourceMappingURL=cloudpoodll.min.js.map