define("tiny_iorad/ui",["exports","./common","./options","core/templates","tiny_iorad/modal","core/modal_events","core/modal_factory","editor_tiny/utils","core/str"],(function(_exports,_common,_options,_templates,_modal,_modal_events,_modal_factory,_utils,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Tiny iorad UI.
   *
   * @module tiny_iorad/ui
   * @copyright 2023 iorad <info@iorad.com>
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.handleAction=void 0,_modal=_interopRequireDefault(_modal),_modal_events=_interopRequireDefault(_modal_events),_modal_factory=_interopRequireDefault(_modal_factory);_exports.handleAction=async editor=>{await displayDialogue(editor)};const getTemplateContext=(editor,data)=>{var _permissions$embed;const permissions=(0,_options.getPermissions)(editor);return{elementid:editor.id,canEmbed:null!==(_permissions$embed=permissions.embed)&&void 0!==_permissions$embed&&_permissions$embed,showOptions:!1,...data}},isValidUrl=url=>[/^https?:\/\/(www\.|test\.|)iorad\.com\/player\/\d+(\/.*|)$/,/^https?:\/\/dev\.iorad\.dev\/player\/\d+(\/.*|)$/,/^https?:\/\/(www\.|)ior\.ad\/\w+\/?$/].some((re=>re.test(url))),isValidIframe=iframe=>{const element=document.createElement("div");element.innerHTML=iframe;const iframeElement=element.querySelector("iframe");return iframeElement&&isValidUrl(iframeElement.src)},buildIoradPlayer=text=>isValidUrl(text)?'<iframe src="'.concat(text,'" width="100%" height="500px" style="width: 100%; height: 500px;"\n                        referrerpolicy="strict-origin-when-cross-origin" frameborder="0" \n                        webkitallowfullscreen="webkitallowfullscreen" mozallowfullscreen="mozallowfullscreen" \n                        allowfullscreen="allowfullscreen" allow="camera; microphone; clipboard-write"></iframe>'):isValidIframe(text)?text:"",isUrlInput=htmlElement=>{var _htmlElement$construc;return(null==htmlElement||null===(_htmlElement$construc=htmlElement.constructor)||void 0===_htmlElement$construc?void 0:_htmlElement$construc.name)===window.HTMLInputElement.name},isIframeInput=htmlElement=>{var _htmlElement$construc2;return(null==htmlElement||null===(_htmlElement$construc2=htmlElement.constructor)||void 0===_htmlElement$construc2?void 0:_htmlElement$construc2.name)===window.HTMLTextAreaElement.name},clearForm=form=>{form.querySelector(".iorad-link-input").value="",form.querySelector(".iorad-iframe-textarea").value="",form.querySelector(".iorad-error-link").classList.add("iorad-hidden"),form.querySelector(".iorad-error-iframe").classList.add("iorad-hidden"),form.querySelector(".iorad-save-button").classList.remove("iorad-button-black"),form.querySelector(".iorad-save-button").disabled=!0},displayDialogue=async function(editor){let data=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const[switchToStepListText,switchToPlayerLinkText]=await Promise.all([(0,_str.get_string)("swicth_to_iframe",_common.component,void 0,void 0),(0,_str.get_string)("swicth_to_url",_common.component,void 0,void 0)]),bookmark=editor.selection.getBookmark(),selection=editor.selection.getNode(),currentData=selection.closest(".iorad-placeholder");data.ioradEmbedCode=null==currentData?void 0:currentData.innerHTML,data.logo=(await(0,_utils.getButtonImage)("icon-colored",_common.component)).html;const modal=await _modal_factory.default.create({type:_modal.default.TYPE,templateContext:getTemplateContext(editor,data),large:!0});modal.show();const $root=await modal.getRoot();$root.on(_modal_events.default.save,(async(event,modal)=>{event.preventDefault();const form=$root.get(0).querySelector("form"),inputElement=form.querySelector(".iorad-field-group:not(.iorad-hidden)").querySelector(".iorad-link-input, .iorad-iframe-textarea");if(isUrlInput(inputElement)&&!isValidUrl(inputElement.value.trim()))return void form.querySelector(".iorad-error-link").classList.remove("iorad-hidden");if(isIframeInput(inputElement)&&!isValidIframe(inputElement.value.trim()))return void form.querySelector(".iorad-error-iframe").classList.remove("iorad-hidden");const ioradPlayer=buildIoradPlayer(inputElement.value.trim()),content=await(0,_templates.renderForPromise)("".concat(_common.component,"/content"),{ioradPlayer:ioradPlayer});editor.selection.moveToBookmark(bookmark),editor.execCommand("mceInsertContent",!1,content.html),modal.destroy()})),$root.on("click",".iorad-switch-button",(()=>{const form=$root.get(0).querySelector("form");clearForm(form);const ioradLinkElement=form.querySelector(".iorad-link-input"),ioradIframeElement=form.querySelector(".iorad-iframe-textarea"),ioradSwitchButtonElement=form.querySelector(".iorad-switch-button");ioradLinkElement.closest(".iorad-field-group").classList.contains("iorad-hidden")?(ioradLinkElement.closest(".iorad-field-group").classList.remove("iorad-hidden"),ioradIframeElement.closest(".iorad-field-group").classList.add("iorad-hidden"),ioradSwitchButtonElement.textContent=switchToStepListText):(ioradLinkElement.closest(".iorad-field-group").classList.add("iorad-hidden"),ioradIframeElement.closest(".iorad-field-group").classList.remove("iorad-hidden"),ioradSwitchButtonElement.textContent=switchToPlayerLinkText)})),$root.on("change, keyup",".iorad-link-input, .iorad-iframe-textarea",(e=>{const inputElement=e.target,form=$root.get(0).querySelector("form");form.querySelector(".iorad-error-link").classList.add("iorad-hidden"),form.querySelector(".iorad-error-iframe").classList.add("iorad-hidden"),isUrlInput(inputElement)&&isValidUrl(inputElement.value.trim())||isIframeInput(inputElement)&&isValidIframe(inputElement.value.trim())?(form.querySelector(".iorad-save-button").classList.add("iorad-button-black"),form.querySelector(".iorad-save-button").disabled=!1):(form.querySelector(".iorad-save-button").classList.remove("iorad-button-black"),form.querySelector(".iorad-save-button").disabled=!0)}))}}));

//# sourceMappingURL=ui.min.js.map