<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for Single view
 *
 * @package   gradereport_singleview
 * @copyright 2014 Moodle Pty Ltd (http://moodle.com)
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

// General Strings.
$string['all_grades'] = 'All grades';
$string['assessmentname'] = 'Grade item';
$string['blanks'] = 'Empty grades';
$string['bulkappliesto'] = 'For';
$string['bulkinsertvalue'] = 'Insert new grade';
$string['bulklegend'] = 'Bulk insert grades';
$string['bulkchoice'] = 'Bulk insert lets you replace multiple grades at once. Choose the grades you want to replace:';
$string['bulkperform'] = 'Perform bulk insert';
$string['bulkfor'] = 'Grades for {$a}';
$string['entrypage'] = 'Grade user or grade item';
$string['exclude'] = 'Exclude';
$string['excludeall'] = 'Exclude all grades';
$string['excludeallgrades'] = 'Exclude all';
$string['excludefor'] = 'Exclude for {$a}';
$string['excludenone'] = 'Do not exclude any grades';
$string['excludenonegrades'] = 'Exclude none';
$string['eventgradereportviewed'] = 'Grade single view report viewed.';
$string['feedbackfor'] = 'Feedback for {$a}';
$string['gradefor'] = 'Grade for {$a}';
$string['gradeitem'] = 'Grade item: {$a}';
$string['gradeuser'] = 'Grade user: {$a}';
$string['gotonextreport'] = 'Go to next user report';
$string['gotopreviousreport'] = 'Go to previous user report';
$string['noscreens'] = 'Could not find a suitable single view screen.';
$string['gradeitemcannotbeoverridden'] = 'This grade item cannot be overridden.';
$string['itemsperpage'] = 'Items per page';
$string['notvalid'] = 'Not a valid Single view screen: {$a}';
$string['override'] = 'Override';
$string['overrideall'] = 'Override all grades';
$string['overrideallgrades'] = 'Override all';
$string['overridefor'] = 'Override for {$a}';
$string['overridenone'] = 'Do not override any grades';
$string['overridenonegrades'] = 'Override none';
$string['overridenoneconfirm'] = 'This will remove all previously entered overridden grades on this page when you save changes.';
$string['pluginname'] = 'Single view';
$string['privacy:metadata'] = 'The Grade single view report only shows data stored in other locations.';
$string['removeoverride'] = 'Remove grade overrides';
$string['removeoverridesave'] = 'Remove overrides';
$string['savegrades'] = 'Saving grades';
$string['save'] = 'Save';
$string['savegradessuccess'] = 'Grades were set for {$a} items';
$string['singleview:view'] = 'View single view';
$string['singleviewreport_user'] = 'Single view for this user';
$string['singleviewreport_gradeitem'] = 'Single view for this item';
$string['summarygrade'] = 'A table of users, with columns for range, grade, feedback, and whether to override or exclude a particular grade.';
$string['summaryuser'] = 'A table of grade items, with columns for grade category, range, grade, feedback, and whether to override or exclude a particular grade.';
$string['unsavedataalert'] = 'If you have unsaved changes on the page, you will lose them if you proceed with bulk insert grades.';
$string['unsavedataconfirm'] = 'I understand that my unsaved changes will be lost.';
$string['userselect'] = 'Select activity';

$string['ariareporttype'] = 'Select a report type to view';
$string['viewby'] = 'View by';
$string['viewsingleuser'] = 'Search for a user to view all their grades';
$string['viewsinglegradeitem'] = 'Select a grade item above';
$string['selectagrade'] = 'Select a grade item';
$string['selectgradeitemlink'] = 'Select a grade item';
$string['singleviewdescription'] = 'In single view you can override or exclude selected grades and bulk insert grades.';
$string['unsaveddatawarning'] = 'Unsaved data warning';

// Deprecated since Moodle 4.1.
$string['filtergrades'] = 'Show grades for {$a}.';

// Deprecated since Moodle 4.3.
$string['viewsingleuserorgradeitem'] = 'View all the grades of a single user or grade item.';
