<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Popup activities course format
 *
 * @package     format_popups
 * @copyright   2021 Daniel Thies <dethies@gmail.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require($CFG->dirroot . '/course/format/topics/format.php');

// The lines below include all the javascript added for this format. The code
// can be added to other formats by copying these lines to that format's
// format.php file and adding a dependency in version.php.
if (get_config('format_popups', 'enabledeftresponse')) {
    $socket = new \format_popups\socket($context);
    $token = $socket->get_token();
    $PAGE->requires->js_call_amd('format_popups/deft', 'init', [
        $context->id, $course->id, $displaysection, $token, get_config('block_deft', 'throttle'),
    ]);
} else {
    $PAGE->requires->js_call_amd('format_popups/popups', 'init', [
        $context->id, $course->id, $displaysection,
    ]);
}
