<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component Designer course format.
 *
 * @package   format_designer
 * @copyright 2021 bdecent gmbh <https://bdecent.de>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['addsections'] = 'Add designer sections';
$string['currentsection'] = 'This designer section';
$string['dateformat'] = 'Date format';
$string['dateformat_help'] = 'Date format for completion info (e.g. Complete by x date)';
$string['deletesection'] = 'Delete designer section';
$string['designer:changesectionoptions'] = 'Change section options, such as type.';
$string['editsection'] = 'Edit designer section';
$string['editsectionname'] = 'Edit designer section name';
$string['hidefromothers'] = 'Hide designer section';
$string['newsectionname'] = 'New name for designer section {$a}';
$string['page-course-view-designer'] = 'Any course main page in Designer format';
$string['page-course-view-designer-x'] = 'Any course page in Designer format';
$string['pluginname'] = 'Designer format';
$string['privacy:metadata'] = 'The Designer format plugin does not store any personal data.';
$string['sectionname'] = 'Designer section';
$string['section0name'] = 'General';
$string['sectiontype'] = 'Section type';
$string['showfromothers'] = 'Show designer section';
$string['completiontrackingmanual'] = 'Manual completion';
$string['completiontrackingautomatic'] = 'Automatic completion';
$string['completeby'] = 'Complete by';
$string['usstandarddate'] = '%m-%d-%Y %I:%M %p';
$string['monthandday'] = '%b %e';
$string['timeagoyear'] = 'year';
$string['timeagomonth'] = 'month';
$string['timeagoweek'] = 'week';
$string['timeagoday'] = 'day';
$string['timeagohour'] = 'hour';
$string['timeagominute'] = 'minute';
$string['timeagosecond'] = 'second';
$string['timeago'] = 'ago';
$string['timeagojustnow'] = 'just now';
$string['overdue'] = 'Overdue';
$string['duetoday'] = 'Due today';
$string['completed'] = 'Completed on';
$string['passed'] = 'Passed on';
$string['failed'] = 'Failed on';
$string['start'] = 'Start';
$string['calltoactionview'] = 'Review {$a} <i class="fa fa-angle-double-right"></i>';
$string['calltoactioncontinue'] = 'Review {$a} <i class="fa fa-angle-double-right"></i>';
$string['calltoactionstart'] = 'Open {$a} <i class="fa fa-angle-double-right"></i>';
$string['calltoactionrestricted'] = '<i class="fa fa-lock"></i>';

$string['completion-alt-auto-enabled'] = 'The system marks this item complete according to conditions';
$string['completion-alt-auto-fail'] = 'Completed (did not achieve pass grade)';
$string['completion-alt-auto-n'] = 'Not completed';
$string['completion-alt-auto-n-override'] = 'Not completed (set by {$a->overrideuser})';
$string['completion-alt-auto-pass'] = 'Completed (achieved pass grade)';
$string['completion-alt-auto-y'] = 'Completed';
$string['completion-alt-auto-y-override'] = 'Completed (set by {$a->overrideuser})';
$string['completion-alt-manual-enabled'] = 'Students can manually mark this item complete';
$string['completion-alt-manual-n'] = 'Not completed. Select to mark as complete.';
$string['completion-alt-manual-n-override'] = 'Not completed (set by {$a->overrideuser}). Select to mark as complete.';
$string['completion-alt-manual-y'] = 'Completed. Select to mark as not complete.';
$string['completion-alt-manual-y-override'] = 'Completed (set by {$a->overrideuser}). Select to mark as not complete.';
$string['completion-fail'] = 'Completed (did not achieve pass grade)';
$string['completion-n'] = 'Not completed';
$string['completion-n-override'] = 'Not completed (set by {$a->overrideuser})';
$string['completion-pass'] = 'Completed (achieved pass grade)';
$string['completion-y'] = 'Completed';
$string['completion-y-override'] = 'Completed (set by {$a->overrideuser})';

$string['completion-shorthand-alt-auto-enabled'] = 'The system marks this item complete according to conditions';
$string['completion-shorthand-alt-auto-fail'] = 'Failed <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-alt-auto-n'] = 'Not completed';
$string['completion-shorthand-alt-auto-n-override'] = 'Not completed <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-alt-auto-pass'] = 'Completed (achieved pass grade)';
$string['completion-shorthand-alt-auto-y'] = 'Completed';
$string['completion-shorthand-alt-auto-y-override'] = 'Completed <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-alt-manual-enabled'] = 'Students can manually mark this item complete';
$string['completion-shorthand-alt-manual-n'] = 'Not completed';
$string['completion-shorthand-alt-manual-n-override'] = 'Not completed';
$string['completion-shorthand-alt-manual-y'] = 'Completed';
$string['completion-shorthand-alt-manual-y-override'] = 'Completed <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-fail'] = 'Completed <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-n'] = 'Not completed';
$string['completion-shorthand-n-override'] = 'Not completed <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-pass'] = 'Completed (achieved pass grade)';
$string['completion-shorthand-y'] = 'Completed';
$string['completion-shorthand-y-override'] = 'Completed <i class="fa fa-exclamation-triangle text-white"></i>';
$string['modvisit'] = 'Visited {$a} times';
$string['link'] = "Text links (Default)";
$string['list'] = "List";
$string['cards'] = "Cards";
$string['notyetcompleted'] = "Not yet completed";
$string['less'] = "Less";
$string['sectioncompleted'] = "Section completed";
$string['circles'] = "Circles";
$string['categoriseheader'] = "Section type";
$string['title'] = "Title";
$string['backgroundcolor'] = "Background color";
$string['backgroundgradient'] = "Background gradient";
$string['textcolor'] = "Text color";

$string['sectiondesignheader'] = 'Design';
$string['sectionbackdesignheader'] = 'Design';
$string['applyto'] = "Apply the background to";
$string['wholesection'] = "Whole section";
$string['sectionheader']  = "Section header";
$string['sectionbackgroundtype_help'] = "<b> Section header selected </b>, The background and the text color shall be applied only to the header content.
<b> Whole section selected </b>, The background shall be applied to the whole section ";
$string['sectionbackgroundtype'] = "<b> Section header selected </b>, The background and the text color shall be applied only to the header content.
<b> Whole section selected </b>, The background shall be applied to the whole section ";
$string['backgroundimage'] = "Background image";
$string['completionbackgroundimage'] = 'Background image (completed)';
$string['textcolor'] = "Text color";
$string['sectiondesignertextcolor_help'] = "Text color shall be only applied to the section title and section summary";
$string['hidesectiontitle'] = "Hide section title";
$string['sectiondesignertextcolor'] = "Text color shall be only applied to the section title and section summary";
$string['sectionlayouts'] = "Layouts";
$string['sectioncontainer'] = "Section container";
$string['full'] = 'Full';
$string['normal'] = 'Normal';
$string['boxed'] = 'Boxed';
$string['sectioncontent'] = 'Section content';
$string['sectioncontainerwidth'] = 'Section container width';
$string['sectioncontentwidth'] = 'Section content width';
$string['activitydesign'] = "Design";
$string['notvisit'] = "Not visited yet";

$string['onecolumn'] = 'Single column';
$string['twocolumn'] = 'Two column';
$string['threecolumn'] = 'Three column';
$string['fourcolumn'] = 'Four column';
$string['fivecolumn'] = 'Five column';
$string['desktopcolumn'] = 'Layout columns - Desktop';
$string['tabletcolumn'] = 'Layout columns - Tablet';
$string['mobilecolumn'] = 'Layout columns - Mobile';
$string['backgroundgradient_help'] = "Generate a gradient: <a href=' https://cssgradient.io/'>https://cssgradient.io/</a>. Paste the background property (linear-gradient).";
$string['markasdone'] = "Mark as done";
$string['done'] = "Done";
$string['gotosection'] = 'Go to section';

$string['completion_manual:markdone'] = 'Mark as done';
$string['completion_manual:markdone:duetoday'] = 'Mark as done today';
$string['completion_manual:markdone:overdue'] = 'Mark as done overdue';
$string['completion_manual:markdone:completeby'] = 'Mark as done by';
$string['completion_manual:done'] = 'Done on';
$string['completion_manual:aria:done'] = '{$a} is marked as done. Press to undo.';
$string['completion_manual:aria:markdone'] = 'Mark {$a} as done';
$string['collapsiblesections'] = 'Collapsible sections';
$string['accordion'] = 'Accordion';
$string['initialstate'] = 'Initial State';
$string['expand'] = 'Expanded';
$string['collapse'] = 'Collapsed';
$string['firstexpand'] = 'First expanded';

$string['completionicons'] = 'Completion tick boxes';
$string['completionicons_help'] = 'Completion info based on designer format';
$string['activitymasking'] = 'Activity masking';
$string['sectionmasking'] = 'Section masking';
$string['maskimage'] = 'Mask image';
$string['maskimg_desc'] = 'Upload multiple mask images. These images are refleacted in the form, You can select any of mask image.';
$string['masksize'] = 'Mask size';
$string['masksize_desc'] = 'Enter one of the CSS background size properties to fix the size of mask image.';
$string['maskposition'] = 'Mask position';
$string['maskposition_desc'] = 'Enter one of the CSS background position property values to display the mask image where you want to display';
$string['minheight'] = 'Minimum height';
$string['minheight_help'] = 'Activity blocks will be displayed in the given height. Use values like 200px, auto, 4rem ...';
$string['backgroundposition'] = 'Background Position';
$string['backgroundsize'] = 'Background Size';
$string['backgroundrepeat'] = 'Background Repeat';
$string['backgroundposition_help'] = 'Background image will focused on the given position';
$string['backgroundsize_help'] = 'Background image will displayed in the size';
$string['backgroundrepeat_help'] = 'Background image will displayed repeated if not fit with section block';

$string['enrolmentstartdate'] = 'Enrolment start date';
$string['enrolmentstartdate_help'] = 'User current course enrolment start date will be displayed in top of the course.';
$string['enrolmentenddate'] = 'Enrolment end date';
$string['enrolmentenddate_help'] = 'User course enrolment end date will be displayed in top of the coures.';
$string['coursecompletiondate'] = 'Course completion date';
$string['coursecompletiondate_help'] = 'Student date of course completion displayed in time section.';
$string['courseduedate'] = 'Course due date';
$string['courseduedate_help'] = 'Course due date will shown in course timesection,
it only works when Learning tools and time management tool will be installed and enabled';
$string['activityprogress'] = 'Progress bar';
$string['activityprogress_help'] = 'The progress bar displays how many activities and prerequisites the student has already completed visually. A tooltip is provided to list the activities and prerequisites that are still "to do" and those that are already "completed"';

$string['activity:icon'] = 'Activity icon';
$string['activity:visits'] = 'Activity visits';
$string['activity:calltoaction'] = 'Activity call to action';
$string['activity:title'] = 'Activity title';
$string['activity:description'] = 'Activity description';
$string['activity:modname'] = 'Activity mod name';
$string['activity:completionbadge'] = 'Activity completion badge';
$string['hideonhover'] = 'Hide on hover';
$string['showonhover'] = 'Show on hover';
$string['mobilewidth'] = 'Section width in phone size';
$string['mobilewidth_help'] = 'Section will be displayed in the selected width in phone size,
Only works for the one section per page.';
$string['desktopwidth'] = 'Section width in desktop size';
$string['desktopwidth_help'] = 'Section will be displayed in the selected width in desktop size,
Only works for the one section per page.';
$string['tabletwidth'] = 'Section width in tablet size';
$string['tabletwidth_help'] = 'Section will be displayed in the selected width in tablet size,
Only works for the one section per page.';
$string['coursetype'] = 'Course type';
$string['coursetype_help'] = 'Kanban board sets as course type, course sections will displayed horizontally.
Collapsible sections are not working in kanban mode.';
$string['kanbanboard'] = 'Kanban Board';
$string['usecompletionbg'] = 'Use different background for completion';
$string['activityelementsdisplay'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2" > Activity Elements Visibility Styles </h5>';
$string['backgroundsection'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2"  > Module Background Styles </h5>';
$string['backgroundmasksection'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2" > Module Background MASK Styles </h5>';
$string['generalsectionconfig'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2" > Module General Styles </h5>';

$string['sectionbackgroundheader'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2" > Section background styles </h5>';
$string['masksize_help'] = 'Enter any of background size property to display the mask in that size.';
$string['maskposition_help'] = 'Use any of background position property to display the mask in that position';
$string['maskimage_help'] = 'Selected mask image will displayed in section block.';
$string['timemanagementmissing'] = 'Learning Tools Pro required for this feature. <a href="https://bdecent.de/product/learning-tools-pro/">Learn more</a>.';
$string['completiontrackingmissing'] = 'Turn on completion tracking to display completion date.';
$string['coursestartdate'] = 'Course start date';
$string['courseduedate'] = 'Course due date';
$string['coursecompletiondate'] = 'Course completion date';
$string['courseexpirationdate'] = 'Course expiration date';
$string['criteriacompleted'] = '{$a->completed} of {$a->count} criteria completed';
$string['todaydue'] = '{$a->due} due today';
$string['overdues'] = '{$a->overdues} overdues';

$string['sectionmaskimage'] = 'Section mask image';
$string['sectionmasksize'] = 'Section mask size';
$string['sectionmaskposition'] = 'Section mask position';
$string['popupactivities'] = 'Display activities in popups';
$string['popupactivities_help'] = 'Display the resources in popup, if enabled some type of resources will display in the popup.';
$string['displayprogress'] = 'Display Progress';
$string['useactivityimage'] = 'Use activity image';
$string['small'] = 'Small';
$string['medium'] = 'Medium';
$string['large'] = 'Large';
$string['circlesize'] = 'Circle size';
$string['type_flow'] = 'Flow';
$string['courseindex'] = 'Course index visibility';
$string['courseindex_help'] = 'Manage the visibility of the course index menu';
$string['hideeverywhere'] = 'Hide everywhere';
$string['hideoncourses'] = 'Hide on course pages';
$string['configtitle'] = 'Designer default options';
$string['generalsettings'] = 'General designer settings';

$string['coursesettings'] = 'Course';
$string['sectionsettings'] = 'Section';
$string['stractivity'] = 'Activity';
$string['courseheader'] = 'Course header';
$string['popupactivitiesnotinstalled'] = 'Popup format must be installed in order to display the activities in popup.';
$string['listwidth'] = 'List width';

$string['general'] = 'General';
$string['flowanimationduration'] = 'Flow animation duration';
$string['flowanimationduration_help'] = 'Change the animation duration for the flow animation';
$string['showanimation'] = 'Flow animation';
$string['showanimation_help'] = 'Enable to reveal the modules with animation effect.';
$string['verticalcircles'] = 'Vertical circles';
$string['horizontal_circles'] = 'Horizontal Circles';
$string['modmaskimage'] = 'Activity mask image';
$string['modmasksize'] = 'Activity mask size';
$string['modmaskposition'] = 'Activity mask position';

$string['heroactivity'] = "Hero activitiy";
$string['everywhere'] = "Everywhere";
$string['onlycoursepage'] = "Only on course main page";
$string['showastab'] = "Show as tab";
$string['disabled'] = "Disabled";
$string['sectionzeroactivities'] = "Section 0 activities";
$string['makeherohide'] = "Make hero activity and hide section 0";
$string['makeherovisible'] = "Make hero activity and keep section 0 visible";
$string['strprerequisites'] = "Prerequisites";
$string['courseprerequisites'] = "Course prerequisites";
$string['displaycourseprerequisites'] = "Display course prerequisites";
$string['displaycourseprerequisites_help'] = "Define where to display the prerequisites courses";
$string['abovecoursecontents'] = "Above course contents";
$string['onseparatetab'] = "On separate tab";
$string['prerequisitesautostudents'] = "Automatically enrol students";
$string['prerequisitesautostudents_help'] = "Enrol students automatically for prerequisites courses";
$string['autoenrolalready'] = "Only if not already enrolled";
$string['autoenrolalways'] = "Always";
$string['prerequisitesunenrolstudents'] = "Unenrol students from prerequisites";
$string['prerequisitesunenrolstudents_help'] = "Unenrol students automatically for prerequisites courses";
$string['prerequisitesgroupstudents'] = "Group students in prerequisites";
$string['prerequisitesgroupstudents_help'] = "create group to students for prerequisites courses";
$string['prerequisitesnewtab'] = "Open prerequisites in new tab";
$string['prerequisitesnewtab_help'] = "Open the prerequisites courses menu in new tab";
$string['prerequisitesbackmain'] = "Back to main course";
$string['prerequisitesbackmain_help'] = "Return the to the main course of prerequisites course";
$string['never'] = "Never";

$string['strprerequisites_role'] = "Role for automatically enrolled students";
$string['backtomaincourse'] = "Back to main course";
$string['disabled'] = "Disabled";
$string['prerequisitesdesc'] = "Please complete all of the following courses:";
$string['courseprerequisitestitle'] = "Prerequisites title";
$string['courseprerequisitestitle_help'] = "Prerequisites course title";
$string['strprerequisiteinfo'] = "Prerequisite info";
$string['strprerequisiteinfo_help'] = "Display the text above the prerequisites.";
$string['displayheaderroleusers'] = "Choose the staff role";
$string['displayheaderroleusers_help'] = "";
$string['addtocontacts'] = "Add to contacts";
$string['message'] = "Message";
$string['mail'] = "Mail";
$string['createprereqgroup'] = "Create prerequisites group";
$string['assignprecourses'] = "Assign prerequisites courses";
$string['allcourses'] = "All courses";
$string['pregroups'] = "Prerequisite groups";
$string['listprereqgroup'] = "Prerequisite groups";
$string['groupnotfound'] = "Group not found";
$string['deletegroup'] = "Delete group";
$string['deletecheckgroup'] = 'Are you absolutely sure you want to completely delete the group {$a}, including their group and other group data?';
$string['deletednotgroup'] = 'Could not delete group {$a} !';
$string['deletesuccess'] = "Deleted successfully";
$string['more'] = "More";
$string['nogroupsfound'] = "No groups found";
$string['addnewgroup'] = "Add new group";
$string['nocourses'] = "No courses";
$string['move_item'] = 'Move this course';
$string['profilefieditem'] = '';
$string['profilefieditem_help'] = "Display the user profile field in the course staff block.";
$string['strcompleted'] = "Completed";

$string['sectionzeroactivities_help'] = "";
$string['heroactivitypos'] = "";
$string['stravoidduplicateentry'] = "Avoid duplicate entry";
$string['stractivitytype'] = 'Activity type';
$string['stractivitytitle'] = "Activity title";
$string['strcustom'] = "Custom";
$string['secondarymeu_title'] = "Secondary menu title";
$string['secondarymenu'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2" > Secondary menu </h5>';
$string['strcustomtitle'] = "Custom title";
$string['customnameincourseindex'] = "Use custom name in course index";
$string['customnameinactivityitem'] = "Use custom name on course/section pages";
$string['strsecondarymenutocourse'] = "Add course to secondary menu item on all course pages";
$string['strsecondarymenutocourse_help'] = "If checked, a link to the course is added on all pages in the course to the secondary navigation";
$string['heroactivity_help'] = 'Designer gives teachers the option to make specific activities a "Hero activity". Hero activities are added to
    the secondary navigation in order to make them easily accessible for students.';
$string['sectionzeroactivities_help'] = "This setting determines wether activities in the general section should automatically become hero activities.
    Designer can automatically hide the general section when editing is turned off. This is useful if you want students to access the activities in the general section only from the secondary navigation. This setting works as a default and can be overridden in the activity settings.";
$string['showastab_help'] = "Use this setting to configure on which pages the menu items for the hero activities should be added to the secondary navigation menu. You can either have them displayed throughout the course or on the course main page.
    This setting works as a default and can be overridden in the activity settings.";
$string['heroactivitypos_help'] = "This setting gives you control over the order of the menu items in the secondary navigation menu. Menu items with negative values are added before the course menu item, menu items with positive values are added afterwards. Usually, it makes more sense to use positive numbers.
    This setting works as a default and can be overridden in the activity settings.";
$string['struppercompleted'] = "COMPLETED";
$string['strtodo'] = "TODO";

$string['criteriaprogressinfo_help'] = 'Tip: Click on the progress bar above to see which activities/prerequisites you have already completed and which are not completed yet.';
$string['criteriaprogressinfo'] = 'Criteria progress bar info';
