define("mod_wordcards/cards",["jquery","core/ajax"],(function($,Ajax){var Cards=function(selector,terms){this._container=$(selector),this._terms=terms,this._selected=null};return Cards.prototype._container=null,Cards.prototype._dryRun=!1,Cards.prototype._resizeTimeout=null,Cards.prototype._selected=null,Cards.prototype._terms=null,Cards.prototype.init=function(){var pool=[];this._terms.forEach(function(item){pool.push(this._makeCard(item.id,item.term)),pool.push(this._makeCard(item.id,item.definition))}.bind(this)),function(array){for(var i=array.length-1;i>0;i--){var j=Math.floor(Math.random()*(i+1)),temp=array[i];array[i]=array[j],array[j]=temp}}(pool),pool.forEach(function(item){this._container.append(item)}.bind(this)),this._arrangePlayground(),pool.forEach((function(item){item.show()})),this._container.on("click",".wordcard",this._handlePick.bind(this)),$(window).on("resize",function(){this._resizeTimeout&&clearTimeout(this._resizeTimeout),this._resizeTimeout=setTimeout(this._arrangePlayground.bind(this),200)}.bind(this))},Cards.prototype._arrangePlayground=function(){var cardWidth,cardHeight,lineHeight,lineHeightValue,suggestedHeight,width=this._container.width(),height=$(window).height(),perRow=3,cardCount=2*this._terms.length,row=0,col=0;cardCount%2<cardCount%3&&(perRow=2),lineHeight=this._container.find(".wordcard").first().css("lineHeight"),lineHeightValue=parseInt(lineHeight.replace(/([^0-9]+)/,"")),suggestedHeight=60,"px"===lineHeight.replace(/([0-9]+)/,"")&&(suggestedHeight=lineHeightValue?3*(lineHeightValue+1):suggestedHeight),suggestedHeight=999,cardWidth=Math.floor(width/perRow),cardHeight=Math.min(Math.round((height-60)/Math.ceil(cardCount/perRow)),suggestedHeight),this._container.find(".wordcard").each((function(index,item){$(item).css({top:row*cardHeight,left:col*cardWidth,width:col==perRow-1?cardWidth:cardWidth-4,height:cardHeight-4}),++col>=perRow&&(col=0,row++)})),this._container.find(".wordcard-content").css("maxHeight",cardHeight-4),this._container.css({height:row*cardHeight}),this._adjustCardContent()},Cards.prototype._adjustCardContent=function(){this._container.find(".wordcard-content").each((function(index,el){var over,txt,node=$(el),loops=0;for(node.text(node.data("text"));el.scrollHeight>el.offsetHeight&&el.scrollHeight>0&&(txt=node.text(),over=Math.max(.1,el.offsetHeight/el.scrollHeight-.05),txt=txt.substr(0,Math.round(txt.length*over)).trim(),txt+="…",node.text(txt),!(loops++>4)););}))},Cards.prototype._checkComplete=function(){this._container.find(".wordcard.found").length==2*this._terms.length&&this._trigger("complete")},Cards.prototype._handlePick=function(e){e.preventDefault();var card=$(e.currentTarget);if(!card.hasClass("found")){if(!this._selected)return this._selected=card,void card.addClass("selected");if(!this._selected.is(card)){if(card.data("id")==this._selected.data("id"))this._selected.addClass("found").animate({opacity:0}),card.addClass("found").animate({opacity:0}),this._reportSuccess(this._selected.data("id")),this._checkComplete();else{var original=this._selected;original.addClass("mismatch"),card.addClass("mismatch"),this._reportFailure(this._selected.data("id"),card.data("id")),setTimeout((function(){original.removeClass("mismatch"),card.removeClass("mismatch")}),600)}this._selected.removeClass("selected"),this._selected=null}}},Cards.prototype._makeCard=function(id,text){var container=$('<div class="wordcard">'),wrapper=$('<div class="wordcard-wrapper">'),content=$('<div class="wordcard-content">');return content.text(text),content.data("text",text),wrapper.append(content),container.append(wrapper),container.data("id",id),container},Cards.prototype.on=function(action,cb){this._container.on(action,cb)},Cards.prototype._reportFailure=function(term1id,term2id){this._dryRun||Ajax.call([{methodname:"mod_wordcards_report_failed_association",args:{term1id:term1id,term2id:term2id}}])},Cards.prototype._reportSuccess=function(termid){this._dryRun||Ajax.call([{methodname:"mod_wordcards_report_successful_association",args:{termid:termid}}])},Cards.prototype.setDryRun=function(value){this._dryRun=value},Cards.prototype._trigger=function(action){this._container.trigger(action)},Cards}));

//# sourceMappingURL=cards.min.js.map