<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * English strings for simplelesson
 *
 * @package    mod_simplelesson
 * @copyright  2018 Richard Jones <richardnz@outlook.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @see https://github.com/moodlehq/moodle-mod_newmodule
 *
 */
defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Action';
$string['actions'] = 'Page Actions';
$string['adaptive'] = 'Adaptive feedback';
$string['adaptivenopenalty'] = 'Adaptive (no penalty)';
$string['add'] = 'add';
$string['add_page'] = 'Add page';
$string['add_question'] = 'Add question';
$string['add_question_help'] = 'Select one question to add to the page, the question type is shown in brackets.  Use the Preview question link to view and test the question as it will appear on the page.  Set a score as required. Questions which have already been added to the Simplelesson are disabled.';
$string['allocate_mark'] = 'Allocate a mark for the essay:';
$string['allowincomplete'] = 'Allow incomplete question attempts';
$string['allowincomplete_help'] = 'Uncheck to force students to respond to a question before navigation links are shown.';
$string['allowreview'] = 'Allow student to review attempts immediately after the current attempt';
$string['allowreview_help'] = 'At the end of the attempt, students can review their responses and their scores by default.  Uncheck this box to disallow student review.';
$string['allowreports'] = 'Allow students to review previous answers.';
$string['allowreports_help'] = 'Students cannot review previous attempts by default.  Check this box to allow the Review button to appear.';
$string['allversions'] = 'Show all question versions';
$string['allversions_help'] = 'Questions with multiple versions and having a ready status can have all versions displayed when adding a question.';
$string['answer_report'] = 'User responses';
$string['answerquestions'] = 'Please answer all the questions';
$string['attempt'] = "Attempt lesson";
$string['attempt_deleted'] = 'Attempt deleted';
$string['attempt_not_deleted'] = 'Attempt to delete record failed';
$string['attempt_report'] = 'User attempts';
$string['attemptid'] = "Attempt";
$string['attemptstarted'] = 'Simple lesson attempt started';
$string['autosequencelink'] = 'Auto-sequence pages';
$string['bad_question'] = 'Duplicate or no question selected';
$string['basic_report'] = 'Basic report';
$string['behaviour'] = 'Question behaviour';
$string['behaviour_help'] = 'With Adaptive feedback the user has multiple tries at each question - a penalty can be applied unless adaptive no penalty is used.  This can only be set on a lesson basis, not per question. Immediate feedback has one attempt available. For Deferred feedback the answer must be explicitly saved but multiple saves are permitted, the student only sees the score when reviewing the lesson. CBM means "certainty-based marking" the student must also say how certain they are that their answer is correct and thereby gain extra marks (or extra penalties).  This can lead to strange scores.';
$string['cancelled'] = 'Action cancelled';
$string['category_select'] = 'Select category';
$string['categoryid'] = 'Category';
$string['categoryid_help'] = 'Choose a category for the questions that can be added to this simplelesson.  You can use the Find in bank link to manipulate the question bank for this course/activity.';
$string['clean_up_usages'] = 'Clean old question usages for Simple lesson';
$string['completequestion'] = 'Please attempt this question to continue';
$string['confirm'] = 'Confirm';
$string['confirm_delete'] = 'You are about to delete a page from this lesson, this action cannot be undone.';
$string['date'] = 'Attempt date';
$string['deferredcbm'] = 'Deferred feedback with cbm';
$string['deferredfeedback'] = 'Deferred feedback';
$string['delete'] = 'delete ';
$string['delete_page'] = 'Delete page: {$a}';
$string['delete_page_button'] = 'Delete page';
$string['delete_question'] = 'Delete question';
$string['deleteallattempts'] = 'Delete all attempts.';
$string['deleteallsubmissions'] = 'Delete all submissions';
$string['edit_lesson'] = 'Edit lesson';
$string['edit_page'] = 'Edit page';
$string['edit_page_form'] = 'Edit the page contents';
$string['editing'] = 'Manage lesson:';
$string['enablereports'] = 'Show reports tab';
$string['enablereports_desc'] = 'Check to allow teachers to see reports';
$string['end_lesson'] = "Exit lesson";
$string['essay'] = 'Essay';
$string['essay_grading'] = 'Grade an essay';
$string['essay_grading_page'] = 'Use this page to manually grade an essay submission.';
$string['essaydate'] = 'Date submitted: {$a}';
$string['exportpagelink'] = 'Export pages';
$string['finishreview'] = 'Finish review';
$string['firstname'] = "First name";
$string['firstpagelink'] = 'First page';
$string['gotoaddpage'] = 'Add page';
$string['gotodeletepage'] = 'Delete page';
$string['gotoeditpage'] = 'Edit page';
$string['gotosummary'] = "Summary page";
$string['grade_saved'] = 'Grade saved';
$string['gradeaverage'] = 'Average of attempts';
$string['graded'] = 'Graded';
$string['gradehighest'] = 'Highest attempt';
$string['gradelast'] = 'Last attempt';
$string['gradelink'] = 'Grade essay';
$string['gradelinkheader'] = 'Action';
$string['gradelowest'] = 'Lowest attempt';
$string['grademethod'] = 'Attempts grading';
$string['grademethod_help'] = 'If multiple attempts are made, this setting determines how the grade for the gradebook will be calculated.';
$string['graderinfo'] = 'Grader Information (if any)';
$string['hasquestion'] = 'Question';
$string['home'] = 'Home';
$string['id'] = 'id';
$string['immediatecbm'] = 'Immediate feedback with CBM';
$string['immediatefeedback'] = 'Immediate feedback';
$string['importpagelink'] = 'Import pages';
$string['lackpages'] = 'Need at least 2 pages to manage';
$string['lastname'] = "Last name";
$string['lessonname'] = 'Lesson';
$string['manage_attempts'] = 'Manage attempts';
$string['manage_pages'] = 'Manage pages';
$string['manage_pages_here'] = 'Manage this page';
$string['manage_questions'] = 'Manage questions';
$string['managelesson'] = 'Manage Lesson: ';
$string['manual_grade'] = 'Manual grading';
$string['mark'] = "Mark";
$string['max_attempts_exceeded'] = "No more attempts allowed";
$string['maxattempts'] = "Max attempts";
$string['maxmark'] = 'Marks available: {$a}';
$string['maxscore'] = 'Out of';
$string['moduleid'] = 'id';
$string['modulename'] = 'Simple lesson';
$string['modulename_help'] = 'Use the Simple lesson module for a simple sequential display of multiple pages of content with an optional index. Simple lesson allows the use of questions from the question bank such as true/false, multiple choice, match, gapselect, drag and drop and short answer.  Essay questions are allowed and need to be manually marked.  Question behaviours implemented are adaptive (with and without penalty, immediate and deferred feedback (with and without CBM). User attempt data, including detailed question responses are recorded and can be exported.  Grading strategies used for multiple attempts are Highest, Average and Last attempt(s). Simple lesson implements privacy and backup features';
$string['modulenameplural'] = 'Simple lessons';
$string['move_down'] = 'Move down';
$string['move_up'] = 'Move up';
$string['navigation'] = 'Navigation:';
$string['next'] = 'Next';
$string['nextid'] = 'Next id';
$string['nextpage'] = 'Next page';
$string['no_manual_grades'] = 'Nothing to grade';
$string['no_pages'] = 'There are no pages in this Simple lesson';
$string['no_question'] = 'No question found';
$string['no_questions'] = 'There are no questions to attempt (use preview)';
$string['none'] = 'none';
$string['noquestions'] = 'There are no questions, select a category from Manage questions on the Edit Simple lesson screen.';
$string['noreview'] = 'You are not allowed to review your previous answers.';
$string['num_pages'] = 'Number of pages: {$a}';
$string['numattempts'] = 'Attempts made: {$a} of';
$string['outof'] = "Out of";
$string['outofsequence'] = 'Something went wrong with the question engine, please try again';
$string['page_adding'] = 'Add a new page';
$string['page_created'] = 'New page created';
$string['page_deleted'] = 'Page deleted';
$string['page_editing'] = 'Use this page to organize your Simple lesson pages (if any). You can add, edit, view, delete and move pages from here (use the icons under Actions).  Autosequencing will put the next and previous page into the order you see below. Click the Question number to preview the question (or add to add one). Remove to remove a question. Use the Manage Questions button to select the behaviour and category of questions that can be added to pages.  Add a question bank category if neccessary.';
$string['page_index_header'] = 'Index';
$string['page_saved'] = 'Page saved';
$string['page_updated'] = 'Page updated';
$string['pagecontents'] = 'Page content';
$string['pagetitle'] = 'Title';
$string['pageviewed'] = 'Simple lesson page viewed';
$string['pluginadministration'] = 'Simple lesson administration';
$string['pluginname'] = 'Simple lesson';
$string['preview'] = 'Preview';
$string['prev'] = 'Previous';
$string['preview_completed'] = 'preview completed';
$string['preview_question'] = 'Preview question';
$string['previd'] = 'Previous id';
$string['prevpage'] = 'Previous page';
$string['privacy:metadata:simplelesson_answers:mark'] = 'The score of the user answering the question.';
$string['privacy:metadata:simplelesson_answers:youranswer'] = 'The response of the user to the question.';
$string['privacy:metadata:simplelesson_answers'] = 'Information about users Simple lesson attempts at individual questions including their response and a score.';
$string['privacy:metadata:simplelesson_attempts:sessionscore'] = 'The score achieved on the attempt.';
$string['privacy:metadata:simplelesson_attempts:status'] = 'The completion status of the attempt.';
$string['privacy:metadata:simplelesson_attempts:timetaken'] = 'The time taken to complete the attempt (seconds).';
$string['privacy:metadata:simplelesson_attempts:userid'] = 'The id of the user taking the attempt.';
$string['privacy:metadata:simplelesson_attempts'] = 'Information about users Simple lesson attempts including completion status, the number of correct responses (a score) and the time taken (seconds) for the attempt.';
$string['qlink'] = 'Find';
$string['qlinkheader'] = 'Find in bank';
$string['qnumber'] = 'Question number';
$string['question'] = "Question";
$string['question_added'] = 'Added question';
$string['question_adding'] = 'Select a category and a behaviour for questions.  You can use questions from more than one category by returning here and selecting another.  Selected behaviour applies to all questions in the Simple lesson.';
$string['question_deleted'] = 'Deleted question';
$string['question_editing'] = 'Editing questions';
$string['question_name'] = 'Question name';
$string['question_placeholder'] = '[[There is a question on this page]]';
$string['question_text'] = 'Question text';
$string['question_version'] = 'Question version';
$string['questions_added'] = 'Added questions';
$string['questionscore'] = 'Score';
$string['questionscore_help'] = 'Optionally input a score for this question (default 1)';
$string['questionsummary'] = 'Question';
$string['remove'] = 'Remove';
$string['reportsheader'] = 'Select required report, click the reports tab to return to the menu.';
$string['reportspage'] = 'Available reports';
$string['reportstab'] = 'reports';
$string['requires_grading'] = 'Requires grading';
$string['review'] = 'Review your answers';
$string['reviewall'] = 'Review';
$string['rightanswer'] = "Right answer";
$string['saveanswer'] = 'Save answer';
$string['saveessay'] = 'Save essay';
$string['save_message'] = 'IMPORTANT: Save your answer before going to the next page.  You may edit and save again if you change your mind.';
$string['select_category'] = 'Select category';
$string['select_question'] = 'Select question';
$string['select_sort'] = 'Select column to sort on:';
$string['sequence'] = 'Seq';
$string['sequence_updated'] = 'Page sequences updated';
$string['sessionscore'] = 'Correct';
$string['setpage'] = 'Allocate';
$string['showindex'] = 'Show the page index';
$string['showindex_help'] = 'The page index is optional and will show on the top right of every content page in preview mode by default. This can be overriden by themes. ';
$string['showpage'] = 'Preview page';
$string['simplelesson:addinstance'] = 'Add a new Simple lesson';
$string['simplelesson:exportpages'] = 'Export pages';
$string['simplelesson:exportreportpages'] = 'Export report pages';
$string['simplelesson:importpages'] = 'Import pages';
$string['simplelesson:manage'] = 'Manage Simple lesson';
$string['simplelesson:manageattempts'] = 'Manage attempt records';
$string['simplelesson:managequestions'] = 'Manage questions';
$string['simplelesson:view'] = 'View Simple lesson';
$string['simplelesson:viewreportstab'] = 'View the reports tab';
$string['simplelesson_editing'] = 'Editing Simple lesson';
$string['simplelesson_settings'] = 'Simplelesson settings';
$string['simplelesson_title'] = 'Title of this resource';
$string['simplelessonfieldset'] = 'Custom example fieldset';
$string['simplelessonname'] = 'Simple lesson name';
$string['simplelessonname_help'] = 'Choose a suitable name for your Simple lesson.';
$string['simplelessonviewed'] = 'Simple lesson viewed';
$string['starting_attempt'] = "Starting Attempt";
$string['status'] = 'Status';
$string['summary_header'] = "Attempt summary";
$string['summary_score'] = 'Score for this attempt: {$a}';
$string['summary_time'] = 'Total time for this attempt: {$a} (Seconds)';
$string['summary_user'] = 'User report for {$a}';
$string['the_essay'] = 'The essay to grade';
$string['timecreated'] = 'Time created';
$string['timetaken'] = 'Time taken (s)';
$string['ungraded'] = 'Not graded';
$string['unlimited'] = 'Unlimited';
$string['unlimited_attempts'] = 'Unlimited attempts';
$string['userdetail'] = 'User: {$a}';
$string['userreportdownload'] = 'Download user report (csv)';
$string['viewtab'] = 'view';
$string['welcome'] = 'Welcome user!';
$string['youranswer'] = "Your answer";
