<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Web service for mod checklist.
 * @copyright  2021 Kristian Ringer <kristian.ringer@gmail.com>
 * @package    mod_checklist
 * @subpackage db
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = [
    'mod_checklist_update_student_comment' => [
        'classname' => 'mod_checklist\external\update_student_comment',
        'methodname' => 'execute',
        'classpath' => '',
        'description' => 'Update a student comment',
        'ajax' => true,
        'type' => 'write',
        'capabilities' => 'mod/checklist:view, mod/checklist:updateown',
    ],
    'mod_checklist_update_item_state' => [
        'classname' => \mod_checklist\external\update_item_state::class,
        'methodname' => 'execute',
        'ajax' => true,
        'type' => 'write',
        'capabilities' => 'mod/checklist:updateown',
        'services' => [MOODLE_OFFICIAL_MOBILE_SERVICE],
    ],
];
