<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     tiny_fontcolor
 * @category    string
 * @copyright   2023 Luca Bösch <luca.boesch@bfh.ch>
 * @copyright   2023 Stephan Robotta <stephan.robotta@bfh.ch>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['backgroundcolorpicker'] = 'Colour picker for text background colour';
$string['backgroundcolorpicker_desc'] = 'Should a colour picker for text background colour be available';
$string['backgroundcolors'] = 'Available text background colours';
$string['backgroundcolors_desc'] = 'A list of colour names on the left and their RGB colour code, e.g. "#000000". The values are the colours displayed in the dialogue to choose from. The names serve as as the tooltip when hovering over the colours.';
$string['btnBgcolor'] = 'Text background colour';
$string['btnFgcolor'] = 'Text foreground colour';
$string['colorPickerCancel'] = 'Cancel';
$string['colorPickerColor'] = 'Colour';
$string['colorPickerErrHexCode'] = 'Invalid hex colour code: {0}';
$string['colorPickerErrRgbCode'] = 'Invalid rgb value: {0}';
$string['colorPickerSave'] = 'Apply';
$string['colorPickerTitle'] = 'Colour picker';
$string['customColor'] = 'Custom colour';
$string['errorupdatingthemescss'] = 'The css classes could not stored in the theme setting.';
$string['fontcolor:use'] = 'Use Tiny font colour';
$string['menuItemBgcolor'] = 'Text background colour';
$string['menuItemFgcolor'] = 'Text foreground colour';
$string['placeholdercolorname'] = 'Descriptive name of colour';
$string['placeholdercolorvalue'] = 'Hex code of colour value';
$string['pluginname'] = 'Tiny font colour';
$string['privacy:metadata'] = 'The Tiny font color plugin does not store any personal data about any user.';
$string['removeColor'] = 'Remove colour';
$string['settings'] = 'Tiny text colour/text background colour settings';
$string['textcolorpicker'] = 'Colour picker for text colour';
$string['textcolorpicker_desc'] = 'Should a colour picker for text colour be available';
$string['textcolors'] = 'Available text colours';
$string['textcolors_desc'] = 'A list of colour names on the left and their RGB colour code, e.g. "#000000". The values are the colours displayed in the dialogue to choose from. The names serve as as the tooltip when hovering over the colours.';
$string['usecssclassnames'] = 'Use CSS classnames over direct color codes in HTML.';
$string['usecssclassnames_desc'] = 'When this option is set, instead of setting the colour in a style attribute, a css classname is used. The css classes with the color definition will be placed in the theme scss setting. Class names are autogenerated from the descriptive name of the colour. Using this setting makes it difficult to transfer content out of this Moodle instance. Please check the documentation for more information.';

// Deprecated since Moodle 4.5.
$string['helplinktext'] = 'Tiny font colour';
