define("core/emoji/picker",["exports","core/localstorage","core/emoji/data","core/utils","core/str","core/templates"],(function(_exports,_localstorage,EmojiData,_utils,_str,_templates){var obj;
/**
   * Emoji picker.
   *
   * @module core/emoji/picker
   * @copyright  2019 Ryan Wyllie <ryan@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_localstorage=(obj=_localstorage)&&obj.__esModule?obj:{default:obj},EmojiData=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(EmojiData);const ROW_TYPE_EMOJI=0,ROW_TYPE_HEADER=1,SELECTORS_CATEGORY_SELECTOR='[data-action="show-category"]',SELECTORS_EMOJIS_CONTAINER='[data-region="emojis-container"]',SELECTORS_EMOJI_PREVIEW='[data-region="emoji-preview"]',SELECTORS_EMOJI_SHORT_NAME='[data-region="emoji-short-name"]',SELECTORS_ROW_CONTAINER='[data-region="row-container"]',SELECTORS_SEARCH_INPUT='[data-region="search-input"]',SELECTORS_SEARCH_RESULTS_CONTAINER='[data-region="search-results-container"]',createRowDataForCategory=(categoryName,categoryDisplayName,emojis,totalRowCount)=>{const rowData=[];rowData.push({index:totalRowCount+rowData.length,type:ROW_TYPE_HEADER,data:{name:categoryName,displayName:categoryDisplayName}});for(let i=0;i<emojis.length;i+=7){const rowEmojis=emojis.slice(i,i+7);rowData.push({index:totalRowCount+rowData.length,type:ROW_TYPE_EMOJI,data:rowEmojis})}return rowData},addIndexesToRowData=rowData=>rowData.map(((data,index)=>({...data,index:index}))),getCategoryScrollPositionsFromRowData=rowData=>rowData.reduce(((carry,row,index)=>(row.type===ROW_TYPE_HEADER&&(carry[row.data.name]=40*index),carry)),{}),isEmojiElement=element=>null!==element.getAttribute("data-short-names"),findCategorySelectorFromElement=element=>element?"show-category"===element.getAttribute("data-action")?element:findCategorySelectorFromElement(element.parentElement):null,getCategorySelectorByCategoryName=(root,name)=>root.querySelector('[data-category="'.concat(name,'"]')),getCategoryByScrollPosition=(root,position,categoryScrollPositions)=>{let positions=[];position<0&&(position=0);for(const categoryName in categoryScrollPositions){const categoryPosition=categoryScrollPositions[categoryName];positions.push([categoryPosition,categoryName])}positions.sort(((_ref,_ref2)=>{let[a]=_ref,[b]=_ref2;return a<b?-1:a>b?1:0}));const{categoryName:categoryName,previousPosition:previousPosition,nextPosition:nextPosition}=positions.reduce(((carry,candidate)=>{const[categoryPosition,categoryName]=candidate;return categoryPosition<=position?(carry.categoryName=categoryName,carry.previousPosition=carry.currentPosition,carry.currentPosition=position):null===carry.nextPosition&&(carry.nextPosition=categoryPosition),carry}),{categoryName:null,currentPosition:null,previousPosition:null,nextPosition:null});return[getCategorySelectorByCategoryName(root,categoryName),previousPosition,nextPosition]},getRecentEmojis=()=>{const storedData=_localstorage.default.get("moodle-recent-emojis");return storedData?JSON.parse(storedData):[]},addRecentEmoji=(rowData,recentEmojiRowCount,newEmoji)=>{const categoryName=rowData[0].data.name,categoryDisplayName=rowData[0].data.displayName,recentEmojis=getRecentEmojis();let newRecentEmojis=[newEmoji,...recentEmojis.filter((emoji=>emoji.unified!=newEmoji.unified))];newRecentEmojis=newRecentEmojis.slice(0,21);const newRecentEmojiRowData=createRowDataForCategory(categoryName,categoryDisplayName,newRecentEmojis);return(recentEmojis=>{_localstorage.default.set("moodle-recent-emojis",JSON.stringify(recentEmojis))})(newRecentEmojis),[addIndexesToRowData(newRecentEmojiRowData.concat(rowData.slice(recentEmojiRowCount))),newRecentEmojiRowData.length]},getRowsToRender=(scrollPosition,visibleRowCount,rowData)=>{const minVisibleRow=scrollPosition>40?Math.floor(scrollPosition/40):0,start=minVisibleRow>=5?minVisibleRow-5:minVisibleRow,end=minVisibleRow+visibleRowCount+5;return rowData.slice(start,end)},createRowElement=async rowData=>{let row=null;return row=rowData.type===ROW_TYPE_HEADER?await(async(rowIndex,name)=>{const context={index:rowIndex,text:name},html=await(0,_templates.render)("core/emoji/header_row",context),temp=document.createElement("div");return temp.innerHTML=html,temp.firstChild})(rowData.index,rowData.data.displayName):await(async(rowIndex,emojis)=>{const context={index:rowIndex,emojis:emojis.map((emojiData=>{const charCodes=emojiData.unified.split("-").map((code=>"0x".concat(code))),emojiText=String.fromCodePoint.apply(null,charCodes);return{shortnames:":".concat(emojiData.shortnames.join(": :"),":"),unified:emojiData.unified,text:emojiText,spacer:!1}})),spacers:Array(7-emojis.length).fill(!0)},html=await(0,_templates.render)("core/emoji/emoji_row",context),temp=document.createElement("div");return temp.innerHTML=html,temp.firstChild})(rowData.index,rowData.data),row.style.position="absolute",row.style.left=0,row.style.right=0,row.style.top="".concat(40*rowData.index,"px"),row},doRowsMatch=(a,b)=>{if(a.index!==b.index)return!1;if(a.type!==b.type)return!1;if(typeof a.data!=typeof b.data)return!1;if(a.type===ROW_TYPE_HEADER)return a.data.name===b.data.name;if(a.data.length!==b.data.length)return!1;for(let i=0;i<a.data.length;i++)if(a.data[i].unified!=b.data[i].unified)return!1;return!0},generateRenderRowsAtPositionFunction=rowContainer=>{let currentRows=[],nextRows=[],rowCount=0,isRendering=!1;const renderNextRows=async()=>{if(!nextRows.length)return;if(isRendering)return;isRendering=!0;const nextRowsToRender=nextRows.slice();nextRows=[],await(async(rowContainer,currentRows,nextRows)=>{const toAdd=nextRows.filter((nextRow=>!currentRows.some((currentRow=>doRowsMatch(currentRow,nextRow)))));let toKeep=currentRows.filter((currentRow=>nextRows.some((nextRow=>doRowsMatch(currentRow,nextRow)))));const toRemoveElements=currentRows.filter((currentRow=>!nextRows.some((nextRow=>doRowsMatch(currentRow,nextRow))))).map((rowData=>rowContainer.querySelectorAll('[data-row="'.concat(rowData.index,'"]'))));(await Promise.all(toAdd.map((rowData=>createRowElement(rowData))))).forEach(((row,index)=>{const rowData=toAdd[index];let nextRowIndex=null;for(let i=0;i<toKeep.length;i++)if(toKeep[i].index>rowData.index){nextRowIndex=i;break}if(null!==nextRowIndex){const nextRowData=toKeep[nextRowIndex],nextRowNode=rowContainer.querySelector('[data-row="'.concat(nextRowData.index,'"]'));rowContainer.insertBefore(row,nextRowNode),toKeep.splice(nextRowIndex,0,toKeep)}else toKeep.push(rowData),rowContainer.appendChild(row)})),toRemoveElements.forEach((rows=>{for(let i=0;i<rows.length;i++){const row=rows[i];rowContainer.removeChild(row)}}))})(rowContainer,currentRows,nextRowsToRender),currentRows=nextRowsToRender,isRendering=!1,renderNextRows()};return function(scrollPosition,rowData){let rowLimit=arguments.length>2&&void 0!==arguments[2]?arguments[2]:10;nextRows=getRowsToRender(scrollPosition,rowLimit,rowData),renderNextRows(),rowCount!==rowData.length&&(rowContainer.style.height="".concat(40*rowData.length,"px")),rowCount=rowData.length}},clearSearch=(emojiContainer,searchResultsContainer,searchInput)=>{searchResultsContainer.classList.add("hidden"),emojiContainer.classList.remove("hidden"),searchInput.value=""},getHandleMouseEnter=(emojiPreview,emojiShortName)=>e=>{const target=e.target;isEmojiElement(target)&&(emojiShortName.textContent=target.getAttribute("data-short-names"),emojiPreview.textContent=target.textContent)},getHandleMouseLeave=(emojiPreview,emojiShortName)=>e=>{const target=e.target;isEmojiElement(target)&&(emojiShortName.textContent="",emojiPreview.textContent="")},getHandleScroll=(root,currentVisibleRowScrollPosition,emojiContainer,initialCategoryScrollPositions,renderAtPosition)=>{let[currentCategoryElement,previousCategoryPosition,nextCategoryPosition]=getCategoryByScrollPosition(root,emojiContainer.scrollTop,initialCategoryScrollPositions);return(categoryScrollPositions,rowData)=>{const newScrollPosition=emojiContainer.scrollTop,updateRenderRows=newScrollPosition<currentVisibleRowScrollPosition-40||newScrollPosition>currentVisibleRowScrollPosition+40;(newScrollPosition>=nextCategoryPosition||newScrollPosition<previousCategoryPosition)&&([currentCategoryElement,previousCategoryPosition,nextCategoryPosition]=getCategoryByScrollPosition(root,newScrollPosition,categoryScrollPositions),((root,element)=>{const allCategorySelectors=root.querySelectorAll(SELECTORS_CATEGORY_SELECTOR);for(let i=0;i<allCategorySelectors.length;i++)allCategorySelectors[i].classList.remove("selected");element.classList.add("selected")})(root,currentCategoryElement)),updateRenderRows&&requestAnimationFrame((()=>{renderAtPosition(newScrollPosition,rowData),currentVisibleRowScrollPosition=newScrollPosition}))}},registerEventListeners=(root,emojiContainer,renderAtPosition,currentVisibleRowScrollPosition,selectCallback,categoryScrollPositions,rowData,recentEmojiRowCount)=>{const searchInput=root.querySelector(SELECTORS_SEARCH_INPUT),searchResultsContainer=root.querySelector(SELECTORS_SEARCH_RESULTS_CONTAINER),emojiPreview=root.querySelector(SELECTORS_EMOJI_PREVIEW),emojiShortName=root.querySelector(SELECTORS_EMOJI_SHORT_NAME),clickHandler=((recentEmojiRowCount,emojiContainer,searchResultsContainer,searchInput,selectCallback,renderAtPosition)=>(e,rowData,categoryScrollPositions)=>{const target=e.target;let newRowData=rowData,newCategoryScrollPositions=categoryScrollPositions;if(clearSearch(emojiContainer,searchResultsContainer,searchInput),isEmojiElement(target)){const emojiData={unified:target.getAttribute("data-unified"),shortnames:target.getAttribute("data-short-names").replace(/:/g,"").split(" ")},currentScrollTop=emojiContainer.scrollTop,isRecentEmojiRowVisible=null!==emojiContainer.querySelector('[data-row="'.concat(recentEmojiRowCount-1,'"]'));return[newRowData,recentEmojiRowCount]=addRecentEmoji(rowData,recentEmojiRowCount,emojiData),newCategoryScrollPositions=getCategoryScrollPositionsFromRowData(newRowData),isRecentEmojiRowVisible&&renderAtPosition(currentScrollTop,newRowData),selectCallback(target.textContent),[newRowData,newCategoryScrollPositions]}const categorySelector=findCategorySelectorFromElement(target);if(categorySelector){const position=categoryScrollPositions[categorySelector.getAttribute("data-category")];emojiContainer.scrollTop=position}return[newRowData,newCategoryScrollPositions]})(recentEmojiRowCount,emojiContainer,searchResultsContainer,searchInput,selectCallback,renderAtPosition),scrollHandler=getHandleScroll(root,currentVisibleRowScrollPosition,emojiContainer,categoryScrollPositions,renderAtPosition),searchHandler=((searchInput,searchResultsContainer,emojiContainer)=>{const rowContainer=searchResultsContainer.querySelector(SELECTORS_ROW_CONTAINER),renderSearchResultsAtPosition=generateRenderRowsAtPositionFunction(rowContainer);return searchResultsContainer.appendChild(rowContainer),async()=>{const searchTerm=searchInput.value.toLowerCase();if(searchTerm){((emojiContainer,searchResultsContainer)=>{searchResultsContainer.classList.remove("hidden"),emojiContainer.classList.add("hidden")})(emojiContainer,searchResultsContainer);const matchingEmojis=Object.keys(EmojiData.byShortName).reduce(((carry,shortName)=>(shortName.includes(searchTerm)&&carry.push({shortnames:[shortName],unified:EmojiData.byShortName[shortName]}),carry)),[]),searchResultsString=await(0,_str.getString)("searchresults","core"),rowData=createRowDataForCategory(searchResultsString,searchResultsString,matchingEmojis,0);renderSearchResultsAtPosition(0,rowData,rowData.length)}else clearSearch(emojiContainer,searchResultsContainer,searchInput)}})(searchInput,searchResultsContainer,emojiContainer);root.addEventListener("focus",getHandleMouseEnter(emojiPreview,emojiShortName),!0),root.addEventListener("blur",getHandleMouseLeave(emojiPreview,emojiShortName),!0),root.addEventListener("mouseenter",getHandleMouseEnter(emojiPreview,emojiShortName),!0),root.addEventListener("mouseleave",getHandleMouseLeave(emojiPreview,emojiShortName),!0),root.addEventListener("click",(e=>{[rowData,categoryScrollPositions]=clickHandler(e,rowData,categoryScrollPositions)})),emojiContainer.addEventListener("scroll",(0,_utils.throttle)((()=>scrollHandler(categoryScrollPositions,rowData)),50)),searchInput.addEventListener("input",(0,_utils.debounce)(searchHandler,200))};return _exports.default=(root,selectCallback)=>{const emojiContainer=root.querySelector(SELECTORS_EMOJIS_CONTAINER),rowContainer=emojiContainer.querySelector(SELECTORS_ROW_CONTAINER),allData=[{name:"Recent",emojis:getRecentEmojis()},...EmojiData.byCategory];let rowData=[],recentEmojiRowCount=0;allData.forEach((category=>{const categoryDisplayName=getCategorySelectorByCategoryName(root,category.name).title,categoryRowData=createRowDataForCategory(category.name,categoryDisplayName,category.emojis,rowData.length);"Recent"===category.name&&(recentEmojiRowCount=categoryRowData.length),rowData=rowData.concat(categoryRowData)})),rowData=addIndexesToRowData(rowData);const categoryScrollPositions=getCategoryScrollPositionsFromRowData(rowData),renderAtPosition=generateRenderRowsAtPositionFunction(rowContainer);renderAtPosition(0,rowData),registerEventListeners(root,emojiContainer,renderAtPosition,0,selectCallback,categoryScrollPositions,rowData,recentEmojiRowCount)},_exports.default}));

//# sourceMappingURL=picker.min.js.map