/*
    JSXGraph 1.4.1

    Copyright 2008-2022
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Andreas Walter,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software dual licensed under the GNU LGPL or MIT License.

    You can redistribute it and/or modify it under the terms of the

      * GNU Lesser General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version
      OR
      * MIT License: https://github.com/jsxgraph/jsxgraph/blob/master/LICENSE.MIT

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License and
    the MIT License along with JSXGraph. If not, see <https://www.gnu.org/licenses/>
    and <https://opensource.org/licenses/MIT/>.
*/

/**
 * almond 0.2.5 Copyright (c) 2011-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: https://github.com/jrburke/almond for details
 */

/**
 * UTF-8 Decoder by Bjoern Hoehrmann
 *
 * Copyright (c) 2008-2009 Bjoern Hoehrmann <bjoern@hoehrmann.de>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this
 * software and associated documentation files (the "Software"), to deal in the Software
 * without restriction, including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function(t,e){"function"==typeof define&&define.amd?define("jsxgraphcore",[],e):"object"==typeof module&&module.exports?module.exports=e():t.returnExports=e()}(this,(function(){
/**
 * @license almond 0.3.3 Copyright jQuery Foundation and other contributors.
 * Released under MIT license, http://github.com/requirejs/almond/LICENSE
 */
var requirejs,require,define;return function(t){var e,i,r,s,o={},n={},a={},h={},l=Object.prototype.hasOwnProperty,c=[].slice,d=/\.js$/;function u(t,e){return l.call(t,e)}function p(t,e){var i,r,s,o,n,h,l,c,u,p,f,m=e&&e.split("/"),g=a.map,b=g&&g["*"]||{};if(t){for(n=(t=t.split("/")).length-1,a.nodeIdCompat&&d.test(t[n])&&(t[n]=t[n].replace(d,"")),"."===t[0].charAt(0)&&m&&(t=m.slice(0,m.length-1).concat(t)),u=0;u<t.length;u++)if("."===(f=t[u]))t.splice(u,1),u-=1;else if(".."===f){if(0===u||1===u&&".."===t[2]||".."===t[u-1])continue;u>0&&(t.splice(u-1,2),u-=2)}t=t.join("/")}if((m||b)&&g){for(u=(i=t.split("/")).length;u>0;u-=1){if(r=i.slice(0,u).join("/"),m)for(p=m.length;p>0;p-=1)if((s=g[m.slice(0,p).join("/")])&&(s=s[r])){o=s,h=u;break}if(o)break;!l&&b&&b[r]&&(l=b[r],c=u)}!o&&l&&(o=l,h=c),o&&(i.splice(0,h,o),t=i.join("/"))}return t}function f(e,r){return function(){var s=c.call(arguments,0);return"string"!=typeof s[0]&&1===s.length&&s.push(null),i.apply(t,s.concat([e,r]))}}function m(t){return function(e){o[t]=e}}function g(i){if(u(n,i)){var r=n[i];delete n[i],h[i]=!0,e.apply(t,r)}if(!u(o,i)&&!u(h,i))throw new Error("No "+i);return o[i]}function b(t){var e,i=t?t.indexOf("!"):-1;return i>-1&&(e=t.substring(0,i),t=t.substring(i+1,t.length)),[e,t]}function v(t){return t?b(t):[]}function y(t){return function(){return a&&a.config&&a.config[t]||{}}}r=function(t,e){var i,r,s=b(t),o=s[0],n=e[1];return t=s[1],o&&(i=g(o=p(o,n))),o?t=i&&i.normalize?i.normalize(t,(r=n,function(t){return p(t,r)})):p(t,n):(o=(s=b(t=p(t,n)))[0],t=s[1],o&&(i=g(o))),{f:o?o+"!"+t:t,n:t,pr:o,p:i}},s={require:function(t){return f(t)},exports:function(t){var e=o[t];return void 0!==e?e:o[t]={}},module:function(t){return{id:t,uri:"",exports:o[t],config:y(t)}}},e=function(e,i,a,l){var c,d,p,b,y,C,_,P=[],E=typeof a;if(C=v(l=l||e),"undefined"===E||"function"===E){for(i=!i.length&&a.length?["require","exports","module"]:i,y=0;y<i.length;y+=1)if("require"===(d=(b=r(i[y],C)).f))P[y]=s.require(e);else if("exports"===d)P[y]=s.exports(e),_=!0;else if("module"===d)c=P[y]=s.module(e);else if(u(o,d)||u(n,d)||u(h,d))P[y]=g(d);else{if(!b.p)throw new Error(e+" missing "+d);b.p.load(b.n,f(l,!0),m(d),{}),P[y]=o[d]}p=a?a.apply(o[e],P):void 0,e&&(c&&c.exports!==t&&c.exports!==o[e]?o[e]=c.exports:p===t&&_||(o[e]=p))}else e&&(o[e]=a)},requirejs=require=i=function(o,n,h,l,c){if("string"==typeof o)return s[o]?s[o](n):g(r(o,v(n)).f);if(!o.splice){if((a=o).deps&&i(a.deps,a.callback),!n)return;n.splice?(o=n,n=h,h=null):o=t}return n=n||function(){},"function"==typeof h&&(h=l,l=c),l?e(t,o,n,h):setTimeout((function(){e(t,o,n,h)}),4),i},i.config=function(t){return i(t)},requirejs._defined=o,(define=function(t,e,i){if("string"!=typeof t)throw new Error("See almond README: incorrect module build, no module name");e.splice||(i=e,e=[]),u(o,t)||u(n,t)||(n[t]=[t,e,i])}).amd={jQuery:!0}}(),define("../node_modules/almond/almond",(function(){})),define("jxg",[],(function(){"use strict";var t={};return"object"!=typeof JXG||JXG.extend||(t=JXG),t.extend=function(t,e,i,r){var s;for(s in i=i||!1,r=r||!1,e)(!i||i&&e.hasOwnProperty(s))&&(t[r?s.toLowerCase():s]=e[s])},t.defineConstant=function(e,i,r,s){(s=s||!1)&&t.exists(e[i])||Object.defineProperty(e,i,{value:r,writable:!1,enumerable:!0,configurable:!1})},t.extendConstants=function(t,e,i,r){var s,o;for(s in i=i||!1,r=r||!1,e)(!i||i&&e.hasOwnProperty(s))&&(o=r?s.toUpperCase():s,this.defineConstant(t,o,e[s]))},t.extend(t,{boards:{},readers:{},elements:{},registerElement:function(t,e){t=t.toLowerCase(),this.elements[t]=e},registerReader:function(t,e){var i,r;for(i=0;i<e.length;i++)r=e[i].toLowerCase(),"function"!=typeof this.readers[r]&&(this.readers[r]=t)},shortcut:function(t,e){return function(){return t[e].apply(this,arguments)}},getRef:function(e,i){return t.deprecated("JXG.getRef()","Board.select()"),e.select(i)},getReference:function(e,i){return t.deprecated("JXG.getReference()","Board.select()"),e.select(i)},getBoardByContainerId:function(t){var e;for(e in JXG.boards)if(JXG.boards.hasOwnProperty(e)&&JXG.boards[e].container===t)return JXG.boards[e];return null},deprecated:function(e,i){var r=e+" is deprecated.";i&&(r+=" Please use "+i+" instead."),t.warn(r)},warn:function(t){"object"==typeof window&&window.console&&console.warn?console.warn("WARNING:",t):"object"==typeof document&&document.getElementById("warning")&&(document.getElementById("debug").innerHTML+="WARNING: "+t+"<br />")},debugInt:function(t){var e,i;for(e=0;e<arguments.length;e++)i=arguments[e],"object"==typeof window&&window.console&&console.log?console.log(i):"object"==typeof document&&document.getElementById("debug")&&(document.getElementById("debug").innerHTML+=i+"<br/>")},debugWST:function(e){var i=new Error;t.debugInt.apply(this,arguments),i&&i.stack&&(t.debugInt("stacktrace"),t.debugInt(i.stack.split("\n").slice(1).join("\n")))},debugLine:function(e){var i=new Error;t.debugInt.apply(this,arguments),i&&i.stack&&t.debugInt("Called from",i.stack.split("\n").slice(2,3).join("\n"))},debug:function(e){t.debugInt.apply(this,arguments)}}),t})),define("base/constants",["jxg"],(function(t){"use strict";var e,i="1.4.1";return e={version:i,licenseText:"JSXGraph v1.4.1 Copyright (C) see https://jsxgraph.org",COORDS_BY_USER:1,COORDS_BY_SCREEN:2,OBJECT_TYPE_ARC:1,OBJECT_TYPE_ARROW:2,OBJECT_TYPE_AXIS:3,OBJECT_TYPE_AXISPOINT:4,OBJECT_TYPE_TICKS:5,OBJECT_TYPE_CIRCLE:6,OBJECT_TYPE_CONIC:7,OBJECT_TYPE_CURVE:8,OBJECT_TYPE_GLIDER:9,OBJECT_TYPE_IMAGE:10,OBJECT_TYPE_LINE:11,OBJECT_TYPE_POINT:12,OBJECT_TYPE_SLIDER:13,OBJECT_TYPE_CAS:14,OBJECT_TYPE_GXTCAS:15,OBJECT_TYPE_POLYGON:16,OBJECT_TYPE_SECTOR:17,OBJECT_TYPE_TEXT:18,OBJECT_TYPE_ANGLE:19,OBJECT_TYPE_INTERSECTION:20,OBJECT_TYPE_TURTLE:21,OBJECT_TYPE_VECTOR:22,OBJECT_TYPE_OPROJECT:23,OBJECT_TYPE_GRID:24,OBJECT_TYPE_TANGENT:25,OBJECT_TYPE_HTMLSLIDER:26,OBJECT_TYPE_CHECKBOX:27,OBJECT_TYPE_INPUT:28,OBJECT_TYPE_BUTTON:29,OBJECT_TYPE_TRANSFORMATION:30,OBJECT_TYPE_FOREIGNOBJECT:31,OBJECT_CLASS_POINT:1,OBJECT_CLASS_LINE:2,OBJECT_CLASS_CIRCLE:3,OBJECT_CLASS_CURVE:4,OBJECT_CLASS_AREA:5,OBJECT_CLASS_OTHER:6,OBJECT_CLASS_TEXT:7,GENTYPE_ABC:1,GENTYPE_AXIS:2,GENTYPE_MID:3,GENTYPE_REFLECTION:4,GENTYPE_MIRRORELEMENT:5,GENTYPE_REFLECTION_ON_LINE:4,GENTYPE_REFLECTION_ON_POINT:5,GENTYPE_TANGENT:6,GENTYPE_PARALLEL:7,GENTYPE_BISECTORLINES:8,GENTYPE_BOARDIMG:9,GENTYPE_BISECTOR:10,GENTYPE_NORMAL:11,GENTYPE_POINT:12,GENTYPE_GLIDER:13,GENTYPE_INTERSECTION:14,GENTYPE_CIRCLE:15,GENTYPE_CIRCLE2POINTS:16,GENTYPE_LINE:17,GENTYPE_TRIANGLE:18,GENTYPE_QUADRILATERAL:19,GENTYPE_TEXT:20,GENTYPE_POLYGON:21,GENTYPE_REGULARPOLYGON:22,GENTYPE_SECTOR:23,GENTYPE_ANGLE:24,GENTYPE_PLOT:25,GENTYPE_SLIDER:26,GENTYPE_TRUNCATE:27,GENTYPE_JCODE:28,GENTYPE_MOVEMENT:29,GENTYPE_COMBINED:30,GENTYPE_RULER:31,GENTYPE_SLOPETRIANGLE:32,GENTYPE_PERPSEGMENT:33,GENTYPE_LABELMOVEMENT:34,GENTYPE_VECTOR:35,GENTYPE_NONREFLEXANGLE:36,GENTYPE_REFLEXANGLE:37,GENTYPE_PATH:38,GENTYPE_DERIVATIVE:39,GENTYPE_DELETE:41,GENTYPE_COPY:42,GENTYPE_MIRROR:43,GENTYPE_ROTATE:44,GENTYPE_ABLATION:45,GENTYPE_MIGRATE:46,GENTYPE_VECTORCOPY:47,GENTYPE_POLYGONCOPY:48,GENTYPE_CTX_TYPE_G:51,GENTYPE_CTX_TYPE_P:52,GENTYPE_CTX_TRACE:53,GENTYPE_CTX_VISIBILITY:54,GENTYPE_CTX_CCVISIBILITY:55,GENTYPE_CTX_MPVISIBILITY:56,GENTYPE_CTX_WITHLABEL:57,GENTYPE_CTX_LABEL:58,GENTYPE_CTX_FIXED:59,GENTYPE_CTX_STROKEWIDTH:60,GENTYPE_CTX_LABELSIZE:61,GENTYPE_CTX_SIZE:62,GENTYPE_CTX_FACE:63,GENTYPE_CTX_STRAIGHT:64,GENTYPE_CTX_ARROW:65,GENTYPE_CTX_COLOR:66,GENTYPE_CTX_RADIUS:67,GENTYPE_CTX_COORDS:68,GENTYPE_CTX_TEXT:69,GENTYPE_CTX_ANGLERADIUS:70,GENTYPE_CTX_DOTVISIBILITY:71,GENTYPE_CTX_FILLOPACITY:72,GENTYPE_CTX_PLOT:73,GENTYPE_CTX_SCALE:74,GENTYPE_CTX_INTVAL:75,GENTYPE_CTX_POINT1:76,GENTYPE_CTX_POINT2:77,GENTYPE_CTX_LABELSTICKY:78,GENTYPE_CTX_TYPE_I:79,GENTYPE_CTX_HASINNERPOINTS:80,GENTYPE_CTX_SNAPWIDTH:81,GENTYPE_CTX_SNAPTOGRID:82},t.extendConstants(t,e),e})),define("utils/type",["jxg","base/constants"],(function(t,e){"use strict";return t.extend(t,{isId:function(t,e){return"string"==typeof e&&!!t.objects[e]},isName:function(t,e){return"string"==typeof e&&!!t.elementsByName[e]},isGroup:function(t,e){return"string"==typeof e&&!!t.groups[e]},isString:function(t){return"string"==typeof t},isNumber:function(t){return"number"==typeof t||"[Object Number]"===Object.prototype.toString.call(t)},isFunction:function(t){return"function"==typeof t},isArray:function(t){return Array.isArray?Array.isArray(t):null!==t&&"object"==typeof t&&"function"==typeof t.splice&&"function"==typeof t.join},isObject:function(t){return"object"==typeof t&&!this.isArray(t)},isPoint:function(t){return null!==t&&"object"==typeof t&&t.elementClass===e.OBJECT_CLASS_POINT},isPointType:function(t,e){var i,r;return!!this.isArray(e)||(!!(this.isFunction(e)&&(i=e(),this.isArray(i)&&i.length>1))||(r=t.select(e),this.isPoint(r)))},isTransformationOrArray:function(t){if(null!==t){if(this.isArray(t)&&t.length>0)return this.isTransformationOrArray(t[0]);if("object"==typeof t)return t.type===e.OBJECT_TYPE_TRANSFORMATION}return!1},exists:function(t,e){var i=!(null==t||null===t);return(e=e||!1)?i&&""!==t:i},isEmpty:function(t){return 0===Object.keys(t).length},def:function(t,e){return this.exists(t)?t:e},str2Bool:function(t){return!this.exists(t)||("boolean"==typeof t?t:!!this.isString(t)&&"true"===t.toLowerCase())},createEvalFunction:function(e,i,r){var s,o=[];for(s=0;s<r;s++)o[s]=t.createFunction(i[s],e,"",!0);return function(t){return o[t]()}},createFunction:function(t,e,i,r){var s=null;return this.exists(r)&&!r||!this.isString(t)?this.isFunction(t)?s=t:(this.isNumber(t)||this.isString(t))&&(s=function(){return t}):s=e.jc.snippet(t,!0,i,!0),null!==s&&(s.origin=t),s},providePoints:function(t,e,i,r,s){var o,n,a,h,l,c=0,d=[];for(this.isArray(e)||(e=[e]),a=e.length,this.exists(s)&&(c=s.length),0===c&&(h=this.copyAttributes(i,t.options,r)),o=0;o<a;++o)if(c>0&&(n=Math.min(o,c-1),h=this.copyAttributes(i,t.options,r,s[n])),this.isArray(e[o])&&e[o].length>1?(d.push(t.create("point",e[o],h)),d[d.length-1]._is_new=!0):this.isFunction(e[o])?(l=e[o](),this.isArray(l)&&l.length>1&&(d.push(t.create("point",[e[o]],h)),d[d.length-1]._is_new=!0)):d.push(t.select(e[o])),!this.isPoint(d[o]))return!1;return d},bind:function(t,e){return function(){return t.apply(e,arguments)}},evaluate:function(t){return this.isFunction(t)?t():t},indexOf:function(t,e,i){var r,s=this.exists(i);if(Array.indexOf&&!s)return t.indexOf(e);for(r=0;r<t.length;r++)if(s&&t[r][i]===e||!s&&t[r]===e)return r;return-1},eliminateDuplicates:function(t){var e,i=t.length,r=[],s={};for(e=0;e<i;e++)s[t[e]]=0;for(e in s)s.hasOwnProperty(e)&&r.push(e);return r},swap:function(t,e,i){var r;return r=t[e],t[e]=t[i],t[i]=r,t},uniqueArray:function(e){var i,r,s,o=[];if(0===e.length)return[];for(i=0;i<e.length;i++)if(s=this.isArray(e[i]),this.exists(e[i]))for(r=i+1;r<e.length;r++)s&&t.cmpArrays(e[i],e[r])?e[i]=[]:s||e[i]!==e[r]||(e[i]="");else e[i]="";for(r=0,i=0;i<e.length;i++)(s=this.isArray(e[i]))||""===e[i]?s&&0!==e[i].length&&(o[r]=e[i].slice(0),r++):(o[r]=e[i],r++);return e=o,o},isInArray:function(e,i){return t.indexOf(e,i)>-1},coordsArrayToMatrix:function(t,e){var i,r=[],s=[];for(i=0;i<t.length;i++)e?(r.push(t[i].usrCoords[1]),s.push(t[i].usrCoords[2])):s.push([t[i].usrCoords[1],t[i].usrCoords[2]]);return e&&(s=[r,s]),s},cmpArrays:function(t,e){var i;if(t===e)return!0;if(t.length!==e.length)return!1;for(i=0;i<t.length;i++)if(this.isArray(t[i])&&this.isArray(e[i])){if(!this.cmpArrays(t[i],e[i]))return!1}else if(t[i]!==e[i])return!1;return!0},removeElementFromArray:function(t,e){var i;for(i=0;i<t.length;i++)if(t[i]===e)return t.splice(i,1),t;return t},trunc:function(e,i){return i=t.def(i,0),this.toFixed(e,i)},_decimalAdjust:function(t,e,i){return void 0===i||0==+i?Math[t](e):(e=+e,i=+i,isNaN(e)||"number"!=typeof i||i%1!=0?NaN:(e=e.toString().split("e"),+((e=(e=Math[t](+(e[0]+"e"+(e[1]?+e[1]-i:-i)))).toString().split("e"))[0]+"e"+(e[1]?+e[1]+i:i))))},_round10:function(t,e){return this._decimalAdjust("round",t,e)},_floor10:function(t,e){return this._decimalAdjust("floor",t,e)},_ceil10:function(t,e){return this._decimalAdjust("ceil",t,e)},toFixed:function(t,e){return this._round10(t,-e).toFixed(e)},autoDigits:function(t){var e=Math.abs(t);return e>.1?this.toFixed(t,2):e>=.01?this.toFixed(t,4):e>=1e-4?this.toFixed(t,6):t},keys:function(t,e){var i,r=[];for(i in t)e?t.hasOwnProperty(i)&&r.push(i):r.push(i);return r},clone:function(t){var e={};return e.prototype=t,e},cloneAndCopy:function(t,e){var i,r=function(){};for(i in r.prototype=t,e)r[i]=e[i];return r},merge:function(t,e){var i,r;for(i in e)if(e.hasOwnProperty(i))if(this.isArray(e[i]))for(t[i]||(t[i]=[]),r=0;r<e[i].length;r++)"object"==typeof e[i][r]?t[i][r]=this.merge(t[i][r],e[i][r]):t[i][r]=e[i][r];else"object"==typeof e[i]?(t[i]||(t[i]={}),t[i]=this.merge(t[i],e[i])):t[i]=e[i];return t},deepCopy:function(t,e,i){var r,s,o,n;if(i=i||!1,"object"!=typeof t||null===t)return t;if(this.isArray(t))for(r=[],s=0;s<t.length;s++)"object"==typeof(o=t[s])?this.exists(o.board)?r[s]=o.id:r[s]=this.deepCopy(o):r[s]=o;else{for(s in r={},t)t.hasOwnProperty(s)&&(n=i?s.toLowerCase():s,null!==(o=t[s])&&"object"==typeof o?this.exists(o.board)?r[n]=o.id:r[n]=this.deepCopy(o):r[n]=o);for(s in e)e.hasOwnProperty(s)&&(n=i?s.toLowerCase():s,"object"==typeof(o=e[s])?this.isArray(o)||!this.exists(r[n])?r[n]=this.deepCopy(o):r[n]=this.deepCopy(r[n],o,i):r[n]=o)}return r},copyAttributes:function(e,i,r){var s,o,n,a,h,l={circle:1,curve:1,image:1,line:1,point:1,polygon:1,text:1,ticks:1,integral:1};for(s=(n=arguments.length)<3||l[r]?t.deepCopy(i.elements,null,!0):{},n<4&&this.exists(r)&&this.exists(i.layer[r])&&(s.layer=i.layer[r]),a=i,h=!0,o=2;o<n;o++){if(!this.exists(a[arguments[o]])){h=!1;break}a=a[arguments[o]]}for(h&&(s=t.deepCopy(s,a,!0)),a=e,h=!0,o=3;o<n;o++){if(!this.exists(a[arguments[o]])){h=!1;break}a=a[arguments[o]]}if(h&&this.extend(s,a,null,!0),"board"===arguments[2])return s;for(a=i,h=!0,o=2;o<n;o++){if(!this.exists(a[arguments[o]])){h=!1;break}a=a[arguments[o]]}return h&&this.exists(a.label)&&(s.label=t.deepCopy(a.label,s.label)),s.label=t.deepCopy(i.label,s.label),s},copyPrototypeMethods:function(t,e,i){var r;for(r in t.prototype[i]=e.prototype.constructor,e.prototype)e.prototype.hasOwnProperty(r)&&(t.prototype[r]=e.prototype[r])},toJSON:function(e,i){var r,s,o,n;if(i=t.def(i,!1),JSON.stringify&&!i)try{return JSON.stringify(e)}catch(t){}switch(typeof e){case"object":if(e){if(r=[],this.isArray(e)){for(o=0;o<e.length;o++)r.push(t.toJSON(e[o],i));return"["+r.join(",")+"]"}for(s in e)if(e.hasOwnProperty(s)){try{n=t.toJSON(e[s],i)}catch(t){n=""}i?r.push(s+":"+n):r.push('"'+s+'":'+n)}return"{"+r.join(",")+"} "}return"null";case"string":return"'"+e.replace(/(["'])/g,"\\$1")+"'";case"number":case"boolean":return e.toString()}return"0"},clearVisPropOld:function(t){return t.visPropOld={cssclass:"",cssdefaultstyle:"",cssstyle:"",fillcolor:"",fillopacity:"",firstarrow:!1,fontsize:-1,lastarrow:!1,left:-1e5,linecap:"",shadow:!1,strokecolor:"",strokeopacity:"",strokewidth:"",tabindex:-1e5,transitionduration:0,top:-1e5,visible:null},t},isInObject:function(t,e){var i;for(i in t)if(t.hasOwnProperty(i)&&t[i]===e)return!0;return!1},escapeHTML:function(t){return t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},unescapeHTML:function(t){return t.replace(/<\/?[^>]+>/gi,"").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">")},capitalize:function(t){return t.charAt(0).toUpperCase()+t.substring(1).toLowerCase()},trimNumber:function(t){return"."!==(t=(t=t.replace(/^0+/,"")).replace(/0+$/,""))[t.length-1]&&","!==t[t.length-1]||(t=t.slice(0,-1)),"."!==t[0]&&","!==t[0]||(t="0"+t),t},filterElements:function(t,e){var i,r,s,o,n,a,h,l=t.length,c=[];if("function"!=typeof e&&"object"!=typeof e)return c;for(i=0;i<l;i++){if(h=!0,s=t[i],"object"==typeof e){for(r in e)if(e.hasOwnProperty(r)&&(o=r.toLowerCase(),n="function"==typeof s[r]?s[r]():s[r],a=s.visProp&&"function"==typeof s.visProp[o]?s.visProp[o]():s.visProp&&s.visProp[o],!(h="function"==typeof e[r]?e[r](n)||e[r](a):n===e[r]||a===e[r])))break}else"function"==typeof e&&(h=e(s));h&&c.push(s)}return c},trim:function(t){return t.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")},sanitizeHTML:function(t,e){return"function"==typeof html_sanitize&&e?html_sanitize(t,(function(){}),(function(t){return t})):(t&&(t=t.replace(/</g,"&lt;").replace(/>/g,"&gt;")),t)},evalSlider:function(t){return t&&t.type===e.OBJECT_TYPE_GLIDER&&"function"==typeof t.Value?t.Value():t}}),t})),define("utils/env",["jxg","utils/type"],(function(t,e){"use strict";return t.extendConstants(t,{touchProperty:"touches"}),t.extend(t,{isTouchEvent:function(e){return t.exists(e[t.touchProperty])},isPointerEvent:function(e){return t.exists(e.pointerId)},isMouseEvent:function(e){return!t.isTouchEvent(e)&&!t.isPointerEvent(e)},getNumberOfTouchPoints:function(e){var i=-1;return t.isTouchEvent(e)&&(i=e[t.touchProperty].length),i},isFirstTouch:function(e){var i=t.getNumberOfTouchPoints(e);return t.isPointerEvent(e)?e.isPrimary:1===i},isBrowser:"object"==typeof window&&"object"==typeof document,supportsES6:function(){try{return new Function("(a = 0) => a"),!0}catch(t){return!1}},supportsVML:function(){return this.isBrowser&&!!document.namespaces},supportsSVG:function(){return this.isBrowser&&document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1")},supportsCanvas:function(){var t=!1;if(this.isNode())try{t=!!("object"==typeof module?module.require("canvas"):require("canvas"))}catch(t){}return t||this.isBrowser&&!!document.createElement("canvas").getContext},isNode:function(){return!this.isBrowser&&("object"==typeof module&&!!module.exports||"object"==typeof global&&global.requirejsVars&&!global.requirejsVars.isBrowser)},isWebWorker:function(){return!this.isBrowser&&"object"==typeof self&&"function"==typeof self.postMessage},supportsPointerEvents:function(){return!!(this.isBrowser&&window.navigator&&(window.PointerEvent||window.navigator.pointerEnabled||window.navigator.msPointerEnabled))},isTouchDevice:function(){return this.isBrowser&&void 0!==window.ontouchstart},isAndroid:function(){return e.exists(navigator)&&navigator.userAgent.toLowerCase().indexOf("android")>-1},isWebkitAndroid:function(){return this.isAndroid()&&navigator.userAgent.indexOf(" AppleWebKit/")>-1},isApple:function(){return e.exists(navigator)&&(navigator.userAgent.indexOf("iPad")>-1||navigator.userAgent.indexOf("iPhone")>-1)},isWebkitApple:function(){return this.isApple()&&navigator.userAgent.search(/Mobile\/[0-9A-Za-z.]*Safari/)>-1},isMetroApp:function(){return"object"==typeof window&&window.clientInformation&&window.clientInformation.appVersion&&window.clientInformation.appVersion.indexOf("MSAppHost")>-1},isMozilla:function(){return e.exists(navigator)&&navigator.userAgent.toLowerCase().indexOf("mozilla")>-1&&-1===navigator.userAgent.toLowerCase().indexOf("apple")},isFirefoxOS:function(){return e.exists(navigator)&&-1===navigator.userAgent.toLowerCase().indexOf("android")&&-1===navigator.userAgent.toLowerCase().indexOf("apple")&&navigator.userAgent.toLowerCase().indexOf("mobile")>-1&&navigator.userAgent.toLowerCase().indexOf("mozilla")>-1},ieVersion:function(){var t,e,i=3;if("object"!=typeof document)return 0;e=(t=document.createElement("div")).getElementsByTagName("i");do{t.innerHTML="\x3c!--[if gt IE "+ ++i+"]><i></i><![endif]--\x3e"}while(e[0]);return i>4?i:void 0}(),getDimensions:function(t,i){var r,s,o,n,a,h,l,c,d,u=/\d+(\.\d*)?px/;if(!this.isBrowser||null===t)return{width:500,height:500};if(r=(i=i||document).getElementById(t),!e.exists(r))throw new Error("\nJSXGraph: HTML container element '"+t+"' not found.");return"none"!==(s=r.style.display)&&null!==s?r.clientWidth>0&&r.clientHeight>0?{width:r.clientWidth,height:r.clientHeight}:(d=window.getComputedStyle?window.getComputedStyle(r):r.style,{width:u.test(d.width)?parseFloat(d.width):0,height:u.test(d.height)?parseFloat(d.height):0}):(n=(o=r.style).visibility,a=o.position,h=o.display,o.visibility="hidden",o.position="absolute",o.display="block",l=r.clientWidth,c=r.clientHeight,o.display=h,o.position=a,o.visibility=n,{width:l,height:c})},addEvent:function(t,i,r,s){var o=function(){return r.apply(s,arguments)};o.origin=r,s["x_internal"+i]=s["x_internal"+i]||[],s["x_internal"+i].push(o),e.exists(t)&&e.exists(t.addEventListener)&&t.addEventListener(i,o,!1),e.exists(t)&&e.exists(t.attachEvent)&&t.attachEvent("on"+i,o)},removeEvent:function(i,r,s,o){var n;if(e.exists(o))if(e.exists(o["x_internal"+r]))if(e.isArray(o["x_internal"+r]))if(-1!==(n=e.indexOf(o["x_internal"+r],s,"origin"))){try{e.exists(i)&&e.exists(i.removeEventListener)&&i.removeEventListener(r,o["x_internal"+r][n],!1),e.exists(i)&&e.exists(i.detachEvent)&&i.detachEvent("on"+r,o["x_internal"+r][n])}catch(e){t.debug("event not registered in browser: ("+r+" -- "+s+")")}o["x_internal"+r].splice(n,1)}else t.debug("removeEvent: no such event function in internal list: "+s);else t.debug("owner[x_internal + "+r+"] is not an array");else t.debug("no such type: "+r);else t.debug("no such owner")},removeAllEvents:function(e,i,r){var s;if(r["x_internal"+i]){for(s=r["x_internal"+i].length-1;s>=0;s--)t.removeEvent(e,i,r["x_internal"+i][s].origin,r);r["x_internal"+i].length>0&&t.debug("removeAllEvents: Not all events could be removed.")}},getPosition:function(i,r,s){var o,n,a,h=0,l=0;if(i||(i=window.event),s=s||document,a=i[t.touchProperty],e.exists(a)&&0===a.length&&(a=i.changedTouches),e.exists(r)&&e.exists(a))if(-1===r){for(n=a.length,o=0;o<n;o++)if(a[o]){i=a[o];break}}else i=a[r];return i.clientX&&(h=i.clientX,l=i.clientY),[h,l]},getOffset:function(t){var e,i=t,r=t,s=i.offsetLeft-i.scrollLeft,o=i.offsetTop-i.scrollTop;for(s=(e=this.getCSSTransform([s,o],i))[0],o=e[1],i=i.offsetParent;i;){for(s+=i.offsetLeft,o+=i.offsetTop,i.offsetParent&&(s+=i.clientLeft-i.scrollLeft,o+=i.clientTop-i.scrollTop),s=(e=this.getCSSTransform([s,o],i))[0],o=e[1],r=r.parentNode;r!==i;)s+=r.clientLeft-r.scrollLeft,o+=r.clientTop-r.scrollTop,s=(e=this.getCSSTransform([s,o],r))[0],o=e[1],r=r.parentNode;i=i.offsetParent}return[s,o]},getStyle:function(e,i){var r,s=e.ownerDocument;return s.defaultView&&s.defaultView.getComputedStyle?r=s.defaultView.getComputedStyle(e,null).getPropertyValue(i):e.currentStyle&&t.ieVersion>=9?r=e.currentStyle[i]:e.style&&(i=i.replace(/-([a-z]|[0-9])/gi,(function(t,e){return e.toUpperCase()})),r=e.style[i]),r},getProp:function(t,e){var i=parseInt(this.getStyle(t,e),10);return isNaN(i)?0:i},getCSSTransform:function(t,i){var r,s,o,n,a,h,l,c=["transform","webkitTransform","MozTransform","msTransform","oTransform"];for(a=c.length,r=0,o="";r<a;r++)if(e.exists(i.style[c[r]])){o=i.style[c[r]];break}if(""!==o&&(n=o.indexOf("("))>0){for(a=o.length,s=0,h=(l=o.substring(n+1,a-1).split(",")).length;s<h;s++)l[s]=parseFloat(l[s]);0===o.indexOf("matrix")?(t[0]+=l[4],t[1]+=l[5]):0===o.indexOf("translateX")?t[0]+=l[0]:0===o.indexOf("translateY")?t[1]+=l[0]:0===o.indexOf("translate")&&(t[0]+=l[0],t[1]+=l[1])}return e.exists(i.style.zoom)&&""!==(o=i.style.zoom)&&(t[0]*=parseFloat(o),t[1]*=parseFloat(o)),t},getCSSTransformMatrix:function(t){var i,r,s,o,n,a,h,l,c=t.ownerDocument,d=["transform","webkitTransform","MozTransform","msTransform","oTransform"],u=[[1,0,0],[0,1,0],[0,0,1]];if(c.defaultView&&c.defaultView.getComputedStyle)s=(l=c.defaultView.getComputedStyle(t,null)).getPropertyValue("-webkit-transform")||l.getPropertyValue("-moz-transform")||l.getPropertyValue("-ms-transform")||l.getPropertyValue("-o-transform")||l.getPropertyValue("transform");else for(n=d.length,i=0,s="";i<n;i++)if(e.exists(t.style[d[i]])){s=t.style[d[i]];break}if(""!==s&&(o=s.indexOf("("))>0){for(n=s.length,r=0,a=(h=s.substring(o+1,n-1).split(",")).length;r<a;r++)h[r]=parseFloat(h[r]);0===s.indexOf("matrix")?u=[[1,0,0],[0,h[0],h[1]],[0,h[2],h[3]]]:0===s.indexOf("scaleX")?u[1][1]=h[0]:0===s.indexOf("scaleY")?u[2][2]=h[0]:0===s.indexOf("scale")&&(u[1][1]=h[0],u[2][2]=h[1])}return e.exists(t.style.zoom)&&""!==(s=t.style.zoom)&&(u[1][1]*=parseFloat(s),u[2][2]*=parseFloat(s)),u},timedChunk:function(t,e,i,r){var s=t.concat(),o=function(){var n=+new Date;do{e.call(i,s.shift())}while(s.length>0&&+new Date-n<300);s.length>0?window.setTimeout(o,1):r(t)};window.setTimeout(o,1)},_getScaleFactors:function(t){var e=t.getBoundingClientRect().width,i=t.getBoundingClientRect().height,r=window.screen.width/e,s=window.screen.height/i,o=.5*(window.screen.height-i),n=Math.min(r,s);return window.matchMedia&&window.matchMedia("(orientation:landscape)").matches&&window.screen.width<window.screen.height&&(r=window.screen.height/e,s=window.screen.width/i,n=Math.min(r,s),o=.5*(window.screen.width-i)),{scale:n*=.85,vshift:o,width:e}},scaleJSXGraphDiv:function(t,e,i,r){var s,o,n=document.styleSheets.length,a=[":fullscreen",":-webkit-full-screen",":-moz-full-screen",":-ms-fullscreen"],h=a.length,l="{margin:0 auto;transform:matrix("+i+",0,0,"+i+",0,"+r+");}",c=new RegExp(".*#"+t+":.*full.*screen.*#"+e+".*auto;.*transform:.*matrix");for(0===n&&((s=document.createElement("style")).appendChild(document.createTextNode("")),document.body.appendChild(s),n=document.styleSheets.length),document.styleSheets[n-1].cssRules.length>0&&c.test(document.styleSheets[n-1].cssRules[0].cssText)&&document.styleSheets[n-1].deleteRule&&document.styleSheets[n-1].deleteRule(0),o=0;o<h;o++)try{document.styleSheets[n-1].insertRule("#"+t+a[o]+" #"+e+l,0);break}catch(t){}o===h&&(console.log("JXG.scaleJSXGraphDiv: Could not add any CSS rule."),console.log("One possible reason could be that the id of the JSXGraph container does not start with a letter."))}}),t})),define("utils/xml",["jxg","utils/type"],(function(t,e){"use strict";return t.XML={cleanWhitespace:function(t){for(var i=t.firstChild;e.exists(i);)3!==i.nodeType||/\S/.test(i.nodeValue)?1===i.nodeType&&this.cleanWhitespace(i):t.removeChild(i),i=i.nextSibling},parse:function(t){var e,i;return i="function"==typeof DOMParser||"object"==typeof DOMParser?DOMParser:function(){this.parseFromString=function(t){var e;return"function"==typeof ActiveXObject&&(e=new ActiveXObject("MSXML.DomDocument")).loadXML(t),e}},e=(new i).parseFromString(t,"text/xml"),this.cleanWhitespace(e),e}},t.XML})),define("utils/event",["jxg","utils/type"],(function(t,e){"use strict";return t.EventEmitter={eventHandlers:{},suspended:{},trigger:function(t,e){var i,r,s,o,n,a;for(n=t.length,r=0;r<n;r++)if(o=this.eventHandlers[t[r]],!this.suspended[t[r]]){if(this.suspended[t[r]]=!0,o)for(a=o.length,i=0;i<a;i++)(s=o[i]).handler.apply(s.context,e);this.suspended[t[r]]=!1}return this},on:function(t,i,r){return e.isArray(this.eventHandlers[t])||(this.eventHandlers[t]=[]),r=e.def(r,this),this.eventHandlers[t].push({handler:i,context:r}),this},off:function(t,i){var r;return t&&e.isArray(this.eventHandlers[t])?(i?((r=e.indexOf(this.eventHandlers[t],i,"handler"))>-1&&this.eventHandlers[t].splice(r,1),0===this.eventHandlers[t].length&&delete this.eventHandlers[t]):delete this.eventHandlers[t],this):this},eventify:function(t){t.eventHandlers={},t.on=this.on,t.off=this.off,t.triggerEventHandlers=this.trigger,t.trigger=this.trigger,t.suspended={}}},t.EventEmitter})),define("math/math",["jxg","utils/type"],(function(t,e){"use strict";var i,r=function(t){var e,r;return t.memo||(e={},r=Array.prototype.join,t.memo=function(){var s=r.call(arguments);return e[s]!==i?e[s]:e[s]=t.apply(this,arguments)}),t.memo};return t.Math={eps:1e-6,relDif:function(t,e){var i=Math.abs(t),r=Math.abs(e);return 0===(r=Math.max(i,r))?0:Math.abs(t-e)/r},mod:function(t,e){return t-Math.floor(t/e)*e},vector:function(t,e){var i,r;for(e=e||0,i=[],r=0;r<t;r++)i[r]=e;return i},matrix:function(t,e,i){var r,s,o;for(i=i||0,e=e||t,r=[],s=0;s<t;s++)for(r[s]=[],o=0;o<e;o++)r[s][o]=i;return r},identity:function(t,e){var r,s;for(e===i&&"number"!=typeof e&&(e=t),r=this.matrix(t,e),s=0;s<Math.min(t,e);s++)r[s][s]=1;return r},frustum:function(t,e,i,r,s,o){var n=this.matrix(4,4);return n[0][0]=2*s/(e-t),n[0][1]=0,n[0][2]=(e+t)/(e-t),n[0][3]=0,n[1][0]=0,n[1][1]=2*s/(r-i),n[1][2]=(r+i)/(r-i),n[1][3]=0,n[2][0]=0,n[2][1]=0,n[2][2]=-(o+s)/(o-s),n[2][3]=-o*s*2/(o-s),n[3][0]=0,n[3][1]=0,n[3][2]=-1,n[3][3]=0,n},projection:function(t,e,i,r){var s=i*Math.tan(t/2),o=s*e;return this.frustum(-o,o,-s,s,i,r)},matVecMult:function(t,e){var i,r,s,o=t.length,n=e.length,a=[];if(3===n)for(i=0;i<o;i++)a[i]=t[i][0]*e[0]+t[i][1]*e[1]+t[i][2]*e[2];else for(i=0;i<o;i++){for(r=0,s=0;s<n;s++)r+=t[i][s]*e[s];a[i]=r}return a},matMatMult:function(t,e){var i,r,s,o,n=t.length,a=n>0?e[0].length:0,h=e.length,l=this.matrix(n,a);for(i=0;i<n;i++)for(r=0;r<a;r++){for(s=0,o=0;o<h;o++)s+=t[i][o]*e[o][r];l[i][r]=s}return l},transpose:function(t){var e,i,r,s,o;for(s=t.length,o=t.length>0?t[0].length:0,e=this.matrix(o,s),i=0;i<o;i++)for(r=0;r<s;r++)e[i][r]=t[r][i];return e},inverse:function(t){var e,i,r,s,o,n,a,h=t.length,l=[],c=[],d=[];for(e=0;e<h;e++){for(l[e]=[],i=0;i<h;i++)l[e][i]=t[e][i];c[e]=e}for(i=0;i<h;i++){for(o=Math.abs(l[i][i]),n=i,e=i+1;e<h;e++)Math.abs(l[e][i])>o&&(o=Math.abs(l[e][i]),n=e);if(o<=this.eps)return[];if(n>i){for(r=0;r<h;r++)a=l[i][r],l[i][r]=l[n][r],l[n][r]=a;a=c[i],c[i]=c[n],c[n]=a}for(s=1/l[i][i],e=0;e<h;e++)l[e][i]*=s;for(l[i][i]=s,r=0;r<h;r++)if(r!==i){for(e=0;e<h;e++)e!==i&&(l[e][r]-=l[e][i]*l[i][r]);l[i][r]=-s*l[i][r]}}for(e=0;e<h;e++){for(r=0;r<h;r++)d[c[r]]=l[e][r];for(r=0;r<h;r++)l[e][r]=d[r]}return l},innerProduct:function(t,r,s){var o,n=0;for(s!==i&&e.isNumber(s)||(s=t.length),o=0;o<s;o++)n+=t[o]*r[o];return n},crossProduct:function(t,e){return[t[1]*e[2]-t[2]*e[1],t[2]*e[0]-t[0]*e[2],t[0]*e[1]-t[1]*e[0]]},norm:function(t,r){var s,o=0;for(r!==i&&e.isNumber(r)||(r=t.length),s=0;s<r;s++)o+=t[s]*t[s];return Math.sqrt(o)},factorial:r((function(t){return t<0?NaN:0===(t=Math.floor(t))||1===t?1:t*this.factorial(t-1)})),binomial:r((function(t,e){var i,r;if(e>t||e<0)return NaN;if(e=Math.round(e),t=Math.round(t),0===e||e===t)return 1;for(i=1,r=0;r<e;r++)i*=t-r,i/=r+1;return i})),cosh:Math.cosh||function(t){return.5*(Math.exp(t)+Math.exp(-t))},sinh:Math.sinh||function(t){return.5*(Math.exp(t)-Math.exp(-t))},acosh:Math.acosh||function(t){return Math.log(t+Math.sqrt(t*t-1))},asinh:Math.asinh||function(t){return t===-1/0?t:Math.log(t+Math.sqrt(t*t+1))},cot:function(t){return 1/Math.tan(t)},acot:function(t){return(t>=0?.5:-.5)*Math.PI-Math.atan(t)},nthroot:function(t,e){var i=1/e;return e<=0||Math.floor(e)!==e?NaN:0===t?0:t>0?Math.exp(i*Math.log(t)):e%2==1?-Math.exp(i*Math.log(-t)):NaN},cbrt:Math.cbrt||function(t){return this.nthroot(t,3)},pow:function(t,e){return 0===t?0===e?1:0:Math.floor(e)===e?Math.pow(t,e):t>0?Math.exp(e*Math.log(t)):NaN},ratpow:function(t,e,i){var r;return 0===e?1:0===i?NaN:(r=this.gcd(e,i),this.nthroot(this.pow(t,e/r),i/r))},log10:function(t){return Math.log(t)/Math.log(10)},log2:function(t){return Math.log(t)/Math.log(2)},log:function(t,i){return void 0!==i&&e.isNumber(i)?Math.log(t)/Math.log(i):Math.log(t)},sign:Math.sign||function(t){return 0===(t=+t)||isNaN(t)?t:t>0?1:-1},squampow:function(t,e){var i;if(Math.floor(e)===e){for(i=1,e<0&&(t=1/t,e*=-1);0!==e;)1&e&&(i*=t),e>>=1,t*=t;return i}return this.pow(t,e)},gcd:function(t,i){if(t=Math.abs(t),i=Math.abs(i),!e.isNumber(t)||!e.isNumber(i))return NaN;if(i>t){var r=t;t=i,i=r}for(;;){if(0===(t%=i))return i;if(0===(i%=t))return t}},lcm:function(t,i){var r;return e.isNumber(t)&&e.isNumber(i)?0!==(r=t*i)?r/this.gcd(t,i):0:NaN},erf:function(t){return this.ProbFuncs.erf(t)},erfc:function(t){return this.ProbFuncs.erfc(t)},erfi:function(t){return this.ProbFuncs.erfi(t)},ndtr:function(t){return this.ProbFuncs.ndtr(t)},ndtri:function(t){return this.ProbFuncs.ndtri(t)},lt:function(t,e){return t<e},leq:function(t,e){return t<=e},gt:function(t,e){return t>e},geq:function(t,e){return t>=e},eq:function(t,e){return t===e},neq:function(t,e){return t!==e},and:function(t,e){return t&&e},not:function(t){return!t},or:function(t,e){return t||e},xor:function(t,e){return(t||e)&&!(t&&e)},normalize:function(t){var e,i,r=2*t[3],s=t[4]/r;return t[5]=s,t[6]=-t[1]/r,t[7]=-t[2]/r,isFinite(s)?Math.abs(s)>=1?(t[0]=(t[6]*t[6]+t[7]*t[7]-s*s)/(2*s),t[1]=-t[6]/s,t[2]=-t[7]/s,t[3]=1/(2*s),t[4]=1):(i=s<=0?-1:1,t[0]=i*(t[6]*t[6]+t[7]*t[7]-s*s)*.5,t[1]=-i*t[6],t[2]=-i*t[7],t[3]=i/2,t[4]=i*s):(e=Math.sqrt(t[1]*t[1]+t[2]*t[2]),t[0]/=e,t[1]/=e,t[2]/=e,t[3]=0,t[4]=1),t},toGL:function(t){var e,i,r;if(e="function"==typeof Float32Array?new Float32Array(16):new Array(16),4!==t.length&&4!==t[0].length)return e;for(i=0;i<4;i++)for(r=0;r<4;r++)e[i+4*r]=t[i][r];return e},Vieta:function(t){var e,i,r,s=t.length,o=[];for(o=t.slice(),e=1;e<s;++e){for(r=o[e],o[e]*=o[e-1],i=e-1;i>=1;--i)o[i]+=o[i-1]*r;o[0]+=r}return o}},t.Math})),define("base/coords",["jxg","base/constants","utils/event","utils/type","math/math"],(function(t,e,i,r,s){"use strict";return t.Coords=function(t,e,s,o){this.board=s,this.usrCoords=[],this.scrCoords=[],this.emitter=!r.exists(o)||o,this.emitter&&i.eventify(this),this.setCoordinates(t,e,!1,!0)},t.extend(t.Coords.prototype,{normalizeUsrCoords:function(){Math.abs(this.usrCoords[0])>s.eps&&(this.usrCoords[1]/=this.usrCoords[0],this.usrCoords[2]/=this.usrCoords[0],this.usrCoords[0]=1)},usr2screen:function(t){var e=Math.round,i=this.board,r=this.usrCoords,s=i.origin.scrCoords;!0===t?(this.scrCoords[0]=e(r[0]),this.scrCoords[1]=e(r[0]*s[1]+r[1]*i.unitX),this.scrCoords[2]=e(r[0]*s[2]-r[2]*i.unitY)):(this.scrCoords[0]=r[0],this.scrCoords[1]=r[0]*s[1]+r[1]*i.unitX,this.scrCoords[2]=r[0]*s[2]-r[2]*i.unitY)},screen2usr:function(){var t=this.board.origin.scrCoords,e=this.scrCoords,i=this.board;this.usrCoords[0]=1,this.usrCoords[1]=(e[1]-t[1])/i.unitX,this.usrCoords[2]=(t[2]-e[2])/i.unitY},distance:function(t,i){var r,o,n=0,a=this.usrCoords,h=this.scrCoords;if(t===e.COORDS_BY_USER){if(r=i.usrCoords,(n=(o=a[0]-r[0])*o)>s.eps*s.eps)return Number.POSITIVE_INFINITY;n+=(o=a[1]-r[1])*o,n+=(o=a[2]-r[2])*o}else r=i.scrCoords,n+=(o=h[1]-r[1])*o,n+=(o=h[2]-r[2])*o;return Math.sqrt(n)},setCoordinates:function(t,i,r,s){var o=this.usrCoords,n=this.scrCoords,a=[o[0],o[1],o[2]],h=[n[0],n[1],n[2]];return t===e.COORDS_BY_USER?(2===i.length?(o[0]=1,o[1]=i[0],o[2]=i[1]):(o[0]=i[0],o[1]=i[1],o[2]=i[2],this.normalizeUsrCoords()),this.usr2screen(r)):(2===i.length?(n[1]=i[0],n[2]=i[1]):(n[1]=i[1],n[2]=i[2]),this.screen2usr()),!this.emitter||s||h[1]===n[1]&&h[2]===n[2]||this.triggerEventHandlers(["update"],[a,h]),this},copy:function(t,e){return void 0===e&&(e=0),this[t].slice(e)},isReal:function(){return!isNaN(this.usrCoords[1]+this.usrCoords[2])&&Math.abs(this.usrCoords[0])>s.eps},__evt__update:function(t,e){},__evt:function(){}}),t.Coords})),define("utils/expect",["jxg","utils/type","base/constants","base/coords"],(function(t,e,i,r){"use strict";var s={each:function(t,i,r){var s,o,n=[];if(e.exists(t.length))for(o=t.length,s=0;s<o;s++)n.push(i.call(this,t[s],r));return n},coords:function(t,e){var s=t;return t&&t.elementClass===i.OBJECT_CLASS_POINT?s=t.coords:t.usrCoords&&t.scrCoords&&t.usr2screen&&(s=t),e&&(s=new r(i.COORDS_BY_USER,s.usrCoords,s.board)),s},coordsArray:function(t,i){var r;return(r=e.isArray(t)?t:this.coords(t).usrCoords).length<3&&r.unshift(1),i&&(r=[r[0],r[1],r[2]]),r}};return t.Expect=s,s})),define("math/probfuncs",["math/math","utils/type"],(function(t,e){"use strict";return t.ProbFuncs={MAXNUM:17014118346046923e22,SQRTH:.7071067811865476,SQRT2:1.4142135623730951,MAXLOG:708.3964185322641,P:[2.461969814735305e-10,.5641895648310689,7.463210564422699,48.63719709856814,196.5208329560771,526.4451949954773,934.5285271719576,1027.5518868951572,557.5353353693994],Q:[13.228195115474499,86.70721408859897,354.9377788878199,975.7085017432055,1823.9091668790973,2246.3376081871097,1656.6630919416134,557.5353408177277],R:[.5641895835477551,1.275366707599781,5.019050422511805,6.160210979930536,7.4097426995044895,2.9788666537210022],S:[2.2605286322011726,9.396035249380015,12.048953980809666,17.08144507475659,9.608968090632859,3.369076451000815],T:[9.604973739870516,90.02601972038427,2232.005345946843,7003.325141128051,55592.30130103949],U:[33.56171416475031,521.3579497801527,4594.323829709801,22629.000061389095,49267.39426086359],M:128,MINV:.0078125,expx2:function(t,e){var i,r,s,o;return t=Math.abs(t),e<0&&(t=-t),i=(s=this.MINV*Math.floor(this.M*t+.5))*s,r=2*s*(o=t-s)+o*o,e<0&&(i=-i,r=-r),i+r>this.MAXLOG?1/0:i=Math.exp(i)*Math.exp(r)},polevl:function(t,i,r){var s,o;if(e.exists(i.reduce))return i.reduce((function(e,i){return e*t+i}),0);for(o=0,s=0;o<=r;o++)s=s*t+i[o];return s},p1evl:function(t,i,r){var s,o;if(e.exists(i.reduce))return i.reduce((function(e,i){return e*t+i}),1);for(o=0,s=1;o<r;o++)s=s*t+i[o];return s},ndtr:function(t){var e,i,r;return e=t*this.SQRTH,(r=Math.abs(e))<1?i=.5+.5*this.erf(e):(i=.5*this.erfce(r),r=this.expx2(t,-1),i*=Math.sqrt(r),e>0&&(i=1-i)),i},_underflow:function(t){return console.log("erfc","UNDERFLOW"),t<0?2:0},erfc:function(t){var e,i,r,s,o;return(r=t<0?-t:t)<1?1-this.erf(t):(o=-t*t)<-this.MAXLOG?this._underflow(t):(o=this.expx2(t,-1),r<8?(e=this.polevl(r,this.P,8),i=this.p1evl(r,this.Q,8)):(e=this.polevl(r,this.R,5),i=this.p1evl(r,this.S,6)),s=o*e/i,t<0&&(s=2-s),0===s?this._underflow(t):s)},erfce:function(t){var e,i;return t<8?(e=this.polevl(t,this.P,8),i=this.p1evl(t,this.Q,8)):(e=this.polevl(t,this.R,5),i=this.p1evl(t,this.S,6)),e/i},erf:function(t){var e;return Math.abs(t)>1?1-this.erfc(t):(e=t*t,t*this.polevl(e,this.T,4)/this.p1evl(e,this.U,5))},s2pi:2.5066282746310007,P0:[-59.96335010141079,98.00107541859997,-56.67628574690703,13.931260938727968,-1.2391658386738125],Q0:[1.9544885833814176,4.676279128988815,86.36024213908905,-225.46268785411937,200.26021238006066,-82.03722561683334,15.90562251262117,-1.1833162112133],P1:[4.0554489230596245,31.525109459989388,57.16281922464213,44.08050738932008,14.684956192885803,2.1866330685079025,-.1402560791713545,-.03504246268278482,-.0008574567851546854],Q1:[15.779988325646675,45.39076351288792,41.3172038254672,15.04253856929075,2.504649462083094,-.14218292285478779,-.03808064076915783,-.0009332594808954574],P2:[3.2377489177694603,6.915228890689842,3.9388102529247444,1.3330346081580755,.20148538954917908,.012371663481782003,.00030158155350823543,26580697468673755e-22,6.239745391849833e-9],Q2:[6.02427039364742,3.6798356385616087,1.3770209948908132,.21623699359449663,.013420400608854318,.00032801446468212774,28924786474538068e-22,6.790194080099813e-9],ndtri:function(t){var e,i,r,s,o;return t<=0?-1/0:t>=1?1/0:(o=1,(i=t)>.8646647167633873&&(i=1-i,o=0),i>.1353352832366127?(e=(i-=.5)+i*((s=i*i)*this.polevl(s,this.P0,4)/this.p1evl(s,this.Q0,8)),e*=this.s2pi):(r=1/(e=Math.sqrt(-2*Math.log(i))),e=e-Math.log(e)/e-(e<8?r*this.polevl(r,this.P1,8)/this.p1evl(r,this.Q1,8):r*this.polevl(r,this.P2,8)/this.p1evl(r,this.Q2,8)),0!==o&&(e=-e),e))},erfi:function(t){return this.ndtri(.5*(t+1))*this.SQRTH}},t.ProbFuncs})),define("math/ia",["jxg","math/math","utils/type"],(function(t,e,i){"use strict";t.Math.DoubleBits=function(){var t,e,i,r,s,o,n,a,h=new Float64Array(1),l=new Uint32Array(h.buffer);void 0!==Float64Array&&(h[0]=1,!0,1072693248===l[1]?(t=function(t){return h[0]=t,[l[0],l[1]]},e=function(t,e){return l[0]=t,l[1]=e,h[0]},i=function(t){return h[0]=t,l[0]},r=function(t){return h[0]=t,l[1]},this.doubleBits=t,this.pack=e,this.lo=i,this.hi=r):1072693248===l[0]&&(s=function(t){return h[0]=t,[l[1],l[0]]},o=function(t,e){return l[1]=t,l[0]=e,h[0]},n=function(t){return h[0]=t,l[1]},a=function(t){return h[0]=t,l[0]},this.doubleBits=s,this.pack=o,this.lo=n,this.hi=a))},t.extend(t.Math.DoubleBits.prototype,{sign:function(t){return this.hi(t)>>>31},exponent:function(t){return(this.hi(t)<<1>>>21)-1023},fraction:function(t){var e=this.lo(t),i=this.hi(t),r=1048575&i;return 2146435072&i&&(r+=1<<20),[e,r]},denormalized:function(t){return!(2146435072&this.hi(t))}});var r=new t.Math.DoubleBits,s=function(t,i){if(void 0!==t&&void 0!==i){if(e.IntervalArithmetic.isInterval(t)){if(!e.IntervalArithmetic.isSingleton(t))throw new TypeError("JXG.Math.IntervalArithmetic: interval `lo` must be a singleton");this.lo=t.lo}else this.lo=t;if(e.IntervalArithmetic.isInterval(i)){if(!e.IntervalArithmetic.isSingleton(i))throw new TypeError("JXG.Math.IntervalArithmetic: interval `hi` must be a singleton");this.hi=i.hi}else this.hi=i}else{if(void 0!==t)return Array.isArray(t)?new s(t[0],t[1]):new s(t,t);this.lo=this.hi=0}};return t.extend(s.prototype,{print:function(){console.log("[",this.lo,this.hi,"]")},set:function(t,e){return this.lo=t,this.hi=e,this},bounded:function(t,i){return this.set(e.IntervalArithmetic.prev(t),e.IntervalArithmetic.next(i))},boundedSingleton:function(t){return this.bounded(t,t)},assign:function(t,e){if("number"!=typeof t||"number"!=typeof e)throw new TypeError("JXG.Math.Interval#assign: arguments must be numbers");return isNaN(t)||isNaN(e)||t>e?this.setEmpty():this.set(t,e)},setEmpty:function(){return this.set(Number.POSITIVE_INFINITY,Number.NEGATIVE_INFINITY)},setWhole:function(){return this.set(Number.NEGATIVE_INFINITY,Number.POSITIVE_INFINITY)},open:function(t,i){return this.assign(e.IntervalArithmetic.next(t),e.IntervalArithmetic.prev(i))},halfOpenLeft:function(t,i){return this.assign(e.IntervalArithmetic.next(t),i)},halfOpenRight:function(t,i){return this.assign(t,e.IntervalArithmetic.prev(i))},toArray:function(){return[this.lo,this.hi]},clone:function(){return(new s).set(this.lo,this.hi)}}),t.Math.IntervalArithmetic={Interval:function(t,e){return new s(t,e)},isInterval:function(t){return null!==t&&"object"==typeof t&&"number"==typeof t.lo&&"number"==typeof t.hi},isSingleton:function(t){return t.lo===t.hi},add:function(t,e){return i.isNumber(t)&&(t=this.Interval(t)),i.isNumber(e)&&(e=this.Interval(e)),new s(this.addLo(t.lo,e.lo),this.addHi(t.hi,e.hi))},sub:function(t,e){return i.isNumber(t)&&(t=this.Interval(t)),i.isNumber(e)&&(e=this.Interval(e)),new s(this.subLo(t.lo,e.hi),this.subHi(t.hi,e.lo))},mul:function(t,e){var r,o,n,a,h;return i.isNumber(t)&&(t=this.Interval(t)),i.isNumber(e)&&(e=this.Interval(e)),this.isEmpty(t)||this.isEmpty(e)?this.EMPTY.clone():(r=t.lo,o=t.hi,n=e.lo,a=e.hi,h=new s,r<0?o>0?n<0?a>0?(h.lo=Math.min(this.mulLo(r,a),this.mulLo(o,n)),h.hi=Math.max(this.mulHi(r,n),this.mulHi(o,a))):(h.lo=this.mulLo(o,n),h.hi=this.mulHi(r,n)):a>0?(h.lo=this.mulLo(r,a),h.hi=this.mulHi(o,a)):(h.lo=0,h.hi=0):n<0?a>0?(h.lo=this.mulLo(r,a),h.hi=this.mulHi(r,n)):(h.lo=this.mulLo(o,a),h.hi=this.mulHi(r,n)):a>0?(h.lo=this.mulLo(r,a),h.hi=this.mulHi(o,n)):(h.lo=0,h.hi=0):o>0?n<0?a>0?(h.lo=this.mulLo(o,n),h.hi=this.mulHi(o,a)):(h.lo=this.mulLo(o,n),h.hi=this.mulHi(r,a)):a>0?(h.lo=this.mulLo(r,n),h.hi=this.mulHi(o,a)):(h.lo=0,h.hi=0):(h.lo=0,h.hi=0),h)},div:function(t,e){return i.isNumber(t)&&(t=this.Interval(t)),i.isNumber(e)&&(e=this.Interval(e)),this.isEmpty(t)||this.isEmpty(e)?this.EMPTY.clone():this.zeroIn(e)?0!==e.lo?0!==e.hi?this.divZero(t):this.divNegative(t,e.lo):0!==e.hi?this.divPositive(t,e.hi):this.EMPTY.clone():this.divNonZero(t,e)},positive:function(t){return new s(t.lo,t.hi)},negative:function(t){return i.isNumber(t)?new s(-t):new s(-t.hi,-t.lo)},isEmpty:function(t){return t.lo>t.hi},isWhole:function(t){return t.lo===-1/0&&t.hi===1/0},zeroIn:function(t){return this.hasValue(t,0)},hasValue:function(t,e){return!this.isEmpty(t)&&(t.lo<=e&&e<=t.hi)},hasInterval:function(t,e){return!!this.isEmpty(t)||!this.isEmpty(e)&&e.lo<=t.lo&&t.hi<=e.hi},intervalsOverlap:function(t,e){return!this.isEmpty(t)&&!this.isEmpty(e)&&(t.lo<=e.lo&&e.lo<=t.hi||e.lo<=t.lo&&t.lo<=e.hi)},divNonZero:function(t,e){var i=t.lo,r=t.hi,o=e.lo,n=e.hi,a=new s;return r<0?n<0?(a.lo=this.divLo(r,o),a.hi=this.divHi(i,n)):(a.lo=this.divLo(i,o),a.hi=this.divHi(r,n)):i<0?n<0?(a.lo=this.divLo(r,n),a.hi=this.divHi(i,n)):(a.lo=this.divLo(i,o),a.hi=this.divHi(r,o)):n<0?(a.lo=this.divLo(r,n),a.hi=this.divHi(i,o)):(a.lo=this.divLo(i,n),a.hi=this.divHi(r,o)),a},divPositive:function(t,e){return 0===t.lo&&0===t.hi?t:this.zeroIn(t)?this.WHOLE:t.hi<0?new s(Number.NEGATIVE_INFINITY,this.divHi(t.hi,e)):new s(this.divLo(t.lo,e),Number.POSITIVE_INFINITY)},divNegative:function(t,e){return 0===t.lo&&0===t.hi?t:this.zeroIn(t)?this.WHOLE:t.hi<0?new s(this.divLo(t.hi,e),Number.POSITIVE_INFINITY):new s(Number.NEGATIVE_INFINITY,this.divHi(t.lo,e))},divZero:function(t){return 0===t.lo&&0===t.hi?t:this.WHOLE},fmod:function(t,e){var r,o;return i.isNumber(t)&&(t=this.Interval(t)),i.isNumber(e)&&(e=this.Interval(e)),this.isEmpty(t)||this.isEmpty(e)?this.EMPTY.clone():(r=t.lo<0?e.lo:e.hi,o=(o=t.lo/r)<0?Math.ceil(o):Math.floor(o),this.sub(t,this.mul(e,new s(o))))},multiplicativeInverse:function(t){return i.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)?this.EMPTY.clone():this.zeroIn(t)?0!==t.lo?0!==t.hi?this.WHOLE:new s(Number.NEGATIVE_INFINITY,this.divHi(1,t.lo)):0!==t.hi?new s(this.divLo(1,t.hi),Number.POSITIVE_INFINITY):this.EMPTY.clone():new s(this.divLo(1,t.hi),this.divHi(1,t.lo))},pow:function(t,e){var r,o;if(i.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t))return this.EMPTY.clone();if(this.isInterval(e)){if(!this.isSingleton(e))return this.EMPTY.clone();e=e.lo}return 0===e?0===t.lo&&0===t.hi?this.EMPTY.clone():this.ONE.clone():e<0?this.pow(this.multiplicativeInverse(t),-e):e%1==0?t.hi<0?(r=this.powLo(-t.hi,e),o=this.powHi(-t.lo,e),1==(1&e)?new s(-o,-r):new s(r,o)):t.lo<0?1==(1&e)?new s(-this.powLo(-t.lo,e),this.powHi(t.hi,e)):new s(0,this.powHi(Math.max(-t.lo,t.hi),e)):new s(this.powLo(t.lo,e),this.powHi(t.hi,e)):(console.warn("power is not an integer, you should use nth-root instead, returning an empty interval"),this.EMPTY.clone())},sqrt:function(t){return i.isNumber(t)&&(t=this.Interval(t)),this.nthRoot(t,2)},nthRoot:function(t,e){var r,o,n,a,h;if(i.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)||e<0)return this.EMPTY.clone();if(this.isInterval(e)){if(!this.isSingleton(e))return this.EMPTY.clone();e=e.lo}return r=1/e,t.hi<0?e%1==0&&1==(1&e)?(o=this.powHi(-t.lo,r),n=this.powLo(-t.hi,r),new s(-o,-n)):this.EMPTY.clone():t.lo<0?(a=this.powHi(t.hi,r),e%1==0&&1==(1&e)?(h=-this.powHi(-t.lo,r),new s(h,a)):new s(0,a)):new s(this.powLo(t.lo,r),this.powHi(t.hi,r))},exp:function(t){return i.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)?this.EMPTY.clone():new s(this.expLo(t.lo),this.expHi(t.hi))},log:function(t){var e;return i.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)?this.EMPTY.clone():(e=t.lo<=0?Number.NEGATIVE_INFINITY:this.logLo(t.lo),new s(e,this.logHi(t.hi)))},ln:function(t){return this.log(t)},log10:function(t){return this.isEmpty(t)?this.EMPTY.clone():this.div(this.log(t),this.log(new s(10,10)))},log2:function(t){return this.isEmpty(t)?this.EMPTY.clone():this.div(this.log(t),this.log(new s(2,2)))},hull:function(t,e){var i=this.isEmpty(t),r=this.isEmpty(e);return i&&r?this.EMPTY.clone():i?e.clone():r?t.clone():new s(Math.min(t.lo,e.lo),Math.max(t.hi,e.hi))},intersection:function(t,e){var i,r;return this.isEmpty(t)||this.isEmpty(e)?this.EMPTY.clone():(i=Math.max(t.lo,e.lo))<=(r=Math.min(t.hi,e.hi))?new s(i,r):this.EMPTY.clone()},union:function(t,e){if(!this.intervalsOverlap(t,e))throw new Error("Interval#unions do not overlap");return new s(Math.min(t.lo,e.lo),Math.max(t.hi,e.hi))},difference:function(t,e){if(this.isEmpty(t)||this.isWhole(e))return this.EMPTY.clone();if(this.intervalsOverlap(t,e)){if(t.lo<e.lo&&e.hi<t.hi)throw new Error("Interval.difference: difference creates multiple intervals");return e.lo<=t.lo&&e.hi===1/0||e.hi>=t.hi&&e.lo===-1/0?this.EMPTY.clone():e.lo<=t.lo?(new s).halfOpenLeft(e.hi,t.hi):(new s).halfOpenRight(t.lo,e.lo)}return t.clone()},width:function(t){return this.isEmpty(t)?0:this.subHi(t.hi,t.lo)},abs:function(t){return i.isNumber(t)&&(t=this.Interval(t)),this.isEmpty(t)?this.EMPTY.clone():t.lo>=0?t.clone():t.hi<=0?this.negative(t):new s(0,Math.max(-t.lo,t.hi))},max:function(t,e){var i=this.isEmpty(t),r=this.isEmpty(e);return i&&r?this.EMPTY.clone():i?e.clone():r?t.clone():new s(Math.max(t.lo,e.lo),Math.max(t.hi,e.hi))},min:function(t,e){var i=this.isEmpty(t),r=this.isEmpty(e);return i&&r?this.EMPTY.clone():i?e.clone():r?t.clone():new s(Math.min(t.lo,e.lo),Math.min(t.hi,e.hi))},onlyInfinity:function(t){return!isFinite(t.lo)&&t.lo===t.hi},_handleNegative:function(t){var e;return t.lo<0&&(t.lo===-1/0?(t.lo=0,t.hi=1/0):(e=Math.ceil(-t.lo/this.piTwiceLow),t.lo+=this.piTwiceLow*e,t.hi+=this.piTwiceLow*e)),t},cos:function(t){var e,i,r,o,n,a,h,l;return this.isEmpty(t)||this.onlyInfinity(t)?this.EMPTY.clone():(e=(new s).set(t.lo,t.hi),this._handleNegative(e),i=this.PI_TWICE,r=this.fmod(e,i),this.width(r)>=i.lo?new s(-1,1):r.lo>=this.piHigh?(o=this.cos(this.sub(r,this.PI)),this.negative(o)):(n=r.lo,a=r.hi,h=this.cosLo(a),l=this.cosHi(n),a<=this.piLow?new s(h,l):a<=i.lo?new s(-1,Math.max(h,l)):new s(-1,1)))},sin:function(t){return this.isEmpty(t)||this.onlyInfinity(t)?this.EMPTY.clone():this.cos(this.sub(t,this.PI_HALF))},tan:function(t){var e,i,r;return this.isEmpty(t)||this.onlyInfinity(t)?this.EMPTY.clone():(e=(new s).set(t.lo,t.hi),this._handleNegative(e),r=this.PI,(i=this.fmod(e,r)).lo>=this.piHalfLow&&(i=this.sub(i,r)),i.lo<=-this.piHalfLow||i.hi>=this.piHalfLow?this.WHOLE.clone():new s(this.tanLo(i.lo),this.tanHi(i.hi)))},asin:function(t){var e,i;return this.isEmpty(t)||t.hi<-1||t.lo>1?this.EMPTY.clone():(e=t.lo<=-1?-this.piHalfHigh:this.asinLo(t.lo),i=t.hi>=1?this.piHalfHigh:this.asinHi(t.hi),new s(e,i))},acos:function(t){var e,i;return this.isEmpty(t)||t.hi<-1||t.lo>1?this.EMPTY.clone():(e=t.hi>=1?0:this.acosLo(t.hi),i=t.lo<=-1?this.piHigh:this.acosHi(t.lo),new s(e,i))},atan:function(t){return this.isEmpty(t)?this.EMPTY.clone():new s(this.atanLo(t.lo),this.atanHi(t.hi))},sinh:function(t){return this.isEmpty(t)?this.EMPTY.clone():new s(this.sinhLo(t.lo),this.sinhHi(t.hi))},cosh:function(t){return this.isEmpty(t)?this.EMPTY.clone():t.hi<0?new s(this.coshLo(t.hi),this.coshHi(t.lo)):t.lo>=0?new s(this.coshLo(t.lo),this.coshHi(t.hi)):new s(1,this.coshHi(-t.lo>t.hi?t.lo:t.hi))},tanh:function(t){return this.isEmpty(t)?this.EMPTY.clone():new s(this.tanhLo(t.lo),this.tanhHi(t.hi))},equal:function(t,e){return this.isEmpty(t)?this.isEmpty(e):!this.isEmpty(e)&&t.lo===e.lo&&t.hi===e.hi},notEqual:function(t,e){return this.isEmpty(t)?!this.isEmpty(e):this.isEmpty(e)||t.hi<e.lo||t.lo>e.hi},lt:function(t,e){return i.isNumber(t)&&(t=this.Interval(t)),i.isNumber(e)&&(e=this.Interval(e)),!this.isEmpty(t)&&!this.isEmpty(e)&&t.hi<e.lo},gt:function(t,e){return i.isNumber(t)&&(t=this.Interval(t)),i.isNumber(e)&&(e=this.Interval(e)),!this.isEmpty(t)&&!this.isEmpty(e)&&t.lo>e.hi},leq:function(t,e){return i.isNumber(t)&&(t=this.Interval(t)),i.isNumber(e)&&(e=this.Interval(e)),!this.isEmpty(t)&&!this.isEmpty(e)&&t.hi<=e.lo},geq:function(t,e){return i.isNumber(t)&&(t=this.Interval(t)),i.isNumber(e)&&(e=this.Interval(e)),!this.isEmpty(t)&&!this.isEmpty(e)&&t.lo>=e.hi},piLow:3.141592653589793,piHigh:3.1415926535897936,piHalfLow:1.5707963267948966,piHalfHigh:1.5707963267948968,piTwiceLow:6.283185307179586,piTwiceHigh:6.283185307179587,identity:function(t){return t},_prev:function(t){return t===1/0?t:this.nextafter(t,-1/0)},_next:function(t){return t===-1/0?t:this.nextafter(t,1/0)},prev:function(t){return this._prev(t)},next:function(t){return this._next(t)},toInteger:function(t){return t<0?Math.ceil(t):Math.floor(t)},addLo:function(t,e){return this.prev(t+e)},addHi:function(t,e){return this.next(t+e)},subLo:function(t,e){return this.prev(t-e)},subHi:function(t,e){return this.next(t-e)},mulLo:function(t,e){return this.prev(t*e)},mulHi:function(t,e){return this.next(t*e)},divLo:function(t,e){return this.prev(t/e)},divHi:function(t,e){return this.next(t/e)},intLo:function(t){return this.toInteger(this.prev(t))},intHi:function(t){return this.toInteger(this.next(t))},logLo:function(t){return this.prev(Math.log(t))},logHi:function(t){return this.next(Math.log(t))},expLo:function(t){return this.prev(Math.exp(t))},expHi:function(t){return this.next(Math.exp(t))},sinLo:function(t){return this.prev(Math.sin(t))},sinHi:function(t){return this.next(Math.sin(t))},cosLo:function(t){return this.prev(Math.cos(t))},cosHi:function(t){return this.next(Math.cos(t))},tanLo:function(t){return this.prev(Math.tan(t))},tanHi:function(t){return this.next(Math.tan(t))},asinLo:function(t){return this.prev(Math.asin(t))},asinHi:function(t){return this.next(Math.asin(t))},acosLo:function(t){return this.prev(Math.acos(t))},acosHi:function(t){return this.next(Math.acos(t))},atanLo:function(t){return this.prev(Math.atan(t))},atanHi:function(t){return this.next(Math.atan(t))},sinhLo:function(t){return this.prev(e.sinh(t))},sinhHi:function(t){return this.next(e.sinh(t))},coshLo:function(t){return this.prev(e.cosh(t))},coshHi:function(t){return this.next(e.cosh(t))},tanhLo:function(t){return this.prev(e.tanh(t))},tanhHi:function(t){return this.next(e.tanh(t))},sqrtLo:function(t){return this.prev(Math.sqrt(t))},sqrtHi:function(t){return this.next(Math.sqrt(t))},powLo:function(t,e){var i;if(e%1!=0)return this.prev(Math.pow(t,e));for(i=1==(1&e)?t:1,e>>=1;e>0;)t=this.mulLo(t,t),1==(1&e)&&(i=this.mulLo(t,i)),e>>=1;return i},powHi:function(t,e){var i;if(e%1!=0)return this.next(Math.pow(t,e));for(i=1==(1&e)?t:1,e>>=1;e>0;)t=this.mulHi(t,t),1==(1&e)&&(i=this.mulHi(t,i)),e>>=1;return i},disable:function(){this.next=this.prev=this.identity},enable:function(){this.prev=function(t){return this._prev(t)},this.next=function(t){return this._next(t)}},SMALLEST_DENORM:Math.pow(2,-1074),UINT_MAX:-1>>>0,nextafter:function(t,e){var i,s;return isNaN(t)||isNaN(e)?NaN:t===e?t:0===t?e<0?-this.SMALLEST_DENORM:this.SMALLEST_DENORM:(s=r.hi(t),i=r.lo(t),e>t==t>0?i===this.UINT_MAX?(s+=1,i=0):i+=1:0===i?(i=this.UINT_MAX,s-=1):i-=1,r.pack(i,s))}},t.Math.IntervalArithmetic.PI=new s(e.IntervalArithmetic.piLow,e.IntervalArithmetic.piHigh),t.Math.IntervalArithmetic.PI_HALF=new s(e.IntervalArithmetic.piHalfLow,e.IntervalArithmetic.piHalfHigh),t.Math.IntervalArithmetic.PI_TWICE=new s(e.IntervalArithmetic.piTwiceLow,e.IntervalArithmetic.piTwiceHigh),t.Math.IntervalArithmetic.ZERO=new s(0),t.Math.IntervalArithmetic.ONE=new s(1),t.Math.IntervalArithmetic.WHOLE=(new s).setWhole(),t.Math.IntervalArithmetic.EMPTY=(new s).setEmpty(),t.Math.IntervalArithmetic})),define("math/extrapolate",["math/math"],(function(t){"use strict";return t.Extrapolate={upper:15,infty:1e4,wynnEps:function(t,e,i){var r,s,o,n,a;if(i[e]=t,0===e)a=t;else{for(o=0,r=e;r>0;r--)s=o,o=i[r-1],n=i[r]-o,Math.abs(n)<=1e-15?i[r-1]=1e20:(1,i[r-1]=1*s+1/n);a=i[e%2]}return a},aitken:function(t,e,i){var r,s,o,n,a,h;if(i[e]=t,e<2)r=t;else{for(n=e/2,a=1;a<=n;a++)s=i[(h=e-2*a)+2]-2*i[h+1]+i[h],Math.abs(s)<1e-15?i[h]=1e20:(o=i[h]-i[h+1],i[h]-=o*o/s);r=i[e%2]}return r},brezinski:function(t,e,i){var r,s,o,n,a,h,l,c;if(i[e]=t,e<3)r=t;else{for(h=e/3,c=e,l=1;l<=h;l++)o=i[(c-=3)+1]-i[c],n=i[c+2]-i[c+1],s=(a=i[c+3]-i[c+2])*(n-o)-o*(a-n),Math.abs(s)<1e-15?i[c]=1e20:i[c]=i[c+1]-o*n*(a-n)/s;r=i[e%3]}return r},iteration:function(t,e,i,r,s){var o,n,a,h,l=NaN,c=[],d="finite",u=e;for(s=s||0,o=1;o<=this.upper;o++){if(n=i(t+(u=0===s?e/(o+1):.5*u),!0),a=this[r](n,o-1,c),isNaN(a)){d="NaN";break}if(0!==n&&a/n>this.infty){l=a,d="infinite";break}if(h=a-l,Math.abs(h)<1e-7)break;l=a}return[l,d,1-(o-1)/this.upper]},levin:function(t,e,i,r,s,o){var n,a,h,l;if(l=1/(r+e),s[e]=t/i,o[e]=1/i,e>0&&(s[e-1]=s[e]-s[e-1],o[e-1]=o[e]-o[e-1],e>1))for(h=(r+e-1)*l,n=2;n<=e;n++)a=(r+e-n)*Math.pow(h,n-2)*l,s[e-n]=s[e-n+1]-a*s[e-n],o[e-n]=o[e-n+1]-a*o[e-n],l*=h;return Math.abs(o[0])<1e-15?1e20:s[0]/o[0]},iteration_levin:function(t,e,i,r){var s,o,n,a,h,l,c,d=NaN,u=[],p=[],f="finite",m=e;for(r=r||0,a=i(t+e,!0),s=1;s<=this.upper;s++){if(h=(o=i(t+(m=0===r?e/(s+1):.5*m),!0))-a,c="u"===(Math.abs(h)<1?"u":"t")?(1+s)*h:h,a=o,l=(n=this.levin(o,s-1,c,1,u,p))-d,isNaN(n)){f="NaN";break}if(0!==o&&n/o>this.infty){d=n,f="infinite";break}if(Math.abs(l)<1e-7)break;d=n}return[d,f,1-(s-1)/this.upper]},limit:function(t,e,i){return this.iteration_levin(t,e,i,0)}},t.Extrapolate})),define("math/qdt",["math/math","utils/type"],(function(t,e){"use strict";return t.Quadtree=function(t){this.capacity=10,this.points=[],this.xlb=t[0],this.xub=t[2],this.ylb=t[3],this.yub=t[1],this.northWest=null,this.northEast=null,this.southEast=null,this.southWest=null},e.extend(t.Quadtree.prototype,{contains:function(t,e){return this.xlb<t&&t<=this.xub&&this.ylb<e&&e<=this.yub},insert:function(t){return!!this.contains(t.usrCoords[1],t.usrCoords[2])&&(this.points.length<this.capacity?(this.points.push(t),!0):(null===this.northWest&&this.subdivide(),!!this.northWest.insert(t)||(!!this.northEast.insert(t)||(!!this.southEast.insert(t)||!!this.southWest.insert(t)))))},subdivide:function(){var e,i=this.points.length,r=this.xlb+(this.xub-this.xlb)/2,s=this.ylb+(this.yub-this.ylb)/2;for(this.northWest=new t.Quadtree([this.xlb,this.yub,r,s]),this.northEast=new t.Quadtree([r,this.yub,this.xub,s]),this.southEast=new t.Quadtree([this.xlb,s,r,this.ylb]),this.southWest=new t.Quadtree([r,s,this.xub,this.ylb]),e=0;e<i;e+=1)this.northWest.insert(this.points[e]),this.northEast.insert(this.points[e]),this.southEast.insert(this.points[e]),this.southWest.insert(this.points[e])},_query:function(t,e){var i;if(this.contains(t,e)){if(null===this.northWest)return this;if(i=this.northWest._query(t,e))return i;if(i=this.northEast._query(t,e))return i;if(i=this.southEast._query(t,e))return i;if(i=this.southWest._query(t,e))return i}return!1},query:function(t,i){var r,s;return e.exists(i)?(r=t,s=i):(r=t.usrCoords[1],s=t.usrCoords[2]),this._query(r,s)}}),t.Quadtree})),define("math/numerics",["jxg","utils/type","utils/env","math/math"],(function(t,e,i,r){"use strict";var s={rk4:{s:4,A:[[0,0,0,0],[.5,0,0,0],[0,.5,0,0],[0,0,1,0]],b:[1/6,1/3,1/3,1/6],c:[0,.5,.5,1]},heun:{s:2,A:[[0,0],[1,0]],b:[.5,.5],c:[0,1]},euler:{s:1,A:[[0]],b:[1],c:[0]}};return r.Numerics={Gauss:function(t,i){var s,o,n,a,h,l=r.eps,c=t.length>0?t[0].length:0;if(c!==i.length||c!==t.length)throw new Error("JXG.Math.Numerics.Gauss: Dimensions don't match. A must be a square matrix and b must be of the same length as A.");for(a=[],h=i.slice(0,c),s=0;s<c;s++)a[s]=t[s].slice(0,c);for(o=0;o<c;o++){for(s=c-1;s>o;s--)if(Math.abs(a[s][o])>l)if(Math.abs(a[o][o])<l)e.swap(a,s,o),e.swap(h,s,o);else for(a[s][o]/=a[o][o],h[s]-=a[s][o]*h[o],n=o+1;n<c;n++)a[s][n]-=a[s][o]*a[o][n];if(Math.abs(a[o][o])<l)throw new Error("JXG.Math.Numerics.Gauss(): The given matrix seems to be singular.")}return this.backwardSolve(a,h,!0),h},backwardSolve:function(t,e,i){var r,s,o,n,a;for(r=i?e:e.slice(0,e.length),s=t.length,o=t.length>0?t[0].length:0,n=s-1;n>=0;n--){for(a=o-1;a>n;a--)r[n]-=t[n][a]*r[a];r[n]/=t[n][n]}return r},gaussBareiss:function(t){var e,i,s,o,n,a,h,l,c,d=r.eps;if((h=t.length)<=0)return 0;for(t[0].length<h&&(h=t[0].length),l=[],o=0;o<h;o++)l[o]=t[o].slice(0,h);for(i=1,s=1,e=0;e<h-1;e++){if(a=l[e][e],Math.abs(a)<d){for(o=e+1;o<h&&!(Math.abs(l[o][e])>=d);o++);if(o===h)return 0;for(n=e;n<h;n++)c=l[o][n],l[o][n]=l[e][n],l[e][n]=c;s=-s,a=l[e][e]}for(o=e+1;o<h;o++)for(n=e+1;n<h;n++)c=a*l[o][n]-l[o][e]*l[e][n],l[o][n]=c/i;i=a}return s*l[h-1][h-1]},det:function(t){return 2===t.length&&2===t[0].length?t[0][0]*t[1][1]-t[1][0]*t[0][1]:this.gaussBareiss(t)},Jacobi:function(t){var e,i,s,o,n,a,h,l,c,d=r.eps*r.eps,u=0,p=t.length,f=[[0,0,0],[0,0,0],[0,0,0]],m=[[0,0,0],[0,0,0],[0,0,0]],g=0;for(e=0;e<p;e++){for(i=0;i<p;i++)f[e][i]=0,m[e][i]=t[e][i],u+=Math.abs(m[e][i]);f[e][e]=1}if(1===p)return[m,f];if(u<=0)return[m,f];u/=p*p;do{for(l=0,c=0,i=1;i<p;i++)for(e=0;e<i;e++)if((o=Math.abs(m[e][i]))>c&&(c=o),l+=o,o>=d){for(o=.5*Math.atan2(2*m[e][i],m[e][e]-m[i][i]),n=Math.sin(o),a=Math.cos(o),s=0;s<p;s++)h=m[s][e],m[s][e]=a*h+n*m[s][i],m[s][i]=-n*h+a*m[s][i],h=f[s][e],f[s][e]=a*h+n*f[s][i],f[s][i]=-n*h+a*f[s][i];for(m[e][e]=a*m[e][e]+n*m[i][e],m[i][i]=-n*m[e][i]+a*m[i][i],m[e][i]=0,s=0;s<p;s++)m[e][s]=m[s][e],m[i][s]=m[s][i]}g+=1}while(Math.abs(l)/u>d&&g<2e3);return[m,f]},NewtonCotes:function(t,i,r){var s,o,n,a=0,h=r&&e.isNumber(r.number_of_nodes)?r.number_of_nodes:28,l={trapez:!0,simpson:!0,milne:!0},c=r&&r.integration_type&&l.hasOwnProperty(r.integration_type)&&l[r.integration_type]?r.integration_type:"milne",d=(t[1]-t[0])/h;switch(c){case"trapez":for(a=.5*(i(t[0])+i(t[1])),s=t[0],o=0;o<h-1;o++)a+=i(s+=d);a*=d;break;case"simpson":if(h%2>0)throw new Error("JSXGraph:  INT_SIMPSON requires config.number_of_nodes dividable by 2.");for(n=h/2,a=i(t[0])+i(t[1]),s=t[0],o=0;o<n-1;o++)a+=2*i(s+=2*d);for(s=t[0]-d,o=0;o<n;o++)a+=4*i(s+=2*d);a*=d/3;break;default:if(h%4>0)throw new Error("JSXGraph: Error in INT_MILNE: config.number_of_nodes must be a multiple of 4");for(n=.25*h,a=7*(i(t[0])+i(t[1])),s=t[0],o=0;o<n-1;o++)a+=14*i(s+=4*d);for(s=t[0]-3*d,o=0;o<n;o++)a+=32*(i(s+=4*d)+i(s+2*d));for(s=t[0]-2*d,o=0;o<n;o++)a+=12*i(s+=4*d);a*=2*d/45}return a},Romberg:function(t,i,r){var s,o,n,a,h,l,c,d,u=[],p=0,f=1/0,m=r&&e.isNumber(r.max_iterations)?r.max_iterations:20,g=r&&e.isNumber(r.eps)?r.eps:r.eps||1e-7;for(s=t[0],n=(o=t[1])-s,h=1,u[0]=.5*n*(i(s)+i(o)),l=0;l<m;++l){for(a=0,n*=.5,h*=2,d=1,c=1;c<h;c+=2)a+=i(s+c*n);for(u[l+1]=.5*u[l]+a*n,p=u[l+1],c=l-1;c>=0;--c)d*=4,u[c]=u[c+1]+(u[c+1]-u[c])/(d-1),p=u[c];if(Math.abs(p-f)<g*Math.abs(p))break;f=p}return p},GaussLegendre:function(t,i,r){var s,o,n,a,h,l,c,d,u=0,p=[],f=[],m=r&&e.isNumber(r.n)?r.n:12;if(m>18&&(m=18),p[2]=[.5773502691896257],f[2]=[1],p[4]=[.33998104358485626,.8611363115940526],f[4]=[.6521451548625461,.34785484513745385],p[6]=[.2386191860831969,.6612093864662645,.932469514203152],f[6]=[.46791393457269104,.3607615730481386,.17132449237917036],p[8]=[.1834346424956498,.525532409916329,.7966664774136267,.9602898564975363],f[8]=[.362683783378362,.31370664587788727,.22238103445337448,.10122853629037626],p[10]=[.14887433898163122,.4333953941292472,.6794095682990244,.8650633666889845,.9739065285171717],f[10]=[.29552422471475287,.26926671930999635,.21908636251598204,.1494513491505806,.06667134430868814],p[12]=[.1252334085114689,.3678314989981802,.5873179542866175,.7699026741943047,.9041172563704749,.9815606342467192],f[12]=[.24914704581340277,.2334925365383548,.20316742672306592,.16007832854334622,.10693932599531843,.04717533638651183],p[14]=[.10805494870734367,.31911236892788974,.5152486363581541,.6872929048116855,.827201315069765,.9284348836635735,.9862838086968123],f[14]=[.2152638534631578,.2051984637212956,.18553839747793782,.15720316715819355,.12151857068790319,.08015808715976021,.03511946033175186],p[16]=[.09501250983763744,.2816035507792589,.45801677765722737,.6178762444026438,.755404408355003,.8656312023878318,.9445750230732326,.9894009349916499],f[16]=[.1894506104550685,.18260341504492358,.16915651939500254,.14959598881657674,.12462897125553388,.09515851168249279,.062253523938647894,.027152459411754096],p[18]=[.0847750130417353,.2518862256915055,.41175116146284263,.5597708310739475,.6916870430603532,.8037049589725231,.8926024664975557,.9558239495713977,.9915651684209309],f[18]=[.1691423829631436,.16427648374583273,.15468467512626524,.14064291467065065,.12255520671147846,.10094204410628717,.07642573025488905,.0497145488949698,.02161601352648331],p[3]=[0,.7745966692414834],f[3]=[.8888888888888888,.5555555555555556],p[5]=[0,.5384693101056831,.906179845938664],f[5]=[.5688888888888889,.47862867049936647,.23692688505618908],p[7]=[0,.4058451513773972,.7415311855993945,.9491079123427585],f[7]=[.4179591836734694,.3818300505051189,.27970539148927664,.1294849661688697],p[9]=[0,.3242534234038089,.6133714327005904,.8360311073266358,.9681602395076261],f[9]=[.3302393550012598,.31234707704000286,.26061069640293544,.1806481606948574,.08127438836157441],p[11]=[0,.26954315595234496,.5190961292068118,.7301520055740494,.8870625997680953,.978228658146057],f[11]=[.2729250867779006,.26280454451024665,.23319376459199048,.18629021092773426,.1255803694649046,.05566856711617366],p[13]=[0,.2304583159551348,.44849275103644687,.6423493394403402,.8015780907333099,.9175983992229779,.9841830547185881],f[13]=[.2325515532308739,.22628318026289723,.2078160475368885,.17814598076194574,.13887351021978725,.09212149983772845,.04048400476531588],p[15]=[0,.20119409399743451,.3941513470775634,.5709721726085388,.7244177313601701,.8482065834104272,.937273392400706,.9879925180204854],f[15]=[.2025782419255613,.19843148532711158,.1861610000155622,.16626920581699392,.13957067792615432,.10715922046717194,.07036604748810812,.03075324199611727],p[17]=[0,.17848418149584785,.3512317634538763,.5126905370864769,.6576711592166907,.7815140038968014,.8802391537269859,.9506755217687678,.9905754753144174],f[17]=[.17944647035620653,.17656270536699264,.16800410215645004,.15404576107681028,.13513636846852548,.11188384719340397,.08503614831717918,.0554595293739872,.02414830286854793],s=t[0],o=t[1],a=m+1>>1,c=p[m],d=f[m],l=.5*(o-s),h=.5*(o+s),!0&m)for(u=d[0]*i(h),n=1;n<a;++n)u+=d[n]*(i(h+l*c[n])+i(h-l*c[n]));else for(u=0,n=0;n<a;++n)u+=d[n]*(i(h+l*c[n])+i(h-l*c[n]));return l*u},_rescale_error:function(t,e,i){var r,s,o=2220446049250313e-31;return t=Math.abs(t),0!==i&&0!==t&&(t=(r=Math.pow(200*t/i,1.5))<1?i*r:i),e>20041683600089728e-310&&(s=50*o*e)>t&&(t=s),t},_gaussKronrod:function(t,e,i,r,s,o,n){var a,h,l,c,d,u,p,f,m,g,b,v=t[0],y=t[1],C=.5*(v+y),_=.5*(y-v),P=Math.abs(_),E=e(C),S=0,x=E*o[i-1],O=Math.abs(x),w=0,T=[],N=[];for(i%2==0&&(S=E*s[i/2-1]),a=Math.floor((i-1)/2),d=0;d<a;d++)g=(f=e(C-(p=_*r[u=2*d+1])))+(m=e(C+p)),T[u]=f,N[u]=m,S+=s[d]*g,x+=o[u]*g,O+=o[u]*(Math.abs(f)+Math.abs(m));for(a=Math.floor(i/2),d=0;d<a;d++)f=e(C-(p=_*r[b=2*d])),m=e(C+p),T[b]=f,N[b]=m,x+=o[b]*(f+m),O+=o[b]*(Math.abs(f)+Math.abs(m));for(l=.5*x,w=o[i-1]*Math.abs(E-l),d=0;d<i-1;d++)w+=o[d]*(Math.abs(T[d]-l)+Math.abs(N[d]-l));return c=(x-S)*_,O*=P,w*=P,h=x*=_,n.abserr=this._rescale_error(c,O,w),n.resabs=O,n.resasc=w,h},GaussKronrod15:function(t,e,i){return this._gaussKronrod(t,e,8,[.9914553711208126,.9491079123427585,.8648644233597691,.7415311855993945,.5860872354676911,.4058451513773972,.20778495500789848,0],[.1294849661688697,.27970539148927664,.3818300505051189,.4179591836734694],[.022935322010529224,.06309209262997856,.10479001032225019,.14065325971552592,.1690047266392679,.19035057806478542,.20443294007529889,.20948214108472782],i)},GaussKronrod21:function(t,e,i){return this._gaussKronrod(t,e,11,[.9956571630258081,.9739065285171717,.9301574913557082,.8650633666889845,.7808177265864169,.6794095682990244,.5627571346686047,.4333953941292472,.2943928627014602,.14887433898163122,0],[.06667134430868814,.1494513491505806,.21908636251598204,.26926671930999635,.29552422471475287],[.011694638867371874,.032558162307964725,.054755896574351995,.07503967481091996,.0931254545836976,.10938715880229764,.12349197626206584,.13470921731147334,.14277593857706009,.14773910490133849,.1494455540029169],i)},GaussKronrod31:function(t,e,i){return this._gaussKronrod(t,e,16,[.9980022986933971,.9879925180204854,.9677390756791391,.937273392400706,.8972645323440819,.8482065834104272,.790418501442466,.7244177313601701,.650996741297417,.5709721726085388,.4850818636402397,.3941513470775634,.29918000715316884,.20119409399743451,.1011420669187175,0],[.03075324199611727,.07036604748810812,.10715922046717194,.13957067792615432,.16626920581699392,.1861610000155622,.19843148532711158,.2025782419255613],[.005377479872923349,.015007947329316122,.02546084732671532,.03534636079137585,.04458975132476488,.05348152469092809,.06200956780067064,.06985412131872826,.07684968075772038,.08308050282313302,.08856444305621176,.09312659817082532,.09664272698362368,.09917359872179196,.10076984552387559,.10133000701479154],i)},_workspace:function(t,e){return{limit:e,size:0,nrmax:0,i:0,alist:[t[0]],blist:[t[1]],rlist:[0],elist:[0],order:[0],level:[0],qpsrt:function(){var t,e,i,r,s,o=this.size-1,n=this.limit,a=this.nrmax,h=this.order[a];if(o<2)return this.order[0]=0,this.order[1]=1,void(this.i=h);for(t=this.elist[h];a>0&&t>this.elist[this.order[a-1]];)this.order[a]=this.order[a-1],a--;for(s=o<n/2+2?o:n-o+1,i=a+1;i<s&&t<this.elist[this.order[i]];)this.order[i-1]=this.order[i],i++;for(this.order[i-1]=h,e=this.elist[o],r=s-1;r>i-2&&e>=this.elist[this.order[r]];)this.order[r+1]=this.order[r],r--;this.order[r+1]=o,h=this.order[a],this.i=h,this.nrmax=a},set_initial_result:function(t,e){this.size=1,this.rlist[0]=t,this.elist[0]=e},update:function(t,e,i,r,s,o,n,a){var h=this.i,l=this.size,c=this.level[this.i]+1;a>r?(this.alist[h]=s,this.rlist[h]=n,this.elist[h]=a,this.level[h]=c,this.alist[l]=t,this.blist[l]=e,this.rlist[l]=i,this.elist[l]=r,this.level[l]=c):(this.blist[h]=e,this.rlist[h]=i,this.elist[h]=r,this.level[h]=c,this.alist[l]=s,this.blist[l]=o,this.rlist[l]=n,this.elist[l]=a,this.level[l]=c),this.size++,c>this.maximum_level&&(this.maximum_level=c),this.qpsrt()},retrieve:function(){var t=this.i;return{a:this.alist[t],b:this.blist[t],r:this.rlist[t],e:this.elist[t]}},sum_results:function(){var t,e=this.size,i=0;for(t=0;t<e;t++)i+=this.rlist[t];return i},subinterval_too_small:function(t,e,i){var r=1.0000000000000222*(Math.abs(e)+22250738585072014e-321);return Math.abs(t)<=r&&Math.abs(i)<=r}}},Qag:function(i,s,o){var n,a,h,l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S=this._workspace(i,1e3),x=o&&e.isNumber(o.limit)?o.limit:15,O=o&&e.isNumber(o.epsrel)?o.epsrel:1e-7,w=o&&e.isNumber(o.epsabs)?o.epsabs:1e-7,T=o&&e.isFunction(o.q)?o.q:this.GaussKronrod15,N={},M=0,A=0,R=0,L=0,k=0,B=0,I=0,Y=0,D=0,j=0;if(x>S.limit&&t.warn("iteration limit exceeds available workspace"),w<=0&&(O<50*r.eps||O<5e-29)&&t.warn("tolerance cannot be acheived with given epsabs and epsrel"),h=T.apply(this,[i,s,N]),l=N.abserr,c=N.resabs,d=N.resasc,S.set_initial_result(h,l),u=Math.max(w,O*Math.abs(h)),l<=11102230246251565e-30*c&&l>u)return h,t.warn("cannot reach tolerance because of roundoff error on first attempt"),-1/0;if(l<=u&&l!==d||0===l)return h;if(1===x)return h,t.warn("a maximum of one iteration was insufficient"),-1/0;n=h,a=l,M=1;do{k=0,B=0,I=0,Y=0,D=0,j=0,b=(P=S.retrieve()).a,v=P.b,y=P.r,C=P.e,p=b,m=f=.5*(b+v),g=v,k=T.apply(this,[[p,f],s,N]),Y=N.abserr,_=N.resasc,B=T.apply(this,[[m,g],s,N]),a+=(j=Y+(D=N.abserr))-C,n+=(I=k+B)-y,_!==Y&&N.resasc!==D&&(E=y-I,Math.abs(E)<=1e-5*Math.abs(I)&&j>=.99*C&&A++,M>=10&&j>C&&R++),a>(u=Math.max(w,O*Math.abs(n)))&&((A>=6||R>=20)&&(L=2),S.subinterval_too_small(p,m,g)&&(L=3)),S.update(p,f,k,Y,m,g,B,D),b=(P=S.retrieve()).a_i,v=P.b_i,y=P.r_i,C=P.e_i,M++}while(M<x&&!L&&a>u);return S.sum_results()},I:function(t,e){return this.Qag(t,e,{q:this.GaussKronrod15,limit:15,epsrel:1e-7,epsabs:1e-7})},Newton:function(t,i,s){var o,n=0,a=r.eps,h=t.apply(s,[i]);for(e.isArray(i)&&(i=i[0]);n<50&&Math.abs(h)>a;)o=this.D(t,s)(i),Math.abs(o)>a?i-=h/o:i+=.2*Math.random()-1,h=t.apply(s,[i]),n+=1;return i},root:function(t,e,i){return this.chandrupatla(t,e,i)},generalizedNewton:function(t,e,i,s){var o,n,a,h,l,c,d,u,p,f,m,g,b,v,y=0;for(this.generalizedNewton.t1memo?(o=this.generalizedNewton.t1memo,n=this.generalizedNewton.t2memo):(o=i,n=s),f=(u=t.X(o)-e.X(n))*u+(p=t.Y(o)-e.Y(n))*p,m=this.D(t.X,t),g=this.D(e.X,e),b=this.D(t.Y,t),v=this.D(e.Y,e);f>r.eps&&y<10;)a=m(o),h=-g(n),l=b(o),o-=((c=-v(n))*u-h*p)/(d=a*c-h*l),n-=(a*p-l*u)/d,f=(u=t.X(o)-e.X(n))*u+(p=t.Y(o)-e.Y(n))*p,y+=1;return this.generalizedNewton.t1memo=o,this.generalizedNewton.t2memo=n,Math.abs(o)<Math.abs(n)?[t.X(o),t.Y(o)]:[e.X(n),e.Y(n)]},Neville:function(t){var e=[],i=function(i){return function(s,o){var n,a,h,l=r.binomial,c=t.length,d=c-1,u=0,p=0;if(!o)for(h=1,n=0;n<c;n++)e[n]=l(d,n)*h,h*=-1;for(a=s,n=0;n<c;n++){if(0===a)return t[n][i]();h=e[n]/a,a-=1,u+=t[n][i]()*h,p+=h}return u/p}};return[i("X"),i("Y"),0,function(){return t.length-1}]},splineDef:function(t,e){var i,r,s,o=Math.min(t.length,e.length),n=[],a=[],h=[],l=[],c=[],d=[];if(2===o)return[0,0];for(r=0;r<o;r++)i={X:t[r],Y:e[r]},h.push(i);for(h.sort((function(t,e){return t.X-e.X})),r=0;r<o;r++)t[r]=h[r].X,e[r]=h[r].Y;for(r=0;r<o-1;r++)l.push(t[r+1]-t[r]);for(r=0;r<o-2;r++)c.push(6*(e[r+2]-e[r+1])/l[r+1]-6*(e[r+1]-e[r])/l[r]);for(n.push(2*(l[0]+l[1])),a.push(c[0]),r=0;r<o-3;r++)s=l[r+1]/n[r],n.push(2*(l[r+1]+l[r+2])-s*l[r+1]),a.push(c[r+1]-s*a[r]);for(d[o-3]=a[o-3]/n[o-3],r=o-4;r>=0;r--)d[r]=(a[r]-l[r+1]*d[r+1])/n[r];for(r=o-3;r>=0;r--)d[r+1]=d[r];return d[0]=0,d[o-1]=0,d},splineEval:function(t,i,r,s){var o,n,a,h,l,c,d,u=Math.min(i.length,r.length),p=1,f=!1,m=[];for(e.isArray(t)?(p=t.length,f=!0):t=[t],o=0;o<p;o++){if(t[o]<i[0]||i[o]>i[u-1])return NaN;for(n=1;n<u&&!(t[o]<=i[n]);n++);a=r[n-=1],h=(r[n+1]-r[n])/(i[n+1]-i[n])-(i[n+1]-i[n])/6*(s[n+1]+2*s[n]),l=s[n]/2,c=(s[n+1]-s[n])/(6*(i[n+1]-i[n])),d=t[o]-i[n],m.push(a+(h+(l+c*d)*d)*d)}return f?m:m[0]},generatePolynomialTerm:function(t,e,i,r){var s,o=[];for(s=e;s>=0;s--)o=o.concat(["(",t[s].toPrecision(r),")"]),s>1?o=o.concat(["*",i,"<sup>",s,"<","/sup> + "]):1===s&&(o=o.concat(["*",i," + "]));return o.join("")},lagrangePolynomial:function(t){var e=[],i=this,r=function(i,r){var s,o,n,a,h=t.length,l=0,c=0;if(!r)for(s=0;s<h;s++){for(e[s]=1,n=t[s].X(),o=0;o<h;o++)o!==s&&(e[s]*=n-t[o].X());e[s]=1/e[s]}for(s=0;s<h;s++){if(i===(n=t[s].X()))return t[s].Y();c+=a=e[s]/(i-n),l+=a*t[s].Y()}return l/c};return r.getTerm=function(e,r,s){return i.lagrangePolynomialTerm(t,e,r,s)()},r},lagrangePolynomialTerm:function(e,s,o,n){return function(){var a,h,l,c,d,u,p=e.length,f=[],m=[],g=[],b=!0;for(o=o||"x",void 0===n&&(n=" * "),a=p-1,c=0;c<p;c++)g[c]=0;for(l=0;l<p;l++){for(d=e[l].Y(),u=e[l].X(),f=[],c=0;c<p;c++)c!==l&&(d/=u-e[c].X(),f.push(e[c].X()));for(m=[1].concat(r.Vieta(f)),c=0;c<m.length;c++)g[c]+=(c%2==1?-1:1)*m[c]*d}for(h="",c=0;c<g.length;c++)d=g[c],Math.abs(d)<r.eps||(t.exists(s)&&(d=i._round10(d,-s)),b?(h+=d>0?d:"-"+-d,b=!1):h+=d>0?" + "+d:" - "+-d,a-c>1?h+=n+o+"^"+(a-c):a-c==1&&(h+=n+o));return h}},_initCubicPoly:function(t,e,i,r){return[t,i,-3*t+3*e-2*i-r,2*t-2*e+i+r]},CardinalSpline:function(t,i,s){var o,n,a,h,l=[],c=this;return h=e.isFunction(i)?i:function(){return i},void 0===s&&(s="uniform"),n=function(e){return function(i,n){var d,u,p,f,m,g,b,v,y,C;if(t.length<2)return NaN;if(!n)for(a=h(),p={X:function(){return 2*t[0].X()-t[1].X()},Y:function(){return 2*t[0].Y()-t[1].Y()},Dist:function(t){var e=this.X()-t.X(),i=this.Y()-t.Y();return Math.sqrt(e*e+i*i)}},f={X:function(){return 2*t[t.length-1].X()-t[t.length-2].X()},Y:function(){return 2*t[t.length-1].Y()-t[t.length-2].Y()},Dist:function(t){var e=this.X()-t.X(),i=this.Y()-t.Y();return Math.sqrt(e*e+i*i)}},C=(o=[p].concat(t,[f])).length,l[e]=[],d=0;d<C-3;d++)"centripetal"===s?(b=o[d].Dist(o[d+1]),v=o[d+2].Dist(o[d+1]),y=o[d+3].Dist(o[d+2]),b=Math.sqrt(b),v=Math.sqrt(v),y=Math.sqrt(y),v<r.eps&&(v=1),b<r.eps&&(b=v),y<r.eps&&(y=v),m=(o[d+1][e]()-o[d][e]())/b-(o[d+2][e]()-o[d][e]())/(v+b)+(o[d+2][e]()-o[d+1][e]())/v,g=(o[d+2][e]()-o[d+1][e]())/v-(o[d+3][e]()-o[d+1][e]())/(y+v)+(o[d+3][e]()-o[d+2][e]())/y,m*=v,g*=v,l[e][d]=c._initCubicPoly(o[d+1][e](),o[d+2][e](),a*m,a*g)):l[e][d]=c._initCubicPoly(o[d+1][e](),o[d+2][e](),a*(o[d+2][e]()-o[d][e]()),a*(o[d+3][e]()-o[d+1][e]()));return isNaN(i)?NaN:(C=t.length,i<=0?t[0][e]():i>=C?t[C-1][e]():(d=Math.floor(i))===i?t[d][e]():(i-=d,void 0===(u=l[e][d])?NaN:((u[3]*i+u[2])*i+u[1])*i+u[0]))}},[n("X"),n("Y"),0,function(){return t.length-1}]},CatmullRomSpline:function(t,e){return this.CardinalSpline(t,.5,e)},regressionPolynomial:function(t,i,s){var o,n,a,h,l,c,d="";if(e.isPoint(t)&&e.isFunction(t.Value))n=function(){return t.Value()};else if(e.isFunction(t))n=t;else{if(!e.isNumber(t))throw new Error("JSXGraph: Can't create regressionPolynomial from degree of type'"+typeof t+"'.");n=function(){return t}}if(3===arguments.length&&e.isArray(i)&&e.isArray(s))l=0;else if(2===arguments.length&&e.isArray(i)&&i.length>0&&e.isPoint(i[0]))l=1;else{if(!(2===arguments.length&&e.isArray(i)&&i.length>0&&i[0].usrCoords&&i[0].scrCoords))throw new Error("JSXGraph: Can't create regressionPolynomial. Wrong parameters.");l=2}return(c=function(t,c){var u,p,f,m,g,b,v,y,C,_=i.length;if(C=Math.floor(n()),!c){if(1===l)for(a=[],h=[],u=0;u<_;u++)a[u]=i[u].X(),h[u]=i[u].Y();if(2===l)for(a=[],h=[],u=0;u<_;u++)a[u]=i[u].usrCoords[1],h[u]=i[u].usrCoords[2];if(0===l)for(a=[],h=[],u=0;u<_;u++)e.isFunction(i[u])?a.push(i[u]()):a.push(i[u]),e.isFunction(s[u])?h.push(s[u]()):h.push(s[u]);for(f=[],p=0;p<_;p++)f.push([1]);for(u=1;u<=C;u++)for(p=0;p<_;p++)f[p][u]=f[p][u-1]*a[p];g=h,m=r.transpose(f),b=r.matMatMult(m,f),v=r.matVecMult(m,g),o=r.Numerics.Gauss(b,v),d=r.Numerics.generatePolynomialTerm(o,C,"x",3)}for(y=o[C],u=C-1;u>=0;u--)y=y*t+o[u];return y}).getTerm=function(){return d},c},bezier:function(t){var e,i,r=function(r){return function(s,o){var n=3*Math.floor(s),a=s%1,h=1-a;return o||(i=3*Math.floor((t.length-1)/3),e=Math.floor(i/3)),s<0?t[0][r]():s>=e?t[i][r]():isNaN(s)?NaN:h*h*(h*t[n][r]()+3*a*t[n+1][r]())+(3*h*t[n+2][r]()+a*t[n+3][r]())*a*a}};return[r("X"),r("Y"),0,function(){return Math.floor(t.length/3)}]},bspline:function(t,e){var i,r=function(r){return function(s,o){var n,a,h,l,c=t.length,d=c-1,u=e;if(d<=0)return NaN;if(d+2<=u&&(u=d+1),s<=0)return t[0][r]();if(s>=d-u+2)return t[d][r]();for(h=Math.floor(s)+u-1,i=function(t,e){var i,r=[];for(i=0;i<t+e+1;i++)r[i]=i<e?0:i<=t?i-e+1:t-e+2;return r}(d,u),l=function(t,e,i,r){var s,o,n,a,h,l=[];for(e[r]<=t&&t<e[r+1]?l[r]=1:l[r]=0,s=2;s<=i;s++)for(o=r-s+1;o<=r;o++)n=o<=r-s+1||o<0?0:l[o],a=o>=r?0:l[o+1],h=e[o+s-1]-e[o],l[o]=0===h?0:(t-e[o])/h*n,0!=(h=e[o+s]-e[o+1])&&(l[o]+=(e[o+s]-t)/h*a);return l}(s,i,u,h),n=0,a=h-u+1;a<=h;a++)a<c&&a>=0&&(n+=t[a][r]()*l[a]);return n}};return[r("X"),r("Y"),0,function(){return t.length-1}]},D:function(t,i){return e.exists(i)?function(e,r){var s=1e-5;return(t.apply(i,[e+s,r])-t.apply(i,[e-s,r]))/2e-5}:function(e,i){var r=1e-5;return(t(e+r,i)-t(e-r,i))/2e-5}},_riemannValue:function(t,e,i,r){var s,o,n,a;if(r<0&&("trapezoidal"!==i&&(t+=r),r*=-1,"lower"===i?i="upper":"upper"===i&&(i="lower")),a=.01*r,"right"===i)s=e(t+r);else if("middle"===i)s=e(t+.5*r);else if("left"===i||"trapezoidal"===i)s=e(t);else if("lower"===i){for(s=e(t),n=t+a;n<=t+r;n+=a)(o=e(n))<s&&(s=o);(o=e(t+r))<s&&(s=o)}else if("upper"===i){for(s=e(t),n=t+a;n<=t+r;n+=a)(o=e(n))>s&&(s=o);(o=e(t+r))>s&&(s=o)}else s="random"===i?e(t+r*Math.random()):"simpson"===i?(e(t)+4*e(t+.5*r)+e(t+r))/6:e(t);return s},riemann:function(t,i,r,s,o){var n,a,h,l,c,d,u,p=[],f=[],m=0,g=s,b=0;if(e.isArray(t)?(c=t[0],l=t[1]):l=t,(i=Math.floor(i))<=0)return[p,f,b];for(a=(o-s)/i,n=0;n<i;n++)h=this._riemannValue(g,l,r,a),p[m]=g,f[m]=h,m+=1,g+=a,"trapezoidal"===r&&(h=l(g)),p[m]=g,f[m]=h,m+=1;for(n=0;n<i;n++)h=c?this._riemannValue(g,c,r,-a):0,p[m]=g,f[m]=h,m+=1,g-=a,"trapezoidal"===r&&c&&(h=c(g)),p[m]=g,f[m]=h,"trapezoidal"!==r?(d=h,u=f[2*(i-1)-2*n]):(u=.5*(l(g+a)+l(g)),d=c?.5*(c(g+a)+c(g)):0),b+=(u-d)*a,p[m+=1]=g,f[m]=f[2*(i-1)-2*n],m+=1;return[p,f,b]},riemannsum:function(e,i,r,s,o){return t.deprecated("Numerics.riemannsum()","Numerics.riemann()"),this.riemann(e,i,r,s,o)[2]},rungeKutta:function(t,i,r,o,n){var a,h,l,c,d,u,p=[],f=[],m=(r[1]-r[0])/o,g=r[0],b=i.length,v=[],y=0;for(e.isString(t)&&(t=s[t]||s.euler),u=t.s,a=0;a<b;a++)p[a]=i[a];for(h=0;h<o;h++){for(v[y]=[],a=0;a<b;a++)v[y][a]=p[a];for(y+=1,c=[],l=0;l<u;l++){for(a=0;a<b;a++)f[a]=0;for(d=0;d<l;d++)for(a=0;a<b;a++)f[a]+=t.A[l][d]*m*c[d][a];for(a=0;a<b;a++)f[a]+=p[a];c.push(n(g+t.c[l]*m,f))}for(a=0;a<b;a++)f[a]=0;for(d=0;d<u;d++)for(a=0;a<b;a++)f[a]+=t.b[d]*c[d][a];for(a=0;a<b;a++)p[a]=p[a]+m*f[a];g+=m}return v},maxIterationsRoot:80,maxIterationsMinimize:500,findBracket:function(t,i,r){var s,o,n,a,h,l,c,d,u,p;if(e.isArray(i))return i;for(s=i,n=t.call(r,s),p=(a=[s-.1*(o=0===s?1:s),s+.1*o,s-1,s+1,s-.5*o,s+.5*o,s-.6*o,s+.6*o,s-1*o,s+1*o,s-2*o,s+2*o,s-5*o,s+5*o,s-10*o,s+10*o,s-50*o,s+50*o,s-100*o,s+100*o]).length,u=0;u<p&&(h=a[u],!(n*(l=t.call(r,h))<=0));u++);return h<s&&(c=s,s=h,h=c,d=n,n=l,l=d),[s,n,h,l]},fzero:function(t,i,s){var o,n,a,h,l,c,d,u,p,f,m,g,b,v,y,C=r.eps,_=this.maxIterationsRoot,P=0;if(e.isArray(i)){if(i.length<2)throw new Error("JXG.Math.Numerics.fzero: length of array x0 has to be at least two.");o=i[0],h=t.call(s,o),n=i[1],l=t.call(s,n)}else o=(d=this.findBracket(t,i,s))[0],h=d[1],n=d[2],l=d[3];if(Math.abs(h)<=C)return o;if(Math.abs(l)<=C)return n;if(h*l>0)return e.isArray(i)?this.fminbr(t,[o,n],s):this.Newton(t,o,s);for(a=o,c=h;P<_;){if(u=n-o,Math.abs(c)<Math.abs(l)&&(o=n,n=a,a=o,h=l,l=c,c=h),g=2*C*Math.abs(n)+.5*C,y=.5*(a-n),Math.abs(y)<=g||Math.abs(l)<=C)return n;Math.abs(u)>=g&&Math.abs(h)>Math.abs(l)&&(f=a-n,o===a?(b=f*(p=l/h),v=1-p):(b=(m=l/h)*(f*(v=h/c)*(v-(p=l/c))-(n-o)*(p-1)),v=(v-1)*(p-1)*(m-1)),b>0?v=-v:b=-b,b<.75*f*v-.5*Math.abs(g*v)&&b<Math.abs(u*v*.5)&&(y=b/v)),Math.abs(y)<g&&(y=y>0?g:-g),o=n,h=l,n+=y,((l=t.call(s,n))>0&&c>0||l<0&&c<0)&&(a=o,c=h),P++}return n},chandrupatla:function(t,i,s){var o,n,a,h,l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S,x=0,O=this.maxIterationsRoot,w=1+.001*Math.random(),T=.5*w,N=r.eps;if(e.isArray(i)){if(i.length<2)throw new Error("JXG.Math.Numerics.fzero: length of array x0 has to be at least two.");o=i[0],n=t.call(s,o),a=i[1],h=t.call(s,a)}else o=(l=this.findBracket(t,i,s))[0],n=l[1],a=l[2],h=l[3];if(n*h>0)return e.isArray(i)?this.fminbr(t,[o,a],s):this.Newton(t,o,s);c=o,d=a,f=n,m=h;do{if(p=c+T*(d-c),b=t.call(s,p),Math.sign(b)===Math.sign(f)?(u=c,c=p,g=f,f=b):(u=d,d=c,g=m,m=f),v=c=p,y=f=b,Math.abs(m)<Math.abs(f)&&(v=d,y=m),(C=(2*N*Math.abs(v)+5e-6)/Math.abs(d-c))>.5||0===y)break;_=(c-d)/(u-d),P=(f-m)/(g-m),E=1-Math.sqrt(1-_),S=Math.sqrt(_),(T=E<P&&P<S?f/(m-f)*(g/(m-g))+f/(g-f)*(m/(g-m))*((u-c)/(d-c)):.5*w)<C&&(T=C),T>1-C&&(T=1-C),x++}while(x<=O);return v},fminbr:function(t,i,s){var o,n,a,h,l,c,d,u,p,f,m,g,b,v,y,C,_=.5*(3-Math.sqrt(5)),P=r.eps,E=r.eps,S=this.maxIterationsMinimize,x=0;if(!e.isArray(i)||i.length<2)throw new Error("JXG.Math.Numerics.fminbr: length of array x0 has to be at least two.");for(a=h=(o=i[0])+_*((n=i[1])-o),l=h,c=d=t.call(s,h),u=d;x<S;){if(p=n-o,f=.5*(o+n),m=E*Math.abs(a)+P/3,Math.abs(a-f)+.5*p<=2*m)return a;g=_*(a<f?n-a:o-a),Math.abs(a-l)>=m&&(b=(a-h)*(v=(a-h)*(c-u))-(a-l)*(y=(a-l)*(c-d)),(v=2*(v-y))>0?b=-b:v=-v,Math.abs(b)<Math.abs(g*v)&&b>v*(o-a+2*m)&&b<v*(n-a-2*m)&&(g=b/v)),Math.abs(g)<m&&(g=g>0?m:-m),y=a+g,(C=t.call(s,y))<=c?(y<a?n=a:o=a,h=l,l=a,a=y,d=u,u=c,c=C):(y<a?o=y:n=y,C<=u||l===a?(h=l,l=y,d=u,u=C):(C<=d||h===a||h===l)&&(h=y,d=C)),x+=1}return a},RamerDouglasPeucker:function(t,e){var i,s,o,n=[],a=[],h=function(t,e,i,s,o){var n=function(t,e,i){var s,o,n,a,h,l,c,d,u,p,f,m=1e4,g=0,b=e;if(i-e<2)return[-1,0];if(n=t[e].scrCoords,a=t[i].scrCoords,isNaN(n[1])||isNaN(n[2]))return[NaN,e];if(isNaN(a[1])||isNaN(a[2]))return[NaN,i];for(o=e+1;o<i;o++){if(h=t[o].scrCoords,isNaN(h[1])||isNaN(h[2]))return[NaN,o];l=(l=(l=h[1]-n[1])==1/0?m:l)===-1/0?-m:l,c=(c=(c=h[2]-n[2])==1/0?m:c)===-1/0?-m:c,(p=(d=(d=(d=a[1]-n[1])==1/0?m:d)===-1/0?-m:d)*d+(u=(u=(u=a[2]-n[2])==1/0?m:u)===-1/0?-m:u)*u)>=r.eps?((f=(l*d+c*u)/p)<0?f=0:f>1&&(f=1),s=(l-=f*d)*l+(c-=f*u)*c):(f=0,s=l*l+c*c),s>g&&(g=s,b=o)}return[Math.sqrt(g),b]}(t,e,i),a=n[1];if(isNaN(n[0])){h(t,e,a-1,s,o),o.push(t[a]);do{++a}while(a<=i&&isNaN(t[a].scrCoords[1]+t[a].scrCoords[2]));a<=i&&o.push(t[a]),h(t,a+1,i,s,o)}else n[0]>s?(h(t,e,a,s,o),h(t,a,i,s,o)):o.push(t[i])};for(o=t.length,i=0;;){for(;i<o&&isNaN(t[i].scrCoords[1]+t[i].scrCoords[2]);)i+=1;for(s=i+1;s<o&&!isNaN(t[s].scrCoords[1]+t[s].scrCoords[2]);)s+=1;if(s--,i<o&&s>i&&((a=[])[0]=t[i],h(t,i,s,e,a),n=n.concat(a)),i>=o)break;s<o-1&&n.push(t[s+1]),i=s+1}return n},RamerDouglasPeuker:function(e,i){return t.deprecated("Numerics.RamerDouglasPeuker()","Numerics.RamerDouglasPeucker()"),this.RamerDouglasPeucker(e,i)},Visvalingam:function(e,i){var r,s,o,n,a,h,l,c,d,u=[],p=[],f=[];if((s=e.length)<=2)return e;for(u[0]={used:!0,lft:null,node:null},a=0,r=1;r<s-1;r++)o=Math.abs(t.Math.Numerics.det([e[r-1].usrCoords,e[r].usrCoords,e[r+1].usrCoords])),isNaN(o)||(d={v:o,idx:r},p.push(d),u[r]={used:!0,lft:a,node:d},u[a].rt=r,a=r);for(u[s-1]={used:!0,rt:null,lft:a,node:null},u[a].rt=s-1,n=-1/0;p.length>i;)p.sort((function(t,e){return e.v-t.v})),u[r=p.pop().idx].used=!1,n=u[r].node.v,a=u[r].lft,h=u[r].rt,u[a].rt=h,u[h].lft=a,null!==(l=u[a].lft)&&(o=Math.abs(t.Math.Numerics.det([e[l].usrCoords,e[a].usrCoords,e[h].usrCoords])),u[a].node.v=o>=n?o:n),null!==(c=u[h].rt)&&(o=Math.abs(t.Math.Numerics.det([e[a].usrCoords,e[h].usrCoords,e[c].usrCoords])),u[h].node.v=o>=n?o:n);f=[e[r=0]];do{r=u[r].rt,f.push(e[r])}while(null!==u[r].rt);return f}},r.Numerics})),define("math/nlp",["jxg"],(function(t){"use strict";return t.Math.Nlp={arr:function(t){var e,i=new Array(t);for(e=0;e<t;e++)i[e]=0;return i},arr2:function(t,e){for(var i=0,r=new Array(t);i<t;)r[i]=this.arr(e),i++;return r},arraycopy:function(t,e,i,r,s){for(var o=0;o<s;)i[o+r]=t[o+e],o++},Normal:0,MaxIterationsReached:1,DivergingRoundingErrors:2,FindMinimum:function(t,e,i,r,s,o,n,a){var h,l,c=i+2,d=this.arr(e+1),u=this;return d[0]=0,this.arraycopy(r,0,d,1,e),l=function(e,i,r,s){var o,n,a=u.arr(e);return u.arraycopy(r,1,a,0,e),o=u.arr(i),n=t(e,i,a,o),u.arraycopy(o,0,s,1,i),n},h=this.cobylb(l,e,i,c,d,s,o,n,a),this.arraycopy(d,1,r,0,e),h},cobylb:function(t,e,i,r,s,o,n,a,h){var l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S,x,O,w,T,N,M,A,R,L,k,B,I,Y,D=-1,j=0,X=0,U=e+1,F=i+1,J=o,G=0,z=!1,H=!1,V=0,$=0,q=0,W=this.arr(1+r),Q=this.arr2(1+e,1+U),Z=this.arr2(1+e,1+e),K=this.arr2(1+r,1+U),tt=this.arr2(1+e,1+F),et=this.arr(1+e),it=this.arr(1+e),rt=this.arr(1+e),st=this.arr(1+e),ot=this.arr(1+e);for(a>=2&&console.log("The initial value of RHO is "+J+" and PARMU is set to zero."),g=0,f=1/J,c=1;c<=e;++c)Q[c][U]=s[c],Q[c][c]=J,Z[c][c]=f;b=U,v=!1;t:for(;;){if(g>=h&&g>0){D=this.MaxIterationsReached;break t}for(++g,j=t(e,i,s,W),X=0,u=1;u<=i;++u)X=Math.max(X,-W[u]);if(g!==a-1&&3!==a||this.PrintIterationResult(g,j,X,s,e,a),W[F]=j,W[r]=X,y=!0,!v){for(y=!1,c=1;c<=r;++c)K[c][b]=W[c];if(g<=U){if(b<=e)if(K[F][U]<=j)s[b]=Q[b][U];else{for(Q[b][U]=s[b],u=1;u<=r;++u)K[u][b]=K[u][U],K[u][U]=W[u];for(u=1;u<=b;++u){for(Q[b][u]=-J,f=0,c=u;c<=b;++c)f-=Z[c][u];Z[b][u]=f}}if(g<=e){s[b=g]+=J;continue t}}v=!0}e:for(;;){i:do{if(!y){for(C=K[F][U]+G*K[r][U],_=U,d=1;d<=e;++d)(f=K[F][d]+G*K[r][d])<C?(_=d,C=f):f===C&&0===G&&K[r][d]<K[r][_]&&(_=d);if(_<=e){for(c=1;c<=r;++c)f=K[c][U],K[c][U]=K[c][_],K[c][_]=f;for(c=1;c<=e;++c){for(f=Q[c][_],Q[c][_]=0,Q[c][U]+=f,m=0,u=1;u<=e;++u)Q[c][u]-=f,m-=Z[u][c];Z[_][c]=m}}for(P=0,c=1;c<=e;++c)for(d=1;d<=e;++d)f=this.DOT_PRODUCT(this.PART(this.ROW(Z,c),1,e),this.PART(this.COL(Q,d),1,e))-(c===d?1:0),P=Math.max(P,Math.abs(f));if(P>.1){D=this.DivergingRoundingErrors;break t}for(u=1;u<=F;++u){for(W[u]=-K[u][U],d=1;d<=e;++d)ot[d]=K[u][d]+W[u];for(c=1;c<=e;++c)tt[c][u]=(u===F?-1:1)*this.DOT_PRODUCT(this.PART(ot,1,e),this.PART(this.COL(Z,c),1,e))}for(z=!0,V=.25*J,E=2.1*J,d=1;d<=e;++d){for(S=0,u=1;u<=e;++u)S+=Z[d][u]*Z[d][u];for(x=0,u=1;u<=e;++u)x+=Q[u][d]*Q[u][d];et[d]=1/Math.sqrt(S),it[d]=Math.sqrt(x),(et[d]<V||it[d]>E)&&(z=!1)}if(!v&&!z){for(b=0,f=E,d=1;d<=e;++d)it[d]>f&&(b=d,f=it[d]);if(0===b)for(d=1;d<=e;++d)et[d]<f&&(b=d,f=et[d]);for(f=.5*J*et[b],u=1;u<=e;++u)st[u]=f*Z[b][u];for(O=0,w=0,l=0,u=1;u<=F;++u)l=this.DOT_PRODUCT(this.PART(this.COL(tt,u),1,e),this.PART(st,1,e)),u<F&&(f=K[u][U],O=Math.max(O,-l-f),w=Math.max(w,l-f));for(T=G*(O-w)>2*l?-1:1,f=0,c=1;c<=e;++c)st[c]=T*st[c],Q[c][b]=st[c],f+=Z[b][c]*st[c];for(u=1;u<=e;++u)Z[b][u]/=f;for(d=1;d<=e;++d){if(d!==b)for(f=this.DOT_PRODUCT(this.PART(this.ROW(Z,d),1,e),this.PART(st,1,e)),u=1;u<=e;++u)Z[d][u]-=f*Z[b][u];s[d]=Q[d][U]+st[d]}continue t}if(!(H=this.trstlp(e,i,tt,W,J,st))){for(f=0,u=1;u<=e;++u)f+=st[u]*st[u];if(f<.25*J*J){v=!0;break i}}for(l=0,N=0,W[F]=0,u=1;u<=F;++u)l=W[u]-this.DOT_PRODUCT(this.PART(this.COL(tt,u),1,e),this.PART(st,1,e)),u<F&&(N=Math.max(N,l));if(G<1.5*(M=($=K[r][U]-N)>0?l/$:0))for(G=2*M,a>=2&&console.log("Increase in PARMU to "+G),A=K[F][U]+G*K[r][U],d=1;d<=e;++d)if((f=K[F][d]+G*K[r][d])<A||f===A&&0===G&&K[r][d]<K[r][U])continue e;for(q=G*$-l,u=1;u<=e;++u)s[u]=Q[u][U]+st[u];v=!0;continue t}for(y=!1,R=K[F][U]+G*K[r][U]-(j+G*X),0===G&&j===K[F][U]&&(q=$,R=K[r][U]-X),L=R<=0?1:0,b=0,d=1;d<=e;++d)(f=Math.abs(this.DOT_PRODUCT(this.PART(this.ROW(Z,d),1,e),this.PART(st,1,e))))>L&&(b=d,L=f),rt[d]=f*et[d];for(k=1.1*J,p=0,d=1;d<=e;++d)if(rt[d]>=V||rt[d]>=et[d]){if(f=it[d],R>0){for(f=0,u=1;u<=e;++u)f+=Math.pow(st[u]-Q[u][d],2);f=Math.sqrt(f)}f>k&&(p=d,k=f)}if(p>0&&(b=p),0!==b){for(f=0,c=1;c<=e;++c)Q[c][b]=st[c],f+=Z[b][c]*st[c];for(u=1;u<=e;++u)Z[b][u]/=f;for(d=1;d<=e;++d)if(d!==b)for(f=this.DOT_PRODUCT(this.PART(this.ROW(Z,d),1,e),this.PART(st,1,e)),u=1;u<=e;++u)Z[d][u]-=f*Z[b][u];for(u=1;u<=r;++u)K[u][b]=W[u];if(R>0&&R>=.1*q)continue e}}while(0);if(z){if(J<=n){D=this.Normal;break t}if(B=0,I=0,(J*=.5)<=1.5*n&&(J=n),G>0){for(Y=0,u=1;u<=F;++u){for(I=B=K[u][U],c=1;c<=e;++c)B=Math.min(B,K[u][c]),I=Math.max(I,K[u][c]);u<=i&&B<.5*I&&(f=Math.max(I,0)-B,Y=Y<=0?f:Math.min(Y,f))}0===Y?G=0:I-B<G*Y&&(G=(I-B)/Y)}a>=2&&console.log("Reduction in RHO to "+J+"  and PARMU = "+G),2===a&&this.PrintIterationResult(g,K[F][U],K[r][U],this.COL(Q,U),e,a)}else v=!1}}switch(D){case this.Normal:if(a>=1&&console.log("%nNormal return from subroutine COBYLA%n"),H)return a>=1&&this.PrintIterationResult(g,j,X,s,e,a),D;break;case this.MaxIterationsReached:a>=1&&console.log("%nReturn from subroutine COBYLA because the MAXFUN limit has been reached.%n");break;case this.DivergingRoundingErrors:a>=1&&console.log("%nReturn from subroutine COBYLA because rounding errors are becoming damaging.%n")}for(u=1;u<=e;++u)s[u]=Q[u][U];return j=K[F][U],X=K[r][U],a>=1&&this.PrintIterationResult(g,j,X,s,e,a),D},trstlp:function(t,e,i,r,s,o){var n,a,h,l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S,x,O,w,T,N,M,A,R,L,k,B,I,Y,D,j=0,X=0,U=0,F=this.arr2(1+t,1+t),J=this.arr(2+e),G=this.arr(2+e),z=this.arr(1+t),H=this.arr(1+t),V=this.arr(2+e),$=this.arr(2+e),q=e,W=0;for(h=1;h<=t;++h)F[h][h]=1,o[h]=0;if(n=0,a=0,e>=1){for(l=1;l<=e;++l)r[l]>a&&(a=r[l],n=l);for(l=1;l<=e;++l)$[l]=l,G[l]=a-r[l]}c=!0;do{t:for(;;){(!c||c&&0===a)&&(n=q=e+1,$[q]=q,G[q]=0),c=!1,d=0,u=0,p=0,f=0;e:do{if(m=q===e?a:-this.DOT_PRODUCT(this.PART(o,1,t),this.PART(this.COL(i,q),1,t)),0===u||m<d?(d=m,X=W,u=3):W>X?(X=W,u=3):--u,0===u)break t;if(g=0,n<=W){if(n<W){b=$[n],v=G[n],l=n;do{for(_=$[C=l+1],P=this.DOT_PRODUCT(this.PART(this.COL(F,l),1,t),this.PART(this.COL(i,_),1,t)),j=Math.sqrt(P*P+J[C]*J[C]),E=J[C]/j,S=P/j,J[C]=E*J[l],J[l]=j,h=1;h<=t;++h)j=E*F[h][C]+S*F[h][l],F[h][C]=E*F[h][l]-S*F[h][C],F[h][l]=j;$[l]=_,G[l]=G[C],l=C}while(l<W);$[l]=b,G[l]=v}if(--W,q>e)for(j=1/J[W],l=1;l<=t;++l)z[l]=j*F[l][W];else for(j=this.DOT_PRODUCT(this.PART(z,1,t),this.PART(this.COL(F,W+1),1,t)),l=1;l<=t;++l)z[l]-=j*F[l][W+1]}else{for(_=$[n],l=1;l<=t;++l)H[l]=i[l][_];for(x=0,l=t;l>W;){for(P=0,O=0,h=1;h<=t;++h)P+=j=F[h][l]*H[h],O+=Math.abs(j);if(w=O+.1*Math.abs(P),T=O+.2*Math.abs(P),(O>=w||w>=T)&&(P=0),0===x)x=P;else for(C=l+1,E=P/(j=Math.sqrt(P*P+x*x)),S=x/j,x=j,h=1;h<=t;++h)j=E*F[h][l]+S*F[h][C],F[h][C]=E*F[h][C]-S*F[h][l],F[h][l]=j;--l}if(0===x){g=-1,l=W;do{for(N=0,M=0,h=1;h<=t;++h)N+=j=F[h][l]*H[h],M+=Math.abs(j);if(w=M+.1*Math.abs(N),T=M+.2*Math.abs(N),M<w&&w<T){if((j=N/J[l])>0&&$[l]<=e&&(D=G[l]/j,(g<0||D<g)&&(g=D)),l>=2)for(A=$[l],h=1;h<=t;++h)H[h]-=j*i[h][A];V[l]=j}else V[l]=0}while(--l>0);if(g<0)break t;for(l=1;l<=W;++l)G[l]=Math.max(0,G[l]-g*V[l]);if(n<W){b=$[n],v=G[n],l=n;do{for(A=$[C=l+1],P=this.DOT_PRODUCT(this.PART(this.COL(F,l),1,t),this.PART(this.COL(i,A),1,t)),j=Math.sqrt(P*P+J[C]*J[C]),E=J[C]/j,S=P/j,J[C]=E*J[l],J[l]=j,h=1;h<=t;++h)j=E*F[h][C]+S*F[h][l],F[h][C]=E*F[h][l]-S*F[h][C],F[h][l]=j;$[l]=A,G[l]=G[C],l=C}while(l<W);$[l]=b,G[l]=v}if(0===(j=this.DOT_PRODUCT(this.PART(this.COL(F,W),1,t),this.PART(this.COL(i,_),1,t))))break t;J[W]=j,G[n]=0,G[W]=g}else J[++W]=x,G[n]=G[W],G[W]=0;if($[n]=$[W],$[W]=_,q>e&&_!==q){for(l=W-1,P=this.DOT_PRODUCT(this.PART(this.COL(F,l),1,t),this.PART(this.COL(i,_),1,t)),j=Math.sqrt(P*P+J[W]*J[W]),E=J[W]/j,S=P/j,J[W]=E*J[l],J[l]=j,h=1;h<=t;++h)j=E*F[h][W]+S*F[h][l],F[h][W]=E*F[h][l]-S*F[h][W],F[h][l]=j;$[W]=$[l],$[l]=_,j=G[l],G[l]=G[W],G[W]=j}if(q>e)for(j=1/J[W],l=1;l<=t;++l)z[l]=j*F[l][W];else for(_=$[W],j=(this.DOT_PRODUCT(this.PART(z,1,t),this.PART(this.COL(i,_),1,t))-1)/J[W],l=1;l<=t;++l)z[l]-=j*F[l][W]}for(R=s*s,k=0,L=0,h=1;h<=t;++h)Math.abs(o[h])>=1e-6*s&&(R-=o[h]*o[h]),k+=o[h]*z[h],L+=z[h]*z[h];if(R<=0)break t;if(j=Math.sqrt(L*R),Math.abs(k)>=1e-6*j&&(j=Math.sqrt(L*R+k*k)),p=f=R/(j+k),q===e){if(T=p+.2*a,p>=(w=p+.1*a)||w>=T)break e;p=Math.min(p,a)}for(l=1;l<=t;++l)H[l]=o[l]+p*z[l];if(q===e)for(U=a,a=0,l=1;l<=W;++l)j=r[_=$[l]]-this.DOT_PRODUCT(this.PART(this.COL(i,_),1,t),this.PART(H,1,t)),a=Math.max(a,j);l=W;do{for(B=0,I=0,h=1;h<=t;++h)B+=j=F[h][l]*H[h],I+=Math.abs(j);if(w=I+.1*Math.abs(B),T=I+.2*Math.abs(B),(I>=w||w>=T)&&(B=0),V[l]=B/J[l],l>=2)for(_=$[l],h=1;h<=t;++h)H[h]-=V[l]*i[h][_]}while(l-- >=2);for(q>e&&(V[W]=Math.max(0,V[W])),l=1;l<=t;++l)H[l]=o[l]+p*z[l];if(q>W)for(l=W+1;l<=q;++l){for(y=a-r[_=$[l]],Y=a+Math.abs(r[_]),h=1;h<=t;++h)y+=j=i[h][_]*H[h],Y+=Math.abs(j);w=Y+.1*Math.abs(y),T=Y+.2*Math.abs(y),(Y>=w||w>=T)&&(y=0),V[l]=y}for(g=1,n=0,l=1;l<=q;++l)V[l]<0&&(j=G[l]/(G[l]-V[l]))<g&&(g=j,n=l);for(j=1-g,l=1;l<=t;++l)o[l]=j*o[l]+g*H[l];for(l=1;l<=q;++l)G[l]=Math.max(0,j*G[l]+g*V[l]);q===e&&(a=U+g*(a-U))}while(n>0);if(p===f)return!0}}while(q===e);return!1},PrintIterationResult:function(t,e,i,r,s,o){o>1&&console.log("NFVALS = "+t+"  F = "+e+"  MAXCV = "+i),o>1&&console.log("X = "+this.PART(r,1,s))},ROW:function(t,e){return t[e].slice()},COL:function(t,e){var i,r=t.length,s=this.arr(r);for(i=0;i<r;++i)s[i]=t[i][e];return s},PART:function(t,e,i){return t.slice(e,i+1)},FORMAT:function(t){return t.join(",")},DOT_PRODUCT:function(t,e){var i,r=0,s=t.length;for(i=0;i<s;++i)r+=t[i]*e[i];return r}},t.Math.Nlp})),define("math/statistics",["jxg","math/math","utils/type"],(function(t,e,i){"use strict";return e.Statistics={sum:function(t){var e,i=t.length,r=0;for(e=0;e<i;e++)r+=t[e];return r},prod:function(t){var e,i=t.length,r=1;for(e=0;e<i;e++)r*=t[e];return r},mean:function(t){return t.length>0?this.sum(t)/t.length:0},median:function(t){var e,i;return t.length>0?(ArrayBuffer.isView(t)?(e=new Float64Array(t)).sort():(e=t.slice(0)).sort((function(t,e){return t-e})),1&(i=e.length)?e[parseInt(.5*i,10)]:.5*(e[.5*i-1]+e[.5*i])):0},percentile:function(t,e){var r,s,o,n,a,h=[];if(t.length>0){for(ArrayBuffer.isView(t)?(r=new Float64Array(t)).sort():(r=t.slice(0)).sort((function(t,e){return t-e})),s=r.length,n=i.isArray(e)?e:[e],o=0;o<n.length;o++)a=s*n[o]*.01,parseInt(a,10)===a?h.push(.5*(r[a-1]+r[a])):h.push(r[parseInt(a,10)]);return i.isArray(e)?h:h[0]}return 0},variance:function(t){var e,i,r,s=t.length;if(s>1){for(e=this.mean(t),i=0,r=0;r<s;r++)i+=(t[r]-e)*(t[r]-e);return i/(t.length-1)}return 0},sd:function(t){return Math.sqrt(this.variance(t))},weightedMean:function(t,e){if(t.length!==e.length)throw new Error("JSXGraph error (Math.Statistics.weightedMean): Array dimension mismatch.");return t.length>0?this.mean(this.multiply(t,e)):0},max:function(t){return Math.max.apply(this,t)},min:function(t){return Math.min.apply(this,t)},range:function(t){return[this.min(t),this.max(t)]},abs:function(t){var e,r,s;if(i.isArray(t))if(t.map)s=t.map(Math.abs);else for(r=t.length,s=[],e=0;e<r;e++)s[e]=Math.abs(t[e]);else s=ArrayBuffer.isView(t)?t.map(Math.abs):Math.abs(t);return s},add:function(t,e){var r,s,o=[];if(t=i.evalSlider(t),e=i.evalSlider(e),i.isArray(t)&&i.isNumber(e))for(s=t.length,r=0;r<s;r++)o[r]=t[r]+e;else if(i.isNumber(t)&&i.isArray(e))for(s=e.length,r=0;r<s;r++)o[r]=t+e[r];else if(i.isArray(t)&&i.isArray(e))for(s=Math.min(t.length,e.length),r=0;r<s;r++)o[r]=t[r]+e[r];else o=t+e;return o},div:function(t,e){var r,s,o=[];if(t=i.evalSlider(t),e=i.evalSlider(e),i.isArray(t)&&i.isNumber(e))for(s=t.length,r=0;r<s;r++)o[r]=t[r]/e;else if(i.isNumber(t)&&i.isArray(e))for(s=e.length,r=0;r<s;r++)o[r]=t/e[r];else if(i.isArray(t)&&i.isArray(e))for(s=Math.min(t.length,e.length),r=0;r<s;r++)o[r]=t[r]/e[r];else o=t/e;return o},divide:function(){t.deprecated("Statistics.divide()","Statistics.div()"),e.Statistics.div.apply(e.Statistics,arguments)},mod:function(t,r,s){var o,n,a=[],h=function(t,e){return t%e};if((s=i.def(s,!1))&&(h=e.mod),t=i.evalSlider(t),r=i.evalSlider(r),i.isArray(t)&&i.isNumber(r))for(n=t.length,o=0;o<n;o++)a[o]=h(t[o],r);else if(i.isNumber(t)&&i.isArray(r))for(n=r.length,o=0;o<n;o++)a[o]=h(t,r[o]);else if(i.isArray(t)&&i.isArray(r))for(n=Math.min(t.length,r.length),o=0;o<n;o++)a[o]=h(t[o],r[o]);else a=h(t,r);return a},multiply:function(t,e){var r,s,o=[];if(t=i.evalSlider(t),e=i.evalSlider(e),i.isArray(t)&&i.isNumber(e))for(s=t.length,r=0;r<s;r++)o[r]=t[r]*e;else if(i.isNumber(t)&&i.isArray(e))for(s=e.length,r=0;r<s;r++)o[r]=t*e[r];else if(i.isArray(t)&&i.isArray(e))for(s=Math.min(t.length,e.length),r=0;r<s;r++)o[r]=t[r]*e[r];else o=t*e;return o},subtract:function(t,e){var r,s,o=[];if(t=i.evalSlider(t),e=i.evalSlider(e),i.isArray(t)&&i.isNumber(e))for(s=t.length,r=0;r<s;r++)o[r]=t[r]-e;else if(i.isNumber(t)&&i.isArray(e))for(s=e.length,r=0;r<s;r++)o[r]=t-e[r];else if(i.isArray(t)&&i.isArray(e))for(s=Math.min(t.length,e.length),r=0;r<s;r++)o[r]=t[r]-e[r];else o=t-e;return o},TheilSenRegression:function(t){var i,r,s=[],o=[],n=[];for(i=0;i<t.length;i++){for(o.length=0,r=0;r<t.length;r++)Math.abs(t[r].usrCoords[1]-t[i].usrCoords[1])>e.eps&&(o[r]=(t[r].usrCoords[2]-t[i].usrCoords[2])/(t[r].usrCoords[1]-t[i].usrCoords[1]));s[i]=this.median(o),n.push(t[i].usrCoords[2]-s[i]*t[i].usrCoords[1])}return[this.median(n),this.median(s),-1]},generateGaussian:function(t,e){var i,r,s;if(this.hasSpare)return this.hasSpare=!1,this.spare*e+t;do{s=(i=2*Math.random()-1)*i+(r=2*Math.random()-1)*r}while(s>=1||0===s);return s=Math.sqrt(-2*Math.log(s)/s),this.spare=r*s,this.hasSpare=!0,t+e*i*s}},e.Statistics})),define("math/geometry",["jxg","base/constants","base/coords","math/math","math/numerics","utils/type","utils/expect"],(function(t,e,i,r,s,o,n){"use strict";return r.Geometry={},t.extend(r.Geometry,{angle:function(e,i,r){var s,o,n,a,h=[],l=[],c=[];return t.deprecated("Geometry.angle()","Geometry.rad()"),e.coords?(h[0]=e.coords.usrCoords[1],h[1]=e.coords.usrCoords[2]):(h[0]=e[0],h[1]=e[1]),i.coords?(l[0]=i.coords.usrCoords[1],l[1]=i.coords.usrCoords[2]):(l[0]=i[0],l[1]=i[1]),r.coords?(c[0]=r.coords.usrCoords[1],c[1]=r.coords.usrCoords[2]):(c[0]=r[0],c[1]=r[1]),s=h[0]-l[0],o=h[1]-l[1],n=c[0]-l[0],a=c[1]-l[1],Math.atan2(s*a-o*n,s*n+o*a)},trueAngle:function(t,e,i){return 57.29577951308232*this.rad(t,e,i)},rad:function(t,e,i){var r,s,o,n,a,h,l;return t.coords?(r=t.coords.usrCoords[1],s=t.coords.usrCoords[2]):(r=t[0],s=t[1]),e.coords?(o=e.coords.usrCoords[1],n=e.coords.usrCoords[2]):(o=e[0],n=e[1]),i.coords?(a=i.coords.usrCoords[1],h=i.coords.usrCoords[2]):(a=i[0],h=i[1]),(l=Math.atan2(h-n,a-o)-Math.atan2(s-n,r-o))<0&&(l+=6.283185307179586),l},angleBisector:function(t,r,s,n){var a,h,l,c,d,u=t.coords.usrCoords,p=r.coords.usrCoords,f=s.coords.usrCoords;return o.exists(n)||(n=t.board),0===p[0]?new i(e.COORDS_BY_USER,[1,.5*(u[1]+f[1]),.5*(u[2]+f[2])],n):(c=u[1]-p[1],d=u[2]-p[2],a=Math.atan2(d,c),c=f[1]-p[1],d=f[2]-p[2],l=.5*(a+(h=Math.atan2(d,c))),a>h&&(l+=Math.PI),c=Math.cos(l)+p[1],d=Math.sin(l)+p[2],new i(e.COORDS_BY_USER,[1,c,d],n))},reflection:function(t,r,s){var n,a,h,l,c,d,u=r.coords.usrCoords,p=t.point1.coords.usrCoords,f=t.point2.coords.usrCoords;return o.exists(s)||(s=r.board),l=f[1]-p[1],c=f[2]-p[2],n=u[1]-p[1],d=(l*(u[2]-p[2])-c*n)/(l*l+c*c),a=u[1]+2*d*c,h=u[2]-2*d*l,new i(e.COORDS_BY_USER,[a,h],s)},rotation:function(t,r,s,n){var a,h,l,c,d,u,p=r.coords.usrCoords,f=t.coords.usrCoords;return o.exists(n)||(n=r.board),a=p[1]-f[1],h=p[2]-f[2],d=a*(l=Math.cos(s))-h*(c=Math.sin(s))+f[1],u=a*c+h*l+f[2],new i(e.COORDS_BY_USER,[d,u],n)},perpendicular:function(t,s,n){var a,h,l,c,d,u=t.point1.coords.usrCoords,p=t.point2.coords.usrCoords,f=s.coords.usrCoords;return o.exists(n)||(n=s.board),s===t.point1?(a=u[1]+p[2]-u[2],h=u[2]-p[1]+u[1],d=u[0]*p[0],Math.abs(d)<r.eps&&(a=p[2],h=-p[1]),c=[d,a,h],l=!0):s===t.point2?(a=p[1]+u[2]-p[2],h=p[2]-u[1]+p[1],d=u[0]*p[0],Math.abs(d)<r.eps&&(a=u[2],h=-u[1]),c=[d,a,h],l=!1):Math.abs(r.innerProduct(f,t.stdform,3))<r.eps?(a=f[1]+p[2]-f[2],h=f[2]-p[1]+f[1],d=p[0],Math.abs(d)<r.eps&&(a=p[2],h=-p[1]),l=!0,Math.abs(d)>r.eps&&Math.abs(a-f[1])<r.eps&&Math.abs(h-f[2])<r.eps&&(a=f[1]+u[2]-f[2],h=f[2]-u[1]+f[1],l=!1),c=[d,a,h]):(c=[0,t.stdform[1],t.stdform[2]],c=r.crossProduct(c,f),c=r.crossProduct(c,t.stdform),l=!0),[new i(e.COORDS_BY_USER,c,n),l]},circumcenterMidpoint:function(){t.deprecated("Geometry.circumcenterMidpoint()","Geometry.circumcenter()"),this.circumcenter.apply(this,arguments)},circumcenter:function(t,s,n,a){var h,l,c,d,u=t.coords.usrCoords,p=s.coords.usrCoords,f=n.coords.usrCoords;return o.exists(a)||(a=t.board),h=[p[0]-u[0],-p[2]+u[2],p[1]-u[1]],l=[.5*(u[0]+p[0]),.5*(u[1]+p[1]),.5*(u[2]+p[2])],c=r.crossProduct(h,l),h=[f[0]-p[0],-f[2]+p[2],f[1]-p[1]],l=[.5*(p[0]+f[0]),.5*(p[1]+f[1]),.5*(p[2]+f[2])],d=r.crossProduct(h,l),new i(e.COORDS_BY_USER,r.crossProduct(c,d),a)},distance:function(t,e,i){var r,s=0;for(i||(i=Math.min(t.length,e.length)),r=0;r<i;r++)s+=(t[r]-e[r])*(t[r]-e[r]);return Math.sqrt(s)},affineDistance:function(t,e,i){var s;return(s=this.distance(t,e,i))>r.eps&&(Math.abs(t[0])<r.eps||Math.abs(e[0])<r.eps)?1/0:s},affineRatio:function(t,e,i){var s;return o.exists(t.usrCoords)&&(t=t.usrCoords),o.exists(e.usrCoords)&&(e=e.usrCoords),o.exists(i.usrCoords)&&(i=i.usrCoords),s=e[1]-t[1],Math.abs(s)>r.eps?(i[1]-t[1])/s:(i[2]-t[2])/(e[2]-t[2])},sortVertices:function(t){for(var e,i=n.each(t,n.coordsArray),r=i.length,s=null;i[0][0]===i[r-1][0]&&i[0][1]===i[r-1][1]&&i[0][2]===i[r-1][2];)s=i.pop(),r--;return e=i[0],i.sort((function(t,i){return(t[2]===e[2]&&t[1]===e[1]?-1/0:Math.atan2(t[2]-e[2],t[1]-e[1]))-(i[2]===e[2]&&i[1]===e[1]?-1/0:Math.atan2(i[2]-e[2],i[1]-e[1]))})),null!==s&&i.push(s),i},signedTriangle:function(t,e,i){var r=n.coordsArray(t),s=n.coordsArray(e),o=n.coordsArray(i);return.5*((s[1]-r[1])*(o[2]-r[2])-(s[2]-r[2])*(o[1]-r[1]))},signedPolygon:function(t,e){var i,r,s=0,o=n.each(t,n.coordsArray);for(void 0===e&&(e=!0),e?o.unshift(o[o.length-1]):o=this.sortVertices(o),r=o.length,i=1;i<r;i++)s+=o[i-1][1]*o[i][2]-o[i][1]*o[i-1][2];return.5*s},GrahamScan:function(t){var e,i=1,r=n.each(t,n.coordsArray),s=r.length;for(s=(r=this.sortVertices(r)).length,e=2;e<s;e++){for(;this.signedTriangle(r[i-1],r[i],r[e])<=0;){if(i>1)i-=1;else if(e===s-1)break;e+=1}i+=1,r=o.swap(r,i,e)}return r.slice(0,i)},calcStraight:function(t,i,s,n){var a,h,l,c,d,u,p,f,m,g;if(o.exists(n)||(n=10),u=o.evaluate(t.visProp.straightfirst),p=o.evaluate(t.visProp.straightlast),Math.abs(i.scrCoords[0])<r.eps&&(u=!0),Math.abs(s.scrCoords[0])<r.eps&&(p=!0),(u||p)&&((f=[])[0]=t.stdform[0]-t.stdform[1]*t.board.origin.scrCoords[1]/t.board.unitX+t.stdform[2]*t.board.origin.scrCoords[2]/t.board.unitY,f[1]=t.stdform[1]/t.board.unitX,f[2]=-t.stdform[2]/t.board.unitY,!isNaN(f[0]+f[1]+f[2]))){if(!1,!1,a=!u&&Math.abs(i.usrCoords[0])>=r.eps&&i.scrCoords[1]>=0&&i.scrCoords[1]<=t.board.canvasWidth&&i.scrCoords[2]>=0&&i.scrCoords[2]<=t.board.canvasHeight,h=!p&&Math.abs(s.usrCoords[0])>=r.eps&&s.scrCoords[1]>=0&&s.scrCoords[1]<=t.board.canvasWidth&&s.scrCoords[2]>=0&&s.scrCoords[2]<=t.board.canvasHeight,c=(l=this.meetLineBoard(f,t.board,n))[0],d=l[1],!a&&!h){if(!u&&p&&!this.isSameDirection(i,s,c)&&!this.isSameDirection(i,s,d))return;if(u&&!p&&!this.isSameDirection(s,i,c)&&!this.isSameDirection(s,i,d))return}a?h||(g=this.isSameDir(i,s,c,d)?d:c):h?m=this.isSameDir(i,s,c,d)?c:d:this.isSameDir(i,s,c,d)?(m=c,g=d):(g=c,m=d),m&&i.setCoordinates(e.COORDS_BY_USER,m.usrCoords),g&&s.setCoordinates(e.COORDS_BY_USER,g.usrCoords)}},calcLineDelimitingPoints:function(t,i,s){var n,a,h,l,c,d,u,p,f,m,g;if(c=o.evaluate(t.visProp.straightfirst),d=o.evaluate(t.visProp.straightlast),Math.abs(i.scrCoords[0])<r.eps&&(c=!0),Math.abs(s.scrCoords[0])<r.eps&&(d=!0),(u=[])[0]=t.stdform[0]-t.stdform[1]*t.board.origin.scrCoords[1]/t.board.unitX+t.stdform[2]*t.board.origin.scrCoords[2]/t.board.unitY,u[1]=t.stdform[1]/t.board.unitX,u[2]=-t.stdform[2]/t.board.unitY,!isNaN(u[0]+u[1]+u[2])){if(m=!c,g=!d,a=t.board.getBoundingBox(),t.getSlope()>=0?(h=this.projectPointToLine({coords:{usrCoords:[1,a[2],a[1]]}},t,t.board),l=this.projectPointToLine({coords:{usrCoords:[1,a[0],a[3]]}},t,t.board)):(h=this.projectPointToLine({coords:{usrCoords:[1,a[0],a[1]]}},t,t.board),l=this.projectPointToLine({coords:{usrCoords:[1,a[2],a[3]]}},t,t.board)),!m&&!g){if(!c&&!d){if(n=i.distance(e.COORDS_BY_USER,s),Math.abs(i.distance(e.COORDS_BY_USER,h)+h.distance(e.COORDS_BY_USER,s)-n)>r.eps)return;if(Math.abs(i.distance(e.COORDS_BY_USER,l)+l.distance(e.COORDS_BY_USER,s)-n)>r.eps)return}if(!c&&d&&!this.isSameDirection(i,s,h)&&!this.isSameDirection(i,s,l))return;if(c&&!d&&!this.isSameDirection(s,i,h)&&!this.isSameDirection(s,i,l))return}m?g||(f=this.isSameDir(i,s,h,l)?l:h):g?p=this.isSameDir(i,s,h,l)?h:l:this.isSameDir(i,s,h,l)?(p=h,f=l):(f=h,p=l),p&&i.setCoordinates(e.COORDS_BY_USER,p.usrCoords),f&&s.setCoordinates(e.COORDS_BY_USER,f.usrCoords)}},calcLabelQuadrant:function(t){return t<0&&(t+=2*Math.PI),["rt","urt","top","ulft","lft","llft","lrt"][Math.floor((t+Math.PI/8)/(Math.PI/4))%8]},isSameDir:function(t,e,i,s){var o=e.usrCoords[1]-t.usrCoords[1],n=e.usrCoords[2]-t.usrCoords[2],a=s.usrCoords[1]-i.usrCoords[1],h=s.usrCoords[2]-i.usrCoords[2];return Math.abs(e.usrCoords[0])<r.eps&&(o=e.usrCoords[1],n=e.usrCoords[2]),Math.abs(t.usrCoords[0])<r.eps&&(o=-t.usrCoords[1],n=-t.usrCoords[2]),o*a+n*h>=0},isSameDirection:function(t,e,i){var s,o,n,a,h=!1;return s=e.usrCoords[1]-t.usrCoords[1],o=e.usrCoords[2]-t.usrCoords[2],n=i.usrCoords[1]-t.usrCoords[1],a=i.usrCoords[2]-t.usrCoords[2],Math.abs(s)<r.eps&&(s=0),Math.abs(o)<r.eps&&(o=0),Math.abs(n)<r.eps&&(n=0),Math.abs(a)<r.eps&&(a=0),(s>=0&&n>=0||s<=0&&n<=0)&&(h=o>=0&&a>=0||o<=0&&a<=0),h},intersectionFunction:function(s,n,a,h,l,c){var d,u,p=this;return d=n.elementClass===e.OBJECT_CLASS_CURVE&&(n.type===e.OBJECT_TYPE_ARC||n.type===e.OBJECT_TYPE_SECTOR),u=a.elementClass===e.OBJECT_CLASS_CURVE&&(a.type===e.OBJECT_TYPE_ARC||a.type===e.OBJECT_TYPE_SECTOR),n.elementClass!==e.OBJECT_CLASS_CURVE&&a.elementClass!==e.OBJECT_CLASS_CURVE||n.elementClass!==e.OBJECT_CLASS_CURVE&&n.elementClass!==e.OBJECT_CLASS_CIRCLE||a.elementClass!==e.OBJECT_CLASS_CURVE&&a.elementClass!==e.OBJECT_CLASS_CIRCLE?n.elementClass===e.OBJECT_CLASS_CURVE&&!d&&a.elementClass===e.OBJECT_CLASS_LINE||a.elementClass===e.OBJECT_CLASS_CURVE&&!u&&n.elementClass===e.OBJECT_CLASS_LINE?function(){return p.meetCurveLine(n,a,h,n.board,c)}:n.elementClass===e.OBJECT_CLASS_LINE&&a.elementClass===e.OBJECT_CLASS_LINE?function(){var t,r,s=o.evaluate(n.visProp.straightfirst),l=o.evaluate(n.visProp.straightlast),d=o.evaluate(a.visProp.straightfirst),u=o.evaluate(a.visProp.straightlast);return o.evaluate(c)||s&&l&&d&&u?p.meet(n.stdform,a.stdform,h,n.board):(t=p.meetSegmentSegment(n.point1.coords.usrCoords,n.point2.coords.usrCoords,a.point1.coords.usrCoords,a.point2.coords.usrCoords),r=!s&&t[1]<0||!l&&t[1]>1||!d&&t[2]<0||!u&&t[2]>1?[0,NaN,NaN]:t[0],new i(e.COORDS_BY_USER,r,n.board))}:function(){var s,l,f,m=p.meet(n.stdform,a.stdform,h,n.board),g=!0;return c?m:(n.elementClass!==e.OBJECT_CLASS_LINE||(s=o.evaluate(n.visProp.straightfirst),l=o.evaluate(n.visProp.straightlast),s&&l||(f=p.affineRatio(n.point1.coords,n.point2.coords,m),!(!l&&f>1+r.eps||!s&&f<0-r.eps))))&&(a.elementClass!==e.OBJECT_CLASS_LINE||(s=o.evaluate(a.visProp.straightfirst),l=o.evaluate(a.visProp.straightlast),s&&l||(f=p.affineRatio(a.point1.coords,a.point2.coords,m),!(!l&&f>1+r.eps||!s&&f<0-r.eps))))?d&&((g=p.coordsOnArc(n,m))&&u&&(g=p.coordsOnArc(a,m)),!g)?new i(t.COORDS_BY_USER,[0,NaN,NaN],n.board):m:new i(t.COORDS_BY_USER,[0,NaN,NaN],n.board)}:function(){return p.meetCurveCurve(n,a,h,l,n.board)}},coordsOnArc:function(t,e){var i=this.rad(t.radiuspoint,t.center,e.usrCoords.slice(1)),r=0,s=this.rad(t.radiuspoint,t.center,t.anglepoint),n=o.evaluate(t.visProp.selection);return("minor"===n&&s>Math.PI||"major"===n&&s<Math.PI)&&(r=s,s=2*Math.PI),!(i<r||i>s)},meet:function(t,e,i,s){var o=r.eps;return Math.abs(t[3])<o&&Math.abs(e[3])<o?this.meetLineLine(t,e,i,s):Math.abs(t[3])>=o&&Math.abs(e[3])<o?this.meetLineCircle(e,t,i,s):Math.abs(t[3])<o&&Math.abs(e[3])>=o?this.meetLineCircle(t,e,i,s):this.meetCircleCircle(t,e,i,s)},meetLineBoard:function(t,s,n){var a,h,l,c,d=[];for(o.exists(n)||(n=0),d[0]=r.crossProduct(t,[n,0,1]),d[1]=r.crossProduct(t,[n,1,0]),d[2]=r.crossProduct(t,[-n-s.canvasHeight,0,1]),d[3]=r.crossProduct(t,[-n-s.canvasWidth,1,0]),l=0;l<4;l++)if(Math.abs(d[l][0])>r.eps){for(c=2;c>0;c--)d[l][c]/=d[l][0];d[l][0]=1}return Math.abs(d[1][0])<r.eps?(a=d[0],h=d[2]):Math.abs(d[0][0])<r.eps?(a=d[1],h=d[3]):d[1][2]<0?(a=d[0],h=d[3][2]>s.canvasHeight?d[2]:d[3]):d[1][2]>s.canvasHeight?(a=d[2],h=d[3][2]<0?d[0]:d[3]):(a=d[1],h=d[3][2]<0?d[0]:d[3][2]>s.canvasHeight?d[2]:d[3]),[a=new i(e.COORDS_BY_SCREEN,a.slice(1),s),h=new i(e.COORDS_BY_SCREEN,h.slice(1),s)]},meetLineLine:function(t,s,o,n){var a=isNaN(t[5]+s[5])?[0,0,0]:r.crossProduct(t,s);return new i(e.COORDS_BY_USER,a,n)},meetLineCircle:function(t,s,o,n){var a,h,l,c,d,u,p,f,m;return s[4]<r.eps?Math.abs(r.innerProduct([1,s[6],s[7]],t,3))<r.eps?new i(e.COORDS_BY_USER,s.slice(6,8),n):new i(e.COORDS_BY_USER,[NaN,NaN],n):(l=s[0],h=s.slice(1,3),a=s[3],c=t[0],d=t.slice(1,3),u=a,(f=(p=h[0]*d[1]-h[1]*d[0])*p-4*u*(a*c*c-(h[0]*d[0]+h[1]*d[1])*c+l))>-r.eps*r.eps?(m=[(-p+(f=Math.sqrt(Math.abs(f))))/(2*u),(-p-f)/(2*u)],new i(e.COORDS_BY_USER,0===o?[-m[0]*-d[1]-c*d[0],-m[0]*d[0]-c*d[1]]:[-m[1]*-d[1]-c*d[0],-m[1]*d[0]-c*d[1]],n)):new i(e.COORDS_BY_USER,[0,0,0],n))},meetCircleCircle:function(t,s,o,n){var a;return t[4]<r.eps?Math.abs(this.distance(t.slice(6,2),s.slice(6,8))-s[4])<r.eps?new i(e.COORDS_BY_USER,t.slice(6,8),n):new i(e.COORDS_BY_USER,[0,0,0],n):s[4]<r.eps?Math.abs(this.distance(s.slice(6,2),t.slice(6,8))-t[4])<r.eps?new i(e.COORDS_BY_USER,s.slice(6,8),n):new i(e.COORDS_BY_USER,[0,0,0],n):(a=[s[3]*t[0]-t[3]*s[0],s[3]*t[1]-t[3]*s[1],s[3]*t[2]-t[3]*s[2],0,1,1/0,1/0,1/0],a=r.normalize(a),this.meetLineCircle(a,t,o,n))},meetCurveCurve:function(t,r,n,a,h,l){var c;return c=o.exists(l)&&"newton"===l?s.generalizedNewton(t,r,n,a):3===t.bezierDegree||3===r.bezierDegree?this.meetBezierCurveRedBlueSegments(t,r,n):this.meetCurveRedBlueSegments(t,r,n),new i(e.COORDS_BY_USER,c,h)},meetCurveLine:function(t,i,r,s,n){var a,h;return o.exists(s)||(s=t.board),t.elementClass===e.OBJECT_CLASS_CURVE?(a=t,h=i):(a=i,h=t),this.meetCurveLineDiscrete(a,h,r,s,!n)},meetCurveLineContinuous:function(t,o,n,a,h){var l,c,d,u,p,f,m,g,b,v,y,C,_,P=r.eps,E=r.eps;for(u=this.meetCurveLineDiscrete(t,o,n,a,h),p=u.usrCoords[1],f=u.usrCoords[2],c=function(e){var i,r;return e>t.maxX()||e<t.minX()?1/0:(i=p-t.X(e))*i+(r=f-t.Y(e))*r},d=function(e){var i=o.stdform[0]+o.stdform[1]*t.X(e)+o.stdform[2]*t.Y(e);return i*i},50,g=(t.maxX()-t.minX())/50,b=t.minX(),C=1e-4,y=NaN,v=0;v<50&&(l=s.root(c,[Math.max(b,t.minX()),Math.min(b+g,t.maxX())]),!((_=Math.abs(c(l)))<=C&&(y=l,(C=_)<P)));v++)b+=g;return l=y,_=d(l=s.root(d,[Math.max(l-g,t.minX()),Math.min(l+g,t.maxX())])),m=isNaN(_)||Math.abs(_)>E?0:1,new i(e.COORDS_BY_USER,[m,t.X(l),t.Y(l)],a)},meetCurveLineDiscrete:function(t,s,n,a,h){var l,c,d,u,p,f,m,g=s.point1.coords.usrCoords,b=s.point2.coords.usrCoords,v=0,y=t.numberPoints,C=o.evaluate(s.visProp.straightfirst),_=o.evaluate(s.visProp.straightlast);for(f=new i(e.COORDS_BY_USER,[0,NaN,NaN],a),0===g[0]?g=[1,b[1]+s.stdform[2],b[2]-s.stdform[1]]:0===b[0]&&(b=[1,g[1]+s.stdform[2],g[2]-s.stdform[1]]),u=t.points[0].usrCoords,l=1;l<y;l+=t.bezierDegree)if(d=u.slice(0),u=t.points[l].usrCoords,this.distance(d,u)>r.eps)for(m=3===t.bezierDegree?this.meetBeziersegmentBeziersegment([t.points[l-1].usrCoords.slice(1),t.points[l].usrCoords.slice(1),t.points[l+1].usrCoords.slice(1),t.points[l+2].usrCoords.slice(1)],[g.slice(1),b.slice(1)],h):[this.meetSegmentSegment(d,u,g,b)],c=0;c<m.length;c++)if(0<=(p=m[c])[1]&&p[1]<=1){if(v===n)return h&&(!C&&p[2]<0||!_&&p[2]>1)?f:f=new i(e.COORDS_BY_USER,p[0],a);v+=1}return f},meetCurveRedBlueSegments:function(t,e,i){var r,s,o,n,a,h,l,c,d,u=0,p=e.numberPoints,f=t.numberPoints;if(p<=1||f<=1)return[0,NaN,NaN];for(r=1;r<f;r++)for(o=t.points[r-1].usrCoords,n=t.points[r].usrCoords,c=Math.min(o[1],n[1]),d=Math.max(o[1],n[1]),h=e.points[0].usrCoords,s=1;s<p;s++)if(a=h,h=e.points[s].usrCoords,Math.min(a[1],h[1])<d&&Math.max(a[1],h[1])>c&&(l=this.meetSegmentSegment(o,n,a,h))[1]>=0&&l[2]>=0&&(l[1]<1&&l[2]<1||r===f-1&&1===l[1]||s===p-1&&1===l[2])){if(u===i)return l[0];u++}return[0,NaN,NaN]},meetSegmentSegment:function(t,e,i,s){var o,n,a,h=r.crossProduct(t,e),l=r.crossProduct(i,s),c=r.crossProduct(h,l);return Math.abs(c[0])<r.eps?[c,1/0,1/0]:(c[1]/=c[0],c[2]/=c[0],c[0]/=c[0],a=t[n=Math.abs(e[1]-e[0]*t[1])<r.eps?2:1]/t[0],o=(c[n]-a)/(0!==e[0]?e[n]/e[0]-a:e[n]),a=i[n=Math.abs(s[1]-s[0]*i[1])<r.eps?2:1]/i[0],[c,o,(c[n]-a)/(0!==s[0]?s[n]/s[0]-a:s[n])])},_bezierSplit:function(t){var e,i,r,s,o,n;return e=[.5*(t[0][0]+t[1][0]),.5*(t[0][1]+t[1][1])],i=[.5*(t[1][0]+t[2][0]),.5*(t[1][1]+t[2][1])],r=[.5*(t[2][0]+t[3][0]),.5*(t[2][1]+t[3][1])],n=[.5*((s=[.5*(e[0]+i[0]),.5*(e[1]+i[1])])[0]+(o=[.5*(i[0]+r[0]),.5*(i[1]+r[1])])[0]),.5*(s[1]+o[1])],[[t[0],e,s,n],[n,o,r,t[3]]]},_bezierBbox:function(t){var e=[];return 4===t.length?(e[0]=Math.min(t[0][0],t[1][0],t[2][0],t[3][0]),e[1]=Math.max(t[0][1],t[1][1],t[2][1],t[3][1]),e[2]=Math.max(t[0][0],t[1][0],t[2][0],t[3][0]),e[3]=Math.min(t[0][1],t[1][1],t[2][1],t[3][1])):(e[0]=Math.min(t[0][0],t[1][0]),e[1]=Math.max(t[0][1],t[1][1]),e[2]=Math.max(t[0][0],t[1][0]),e[3]=Math.min(t[0][1],t[1][1])),e},_bezierOverlap:function(t,e){return t[2]>=e[0]&&t[0]<=e[2]&&t[1]>=e[3]&&t[3]<=e[1]},_bezierListConcat:function(t,e,i,r){var s,n=o.exists(r),a=0,h=e.length,l=t.length;for(l>0&&h>0&&(1===t[l-1][1]&&0===e[0][1]||n&&1===t[l-1][2]&&0===e[0][2])&&(a=1),s=a;s<h;s++)n&&(e[s][2]*=.5,e[s][2]+=r),e[s][1]*=.5,e[s][1]+=i,t.push(e[s])},_bezierMeetSubdivision:function(t,e,i){var r,s,o,n,a,h,l,c,d,u,p,f,m=[];return s=this._bezierBbox(e),r=this._bezierBbox(t),this._bezierOverlap(s,r)?i<5?(h=(o=this._bezierSplit(t))[0],l=o[1],n=(o=this._bezierSplit(e))[0],a=o[1],this._bezierListConcat(m,this._bezierMeetSubdivision(h,n,i+1),0,0),this._bezierListConcat(m,this._bezierMeetSubdivision(h,a,i+1),0,.5),this._bezierListConcat(m,this._bezierMeetSubdivision(l,n,i+1),.5,0),this._bezierListConcat(m,this._bezierMeetSubdivision(l,a,i+1),.5,.5),m):(p=[1].concat(t[0]),f=[1].concat(t[3]),d=[1].concat(e[0]),u=[1].concat(e[3]),(c=this.meetSegmentSegment(p,f,d,u))[1]>=0&&c[2]>=0&&c[1]<=1&&c[2]<=1?[c]:[]):[]},_bezierLineMeetSubdivision:function(t,e,i,r){var s,o,n,a,h,l,c,d,u,p,f=[];return s=this._bezierBbox(e),o=this._bezierBbox(t),r&&!this._bezierOverlap(o,s)?[]:i<5?(a=(n=this._bezierSplit(t))[0],h=n[1],this._bezierListConcat(f,this._bezierLineMeetSubdivision(a,e,i+1),0),this._bezierListConcat(f,this._bezierLineMeetSubdivision(h,e,i+1),.5),f):(u=[1].concat(t[0]),p=[1].concat(t[3]),c=[1].concat(e[0]),d=[1].concat(e[1]),(l=this.meetSegmentSegment(u,p,c,d))[1]>=0&&l[1]<=1&&(!r||l[2]>=0&&l[2]<=1)?[l]:[])},meetBeziersegmentBeziersegment:function(t,e,i){var r,s,o;for((r=4===t.length&&4===e.length?this._bezierMeetSubdivision(t,e,0):this._bezierLineMeetSubdivision(t,e,0,i)).sort((function(t,e){return 1e7*(t[1]-e[1])+(t[2]-e[2])})),s=[],o=0;o<r.length;o++)0!==o&&r[o][1]===r[o-1][1]&&r[o][2]===r[o-1][2]||s.push(r[o]);return s},meetBezierCurveRedBlueSegments:function(t,i,s){var o,n,a,h,l,c,d,u,p,f,m=0,g=0,b=i.numberPoints,v=t.numberPoints,y=[];if(b<i.bezierDegree+1||v<t.bezierDegree+1)return[0,NaN,NaN];for(b-=i.bezierDegree,v-=t.bezierDegree,t.type===e.OBJECT_TYPE_SECTOR&&(m=3,v-=3),i.type===e.OBJECT_TYPE_SECTOR&&(g=3,b-=3),n=m;n<v;n+=t.bezierDegree)for(c=[(o=t.points)[n].usrCoords.slice(1),o[n+1].usrCoords.slice(1)],3===t.bezierDegree&&(c[2]=o[n+2].usrCoords.slice(1),c[3]=o[n+3].usrCoords.slice(1)),u=this._bezierBbox(c),a=g;a<b;a+=i.bezierDegree)if(d=[(o=i.points)[a].usrCoords.slice(1),o[a+1].usrCoords.slice(1)],3===i.bezierDegree&&(d[2]=o[a+2].usrCoords.slice(1),d[3]=o[a+3].usrCoords.slice(1)),p=this._bezierBbox(d),this._bezierOverlap(u,p)){if(0===(f=this.meetBeziersegmentBeziersegment(c,d)).length)continue;for(h=0;h<f.length;h++)(l=f[h])[1]<-r.eps||l[1]>1+r.eps||l[2]<-r.eps||l[2]>1+r.eps||y.push(l);if(y.length>s)return y[s][0]}return y.length>s?y[s][0]:[0,NaN,NaN]},bezierSegmentEval:function(t,e){var i,r,s,o=1-t;return r=0,s=0,r+=(i=o*o*o)*e[0][0],s+=i*e[0][1],r+=(i=3*t*o*o)*e[1][0],s+=i*e[1][1],r+=(i=3*t*t*o)*e[2][0],s+=i*e[2][1],[1,r+=(i=t*t*t)*e[3][0],s+=i*e[3][1]]},bezierArc:function(t,e,i,s,o){var n,a,h,l,c,d,u,p,f,m,g,b,v,y,C,_,P,E=.5*Math.PI,S=e[1],x=e[2],O=e[0],w=[],T=[];for(c=this.distance(e,t),S/=O,x/=O,d=this.rad(t.slice(1),e.slice(1),i.slice(1)),-1===o&&(d=2*Math.PI-d),(n=t)[1]/=n[0],n[2]/=n[0],n[0]/=n[0],l=n.slice(0),s?(w=[S,S+.333*(n[1]-S),S+.666*(n[1]-S),n[1]],T=[x,x+.333*(n[2]-x),x+.666*(n[2]-x),n[2]]):(w=[n[1]],T=[n[2]]);d>r.eps;)d>E?(u=E,d-=E):(u=d,d=0),P=[[1,0,0],[S*(1-(p=Math.cos(o*u)))+x*(f=Math.sin(o*u)),p,-f],[x*(1-p)-S*f,f,p]],l=[(C=r.matVecMult(P,n))[0]/C[0],C[1]/C[0],C[2]/C[0]],m=n[1]-S,g=n[2]-x,b=l[1]-S,v=l[2]-x,_=Math.sqrt((m+b)*(m+b)+(g+v)*(g+v)),y=Math.abs(v-g)>r.eps?(m+b)*(c/_-.5)/(v-g)*8/3:(g+v)*(c/_-.5)/(m-b)*8/3,a=[1,n[1]-y*g,n[2]+y*m],h=[1,l[1]+y*v,l[2]-y*b],w=w.concat([a[1],h[1],l[1]]),T=T.concat([a[2],h[2],l[2]]),n=l.slice(0);return s&&(w=w.concat([l[1]+.333*(S-l[1]),l[1]+.666*(S-l[1]),S]),T=T.concat([l[2]+.333*(x-l[2]),l[2]+.666*(x-l[2]),x])),[w,T]},projectPointToCircle:function(t,s,n){var a,h,l,c,d,u=s.center.coords.usrCoords;return o.exists(n)||(n=t.board),o.isPoint(t)?(a=t.coords.distance(e.COORDS_BY_USER,s.center.coords),h=t.coords.usrCoords):(a=t.distance(e.COORDS_BY_USER,s.center.coords),h=t.usrCoords),Math.abs(a)<r.eps&&(a=r.eps),d=s.Radius()/a,l=u[1]+d*(h[1]-u[1]),c=u[2]+d*(h[2]-u[2]),new i(e.COORDS_BY_USER,[l,c],n)},projectPointToLine:function(t,s,n){var a,h=[0,s.stdform[1],s.stdform[2]];return o.exists(n)||(n=o.exists(t.coords)?t.board:s.board),a=o.exists(t.coords)?t.coords.usrCoords:t.usrCoords,h=r.crossProduct(h,a),new i(e.COORDS_BY_USER,r.crossProduct(h,s.stdform),n)},projectCoordsToSegment:function(t,e,i){var s,o=[i[1]-e[1],i[2]-e[2]],n=[t[1]-e[1],t[2]-e[2]];return Math.abs(o[0])<r.eps&&Math.abs(o[1])<r.eps?[e,0]:(s=r.innerProduct(n,o),[[1,(s/=r.innerProduct(o,o))*o[0]+e[1],s*o[1]+e[2]],s])},projectCoordsToBeziersegment:function(e,i,r){var s;return s=t.Math.Numerics.fminbr((function(t){var s=[1,i.X(r+t),i.Y(r+t)];return s[1]-=e[1],s[2]-=e[2],s[1]*s[1]+s[2]*s[2]}),[0,1]),[[1,i.X(s+r),i.Y(s+r)],s]},projectPointToCurve:function(t,e,i){o.exists(i)||(i=t.board);var r=t.X(),s=t.Y(),n=t.position||0;return this.projectCoordsToCurve(r,s,n,e,i)},projectCoordsToCurve:function(t,r,n,a,h){var l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S,x,O,w,T,N=Number.POSITIVE_INFINITY;if(o.exists(h)||(h=a.board),"plot"===o.evaluate(a.visProp.curvetype)){if(n=0,p=N,l=0===a.numberPoints?[0,1,1]:[a.Z(0),a.X(0),a.Y(0)],a.numberPoints>1)for(g=[1,t,r],3===a.bezierDegree?u=0:y=[a.Z(0),a.X(0),a.Y(0)],d=0;d<a.numberPoints-1;d++)3===a.bezierDegree?_=this.projectCoordsToBeziersegment(g,a,u):(C=[a.Z(d+1),a.X(d+1),a.Y(d+1)],_=this.projectCoordsToSegment(g,y,C)),m=_[1],b=_[0],0<=m&&m<=1?(f=this.distance(b,g),v=d+m):m<0?(b=y,f=this.distance(y,g),v=d):m>1&&d===a.numberPoints-2&&(b=C,f=this.distance(b,g),v=a.numberPoints-1),f<p&&(p=f,n=v,l=b),3===a.bezierDegree?(u++,d+=2):y=C;c=new i(e.COORDS_BY_USER,l,h)}else{for(P=function(e){var i,s;return e<a.minX()||e>a.maxX()?1/0:(i=t-a.X(e))*i+(s=r-a.Y(e))*s},x=P(n),50,w=a.minX(),O=((T=a.maxX())-w)/50,E=w,d=0;d<50;d++)((S=P(E))<x||x===1/0)&&(n=E,x=S),E+=O;n=(n=(n=s.fminbr(P,[Math.max(n-O,w),Math.min(n+O,T)]))<w?w:n)>T?T:n,c=new i(e.COORDS_BY_USER,[a.X(n),a.Y(n)],h)}return[a.updateTransform(c),n]},projectCoordsToPolygon:function(e,i){var r,s,o,n,a,h=i.vertices.length,l=1/0;for(r=0;r<h-1;r++)0<=(o=t.Math.Geometry.projectCoordsToSegment(e,i.vertices[r].coords.usrCoords,i.vertices[r+1].coords.usrCoords))[1]&&o[1]<=1?(s=t.Math.Geometry.distance(o[0],e,3),n=o[0]):o[1]<0?(s=t.Math.Geometry.distance(i.vertices[r].coords.usrCoords,e,3),n=i.vertices[r].coords.usrCoords):(s=t.Math.Geometry.distance(i.vertices[r+1].coords.usrCoords,e,3),n=i.vertices[r+1].coords.usrCoords),s<l&&(a=n.slice(0),l=s);return a},projectPointToTurtle:function(t,r,s){var n,a,h,l,c,d,u,p,f,m,g=0,b=0,v=Number.POSITIVE_INFINITY,y=r.objects.length;for(o.exists(s)||(s=t.board),c=0;c<y;c++)(u=r.objects[c]).elementClass===e.OBJECT_CLASS_CURVE&&(n=(f=this.projectPointToCurve(t,u))[0],m=f[1],(d=this.distance(n.usrCoords,t.coords.usrCoords))<v&&(h=n.usrCoords[1],l=n.usrCoords[2],a=m,v=d,p=u,b=g),g+=u.numberPoints);return n=new i(e.COORDS_BY_USER,[h,l],s),[p.updateTransform(n),a+b]},projectPointToPoint:function(t,e){return e.coords},projectPointToBoard:function(t,e){var i,s,o,n=e||t.board,a=[[1,1,0,0,3,0,1],[-1,2,1,0,1,2,1],[-1,1,2,2,1,2,3],[1,2,3,0,3,2,3]],h=t.coords||t,l=n.getBoundingBox();for(i=0;i<4;i++)(o=a[i])[0]*h.usrCoords[o[1]]<o[0]*l[o[2]]&&((s=r.crossProduct([1,l[o[3]],l[o[4]]],[1,l[o[5]],l[o[6]]]))[3]=0,s=r.normalize(s),h=this.projectPointToLine({coords:h},{stdform:s},n));return h},distPointLine:function(t,e){var i,s=e[1],o=e[2],n=e[0];return Math.abs(s)+Math.abs(o)<r.eps?Number.POSITIVE_INFINITY:(i=s*t[1]+o*t[2]+n,s*=s,o*=o,Math.abs(i)/Math.sqrt(s+o))},reuleauxPolygon:function(t,e){var i,s=2*Math.PI,o=s/e,n=(e-1)/2,a=0,h=function(h,l){return function(c,d){var u=(c%s+s)%s,p=Math.floor(u/o)%e;return d||(a=t[0].Dist(t[n]),i=r.Geometry.rad([t[0].X()+1,t[0].Y()],t[0],t[n%e])),isNaN(p)?p:(u=.5*u+p*o*.5+i,t[p][h]()+a*Math[l](u))}};return[h("X","cos"),h("Y","sin"),0,s]}}),r.Geometry})),define("math/plot",["jxg","base/constants","base/coords","math/math","math/extrapolate","math/numerics","math/statistics","math/geometry","math/ia","utils/type"],(function(t,e,i,r,s,o,n,a,h,l){"use strict";return r.Plot={checkReal:function(t){var e,i,s=!1,o=t.length;for(e=0;e<o;e++)if(i=t[e].usrCoords,!isNaN(i[1])&&!isNaN(i[2])&&Math.abs(i[0])>r.eps){s=!0;break}return s},updateParametricCurveNaive:function(t,i,r,s){var o,n,a=!1,h=(r-i)/s;for(o=0;o<s;o++)n=i+o*h,t.points[o].setCoordinates(e.COORDS_BY_USER,[t.X(n,a),t.Y(n,a)],!1),t.points[o]._t=n,a=!0;return t},isSegmentOutside:function(t,e,i,r,s){return e<0&&r<0||e>s.canvasHeight&&r>s.canvasHeight||t<0&&i<0||t>s.canvasWidth&&i>s.canvasWidth},isDistOK:function(t,e,i,r){return Math.abs(t)<i&&Math.abs(e)<r&&!isNaN(t+e)},isSegmentDefined:function(t,e,i,r){return!(isNaN(t+e)&&isNaN(i+r))},updateParametricCurveOld:function(s,o,n){var a,h,l,c,d,u,p,f,m,g,b,v=!1,y=new i(e.COORDS_BY_USER,[0,0],s.board,!1),C=[],_=[],P=[],E=[],S=!1,x=0,O=function(t,e,i){var s,o,n=i[1]-t[1],a=i[2]-t[2],h=e[0]-t[1],l=e[1]-t[2],c=h*h+l*l;return c>=r.eps&&(s=(n*h+a*l)/c)>0&&(s<=1?(n-=s*h,a-=s*l):(n-=h,a-=l)),o=n*n+a*a,Math.sqrt(o)};for(t.deprecated("Curve.updateParametricCurveOld()"),s.board.updateQuality===s.board.BOARD_QUALITY_LOW?(m=15,g=10,b=10):(m=21,g=.7,b=.7),E[0]=n-o,a=1;a<m;a++)E[a]=.5*E[a-1];a=1,C[0]=1,_[0]=0,h=o,y.setCoordinates(e.COORDS_BY_USER,[s.X(h,v),s.Y(h,v)],!1),v=!0,d=y.scrCoords[1],u=y.scrCoords[2],h=n,y.setCoordinates(e.COORDS_BY_USER,[s.X(h,v),s.Y(h,v)],!1),l=y.scrCoords[1],c=y.scrCoords[2],P[0]=[l,c],p=1,f=0,s.points=[],s.points[x++]=new i(e.COORDS_BY_SCREEN,[d,u],s.board,!1);do{for(S=this.isDistOK(l-d,c-u,g,b)||this.isSegmentOutside(d,u,l,c,s.board);f<m&&(!S||f<6)&&(f<=7||this.isSegmentDefined(d,u,l,c));)C[p]=a,_[p]=f,P[p]=[l,c],p+=1,h=o+(a=2*a-1)*E[++f],y.setCoordinates(e.COORDS_BY_USER,[s.X(h,v),s.Y(h,v)],!1,!0),l=y.scrCoords[1],c=y.scrCoords[2],S=this.isDistOK(l-d,c-u,g,b)||this.isSegmentOutside(d,u,l,c,s.board);x>1&&O(s.points[x-2].scrCoords,[l,c],s.points[x-1].scrCoords)<.015&&(x-=1),s.points[x]=new i(e.COORDS_BY_SCREEN,[l,c],s.board,!1),s.points[x]._t=h,x+=1,d=l,u=c,h,l=P[p-=1][0],c=P[p][1],f=_[p]+1,a=2*C[p]}while(p>0&&x<5e5);return s.numberPoints=s.points.length,s},_insertPoint_v2:function(t,e,i){var r=!isNaN(this._lastCrds[1]+this._lastCrds[2]),s=!isNaN(e.scrCoords[1]+e.scrCoords[2]),o=t.board.canvasWidth,n=t.board.canvasHeight,a=500;(!(s=s&&e.scrCoords[1]>-500&&e.scrCoords[2]>-500&&e.scrCoords[1]<o+a&&e.scrCoords[2]<n+a)&&r||s&&(!r||Math.abs(e.scrCoords[1]-this._lastCrds[1])>.7||Math.abs(e.scrCoords[2]-this._lastCrds[2])>.7))&&(e._t=i,t.points.push(e),this._lastCrds=e.copy("scrCoords"))},neighborhood_isNaN_v2:function(t,s){var o,n,a=new i(e.COORDS_BY_USER,[0,0],t.board,!1);return o=s+r.eps,a.setCoordinates(e.COORDS_BY_USER,[t.X(o,!0),t.Y(o,!0)],!1),n=a.usrCoords,!!(isNaN(n[1]+n[2])||(o=s-r.eps,a.setCoordinates(e.COORDS_BY_USER,[t.X(o,!0),t.Y(o,!0)],!1),n=a.usrCoords,isNaN(n[1]+n[2])))},_borderCase:function(t,r,s,o,n,a,h,l){var c,d,u,p,f,m,g,b=null,v=!1;if(l<=1){if(d=new i(e.COORDS_BY_USER,[0,0],t.board,!1),isNaN(r[1]+r[2])&&!isNaN(o[1]+o[2])&&!this.neighborhood_isNaN_v2(t,n))return!1;if(isNaN(s[1]+s[2])&&!isNaN(o[1]+o[2])&&!this.neighborhood_isNaN_v2(t,a))return!1;if(isNaN(o[1]+o[2])&&(!isNaN(r[1]+r[2])||!isNaN(s[1]+s[2]))&&!this.neighborhood_isNaN_v2(t,h))return!1;p=0;do{if(isNaN(r[1]+r[2])&&!isNaN(o[1]+o[2]))f=n,m=h,g=a;else if(isNaN(s[1]+s[2])&&!isNaN(o[1]+o[2]))f=a,m=h,g=n;else if(isNaN(o[1]+o[2])&&!isNaN(s[1]+s[2]))f=h,m=a,g=a+(a-h);else{if(!isNaN(o[1]+o[2])||isNaN(r[1]+r[2]))return!1;f=h,m=n,g=n-(h-n)}c=.5*(f+m),d.setCoordinates(e.COORDS_BY_USER,[t.X(c,!0),t.Y(c,!0)],!1),u=d.usrCoords,(v=isNaN(u[1]+u[2]))?f=c:(g=m,m=c),++p}while(v&&p<30);if(p<30&&(b=u.slice(),o=u.slice(),m=c),(t.X(m,!0)-t.X(g,!0))/(m-g),(t.Y(m,!0)-t.Y(g,!0))/(m-g),null!==b)return this._insertPoint_v2(t,new i(e.COORDS_BY_USER,b,t.board,!1)),!0}return!1},_plotRecursive_v2:function(t,r,s,o,n,a,h){var l,c,d,u,p,f=0,m=new i(e.COORDS_BY_USER,[0,0],t.board,!1);if(!(t.numberPoints>65536))return a<this.nanLevel&&this._isUndefined(t,r,s,o,n)||a<this.nanLevel&&this._isOutside(r,s,o,n,t.board)?this:(l=.5*(s+n),m.setCoordinates(e.COORDS_BY_USER,[t.X(l,!0),t.Y(l,!0)],!1),c=m.scrCoords,this._borderCase(t,r,o,c,s,n,l,a)||(d=this._triangleDists(r,o,c),u=a<this.smoothLevel&&d[3]<h,p=a<this.jumpLevel&&(d[2]>.99*d[0]||d[1]>.99*d[0]||d[0]===1/0||d[1]===1/0||d[2]===1/0),a<this.smoothLevel+2&&d[0]<.5*(d[1]+d[2])&&(f=0,u=!1),--a,p?this._insertPoint_v2(t,new i(e.COORDS_BY_SCREEN,[NaN,NaN],t.board,!1),l):a<=f||u?this._insertPoint_v2(t,m,l):(this._plotRecursive_v2(t,r,s,c,l,a,h),isNaN(m.scrCoords[1]+m.scrCoords[2])||this._insertPoint_v2(t,m,l),this._plotRecursive_v2(t,c,l,o,n,a,h))),this)},updateParametricCurve_v2:function(t,r,s){var o,n,a,h,c,d,u,p,f,m=!1,g=new i(e.COORDS_BY_USER,[0,0],t.board,!1),b=new i(e.COORDS_BY_USER,[0,0],t.board,!1);return t.board.updateQuality===t.board.BOARD_QUALITY_LOW?(c=l.evaluate(t.visProp.recursiondepthlow)||13,d=2,this.smoothLevel=c-6,this.jumpLevel=3):(c=l.evaluate(t.visProp.recursiondepthhigh)||17,d=2,this.smoothLevel=c-9,this.jumpLevel=2),this.nanLevel=c-4,t.points=[],"x"===this.xterm?(u=.3*((p=t.board.getBoundingBox())[2]-p[0]),.3*(p[1]-p[3]),o=Math.max(r,p[0]-u),n=Math.min(s,p[2]+u)):(o=r,n=s),g.setCoordinates(e.COORDS_BY_USER,[t.X(o,m),t.Y(o,m)],!1),m=!0,b.setCoordinates(e.COORDS_BY_USER,[t.X(n,m),t.Y(n,m)],!1),f=this._findStartPoint(t,g.scrCoords,o,b.scrCoords,n),g.setCoordinates(e.COORDS_BY_SCREEN,f[0],!1),o=f[1],f=this._findStartPoint(t,b.scrCoords,n,g.scrCoords,o),b.setCoordinates(e.COORDS_BY_SCREEN,f[0],!1),n=f[1],this._visibleArea=[o,n],a=g.copy("scrCoords"),h=b.copy("scrCoords"),g._t=o,t.points.push(g),this._lastCrds=g.copy("scrCoords"),this._plotRecursive_v2(t,a,o,h,n,c,d),b._t=n,t.points.push(b),t.numberPoints=t.points.length,t},_insertLimesPoint:function(t,s,o,n,a){var h,l,c;Math.abs(this._lastUsrCrds[1])===1/0&&Math.abs(a.left_x)===1/0||Math.abs(this._lastUsrCrds[2])===1/0&&Math.abs(a.left_y)===1/0||((h=new i(e.COORDS_BY_USER,[a.left_x,a.left_y],t.board))._t=o,t.points.push(h),isNaN(a.left_x)||isNaN(a.left_y)||isNaN(a.right_x)||isNaN(a.right_y)||!(Math.abs(a.left_x-a.right_x)>r.eps||Math.abs(a.left_y-a.right_y)>r.eps)||((l=new i(e.COORDS_BY_SCREEN,s,t.board))._t=o,t.points.push(l)),(c=new i(e.COORDS_BY_USER,[a.right_x,a.right_y],t.board))._t=o,t.points.push(c),this._lastScrCrds=c.copy("scrCoords"),this._lastUsrCrds=c.copy("usrCoords"))},_insertPoint:function(t,r,s,o,n){var a,h=!isNaN(this._lastScrCrds[1]+this._lastScrCrds[2]),c=!isNaN(r[1]+r[2]),d=t.board.canvasWidth,u=t.board.canvasHeight,p=500;l.exists(n)?this._insertLimesPoint(t,r,s,o,n):(c=c&&r[1]>-500&&r[2]>-500&&r[1]<d+p&&r[2]<u+p,(h||c)&&(c&&h&&Math.abs(r[1]-this._lastScrCrds[1])<.8&&Math.abs(r[2]-this._lastScrCrds[2])<.8||Math.abs(r[1])===1/0&&Math.abs(this._lastUsrCrds[1])===1/0||Math.abs(r[2])===1/0&&Math.abs(this._lastUsrCrds[2])===1/0||((a=new i(e.COORDS_BY_SCREEN,r,t.board))._t=s,t.points.push(a),this._lastScrCrds=a.copy("scrCoords"),this._lastUsrCrds=a.copy("usrCoords"))))},_triangleDists:function(t,e,i){var r;return r=[t[0]*e[0],.5*(t[1]+e[1]),.5*(t[2]+e[2])],[a.distance(t,e,3),a.distance(t,i,3),a.distance(i,e,3),a.distance(i,r,3)]},_isUndefined:function(t,r,s,o,n){var a,h,l;if(!isNaN(r[1]+r[2])||!isNaN(o[1]+o[2]))return!1;for(l=new i(e.COORDS_BY_USER,[0,0],t.board,!1),h=0;h<20;++h)if(a=s+Math.random()*(n-s),l.setCoordinates(e.COORDS_BY_USER,[t.X(a,!0),t.Y(a,!0)],!1),!isNaN(l.scrCoords[0]+l.scrCoords[1]+l.scrCoords[2]))return!1;return!0},_isOutside:function(t,e,i,r,s){var o=500,n=s.canvasWidth,a=s.canvasHeight;return!!(t[1]<-500&&i[1]<-500||t[2]<-500&&i[2]<-500||t[1]>n+o&&i[1]>n+o||t[2]>a+o&&i[2]>a+o)},_isOutsidePoint:function(t,e){var i=500,r=e.canvasWidth,s=e.canvasHeight;return!!(t[1]<-500||t[2]<-500||t[1]>r+i||t[2]>s+i)},_findStartPoint:function(t,r,s,o,n){new i(e.COORDS_BY_USER,[0,0],t.board,!1),t.board.getBoundingBox();return[r,s]},_getBorderPos:function(t,s,o,n,a,h,l){var c,d,u,p,f,m;if(d=new i(e.COORDS_BY_USER,[0,0],t.board,!1),p=0,isNaN(o[1]+o[2])&&!isNaN(a[1]+a[2]))m=s,f=n,h;else if(isNaN(l[1]+l[2])&&!isNaN(a[1]+a[2]))m=h,f=n,s;else if(isNaN(a[1]+a[2])&&!isNaN(l[1]+l[2]))m=n,f=h,h+(h-n);else{if(!isNaN(a[1]+a[2])||isNaN(o[1]+o[2]))return!1;m=n,f=s,s-(n-s)}do{c=.5*(f+m),d.setCoordinates(e.COORDS_BY_USER,[t.X(c,!0),t.Y(c,!0)],!1),u=d.usrCoords,isNaN(u[1]+u[2])?m=c:(f,f=c),++p}while(p<30&&Math.abs(f-m)>r.eps);return c},_getCuspPos:function(t,e,i){var r=[t.X(e,!0),t.Y(e,!0)],s=[t.X(i,!0),t.Y(i,!0)];return o.fminbr((function(e){var i=[t.X(e,!0),t.Y(e,!0)];return-(Math.sqrt((r[0]-i[0])*(r[0]-i[0])+(r[1]-i[1])*(r[1]-i[1]))+Math.sqrt((s[0]-i[0])*(s[0]-i[0])+(s[1]-i[1])*(s[1]-i[1])))}),[e,i],t)},_getJumpPos:function(t,e,i){return o.fminbr((function(e){var i=r.eps*r.eps,s=[t.X(e,!0),t.Y(e,!0)],o=[t.X(e+i,!0),t.Y(e+i,!0)];return-Math.abs((o[1]-s[1])/(o[0]-s[0]))}),[e,i],t)},_getLimits:function(t,e){var i,r,o,n,a,h=2/(t.maxX()-t.minX());return r=(i=s.limit(e,-h,t.X))[0],"infinite"===i[1]&&(r=Math.sign(r)*(1/0)),n=(i=s.limit(e,-h,t.Y))[0],"infinite"===i[1]&&(n=Math.sign(n)*(1/0)),o=(i=s.limit(e,h,t.X))[0],"infinite"===i[1]&&(o=Math.sign(o)*(1/0)),a=(i=s.limit(e,h,t.Y))[0],"infinite"===i[1]&&(a=Math.sign(a)*(1/0)),{left_x:r,left_y:n,right_x:o,right_y:a,t:e}},_getLimes:function(t,e,i,r,s,o,n,a,h){var l;return"border"===a?l=this._getBorderPos(t,e,i,r,s,o,n):"cusp"===a?l=this._getCuspPos(t,e,o):"jump"===a&&(l=this._getJumpPos(t,e,o)),this._getLimits(t,l)},_plotNonRecursive:function(t,e,i,r,s,o){var n,a,h,l,c,d,u,p,f,m,g,b=null,v=!1,y="",C=[],_=0;for(p=t.board.origin.scrCoords,C[_++]=[e,i,r,s,o,1/0];_>0;){if(e=(g=C[--_])[0],i=g[1],r=g[2],s=g[3],f=g[4],m=g[5],v=!1,y="",b=null,t.points.length>65536)return;if(f<this.nanLevel){if(this._isUndefined(t,e,i,r,s))continue;if(this._isOutside(e,i,r,s,t.board))continue}n=.5*(i+s),d=t.X(n,!0),u=t.Y(n,!0),a=[1,p[1]+d*t.board.unitX,p[2]-u*t.board.unitY],h=this._triangleDists(e,r,a),l=isNaN(e[1]+e[2]),c=isNaN(r[1]+r[2]),l&&!c||!l&&c?y="border":h[0]>.66*m||h[0]<this.cusp_threshold*(h[1]+h[2])||h[1]>5*h[2]||h[2]>5*h[1]?y="cusp":(h[2]>this.jump_threshold*h[0]||h[1]>this.jump_threshold*h[0]||h[0]===1/0||h[1]===1/0||h[2]===1/0)&&(y="jump"),v=""===y&&f<this.smoothLevel&&h[3]<this.smooth_threshold,f<this.testLevel&&!v&&(""===y?v=!0:b=this._getLimes(t,i,e,n,a,s,r,y,f)),null!==b?(a=[1,NaN,NaN],this._insertPoint(t,a,n,f,b)):f<=0||v?this._insertPoint(t,a,n,f,null):(C[_++]=[a,n,r,s,f-1,h[0]],C[_++]=[e,i,a,n,f-1,h[0]])}return this},updateParametricCurve_v3:function(t,r,s){var o,n,a,h,c,d,u,p,f=!1,m=new i(e.COORDS_BY_USER,[0,0],t.board,!1),g=new i(e.COORDS_BY_USER,[0,0],t.board,!1);return c=t.board.updateQuality===t.board.BOARD_QUALITY_LOW?l.evaluate(t.visProp.recursiondepthlow)||14:l.evaluate(t.visProp.recursiondepthhigh)||17,this.smoothLevel=7,this.nanLevel=c-4,this.testLevel=4,this.cusp_threshold=.5,this.jump_threshold=.99,this.smooth_threshold=2,t.points=[],"x"===t.xterm?(d=.3*((u=t.board.getBoundingBox())[2]-u[0]),o=Math.max(r,u[0]-d),n=Math.min(s,u[2]+d)):(o=r,n=s),m.setCoordinates(e.COORDS_BY_USER,[t.X(o,f),t.Y(o,f)],!1),f=!0,g.setCoordinates(e.COORDS_BY_USER,[t.X(n,f),t.Y(n,f)],!1),p=this._findStartPoint(t,m.scrCoords,o,g.scrCoords,n),m.setCoordinates(e.COORDS_BY_SCREEN,p[0],!1),o=p[1],p=this._findStartPoint(t,g.scrCoords,n,m.scrCoords,o),g.setCoordinates(e.COORDS_BY_SCREEN,p[0],!1),n=p[1],this._visibleArea=[o,n],a=m.copy("scrCoords"),h=g.copy("scrCoords"),m._t=o,t.points.push(m),this._lastScrCrds=m.copy("scrCoords"),this._lastUsrCrds=m.copy("usrCoords"),this._plotNonRecursive(t,a,o,h,n,c),g._t=n,t.points.push(g),t.numberPoints=t.points.length,t},_criticalInterval:function(t,e,i){var r,s,o,a,h,l,c,d=!1,u=-1/0,p=!1,f=!1,m=0,g=[],b=[],v=[];for(c=n.abs(t),(a=n.median(c))<1e-7?(a=1e-7,p=!0):a*=this.criticalThreshold,r=0;r<e;r++)c[r]>a?(v.push({i:r,v:t[r],group:m}),u=r,d||(d=!0)):d&&r>u+4&&(v.length>0&&g.push(v.slice(0)),v=[],d=!1,m++);for(d&&v.length>1&&g.push(v.slice(0)),p&&0===g.length&&(f=!0),s=0;s<g.length;s++)if(b[s]="point",!((o=g[s].length)<64)){for(l=0,h=Math.sign(g[s][0].v),r=1;r<o;r++)Math.sign(g[s][r].v)!==h&&(l++,h=Math.sign(g[s][r].v));6*l>o&&(b[s]="interval")}return{smooth:f,groups:g,types:b}},Component:function(){this.left_isNaN=!1,this.right_isNaN=!1,this.left_t=null,this.right_t=null,this.t_values=[],this.x_values=[],this.y_values=[],this.len=0},findComponents:function(t,e,i,r){var s,o,n,a,h,l,c=[],d=0,u=0,p=0,f=!1,m=!1;for(n=(i-e)/r,c[d]=new this.Component,l=c[d],s=0,o=e;s<=r;s++,o+=n)a=t.X(o,m),h=t.Y(o,m),isNaN(a)||isNaN(h)?++p>1&&f&&(l.right_isNaN=!0,l.right_t=o-n,l.len=u,f=!1,c[++d]=new this.Component,l=c[d],p=0):(f||(f=!0,u=0,p>0&&(l.left_t=o-n,l.left_isNaN=!0)),p=0,l.t_values[u]=o,l.x_values[u]=a,l.y_values[u]=h,u++),0===s&&(m=!0);return f?l.len=u:c.pop(),c},getPointType:function(t,e,i,r,s,o,n){var a=s[0],h=o[0],l=r.length,c={idx:e,t:i,x:a[e],y:h[e],type:"other"};return e<5?(c.type="borderleft",c.idx=0,c.t=r[0],c.x=a[0],c.y=h[0],c):e>n-6?(c.type="borderright",c.idx=l-1,c.t=r[l-1],c.x=a[l-1],c.y=h[l-1],c):c},newtonApprox:function(t,e,i,r,s){var o,n=0;for(o=r;o>0;o--)n=(n+s[o][t])*(e-(o-1)*i)/o;return n+s[0][t]},thiele:function(t,e,i,r,s){var o,n=0;for(o=s;o>1;o--)n=(t-i[r+o])/(e[o][r+1]-e[o-2][r+1]+n);return e[0][r+1]+(t-i[r+1])/(e[1][r+1]+n)},differenceMethodExperiments:function(t,e){var i,r,s,o,n,a,h,l,c,d,u,p=t.t_values,f=t.x_values,m=t.y_values,g=[],b=[],v=[],y=[],C=[],_=[],P=[],E=[],S=0,x=[];for(n=p[1]-p[0],C.push([]),_.push([]),P.push([]),E.push([]),s=m.length,i=0;i<s;i++)C[0][i]=f[i],_[0][i]=m[i],P[0][i]=f[i],E[0][i]=m[i];for(C.push([]),_.push([]),P.push([]),E.push([]),a=n,s=m.length-1,i=0;i<s;i++)g[i]=f[i+1]-f[i],b[i]=m[i+1]-m[i],v[i]=g[i],y[i]=b[i],C[1][i]=g[i],_[1][i]=b[i],P[1][i]=a/g[i],E[1][i]=a/b[i];for(s--,o=Math.min(8,m.length-1),r=1;r<o;r++){for(C.push([]),_.push([]),P.push([]),E.push([]),a*=n,i=0;i<s;i++)g[i]=g[i+1]-g[i],b[i]=b[i+1]-b[i],C[r+1][i]=g[i],_[r+1][i]=b[i],P[r+1][i]=a/(P[r][i+1]-P[r][i])+P[r-1][i+1],E[r+1][i]=a/(E[r][i+1]-E[r][i])+E[r-1][i+1];if(!1===(u=this._criticalPoints(b,s,r))){console.log("Polynomial of degree",r),u=[];break}if(u.length>0&&++S>1&&r%2==0)break;s--}for(i=0;i<u.length;i++){for(l=-1/0,c=0;c<u[i].length;c++)(d=Math.abs(u[i][c].v))>l&&(l=d,h=c);h=Math.floor(u[i][h].i+r/2),x.push(this.getPointType(e,h,p,f,m,v,y,s+1))}return[x,C,_,P,E]},getCenterOfCriticalInterval:function(t,e,i){var r,s,o,n,a,h=0,l=0,c=i[1]-i[0],d=[];for(r=-1/0,d=[],s=0;s<t.length;s++)(n=Math.abs(t[s].v))>r?(d=[s],r=n,o=s):r===n&&d.push(s);if(d.length>0&&(a=d.reduce((function(t,e){return t+e}),0)/d.length,o=Math.floor(a),a+=t[0].i),r<1/0){for(s=0;s<t.length;s++)h+=Math.abs(t[s].v)*t[s].i,l+=Math.abs(t[s].v);a=h/l}return a+=e/2,[t[o].i+e/2,a,i[Math.floor(a)]+c*(a-Math.floor(a))]},differenceMethod:function(t,e){var i,r,s,o,n,a,h,l,c,d,u=t.t_values,p=t.x_values,f=t.y_values,m=[],g=[],b=0,v=-1,y=-1,C=[],_=[];for(s=f.length,m.push(new Float64Array(p)),g.push(new Float64Array(f)),s--,o=Math.min(12,s),r=0;r<o&&(m.push(new Float64Array(s)),g.push(new Float64Array(s)),m[r+1]=m[r].map((function(t,e,i){return i[e+1]-t})),g[r+1]=g[r].map((function(t,e,i){return i[e+1]-t})),!0===(l=this._criticalInterval(g[r+1],s,r)).smooth&&(y=r,C=[]),h=this._criticalInterval(m[r+1],s,r),-1===v&&!0===h.smooth&&(v=r),!(y>=0));r++){if(l.groups.length>0&&++b>2&&(r+1)%2==0){C=l.groups,d=l.types;break}s--}for(i=0;i<C.length;i++)"interval"!==d[i]&&(a=this.getCenterOfCriticalInterval(C[i],r+1,u),l[0],n=Math.floor(a[1]),c=a[2],_.push(this.getPointType(e,n,c,u,m,g,s+1)));return[_,m,g,v,y]},_insertPoint_v4:function(t,r,s,o){var n,a,h,l=null;t.points.length>0&&(l=t.points[t.points.length-1].scrCoords),n=new i(e.COORDS_BY_USER,r,t.board),null!==l&&(a=n.scrCoords[1]-l[1])*a+(h=n.scrCoords[2]-l[2])*h<.8*.8||(n._t=s,t.points.push(n))},getInterval:function(e,i,r){var s,o;return h.disable(),s=h.Interval(i,r),e.board.mathLib=h,e.board.mathLibJXG=h,e.X(s,!0),o=e.Y(s,!0),e.board.mathLib=Math,e.board.mathLibJXG=t.Math,o},sign:function(t){return t<0?-1:t>0?1:0},handleBorder:function(t,e,i,r,s){var o,n,a,h,c,d,u,p,f,m,g,b,v=i.idx;if(b=e.t_values[1]-e.t_values[0],"borderleft"===i.type?a=(n=o=e.left_isNaN?e.left_t:i.t-b)+b:"borderright"===i.type?n=(a=o=e.right_isNaN?e.right_t:i.t+b)-b:console.log("No bordercase!!!"),0!==(m=this.findComponents(t,n,a,32)).length){for("borderleft"===i.type&&(n=m[0].left_t,a=m[0].t_values[0],b=m[0].t_values[1]-m[0].t_values[0],o=n=null===n?a-b:n,h=this.getInterval(t,n,a),l.isObject(h)&&(u=h.lo,p=h.hi,c=t.X(o,!0),d=s[1][v]<0?p:u,this._insertPoint_v4(t,[1,c,d],o))),g=m[0].t_values.length,f=0;f<g;f++)o=m[0].t_values[f],c=m[0].x_values[f],d=m[0].y_values[f],this._insertPoint_v4(t,[1,c,d],o);"borderright"===i.type&&(n=m[0].t_values[g-1],a=m[0].right_t,b=m[0].t_values[1]-m[0].t_values[0],o=a=null===a?n+b:a,h=this.getInterval(t,n,a),l.isObject(h)&&(u=h.lo,p=h.hi,c=t.X(o,!0),d=s[1][v]>0?p:u,this._insertPoint_v4(t,[1,c,d],o)))}},_seconditeration_v4:function(t,e,i,r,s){var o,n,a,h,l,c,d,u,p,f,m,g,b;for(n=e.t_values[i.idx-2],a=e.t_values[i.idx+2],l=this.findComponents(t,n,a,64),d=0;d<l.length;d++){for(c=l[d],u=(h=this.differenceMethod(c,t))[0],f=h[1],m=h[2],g=0,p=0;p<=u.length;p++){for(b=p===u.length?c.len:u[p].idx,o=g;o<b;o++)isNaN(c.x_values[o])||isNaN(c.y_values[o])||this._insertPoint_v4(t,[1,c.x_values[o],c.y_values[o]],c.t_values[o]);p<u.length&&(this.handleSingularity(t,c,u[p],f,m),g=u[p].idx+1)}b=c.len,d<l.length-1&&this._insertPoint_v4(t,[1,NaN,NaN],c.right_t)}return this},_recurse_v4:function(t,e,i,r,s,o,n,a){var h,l,c=.5*(e+i),d=t.X(c,!0),u=t.Y(c,!0);0!==a?(h=(d-r)*t.board.unitX,l=(u-s)*t.board.unitY,Math.sqrt(h*h+l*l)>2?this._recurse_v4(t,e,c,r,s,d,u,a-1):this._insertPoint_v4(t,[1,d,u],c),h=(d-o)*t.board.unitX,l=(u-n)*t.board.unitY,Math.sqrt(h*h+l*l)>2?this._recurse_v4(t,c,i,d,u,o,n,a-1):this._insertPoint_v4(t,[1,d,u],c)):this._insertPoint_v4(t,[1,NaN,NaN],c)},handleSingularity:function(t,e,i,r,s){var o,n,a,h,c,d,u,p,f,m,g,b=i.idx,v=100;o=i.t,console.log("HandleSingularity at t =",o),n=e.t_values[b-5],a=e.t_values[b+5],h=this.getInterval(t,n,a),l.isObject(h)?(p=h.lo,f=h.hi):s[0][b-1]<s[0][b+1]?(p=s[0][b-1],f=s[0][b+1]):(p=s[0][b+1],f=s[0][b-1]),u=t.X(o,!0),m=(s[0][b-3]-s[0][b-5])/(e.t_values[b-3]-e.t_values[b-5]),g=(s[0][b+3]-s[0][b+5])/(e.t_values[b+3]-e.t_values[b+5]),console.log(":::",m,g),m<-100?(this._insertPoint_v4(t,[1,u,p],o,!0),g<=v&&this._insertPoint_v4(t,[1,NaN,NaN],o)):m>v?(this._insertPoint_v4(t,[1,u,f],o),g>=-100&&this._insertPoint_v4(t,[1,NaN,NaN],o)):(p===-1/0&&(this._insertPoint_v4(t,[1,u,p],o,!0),this._insertPoint_v4(t,[1,NaN,NaN],o)),f===1/0&&(this._insertPoint_v4(t,[1,NaN,NaN],o),this._insertPoint_v4(t,[1,u,f],o,!0)),i.t<e.t_values[b]?(c=b-1,d=b):(c=b,d=b+1),n=e.t_values[c],a=e.t_values[d],this._recurse_v4(t,n,a,r[0][c],s[0][c],r[0][d],s[0][d],10)),g<-100?this._insertPoint_v4(t,[1,u,f],o):g>v&&this._insertPoint_v4(t,[1,u,p],o)},steps:1021,criticalThreshold:1e3,plot_v4:function(t,e,i,r){var s,n,a,h,c,d,u,p,f,m,g,b,v,y,C,_=(i-e)/r,P=function(e){return t.Y(e,!0)},E=function(e){return-t.Y(e,!0)},S=.5*_;for(a=this.findComponents(t,e,i,r),h=0;h<a.length;h++){for(c=a[h],d=(f=this.differenceMethod(c,t))[0],m=f[1],g=f[2],f[3],f[4],0!==d.length&&"borderleft"===d[0].type||d.unshift({idx:0,t:c.t_values[0],x:c.x_values[0],y:c.y_values[0],type:"borderleft"}),"borderright"!==d[d.length-1].type&&(n=c.t_values.length,d.push({idx:n-1,t:c.t_values[n-1],x:c.x_values[n-1],y:c.y_values[n-1],type:"borderright"})),p=0,u=0;u<=d.length;u++){for(n=u===d.length?c.len:d[u].idx-1,0,0,s=p;s<n-2;s++)this._insertPoint_v4(t,[1,c.x_values[s],c.y_values[s]],c.t_values[s]),Math.max(0,s-2),s>=p+3&&s<n-3&&g.length>3&&Math.abs(g[2][s])>.2*Math.abs(g[0][s])?(b=c.t_values[s],S=.25*_,C=this.getInterval(t,b,b+_),l.isObject(C)?g[2][s]>0?this._insertPoint_v4(t,[1,b+S,C.lo],b+S):this._insertPoint_v4(t,[1,b+_-S,C.hi],b+_-S):(v=o.fminbr(P,[b,b+_]))<(y=o.fminbr(E,[b,b+_]))?(this._insertPoint_v4(t,[1,t.X(v,!0),t.Y(v,!0)],v),this._insertPoint_v4(t,[1,t.X(y,!0),t.Y(y,!0)],y)):(this._insertPoint_v4(t,[1,t.X(y,!0),t.Y(y,!0)],y),this._insertPoint_v4(t,[1,t.X(v,!0),t.Y(v,!0)],v))):0;u<d.length&&(s=d[u].idx,"borderleft"===d[u].type||"borderright"===d[u].type?this.handleBorder(t,c,d[u],m,g):this._seconditeration_v4(t,c,d[u],m,g),p=d[u].idx+1+1)}n=c.len,h<a.length-1&&this._insertPoint_v4(t,[1,NaN,NaN],c.right_t)}},updateParametricCurve_v4:function(t,e,i){var r,s,o,n;"x"===t.xterm?(o=.3*((n=t.board.getBoundingBox())[2]-n[0]),r=Math.max(e,n[0]-o),s=Math.min(i,n[2]+o)):(r=e,s=i),t.points=[],this.plot_v4(t,r,s,this.steps),t.numberPoints=t.points.length},updateParametricCurve:function(t,e,i){return this.updateParametricCurve_v2(t,e,i)}},r.Plot})),define("math/metapost",["utils/type","math/math"],(function(t,e){"use strict";return e.Metapost={MP_ENDPOINT:0,MP_EXPLICIT:1,MP_GIVEN:2,MP_CURL:3,MP_OPEN:4,MP_END_CYCLE:5,UNITY:1,FRACTION_ONE:1,FRACTION_THREE:3,ONE_EIGHTY_DEG:Math.PI,THREE_SIXTY_DEG:2*Math.PI,EPS_SQ:1e-5*1e-5,make_choices:function(t){var e,i,r,s,o,n,a,h,l,c,d,u,p,f,m;a=t[0];do{if(!a)break;n=a.next,a.rtype>this.MP_EXPLICIT&&(a.x-n.x)*(a.x-n.x)+(a.y-n.y)*(a.y-n.y)<this.EPS_SQ&&(a.rtype=this.MP_EXPLICIT,a.ltype===this.MP_OPEN&&(a.ltype=this.MP_CURL,a.set_left_curl(this.UNITY)),n.ltype=this.MP_EXPLICIT,n.rtype===this.MP_OPEN&&(n.rtype=this.MP_CURL,n.set_right_curl(this.UNITY)),a.rx=a.x,n.lx=a.x,a.ry=a.y,n.ly=a.y),a=n}while(a!==t[0]);for(i=t[0];i.ltype===this.MP_OPEN&&i.rtype===this.MP_OPEN;)if((i=i.next)===t[0]){i.ltype=this.MP_END_CYCLE;break}for(a=i;a;){if(n=a.next,a.rtype>=this.MP_GIVEN){for(;n.ltype===this.MP_OPEN&&n.rtype===this.MP_OPEN;)n=n.next;for(r=0,h=a,o=t.length,u=[],p=[],f=[],m=[null];c=h.next,u.push(c.x-h.x),p.push(c.y-h.y),f.push(this.mp_pyth_add(u[r],p[r])),r>0&&(d=p[r-1]/f[r-1],l=u[r-1]/f[r-1],m.push(Math.atan2(p[r]*l-u[r]*d,u[r]*l+p[r]*d))),r++,(h=c)===n&&(o=r),!(r>=o&&h.ltype!==this.MP_END_CYCLE););r===o?m.push(0):m.push(m[1]),n.ltype===this.MP_OPEN&&((s=n.rx-n.x)*s+(e=n.ry-n.y)*e<this.EPS_SQ?(n.ltype=this.MP_CURL,n.set_left_curl(this.UNITY)):(n.ltype=this.MP_GIVEN,n.set_left_given(Math.atan2(e,s)))),a.rtype===this.MP_OPEN&&a.ltype===this.MP_EXPLICIT&&((s=a.x-a.lx)*s+(e=a.y-a.ly)*e<this.EPS_SQ?(a.rtype=this.MP_CURL,a.set_right_curl(this.UNITY)):(a.rtype=this.MP_GIVEN,a.set_right_given(Math.atan2(e,s)))),this.mp_solve_choices(a,n,o,u,p,f,m)}else a.rtype===this.MP_ENDPOINT&&(a.rx=a.x,a.ry=a.y,n.lx=n.x,n.ly=n.y);if((a=n)===i)break}},mp_solve_choices:function(t,e,i,r,s,o,n){var a,h,l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S,x,O,w,T,N,M,A,R;for(d=o.length+1,g=new Array(d),m=new Array(d),l=new Array(d),_=new Array(d),A=0;A<d;A++)_[A]=l[A]=m[A]=g[A]=0;for(p=0,f=t,v=0;;){if(y=f.next,0===p)if(f.rtype===this.MP_GIVEN){if(y.ltype===this.MP_GIVEN)return a=Math.atan2(s[0],r[0]),O=(x=this.mp_n_sin_cos(t.right_given()-a))[0],w=x[1],N=(T=this.mp_n_sin_cos(e.left_given()-a))[0],M=T[1],void this.mp_set_controls(t,e,r[0],s[0],w,O,-M,N);l[0]=f.right_given()-Math.atan2(s[0],r[0]),l[0]=this.reduce_angle(l[0]),g[0]=0,m[0]=0}else if(f.rtype===this.MP_CURL){if(y.ltype===this.MP_CURL)return t.rtype=this.MP_EXPLICIT,e.ltype=this.MP_EXPLICIT,b=Math.abs(e.left_tension()),P=Math.abs(t.right_tension()),C=this.UNITY/(3*P),t.rx=t.x+r[0]*C,t.ry=t.y+s[0]*C,C=this.UNITY/(3*b),e.lx=e.x-r[0]*C,void(e.ly=e.y-s[0]*C);S=f.right_curl(),b=Math.abs(y.left_tension()),P=Math.abs(f.right_tension()),g[0]=this.mp_curl_ratio(S,P,b),l[0]=-n[1]*g[0],m[0]=0}else f.rtype===this.MP_OPEN&&(g[0]=0,l[0]=0,m[0]=this.FRACTION_ONE);else if(f.ltype===this.MP_END_CYCLE||f.ltype===this.MP_OPEN){if(a=this.UNITY/(3*Math.abs(v.right_tension())-this.UNITY),E=o[p]*(this.FRACTION_THREE-this.UNITY/Math.abs(v.right_tension())),c=this.UNITY/(3*Math.abs(y.left_tension())-this.UNITY),u=o[p-1]*(this.FRACTION_THREE-this.UNITY/Math.abs(y.left_tension())),E*=S=this.FRACTION_ONE-g[p-1]*a,(b=Math.abs(f.left_tension()))<(P=Math.abs(f.right_tension()))?E*=Math.pow(b/P,2):b>P&&(u*=Math.pow(P/b,2)),C=u/(u+E),g[p]=C*c,h=-n[p+1]*g[p],v.rtype===this.MP_CURL?(m[p]=0,l[p]=h-n[1]*(this.FRACTION_ONE-C)):(C=(this.FRACTION_ONE-C)/S,h-=n[p]*C,C*=a,l[p]=h-l[p-1]*C,m[p]=-m[p-1]*C),f.ltype===this.MP_END_CYCLE){for(a=0,c=this.FRACTION_ONE;0===(p-=1)&&(p=i),a=l[p]-a*g[p],c=m[p]-c*g[p],p!==i;);for(a/=this.FRACTION_ONE-c,_[i]=a,l[0]=a,R=1;R<i;R++)l[R]=l[R]+a*m[R];break}}else{if(f.ltype===this.MP_CURL){S=f.left_curl(),b=Math.abs(f.left_tension()),P=Math.abs(v.right_tension()),C=this.mp_curl_ratio(S,b,P),_[i]=-l[i-1]*C/(this.FRACTION_ONE-C*g[i-1]);break}if(f.ltype===this.MP_GIVEN){_[i]=f.left_given()-Math.atan2(s[i-1],r[i-1]),_[i]=this.reduce_angle(_[i]);break}}v=f,f=y,p+=1}for(p=i-1;p>-1;p--)_[p]=l[p]-_[p+1]*g[p];for(f=t,p=0;y=f.next,O=(x=this.mp_n_sin_cos(_[p]))[0],w=x[1],N=(T=this.mp_n_sin_cos(-n[p+1]-_[p+1]))[0],M=T[1],this.mp_set_controls(f,y,r[p],s[p],w,O,M,N),f=y,++p!==i;);},mp_n_sin_cos:function(t){return[Math.cos(t),Math.sin(t)]},mp_set_controls:function(t,e,i,r,s,o,n,a){var h,l,c,d,u;c=Math.abs(e.left_tension()),h=Math.abs(t.right_tension()),u=this.mp_velocity(s,o,n,a,h),l=this.mp_velocity(n,a,s,o,c),(t.right_tension()<0||e.left_tension()<0)&&(s>=0&&n>=0||s<=0&&n<=0)&&(d=Math.abs(s)*a+Math.abs(n)*o)>0&&(d*=1.00024414062,t.right_tension()<0&&this.mp_ab_vs_cd(Math.abs(n),this.FRACTION_ONE,u,d)<0&&(u=Math.abs(n)/d),e.left_tension()<0&&this.mp_ab_vs_cd(Math.abs(s),this.FRACTION_ONE,l,d)<0&&(l=Math.abs(s)/d)),t.rx=t.x+(i*o-r*s)*u,t.ry=t.y+(r*o+i*s)*u,e.lx=e.x-(i*a+r*n)*l,e.ly=e.y-(r*a-i*n)*l,t.rtype=this.MP_EXPLICIT,e.ltype=this.MP_EXPLICIT},mp_pyth_add:function(t,e){return Math.sqrt(t*t+e*e)},mp_curl_ratio:function(t,e,i){var r=1/e,s=1/i;return Math.min(4,((3-r)*r*r*t+s*s*s)/(r*r*r*t+(3-s)*s*s))},mp_ab_vs_cd:function(t,e,i,r){return t*e==i*r?0:t*e>i*r?1:-1},mp_velocity:function(t,e,i,r,s){return Math.min(4,(2+Math.sqrt(2)*(t-i/16)*(i-t/16)*(e-r))/(1.5*s*(2+(Math.sqrt(5)-1)*e+(3-Math.sqrt(5))*r)))},reduce_angle:function(t){return Math.abs(t)>this.ONE_EIGHTY_DEG&&(t>0?t-=this.THREE_SIXTY_DEG:t+=this.THREE_SIXTY_DEG),t},makeknots:function(t,e,i){var r,s,o=[];for(e=e||1,s=t.length,r=0;r<s;r++)o.push({x:t[r][0],y:t[r][1],ltype:this.MP_OPEN,rtype:this.MP_OPEN,ly:e,ry:e,lx:e,rx:e,left_curl:function(){return this.lx||0},right_curl:function(){return this.rx||0},left_tension:function(){return this.ly||(this.ly=1),this.ly},right_tension:function(){return this.ry||(this.ry=1),this.ry},set_right_curl:function(t){this.rx=t||0},set_left_curl:function(t){this.lx=t||0}});for(s=o.length,r=0;r<s;r++)o[r].next=o[r+1]||o[r],o[r].set_right_given=o[r].set_right_curl,o[r].set_left_given=o[r].set_left_curl,o[r].right_given=o[r].right_curl,o[r].left_given=o[r].left_curl;return o[s-1].next=o[0],i||(o[s-1].rtype=this.MP_ENDPOINT,o[s-1].ltype=this.MP_CURL,o[0].rtype=this.MP_CURL),o},curve:function(e,i){var r,s,o,n,a=[],h=[];for(o in i=i||{tension:1,direction:{},curl:{},isClosed:!1},s=(r=this.makeknots(e,t.evaluate(i.tension),i.isClosed)).length,i.direction)i.direction.hasOwnProperty(o)&&(n=t.evaluate(i.direction[o]),t.isArray(n)?(!1!==n[0]&&(r[o].lx=n[0]*Math.PI/180,r[o].ltype=this.MP_GIVEN),!1!==n[1]&&(r[o].rx=n[1]*Math.PI/180,r[o].rtype=this.MP_GIVEN)):(r[o].lx=n*Math.PI/180,r[o].rx=n*Math.PI/180,r[o].ltype=r[o].rtype=this.MP_GIVEN));for(o in i.curl)i.curl.hasOwnProperty(o)&&(n=t.evaluate(i.curl[o]),0===parseInt(o,10)?(r[o].rtype=this.MP_CURL,r[o].set_right_curl(n)):parseInt(o,10)===s-1&&(r[o].ltype=this.MP_CURL,r[o].set_left_curl(n)));for(this.make_choices(r),o=0;o<s-1;o++)a.push(r[o].x),a.push(r[o].rx),a.push(r[o+1].lx),h.push(r[o].y),h.push(r[o].ry),h.push(r[o+1].ly);return a.push(r[s-1].x),h.push(r[s-1].y),i.isClosed&&(a.push(r[s-1].rx),h.push(r[s-1].ry),a.push(r[0].lx),h.push(r[0].ly),a.push(r[0].x),h.push(r[0].y)),[a,h]}},e.Metapost})),define("utils/zip",["jxg"],(function(t){"use strict";var e=[0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255],i=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],r=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,99,99],s=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577],o=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],n=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];return t.Util=t.Util||{},t.Util.Unzip=function(a){var h,l,c,d,u=[],p=0,f=[],m=new Array(32768),g=0,b=!1,v=a.length,y=0,C=1,_=new Array(288),P=new Array(32),E=0,S=null,x=(new Array(64),new Array(64),0),O=new Array(17),w=[];function T(){return 8,y<v?a[y++]:-1}function N(){C=1}function M(){var t;try{return t=1&C,0===(C>>=1)&&(t=1&(C=T()),C=C>>1|128),t}catch(t){throw t}}function A(t){var i=0,r=t;try{for(;r--;)i=i<<1|M();t&&(i=e[i]>>8-t)}catch(t){throw t}return i}function R(){g=0}function L(t){m[g++]=t,u.push(String.fromCharCode(t)),32768===g&&(g=0)}function k(){this.b0=0,this.b1=0,this.jump=null,this.jumppos=-1}function B(){for(;;){if(O[x]>=d)return-1;if(c[O[x]]===x)return O[x]++;O[x]++}}function I(){var t,e=S[E];if(17===x)return-1;if(E++,x++,(t=B())>=0)e.b0=t;else if(e.b0=32768,I())return-1;if((t=B())>=0)e.b1=t,e.jump=null;else if(e.b1=32768,e.jump=S[E],e.jumppos=E,I())return-1;return x--,0}function Y(t,e,i,r){var s;for(S=t,E=0,c=i,d=e,s=0;s<17;s++)O[s]=0;return x=0,I()?-1:0}function D(t){for(var e,i,r=0,s=t[r];;)if(M()){if(!(32768&s.b1))return s.b1;for(s=s.jump,e=t.length,i=0;i<e;i++)if(t[i]===s){r=i;break}}else{if(!(32768&s.b0))return s.b0;s=t[++r]}}function j(){var a,h,l,c,d,u,p,f,b,v,y,C,E,S,x;do{if(a=M(),0===(h=A(2)))for(N(),b=T(),b|=T()<<8,y=T(),65535&(b^~(y|=T()<<8))&&t.debug("BlockLen checksum mismatch\n");b--;)L(T());else if(1===h)for(;;)if((c=e[A(7)]>>1)>23?(c=c<<1|M())>199?c=(c-=128)<<1|M():(c-=48)>143&&(c+=136):c+=256,c<256)L(c);else{if(256===c)break;for(f=A(r[c-=257])+i[c],c=e[A(5)]>>3,o[c]>8?(v=A(8),v|=A(o[c]-8)<<8):v=A(o[c]),v+=s[c],c=0;c<f;c++)L(m[g-v&32767])}else if(2===h){for(u=new Array(320),E=257+A(5),S=1+A(5),x=4+A(4),c=0;c<19;c++)u[c]=0;for(c=0;c<x;c++)u[n[c]]=A(3);for(f=P.length,l=0;l<f;l++)P[l]=new k;if(Y(P,19,u))return R(),1;for(C=E+S,l=0,-1;l<C;)if((c=D(P))<16)u[l++]=c;else if(16===c){if(l+(c=3+A(2))>C)return R(),1;for(d=l?u[l-1]:0;c--;)u[l++]=d}else{if(l+(c=17===c?3+A(3):11+A(7))>C)return R(),1;for(;c--;)u[l++]=0}for(f=_.length,l=0;l<f;l++)_[l]=new k;if(Y(_,E,u))return R(),1;for(f=_.length,l=0;l<f;l++)P[l]=new k;for(p=[],l=E;l<u.length;l++)p[l-E]=u[l];if(Y(P,S,p))return R(),1;for(;;)if((c=D(_))>=256){if(0===(c-=256))break;for(f=A(r[c-=1])+i[c],c=D(P),o[c]>8?(v=A(8),v|=A(o[c]-8)<<8):v=A(o[c]),v+=s[c];f--;)L(m[g-v&32767])}else L(c)}}while(!a);return R(),N(),0}function X(){var t,e,i,r,s,o=[];try{if(u=[],b=!1,o[0]=T(),o[1]=T(),120===o[0]&&218===o[1]&&(j(),f[p]=[u.join(""),"geonext.gxt"],p++),31===o[0]&&139===o[1]&&(U(),f[p]=[u.join(""),"file"],p++),80===o[0]&&75===o[1]){if(b=!0,o[2]=T(),o[3]=T(),3===o[2]&&4===o[3]){for(o[0]=T(),o[1]=T(),h=T(),h|=T()<<8,s=T(),s|=T()<<8,T(),T(),T(),T(),T(),T()<<8,T()<<16,T()<<24,T(),T()<<8,T()<<16,T()<<24,T(),T()<<8,T()<<16,T()<<24,r=T(),r|=T()<<8,i=T(),i|=T()<<8,t=0,w=[];r--;)"/"===(e=T())|":"===e?t=0:t<255&&(w[t++]=String.fromCharCode(e));for(l||(l=w),t=0;t<i;)e=T(),t++;if(0,8===s&&(j(),f[p]=new Array(2),f[p][0]=u.join(""),f[p][1]=w.join(""),p++),U())return!1}return!0}}catch(t){throw t}return!1}function U(){var t,e,i=[];if(8&h&&(i[0]=T(),i[1]=T(),i[2]=T(),i[3]=T(),80===i[0]&&75===i[1]&&7===i[2]&&8===i[3]?(T(),T()<<8,T()<<16,T()<<24):i[0]|i[1]<<8|i[2]<<16|i[3]<<24,T(),T()<<8,T()<<16,T()<<24,T(),T()<<8,T()<<16,T()<<24),b&&X())return!1;if(i[0]=T(),8!==i[0])return!0;if(h=T(),T(),T(),T(),T(),T(),T(),4&h)for(i[0]=T(),i[2]=T(),x=i[0]+256*i[1],t=0;t<x;t++)T();if(8&h)for(t=0,w=[],e=T();e;)"7"!==e&&":"!==e||(t=0),t<255&&(w[t++]=e),e=T();if(16&h)for(e=T();e;)e=T();return 2&h&&(T(),T()),j(),T(),T()<<8,T()<<16,T()<<24,T(),T()<<8,T()<<16,T()<<24,b&&X(),!1}O[0]=0,t.Util.Unzip.prototype.unzipFile=function(t){var e;for(this.unzip(),e=0;e<f.length;e++)if(f[e][1]===t)return f[e][0];return""},t.Util.Unzip.prototype.unzip=function(){return X(),f}},t.Util})),define("utils/encoding",["jxg"],(function(t){"use strict";var e=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,10,3,3,3,3,3,3,3,3,3,3,3,3,4,3,3,11,6,6,6,5,8,8,8,8,8,8,8,8,8,8,8,0,12,24,36,60,96,84,12,12,12,48,72,12,12,12,12,12,12,12,12,12,12,12,12,12,0,12,12,12,12,12,0,12,0,12,12,12,24,12,12,12,12,12,24,12,24,12,12,12,12,12,12,12,12,12,24,12,12,12,12,12,24,12,12,12,12,12,12,12,24,12,12,12,12,12,12,12,12,12,36,12,36,12,12,12,36,12,12,12,12,12,36,12,36,12,12,12,36,12,12,12,12,12,12,12,12,12,12];return t.Util=t.Util||{},t.Util.UTF8={encode:function(t){var e,i,r="",s=t.length;if(t=t.replace(/\r\n/g,"\n"),"function"==typeof unescape&&"function"==typeof encodeURIComponent)return unescape(encodeURIComponent(t));for(e=0;e<s;e++)(i=t.charCodeAt(e))<128?r+=String.fromCharCode(i):i>127&&i<2048?(r+=String.fromCharCode(i>>6|192),r+=String.fromCharCode(63&i|128)):(r+=String.fromCharCode(i>>12|224),r+=String.fromCharCode(i>>6&63|128),r+=String.fromCharCode(63&i|128));return r},decode:function(t){var i,r,s,o=0,n=0,a=0,h=[],l=t.length,c=[];for(i=0;i<l;i++)r=t.charCodeAt(i),s=e[r],n=0!==a?63&r|n<<6:255>>s&r,0===(a=e[256+a+s])&&(n>65535?h.push(55232+(n>>10),56320+(1023&n)):h.push(n),++o%1e4==0&&(c.push(String.fromCharCode.apply(null,h)),h=[]));return c.push(String.fromCharCode.apply(null,h)),c.join("")},asciiCharCodeAt:function(t,e){var i=t.charCodeAt(e);if(i>255)switch(i){case 8364:i=128;break;case 8218:i=130;break;case 402:i=131;break;case 8222:i=132;break;case 8230:i=133;break;case 8224:i=134;break;case 8225:i=135;break;case 710:i=136;break;case 8240:i=137;break;case 352:i=138;break;case 8249:i=139;break;case 338:i=140;break;case 381:i=142;break;case 8216:i=145;break;case 8217:i=146;break;case 8220:i=147;break;case 8221:i=148;break;case 8226:i=149;break;case 8211:i=150;break;case 8212:i=151;break;case 732:i=152;break;case 8482:i=153;break;case 353:i=154;break;case 8250:i=155;break;case 339:i=156;break;case 382:i=158;break;case 376:i=159}return i}},t.Util.UTF8})),define("utils/base64",["jxg","utils/encoding"],(function(t,e){"use strict";var i="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",r="=";function s(t,e){return 255&t.charCodeAt(e)}function o(t,e){return i.indexOf(t.charAt(e))}return t.Util=t.Util||{},t.Util.Base64={encode:function(t){var o,n,a,h,l,c=[];for(h=(a=(l=e.encode(t)).length)%3,o=0;o<a-h;o+=3)n=s(l,o)<<16|s(l,o+1)<<8|s(l,o+2),c.push(i.charAt(n>>18),i.charAt(n>>12&63),i.charAt(n>>6&63),i.charAt(63&n));switch(h){case 1:n=s(l,a-1),c.push(i.charAt(n>>2),i.charAt(n<<4&63),r,r);break;case 2:n=s(l,a-2)<<8|s(l,a-1),c.push(i.charAt(n>>10),i.charAt(n>>4&63),i.charAt(n<<2&63),r)}return c.join("")},decode:function(t,i){var s,n,a,h,l,c,d=[],u=[];if((a=(s=t.replace(/[^A-Za-z0-9+/=]/g,"")).length)%4!=0)throw new Error("JSXGraph/utils/base64: Can't decode string (invalid input length).");for(s.charAt(a-1)===r&&(h=1,s.charAt(a-2)===r&&(h=2),a-=4),n=0;n<a;n+=4)l=o(s,n)<<18|o(s,n+1)<<12|o(s,n+2)<<6|o(s,n+3),u.push(l>>16,l>>8&255,255&l),n%1e4==0&&(d.push(String.fromCharCode.apply(null,u)),u=[]);switch(h){case 1:l=o(s,a)<<12|o(s,a+1)<<6|o(s,a+2),u.push(l>>10,l>>2&255);break;case 2:l=o(s,n)<<6|o(s,n+1),u.push(l>>4)}return d.push(String.fromCharCode.apply(null,u)),c=d.join(""),i&&(c=e.decode(c)),c},decodeAsArray:function(t){var e,i=this.decode(t),r=[],s=i.length;for(e=0;e<s;e++)r[e]=i.charCodeAt(e);return r}},t.Util.Base64})),define("server/server",["jxg","utils/zip","utils/base64","utils/type"],(function(t,e,i,r){"use strict";return t.Server={modules:{},runningCalls:{},handleError:function(e){t.debug("error occured, server says: "+e.message)},callServer:function(s,o,n,a){var h,l,c,d,u,p,f;for(p in a=a||!1,"",n)n.hasOwnProperty(p)&&"&"+escape(p)+"="+escape(n[p]);u=r.toJSON(n);do{d=s+Math.floor(4096*Math.random())}while(r.exists(this.runningCalls[d]));return this.runningCalls[d]={action:s},r.exists(n.module)&&(this.runningCalls[d].module=n.module),h=t.serverBase+"JXGServer.py",l="action="+escape(s)+"&id="+d+"&dataJSON="+escape(i.encode(u)),this.cbp=function(t){var s,n,a,h,l,c,d,u;if(s=new e.Unzip(i.decodeAsArray(t)).unzip(),r.isArray(s)&&s.length>0&&(s=s[0][0]),r.exists(s))if("error"===(n=window.JSON&&window.JSON.parse?window.JSON.parse(s):new Function("return "+s)()).type)this.handleError(n);else if("response"===n.type){for(c=n.id,d=0;d<n.fields.length;d++)h=(a=n.fields[d]).namespace+("object"==typeof new Function("return "+a.namespace)()?".":".prototype.")+a.name+" = "+a.value,new Function(h)();for(d=0;d<n.handler.length;d++){for(a=n.handler[d],l=[],u=0;u<a.parameters.length;u++)l[u]='"'+a.parameters[u]+'": '+a.parameters[u];h="if(typeof JXG.Server.modules."+this.runningCalls[c].module+' == "undefined")JXG.Server.modules.'+this.runningCalls[c].module+" = {};",h+="JXG.Server.modules."+this.runningCalls[c].module+"."+a.name+"_cb = "+a.callback+";",h+="JXG.Server.modules."+this.runningCalls[c].module+"."+a.name+" = function ("+a.parameters.join(",")+', __JXGSERVER_CB__, __JXGSERVER_SYNC) {if(typeof __JXGSERVER_CB__ == "undefined") __JXGSERVER_CB__ = JXG.Server.modules.'+this.runningCalls[c].module+"."+a.name+"_cb;var __JXGSERVER_PAR__ = {"+l.join(",")+', "module": "'+this.runningCalls[c].module+'", "handler": "'+a.name+'" };JXG.Server.callServer("exec", __JXGSERVER_CB__, __JXGSERVER_PAR__, __JXGSERVER_SYNC);};',new Function(h)()}delete this.runningCalls[c],o(n.data)}},this.cb=t.bind(this.cbp,this),window.XMLHttpRequest?(c=new XMLHttpRequest).overrideMimeType("text/plain; charset=iso-8859-1"):c=new ActiveXObject("Microsoft.XMLHTTP"),!(!c||(c.open("POST",h,!a),c.setRequestHeader("Content-type","application/x-www-form-urlencoded"),a||(c.onreadystatechange=(f=this.cb,function(){return 4===c.readyState&&200===c.status&&(f(c.responseText),!0)})),c.send(l),!a))&&(this.cb(c.responseText),!0)},loadModule_cb:function(e){var i;for(i=0;i<e.length;i++)t.debug(e[i].name+": "+e[i].value)},loadModule:function(e){return t.Server.callServer("load",t.Server.loadModule_cb,{module:e},!0)}},t.Server.load=t.Server.loadModule,t.Server})),define("math/symbolic",["base/constants","base/coords","math/math","math/geometry","server/server","utils/type"],(function(t,e,i,r,s,o){"use strict";var n;return i.Symbolic={generateSymbolicCoordinatesPartial:function(t,e,i,r){var s,n,a,h=e.ancestors,l=0,c=function(t){return"underscore"===r?i+"_{"+t+"}":"brace"===r?i+"["+t+"]":i+t};for(n in t.listOfFreePoints=[],t.listOfDependantPoints=[],h)if(h.hasOwnProperty(n)&&(s=0,o.isPoint(h[n]))){for(a in h[n].ancestors)h[n].ancestors.hasOwnProperty(a)&&s++;0===s?(h[n].symbolic.x=h[n].coords.usrCoords[1],h[n].symbolic.y=h[n].coords.usrCoords[2],t.listOfFreePoints.push(h[n])):(l+=1,h[n].symbolic.x=c(l),l+=1,h[n].symbolic.y=c(l),t.listOfDependantPoints.push(h[n]))}return o.isPoint(e)&&(e.symbolic.x="x",e.symbolic.y="y"),l},clearSymbolicCoordinates:function(t){var e=function(t){var e,i=t&&t.length||0;for(e=0;e<i;e++)o.isPoint(t[e])&&(t[e].symbolic.x="",t[e].symbolic.y="")};e(t.listOfFreePoints),e(t.listOfDependantPoints),delete t.listOfFreePoints,delete t.listOfDependantPoints},generatePolynomials:function(t,e,i){var r,s,n,a,h=e.ancestors,l=[],c=[];for(r in i&&this.generateSymbolicCoordinatesPartial(t,e,"u","brace"),h[e.id]=e,h)if(h.hasOwnProperty(r)&&(a=0,l=[],o.isPoint(h[r]))){for(s in h[r].ancestors)h[r].ancestors.hasOwnProperty(s)&&a++;if(a>0)for(l=h[r].generatePolynomial(),n=0;n<l.length;n++)c.push(l[n])}return i&&this.clearSymbolicCoordinates(t),c},geometricLocusByGroebnerBase:function(a,h){var l,c,d,u,p,f,m,g,b,v,y,C,_=a.options.locus,P={},E=this.generateSymbolicCoordinatesPartial(a,h,"u","brace"),S=new e(t.COORDS_BY_USR,[0,0],a),x=new e(t.COORDS_BY_USR,[a.canvasWidth,a.canvasHeight],a),O=1,w=0,T=0,N=0;if(s.modules.geoloci===n&&s.loadModule("geoloci"),s.modules.geoloci===n)throw new Error("JSXGraph: Unable to load JXG.Server module 'geoloci.py'.");if(f=S.usrCoords[1],m=x.usrCoords[1],g=x.usrCoords[2],b=S.usrCoords[2],_.translateToOrigin&&a.listOfFreePoints.length>0){for(w=(d=_.toOrigin!==n&&null!==_.toOrigin&&o.isInArray(a.listOfFreePoints,_.toOrigin.id)?_.toOrigin:a.listOfFreePoints[0]).symbolic.x,T=d.symbolic.y,p=0;p<a.listOfFreePoints.length;p++)a.listOfFreePoints[p].symbolic.x-=w,a.listOfFreePoints[p].symbolic.y-=T;if(f-=w,m-=w,g-=T,b-=T,_.translateTo10&&a.listOfFreePoints.length>1){for(u=_.to10!==n&&null!==_.to10&&_.to10.id!==_.toOrigin.id&&o.isInArray(a.listOfFreePoints,_.to10.id)?_.to10:a.listOfFreePoints[0].id===d.id?a.listOfFreePoints[1]:a.listOfFreePoints[0],N=r.rad([1,0],[0,0],[u.symbolic.x,u.symbolic.y]),v=Math.cos(-N),y=Math.sin(-N),p=0;p<a.listOfFreePoints.length;p++)C=a.listOfFreePoints[p].symbolic.x,a.listOfFreePoints[p].symbolic.x=v*a.listOfFreePoints[p].symbolic.x-y*a.listOfFreePoints[p].symbolic.y,a.listOfFreePoints[p].symbolic.y=y*C+v*a.listOfFreePoints[p].symbolic.y;if(u.symbolic.y=0,C=f,f=v*f-y*g,g=y*C+v*g,C=m,m=v*m-y*b,b=y*C+v*b,_.stretch&&Math.abs(u.symbolic.x)>i.eps){for(O=u.symbolic.x,p=0;p<a.listOfFreePoints.length;p++)a.listOfFreePoints[p].symbolic.x/=O,a.listOfFreePoints[p].symbolic.y/=O;for(p=0;p<a.objectsList.length;p++)a.objectsList[p].elementClass===t.OBJECT_CLASS_CIRCLE&&"pointRadius"===a.objectsList[p].method&&(P[p]=a.objectsList[p].radius,a.objectsList[p].radius/=O);f/=O,m/=O,g/=O,b/=O,u.symbolic.x=1}}for(p=0;p<a.listOfFreePoints.length;p++)C=a.listOfFreePoints[p].symbolic.x,Math.abs(C)<i.eps&&(a.listOfFreePoints[p].symbolic.x=0),Math.abs(C-Math.round(C))<i.eps&&(a.listOfFreePoints[p].symbolic.x=Math.round(C)),C=a.listOfFreePoints[p].symbolic.y,Math.abs(C)<i.eps&&(a.listOfFreePoints[p].symbolic.y=0),Math.abs(C-Math.round(C))<i.eps&&(a.listOfFreePoints[p].symbolic.y=Math.round(C))}for(p in l=this.generatePolynomials(a,h).join(","),this.cbp=function(t){c=t},this.cb=o.bind(this.cbp,this),s.modules.geoloci.lociCoCoA(f,m,g,b,E,l,O,N,w,T,this.cb,!0),this.clearSymbolicCoordinates(a),P)P.hasOwnProperty(p)&&(a.objects[p].radius=P[p]);return c}},i.Symbolic})),define("math/clip",["jxg","base/constants","base/coords","math/math","math/geometry","utils/type"],(function(t,e,i,r,s,o){"use strict";return r.Clip={_isSeparator:function(t){return isNaN(t.coords.usrCoords[1])&&isNaN(t.coords.usrCoords[2])},makeDoublyLinkedList:function(t){var e,i=null,r=[],s=t.length;if(s>0)for(e=0;e<s;e++)this._isSeparator(t[e])?(t[e]._next=t[(e+1)%s],t[e]._prev=t[(s+e-1)%s]):(null===i&&(i=e,r.push(i)),this._isSeparator(t[(e+1)%s])||e===s-1?(t[e]._next=t[i],t[i]._prev=t[e],t[e]._end=!0,i=null):(t[e]._next=t[(e+1)%s],t[i]._prev=t[e]),this._isSeparator(t[(s+e-1)%s])||(t[e]._prev=t[(s+e-1)%s]));return r},det:function(t,e,i){return(t[1]-i[1])*(e[2]-i[2])-(e[1]-i[1])*(t[2]-i[2])},windingNumber:function(t,e){var i,s,o,n,a,h=0,l=e.length,c=t[1],d=t[2];if(0===l)return 0;if(isNaN(c)||isNaN(d))return 1;if(e[0].coords.usrCoords[1]===c&&e[0].coords.usrCoords[2]===d)return 1;for(a=0;a<l;a++)if(i=e[a].coords.usrCoords,s=e[(a+1)%l].coords.usrCoords,!(0===i[0]||0===s[0]||isNaN(i[1])||isNaN(s[1])||isNaN(i[2])||isNaN(s[2]))){if(s[2]===d){if(s[1]===c)return 1;if(i[2]===d&&s[1]>c==i[1]<c)return 0}if(i[2]<d!=s[2]<d)if(n=2*(s[2]>i[2]?1:0)-1,i[1]>=c)if(s[1]>c)h+=n;else{if(0===(o=this.det(i,s,t)))return 0;o>0==s[2]>i[2]&&(h+=n)}else s[1]>c&&(o=this.det(i,s,t))>0+r.eps==s[2]>i[2]&&(h+=n)}return h},Vertex:function(t,i,r,s,o,n){this.pos=i,this.intersection=!0,this.coords=t,this.elementClass=e.OBJECT_CLASS_POINT,this.data={alpha:r,path:s,pathname:o,done:!1,type:n,idx:0},this.neighbour=null,this.entry_exit=!1},_addToList:function(t,i,s){var o=t.length,n=r.eps*r.eps;o>0&&Math.abs(t[o-1].coords.usrCoords[0]-i.usrCoords[0])<n&&Math.abs(t[o-1].coords.usrCoords[1]-i.usrCoords[1])<n&&Math.abs(t[o-1].coords.usrCoords[2]-i.usrCoords[2])<n||t.push({pos:s,intersection:!1,coords:i,elementClass:e.OBJECT_CLASS_POINT})},sortIntersections:function(t){var e,i,r,s,o,n,a=[],h=t.length;for(e=0;e<h;e++)if(t[e].sort((function(t,e){return t.data.alpha>e.data.alpha?1:-1})),t[e].length>0){for(o=t[e].length-1,n=(s=(r=t[e][0]).data.path[r.pos])._next,e===h-1&&(s._end=!1),0===r.data.alpha&&"T"===r.data.type?(s.intersection=!0,s.data=r.data,s.neighbour=r.neighbour,s.neighbour.neighbour=s,s.entry_exit=!1,t[e][0]=s):(r._prev=s,r._prev._next=r),i=1;i<=o;i++)(r=t[e][i])._prev=t[e][i-1],r._prev._next=r;(r=t[e][o])._next=n,r._next._prev=r,e===h-1&&(r._end=!0),a=a.concat(t[e])}return a},_inbetween:function(t,e,i){var s,o=r.eps*r.eps,n=i[1]-e[1],a=i[2]-e[2],h=t[1]-e[1],l=t[2]-e[2];return 0===n&&0===a&&0===h&&0===l||(s=Math.abs(h)<o&&Math.abs(n)<o?l/a:h/n,Math.abs(s)<o&&(s=0),s)},_print_array:function(t){var e,i;for(e=0;e<t.length;e++)try{i="",t[e]._end&&(i=" end"),console.log(e,t[e].coords.usrCoords,t[e].data.type,"\t","prev",t[e]._prev.coords.usrCoords,"next",t[e]._next.coords.usrCoords+i)}catch(i){console.log(e,t[e].coords.usrCoords)}},_print_list:function(t){for(var e,i=0;i<100&&(e=t.data?t.data.alpha:"-",console.log("\t",t.coords.usrCoords,"\n\t\tis:",t.intersection,"end:",t._end,e,"\n\t\t-:",t._prev.coords.usrCoords,"\n\t\t+:",t._next.coords.usrCoords,"\n\t\tn:",t.intersection?t.neighbour.coords.usrCoords:"-"),!t._end);)t=t._next,i++},_noOverlap:function(t,e,i,s){var o,n,a,h,l,c=Math.sqrt(r.eps),d=!1;for(o=0;o<3;o++)if(n=Math.min(t[o],e[o]),a=Math.max(t[o],e[o]),h=Math.min(i[o],s[o]),l=Math.max(i[o],s[o]),a<h-c||n>l+c){d=!0;break}return d},findIntersections:function(t,o,n){var a,h,l,c,d,u,p,f,m,g,b,v,y,C=[],_=r.eps,P=t.length,E=o.length,S=[],x=[],O=[],w=!1,T=!1,N=!1;for(h=0;h<E;h++)O.push([]);for(a=0;a<P;a++)if(x.push([]),this._isSeparator(t[a])||this._isSeparator(t[(a+1)%P]))w=!0;else{if(w&&a===P-1)break;for(c=t[a].coords.usrCoords,d=t[(a+1)%P].coords.usrCoords,h=0;h<E;h++)if(this._isSeparator(o[h])||this._isSeparator(o[(h+1)%E]))T=!0;else{if(T&&h===E-1)break;if(u=o[h].coords.usrCoords,p=o[(h+1)%E].coords.usrCoords,!this._noOverlap(c,d,u,p)&&(C=s.meetSegmentSegment(c,d,u,p),f=s.distance(c,d,3),m=s.distance(u,p,3),C[1]*f>-_&&C[1]<1-_/f&&C[2]*m>-_&&C[2]<1-_/m||C[1]===1/0&&C[2]===1/0&&r.norm(C[0],3)<_)){if(l=new i(e.COORDS_BY_USER,C[0],n),b="X",Math.abs(C[1])*f<_||Math.abs(C[2])*m<_)b="T",Math.abs(C[1])*f<_&&(C[1]=0),Math.abs(C[2])*m<_&&(C[2]=0),l=0===C[1]?new i(e.COORDS_BY_USER,c,n):new i(e.COORDS_BY_USER,u,n);else if(C[1]===1/0&&C[2]===1/0&&r.norm(C[0],3)<_){(g=this._inbetween(c,u,p))>=0&&g<1&&(b="T",l=new i(e.COORDS_BY_USER,c,n),C[1]=0,C[2]=g,v=new this.Vertex(l,a,C[1],t,"S",b),y=new this.Vertex(l,h,C[2],o,"C",b),v.neighbour=y,y.neighbour=v,x[a].push(v),O[h].push(y)),g=this._inbetween(u,c,d),s.distance(c,u,3)>_&&g>=0&&g<1&&(b="T",l=new i(e.COORDS_BY_USER,u,n),C[1]=g,C[2]=0,v=new this.Vertex(l,a,C[1],t,"S",b),y=new this.Vertex(l,h,C[2],o,"C",b),v.neighbour=y,y.neighbour=v,x[a].push(v),O[h].push(y));continue}N,v=new this.Vertex(l,a,C[1],t,"S",b),y=new this.Vertex(l,h,C[2],o,"C",b),v.neighbour=y,y.neighbour=v,x[a].push(v),O[h].push(y)}}}for(S=this.sortIntersections(x),a=0;a<S.length;a++)S[a].data.idx=a,S[a].neighbour.data.idx=a;return[S,this.sortIntersections(O)]},_getPosition:function(t,e,i,r){var s=this.det(t,e,i),o=this.det(t,i,r);return this.det(e,i,r)>=0?s>=0&&o>=0?"left":"right":s>=0||o>=0?"left":"right"},_classifyDegenerateIntersections:function(t){var e,i,n,a,h,l,c,d,u,p,f,m,g,b=!1;for(b,c=0,t._tours=0;;){if(t.intersection&&"T"===t.data.type&&(e=t._next.coords.usrCoords,i=t._prev.coords.usrCoords,s.distance(t.coords.usrCoords,e,3)<r.eps&&(e=t._next._next.coords.usrCoords),s.distance(t.coords.usrCoords,i,3)<r.eps&&(i=t._prev._prev.coords.usrCoords),a=(h=t.neighbour)._prev.coords.usrCoords,n=h._next.coords.usrCoords,s.distance(h.coords.usrCoords,n,3)<r.eps&&(n=h._next._next.coords.usrCoords),s.distance(h.coords.usrCoords,a,3)<r.eps&&(a=h._prev._prev.coords.usrCoords),p=this.det(t.coords.usrCoords,i,a),f=this.det(t.coords.usrCoords,e,n),m=this.det(t.coords.usrCoords,i,n),g=this.det(t.coords.usrCoords,e,a),0===p&&0===f&&0===m&&0===g&&(t.coords.usrCoords[1]*=1+Math.random()*r.eps,t.coords.usrCoords[2]*=1+Math.random()*r.eps,h.coords.usrCoords[1]=t.coords.usrCoords[1],h.coords.usrCoords[2]=t.coords.usrCoords[2],p=this.det(t.coords.usrCoords,i,a),f=this.det(t.coords.usrCoords,e,n),m=this.det(t.coords.usrCoords,i,n),g=this.det(t.coords.usrCoords,e,a)),u=!1,0===p?s.affineRatio(t.coords.usrCoords,i,a)<0&&(u=!0):0===f?s.affineRatio(t.coords.usrCoords,e,n)<0&&(u=!0):0===m?s.affineRatio(t.coords.usrCoords,i,n)>0&&(u=!0):0===g&&s.affineRatio(t.coords.usrCoords,e,a)>0&&(u=!0),u&&(d=a,a=n,n=d,d=p,p=m,m=d,d=f,f=g,g=d),o.exists(t.delayedStatus)||(t.delayedStatus=[]),0===p&&0===f?t.delayedStatus=["on","on"]:0===p?(l=this._getPosition(e,a,h.coords.usrCoords,n),t.delayedStatus=["on",l]):0===f?(l=this._getPosition(i,a,h.coords.usrCoords,n),t.delayedStatus=[l,"on"]):0===t.delayedStatus.length&&(this._getPosition(i,a,h.coords.usrCoords,n)!==this._getPosition(e,a,h.coords.usrCoords,n)?t.data.type="X":t.data.type="B")),o.exists(t._tours)&&t._tours++,t._tours>3||t._end||c>1e3){c>1e3&&console.log("Clipping: _classifyDegenerateIntersections exit"),o.exists(t._tours)&&delete t._tours;break}t.intersection&&c++,t=t._next}},_handleIntersectionChains:function(t){var e,i=0,r="Null",s=!1,o=!1,n=!1;for(n;!0===t.intersection&&("T"===t.data.type&&("on"!==t.delayedStatus[0]&&"on"===t.delayedStatus[1]?(s=!0,e=t,r=t.delayedStatus[0]):s&&"on"===t.delayedStatus[0]&&"on"===t.delayedStatus[1]?t.data.type="B":s&&"on"===t.delayedStatus[0]&&"on"!==t.delayedStatus[1]&&(s=!1,r===t.delayedStatus[1]?(e.data.type="DB",t.data.type="DB"):(e.data.type="DX",t.data.type="DX"))),i++),t._end&&(o=!0),!o||s;){if(i>1e3){console.log("Warning: _handleIntersectionChains: intersection chain reached maximum numbers of iterations");break}t=t._next}},_handleFullyDegenerateCase:function(t,s,o){var n,a,h,l,c,d,u,p,f,m,g,b,v,y=[t,s];for(h=0;h<2;h++){for(m=(n=y[h]).length,p=0,v=!0;p<m;p++)if(!n[p].intersection){v=!1;break}if(v)for(g=(a=y[(h+1)%2]).length,p=0;p<m;p++){for(c=n[p].coords.usrCoords,d=n[(p+1)%m].coords.usrCoords,l=[.5*(c[0]+d[0]),.5*(c[1]+d[1]),.5*(c[2]+d[2])],f=0,b=!1;f<g;f++)if(Math.abs(this.det(a[f].coords.usrCoords,a[(f+1)%g].coords.usrCoords,l))<r.eps){b=!0;break}if(!b){u={pos:p,intersection:!1,coords:new i(e.COORDS_BY_USER,l,o),elementClass:e.OBJECT_CLASS_POINT},n[p]._next=u,u._prev=n[p],n[(p+1)%m]._prev=u,u._next=n[(p+1)%m],n[p]._end&&(n[p]._end=!1,u._end=!0);break}}}},_getStatus:function(t,e){for(;t.intersection&&!t._end;)t=t._next;return[t,this.windingNumber(t.coords.usrCoords,e)%2==0?"entry":"exit"]},markEntryExit:function(t,e,i){var r,s,n,a,h,l,c,d=null,u=0;for(l=i.length,h=0;h<l;h++)for(c=i[h],this._classifyDegenerateIntersections(t[c]),this._handleIntersectionChains(t[c]),s=(a=this._getStatus(t[c],e))[0],r=a[1],s._starter=!0,n=0,d=null,u=0;!0===s.intersection&&("X"===s.data.type&&1===u&&(d.entry_exit=r,"exit"===r&&(d.data.type="X"),u=2),"X"!==s.data.type&&"DB"!==s.data.type||(s.entry_exit=r,r="entry"===r?"exit":"entry"),"DX"===s.data.type&&(0===u?(d=s,u=1):1===u?(s.entry_exit=r,d.entry_exit=r,"exit"===r?d.data.type="X":s.data.type="X",r="entry"===r?"exit":"entry",d=null,u=0):2===u&&(s.entry_exit=r,s.data.type="X",r="entry"===r?"exit":"entry",d=null,u=0))),s=s._next,!(o.exists(s._starter)||n>1e4);)n++},_stayOnPath:function(t,e){var i=!0;return t.intersection&&"B"!==t.data.type&&(i=e===t.entry_exit),i},_addVertex:function(t,e,i){return isNaN(e.coords.usrCoords[1])||isNaN(e.coords.usrCoords[2])||t.push(e),e.intersection&&e.data.done?(i&&console.log("Add last intersection point",e.coords.usrCoords,"on",e.data.pathname,e.entry_exit,e.data.type),!0):(e.intersection&&(e.data.done=!0,i&&console.log("Add intersection point",e.coords.usrCoords,"on",e.data.pathname,e.entry_exit,e.data.type)),!1)},tracing:function(t,e,i){var r,s,o,n,a=0,h=1e4,l=0,c=[],d=!1,u=!1;for(u;l<e.length&&a<h;)if((s=e[l]).data.done||"X"!==s.data.type)l++;else{u,c.length>0&&c.push([NaN,NaN]),o=s.data.idx,r=t,d=this._addVertex(c,s,u),n=s.entry_exit;do{if(d)break;if("intersection"===i&&"entry"===s.entry_exit||"union"===i&&"exit"===s.entry_exit||"difference"===i&&r===t==("exit"===s.entry_exit)){u;do{if(s=s._next,d=this._addVertex(c,s,u))break}while(this._stayOnPath(s,n));a++}else{u;do{if(s=s._prev,d=this._addVertex(c,s,u))break}while(this._stayOnPath(s,n));a++}if(d)break;if(!s.neighbour)return console.log("Tracing: emergency break - no neighbour!!!!!!!!!!!!!!!!!",a),[[0],[0]];if((s=s.neighbour).data.done)break;s.data.done=!0,n=s.entry_exit,r=s.data.path}while(s.data.idx!==o&&a<h);a>=h&&console.log("Tracing: stopping an infinite loop!",a),l++}return this._getCoordsArrays(c,!1)},isEmptyCase:function(t,e,i){return"intersection"===i&&(0===t.length||0===e.length)||("union"===i&&0===t.length&&0===e.length||"difference"===i&&0===t.length)},_getCoordsArrays:function(t,e){var i,r=[],s=[],o=t.length;for(i=0;i<o;i++)t[i].coords?(r.push(t[i].coords.usrCoords[1]),s.push(t[i].coords.usrCoords[2])):(r.push(t[i][0]),s.push(t[i][1]));return e&&o>0&&(t[0].coords?(r.push(t[0].coords.usrCoords[1]),s.push(t[0].coords.usrCoords[2])):(r.push(t[0][0]),s.push(t[0][1]))),[r,s]},handleEmptyIntersection:function(t,e,i){var r,o,n=!1,a=[];if(0===t.length)return a="union"===i?e:[],this._getCoordsArrays(a,!0);if(0===e.length)return a="intersection"===i?[]:t,this._getCoordsArrays(a,!0);if(t.length>0)for(r=t[0];r.intersection&&!(r=r._next)._end;);if(e.length>0)for(o=e[0];o.intersection&&!(o=o._next)._end;);return 0===this.windingNumber(r.coords.usrCoords,e)?0!==this.windingNumber(o.coords.usrCoords,t)?("union"===i?(a=a.concat(t)).push(t[0]):"difference"===i&&((a=a.concat(t)).push(t[0]),s.signedPolygon(t)*s.signedPolygon(e)>0&&a.reverse(),a.push([NaN,NaN])),"difference"!==i&&"intersection"!==i||((a=a.concat(e)).push(e[0]),n=!1)):"difference"===i?(a=a.concat(t),n=!0):"union"===i&&((a=a.concat(t)).push(t[0]),a.push([NaN,NaN]),(a=a.concat(e)).push(e[0])):"intersection"===i?(a=a.concat(t),n=!0):"union"===i&&(a=a.concat(e)).push(e[0]),this._getCoordsArrays(a,n)},_countCrossingIntersections:function(t){var e,i=t.length,r=0;for(e=0;e<i;e++)"X"===t[e].data.type&&r++;return r},_getPath:function(t,r){var n,a,h,l,c,d,u,p=[];if(t.elementClass!==e.OBJECT_CLASS_CURVE||t.type!==e.OBJECT_TYPE_ARC&&t.type!==e.OBJECT_TYPE_SECTOR){if(t.elementClass===e.OBJECT_CLASS_CURVE&&o.exists(t.points))for(a=t.numberPoints,n=0;n<a;n++)this._addToList(p,t.points[n],n);else if(t.type===e.OBJECT_TYPE_POLYGON)for(n=0;n<t.vertices.length;n++)this._addToList(p,t.vertices[n].coords,n);else if(t.elementClass===e.OBJECT_CLASS_CIRCLE)for(u=359,h=t.Radius(),l=2*Math.PI/u,n=0;n<=u;n++)this._addToList(p,new i(e.COORDS_BY_USER,[t.center.coords.usrCoords[0],t.center.coords.usrCoords[1]+Math.cos(n*l)*h,t.center.coords.usrCoords[2]+Math.sin(n*l)*h],r),n);else if(o.isArray(t))for(a=t.length,n=0;n<a;n++)o.exists(t[n].coords)?this._addToList(p,t[n].coords,n):o.isArray(t[n])?this._addToList(p,new i(e.COORDS_BY_USER,t[n],r),n):o.exists(t[n].usrCoords)&&this._addToList(p,t[n],n)}else{for(c=s.rad(t.radiuspoint,t.center,t.anglepoint),u=Math.floor(180*c/Math.PI),h=t.Radius(),l=c/u,d=Math.atan2(t.radiuspoint.coords.usrCoords[2]-t.center.coords.usrCoords[2],t.radiuspoint.coords.usrCoords[1]-t.center.coords.usrCoords[1]),t.type===e.OBJECT_TYPE_SECTOR&&this._addToList(p,t.center.coords,0),n=0;n<=u;n++)this._addToList(p,new i(e.COORDS_BY_USER,[t.center.coords.usrCoords[0],t.center.coords.usrCoords[1]+Math.cos(n*l+d)*h,t.center.coords.usrCoords[2]+Math.sin(n*l+d)*h],r),n+1);t.type===e.OBJECT_TYPE_SECTOR&&this._addToList(p,t.center.coords,u+2)}return p},greinerHormann:function(t,e,i,o){var n,a,h,l,c=[],d=[];return(n=(c=this._getPath(t,o)).length)>0&&s.distance(c[0].coords.usrCoords,c[n-1].coords.usrCoords,3)<r.eps&&c.pop(),(n=(d=this._getPath(e,o)).length)>0&&s.distance(d[0].coords.usrCoords,d[n-1].coords.usrCoords,3)<r.eps*r.eps&&d.pop(),this.isEmptyCase(c,d,i)?[[],[]]:(h=this.makeDoublyLinkedList(c),l=this.makeDoublyLinkedList(d),a=this.findIntersections(c,d,o)[0],this._handleFullyDegenerateCase(c,d,o),this.markEntryExit(c,d,h),this.markEntryExit(d,c,l),0===this._countCrossingIntersections(a)?this.handleEmptyIntersection(c,d,i):this.tracing(c,a,i))},union:function(t,e,i){return this.greinerHormann(t,e,"union",i)},intersection:function(t,e,i){return this.greinerHormann(t,e,"intersection",i)},difference:function(t,e,i){return this.greinerHormann(t,e,"difference",i)}},t.extend(r.Clip,{}),r.Clip})),define("math/poly",["jxg","math/math","utils/type"],(function(t,e,i){"use strict";return e.Poly={},e.Poly.Ring=function(t){this.vars=t},t.extend(e.Poly.Ring.prototype,{}),e.Poly.Monomial=function(t,e,r){var s;if(!i.exists(t))throw new Error("JSXGraph error: In JXG.Math.Poly.monomial missing parameter 'ring'.");for(i.isArray(r)||(r=[]),s=(r=r.slice(0,t.vars.length)).length;s<t.vars.length;s++)r.push(0);this.ring=t,this.coefficient=e||0,this.exponents=i.deepCopy(r)},t.extend(e.Poly.Monomial.prototype,{copy:function(){return new e.Poly.Monomial(this.ring,this.coefficient,this.exponents)},print:function(){var t,e=[];for(t=0;t<this.ring.vars.length;t++)e.push(this.ring.vars[t]+"^"+this.exponents[t]);return this.coefficient+"*"+e.join("*")}}),e.Poly.Polynomial=function(t,e){var r;if(!i.exists(t))throw new Error("JSXGraph error: In JXG.Math.Poly.polynomial missing parameter 'ring'.");r=i.exists(e)&&i.isString(e)?void 0:[],this.ring=t,this.monomials=r},t.extend(e.Poly.Polynomial.prototype,{findSignature:function(t){var e;for(e=0;e<this.monomials.length;e++)if(i.cmpArrays(this.monomials[e].exponents,t))return e;return-1},addSubMonomial:function(t,e){var i;(i=this.findSignature(t.exponents))>-1?this.monomials[i].coefficient+=e*t.coefficient:(t.coefficient*=e,this.monomials.push(t))},add:function(t){var e;if(!i.exists(t)||t.ring!==this.ring)throw new Error("JSXGraph error: In JXG.Math.Poly.polynomial.add either summand is undefined or rings don't match.");if(i.isArray(t.exponents))this.addSubMonomial(t,1);else for(e=0;e<t.monomials.length;e++)this.addSubMonomial(t.monomials[e],1)},sub:function(t){var e;if(!i.exists(t)||t.ring!==this.ring)throw new Error("JSXGraph error: In JXG.Math.Poly.polynomial.sub either summand is undefined or rings don't match.");if(i.isArray(t.exponents))this.addSubMonomial(t,-1);else for(e=0;e<t.monomials.length;e++)this.addSubMonomial(t.monomials[e],-1)},copy:function(){var t,i;for(i=new e.Poly.Polynomial(this.ring),t=0;t<this.monomials.length;t++)i.monomials.push(this.monomials[t].copy());return i},print:function(){var t,e=[];for(t=0;t<this.monomials.length;t++)e.push("("+this.monomials[t].print()+")");return e.join("+")}}),e.Poly})),define("math/complex",["jxg","utils/type"],(function(t,e){"use strict";return t.Complex=function(t,e){this.isComplex=!0,t&&t.isComplex&&(e=t.imaginary,t=t.real),this.real=t||0,this.imaginary=e||0,this.absval=0,this.angle=0},t.extend(t.Complex.prototype,{toString:function(){return this.real+" + "+this.imaginary+"i"},add:function(t){return e.isNumber(t)?this.real+=t:(this.real+=t.real,this.imaginary+=t.imaginary),this},sub:function(t){return e.isNumber(t)?this.real-=t:(this.real-=t.real,this.imaginary-=t.imaginary),this},mult:function(t){var i,r;return e.isNumber(t)?(this.real*=t,this.imaginary*=t):(i=this.real,r=this.imaginary,this.real=i*t.real-r*t.imaginary,this.imaginary=i*t.imaginary+r*t.real),this},div:function(t){var i,r,s;if(e.isNumber(t)){if(Math.abs(t)<Math.eps)return this.real=1/0,this.imaginary=1/0,this;this.real/=t,this.imaginary/=t}else{if(Math.abs(t.real)<Math.eps&&Math.abs(t.imaginary)<Math.eps)return this.real=1/0,this.imaginary=1/0,this;i=t.real*t.real+t.imaginary*t.imaginary,s=this.real,r=this.imaginary,this.real=(s*t.real+r*t.imaginary)/i,this.imaginary=(r*t.real-s*t.imaginary)/i}return this},conj:function(){return this.imaginary*=-1,this}}),t.C={},t.C.add=function(e,i){var r=new t.Complex(e);return r.add(i),r},t.C.sub=function(e,i){var r=new t.Complex(e);return r.sub(i),r},t.C.mult=function(e,i){var r=new t.Complex(e);return r.mult(i),r},t.C.div=function(e,i){var r=new t.Complex(e);return r.div(i),r},t.C.conj=function(e){var i=new t.Complex(e);return i.conj(),i},t.C.abs=function(e){var i=new t.Complex(e);return i.conj(),i.mult(e),Math.sqrt(i.real)},t.Complex.C=t.C,t.Complex})),define("utils/color",["jxg","utils/type","math/math"],(function(t,e,i){"use strict";var r={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"},s=[{re:/^\s*rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([\d.]{1,3})\s*\)\s*$/,example:["rgba(123, 234, 45, 0.5)","rgba(255,234,245,1.0)"],process:function(t){return[parseInt(t[1],10),parseInt(t[2],10),parseInt(t[3],10)]}},{re:/^\s*rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)\s*$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(t){return[parseInt(t[1],10),parseInt(t[2],10),parseInt(t[3],10)]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)]}}];return t.rgbParser=function(t,i,o){var n,a,h,l,c,d,u,p,f,m,g=t;if(!e.exists(t))return[];if(e.exists(i)&&e.exists(o)&&(g=[t,i,o]),n=g,m=!1,e.isArray(n)){for(d=0;d<3;d++)m=m||/\./.test(g[d].toString());for(d=0;d<3;d++)m=m&&g[d]>=0&&g[d]<=1;return m?[Math.ceil(255*g[0]),Math.ceil(255*g[1]),Math.ceil(255*g[2])]:g}for("string"==typeof g&&(n=g),"#"===n.charAt(0)&&(n=n.substr(1,6)),n=n.replace(/ /g,"").toLowerCase(),n=r[n]||n,d=0;d<s.length;d++)h=s[d].re,l=s[d].process,(c=h.exec(n))&&(u=(a=l(c))[0],p=a[1],f=a[2]);return isNaN(u)||isNaN(p)||isNaN(f)?[]:[u=u<0||isNaN(u)?0:u>255?255:u,p=p<0||isNaN(p)?0:p>255?255:p,f=f<0||isNaN(f)?0:f>255?255:f]},t.rgb2css=function(e,i,r){var s;return"rgb("+(s=t.rgbParser(e,i,r))[0]+", "+s[1]+", "+s[2]+")"},t.rgb2hex=function(e,i,r){var s,o,n;return o=(s=t.rgbParser(e,i,r))[1],n=s[2],s=(s=s[0]).toString(16),o=o.toString(16),n=n.toString(16),1===s.length&&(s="0"+s),1===o.length&&(o="0"+o),1===n.length&&(n="0"+n),"#"+s+o+n},t.hex2rgb=function(e){return t.deprecated("JXG.hex2rgb()","JXG.rgb2css()"),t.rgb2css(e)},t.hsv2rgb=function(t,e,r){var s,o,n,a,h,l,c,d,u;if(t=(t%360+360)%360,0===e){if(!(isNaN(t)||t<i.eps))return"#ffffff";s=r,o=r,n=r}else switch(l=t>=360?0:t,c=r*(1-e),d=r*(1-e*(a=(l/=60)-(h=Math.floor(l)))),u=r*(1-e*(1-a)),h){case 0:s=r,o=u,n=c;break;case 1:s=d,o=r,n=c;break;case 2:s=c,o=r,n=u;break;case 3:s=c,o=d,n=r;break;case 4:s=u,o=c,n=r;break;case 5:s=r,o=c,n=d}return["#",s=2===(s=Math.round(255*s).toString(16)).length?s:1===s.length?"0"+s:"00",o=2===(o=Math.round(255*o).toString(16)).length?o:1===o.length?"0"+o:"00",n=2===(n=Math.round(255*n).toString(16)).length?n:1===n.length?"0"+n:"00"].join("")},t.rgb2hsv=function(e,i,r){var s,o,n,a,h,l,c,d,u,p,f,m,g;return o=(s=t.rgbParser(e,i,r))[1],n=s[2],a=(s=s[0])/255,h=o/255,l=n/255,m=Math.max(s,o,n),d=(g=Math.min(s,o,n))/255,p=0,(f=c=m/255)>0&&(p=(f-d)/f),u=1/(c-d),p>0&&(m===s?u*=h-l:u=m===o?2+(l-a)*u:4+(a-h)*u),(u*=60)<0&&(u+=360),m===g&&(u=0),[u,p,f]},t.rgb2LMS=function(e,i,r){var s,o,n,a,h,l,c,d=[[.05059983,.08585369,.0095242],[.01893033,.08925308,.01370054],[.00292202,.00975732,.07145979]];return o=(s=t.rgbParser(e,i,r))[1],n=s[2],s=s[0],s=Math.pow(s,.476190476),o=Math.pow(o,.476190476),n=Math.pow(n,.476190476),(c=[a=s*d[0][0]+o*d[0][1]+n*d[0][2],h=s*d[1][0]+o*d[1][1]+n*d[1][2],l=s*d[2][0]+o*d[2][1]+n*d[2][2]]).l=a,c.m=h,c.s=l,c},t.LMS2rgb=function(t,e,i){var r,s,o,n,a=[[30.830854,-29.832659,1.610474],[-6.481468,17.715578,-2.532642],[-.37569,-1.199062,14.273846]],h=function(t){for(var e=127,i=64;i>0;){if(Math.pow(e,.476190476)>t)e-=i;else{if(Math.pow(e+1,.476190476)>t)return e;e+=i}i/=2}return 254===e&&13.994955247<t?255:e};return r=t*a[0][0]+e*a[0][1]+i*a[0][2],s=t*a[1][0]+e*a[1][1]+i*a[1][2],o=t*a[2][0]+e*a[2][1]+i*a[2][2],(n=[r=h(r),s=h(s),o=h(o)]).r=r,n.g=s,n.b=o,n},t.rgba2rgbo=function(t){var e;return 9===t.length&&"#"===t.charAt(0)?(e=parseInt(t.substr(7,2).toUpperCase(),16)/255,t=t.substr(0,7)):e=1,[t,e]},t.rgbo2rgba=function(t,e){var i;return"none"===t?t:(1===(i=Math.round(255*e).toString(16)).length&&(i="0"+i),t+i)},t.rgb2bw=function(e){var i,r,s,o="0123456789ABCDEF";return"none"===e?e:(s=t.rgbParser(e),i=Math.floor(.3*s[0]+.59*s[1]+.11*s[2]),e="#"+(r=o.charAt(i>>4&15)+o.charAt(15&i))+r+r)},t.rgb2cb=function(e,i){var r,s,o,n,a,h,l,c,d,u,p,f="0123456789ABCDEF";if("none"===e)return e;switch(s=(a=t.rgb2LMS(e))[0],o=a[1],n=a[2],i=i.toLowerCase()){case"protanopia":h=-.06150039994295001,l=.08277001656812001,c=-.013200141220000003,d=.05858939668799999,u=-.07934519995360001,p=.013289415272000003,s=n/o<.6903216543277437?-(l*o+c*n)/h:-(u*o+p*n)/d;break;case"tritanopia":h=-.00058973116217,l=.007690316482,c=-.01011703519052,d=.025495080838999994,u=-.0422740347,p=.017005316784,n=o/s<.8349489908460004?-(h*s+l*o)/c:-(d*s+u*o)/p;break;default:h=-.06150039994295001,l=.08277001656812001,c=-.013200141220000003,d=.05858939668799999,u=-.07934519995360001,p=.013289415272000003,o=n/s<.5763833686400911?-(h*s+c*n)/l:-(d*s+p*n)/u}return r=t.LMS2rgb(s,o,n),e="#"+(f.charAt(r[0]>>4&15)+f.charAt(15&r[0])),e+=f.charAt(r[1]>>4&15)+f.charAt(15&r[1]),e+=f.charAt(r[2]>>4&15)+f.charAt(15&r[2])},t.autoHighlight=function(e){var i=t.rgba2rgbo(e),r=i[0],s=i[1];return"#"===e.charAt(0)?(s*=s<.3?1.8:.4,t.rgbo2rgba(r,s)):e},t.contrast=function(e,i,r,s){var o,n,a,h,l;return i=i||"#000000",r=r||"#ffffff",s=s||7,o=t.rgbParser(e),n=t.rgbParser("#000000"),l=(a=.2126*Math.pow(o[0]/255,2.2)+.7152*Math.pow(o[1]/255,2.2)+.0722*Math.pow(o[2]/255,2.2))>(h=.2126*Math.pow(n[0]/255,2.2)+.7152*Math.pow(n[1]/255,2.2)+.0722*Math.pow(n[2]/255,2.2))?Math.floor((a+.05)/(h+.05)):Math.floor((h+.05)/(a+.05)),(l-=1)>s?i:r},t.setClassicColors=function(){t.Options.elements.strokeColor="blue",t.Options.elements.fillColor="red",t.Options.hatch.strokeColor="blue",t.Options.angle.fillColor="#ff7f00",t.Options.angle.highlightFillColor="#ff7f00",t.Options.angle.strokeColor="#ff7f00",t.Options.angle.label.strokeColor="blue",t.Options.arc.strokeColor="blue",t.Options.circle.center.fillColor="red",t.Options.circle.center.strokeColor="blue",t.Options.circumcircle.strokeColor="blue",t.Options.circumcircle.center.fillColor="red",t.Options.circumcircle.center.strokeColor="blue",t.Options.circumcirclearc.strokeColor="blue",t.Options.circumcirclesector.strokeColor="blue",t.Options.circumcirclesector.fillColor="green",t.Options.circumcirclesector.highlightFillColor="green",t.Options.conic.strokeColor="blue",t.Options.curve.strokeColor="blue",t.Options.incircle.strokeColor="blue",t.Options.incircle.center.fillColor="red",t.Options.incircle.center.strokeColor="blue",t.Options.inequality.fillColor="red",t.Options.integral.fillColor="red",t.Options.integral.curveLeft.color="red",t.Options.integral.curveRight.color="red",t.Options.line.strokeColor="blue",t.Options.point.fillColor="red",t.Options.point.strokeColor="red",t.Options.polygon.fillColor="green",t.Options.polygon.highlightFillColor="green",t.Options.polygon.vertices.strokeColor="red",t.Options.polygon.vertices.fillColor="red",t.Options.regularpolygon.fillColor="green",t.Options.regularpolygon.highlightFillColor="green",t.Options.regularpolygon.vertices.strokeColor="red",t.Options.regularpolygon.vertices.fillColor="red",t.Options.riemannsum.fillColor="yellow",t.Options.sector.fillColor="green",t.Options.sector.highlightFillColor="green",t.Options.semicircle.center.fillColor="red",t.Options.semicircle.center.strokeColor="blue",t.Options.slopetriangle.fillColor="red",t.Options.slopetriangle.highlightFillColor="red",t.Options.turtle.arrow.strokeColor="blue"},t.extend(t,{paletteWong:{black:"#000000",orange:"#E69F00",skyblue:"#56B4E9",bluishgreen:"#009E73",yellow:"#F0E442",darkblue:"#0072B2",vermillion:"#D55E00",reddishpurple:"#CC79A7",blue:"#0072B2",red:"#D55E00",green:"#009E73",purple:"#CC79A7",white:"#ffffff"}}),t.palette=t.paletteWong,t})),define("options",["jxg","base/constants","math/math","utils/color","utils/type"],(function(t,e,i,r,s){"use strict";return t.Options={jc:{enabled:!0,compile:!0},board:{boundingBox:[-5,5,5,-5],maxBoundingBox:[-1/0,1/0,1/0,-1/0],zoomFactor:1,zoomX:1,zoomY:1,title:"",description:"",showCopyright:!0,axis:!1,defaultAxes:{x:{name:"x",ticks:{label:{visible:"inherit",anchorX:"middle",anchorY:"top",fontSize:12,offset:[0,-3]},drawZero:!1,visible:"inherit"}},y:{name:"y",ticks:{label:{visible:"inherit",anchorX:"right",anchorY:"middle",fontSize:12,offset:[-6,0]},tickEndings:[1,0],drawZero:!1,visible:"inherit"}}},showNavigation:!0,showZoom:!0,showReload:!1,showScreenshot:!1,screenshot:{scale:1,type:"png",symbol:"⌘",css:"background-color:#eeeeee; opacity:1.0; border:2px solid black; border-radius:10px; text-align:center",cssButton:"padding: 4px 10px; border: solid #356AA0 1px; border-radius: 5px; position: absolute; right: 2ex; top: 2ex; background-color: rgba(255, 255, 255, 0.3);"},showFullscreen:!1,fullscreen:{symbol:"□",id:null},showClearTraces:!1,keepAspectRatio:!1,ignoreLabels:!0,maxNameLength:1,document:!1,takeFirst:!1,takeSizeFromFile:!1,renderer:"auto",animationDelay:35,maxFrameRate:40,registerEvents:!0,minimizeReflow:"none",offsetX:0,offsetY:0,zoom:{enabled:!0,factorX:1.25,factorY:1.25,wheel:!0,needShift:!0,min:1e-4,max:1e4,pinchHorizontal:!0,pinchVertical:!0,pinchSensitivity:7},pan:{needShift:!0,needTwoFingers:!1,enabled:!0},drag:{enabled:!0},keyboard:{enabled:!0,dx:10,dy:10,panShift:!0,panCtrl:!1},resize:{enabled:!0,throttle:10},moveTarget:null,selection:{enabled:!1,name:"selectionPolygon",needShift:!1,needCtrl:!0,withLines:!1,vertices:{visible:!1},fillColor:"#ffff00",visible:!1},showInfobox:!0},navbar:{strokeColor:"#333333",fillColor:"transparent",highlightFillColor:"#aaaaaa",padding:"2px",position:"absolute",fontSize:"14px",cursor:"pointer",zIndex:"100",right:"5px",bottom:"5px"},elements:{strokeColor:r.palette.blue,highlightStrokeColor:"#c3d9ff",fillColor:r.palette.red,highlightFillColor:"none",strokeOpacity:1,highlightStrokeOpacity:1,fillOpacity:1,highlightFillOpacity:1,gradient:null,gradientSecondColor:"#ffffff",gradientSecondOpacity:1,gradientStartOffset:0,gradientEndOffset:1,gradientAngle:0,gradientCX:.5,gradientCY:.5,gradientR:.5,gradientFX:.5,gradientFY:.5,gradientFR:0,transitionDuration:100,strokeWidth:2,highlightStrokeWidth:2,fixed:!1,frozen:!1,withLabel:!1,visible:!0,priv:!1,layer:0,dash:0,shadow:!1,trace:!1,traceAttributes:{},highlight:!0,needsRegularUpdate:!0,snapToGrid:!1,scalable:!0,dragToTopOfLayer:!1,precision:"inherit",draft:{draft:!1,strokeColor:"#565656",fillColor:"#565656",strokeOpacity:.8,fillOpacity:.8,strokeWidth:1},isLabel:!1,tabindex:0},ticks:{generateLabelText:null,generateLabelValue:null,drawLabels:!1,label:{},beautifulScientificTickLabels:!1,useUnicodeMinus:!0,anchor:"left",drawZero:!1,insertTicks:!1,minTicksDistance:10,minorHeight:4,majorHeight:10,tickEndings:[1,1],minorTicks:4,scale:1,scaleSymbol:"",labels:[],maxLabelLength:5,precision:3,digits:3,ticksDistance:1,face:"|",strokeOpacity:1,strokeWidth:1,strokeColor:"#000000",highlightStrokeColor:"#888888",fillColor:"none",highlightFillColor:"none",visible:"inherit",includeBoundaries:!1,type:"linear"},hatch:{drawLabels:!1,drawZero:!0,majorHeight:20,anchor:"middle",face:"|",strokeWidth:2,strokeColor:r.palette.blue,ticksDistance:.2},precision:{touch:30,touchMax:100,mouse:4,pen:4,epsilon:1e-4,hasPoint:4},layer:{numlayers:20,unused9:19,unused8:18,unused7:17,unused6:16,unused5:15,unused4:14,unused3:13,unused2:12,unused1:11,unused0:10,text:9,point:9,glider:9,arc:8,line:7,circle:6,curve:5,turtle:5,polygon:3,sector:3,angle:3,integral:3,axis:2,ticks:2,grid:1,image:0,trace:0},angle:{withLabel:!0,radius:"auto",type:"sector",orthoType:"square",orthoSensitivity:1,fillColor:r.palette.orange,highlightFillColor:r.palette.orange,strokeColor:r.palette.orange,fillOpacity:.3,highlightFillOpacity:.3,radiuspoint:{withLabel:!1,visible:!1,name:""},pointsquare:{withLabel:!1,visible:!1,name:""},dot:{visible:!1,strokeColor:"none",fillColor:"#000000",size:2,face:"o",withLabel:!1,name:""},label:{position:"top",offset:[0,0],strokeColor:r.palette.blue},arc:{visible:!1,fillColor:"none"}},arc:{selection:"auto",hasInnerPoints:!1,label:{anchorX:"auto",anchorY:"auto"},firstArrow:!1,lastArrow:!1,fillColor:"none",highlightFillColor:"none",strokeColor:r.palette.blue,highlightStrokeColor:"#c3d9ff",useDirection:!1,center:{},radiusPoint:{},anglePoint:{}},arrow:{firstArrow:!1,lastArrow:{type:1,highlightSize:6,size:6}},axis:{name:"",needsRegularUpdate:!1,strokeWidth:1,lastArrow:{type:1,highlightSize:8,size:8},strokeColor:"#666666",highlightStrokeWidth:1,highlightStrokeColor:"#888888",withTicks:!0,straightFirst:!0,straightLast:!0,margin:-4,withLabel:!1,scalable:!1,ticks:{label:{offset:[4,-9],parse:!1,needsRegularUpdate:!1,display:"internal",visible:"inherit",layer:9},visible:"inherit",needsRegularUpdate:!1,strokeWidth:1,strokeColor:"#666666",highlightStrokeColor:"#888888",drawLabels:!0,drawZero:!1,insertTicks:!0,minTicksDistance:5,minorHeight:10,majorHeight:-1,tickEndings:[0,1],minorTicks:4,ticksDistance:1,strokeOpacity:.25},point1:{needsRegularUpdate:!1,visible:!1},point2:{needsRegularUpdate:!1,visible:!1},tabindex:-1,label:{position:"lft",offset:[10,10]}},bisector:{strokeColor:"#000000",point:{visible:!1,fixed:!1,withLabel:!1,name:""}},bisectorlines:{line1:{strokeColor:"#000000"},line2:{strokeColor:"#000000"}},boxplot:{dir:"vertical",smallWidth:.5,strokeWidth:2,strokeColor:r.palette.blue,fillColor:r.palette.blue,fillOpacity:.2,highlightStrokeWidth:2,highlightStrokeColor:r.palette.blue,highlightFillColor:r.palette.blue,highlightFillOpacity:.1},button:{disabled:!1,display:"html"},cardinalspline:{createPoints:!0,isArrayOfCoordinates:!1,points:{strokeOpacity:.05,fillOpacity:.05,highlightStrokeOpacity:1,highlightFillOpacity:1,withLabel:!1,name:"",fixed:!1}},chart:{chartStyle:"line",colors:["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#c3d9ff","#4096EE","#008C00"],highlightcolors:null,fillcolor:null,highlightonsector:!1,highlightbysize:!1,fillOpacity:.6,withLines:!1,label:{}},checkbox:{disabled:!1,checked:!1,display:"html"},circle:{hasInnerPoints:!1,fillColor:"none",highlightFillColor:"none",strokeColor:r.palette.blue,highlightStrokeColor:"#c3d9ff",center:{visible:!1,withLabel:!1,fixed:!1,fillColor:r.palette.red,strokeColor:r.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",name:""},point2:{visible:!1,withLabel:!1,fixed:!1,name:""},label:{position:"urt"}},circumcircle:{fillColor:"none",highlightFillColor:"none",strokeColor:r.palette.blue,highlightStrokeColor:"#c3d9ff",center:{visible:!1,fixed:!1,withLabel:!1,fillColor:r.palette.red,strokeColor:r.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",name:""}},circumcirclearc:{fillColor:"none",highlightFillColor:"none",strokeColor:r.palette.blue,highlightStrokeColor:"#c3d9ff",center:{visible:!1,withLabel:!1,fixed:!1,name:""}},circumcirclesector:{useDirection:!0,fillColor:r.palette.yellow,highlightFillColor:r.palette.yellow,fillOpacity:.3,highlightFillOpacity:.3,strokeColor:r.palette.blue,highlightStrokeColor:"#c3d9ff",point:{visible:!1,fixed:!1,withLabel:!1,name:""}},conic:{fillColor:"none",highlightFillColor:"none",strokeColor:r.palette.blue,highlightStrokeColor:"#c3d9ff",foci:{fixed:!1,visible:!1,withLabel:!1,name:""},center:{visible:!1,withLabel:!1,name:""},point:{withLabel:!1,name:""},line:{visible:!1}},curve:{strokeWidth:1,strokeColor:r.palette.blue,fillColor:"none",fixed:!0,useQDT:!1,handDrawing:!1,curveType:null,RDPsmoothing:!1,numberPointsHigh:1600,numberPointsLow:400,doAdvancedPlot:!0,recursionDepthHigh:17,recursionDepthLow:15,doAdvancedPlotOld:!1,plotVersion:2,label:{position:"lft"},firstArrow:!1,lastArrow:!1},foreignobject:{attractors:[],fixed:!0,visible:!0},glider:{label:{}},grid:{needsRegularUpdate:!1,hasGrid:!1,gridX:1,gridY:1,strokeColor:"#c0c0c0",strokeOpacity:.5,strokeWidth:1,dash:0,snapToGrid:!1,snapSizeX:10,snapSizeY:10},group:{needsRegularUpdate:!0},htmlslider:{widthRange:100,widthOut:34,step:.01,frozen:!0,isLabel:!1,strokeColor:"#000000",display:"html",anchorX:"left",anchorY:"middle",withLabel:!1},image:{imageString:null,fillOpacity:1,highlightFillOpacity:.6,cssClass:"JXGimage",highlightCssClass:"JXGimageHighlight",rotate:0,snapSizeX:1,snapSizeY:1,attractors:[]},incircle:{fillColor:"none",highlightFillColor:"none",strokeColor:r.palette.blue,highlightStrokeColor:"#c3d9ff",center:{visible:!1,fixed:!1,withLabel:!1,fillColor:r.palette.red,strokeColor:r.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",name:""}},inequality:{fillColor:r.palette.red,fillOpacity:.2,strokeColor:"none",inverse:!1},infobox:{fontSize:12,isLabel:!1,strokeColor:"#bbbbbb",display:"html",anchorX:"left",anchorY:"middle",cssClass:"JXGinfobox",rotate:0,visible:!0,parse:!1,transitionDuration:0,needsRegularUpdate:!1},integral:{axis:"x",withLabel:!0,fixed:!0,strokeWidth:0,strokeOpacity:0,fillColor:r.palette.red,fillOpacity:.3,highlightFillColor:r.palette.red,highlightFillOpacity:.2,curveLeft:{visible:!0,withLabel:!1,color:r.palette.red,fillOpacity:.8,layer:9},baseLeft:{visible:!1,fixed:!1,withLabel:!1,name:""},curveRight:{visible:!0,withLabel:!1,color:r.palette.red,fillOpacity:.8,layer:9},baseRight:{visible:!1,fixed:!1,withLabel:!1,name:""},label:{fontSize:20}},input:{disabled:!1,maxlength:524288,display:"html"},intersection:{alwaysIntersect:!0},label:{visible:"inherit",strokeColor:"#000000",strokeOpacity:1,highlightStrokeOpacity:.666666,highlightStrokeColor:"#000000",fixed:!0,position:"urt",offset:[10,10],autoPosition:!1},legend:{style:"vertical",labels:["1","2","3","4","5","6","7","8"],colors:["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#c3d9ff","#4096EE","#008C00"],rowHeight:20,strokeWidth:5},line:{firstArrow:!1,lastArrow:!1,margin:0,straightFirst:!0,straightLast:!0,fillColor:"none",highlightFillColor:"none",strokeColor:r.palette.blue,highlightStrokeColor:"#c3d9ff",withTicks:!1,point1:{visible:!1,withLabel:!1,fixed:!1,name:""},point2:{visible:!1,withLabel:!1,fixed:!1,name:""},ticks:{drawLabels:!0,label:{offset:[4,-9]},drawZero:!1,insertTicks:!1,minTicksDistance:50,minorHeight:4,majorHeight:-1,minorTicks:4,defaultDistance:1,strokeOpacity:.3,visible:"inherit"},label:{position:"llft"},snapToGrid:!1,snapSizeX:1,snapSizeY:1,touchFirstPoint:!1,touchLastPoint:!1,lineCap:"butt"},locus:{translateToOrigin:!1,translateTo10:!1,stretch:!1,toOrigin:null,to10:null},metapostspline:{createPoints:!0,isArrayOfCoordinates:!1,points:{strokeOpacity:.05,fillOpacity:.05,highlightStrokeOpacity:1,highlightFillOpacity:1,withLabel:!1,name:"",fixed:!1}},mirrorelement:{fixed:!0,point:{},center:{},type:"Euclidean"},normal:{strokeColor:"#000000",point:{visible:!1,fixed:!1,withLabel:!1,name:""}},orthogonalprojection:{},parallel:{strokeColor:"#000000",point:{visible:!1,fixed:!1,withLabel:!1,name:""},label:{position:"llft"}},perpendicular:{strokeColor:"#000000",straightFirst:!0,straightLast:!0},perpendicularsegment:{strokeColor:"#000000",straightFirst:!1,straightLast:!1,point:{visible:!1,fixed:!0,withLabel:!1,name:""}},point:{withLabel:!0,label:{},style:5,face:"o",size:3,sizeUnit:"screen",strokeWidth:2,fillColor:r.palette.red,strokeColor:r.palette.red,highlightFillColor:"#c3d9ff",highlightStrokeColor:"#c3d9ff",zoom:!1,showInfobox:"inherit",infoboxDigits:"auto",draft:!1,attractors:[],attractorUnit:"user",attractorDistance:0,snatchDistance:0,snapToGrid:!1,attractToGrid:!1,snapSizeX:1,snapSizeY:1,snapToPoints:!1,ignoredSnapToPoints:[]},polygon:{hasInnerPoints:!1,fillColor:r.palette.yellow,highlightFillColor:r.palette.yellow,fillOpacity:.3,highlightFillOpacity:.2,withLines:!0,borders:{withLabel:!1,strokeWidth:1,highlightStrokeWidth:1,layer:5,label:{position:"top"},visible:"inherit"},vertices:{layer:9,withLabel:!1,name:"",strokeColor:r.palette.red,fillColor:r.palette.red,fixed:!1,visible:"inherit"},label:{offset:[0,0]}},polygonalchain:{fillColor:"none",highlightFillColor:"none"},prescribedangle:{anglePoint:{size:2,visible:!1,withLabel:!1}},reflection:{fixed:!0,center:{},type:"Euclidean"},regularpolygon:{hasInnerPoints:!1,fillColor:r.palette.yellow,highlightFillColor:r.palette.yellow,fillOpacity:.3,highlightFillOpacity:.2,withLines:!0,borders:{withLabel:!1,strokeWidth:1,highlightStrokeWidth:1,layer:5,label:{position:"top"}},vertices:{layer:9,withLabel:!0,strokeColor:r.palette.red,fillColor:r.palette.red,fixed:!1},label:{offset:[0,0]}},riemannsum:{withLabel:!1,fillOpacity:.3,fillColor:r.palette.yellow},sector:{fillColor:r.palette.yellow,highlightFillColor:r.palette.yellow,fillOpacity:.3,highlightFillOpacity:.3,highlightOnSector:!1,highlightStrokeWidth:0,selection:"auto",arc:{visible:!1,fillColor:"none"},radiusPoint:{visible:!1,withLabel:!1},center:{visible:!1,withLabel:!1},anglePoint:{visible:!1,withLabel:!1},label:{offset:[0,0],anchorX:"auto",anchorY:"auto"}},segment:{label:{position:"top"}},semicircle:{center:{visible:!1,withLabel:!1,fixed:!1,fillColor:r.palette.red,strokeColor:r.palette.red,highlightFillColor:"#eeeeee",highlightStrokeColor:r.palette.red,name:""}},slider:{snapWidth:-1,precision:2,digits:2,firstArrow:!1,lastArrow:!1,withTicks:!0,withLabel:!0,suffixLabel:null,unitLabel:null,postLabel:null,layer:9,showInfobox:!1,name:"",visible:!0,strokeColor:"#000000",highlightStrokeColor:"#888888",fillColor:"#ffffff",highlightFillColor:"none",size:6,point1:{needsRegularUpdate:!1,showInfobox:!1,withLabel:!1,visible:!1,fixed:!0,name:""},point2:{needsRegularUpdate:!1,showInfobox:!1,withLabel:!1,visible:!1,fixed:!0,name:""},baseline:{needsRegularUpdate:!1,visible:"inherit",fixed:!0,scalable:!1,name:"",strokeWidth:1,strokeColor:"#000000",highlightStrokeColor:"#888888"},ticks:{needsRegularUpdate:!1,fixed:!0,drawLabels:!1,digits:2,includeBoundaries:1,drawZero:!0,label:{offset:[-4,-14],display:"internal"},minTicksDistance:30,insertTicks:!0,minorHeight:4,majorHeight:5,minorTicks:0,defaultDistance:1,strokeOpacity:1,strokeWidth:1,tickEndings:[0,1],strokeColor:"#000000",visible:"inherit"},highline:{strokeWidth:3,visible:"inherit",fixed:!0,name:"",strokeColor:"#000000",highlightStrokeColor:"#888888"},label:{visible:"inherit",strokeColor:"#000000"},moveOnUp:!0},comb:{frequency:.2,width:.4,angle:Math.PI/3,reverse:!1,point1:{visible:!1,withLabel:!1,fixed:!1,name:""},point2:{visible:!1,withLabel:!1,fixed:!1,name:""},curve:{strokeWidth:1,strokeColor:"#000000",fillColor:"none"}},slopetriangle:{fillColor:r.palette.red,fillOpacity:.4,highlightFillColor:r.palette.red,highlightFillOpacity:.3,borders:{lastArrow:{type:1,size:6}},glider:{fixed:!0,visible:!1,withLabel:!1},baseline:{visible:!1,withLabel:!1,name:""},basepoint:{visible:!1,withLabel:!1,name:""},tangent:{visible:!1,withLabel:!1,name:""},toppoint:{visible:!1,withLabel:!1,name:""},label:{visible:!0}},stepfunction:{},tapemeasure:{strokeColor:"#000000",strokeWidth:2,highlightStrokeColor:"#000000",withTicks:!0,withLabel:!0,precision:2,digits:2,point1:{visible:"inherit",strokeColor:"#000000",fillColor:"#ffffff",fillOpacity:0,highlightFillOpacity:.1,size:6,snapToPoints:!0,attractorUnit:"screen",attractorDistance:20,showInfobox:!1,withLabel:!1,name:""},point2:{visible:"inherit",strokeColor:"#000000",fillColor:"#ffffff",fillOpacity:0,highlightFillOpacity:.1,size:6,snapToPoints:!0,attractorUnit:"screen",attractorDistance:20,showInfobox:!1,withLabel:!1,name:""},ticks:{drawLabels:!1,drawZero:!0,insertTicks:!0,minorHeight:8,majorHeight:16,minorTicks:4,tickEndings:[0,1],defaultDistance:.1,strokeOpacity:1,strokeWidth:1,strokeColor:"#000000",visible:"inherit"},label:{position:"top"}},text:{fontSize:12,fontUnit:"px",digits:2,parse:!0,useCaja:!1,isLabel:!1,strokeColor:"#000000",highlightStrokeColor:"#000000",highlightStrokeOpacity:.666666,cssDefaultStyle:"font-family: Arial, Helvetica, Geneva, sans-serif;",highlightCssDefaultStyle:"font-family: Arial, Helvetica, Geneva, sans-serif;",cssStyle:"",highlightCssStyle:"",useASCIIMathML:!1,useMathJax:!1,useKatex:!1,display:"html",anchor:null,anchorX:"left",anchorY:"middle",cssClass:"JXGtext",highlightCssClass:"JXGtext",dragArea:"all",withLabel:!1,rotate:0,visible:!0,snapSizeX:1,snapSizeY:1,attractors:[]},tracecurve:{strokeColor:"#000000",fillColor:"none",numberPoints:100},turtle:{strokeWidth:1,fillColor:"none",strokeColor:"#000000",arrow:{strokeWidth:2,withLabel:!1,strokeColor:r.palette.red,lastArrow:!0}},shortcuts:{color:["strokeColor","fillColor"],opacity:["strokeOpacity","fillOpacity"],highlightColor:["highlightStrokeColor","highlightFillColor"],highlightOpacity:["highlightStrokeOpacity","highlightFillOpacity"],strokeWidth:["strokeWidth","highlightStrokeWidth"]}},t.Validator=function(){var e,r=function(t){return s.isString(t)},o=function(t){return Math.abs(t-Math.round(t))<i.eps},n=function(t){return o(t)&&t>0},a=function(t){return t>0},h=function(t){return t>=0},l={},c={attractorDistance:h,color:r,defaultDistance:s.isNumber,display:function(t){return"html"===t||"internal"===t},doAdvancedPlot:!1,draft:!1,drawLabels:!1,drawZero:!1,face:function(e){return s.exists(t.normalizePointFace(e))},factor:s.isNumber,fillColor:r,fillOpacity:s.isNumber,firstArrow:!1,fontSize:o,dash:o,gridX:s.isNumber,gridY:s.isNumber,hasGrid:!1,highlightFillColor:r,highlightFillOpacity:s.isNumber,highlightStrokeColor:r,highlightStrokeOpacity:s.isNumber,insertTicks:!1,lastArrow:!1,layer:function(t){return o(t)&&t>=0},majorHeight:o,minorHeight:o,minorTicks:h,minTicksDistance:n,numberPointsHigh:n,numberPointsLow:n,opacity:s.isNumber,radius:s.isNumber,RDPsmoothing:!1,renderer:function(t){return"vml"===t||"svg"===t||"canvas"===t||"no"===t},right:function(t){return/^[0-9]+px$/.test(t)},showCopyright:!1,showInfobox:!1,showNavigation:!1,size:h,snapSizeX:a,snapSizeY:a,snapWidth:s.isNumber,snapToGrid:!1,snatchDistance:h,straightFirst:!1,straightLast:!1,stretch:!1,strokeColor:r,strokeOpacity:s.isNumber,strokeWidth:h,takeFirst:!1,takeSizeFromFile:!1,to10:!1,toOrigin:!1,translateTo10:!1,translateToOrigin:!1,useASCIIMathML:!1,useDirection:!1,useMathJax:!1,withLabel:!1,withTicks:!1,zoom:!1};for(e in c)c.hasOwnProperty(e)&&(l[e.toLowerCase()]=c[e]);return l}(),t.normalizePointFace=function(t){return{cross:"x",x:"x",circle:"o",o:"o",square:"[]","[]":"[]",plus:"+","+":"+",diamond:"<>","<>":"<>",triangleup:"^",a:"^","^":"^",triangledown:"v",v:"v",triangleleft:"<","<":"<",triangleright:">",">":">"}[t]},t.useStandardOptions=function(i){var r,s,o,n,a=t.Options,h=i.hasGrid;for(r in i.options.grid.hasGrid=a.grid.hasGrid,i.options.grid.gridX=a.grid.gridX,i.options.grid.gridY=a.grid.gridY,i.options.grid.gridColor=a.grid.gridColor,i.options.grid.gridOpacity=a.grid.gridOpacity,i.options.grid.gridDash=a.grid.gridDash,i.options.grid.snapToGrid=a.grid.snapToGrid,i.options.grid.snapSizeX=a.grid.SnapSizeX,i.options.grid.snapSizeY=a.grid.SnapSizeY,i.takeSizeFromFile=a.takeSizeFromFile,n=function(t,e){t.visProp.fillcolor=e.fillColor,t.visProp.highlightfillcolor=e.highlightFillColor,t.visProp.strokecolor=e.strokeColor,t.visProp.highlightstrokecolor=e.highlightStrokeColor},i.objects)if(i.objects.hasOwnProperty(r))if((o=i.objects[r]).elementClass===e.OBJECT_CLASS_POINT)n(o,a.point);else if(o.elementClass===e.OBJECT_CLASS_LINE)for(n(o,a.line),s=0;s<o.ticks.length;s++)o.ticks[s].majorTicks=a.line.ticks.majorTicks,o.ticks[s].minTicksDistance=a.line.ticks.minTicksDistance,o.ticks[s].visProp.minorheight=a.line.ticks.minorHeight,o.ticks[s].visProp.majorheight=a.line.ticks.majorHeight;else o.elementClass===e.OBJECT_CLASS_CIRCLE?n(o,a.circle):o.type===e.OBJECT_TYPE_ANGLE?n(o,a.angle):o.type===e.OBJECT_TYPE_ARC?n(o,a.arc):o.type===e.OBJECT_TYPE_POLYGON?n(o,a.polygon):o.type===e.OBJECT_TYPE_CONIC?n(o,a.conic):o.type===e.OBJECT_TYPE_CURVE?n(o,a.curve):o.type===e.OBJECT_TYPE_SECTOR&&(o.arc.visProp.fillcolor=a.sector.fillColor,o.arc.visProp.highlightfillcolor=a.sector.highlightFillColor,o.arc.visProp.fillopacity=a.sector.fillOpacity,o.arc.visProp.highlightfillopacity=a.sector.highlightFillOpacity);i.fullUpdate(),h&&!i.hasGrid?i.removeGrids(i):!h&&i.hasGrid&&i.create("grid",[])},t.useBlackWhiteOptions=function(e){var i=t.Options;i.point.fillColor=r.rgb2bw(i.point.fillColor),i.point.highlightFillColor=r.rgb2bw(i.point.highlightFillColor),i.point.strokeColor=r.rgb2bw(i.point.strokeColor),i.point.highlightStrokeColor=r.rgb2bw(i.point.highlightStrokeColor),i.line.fillColor=r.rgb2bw(i.line.fillColor),i.line.highlightFillColor=r.rgb2bw(i.line.highlightFillColor),i.line.strokeColor=r.rgb2bw(i.line.strokeColor),i.line.highlightStrokeColor=r.rgb2bw(i.line.highlightStrokeColor),i.circle.fillColor=r.rgb2bw(i.circle.fillColor),i.circle.highlightFillColor=r.rgb2bw(i.circle.highlightFillColor),i.circle.strokeColor=r.rgb2bw(i.circle.strokeColor),i.circle.highlightStrokeColor=r.rgb2bw(i.circle.highlightStrokeColor),i.arc.fillColor=r.rgb2bw(i.arc.fillColor),i.arc.highlightFillColor=r.rgb2bw(i.arc.highlightFillColor),i.arc.strokeColor=r.rgb2bw(i.arc.strokeColor),i.arc.highlightStrokeColor=r.rgb2bw(i.arc.highlightStrokeColor),i.polygon.fillColor=r.rgb2bw(i.polygon.fillColor),i.polygon.highlightFillColor=r.rgb2bw(i.polygon.highlightFillColor),i.sector.fillColor=r.rgb2bw(i.sector.fillColor),i.sector.highlightFillColor=r.rgb2bw(i.sector.highlightFillColor),i.curve.strokeColor=r.rgb2bw(i.curve.strokeColor),i.grid.gridColor=r.rgb2bw(i.grid.gridColor),t.useStandardOptions(e)},t.Options.normalizePointFace=t.normalizePointFace,t.Options})),define("renderer/abstract",["jxg","options","base/coords","base/constants","math/math","math/geometry","utils/type","utils/env"],(function(t,e,i,r,s,o,n,a){"use strict";return t.AbstractRenderer=function(){this.vOffsetText=0,this.enhancedRendering=!0,this.container=null,this.type="",this.supportsForeignObject=!1},t.extend(t.AbstractRenderer.prototype,{_updateVisual:function(t,e,i){(i||this.enhancedRendering)&&(e=e||{},this.setObjectTransition(t),n.evaluate(t.visProp.draft)?this.setDraft(t):(e.stroke||(t.highlighted?(this.setObjectStrokeColor(t,t.visProp.highlightstrokecolor,t.visProp.highlightstrokeopacity),this.setObjectStrokeWidth(t,t.visProp.highlightstrokewidth)):(this.setObjectStrokeColor(t,t.visProp.strokecolor,t.visProp.strokeopacity),this.setObjectStrokeWidth(t,t.visProp.strokewidth))),e.fill||(t.highlighted?this.setObjectFillColor(t,t.visProp.highlightfillcolor,t.visProp.highlightfillopacity):this.setObjectFillColor(t,t.visProp.fillcolor,t.visProp.fillopacity)),e.dash||this.setDashStyle(t,t.visProp),e.shadow||this.setShadow(t),e.gradient||this.setShadow(t),e.tabindex||this.setTabindex(t)))},_getHighlighted:function(t){var e=!1;return n.exists(t.board)&&n.exists(t.board.highlightedObjects)||(e=!0),!e&&n.exists(t.board.highlightedObjects[t.id])?"highlight":""},drawPoint:function(t){var i,r=e.normalizePointFace(n.evaluate(t.visProp.face));i="o"===r?"ellipse":"[]"===r?"rect":"path",t.rendNode=this.appendChildPrim(this.createPrim(i,t.id),n.evaluate(t.visProp.layer)),this.appendNodesToElement(t,i),this._updateVisual(t,{dash:!0,shadow:!0},!0),this.updatePoint(t)},updatePoint:function(t){var i,r=n.evaluate(t.visProp.size),s=e.normalizePointFace(n.evaluate(t.visProp.face)),o=n.evaluate(t.visProp.sizeunit),a=n.evaluate(t.visProp.zoom);isNaN(t.coords.scrCoords[2]+t.coords.scrCoords[1])||("user"===o&&(r*=Math.sqrt(t.board.unitX*t.board.unitY)),i=0===(r*=t.board&&a?Math.sqrt(t.board.zoomX*t.board.zoomY):1)?0:r+1,"o"===s?this.updateEllipsePrim(t.rendNode,t.coords.scrCoords[1],t.coords.scrCoords[2],i,i):"[]"===s?this.updateRectPrim(t.rendNode,t.coords.scrCoords[1]-r,t.coords.scrCoords[2]-r,2*r,2*r):this.updatePathPrim(t.rendNode,this.updatePathStringPoint(t,r,s),t.board),this._updateVisual(t,{dash:!1,shadow:!1}),this.setShadow(t))},changePointStyle:function(t){var e=this.getElementById(t.id);n.exists(e)&&this.remove(e),this.drawPoint(t),n.clearVisPropOld(t),t.visPropCalc.visible||this.display(t,!1),n.evaluate(t.visProp.draft)&&this.setDraft(t)},drawLine:function(t){t.rendNode=this.appendChildPrim(this.createPrim("line",t.id),n.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"lines"),this.updateLine(t)},updateLine:function(t){this._updateVisual(t),this.updatePathWithArrowHeads(t),this.setLineCap(t)},drawCurve:function(t){t.rendNode=this.appendChildPrim(this.createPrim("path",t.id),n.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"path"),this.updateCurve(t)},updateCurve:function(t){this._updateVisual(t),this.updatePathWithArrowHeads(t),this.setLineCap(t)},updatePathWithArrowHeads:function(t,e){var i,s,o=t.visProp,a=e?"highlight":"";i=e&&o.highlightstrokewidth?Math.max(n.evaluate(o.highlightstrokewidth),n.evaluate(o.strokewidth)):n.evaluate(o.strokewidth),s=this.getArrowHeadData(t,i,a),this.makeArrows(t,s),t.elementClass===r.OBJECT_CLASS_LINE?this.updateLineWithEndings(t,s):t.elementClass===r.OBJECT_CLASS_CURVE&&this.updatePath(t),this.setArrowSize(t,s)},getArrowHeadData:function(t,e,i){var o,a,h,l,c=s.eps,d=0,u=0,p=0,f=0,m=n.evaluate(t.visProp.firstarrow),g=n.evaluate(t.visProp.lastarrow);return(m||g)&&(o=n.exists(m.type)?n.evaluate(m.type):t.elementClass===r.OBJECT_CLASS_LINE?1:7,a=n.exists(g.type)?n.evaluate(g.type):t.elementClass===r.OBJECT_CLASS_LINE?1:7,m&&(l=6,n.exists(m.size)&&(l=n.evaluate(m.size)),""!==i&&n.exists(m[i+"size"])&&(l=n.evaluate(m[i+"size"])),h=e*l,2===o?(h*=.5,c+=e*l):3===o?(h=e*l/3,c+=e):4===o||5===o||6===o?(h=e*l/1.5,c+=e*l):7===o?(h=0,l=10,c+=e):c+=e*l,d+=h,p=l),g&&(l=6,n.exists(g.size)&&(l=n.evaluate(g.size)),""!==i&&n.exists(g[i+"size"])&&(l=n.evaluate(g[i+"size"])),h=e*l,2===a?(h*=.5,c+=e*l):3===a?(h=e*l/3,c+=e):4===a||5===a||6===a?(h=e*l/1.5,c+=e*l):7===a?(h=0,l=10,c+=e):c+=e*l,u+=h,f=l)),t.visPropCalc.typeFirst=o,t.visPropCalc.typeLast=a,{evFirst:m,evLast:g,typeFirst:o,typeLast:a,offFirst:d,offLast:u,sizeFirst:p,sizeLast:f,showFirst:1,showLast:1,minLen:c,strokeWidth:e}},updateLineWithEndings:function(t,e){var s,a,h;return s=new i(r.COORDS_BY_USER,t.point1.coords.usrCoords,t.board),a=new i(r.COORDS_BY_USER,t.point2.coords.usrCoords,t.board),h=n.evaluate(t.visProp.margin),o.calcStraight(t,s,a,h),this.handleTouchpoints(t,s,a,e),this.getPositionArrowHead(t,s,a,e),this.updateLinePrim(t.rendNode,s.scrCoords[1],s.scrCoords[2],a.scrCoords[1],a.scrCoords[2],t.board),this},updatePath:function(t){return n.evaluate(t.visProp.handdrawing)?this.updatePathPrim(t.rendNode,this.updatePathStringBezierPrim(t),t.board):this.updatePathPrim(t.rendNode,this.updatePathStringPrim(t),t.board),this},getPositionArrowHead:function(t,e,i,s){var o,n,a,h,l;return(s.evFirst||s.evLast)&&(n=a=h=l=0,o=e.distance(r.COORDS_BY_SCREEN,i),s.evFirst&&"vml"!==t.board.renderer.type&&(o>=s.minLen?(n=(i.scrCoords[1]-e.scrCoords[1])*s.offFirst/o,a=(i.scrCoords[2]-e.scrCoords[2])*s.offFirst/o):s.showFirst=0),s.evLast&&"vml"!==t.board.renderer.type&&(o>=s.minLen?(h=(i.scrCoords[1]-e.scrCoords[1])*s.offLast/o,l=(i.scrCoords[2]-e.scrCoords[2])*s.offLast/o):s.showLast=0),e.setCoordinates(r.COORDS_BY_SCREEN,[e.scrCoords[1]+n,e.scrCoords[2]+a],!1,!0),i.setCoordinates(r.COORDS_BY_SCREEN,[i.scrCoords[1]-h,i.scrCoords[2]-l],!1,!0)),this},handleTouchpoints:function(t,e,i,s){var o,a,h,l,c,d,u;return(s.evFirst||s.evLast)&&(h=l=c=d=u=0,o=n.evaluate(t.point1.visProp.size)+n.evaluate(t.point1.visProp.strokewidth),a=n.evaluate(t.point2.visProp.size)+n.evaluate(t.point2.visProp.strokewidth),s.evFirst&&n.evaluate(t.visProp.touchfirstpoint)&&(h=e.distance(r.COORDS_BY_SCREEN,i),l=(i.scrCoords[1]-e.scrCoords[1])*o/h,c=(i.scrCoords[2]-e.scrCoords[2])*o/h),s.evLast&&n.evaluate(t.visProp.touchlastpoint)&&(h=e.distance(r.COORDS_BY_SCREEN,i),d=(i.scrCoords[1]-e.scrCoords[1])*a/h,u=(i.scrCoords[2]-e.scrCoords[2])*a/h),e.setCoordinates(r.COORDS_BY_SCREEN,[e.scrCoords[1]+l,e.scrCoords[2]+c],!1,!0),i.setCoordinates(r.COORDS_BY_SCREEN,[i.scrCoords[1]-d,i.scrCoords[2]-u],!1,!0)),this},setArrowSize:function(t,e){return e.evFirst&&this._setArrowWidth(t.rendNodeTriangleStart,e.showFirst*e.strokeWidth,t.rendNode,e.sizeFirst),e.evLast&&this._setArrowWidth(t.rendNodeTriangleEnd,e.showLast*e.strokeWidth,t.rendNode,e.sizeLast),this},setLineCap:function(t){},drawTicks:function(t){t.rendNode=this.appendChildPrim(this.createPrim("path",t.id),n.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"path")},updateTicks:function(t){},drawEllipse:function(t){t.rendNode=this.appendChildPrim(this.createPrim("ellipse",t.id),n.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"ellipse"),this.updateEllipse(t)},updateEllipse:function(t){this._updateVisual(t);var e=t.Radius();e>0&&Math.abs(t.center.coords.usrCoords[0])>s.eps&&!isNaN(e+t.center.coords.scrCoords[1]+t.center.coords.scrCoords[2])&&e*t.board.unitX<2e6&&this.updateEllipsePrim(t.rendNode,t.center.coords.scrCoords[1],t.center.coords.scrCoords[2],e*t.board.unitX,e*t.board.unitY)},drawPolygon:function(t){t.rendNode=this.appendChildPrim(this.createPrim("polygon",t.id),n.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"polygon"),this.updatePolygon(t)},updatePolygon:function(t){this._updateVisual(t,{stroke:!0,dash:!0}),this.updatePolygonPrim(t.rendNode,t)},displayCopyright:function(t,e){},drawInternalText:function(t){},updateInternalText:function(t){},drawText:function(t){var e,i,r,s;"html"===n.evaluate(t.visProp.display)&&a.isBrowser&&"no"!==this.type?((e=this.container.ownerDocument.createElement("div")).style.position="absolute",e.className=n.evaluate(t.visProp.cssclass),r=n.evaluate(t.visProp.layer),n.exists(r)||(r=0),i=""===this.container.style.zIndex?0:parseInt(this.container.style.zIndex,10),e.style.zIndex=i+r,this.container.appendChild(e),e.setAttribute("id",this.container.id+"_"+t.id)):e=this.drawInternalText(t),t.rendNode=e,t.htmlStr="",t.visProp.islabel&&n.exists(t.visProp.anchor)?(s=n.evaluate(t.visProp.anchor.visProp.visible),t.prepareUpdate().updateVisibility(s)):t.prepareUpdate().updateVisibility(),this.updateText(t)},updateText:function(e){var i,r,s,o,h,l,c,d,u,p=e.plaintext;if(e.visPropCalc.visible)if(this.updateTextStyle(e,!1),"html"===n.evaluate(e.visProp.display)&&"no"!==this.type){if(isNaN(e.coords.scrCoords[1]+e.coords.scrCoords[2])||(r=e.coords.scrCoords[1],r=Math.abs(r)<1e6?r:1e6,i="right"===(d=e.getAnchorX())?e.board.canvasWidth-r:"middle"===d?r-.5*e.size[0]:r,e.visPropOld.left!==d+i&&("right"===d?(e.rendNode.style.right=i+"px",e.rendNode.style.left="auto"):(e.rendNode.style.left=i+"px",e.rendNode.style.right="auto"),e.visPropOld.left=d+i),r=e.coords.scrCoords[2]+this.vOffsetText,r=Math.abs(r)<1e6?r:1e6,i="bottom"===(u=e.getAnchorY())?e.board.canvasHeight-r:"middle"===u?r-.5*e.size[1]:r,e.visPropOld.top!==u+i&&("bottom"===u?(e.rendNode.style.top="auto",e.rendNode.style.bottom=i+"px"):(e.rendNode.style.bottom="auto",e.rendNode.style.top=i+"px"),e.visPropOld.top=u+i)),e.htmlStr!==p){try{e.type===n.OBJECT_TYPE_BUTTON?e.rendNodeButton.innerHTML=p:e.type===n.OBJECT_TYPE_CHECKBOX||e.type===n.OBJECT_TYPE_INPUT?e.rendNodeLabel.innerHTML=p:e.rendNode.innerHTML=p}catch(t){s=e.rendNode.parentNode,e.rendNode.parentNode.removeChild(e.rendNode),e.rendNode.innerHTML=p,s.appendChild(e.rendNode)}if(e.htmlStr=p,n.evaluate(e.visProp.usemathjax))try{MathJax.typeset?MathJax.typeset([e.rendNode]):MathJax.Hub.Queue(["Typeset",MathJax.Hub,e.rendNode]),c="fullscreenwrap_"+(l=e.board.container),document.getElementById(c)&&(o=e.board.containerObj._cssFullscreenStore.scale,h=e.board.containerObj._cssFullscreenStore.vshift,a.scaleJSXGraphDiv("#"+c,"#"+l,o,h))}catch(e){t.debug("MathJax (not yet) loaded")}else if(n.evaluate(e.visProp.usekatex))try{katex.render(p,e.rendNode,{throwOnError:!1})}catch(e){t.debug("KaTeX (not yet) loaded")}else if(n.evaluate(e.visProp.useasciimathml))try{AMprocessNode(e.rendNode,!1)}catch(e){t.debug("AsciiMathML (not yet) loaded")}}this.transformImage(e,e.transformations)}else this.updateInternalText(e)},_css2js:function(t){var e,i,r,s,o,a=[],h=n.trim(t).replace(/;$/,"").split(";");for(i=h.length,e=0;e<i;++e)""!==n.trim(h[e])&&(o=h[e].split(":"),r=n.trim(o[0].replace(/-([a-z])/gi,(function(t,e){return e.toUpperCase()}))),s=n.trim(o[1]),a.push({key:r,val:s}));return a},updateTextStyle:function(t,e){var i,r,s,o,h,l,c,d,u,p=t.visProp,f=a.isBrowser?p.display:"internal",m=["rendNode","rendNodeTag","rendNodeLabel"],g=m.length,b=n.evaluate(p.fontunit),v=["cssdefaultstyle","cssstyle"],y=v.length;if(e?(s=p.highlightstrokecolor,r=p.highlightstrokeopacity,o=p.highlightcssclass):(s=p.strokecolor,r=p.strokeopacity,o=p.cssclass),"no"!==this.type&&("html"===f||"canvas"!==this.type)){for(d=0;d<y;d++)if(""!==(u=n.evaluate(p[(e?"highlight":"")+v[d]]))&&t.visPropOld[v[d]]!==u){for(l=this._css2js(u),h=0;h<g;h++)if(n.exists(t[m[h]]))for(c in l)l.hasOwnProperty(c)&&(t[m[h]].style[l[c].key]=l[c].val);t.visPropOld[v[d]]=u}if(i=n.evaluate(p.fontsize),t.visPropOld.fontsize!==i){t.needsSizeUpdate=!0;try{for(h=0;h<g;h++)n.exists(t[m[h]])&&(t[m[h]].style.fontSize=i+b)}catch(e){for(h=0;h<g;h++)n.exists(t[m[h]])&&(t[m[h]].style.fontSize=i)}t.visPropOld.fontsize=i}}return this.setObjectTransition(t),"html"===f&&"no"!==this.type?(t.visPropOld.cssclass!==o&&(t.rendNode.className=o,t.visPropOld.cssclass=o,t.needsSizeUpdate=!0),this.setObjectStrokeColor(t,s,r)):this.updateInternalTextStyle(t,s,r),this},updateInternalTextStyle:function(t,e,i){this.setObjectStrokeColor(t,e,i)},drawImage:function(t){},updateImage:function(t){this.updateRectPrim(t.rendNode,t.coords.scrCoords[1],t.coords.scrCoords[2]-t.size[1],t.size[0],t.size[1]),this.updateImageURL(t),this.transformImage(t,t.transformations),this._updateVisual(t,{stroke:!0,dash:!0},!0)},joinTransforms:function(t,e){var i,r=t.board.origin.scrCoords[1],o=t.board.origin.scrCoords[2],n=t.board.unitX,a=t.board.unitY,h=e.length,l=[[1,0,0],[-r/n,1/n,0],[o/a,0,-1/a]];for(i=0;i<h;i++)l=s.matMatMult(e[i].matrix,l);return l=s.matMatMult([[1,0,0],[r,n,0],[o,0,-a]],l)},transformImage:function(t,e){},updateImageURL:function(t){},updateImageStyle:function(t,e){t.rendNode.className=n.evaluate(e?t.visProp.highlightcssclass:t.visProp.cssclass)},drawForeignObject:function(t){},updateForeignObject:function(t){},appendChildPrim:function(t,e){},appendNodesToElement:function(t,e){},createPrim:function(t,e){return null},remove:function(t){},makeArrows:function(t,e){},_setArrowWidth:function(t,e,i){},updateEllipsePrim:function(t,e,i,r,s){},updateLinePrim:function(t,e,i,r,s,o){},updatePathPrim:function(t,e,i){},updatePathStringPoint:function(t,e,i){},updatePathStringPrim:function(t){},updatePathStringBezierPrim:function(t){},updatePolygonPrim:function(t,e){},updateRectPrim:function(t,e,i,r,s){},setPropertyPrim:function(t,e,i){},setTabindex:function(t){var e;n.exists(t.rendNode)&&(e=n.evaluate(t.visProp.tabindex))!==t.visPropOld.tabindex&&(t.rendNode.setAttribute("tabindex",e),t.visPropOld.tabindex=e)},display:function(t,e){t&&(t.visPropOld.visible=e)},show:function(t){},hide:function(t){},setBuffering:function(t,e){},setDashStyle:function(t){},setDraft:function(t){if(n.evaluate(t.visProp.draft)){var e=t.board.options.elements.draft.color,i=t.board.options.elements.draft.opacity;this.setObjectTransition(t),t.type===r.OBJECT_TYPE_POLYGON?this.setObjectFillColor(t,e,i):(t.elementClass===r.OBJECT_CLASS_POINT?this.setObjectFillColor(t,e,i):this.setObjectFillColor(t,"none",0),this.setObjectStrokeColor(t,e,i),this.setObjectStrokeWidth(t,t.board.options.elements.draft.strokeWidth))}},removeDraft:function(t){this.setObjectTransition(t),t.type===r.OBJECT_TYPE_POLYGON?this.setObjectFillColor(t,t.visProp.fillcolor,t.visProp.fillopacity):(t.type===r.OBJECT_CLASS_POINT&&this.setObjectFillColor(t,t.visProp.fillcolor,t.visProp.fillopacity),this.setObjectStrokeColor(t,t.visProp.strokecolor,t.visProp.strokeopacity),this.setObjectStrokeWidth(t,t.visProp.strokewidth))},setGradient:function(t){},updateGradient:function(t){},setObjectTransition:function(t,e){},setObjectFillColor:function(t,e,i){},setObjectStrokeColor:function(t,e,i){},setObjectStrokeWidth:function(t,e){},setShadow:function(t){},highlight:function(t){var e,i,s=t.visProp;if(this.setObjectTransition(t),!s.draft){if(t.type===r.OBJECT_TYPE_POLYGON)for(this.setObjectFillColor(t,s.highlightfillcolor,s.highlightfillopacity),e=0;e<t.borders.length;e++)this.setObjectStrokeColor(t.borders[e],t.borders[e].visProp.highlightstrokecolor,t.borders[e].visProp.highlightstrokeopacity);else t.elementClass===r.OBJECT_CLASS_TEXT?this.updateTextStyle(t,!0):t.type===r.OBJECT_TYPE_IMAGE?(this.updateImageStyle(t,!0),this.setObjectFillColor(t,s.highlightfillcolor,s.highlightfillopacity)):(this.setObjectStrokeColor(t,s.highlightstrokecolor,s.highlightstrokeopacity),this.setObjectFillColor(t,s.highlightfillcolor,s.highlightfillopacity));s.highlightstrokewidth&&(i=Math.max(n.evaluate(s.highlightstrokewidth),n.evaluate(s.strokewidth)),this.setObjectStrokeWidth(t,i),t.elementClass!==r.OBJECT_CLASS_LINE&&t.elementClass!==r.OBJECT_CLASS_CURVE||this.updatePathWithArrowHeads(t,!0))}return this},noHighlight:function(t){var e,i,s=t.visProp;if(this.setObjectTransition(t),!n.evaluate(t.visProp.draft)){if(t.type===r.OBJECT_TYPE_POLYGON)for(this.setObjectFillColor(t,s.fillcolor,s.fillopacity),e=0;e<t.borders.length;e++)this.setObjectStrokeColor(t.borders[e],t.borders[e].visProp.strokecolor,t.borders[e].visProp.strokeopacity);else t.elementClass===r.OBJECT_CLASS_TEXT?this.updateTextStyle(t,!1):t.type===r.OBJECT_TYPE_IMAGE?(this.updateImageStyle(t,!1),this.setObjectFillColor(t,s.fillcolor,s.fillopacity)):(this.setObjectStrokeColor(t,s.strokecolor,s.strokeopacity),this.setObjectFillColor(t,s.fillcolor,s.fillopacity));i=n.evaluate(s.strokewidth),this.setObjectStrokeWidth(t,i),t.elementClass!==r.OBJECT_CLASS_LINE&&t.elementClass!==r.OBJECT_CLASS_CURVE||this.updatePathWithArrowHeads(t,!1)}return this},suspendRedraw:function(){},unsuspendRedraw:function(){},drawZoomBar:function(t,e){var i,r,s=function(t){t||(t=window.event),t.stopPropagation?t.stopPropagation():t.cancelBubble=!0},o=function(e,o){var h;h=i.createElement("span"),r.appendChild(h),h.appendChild(i.createTextNode(e)),h.style.paddingLeft="7px",h.style.paddingRight="7px",void 0!==h.classList&&h.classList.add("JXG_navigation_button"),a.addEvent(h,"click",(function(e){return n.bind(o,t)(),!1}),t),a.addEvent(h,"mouseup",s,t),a.addEvent(h,"mousedown",s,t),a.addEvent(h,"touchend",s,t),a.addEvent(h,"touchstart",s,t)};a.isBrowser&&"no"!==this.type&&(i=t.containerObj.ownerDocument,(r=i.createElement("div")).setAttribute("id",t.containerObj.id+"_navigationbar"),r.style.color=e.strokecolor,r.style.backgroundColor=e.fillcolor,r.style.padding=e.padding,r.style.position=e.position,r.style.fontSize=e.fontsize,r.style.cursor=e.cursor,r.style.zIndex=e.zindex,t.containerObj.appendChild(r),r.style.right=e.right,r.style.bottom=e.bottom,void 0!==r.classList&&r.classList.add("JXG_navigation"),t.attr.showfullscreen&&o(t.attr.fullscreen.symbol,(function(){t.toFullscreen(t.attr.fullscreen.id)})),t.attr.showscreenshot&&o(t.attr.screenshot.symbol,(function(){window.setTimeout((function(){t.renderer.screenshot(t,"",!1)}),330)})),t.attr.showreload&&o("↻",(function(){t.reload()})),t.attr.showcleartraces&&o("⊗",(function(){t.clearTraces()})),t.attr.shownavigation&&(t.attr.showzoom&&(o("–",t.zoomOut),o("o",t.zoom100),o("+",t.zoomIn)),o("←",t.clickLeftArrow),o("↓",t.clickUpArrow),o("↑",t.clickDownArrow),o("→",t.clickRightArrow)))},getElementById:function(t){return n.exists(this.container)?this.container.ownerDocument.getElementById(this.container.id+"_"+t):""},removeToInsertLater:function(t){var e=t.parentNode,i=t.nextSibling;if(null!==e)return e.removeChild(t),function(){i?e.insertBefore(t,i):e.appendChild(t)}},resize:function(t,e){},createTouchpoints:function(t){},showTouchpoint:function(t){},hideTouchpoint:function(t){},updateTouchpoint:function(t,e){},dumpToDataURI:function(t){},dumpToCanvas:function(t,e,i,r){},screenshot:function(t){},setLayer:function(t,e){}}),t.AbstractRenderer})),define("reader/file",["jxg","utils/env","utils/type","utils/encoding","utils/base64"],(function(t,e,i,r,s){"use strict";return t.FileReader={handleRemoteFile:function(e,o,n,a,h,l){var c=!1;try{c=new XMLHttpRequest,"raw"===n.toLowerCase()?c.overrideMimeType("text/plain; charset="+h):c.overrideMimeType("text/xml; charset="+h)}catch(t){try{c=new ActiveXObject("Msxml2.XMLHTTP")}catch(t){try{c=new ActiveXObject("Microsoft.XMLHTTP")}catch(t){c=!1}}}if(c){c.open("GET",e,a),"raw"===n.toLowerCase()?this.cbp=function(){var t=c;4===t.readyState&&o(t.responseText)}:this.cbp=function(){var t=c,e="";4===t.readyState&&(e=!i.exists(t.responseStream)||"PK"!==t.responseText.slice(0,2)&&31!==r.asciiCharCodeAt(t.responseText.slice(0,1),0)?t.responseText:s.decode(jxgBinFileReader(t)),this.parseString(e,o,n,l))},this.cb=i.bind(this.cbp,this),c.onreadystatechange=this.cb;try{c.send(null)}catch(t){throw new Error("JSXGraph: A problem occurred while trying to read remote file '"+e+"'.")}}else t.debug("AJAX not activated!")},handleLocalFile:function(t,e,r,s,o,n){i.exists(s)||(s=!0),"raw"===r.toLowerCase()?this.cbp=function(t){e(t.target.result)}:this.cbp=function(t){var i=t.target.result;this.parseString(i,e,r,n)},this.cb=i.bind(this.cbp,this);var a=new FileReader;a.onload=this.cb,"raw"===r.toLowerCase()?a.readAsText(t):a.readAsText(t,o)},parseFileContent:function(t,e,r,s,o,n){i.isString(t)||void 0===FileReader?this.handleRemoteFile(t,e,r,s,o,n):this.handleLocalFile(t,e,r,s,o,n)},parseString:function(e,r,s,o){var n;if(s=s.toLowerCase(),n=t.readers[s],i.exists(n))new n(r,e).read();else if("jessiecode"!==s)throw new Error("JSXGraph: There is no reader available for '"+s+"'.");i.isFunction(o)&&o(r)}},!e.isMetroApp()&&e.isBrowser&&"object"==typeof navigator&&/msie/i.test(navigator.userAgent)&&!/opera/i.test(navigator.userAgent)&&document&&document.write&&document.write('<script type="text/vbscript">\nFunction Base64Encode(inData)\n  Const Base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"\n  Dim cOut, sOut, I\n  For I = 1 To LenB(inData) Step 3\n    Dim nGroup, pOut, sGroup\n    nGroup = &H10000 * AscB(MidB(inData, I, 1)) + _\n      &H100 * MyASC(MidB(inData, I + 1, 1)) + MyASC(MidB(inData, I + 2, 1))\n    nGroup = Oct(nGroup)\n    nGroup = String(8 - Len(nGroup), "0") & nGroup\n    pOut = Mid(Base64, CLng("&o" & Mid(nGroup, 1, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 3, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 5, 2)) + 1, 1) + _\n      Mid(Base64, CLng("&o" & Mid(nGroup, 7, 2)) + 1, 1)\n    sOut = sOut + pOut\n  Next\n  Select Case LenB(inData) Mod 3\n    Case 1: \'8 bit final\n      sOut = Left(sOut, Len(sOut) - 2) + "=="\n    Case 2: \'16 bit final\n      sOut = Left(sOut, Len(sOut) - 1) + "="\n  End Select\n  Base64Encode = sOut\nEnd Function\n\nFunction MyASC(OneChar)\n  If OneChar = "" Then MyASC = 0 Else MyASC = AscB(OneChar)\nEnd Function\n\nFunction jxgBinFileReader(xhr)\n    Dim byteString\n    Dim b64String\n    Dim i\n    byteString = xhr.responseBody\n    ReDim byteArray(LenB(byteString))\n    For i = 1 To LenB(byteString)\n        byteArray(i-1) = AscB(MidB(byteString, i, 1))\n    Next\n    b64String = Base64Encode(byteString)\n    jxgBinFileReader = b64String\nEnd Function\n<\/script>\n'),t.FileReader})),define("parser/geonext",["jxg","base/constants","utils/type"],(function(t,e,i){"use strict";return t.GeonextParser={replacePow:function(t){var e,i,r,s,o,n,a,h,l,c,d,u;for(c=(t=t.replace(/(\s*)\^(\s*)/g,"^")).indexOf("^"),s=-1;c>=0&&c<t.length-1;){if(s===c)throw new Error("JSXGraph: Error while parsing expression '"+t+"'");if(s=c,l=t.slice(0,c),d=t.slice(c+1),")"===l.charAt(l.length-1)){for(e=1,i=l.length-2;i>=0&&e>0;)")"===(r=l.charAt(i))?e++:"("===r&&(e-=1),i-=1;if(0!==e)throw new Error("JSXGraph: Missing '(' in expression");for(o="",a=l.substring(0,i+1),h=i;h>=0&&a.substr(h,1).match(/([\w.]+)/);)o=RegExp.$1+o,h-=1;o=(o+=l.substring(i+1,l.length)).replace(/([()+*%^\-/\][])/g,"\\$1")}else o="[\\w\\.]+";if(d.match(/^([\w.]*\()/)){for(e=1,i=RegExp.$1.length;i<d.length&&e>0;)")"===(r=d.charAt(i))?e-=1:"("===r&&(e+=1),i+=1;if(0!==e)throw new Error("JSXGraph: Missing ')' in expression");n=(n=d.substring(0,i)).replace(/([()+*%^\-/[\]])/g,"\\$1")}else n="[\\w\\.]+";u=new RegExp("("+o+")\\^("+n+")"),c=(t=t.replace(u,"pow($1,$2)")).indexOf("^")}return t},replaceIf:function(t){var e,i,r,s,o,n,a,h,l,c="",d=null,u=null,p=null;if((r=t.indexOf("If("))<0)return t;for(t=t.replace(/""/g,"0");r>=0;){for(e=t.slice(0,r),i=t.slice(r+3),o=1,s=0,n=-1,a=-1;s<i.length&&o>0;)")"===(h=i.charAt(s))?o-=1:"("===h?o+=1:","===h&&1===o&&(n<0?n=s:a=s),s+=1;if(l=i.slice(0,s-1),i=i.slice(s),n<0)return"";if(a<0)return"";d=l.slice(0,n),u=l.slice(n+1,a),p=l.slice(a+1),c+=e+"(("+(d=this.replaceIf(d))+")?("+(u=this.replaceIf(u))+"):("+(p=this.replaceIf(p))+"))",d=null,u=null,r=(t=i).indexOf("If(")}return c+=i},replaceNameById:function(t,e,i){var r,s,o,n,a=0,h=["X","Y","L","V"],l=function(t){return i?"$('"+t+"')":t};for(n=0;n<h.length;n++)for(a=t.indexOf(h[n]+"(");a>=0;)a>=0&&(r=t.indexOf(")",a+2))>=0&&(s=(s=t.slice(a+2,r)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[s])&&(t=t.slice(0,a+2)+(i?"$('":"")+l(o.id)+t.slice(r))),r=t.indexOf(")",a+2),a=t.indexOf(h[n]+"(",r);for(a=t.indexOf("Dist(");a>=0;)a>=0&&(r=t.indexOf(",",a+5))>=0&&(s=(s=t.slice(a+5,r)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[s])&&(t=t.slice(0,a+5)+l(o.id)+t.slice(r))),r=t.indexOf(",",a+5),a=t.indexOf(",",r),(r=t.indexOf(")",a+1))>=0&&(s=(s=t.slice(a+1,r)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[s])&&(t=t.slice(0,a+1)+l(o.id)+t.slice(r))),r=t.indexOf(")",a+1),a=t.indexOf("Dist(",r);for(h=["Deg","Rad"],n=0;n<h.length;n++)for(a=t.indexOf(h[n]+"(");a>=0;)a>=0&&(r=t.indexOf(",",a+4))>=0&&(s=(s=t.slice(a+4,r)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[s])&&(t=t.slice(0,a+4)+l(o.id)+t.slice(r))),r=t.indexOf(",",a+4),a=t.indexOf(",",r),(r=t.indexOf(",",a+1))>=0&&(s=(s=t.slice(a+1,r)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[s])&&(t=t.slice(0,a+1)+l(o.id)+t.slice(r))),r=t.indexOf(",",a+1),a=t.indexOf(",",r),(r=t.indexOf(")",a+1))>=0&&(s=(s=t.slice(a+1,r)).replace(/\\(['"])?/g,"$1"),(o=e.elementsByName[s])&&(t=t.slice(0,a+1)+l(o.id)+t.slice(r))),r=t.indexOf(")",a+1),a=t.indexOf(h[n]+"(",r);return t},replaceIdByObj:function(t){var e=/(X|Y|L)\(([\w_]+)\)/g;return t=t.replace(e,"$('$2').$1()"),e=/(V)\(([\w_]+)\)/g,t=t.replace(e,"$('$2').Value()"),e=/(Dist)\(([\w_]+),([\w_]+)\)/g,t=t.replace(e,"dist($('$2'), $('$3'))"),e=/(Deg)\(([\w_]+),([ \w[\w_]+),([\w_]+)\)/g,t=t.replace(e,"deg($('$2'),$('$3'),$('$4'))"),e=/Rad\(([\w_]+),([\w_]+),([\w_]+)\)/g,t=t.replace(e,"rad($('$1'),$('$2'),$('$3'))"),e=/N\((.+)\)/g,t=t.replace(e,"($1)")},geonext2JS:function(t,e){var i,r,s,o=["Abs","ACos","ASin","ATan","Ceil","Cos","Exp","Factorial","Floor","Log","Max","Min","Random","Round","Sin","Sqrt","Tan","Trunc"],n=["abs","acos","asin","atan","ceil","cos","exp","factorial","floor","log","max","min","random","round","sin","sqrt","tan","ceil"];for(r=t=(t=(t=t.replace(/&lt;/g,"<")).replace(/&gt;/g,">")).replace(/&amp;/g,"&"),r=this.replaceNameById(r,e),r=this.replaceIf(r),r=this.replacePow(r),r=this.replaceIdByObj(r),s=0;s<o.length;s++)i=new RegExp(["(\\W|^)(",o[s],")"].join(""),"ig"),r=r.replace(i,["$1",n[s]].join(""));return r=(r=(r=(r=(r=r.replace(/True/g,"true")).replace(/False/g,"false")).replace(/fasle/g,"false")).replace(/Pi/g,"PI")).replace(/"/g,"'")},findDependencies:function(t,r,s){var o,n,a,h;for(n in i.exists(s)||(s=t.board),o=s.elementsByName)o.hasOwnProperty(n)&&n!==t.name&&(o[n].elementClass===e.OBJECT_CLASS_TEXT&&i.evaluate(o[n].visProp.islabel)||(h=(h=n.replace(/\[/g,"\\[")).replace(/\]/g,"\\]"),a=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+h+")(,[\\w\\[\\]'_ ]+)*\\)","g"),r.search(a)>=0&&o[n].addChild(t)))},gxt2jc:function(t,e){var i;return i=t=(t=(t=t.replace(/&lt;/g,"<")).replace(/&gt;/g,">")).replace(/&amp;/g,"&"),i=(i=(i=(i=this.replaceNameById(i,e,!0)).replace(/True/g,"true")).replace(/False/g,"false")).replace(/fasle/g,"false")}},t.GeonextParser})),define("base/element",["jxg","base/constants","base/coords","math/math","math/statistics","options","utils/event","utils/color","utils/type"],(function(t,e,i,r,s,o,n,a,h){"use strict";return t.GeometryElement=function(t,i,r,s){var o,a,l;if(this.needsUpdate=!0,this.isDraggable=!1,this.isReal=!0,this.childElements={},this.hasLabel=!1,this.highlighted=!1,this.notExistingParents={},this.traces={},this.numTraces=0,this.transformations=[],this.baseElement=null,this.descendants={},this.ancestors={},this.parents=[],this.symbolic={},this.rendNode=null,this.elType="",this.dump=!0,this.subs={},this.inherits=[],this._pos=-1,this.stdform=[1,0,0,0,1,1,0,0],this.methodMap={setLabel:"setLabel",label:"label",setName:"setName",getName:"getName",addTransform:"addTransform",setProperty:"setAttribute",setAttribute:"setAttribute",addChild:"addChild",animate:"animate",on:"on",off:"off",trigger:"trigger",addTicks:"addTicks",removeTicks:"removeTicks",removeAllTicks:"removeAllTicks"},this.quadraticform=[[1,0,0],[0,1,0],[0,0,1]],this.visProp={},this.visPropCalc={visible:!1},n.eventify(this),this.mouseover=!1,this.lastDragTime=new Date,arguments.length>0){for(a in this.board=t,this.type=r,this._org_type=r,this.elementClass=s||e.OBJECT_CLASS_OTHER,this.id=i.id,o=i.name,h.exists(o)||(o=this.board.generateName(this)),""!==o&&(this.board.elementsByName[o]=this),this.name=o,this.needsRegularUpdate=i.needsregularupdate,h.clearVisPropOld(this),l=this.resolveShortcuts(i))l.hasOwnProperty(a)&&this._set(a,l[a]);this.visProp.draft=l.draft&&l.draft.draft}},t.extend(t.GeometryElement.prototype,{addChild:function(t){var e,i;for(e in this.childElements[t.id]=t,this.addDescendants(t),t.ancestors[this.id]=this,this.descendants)if(this.descendants.hasOwnProperty(e))for(i in this.descendants[e].ancestors[this.id]=this,this.ancestors)this.ancestors.hasOwnProperty(i)&&(this.descendants[e].ancestors[this.ancestors[i].id]=this.ancestors[i]);for(e in this.ancestors)if(this.ancestors.hasOwnProperty(e))for(i in this.descendants)this.descendants.hasOwnProperty(i)&&(this.ancestors[e].descendants[this.descendants[i].id]=this.descendants[i]);return this},addDescendants:function(t){var e;for(e in this.descendants[t.id]=t,t.childElements)t.childElements.hasOwnProperty(e)&&this.addDescendants(t.childElements[e]);return this},addParents:function(t){var e,i,r;for(i=(r=h.isArray(t)?t:arguments).length,e=0;e<i;++e)h.exists(r[e])&&(h.isId(this.board,r[e])?this.parents.push(r[e]):h.exists(r[e].id)&&this.parents.push(r[e].id));this.parents=h.uniqueArray(this.parents)},setParents:function(t){this.parents=[],this.addParents(t)},removeChild:function(t){return delete this.childElements[t.id],this.removeDescendants(t),delete t.ancestors[this.id],this},removeDescendants:function(t){var e;for(e in delete this.descendants[t.id],t.childElements)t.childElements.hasOwnProperty(e)&&this.removeDescendants(t.childElements[e]);return this},countChildren:function(){var t,e,i=0;for(t in e=this.childElements)e.hasOwnProperty(t)&&t.indexOf("Label")<0&&i++;return i},getName:function(){return this.name},addTransform:function(t){return this},draggable:function(){return this.isDraggable&&!h.evaluate(this.visProp.fixed)&&
/*!this.visProp.frozen &&*/this.type!==e.OBJECT_TYPE_GLIDER},setPosition:function(t,i){var r,s,o,n,a=[];if(!h.exists(this.parents))return this;for(o=this.parents.length,s=0;s<o;++s)if(r=this.board.select(this.parents[s]),h.isPoint(r)){if(!r.draggable())return this;a.push(r)}for(3===i.length&&(i=i.slice(1)),n=this.board.create("transform",i,{type:"translate"}),(o=a.length)>0?n.applyOnce(a):this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix?this.transformations[this.transformations.length-1].melt(n):this.addTransform(n),s=0;s<o;++s)a[s].type===e.OBJECT_TYPE_GLIDER&&a[s].updateGlider();return this},setPositionDirectly:function(t,r,o){var n=new i(t,r,this.board,!1),a=new i(t,o,this.board,!1),h=s.subtract(n.usrCoords,a.usrCoords);return this.setPosition(e.COORDS_BY_USER,h),this},generatePolynomial:function(){return[]},animate:function(t,e,i){i=i||{};var r,s,o,n=this.board.attr.animationdelay,l=Math.ceil(e/n),c=this,d=function(t,e,i){var r,s,n,h,d;for(r=a.rgb2hsv(t),n=((s=a.rgb2hsv(e))[0]-r[0])/l,h=(s[1]-r[1])/l,d=(s[2]-r[2])/l,c.animationData[i]=[],o=0;o<l;o++)c.animationData[i][l-o-1]=a.hsv2rgb(r[0]+(o+1)*n,r[1]+(o+1)*h,r[2]+(o+1)*d)},u=function(t,e,i,r){var s,n;if(t=parseFloat(t),e=parseFloat(e),!isNaN(t)&&!isNaN(e))for(n=(e-t)/l,c.animationData[i]=[],o=0;o<l;o++)s=t+(o+1)*n,c.animationData[i][l-o-1]=r?Math.floor(s):s};for(r in this.animationData={},t)if(t.hasOwnProperty(r))switch(s=r.toLowerCase()){case"strokecolor":case"fillcolor":d(this.visProp[s],t[r],s);break;case"size":if(!h.isPoint(this))break;u(this.visProp[s],t[r],s,!0);break;case"strokeopacity":case"strokewidth":case"fillopacity":u(this.visProp[s],t[r],s,!1)}return this.animationCallback=i.callback,this.board.addAnimation(this),this},update:function(){return h.evaluate(this.visProp.trace)&&this.cloneToBackground(),this},updateRenderer:function(){return this},fullUpdate:function(t){return this.prepareUpdate().update().updateVisibility(t).updateRenderer()},setDisplayRendNode:function(t){var e,i,r,s,o;if(void 0===t&&(t=this.visPropCalc.visible),t===this.visPropOld.visible)return this;for(this.board.renderer.display(this,t),i=this.inherits.length,r=0;r<i;r++)if(o=this.inherits[r],h.isArray(o))for(s=o.length,e=0;e<s;e++)h.exists(o[e])&&h.exists(o[e].rendNode)&&"inherit"===h.evaluate(o[e].visProp.visible)&&o[e].setDisplayRendNode(t);else h.exists(o)&&h.exists(o.rendNode)&&"inherit"===h.evaluate(o.visProp.visible)&&o.setDisplayRendNode(t);return this.hasLabel&&h.exists(this.label)&&h.exists(this.label.rendNode)&&"inherit"===h.evaluate(this.label.visProp.visible)&&this.label.setDisplayRendNode(t),this},hide:function(){return this.setAttribute({visible:!1}),this},hideElement:function(){return this.hide(),this},show:function(){return this.setAttribute({visible:!0}),this},showElement:function(){return this.show(),this},updateVisibility:function(t){var e,i,r,s,o,n;if(this.needsUpdate){for(void 0!==t?this.visPropCalc.visible=t:(n=h.evaluate(this.visProp.visible),h.exists(this.hiddenByParent)&&this.hiddenByParent&&(n=!1),"inherit"!==n&&(this.visPropCalc.visible=n)),i=this.inherits.length,r=0;r<i;r++)if(o=this.inherits[r],h.isArray(o))for(s=o.length,e=0;e<s;e++)h.exists(o[e])&&"inherit"===h.evaluate(o[e].visProp.visible)&&o[e].prepareUpdate().updateVisibility(this.visPropCalc.visible);else h.exists(o)&&"inherit"===h.evaluate(o.visProp.visible)&&o.prepareUpdate().updateVisibility(this.visPropCalc.visible);h.exists(this.label)&&h.exists(this.label.visProp)&&h.evaluate(this.label.visProp.visible)&&this.label.prepareUpdate().updateVisibility(this.visPropCalc.visible)}return this},_set:function(t,e){var i;if(t=t.toLocaleLowerCase(),this.visProp.hasOwnProperty(t)&&t.indexOf("color")>=0&&h.isString(e)&&9===e.length&&"#"===e.charAt(0))e=a.rgba2rgbo(e),this.visProp[t]=e[0],this.visProp[t.replace("color","opacity")]=e[1];else if(null===e||!h.isObject(e)||h.exists(e.id)||h.exists(e.name))this.visProp[t]=e;else for(i in this.visProp[t]={},e)e.hasOwnProperty(i)&&(this.visProp[t][i.toLocaleLowerCase()]=e[i])},resolveShortcuts:function(t){var e,i;for(e in o.shortcuts)if(o.shortcuts.hasOwnProperty(e)&&h.exists(t[e]))for(i=0;i<o.shortcuts[e].length;i++)h.exists(t[o.shortcuts[e][i]])||(t[o.shortcuts[e][i]]=t[e]);return t},setLabel:function(t){this.hasLabel||this.setAttribute({withlabel:!0}),this.setLabelText(t)},setLabelText:function(t){return h.exists(this.label)&&(t=t.replace(/</g,"&lt;").replace(/>/g,"&gt;"),this.label.setText(t)),this},setName:function(t){t=t.replace(/</g,"&lt;").replace(/>/g,"&gt;"),"slider"!==this.elType&&this.setLabelText(t),this.setAttribute({name:t})},setProperty:function(){t.deprecated("setProperty()","setAttribute()"),this.setAttribute.apply(this,arguments)},setAttribute:function(i){var r,s,o,n,l,c,d,u,p,f={};for(r=0;r<arguments.length;r++)c=arguments[r],h.isString(c)?(u=c.split(":"),f[h.trim(u[0])]=h.trim(u[1])):h.isArray(c)?f[c[0]]=c[1]:t.extend(f,c);for(r in f=this.resolveShortcuts(f))if(f.hasOwnProperty(r)){if(n=r.replace(/\s+/g,"").toLowerCase(),l=f[r],h.isObject(l)&&h.exists(this.visProp[n])){if(this.visProp[n]=h.merge(this.visProp[n],l),this.type===e.OBJECT_TYPE_TICKS&&h.exists(this.labels))for(o=this.labels.length,s=0;s<o;s++)this.labels[s].setAttribute(l);else if(h.exists(this[n]))if(h.isArray(this[n]))for(s=0;s<this[n].length;s++)this[n][s].setAttribute(l);else this[n].setAttribute(l);continue}switch(p=this.visProp[n],n){case"name":p=this.name,delete this.board.elementsByName[this.name],this.name=l,this.board.elementsByName[this.name]=this;break;case"needsregularupdate":this.needsRegularUpdate=!("false"===l||!1===l),this.board.renderer.setBuffering(this,this.needsRegularUpdate?"auto":"static");break;case"labelcolor":d=(l=a.rgba2rgbo(l))[1],l=l[0],0===d&&h.exists(this.label)&&this.hasLabel&&this.label.hideElement(),h.exists(this.label)&&this.hasLabel&&(this.label.visProp.strokecolor=l,this.board.renderer.setObjectStrokeColor(this.label,l,d)),this.elementClass===e.OBJECT_CLASS_TEXT&&(this.visProp.strokecolor=l,this.visProp.strokeopacity=d,this.board.renderer.setObjectStrokeColor(this,l,d));break;case"infoboxtext":h.isString(l)?this.infoboxText=l:this.infoboxText=!1;break;case"visible":this.visProp.visible="false"!==l&&("true"===l||l),this.setDisplayRendNode(h.evaluate(this.visProp.visible)),h.evaluate(this.visProp.visible)&&h.exists(this.updateSize)&&this.updateSize();break;case"face":h.isPoint(this)&&(this.visProp.face=l,this.board.renderer.changePointStyle(this));break;case"trace":"false"===l||!1===l?(this.clearTrace(),this.visProp.trace=!1):this.visProp.trace="pause"!==l;break;case"gradient":this.visProp.gradient=l,this.board.renderer.setGradient(this);break;case"gradientsecondcolor":l=a.rgba2rgbo(l),this.visProp.gradientsecondcolor=l[0],this.visProp.gradientsecondopacity=l[1],this.board.renderer.updateGradient(this);break;case"gradientsecondopacity":this.visProp.gradientsecondopacity=l,this.board.renderer.updateGradient(this);break;case"withlabel":this.visProp.withlabel=l,h.evaluate(l)?(this.label||this.createLabel(),this.label.setAttribute({visible:"inherit"})):this.label&&this.hasLabel&&this.label.setAttribute({visible:!1}),this.hasLabel=l;break;case"radius":this.type!==e.OBJECT_TYPE_ANGLE&&this.type!==e.OBJECT_TYPE_SECTOR||this.setRadius(l);break;case"rotate":(this.elementClass===e.OBJECT_CLASS_TEXT&&"internal"===h.evaluate(this.visProp.display)||this.type===e.OBJECT_TYPE_IMAGE)&&this.addRotation(l);break;case"ticksdistance":this.type===e.OBJECT_TYPE_TICKS&&h.isNumber(l)&&(this.ticksFunction=this.makeTicksFunction(l));break;case"generatelabelvalue":this.type===e.OBJECT_TYPE_TICKS&&h.isFunction(l)&&(this.generateLabelValue=l);break;case"onpolygon":this.type===e.OBJECT_TYPE_GLIDER&&(this.onPolygon=!!l);break;case"disabled":h.exists(this.rendNodeTag)&&(this.rendNodeTag.disabled=!!l);break;case"checked":h.exists(this.rendNodeTag)&&(this.rendNodeCheckbox.checked=!!l);break;case"maxlength":h.exists(this.rendNodeTag)&&(this.rendNodeTag.maxlength=!!l);break;case"layer":this.board.renderer.setLayer(this,h.evaluate(l)),this._set(n,l);break;case"tabindex":h.exists(this.rendNode)&&(this.rendNode.setAttribute("tabindex",l),this._set(n,l));break;default:h.exists(this.visProp[n])&&(!t.Validator[n]||t.Validator[n]&&t.Validator[n](l)||t.Validator[n]&&h.isFunction(l)&&t.Validator[n](l()))&&(l=(!l.toLowerCase||"false"!==l.toLowerCase())&&l,this._set(n,l))}this.triggerEventHandlers(["attribute:"+n],[p,l,this])}return this.triggerEventHandlers(["attribute"],[f,this]),h.evaluate(this.visProp.needsregularupdate)?this.board.update(this):this.board.fullUpdate(),this},getProperty:function(){t.deprecated("getProperty()","getAttribute()"),this.getProperty.apply(this,arguments)},getAttribute:function(t){var e;switch(t=t.toLowerCase()){case"needsregularupdate":e=this.needsRegularUpdate;break;case"labelcolor":e=this.label.visProp.strokecolor;break;case"infoboxtext":e=this.infoboxText;break;case"withlabel":e=this.hasLabel;break;default:e=this.visProp[t]}return e},setDash:function(t){return this.setAttribute({dash:t}),this},prepareUpdate:function(){return this.needsUpdate=!0,this},remove:function(){return this.board.renderer.remove(this.board.renderer.getElementById(this.id)),this.hasLabel&&this.board.renderer.remove(this.board.renderer.getElementById(this.label.id)),this},getTextAnchor:function(){return new i(e.COORDS_BY_USER,[0,0],this.board)},getLabelAnchor:function(){return new i(e.COORDS_BY_USER,[0,0],this.board)},setArrow:function(t,i){return this.visProp.firstarrow=t,this.visProp.lastarrow=i,i&&(this.type=e.OBJECT_TYPE_VECTOR,this.elType="arrow"),this.prepareUpdate().update().updateVisibility().updateRenderer(),this},createGradient:function(){var t=h.evaluate(this.visProp.gradient);"linear"!==t&&"radial"!==t||this.board.renderer.setGradient(this)},createLabel:function(){var e,i=this;return t.elements.text?((e=h.deepCopy(this.visProp.label,null)).id=this.id+"Label",e.isLabel=!0,e.anchor=this,e.priv=this.visProp.priv,this.visProp.withlabel&&(this.label=t.elements.text(this.board,[0,0,function(){return h.isFunction(i.name)?i.name():i.name}],e),this.label.needsUpdate=!0,this.label.dump=!1,this.label.fullUpdate(),this.hasLabel=!0)):t.debug("JSXGraph: Can't create label: text element is not available. Make sure you include base/text"),this},highlight:function(t){return t=h.def(t,!1),!h.evaluate(this.visProp.highlight)||this.highlighted&&!t||(this.highlighted=!0,this.board.highlightedObjects[this.id]=this,this.board.renderer.highlight(this)),this},noHighlight:function(){return this.highlighted&&(this.highlighted=!1,delete this.board.highlightedObjects[this.id],this.board.renderer.noHighlight(this)),this},clearTrace:function(){var t;for(t in this.traces)this.traces.hasOwnProperty(t)&&this.board.renderer.remove(this.traces[t]);return this.numTraces=0,this},cloneToBackground:function(){return this},bounds:function(){return[0,0,0,0]},normalize:function(){return this.stdform=r.normalize(this.stdform),this},toJSON:function(){var t,e,i=['{"name":',this.name];for(e in i.push(', "id":'+this.id),t=[],this.visProp)this.visProp.hasOwnProperty(e)&&h.exists(this.visProp[e])&&t.push('"'+e+'":'+this.visProp[e]);return i.push(', "visProp":{'+t.toString()+"}"),i.push("}"),i.join("")},addRotation:function(t){var i,r,s,o,n,a=this;return(this.elementClass===e.OBJECT_CLASS_TEXT&&"internal"===h.evaluate(this.visProp.display)||this.type===e.OBJECT_TYPE_IMAGE)&&0!==t&&(i=this.board.create("transform",[function(){return-a.X()},function(){return-a.Y()}],{type:"translate"}),r=this.board.create("transform",[function(){return a.X()},function(){return a.Y()}],{type:"translate"}),s=this.board.create("transform",[function(){return a.board.unitX/a.board.unitY},function(){return 1}],{type:"scale"}),o=this.board.create("transform",[function(){return a.board.unitY/a.board.unitX},function(){return 1}],{type:"scale"}),n=this.board.create("transform",[function(){return h.evaluate(t)*Math.PI/180}],{type:"rotate"}),i.bindTo(this),s.bindTo(this),n.bindTo(this),o.bindTo(this),r.bindTo(this)),this},highlightStrokeColor:function(e){return t.deprecated("highlightStrokeColor()","setAttribute()"),this.setAttribute({highlightStrokeColor:e}),this},strokeColor:function(e){return t.deprecated("strokeColor()","setAttribute()"),this.setAttribute({strokeColor:e}),this},strokeWidth:function(e){return t.deprecated("strokeWidth()","setAttribute()"),this.setAttribute({strokeWidth:e}),this},fillColor:function(e){return t.deprecated("fillColor()","setAttribute()"),this.setAttribute({fillColor:e}),this},highlightFillColor:function(e){return t.deprecated("highlightFillColor()","setAttribute()"),this.setAttribute({highlightFillColor:e}),this},labelColor:function(e){return t.deprecated("labelColor()","setAttribute()"),this.setAttribute({labelColor:e}),this},dash:function(e){return t.deprecated("dash()","setAttribute()"),this.setAttribute({dash:e}),this},visible:function(e){return t.deprecated("visible()","setAttribute()"),this.setAttribute({visible:e}),this},shadow:function(e){return t.deprecated("shadow()","setAttribute()"),this.setAttribute({shadow:e}),this},getType:function(){return this.elType},getParents:function(){return h.isArray(this.parents)?this.parents:[]},snapToGrid:function(){return this},snapToPoints:function(){return this},getAttributes:function(){var t,e=h.deepCopy(this.visProp),i=[],r=i.length;for(e.id=this.id,e.name=this.name,t=0;t<r;t++)delete e[i[t]];return e},hasPoint:function(t,e){return!1},addTicks:function(t){return""!==t.id&&h.exists(t.id)||(t.id=this.id+"_ticks_"+(this.ticks.length+1)),this.board.renderer.drawTicks(t),this.ticks.push(t),t.id},removeAllTicks:function(){var t;if(h.exists(this.ticks)){for(t=this.ticks.length-1;t>=0;t--)this.removeTicks(this.ticks[t]);this.ticks=[],this.board.update()}},removeTicks:function(t){var e,i;if(h.exists(this.defaultTicks)&&this.defaultTicks===t&&(this.defaultTicks=null),h.exists(this.ticks))for(e=this.ticks.length-1;e>=0;e--)if(this.ticks[e]===t){if(this.board.removeObject(this.ticks[e]),this.ticks[e].ticks)for(i=0;i<this.ticks[e].ticks.length;i++)h.exists(this.ticks[e].labels[i])&&this.board.removeObject(this.ticks[e].labels[i]);delete this.ticks[e];break}},getSnapSizes:function(){var t,e,i;return t=h.evaluate(this.visProp.snapsizex),e=h.evaluate(this.visProp.snapsizey),t<=0&&this.board.defaultAxes&&this.board.defaultAxes.x.defaultTicks&&(t=(i=this.board.defaultAxes.x.defaultTicks).ticksDelta*(h.evaluate(i.visProp.minorticks)+1)),e<=0&&this.board.defaultAxes&&this.board.defaultAxes.y.defaultTicks&&(e=(i=this.board.defaultAxes.y.defaultTicks).ticksDelta*(h.evaluate(i.visProp.minorticks)+1)),[t,e]},handleSnapToGrid:function(i,r){var s,o,n,a,l,c,d,u,p,f=h.evaluate(this.visProp.attracttogrid),m=h.evaluate(this.visProp.attractorunit),g=h.evaluate(this.visProp.attractordistance);return!h.exists(this.coords)||h.evaluate(this.visProp.fixed)||(h.evaluate(this.visProp.snaptogrid)||f||!0===i)&&(s=this.coords.usrCoords[1],o=this.coords.usrCoords[2],u=(d=this.getSnapSizes())[0],p=d[1],u>0&&p>0&&(c=this.board.getBoundingBox(),n=Math.round(s/u)*u,a=Math.round(o/p)*p,l=new t.Coords(e.COORDS_BY_USER,[n,a],this.board),(!f||l.distance("screen"===m?e.COORDS_BY_SCREEN:e.COORDS_BY_USER,this.coords)<g)&&(s=n,o=a,r||(s<c[0]?s+=u:s>c[2]&&(s-=u),o<c[3]?o+=p:o>c[1]&&(o-=p)),this.coords.setCoordinates(e.COORDS_BY_USER,[s,o])))),this},getBoundingBox:function(){var t,i,r,s,o,n=[1/0,1/0,-1/0,-1/0];if(this.type===e.OBJECT_TYPE_POLYGON){if((i=this.vertices.length-1)<=0)return n;for(t=0;t<i;t++)r=this.vertices[t].X(),n[0]=r<n[0]?r:n[0],n[2]=r>n[2]?r:n[2],r=this.vertices[t].Y(),n[1]=r<n[1]?r:n[1],n[3]=r>n[3]?r:n[3]}else if(this.elementClass===e.OBJECT_CLASS_CIRCLE)s=this.center.X(),o=this.center.Y(),n=[s-this.radius,o+this.radius,s+this.radius,o-this.radius];else if(this.elementClass===e.OBJECT_CLASS_CURVE){if(0===(i=this.vertices.length))return n;for(t=0;t<i;t++)r=this.points[t].coords.usrCoords[1],n[0]=r<n[0]?r:n[0],n[2]=r>n[2]?r:n[2],r=this.points[t].coords.usrCoords[1],n[1]=r<n[1]?r:n[1],n[3]=r>n[3]?r:n[3]}return n},addEvent:t.shortcut(t.GeometryElement.prototype,"on"),removeEvent:t.shortcut(t.GeometryElement.prototype,"off"),__evt__over:function(t){},__evt__mouseover:function(t){},__evt__out:function(t){},__evt__mouseout:function(t){},__evt__move:function(t){},__evt__mousemove:function(t){},__evt__drag:function(t){},__evt__mousedrag:function(t){},__evt__pendrag:function(t){},__evt__touchdrag:function(t){},__evt__down:function(t){},__evt__mousedown:function(t){},__evt__pendown:function(t){},__evt__touchdown:function(t){},__evt__up:function(t){},__evt__mouseup:function(t){},__evt__penup:function(t){},__evt__touchup:function(t){},__evt__attribute:function(t,e){},__evt__attribute_:function(t,e,i){},__evt:function(){}}),t.GeometryElement})),define("base/coordselement",["jxg","math/math","math/geometry","math/numerics","math/statistics","base/coords","base/constants","utils/type"],(function(t,e,i,r,s,o,n,a){"use strict";return t.CoordsElement=function(t,e){var i;for(a.exists(t)||(t=[1,0,0]),i=0;i<t.length;++i)t[i]=parseFloat(t[i]);this.coords=new o(n.COORDS_BY_USER,t,this.board),this.initialCoords=new o(n.COORDS_BY_USER,t,this.board),this.position=null,this.isConstrained=!1,this.onPolygon=!1,this.slideObject=null,this.slideObjects=[],this.needsUpdateFromParent=!0,this.groups=[],this.Xjc=null,this.Yjc=null,this.methodMap=a.deepCopy(this.methodMap,{move:"moveTo",moveTo:"moveTo",moveAlong:"moveAlong",visit:"visit",glide:"makeGlider",makeGlider:"makeGlider",intersect:"makeIntersection",makeIntersection:"makeIntersection",X:"X",Y:"Y",free:"free",setPosition:"setGliderPosition",setGliderPosition:"setGliderPosition",addConstraint:"addConstraint",dist:"Dist",onPolygon:"onPolygon"}),a.exists(this.element)&&this.addAnchor(t,e),this.isDraggable=!0},t.extend(t.CoordsElement.prototype,{updateConstraint:function(){return this},updateCoords:function(t){return this.needsUpdate?(a.exists(t)||(t=!1),a.evaluate(this.visProp.frozen)||this.updateConstraint(),this.type===n.OBJECT_TYPE_GLIDER&&(this.isConstrained&&(t=!1),t?this.updateGliderFromParent():this.updateGlider()),this.updateTransform(t),this):this},updateGlider:function(){var t,r,s,h,l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S=2*Math.PI,x=!1,O=this.slideObject,w=[];if(this.needsUpdateFromParent=!1,O.elementClass===n.OBJECT_CLASS_CIRCLE)a.evaluate(this.visProp.isgeonext)&&(S=1),v=i.projectPointToCircle(this,O,this.board),y=i.rad([O.center.X()+1,O.center.Y()],O.center,this)/S;else if(O.elementClass===n.OBJECT_CLASS_LINE){if(this.onPolygon){if(r=O.point1.coords.usrCoords,h=(s=O.point2.coords.usrCoords)[t=1]-r[t],Math.abs(h)<e.eps&&(h=s[t=2]-r[t]),d=(i.projectPointToLine(this,O,this.board).usrCoords[t]-r[t])/h,c=O.parentPolygon,d<0){for(t=0;t<c.borders.length;t++)if(O===c.borders[t]){O=c.borders[(t-1+c.borders.length)%c.borders.length];break}}else if(d>1)for(t=0;t<c.borders.length;t++)if(O===c.borders[t]){O=c.borders[(t+1+c.borders.length)%c.borders.length];break}O.id!==this.slideObject.id&&(this.slideObject=O)}r=O.point1.coords,s=O.point2.coords,(h=r.distance(n.COORDS_BY_USER,s))<e.eps?(v=r,x=!0,y=0):(v=i.projectPointToLine(this,O,this.board),r=r.usrCoords.slice(0),s=s.usrCoords.slice(0),Math.abs(s[0])<e.eps?(h=s[t=1],Math.abs(h)<e.eps&&(h=s[t=2]),y=((h=(v.usrCoords[t]-r[t])/h)>=0?1:-1)*(h=Math.abs(h))/(h+1)):Math.abs(r[0])<e.eps?(h=r[t=1],Math.abs(h)<e.eps&&(h=r[t=2]),y=(h=(v.usrCoords[t]-s[t])/h)<0?(1-2*h)/(1-h):1/(h+1)):(h=s[t=1]-r[t],Math.abs(h)<e.eps&&(h=s[t=2]-r[t]),y=(v.usrCoords[t]-r[t])/h)),C=a.evaluate(this.visProp.snapwidth),a.evaluate(C)>0&&Math.abs(this._smax-this._smin)>=e.eps&&(l=(y=Math.max(Math.min(y,1),0))*(this._smax-this._smin)+this._smin,y=((l=Math.round(l/C)*C)-this._smin)/(this._smax-this._smin),this.update(!0)),r=O.point1.coords,!a.evaluate(O.visProp.straightfirst)&&Math.abs(r.usrCoords[0])>e.eps&&y<0&&(v=r,x=!0,y=0),s=O.point2.coords,!a.evaluate(O.visProp.straightlast)&&Math.abs(s.usrCoords[0])>e.eps&&y>1&&(v=s,x=!0,y=1)}else if(O.type===n.OBJECT_TYPE_TURTLE)this.updateConstraint(),v=(_=i.projectPointToTurtle(this,O,this.board))[0],y=_[1];else if(O.elementClass===n.OBJECT_CLASS_CURVE)if(O.type===n.OBJECT_TYPE_ARC||O.type===n.OBJECT_TYPE_SECTOR)v=i.projectPointToCircle(this,O,this.board),f=i.rad(O.radiuspoint,O.center,this),u=0,p=i.rad(O.radiuspoint,O.center,O.anglepoint),y=f,("minor"===(C=a.evaluate(O.visProp.selection))&&p>Math.PI||"major"===C&&p<Math.PI)&&(u=p,p=2*Math.PI),(f<u||f>p)&&(y=p,(f<u&&f>.5*u||f>p&&f>.5*p+Math.PI)&&(y=u),this.needsUpdateFromParent=!0,this.updateGliderFromParent()),S=p-u,this.visProp.isgeonext&&(S=1),Math.abs(S)>e.eps&&(y/=S);else if(this.updateConstraint(),O.transformations.length>0){for(E=!1,(_=O.getTransformationSource())[0]&&(E=_[0],w.push(O),w.push(_[1]));_[0]&&a.exists(_[1]._transformationSource);)_=_[1].getTransformationSource(),w.push(_[1]);if(P=this.coords.usrCoords,E){for(t=0;t<w.length;t++)w[t].updateTransformMatrix(),b=e.inverse(w[t].transformMat),P=e.matVecMult(b,P);for(m=new o(n.COORDS_BY_USER,P,this.board).usrCoords,P=(g=i.projectCoordsToCurve(m[1],m[2],this.position||0,w[w.length-1],this.board))[0].usrCoords,t=w.length-2;t>=0;t--)P=e.matVecMult(w[t].transformMat,P);g[0]=new o(n.COORDS_BY_USER,P,this.board)}else O.updateTransformMatrix(),b=e.inverse(O.transformMat),P=e.matVecMult(b,P),m=new o(n.COORDS_BY_USER,P,this.board).usrCoords,g=i.projectCoordsToCurve(m[1],m[2],this.position||0,O,this.board);v=g[0],y=g[1]}else v=(_=i.projectPointToCurve(this,O,this.board))[0],y=_[1];else a.isPoint(O)&&(v=i.projectPointToPoint(this,O,this.board),y=this.position);this.coords.setCoordinates(n.COORDS_BY_USER,v.usrCoords,x),this.position=y},updateGliderFromParent:function(){var t,r,s,h,l,c,d,u,p,f,m,g,b=this.slideObject,v=[],y=2*Math.PI;if(this.needsUpdateFromParent){if(b.elementClass===n.OBJECT_CLASS_CIRCLE)s=b.Radius(),a.evaluate(this.visProp.isgeonext)&&(y=1),l=[b.center.X()+s*Math.cos(this.position*y),b.center.Y()+s*Math.sin(this.position*y)];else if(b.elementClass===n.OBJECT_CLASS_LINE)t=b.point1.coords.usrCoords,r=b.point2.coords.usrCoords,0===t[0]&&0===t[1]&&0===t[2]||0===r[0]&&0===r[1]&&0===r[2]?l=[0,0,0]:Math.abs(r[0])<e.eps?(h=Math.min(Math.abs(this.position),1-e.eps),h/=1-h,this.position<0&&(h=-h),l=[t[0]+h*r[0],t[1]+h*r[1],t[2]+h*r[2]]):Math.abs(t[0])<e.eps?(h=Math.max(this.position,e.eps),h=(h=Math.min(h,2-e.eps))>1?(h-1)/(h-2):(1-h)/h,l=[r[0]+h*t[0],r[1]+h*t[1],r[2]+h*t[2]]):(h=this.position,l=[t[0]+h*(r[0]-t[0]),t[1]+h*(r[1]-t[1]),t[2]+h*(r[2]-t[2])]);else if(b.type===n.OBJECT_TYPE_TURTLE)this.coords.setCoordinates(n.COORDS_BY_USER,[b.Z(this.position),b.X(this.position),b.Y(this.position)]),this.updateConstraint(),l=i.projectPointToTurtle(this,b,this.board)[0].usrCoords;else if(b.elementClass===n.OBJECT_CLASS_CURVE){for(u=!1,(c=b.getTransformationSource())[0]&&(u=c[0],v.push(b),v.push(c[1]));c[0]&&a.exists(c[1]._transformationSource);)c=c[1].getTransformationSource(),v.push(c[1]);if(u?this.coords.setCoordinates(n.COORDS_BY_USER,[v[v.length-1].Z(this.position),v[v.length-1].X(this.position),v[v.length-1].Y(this.position)]):this.coords.setCoordinates(n.COORDS_BY_USER,[b.Z(this.position),b.X(this.position),b.Y(this.position)]),b.type===n.OBJECT_TYPE_ARC||b.type===n.OBJECT_TYPE_SECTOR)p=i.rad([b.center.X()+1,b.center.Y()],b.center,b.radiuspoint),f=0,g=i.rad(b.radiuspoint,b.center,b.anglepoint),("minor"===b.visProp.selection&&g>Math.PI||"major"===b.visProp.selection&&g<Math.PI)&&(f=g,g=2*Math.PI),y=g-f,a.evaluate(this.visProp.isgeonext)&&(y=1),((m=this.position*y)<f||m>g)&&(((m=g)<f&&m>.5*f||m>g&&m>.5*g+Math.PI)&&(m=f),this.position=m,Math.abs(y)>e.eps&&(this.position/=y)),s=b.Radius(),l=[b.center.X()+s*Math.cos(this.position*y+p),b.center.Y()+s*Math.sin(this.position*y+p)];else if(this.updateConstraint(),u)for(l=i.projectPointToCurve(this,v[v.length-1],this.board)[0].usrCoords,d=v.length-2;d>=0;d--)l=new o(n.COORDS_BY_USER,e.matVecMult(v[d].transformMat,l),this.board).usrCoords;else l=i.projectPointToCurve(this,b,this.board)[0].usrCoords}else a.isPoint(b)&&(l=i.projectPointToPoint(this,b,this.board).usrCoords);this.coords.setCoordinates(n.COORDS_BY_USER,l,!1)}else this.needsUpdateFromParent=!0},updateRendererGeneric:function(t){return this.needsUpdate?(this.visPropCalc.visible&&(this.isReal=!isNaN(this.coords.usrCoords[1]+this.coords.usrCoords[2]),this.isReal=Math.abs(this.coords.usrCoords[0])>e.eps&&this.isReal,this.isReal||this.updateVisibility(!1)),this.visPropCalc.visible&&this.board.renderer[t](this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},X:function(){return this.coords.usrCoords[1]},Y:function(){return this.coords.usrCoords[2]},Z:function(){return this.coords.usrCoords[0]},XEval:function(){return this.coords.usrCoords[1]},YEval:function(){return this.coords.usrCoords[2]},ZEval:function(){return this.coords.usrCoords[0]},Dist:function(t){return this.isReal&&t.isReal?this.coords.distance(n.COORDS_BY_USER,t.coords):NaN},snapToGrid:function(t){return this.handleSnapToGrid(t)},handleSnapToPoints:function(t){var e,r,s,o,h,l,c,d,u=0,p=1/0,f=null,m=a.evaluate(this.visProp.ignoredsnaptopoints),g=!1;if(o=this.board.objectsList.length,m&&(c=m.length),a.evaluate(this.visProp.snaptopoints)||t){for(h=a.evaluate(this.visProp.attractorunit),l=a.evaluate(this.visProp.attractordistance),e=0;e<o;e++){if(r=this.board.objectsList[e],m){for(g=!1,d=0;d<c;d++)if(r===this.board.select(m[d])){g=!0;break}if(g)continue}a.isPoint(r)&&r!==this&&r.visPropCalc.visible&&(s=i.projectPointToPoint(this,r,this.board),(u="screen"===h?s.distance(n.COORDS_BY_SCREEN,this.coords):s.distance(n.COORDS_BY_USER,this.coords))<l&&u<p&&(p=u,f=s))}null!==f&&this.coords.setCoordinates(n.COORDS_BY_USER,f.usrCoords)}return this},snapToPoints:function(t){return this.handleSnapToPoints(t)},handleAttractors:function(){var t,e,r,s,h=0,l=a.evaluate(this.visProp.attractorunit),c=a.evaluate(this.visProp.attractordistance),d=a.evaluate(this.visProp.snatchdistance),u=a.evaluate(this.visProp.attractors),p=u.length;if(0!==c){for(t=0;t<p;t++)if(e=this.board.select(u[t]),a.exists(e)&&e!==this){if(a.isPoint(e)?r=i.projectPointToPoint(this,e,this.board):e.elementClass===n.OBJECT_CLASS_LINE?(s=i.projectCoordsToSegment(this.coords.usrCoords,e.point1.coords.usrCoords,e.point2.coords.usrCoords),r=!a.evaluate(e.visProp.straightfirst)&&s[1]<0?e.point1.coords:!a.evaluate(e.visProp.straightlast)&&s[1]>1?e.point2.coords:new o(n.COORDS_BY_USER,s[0],this.board)):e.elementClass===n.OBJECT_CLASS_CIRCLE?r=i.projectPointToCircle(this,e,this.board):e.elementClass===n.OBJECT_CLASS_CURVE?r=i.projectPointToCurve(this,e,this.board)[0]:e.type===n.OBJECT_TYPE_TURTLE?r=i.projectPointToTurtle(this,e,this.board)[0]:e.type===n.OBJECT_TYPE_POLYGON&&(r=new o(n.COORDS_BY_USER,i.projectCoordsToPolygon(this.coords.usrCoords,e),this.board)),(h="screen"===l?r.distance(n.COORDS_BY_SCREEN,this.coords):r.distance(n.COORDS_BY_USER,this.coords))<c){this.type===n.OBJECT_TYPE_GLIDER&&(e===this.slideObject||this.slideObject&&this.onPolygon&&this.slideObject.parentPolygon===e)||this.makeGlider(e);break}h>=d&&(e===this.slideObject||this.slideObject&&this.onPolygon&&this.slideObject.parentPolygon===e)&&this.popSlideObject()}return this}},setPositionDirectly:function(t,i){var r,h,l,c,d=this.coords;if(this.relativeCoords)return h=new o(t,i,this.board),a.evaluate(this.visProp.islabel)?(l=s.subtract(h.scrCoords,d.scrCoords),this.relativeCoords.scrCoords[1]+=l[1],this.relativeCoords.scrCoords[2]+=l[2]):(l=s.subtract(h.usrCoords,d.usrCoords),this.relativeCoords.usrCoords[1]+=l[1],this.relativeCoords.usrCoords[2]+=l[2]),this;for(this.coords.setCoordinates(t,i),this.handleSnapToGrid(),this.handleSnapToPoints(),this.handleAttractors(),r=this.transformations.length-1;r>=0;r--)t===n.COORDS_BY_SCREEN?c=new o(t,i,this.board).usrCoords:(2===i.length&&(i=[1].concat(i)),c=i),this.initialCoords.setCoordinates(n.COORDS_BY_USER,e.matVecMult(e.inverse(this.transformations[r].matrix),c));return this.prepareUpdate().update(),this.board.isSuspendedUpdate&&this.type===n.OBJECT_TYPE_GLIDER&&this.updateGlider(),this},setPositionByTransform:function(t,e){var i;return e=new o(t,e,this.board),i=this.board.create("transform",e.usrCoords.slice(1),{type:"translate"}),this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix?this.transformations[this.transformations.length-1].melt(i):this.addTransform(this,i),this.prepareUpdate().update(),this},setPosition:function(t,e){return this.setPositionDirectly(t,e)},setGliderPosition:function(t){return this.type===n.OBJECT_TYPE_GLIDER&&(this.position=t,this.board.update()),this},makeGlider:function(e){var i,r,s,o=this.board.select(e),h=!1;if(o.type===n.OBJECT_TYPE_POLYGON){for(i=Number.MAX_VALUE,r=0;r<o.borders.length;r++)(s=t.Math.Geometry.distPointLine(this.coords.usrCoords,o.borders[r].stdform))<i&&(i=s,e=o.borders[r]);o=this.board.select(e),h=!0}if(!a.exists(o))throw new Error("JSXGraph: slide object undefined.");if(o.type===n.OBJECT_TYPE_TICKS)throw new Error("JSXGraph: gliders on ticks are not possible.");return this.slideObject=this.board.select(e),this.slideObjects.push(this.slideObject),this.addParents(e),this.type=n.OBJECT_TYPE_GLIDER,this.elType="glider",this.visProp.snapwidth=-1,this.slideObject.addChild(this),this.isDraggable=!0,this.onPolygon=h,this.generatePolynomial=function(){return this.slideObject.generatePolynomial(this)},this.updateGlider(),this.needsUpdateFromParent=!0,this.updateGliderFromParent(),this},popSlideObject:function(){this.slideObjects.length>0&&(this.slideObjects.pop(),this.slideObject.removeChild(this),0===this.slideObjects.length?(this.type=this._org_type,this.type===n.OBJECT_TYPE_POINT?this.elType="point":this.elementClass===n.OBJECT_CLASS_TEXT?this.elType="text":this.type===n.OBJECT_TYPE_IMAGE?this.elType="image":this.type===n.OBJECT_TYPE_FOREIGNOBJECT&&(this.elType="foreignobject"),this.slideObject=null):this.slideObject=this.slideObjects[this.slideObjects.length-1])},free:function(){var t,e;if(this.type!==n.OBJECT_TYPE_GLIDER){if(this.transformations.length=0,delete this.updateConstraint,this.isConstrained=!1,this.isDraggable)return;this.isDraggable=!0,this.elementClass===n.OBJECT_CLASS_POINT&&(this.type=n.OBJECT_TYPE_POINT,this.elType="point"),this.XEval=function(){return this.coords.usrCoords[1]},this.YEval=function(){return this.coords.usrCoords[2]},this.ZEval=function(){return this.coords.usrCoords[0]},this.Xjc=null,this.Yjc=null}for(t in this.board.objects)this.board.objects.hasOwnProperty(t)&&(e=this.board.objects[t]).descendants&&(delete e.descendants[this.id],delete e.childElements[this.id],this.hasLabel&&(delete e.descendants[this.label.id],delete e.childElements[this.label.id]));this.ancestors={},this.slideObject=null,this.slideObjects=[],this.elementClass===n.OBJECT_CLASS_POINT?(this.type=n.OBJECT_TYPE_POINT,this.elType="point"):this.elementClass===n.OBJECT_CLASS_TEXT?(this.type=this._org_type,this.elType="text"):this.elementClass===n.OBJECT_CLASS_OTHER&&(this.type=this._org_type,this.elType="image")},addConstraint:function(t){var e,i,r=[],s=["X","Y"],o=function(t){return function(){return t}},h=function(t){return function(){return t.Value()}};for(this.elementClass===n.OBJECT_CLASS_POINT&&(this.type=n.OBJECT_TYPE_CAS),this.isDraggable=!1,e=0;e<t.length;e++)i=t[e],a.isString(i)?(r[e]=this.board.jc.snippet(i,!0,null,!0),2===t.length&&(this[s[e]+"jc"]=t[e])):a.isFunction(i)?r[e]=i:a.isNumber(i)?r[e]=o(i):a.isObject(i)&&a.isFunction(i.Value)&&(r[e]=h(i)),r[e].origin=i;return 1===t.length?this.updateConstraint=function(){var t=r[0]();return a.isArray(t)?this.coords.setCoordinates(n.COORDS_BY_USER,t):this.coords=t,this}:2===t.length?(this.XEval=r[0],this.YEval=r[1],this.setParents([r[0].origin,r[1].origin]),this.updateConstraint=function(){return this.coords.setCoordinates(n.COORDS_BY_USER,[this.XEval(),this.YEval()]),this}):(this.ZEval=r[0],this.XEval=r[1],this.YEval=r[2],this.setParents([r[0].origin,r[1].origin,r[2].origin]),this.updateConstraint=function(){return this.coords.setCoordinates(n.COORDS_BY_USER,[this.ZEval(),this.XEval(),this.YEval()]),this}),this.isConstrained=!0,this.prepareUpdate().update(),this.board.isSuspendedUpdate||(this.updateVisibility().updateRenderer(),this.hasLabel&&this.label.fullUpdate()),this},addAnchor:function(t,e){this.relativeCoords=e?new o(n.COORDS_BY_SCREEN,t.slice(0,2),this.board):new o(n.COORDS_BY_USER,t,this.board),this.element.addChild(this),e&&this.addParents(this.element),this.XEval=function(){var t,e,i;return a.evaluate(this.visProp.islabel)?(i=a.evaluate(this.visProp.offset),t=parseFloat(i[0]),e=this.element.getLabelAnchor(),new o(n.COORDS_BY_SCREEN,[t+this.relativeCoords.scrCoords[1]+e.scrCoords[1],0],this.board).usrCoords[1]):(e=this.element.getTextAnchor(),this.relativeCoords.usrCoords[1]+e.usrCoords[1])},this.YEval=function(){var t,e,i;return a.evaluate(this.visProp.islabel)?(i=a.evaluate(this.visProp.offset),t=-parseFloat(i[1]),e=this.element.getLabelAnchor(),new o(n.COORDS_BY_SCREEN,[0,t+this.relativeCoords.scrCoords[2]+e.scrCoords[2]],this.board).usrCoords[2]):(e=this.element.getTextAnchor(),this.relativeCoords.usrCoords[2]+e.usrCoords[2])},this.ZEval=a.createFunction(1,this.board,""),this.updateConstraint=function(){this.coords.setCoordinates(n.COORDS_BY_USER,[this.ZEval(),this.XEval(),this.YEval()])},this.isConstrained=!0,this.updateConstraint()},updateTransform:function(t){var e;if(0===this.transformations.length)return this;for(e=0;e<this.transformations.length;e++)this.transformations[e].update();return this},addTransform:function(t,e){var i,r=a.isArray(e)?e:[e],s=r.length;for(0===this.transformations.length&&(this.baseElement=t),i=0;i<s;i++)this.transformations.push(r[i]);return this},startAnimation:function(t,e,i){var r=this;return i=i||250,this.type!==n.OBJECT_TYPE_GLIDER||a.exists(this.intervalCode)||(this.intervalCode=window.setInterval((function(){r._anim(t,e)}),i),a.exists(this.intervalCount)||(this.intervalCount=0)),this},stopAnimation:function(){return a.exists(this.intervalCode)&&(window.clearInterval(this.intervalCode),delete this.intervalCode),this},moveAlong:function(t,e,i){i=i||{};var s,o,h,l,c,d=[],u=[],p=e/this.board.attr.animationdelay,f=function(e,i){return function(){return t[e][i]}};if(a.isArray(t)){for(h=t.length,s=0;s<h;s++)a.isPoint(t[s])?u[s]=t[s]:u[s]={elementClass:n.OBJECT_CLASS_POINT,X:f(s,0),Y:f(s,1)};if(0===(e=e||0))return this.setPosition(n.COORDS_BY_USER,[u[u.length-1].X(),u[u.length-1].Y()]),this.board.update(this);if(!a.exists(i.interpolate)||i.interpolate)for(o=r.Neville(u),s=0;s<p;s++)d[s]=[],d[s][0]=o[0]((p-s)/p*o[3]()),d[s][1]=o[1]((p-s)/p*o[3]());else{for(h=t.length-1,s=0;s<p;++s)c=s/p*h-(l=Math.floor(s/p*h)),d[s]=[],d[s][0]=(1-c)*u[l].X()+c*u[l+1].X(),d[s][1]=(1-c)*u[l].Y()+c*u[l+1].Y();d.push([u[h].X(),u[h].Y()]),d.reverse()}this.animationPath=d}else a.isFunction(t)&&(this.animationPath=t,this.animationStart=(new Date).getTime());return this.animationCallback=i.callback,this.board.addAnimation(this),this},moveTo:function(t,i,r){r=r||{},t=new o(n.COORDS_BY_USER,t,this.board);var s,h=this.board.attr.animationdelay,l=Math.ceil(i/h),c=[],d=this.coords.usrCoords[1],u=this.coords.usrCoords[2],p=t.usrCoords[1]-d,f=t.usrCoords[2]-u,m=function(t){return r.effect&&"<>"===r.effect?Math.pow(Math.sin(t/l*Math.PI/2),2):t/l};if(!a.exists(i)||0===i||Math.abs(t.usrCoords[0]-this.coords.usrCoords[0])>e.eps)return this.setPosition(n.COORDS_BY_USER,t.usrCoords),this.board.update(this);if(!a.exists(r.callback)&&Math.abs(p)<e.eps&&Math.abs(f)<e.eps)return this;for(s=l;s>=0;s--)c[l-s]=[t.usrCoords[0],d+p*m(s),u+f*m(s)];return this.animationPath=c,this.animationCallback=r.callback,this.board.addAnimation(this),this},visit:function(t,e,i){t=new o(n.COORDS_BY_USER,t,this.board);var r,s,h,l=this.board.attr.animationdelay,c=[],d=this.coords.usrCoords[1],u=this.coords.usrCoords[2],p=t.usrCoords[1]-d,f=t.usrCoords[2]-u,m=function(t){var e=t<h/2?2*t/h:2*(h-t)/h;return i.effect&&"<>"===i.effect?Math.pow(Math.sin(e*Math.PI/2),2):e};for(a.isNumber(i)?i={repeat:i}:(i=i||{},a.exists(i.repeat)||(i.repeat=1)),h=Math.ceil(e/(l*i.repeat)),s=0;s<i.repeat;s++)for(r=h;r>=0;r--)c[s*(h+1)+h-r]=[t.usrCoords[0],d+p*m(r),u+f*m(r)];return this.animationPath=c,this.animationCallback=i.callback,this.board.addAnimation(this),this},_anim:function(t,e){var r,s,o,a,h,l,c,d,u;return this.intervalCount+=1,this.intervalCount>e&&(this.intervalCount=0),this.slideObject.elementClass===n.OBJECT_CLASS_LINE?(c=this.slideObject.point1.coords.scrCoords,d=this.slideObject.point2.coords.scrCoords,r=Math.round((d[1]-c[1])*this.intervalCount/e),s=Math.round((d[2]-c[2])*this.intervalCount/e),t>0?a=this.slideObject.point1:(a=this.slideObject.point2,r*=-1,s*=-1),this.coords.setCoordinates(n.COORDS_BY_SCREEN,[a.coords.scrCoords[1]+r,a.coords.scrCoords[2]+s])):this.slideObject.elementClass===n.OBJECT_CLASS_CURVE?(h=t>0?Math.round(this.intervalCount/e*this.board.canvasWidth):Math.round((e-this.intervalCount)/e*this.board.canvasWidth),this.coords.setCoordinates(n.COORDS_BY_SCREEN,[h,0]),u=i.projectPointToCurve(this,this.slideObject,this.board),this.coords=u[0],this.position=u[1]):this.slideObject.elementClass===n.OBJECT_CLASS_CIRCLE&&(o=2*Math.PI,o*=t<0?this.intervalCount/e:e-this.intervalCount,l=this.slideObject.Radius(),this.coords.setCoordinates(n.COORDS_BY_USER,[this.slideObject.center.coords.usrCoords[1]+l*Math.cos(o),this.slideObject.center.coords.usrCoords[2]+l*Math.sin(o)])),this.board.update(this),this},getTextAnchor:function(){return this.coords},getLabelAnchor:function(){return this.coords},getParents:function(){var t=[this.Z(),this.X(),this.Y()];return 0!==this.parents.length&&(t=this.parents),this.type===n.OBJECT_TYPE_GLIDER&&(t=[this.X(),this.Y(),this.slideObject.id]),t}}),t.CoordsElement.create=function(t,e,i,r,s,o){var n,h,l=!1;for(h=0;h<i.length;h++)(a.isFunction(i[h])||a.isString(i[h]))&&(l=!0);if(l)(n=new t(e,[0,0],r,s,o)).addConstraint(i);else if(a.isNumber(i[0])&&a.isNumber(i[1]))n=new t(e,i,r,s,o),a.exists(r.slideobject)?n.makeGlider(r.slideobject):n.baseElement=n,n.isDraggable=!0;else{if(!a.isObject(i[0])||!a.isTransformationOrArray(i[1]))return!1;(n=new t(e,[0,0],r,s,o)).addTransform(i[0],i[1]),n.isDraggable=!1}return n.handleSnapToGrid(),n.handleSnapToPoints(),n.handleAttractors(),n.addParents(i),n},t.CoordsElement})),define("base/text",["jxg","base/constants","base/element","parser/geonext","utils/env","utils/type","math/math","base/coordselement"],(function(t,e,i,r,s,o,n,a){"use strict";var h=function(){this._val=parseFloat(this.rendNodeRange.value),this.rendNodeOut.value=this.rendNodeRange.value,this.board.update()};return t.Text=function(t,i,r,s){this.constructor(t,r,e.OBJECT_TYPE_TEXT,e.OBJECT_CLASS_TEXT),this.element=this.board.select(r.anchor),this.coordsConstructor(i,o.evaluate(this.visProp.islabel)),this.content="",this.plaintext="",this.plaintextOld=null,this.orgText="",this.needsSizeUpdate=!1,this.hiddenByParent=!1,this.size=[1,1],this.id=this.board.setId(this,"T"),this.board.renderer.drawText(this),this.board.finalizeAdding(this),this.setText(s),o.isString(this.content)&&this.notifyParents(this.content),this.elType="text",this.methodMap=o.deepCopy(this.methodMap,{setText:"setTextJessieCode",move:"setCoords"})},t.Text.prototype=new i,o.copyPrototypeMethods(t.Text,a,"coordsConstructor"),t.extend(t.Text.prototype,{hasPoint:function(t,e){var i,r,s,a,h,l,c,d;return o.isObject(o.evaluate(this.visProp.precision))?(c=this.board._inputDevice,d=o.evaluate(this.visProp.precision[c])):d=this.board.options.precision.hasPoint,this.transformations.length>0&&(t=(i=n.matVecMult(n.inverse(this.board.renderer.joinTransforms(this,this.transformations)),[1,t,e]))[1],e=i[2]),r=(i="right"===(h=this.getAnchorX())?this.coords.scrCoords[1]-this.size[0]:"middle"===h?this.coords.scrCoords[1]-.5*this.size[0]:this.coords.scrCoords[1])+this.size[0],s=(a="top"===(l=this.getAnchorY())?this.coords.scrCoords[2]+this.size[1]:"middle"===l?this.coords.scrCoords[2]+.5*this.size[1]:this.coords.scrCoords[2])-this.size[1],"all"===o.evaluate(this.visProp.dragarea)?t>=i-d&&t<r+d&&e>=s-d&&e<=a+d:e>=s-d&&e<=a+d&&(t>=i-d&&t<=i+2*d||t>=r-2*d&&t<=r+d)},_createFctUpdateText:function(t){var e,i,r=o.evaluate(this.visProp.parse),s=o.evaluate(this.visProp.usemathjax),n=o.evaluate(this.visProp.usekatex);this.orgText=t,o.isFunction(t)?this.updateText=function(){i=t().toString(),this.plaintext=!r||s||n?i:this.replaceSub(this.replaceSup(this.convertGeonextAndSketchometry2CSS(i)))}:o.isString(t)&&!r?this.updateText=function(){this.plaintext=t}:(o.isNumber(t)?this.content=o.toFixed(t,o.evaluate(this.visProp.digits)):o.evaluate(this.visProp.useasciimathml)?this.content="'`"+t+"`'":this.content=s||n?"'"+t+"'":this.generateTerm(t,!0,!0),e=this.board.jc.snippet(this.content,!0,"",!1),this.updateText=function(){this.plaintext=e()})},_setText:function(t){return this._createFctUpdateText(t),this.updateText(),this.fullUpdate(),this.board.infobox&&this.id===this.board.infobox.id||this.updateSize(),this},setTextJessieCode:function(t){var e;return this.visProp.castext=t,e=o.isFunction(t)?function(){return o.sanitizeHTML(t())}:o.isNumber(t)?t:o.sanitizeHTML(t),this._setText(e)},setText:function(t){return this._setText(t)},updateSize:function(){var t,e,i,r=o.evaluate(this.visProp.display);return s.isBrowser&&"no"!==this.board.renderer.type?(i=this.rendNode,"html"===r||"vml"===this.board.renderer.type?o.exists(i.offsetWidth)?(e=this,window.setTimeout((function(){e.size=[i.offsetWidth,i.offsetHeight],e.needsUpdate=!0,e.updateRenderer()}),0)):this.size=this.crudeSizeEstimate():"internal"===r&&("svg"===this.board.renderer.type?(e=this,window.setTimeout((function(){try{t=i.getBBox(),e.size=[t.width,t.height],e.needsUpdate=!0,e.updateRenderer()}catch(t){}}),0)):"canvas"===this.board.renderer.type&&(this.size=this.crudeSizeEstimate())),this):this},crudeSizeEstimate:function(){var t=parseFloat(o.evaluate(this.visProp.fontsize));return[t*this.plaintext.length*.45,.9*t]},utf8_decode:function(t){return t.replace(/&#x(\w+);/g,(function(t,e){return String.fromCharCode(parseInt(e,16))}))},replaceSub:function(t){if(!t.indexOf)return t;for(var e,i=t.indexOf("_{");i>=0;)(e=(t=t.substr(0,i)+t.substr(i).replace(/_\{/,"<sub>")).substr(i).indexOf("}"))>=0&&(t=t.substr(0,e)+t.substr(e).replace(/\}/,"</sub>")),i=t.indexOf("_{");for(i=t.indexOf("_");i>=0;)i=(t=t.substr(0,i)+t.substr(i).replace(/_(.?)/,"<sub>$1</sub>")).indexOf("_");return t},replaceSup:function(t){if(!t.indexOf)return t;for(var e,i=t.indexOf("^{");i>=0;)(e=(t=t.substr(0,i)+t.substr(i).replace(/\^\{/,"<sup>")).substr(i).indexOf("}"))>=0&&(t=t.substr(0,e)+t.substr(e).replace(/\}/,"</sup>")),i=t.indexOf("^{");for(i=t.indexOf("^");i>=0;)i=(t=t.substr(0,i)+t.substr(i).replace(/\^(.?)/,"<sup>$1</sup>")).indexOf("^");return t},getSize:function(){return this.size},setCoords:function(t,i){var r,s,n;return o.isArray(t)&&t.length>1&&(i=t[1],t=t[0]),o.evaluate(this.visProp.islabel)&&o.exists(this.element)?(s=(t-(r=this.element.getLabelAnchor()).usrCoords[1])*this.board.unitX,n=-(i-r.usrCoords[2])*this.board.unitY,this.relativeCoords.setCoordinates(e.COORDS_BY_SCREEN,[s,n])):this.coords.setCoordinates(e.COORDS_BY_USER,[t,i]),this.fullUpdate(),this},update:function(t){return this.needsUpdate?(this.updateCoords(t),this.updateText(),"internal"===o.evaluate(this.visProp.display)&&o.isString(this.plaintext)&&(this.plaintext=this.utf8_decode(this.plaintext)),this.checkForSizeUpdate(),this.needsSizeUpdate&&this.updateSize(),this):this},checkForSizeUpdate:function(){this.board.infobox&&this.id===this.board.infobox.id?this.needsSizeUpdate=!1:(this.needsSizeUpdate=this.plaintextOld!==this.plaintext,this.needsSizeUpdate&&(this.plaintextOld=this.plaintext))},updateRenderer:function(){return o.evaluate(this.visProp.autoposition)&&this.setAutoPosition().updateConstraint(),this.updateRendererGeneric("updateText")},expandShortMath:function(t){return t.replace(/([)0-9.])\s*([(a-zA-Z_])/g,"$1*$2")},generateTerm:function(t,e,i){var s,n,a,h,l='""';if(a=(t=(t=(t=(t=(t=(t=(t=(t=(t=(t=(t=t||"").replace(/\r/g,"")).replace(/\n/g,"")).replace(/"/g,"'")).replace(/'/g,"\\'")).replace(/&amp;arc;/g,"&ang;")).replace(/<arc\s*\/>/g,"&ang;")).replace(/&lt;arc\s*\/&gt;/g,"&ang;")).replace(/&lt;sqrt\s*\/&gt;/g,"&radic;")).replace(/&lt;value&gt;/g,"<value>")).replace(/&lt;\/value&gt;/g,"</value>")).indexOf("<value>"),h=t.indexOf("</value>"),a>=0)for(;a>=0;)l+=' + "'+this.replaceSub(this.replaceSup(t.slice(0,a)))+'"',n=(n=t.slice(a+7,h)).replace(/\s+/g,""),!0===e&&(n=this.expandShortMath(n)),(s=(s=(s=i?n:r.geonext2JS(n,this.board)).replace(/\\"/g,"'")).replace(/\\'/g,"'")).indexOf("toFixed")<0&&o.isNumber(o.bind(this.board.jc.snippet(s,!0,"",!1),this)())?l+="+("+s+").toFixed("+o.evaluate(this.visProp.digits)+")":l+="+("+s+")",a=(t=t.slice(h+8)).indexOf("<value>"),h=t.indexOf("</value>");return l+=' + "'+this.replaceSub(this.replaceSup(t))+'"',l=(l=(l=this.convertGeonextAndSketchometry2CSS(l)).replace(/&amp;/g,"&")).replace(/"/g,"'")},convertGeonext2CSS:function(t){return o.isString(t)&&(t=(t=(t=(t=t.replace(/(<|&lt;)overline(>|&gt;)/g,"<span style=text-decoration:overline;>")).replace(/(<|&lt;)\/overline(>|&gt;)/g,"</span>")).replace(/(<|&lt;)arrow(>|&gt;)/g,"<span style=text-decoration:overline;>")).replace(/(<|&lt;)\/arrow(>|&gt;)/g,"</span>")),t},convertSketchometry2CSS:function(t){return o.isString(t)&&(t=(t=(t=(t=t.replace(/(<|&lt;)sketchofont(>|&gt;)/g,"<span style=font-family:sketchometry-light;font-weight:500;>")).replace(/(<|&lt;)\/sketchofont(>|&gt;)/g,"</span>")).replace(/(<|&lt;)sketchometry-light(>|&gt;)/g,"<span style=font-family:sketchometry-light;font-weight:500;>")).replace(/(<|&lt;)\/sketchometry-light(>|&gt;)/g,"</span>")),t},convertGeonextAndSketchometry2CSS:function(t){return t=this.convertGeonext2CSS(t),t=this.convertSketchometry2CSS(t)},notifyParents:function(t){var e,i=null;t=(t=t.replace(/&lt;value&gt;/g,"<value>")).replace(/&lt;\/value&gt;/g,"</value>");do{null!==(i=(e=/<value>([\w\s*/^\-+()[\],<>=!]+)<\/value>/).exec(t))&&(r.findDependencies(this,i[1],this.board),t=(t=t.substr(i.index)).replace(e,""))}while(null!==i);return this},getParents:function(){var t;return t=void 0!==this.relativeCoords?[this.relativeCoords.usrCoords[1],this.relativeCoords.usrCoords[2],this.orgText]:[this.Z(),this.X(),this.Y(),this.orgText],0!==this.parents.length&&(t=this.parents),t},bounds:function(){var t=this.coords.usrCoords;return o.evaluate(this.visProp.islabel)||0===this.board.unitY||0===this.board.unitX?[0,0,0,0]:[t[1],t[2]+this.size[1]/this.board.unitY,t[1]+this.size[0]/this.board.unitX,t[2]]},getAnchorX:function(){var t=o.evaluate(this.visProp.anchorx);if("auto"===t)switch(this.visProp.position){case"top":case"bot":return"middle";case"rt":case"lrt":case"urt":return"left";default:return"right"}return t},getAnchorY:function(){var t=o.evaluate(this.visProp.anchory);if("auto"===t)switch(this.visProp.position){case"top":case"ulft":case"urt":return"bottom";case"bot":case"lrt":case"llft":return"top";default:return"middle"}return t},getNumberofConflicts:function(t,e,i,r){var s,o,n,a,h=0;for(a=this.board.options.precision.hasPoint,this.board.options.precision.hasPoint=.25*(i+r),s=0,n=this.board.objectsList.length;s<n;s++)(o=this.board.objectsList[s]).visPropCalc.visible&&"axis"!==o.elType&&"ticks"!==o.elType&&o!==this.board.infobox&&o!==this&&o.hasPoint(t,e)&&h++;return this.board.options.precision.hasPoint=a,h},setAutoPosition:function(){var t,e,i,r,s,n,a,h,l,c,d,u,p,f,m,g,b=this.size[0],v=this.size[1],y={conflicts:1/0,angle:0,r:0},C=2*Math.PI/12;if(this===this.board.infobox||!this.visPropCalc.visible||!o.evaluate(this.visProp.islabel)||!this.element)return this;if(c=o.evaluate(this.visProp.offset),i=(s=this.element.getLabelAnchor()).scrCoords[1],r=s.scrCoords[2],p=c[0],f=c[1],0===(l=this.getNumberofConflicts(i+p,r-f,b,v)))return this;for(28,h=.2*(d=12),n=Math.atan2(f,p),y.conflicts=l,y.angle=n,y.r=d;y.conflicts>0&&d<28;){for(u=1,a=n+C;u<12&&y.conflicts>0&&(t=i+d*(m=Math.cos(a)),e=r-d*(g=Math.sin(a)),(l=this.getNumberofConflicts(t,e,b,v))<y.conflicts&&(y.conflicts=l,y.angle=a,y.r=d),0!==y.conflicts);u++)a+=C;d+=h}return d=y.r,m=Math.cos(y.angle),g=Math.sin(y.angle),this.visProp.offset=[d*m,d*g],this.visProp.anchorx=m<-.2?"right":m>.2?"left":"middle",this}}),t.createText=function(e,i,r){var s,n=o.copyAttributes(r,e.options,"text"),h=i.slice(0,-1),l=i[i.length-1];if(n.anchor=n.parent||n.anchor,!(s=a.create(t.Text,e,h,n,l)))throw new Error("JSXGraph: Can't create text with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [x,y], [z,x,y], [element,transformation]");return 0!==n.rotate&&"internal"===n.display&&s.addRotation(n.rotate),s},t.registerElement("text",t.createText),t.createHTMLSlider=function(e,i,r){var n,a,l=o.copyAttributes(r,e.options,"htmlslider");if(2!==i.length||2!==i[0].length||3!==i[1].length)throw new Error("JSXGraph: Can't create htmlslider with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parents are: [[x,y], [min, start, max]]");l.anchor=l.parent||l.anchor,l.fixed=l.fixed||!0,a=[i[0][0],i[0][1],'<form style="display:inline"><input type="range" /><span></span><input type="text" /></form>'],(n=t.createText(e,a,l)).type=o.OBJECT_TYPE_HTMLSLIDER,n.rendNodeForm=n.rendNode.childNodes[0],n.rendNodeRange=n.rendNodeForm.childNodes[0],n.rendNodeRange.min=i[1][0],n.rendNodeRange.max=i[1][2],n.rendNodeRange.step=l.step,n.rendNodeRange.value=i[1][1],n.rendNodeLabel=n.rendNodeForm.childNodes[1],n.rendNodeLabel.id=n.rendNode.id+"_label",l.withlabel&&(n.rendNodeLabel.innerHTML=n.name+"="),n.rendNodeOut=n.rendNodeForm.childNodes[2],n.rendNodeOut.value=i[1][1];try{n.rendNodeForm.id=n.rendNode.id+"_form",n.rendNodeRange.id=n.rendNode.id+"_range",n.rendNodeOut.id=n.rendNode.id+"_out"}catch(e){t.debug(e)}return n.rendNodeRange.style.width=l.widthrange+"px",n.rendNodeRange.style.verticalAlign="middle",n.rendNodeOut.style.width=l.widthout+"px",n._val=i[1][1],t.supportsVML()?s.addEvent(n.rendNodeForm,"change",h,n):s.addEvent(n.rendNodeForm,"input",h,n),n.Value=function(){return this._val},n},t.registerElement("htmlslider",t.createHTMLSlider),{Text:t.Text,createText:t.createText,createHTMLSlider:t.createHTMLSlider}})),define("utils/uuid",["jxg"],(function(t){"use strict";var e="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");return t.Util=t.Util||{},t.Util.genUUID=function(t){var i,r,s=[],o=0;for(""!==(t=t||"")&&"-"!==t.substr(t.length-1)&&(t+="-"),r=0;r<36;r++)8===r||13===r||18===r||23===r?s[r]="-":14===r?s[r]="4":(o<=2&&(o=33554432+16777216*Math.random()|0),i=15&o,o>>=4,s[r]=e[19===r?3&i|8:i]);return t+s.join("")},t.Util})),define("parser/jessiecode",["jxg","base/constants","base/text","math/math","math/ia","math/geometry","math/statistics","utils/type","utils/uuid","utils/env"],(function(JXG,Const,Text,Mat,Interval,Geometry,Statistics,Type,UUID,Env){Object.create||(Object.create=function(t,e){if("object"!=typeof t&&"function"!=typeof t)throw new TypeError("Object prototype may only be an Object: "+t);if(null===t)throw new Error("This browser's implementation of Object.create is a shim and doesn't support 'null' as the first argument.");if(void 0!==e)throw new Error("This browser's implementation of Object.create is a shim and doesn't support a second argument.");function i(){}return i.prototype=t,new i});var priv={modules:{math:Mat,"math/geometry":Geometry,"math/statistics":Statistics,"math/numerics":Mat.Numerics}},r,_ccache;JXG.JessieCode=function(t,e){this.scope={id:0,hasChild:!0,args:[],locals:{},context:null,previous:null},this.scopes=[],this.scopes.push(this.scope),this.dpstack=[[]],this.pscope=0,this.propstack=[{}],this.propscope=0,this.lhs=[],this.isLHS=!1,this.warnLog="jcwarn",this.$log=[],this.builtIn=this.defineBuiltIn(),this.board=null,this.lineToElement={},this.parCurLine=1,this.parCurColumn=0,this.line=1,this.col=1,JXG.CA&&(this.CA=new JXG.CA(this.node,this.createNode,this)),this.code="","string"==typeof t&&this.parse(t,e)},JXG.extend(JXG.JessieCode.prototype,{node:function(t,e,i){return{type:t,value:e,children:i}},createNode:function(t,e,i){var r,s=this.node(t,e,[]);for(r=2;r<arguments.length;r++)s.children.push(arguments[r]);return"node_const"==s.type&&Type.isNumber(s.value)&&(s.isMath=!0),s.line=this.parCurLine,s.col=this.parCurColumn,s},pushScope:function(t){var e={args:t,locals:{},context:null,previous:this.scope};return this.scope.hasChild=!0,this.scope=e,e.id=this.scopes.push(e)-1,e},popScope:function(){var t=this.scope.previous;return this.scope=null!==t?t:this.scope,this.scope},getElementById:function(t){return this.board.objects[t]},log:function(){this.$log.push(arguments),"object"==typeof console&&console.log&&console.log.apply(console,arguments)},creator:(_ccache={},(r=function(t){var e,i;return"function"==typeof _ccache[this.board.id+t]?e=_ccache[this.board.id+t]:(i=this,(e=function(e,r){var s;return void 0===(s=Type.exists(r)?r:{}).name&&void 0===s.id&&(s.name=0!==i.lhs[i.scope.id]?i.lhs[i.scope.id]:""),i.board.create(t,e,s)}).creator=!0,_ccache[this.board.id+t]=e),e}).clearCache=function(){_ccache={}},r),letvar:function(t,e){this.builtIn[t]&&this._warn('"'+t+'" is a predefined value.'),this.scope.locals[t]=e},isLocalVariable:function(t){for(var e=this.scope;null!==e;){if(Type.exists(e.locals[t]))return e;e=e.previous}return null},isParameter:function(t){for(var e=this.scope;null!==e;){if(Type.indexOf(e.args,t)>-1)return e;e=e.previous}return null},isCreator:function(t){return!!JXG.elements[t]},isMathMethod:function(t){return"E"!==t&&!!Math[t]},isBuiltIn:function(t){return!!this.builtIn[t]},getvar:function(t,e,i){var r;if(e=Type.def(e,!1),null!==(r=this.isLocalVariable(t)))return r.locals[t];if("$board"===t||"EULER"===t||"PI"===t)return this.builtIn[t];if(i){if(this.isBuiltIn(t))return this.builtIn[t];if(this.isMathMethod(t))return Math[t];if(this.isCreator(t))return this.creator(t)}return e||(r=this.board.select(t))===t?void 0:r},resolve:function(t){for(var e=this.scope;null!==e;){if(Type.exists(e.locals[t]))return e.locals[t];e=e.previous}},getvarJS:function(t,e,i){var r,s="";return e=Type.def(e,!1),i=Type.def(i,!1),null!==this.isParameter(t)?t:null===this.isLocalVariable(t)||i?this.isCreator(t)?"(function () { var a = Array.prototype.slice.call(arguments, 0), props = "+(i?"a.pop()":"{}")+"; return $jc$.board.create.apply($jc$.board, ['"+t+"'].concat([a, props])); })":(i&&this._error("Syntax error (attribute values are allowed with element creators only)"),this.isBuiltIn(t)?(s=this.builtIn[t].src||this.builtIn[t],Type.isNumber(s)||s.match(/board\.select/)?s:(t=s.split(".").pop(),Type.exists(this.board.mathLib)&&null!==(r=new RegExp("^Math."+t)).exec(s)?s.replace(r,"$jc$.board.mathLib."+t):Type.exists(this.board.mathLibJXG)&&null!==(r=new RegExp("^JXG.Math.")).exec(s)?s.replace(r,"$jc$.board.mathLibJXG."):s)):this.isMathMethod(t)?"$jc$.board.mathLib."+t:e?"":(Type.isId(this.board,t)?(s="$jc$.board.objects['"+t+"']","slider"===this.board.objects[t].elType&&(s+=".Value()")):Type.isName(this.board,t)?(s="$jc$.board.elementsByName['"+t+"']","slider"===this.board.elementsByName[t].elType&&(s+=".Value()")):Type.isGroup(this.board,t)&&(s="$jc$.board.groups['"+t+"']"),s)):"$jc$.resolve('"+t+"')"},makeMap:function(t){return t.isMap=!0,t},functionCodeJS:function(t){var e=t.children[0].join(", "),i="",r="";return"op_map"===t.value&&(i="{ return  ",r=" }"),"function ("+e+") {\nvar $oldscope$ = $jc$.scope;\n$jc$.scope = $jc$.scopes["+this.scope.id+"];\nvar r = (function () "+i+this.compile(t.children[1],!0)+r+")();\n$jc$.scope = $oldscope$;\nreturn r;\n}"},defineFunction:function(node){var fun,i,that=this,list=node.children[0],scope=this.pushScope(list),_that;if(this.board.options.jc.compile){for(this.isLHS=!1,i=0;i<list.length;i++)scope.locals[list[i]]=list[i];this.replaceNames(node.children[1]),fun=function($jc$){var fun,str="var f = "+$jc$.functionCodeJS(node)+"; f;";try{for(fun=eval(str),scope.argtypes=[],i=0;i<list.length;i++)scope.argtypes.push(that.resolveType(list[i],node));return fun}catch(t){return $jc$._warn("error compiling function\n\n"+str+"\n\n"+t.toString()),function(){}}}(this),this.popScope()}else fun=function(t,e,i){return function(){var r,s;for(s=e.scope,e.scope=e.scopes[i],r=0;r<t.length;r++)e.scope.locals[t[r]]=arguments[r];return r=e.execute(node.children[1]),e.scope=s,r}}(list,this,scope.id);return fun.node=node,fun.scope=scope,fun.toJS=fun.toString,fun.toString=(_that=this,function(){return _that.compile(_that.replaceIDs(Type.deepCopy(node)))}),fun.deps={},this.collectDependencies(node.children[1],fun.deps),fun},mergeAttributes:function(t){var e,i={};for(e=0;e<arguments.length;e++)i=Type.deepCopy(i,arguments[e],!0);return i},setProp:function(t,e,i){var r,s,o={};t.elementClass!==Const.OBJECT_CLASS_POINT||"X"!==e&&"Y"!==e?t.elementClass!==Const.OBJECT_CLASS_TEXT||"X"!==e&&"Y"!==e?t.type&&t.elementClass&&t.visProp?Type.exists(t[t.methodMap[e]])&&"function"!=typeof t[t.methodMap[e]]?t[t.methodMap[e]]=i:(o[e]=i,t.setAttribute(o)):t[e]=i:("number"==typeof i?t[e]=function(){return i}:"function"==typeof i?(t.isDraggable=!1,t[e]=i):"string"==typeof i&&(t.isDraggable=!1,t[e]=Type.createFunction(i,this.board,null,!0),t[e+"jc"]=i),t[e].origin=i,this.board.update()):(e=e.toLowerCase(),t.isDraggable&&"number"==typeof i?(r="x"===e?i:t.X(),s="y"===e?i:t.Y(),t.setPosition(Const.COORDS_BY_USER,[r,s])):!t.isDraggable||"function"!=typeof i&&"string"!=typeof i?t.isDraggable||(r="x"===e?i:t.XEval.origin,s="y"===e?i:t.YEval.origin,t.addConstraint([r,s])):(r="x"===e?i:t.coords.usrCoords[1],s="y"===e?i:t.coords.usrCoords[2],t.addConstraint([r,s])),this.board.update())},_genericParse:function(t,e,i,r){var s,o,n,a,h=t.replace(/\r\n/g,"\n").split("\n"),l=[];r||(this.code+=t+"\n"),Text&&(o=Text.Text.prototype.setText,Text.Text.prototype.setText=Text.Text.prototype.setTextJessieCode);try{for(Type.exists(i)||(i=!1),s=0;s<h.length;s++)i&&(h[s]=JXG.GeonextParser.geonext2JS(h[s],this.board)),l.push(h[s]);switch(t=l.join("\n"),n=parser.parse(t),this.CA&&(n=this.CA.expandDerivatives(n,null,n),n=this.CA.removeTrivialNodes(n)),e){case"parse":a=this.execute(n);break;case"manipulate":a=this.compile(n);break;case"getAst":a=n;break;default:a=!1}}catch(t){throw t}finally{Text&&(Text.Text.prototype.setText=o)}return a},parse:function(t,e,i){return this._genericParse(t,"parse",e,i)},manipulate:function(t,e,i){return this._genericParse(t,"manipulate",e,i)},getAST:function(t,e,i){return this._genericParse(t,"getAst",e,i)},snippet:function(t,e,i,r){var s;return e=Type.def(e,!0),i=Type.def(i,""),r=Type.def(r,!1),s=(e?" function ("+i+") { return ":"")+t+(e?"; }":"")+";",this.parse(s,r,!0)},replaceIDs:function(t){var e,i;if(t.replaced&&(i=this.board.objects[t.children[1][0].value],Type.exists(i)&&""!==i.name&&(t.type="node_var",t.value=i.name,t.children.length=0,delete t.replaced)),Type.isArray(t))for(e=0;e<t.length;e++)t[e]=this.replaceIDs(t[e]);if(t.children)for(e=t.children.length;e>0;e--)Type.exists(t.children[e-1])&&(t.children[e-1]=this.replaceIDs(t.children[e-1]));return t},replaceNames:function(t){var e,i;if(i=t.value,"node_op"===t.type&&"op_lhs"===i&&1===t.children.length?this.isLHS=!0:"node_var"===t.type&&(this.isLHS?this.letvar(i,!0):!Type.exists(this.getvar(i,!0))&&Type.exists(this.board.elementsByName[i])&&(t=this.createReplacementNode(t))),Type.isArray(t))for(e=0;e<t.length;e++)t[e]=this.replaceNames(t[e]);if(t.children)for(e=t.children.length;e>0;e--)Type.exists(t.children[e-1])&&(t.children[e-1]=this.replaceNames(t.children[e-1]));return"node_op"===t.type&&"op_lhs"===t.value&&1===t.children.length&&(this.isLHS=!1),t},createReplacementNode:function(t){var e=t.value,i=this.board.elementsByName[e];return(t=this.createNode("node_op","op_execfun",this.createNode("node_var","$"),[this.createNode("node_str",i.id)])).replaced=!0,t},collectDependencies:function(t,e){var i,r,s,o;if(Type.isArray(t))for(o=t.length,i=0;i<o;i++)this.collectDependencies(t[i],e);else if(r=t.value,"node_var"===t.type&&(s=this.getvar(r))&&s.visProp&&s.type&&s.elementClass&&s.id&&(e[s.id]=s),"node_op"===t.type&&"op_execfun"===t.value&&t.children.length>1&&"$"===t.children[0].value&&t.children[1].length>0&&(e[s=t.children[1][0].value]=this.board.objects[s]),t.children)for(i=t.children.length;i>0;i--)Type.exists(t.children[i-1])&&this.collectDependencies(t.children[i-1],e)},resolveProperty:function(t,e,i){return i=Type.def(i,!1),t&&t.methodMap&&(Type.exists(t.subs)&&Type.exists(t.subs[e])?t=t.subs:Type.exists(t.methodMap[e])?e=t.methodMap[e]:(t=t.visProp,e=e.toLowerCase())),Type.isFunction(t)&&this._error("Accessing function properties is not allowed."),Type.exists(t)||this._error(t+" is not an object"),Type.exists(t[e])||this._error("unknown property "+e),i&&"function"==typeof t[e]?function(){return t[e].apply(t,arguments)}:t[e]},resolveType:function(t,e){var i,r;if(Type.isArray(e))for(i=0;i<e.length;i++)if("any"!==(r=this.resolveType(t,e[i])))return r;if("node_op"===e.type&&"op_execfun"===e.value&&"node_var"===e.children[0].type&&e.children[0].value===t)return"function";if("node_op"===e.type){for(i=0;i<e.children.length;i++)if("node_var"===e.children[0].type&&e.children[0].value===t&&("op_add"===e.value||"op_sub"===e.value||"op_mul"===e.value||"op_div"===e.value||"op_mod"===e.value||"op_exp"===e.value||"op_neg"===e.value))return"any";for(i=0;i<e.children.length;i++)if("any"!==(r=this.resolveType(t,e.children[i])))return r}return"any"},getLHS:function(t){var e;if("node_var"===t.type)e={o:this.scope.locals,what:t.value};else if("node_op"===t.type&&"op_property"===t.value)e={o:this.execute(t.children[0]),what:t.children[1]};else{if("node_op"!==t.type||"op_extvalue"!==t.value)throw new Error("Syntax error: Invalid left-hand side of assignment.");e={o:this.execute(t.children[0]),what:this.execute(t.children[1])}}return e},getLHSCompiler:function(t,e){var i;if("node_var"===t.type)i=t.value;else if("node_op"===t.type&&"op_property"===t.value)i=[this.compile(t.children[0],e),"'"+t.children[1]+"'"];else{if("node_op"!==t.type||"op_extvalue"!==t.value)throw new Error("Syntax error: Invalid left-hand side of assignment.");i=[this.compile(t.children[0],e),"node_const"===t.children[1].type?t.children[1].value:this.compile(t.children[1],e)]}return i},execute:function(t){var e,i,r,s,o,n,a,h,l,c,d=[];if(e=0,!t)return e;switch(this.line=t.line,this.col=t.col,t.type){case"node_op":switch(t.value){case"op_none":t.children[0]&&this.execute(t.children[0]),t.children[1]&&(e=this.execute(t.children[1]));break;case"op_assign":i=this.getLHS(t.children[0]),this.lhs[this.scope.id]=i.what,i.o.type&&i.o.elementClass&&i.o.methodMap&&"label"===i.what&&this._error("Left-hand side of assignment is read-only."),e=this.execute(t.children[1]),i.o!==this.scope.locals||Type.isArray(i.o)&&"number"==typeof i.what?this.setProp(i.o,i.what,e):this.letvar(i.what,e),this.lhs[this.scope.id]=0;break;case"op_if":this.execute(t.children[0])&&(e=this.execute(t.children[1]));break;case"op_conditional":case"op_if_else":e=this.execute(t.children[0])?this.execute(t.children[1]):this.execute(t.children[2]);break;case"op_while":for(;this.execute(t.children[0]);)this.execute(t.children[1]);break;case"op_do":do{this.execute(t.children[0])}while(this.execute(t.children[1]));break;case"op_for":for(this.execute(t.children[0]);this.execute(t.children[1]);this.execute(t.children[2]))this.execute(t.children[3]);break;case"op_proplst":t.children[0]&&this.execute(t.children[0]),t.children[1]&&this.execute(t.children[1]);break;case"op_emptyobject":e={};break;case"op_proplst_val":this.propstack.push({}),this.propscope++,this.execute(t.children[0]),e=this.propstack[this.propscope],this.propstack.pop(),this.propscope--;break;case"op_prop":this.propstack[this.propscope][t.children[0]]=this.execute(t.children[1]);break;case"op_array":for(e=[],o=t.children[0].length,r=0;r<o;r++)e.push(this.execute(t.children[0][r]));break;case"op_extvalue":e=this.execute(t.children[0]),e="number"==typeof(r=this.execute(t.children[1]))&&Math.abs(Math.round(r)-r)<Mat.eps?e[r]:undefined;break;case"op_return":if(0!==this.scope)return this.execute(t.children[0]);this._error("Unexpected return.");break;case"op_map":t.children[1].isMath||"node_var"===t.children[1].type||this._error("execute: In a map only function calls and mathematical expressions are allowed."),(h=this.defineFunction(t)).isMap=!0,e=h;break;case"op_function":(h=this.defineFunction(t)).isMap=!1,e=h;break;case"op_execfun":if(this.dpstack.push([]),this.pscope++,n=t.children[1],Type.exists(t.children[2]))if(t.children[3])for(a=t.children[2],l={},r=0;r<a.length;r++)l=Type.deepCopy(l,this.execute(a[r]),!0);else l=this.execute(t.children[2]);for(t.children[0]._isFunctionName=!0,h=this.execute(t.children[0]),delete t.children[0]._isFunctionName,c=h&&h.sc?h.sc:this,!h.creator&&Type.exists(t.children[2])&&this._error("Unexpected value. Only element creators are allowed to have a value after the function call."),r=0;r<n.length;r++)Type.exists(h.scope)&&Type.exists(h.scope.argtypes)&&"function"===h.scope.argtypes[r]?(n[r]._isFunctionName=!0,d[r]=this.execute(n[r]),delete n[r]._isFunctionName):d[r]=this.execute(n[r]),this.dpstack[this.pscope].push({line:t.children[1][r].line,col:t.children[1][r].ecol});if("function"!=typeof h||h.creator)if("function"==typeof h&&h.creator){s=this.line;try{for((e=h(d,l)).jcLineStart=s,e.jcLineEnd=t.eline,r=s;r<=t.line;r++)this.lineToElement[r]=e;e.debugParents=this.dpstack[this.pscope]}catch(t){this._error(t.toString())}}else this._error("Function '"+h+"' is undefined.");else e=h.apply(c,d);this.dpstack.pop(),this.pscope--;break;case"op_property":s=this.execute(t.children[0]),i=t.children[1],e=this.resolveProperty(s,i,!1),Type.exists(e)&&(e.sc=s);break;case"op_use":this._warn("Use of the 'use' operator is deprecated."),this.use(t.children[0].toString());break;case"op_delete":this._warn("Use of the 'delete' operator is deprecated. Please use the remove() function."),i=this.getvar(t.children[0]),e=this.del(i);break;case"op_eq":e=this.execute(t.children[0])==this.execute(t.children[1]);break;case"op_neq":e=this.execute(t.children[0])!=this.execute(t.children[1]);break;case"op_approx":e=Math.abs(this.execute(t.children[0])-this.execute(t.children[1]))<Mat.eps;break;case"op_gt":e=this.execute(t.children[0])>this.execute(t.children[1]);break;case"op_lt":e=this.execute(t.children[0])<this.execute(t.children[1]);break;case"op_geq":e=this.execute(t.children[0])>=this.execute(t.children[1]);break;case"op_leq":e=this.execute(t.children[0])<=this.execute(t.children[1]);break;case"op_or":e=this.execute(t.children[0])||this.execute(t.children[1]);break;case"op_and":e=this.execute(t.children[0])&&this.execute(t.children[1]);break;case"op_not":e=!this.execute(t.children[0]);break;case"op_add":e=this.add(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_sub":e=this.sub(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_div":e=this.div(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_mod":e=this.mod(this.execute(t.children[0]),this.execute(t.children[1]),!0);break;case"op_mul":e=this.mul(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_exp":e=this.pow(this.execute(t.children[0]),this.execute(t.children[1]));break;case"op_neg":e=this.neg(this.execute(t.children[0]))}break;case"node_var":e=this.getvar(t.value,!1,t._isFunctionName);break;case"node_const":e=null===t.value?null:Number(t.value);break;case"node_const_bool":e=t.value;break;case"node_str":e=t.value.replace(/\\(.)/,"$1")}return e},compile:function(t,e){var i,r,s,o="";if(Type.exists(e)||(e=!1),!t)return o;switch(t.type){case"node_op":switch(t.value){case"op_none":t.children[0]&&(o=this.compile(t.children[0],e)),t.children[1]&&(o+=this.compile(t.children[1],e));break;case"op_assign":e?(i=this.getLHSCompiler(t.children[0],e),Type.isArray(i)?o="$jc$.setProp("+i[0]+", "+i[1]+", "+this.compile(t.children[1],e)+");\n":(this.isLocalVariable(i)!==this.scope&&(this.scope.locals[i]=!0),o="$jc$.scopes["+this.scope.id+"].locals['"+i+"'] = "+this.compile(t.children[1],e)+";\n")):o=(i=this.compile(t.children[0]))+" = "+this.compile(t.children[1],e)+";\n";break;case"op_if":o=" if ("+this.compile(t.children[0],e)+") "+this.compile(t.children[1],e);break;case"op_if_else":o=" if ("+this.compile(t.children[0],e)+")"+this.compile(t.children[1],e),o+=" else "+this.compile(t.children[2],e);break;case"op_conditional":o="(("+this.compile(t.children[0],e)+")?("+this.compile(t.children[1],e),o+="):("+this.compile(t.children[2],e)+"))";break;case"op_while":o=" while ("+this.compile(t.children[0],e)+") {\n"+this.compile(t.children[1],e)+"}\n";break;case"op_do":o=" do {\n"+this.compile(t.children[0],e)+"} while ("+this.compile(t.children[1],e)+");\n";break;case"op_for":o=" for ("+this.compile(t.children[0],e)+this.compile(t.children[1],e)+"; "+this.compile(t.children[2],e).slice(0,-2)+") {\n"+this.compile(t.children[3],e)+"\n}\n";break;case"op_proplst":t.children[0]&&(o=this.compile(t.children[0],e)+", "),o+=this.compile(t.children[1],e);break;case"op_prop":o=t.children[0]+": "+this.compile(t.children[1],e);break;case"op_emptyobject":o=e?"{}":"<< >>";break;case"op_proplst_val":o=this.compile(t.children[0],e);break;case"op_array":for(s=[],r=0;r<t.children[0].length;r++)s.push(this.compile(t.children[0][r],e));o="["+s.join(", ")+"]";break;case"op_extvalue":o=this.compile(t.children[0],e)+"["+this.compile(t.children[1],e)+"]";break;case"op_return":o=" return "+this.compile(t.children[0],e)+";\n";break;case"op_map":t.children[1].isMath||"node_var"===t.children[1].type||this._error("compile: In a map only function calls and mathematical expressions are allowed."),s=t.children[0],o=e?" $jc$.makeMap(function ("+s.join(", ")+") { return "+this.compile(t.children[1],e)+"; })":"map ("+s.join(", ")+") -> "+this.compile(t.children[1],e);break;case"op_function":s=t.children[0],this.pushScope(s),o=e?this.functionCodeJS(t):" function ("+s.join(", ")+") "+this.compile(t.children[1],e),this.popScope();break;case"op_execfunmath":console.log("op_execfunmath: TODO"),o="-1";break;case"op_execfun":if(t.children[2]){for(s=[],r=0;r<t.children[2].length;r++)s.push(this.compile(t.children[2][r],e));e&&(i="$jc$.mergeAttributes("+s.join(", ")+")")}for(t.children[0].withProps=!!t.children[2],s=[],r=0;r<t.children[1].length;r++)s.push(this.compile(t.children[1][r],e));o=this.compile(t.children[0],e)+"("+s.join(", ")+(t.children[2]&&e?", "+i:"")+")"+(t.children[2]&&!e?i:""),e&&(o+="\n"),e&&"$"===t.children[0].value&&(o="$jc$.board.objects["+this.compile(t.children[1][0],e)+"]");break;case"op_property":o=e&&"X"!==t.children[1]&&"Y"!==t.children[1]?"$jc$.resolveProperty("+this.compile(t.children[0],e)+", '"+t.children[1]+"', true)":this.compile(t.children[0],e)+"."+t.children[1];break;case"op_use":this._warn("Use of the 'use' operator is deprecated."),o=e?"$jc$.use('":"use('",o+=t.children[0].toString()+"');";break;case"op_delete":this._warn("Use of the 'delete' operator is deprecated. Please use the remove() function."),o=e?"$jc$.del(":"remove(",o+=this.compile(t.children[0],e)+")";break;case"op_eq":o="("+this.compile(t.children[0],e)+" === "+this.compile(t.children[1],e)+")";break;case"op_neq":o="("+this.compile(t.children[0],e)+" !== "+this.compile(t.children[1],e)+")";break;case"op_approx":o="("+this.compile(t.children[0],e)+" ~= "+this.compile(t.children[1],e)+")";break;case"op_gt":o=e?"$jc$.gt("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" > "+this.compile(t.children[1],e)+")";break;case"op_lt":o=e?"$jc$.lt("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" < "+this.compile(t.children[1],e)+")";break;case"op_geq":o=e?"$jc$.geq("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" >= "+this.compile(t.children[1],e)+")";break;case"op_leq":o=e?"$jc$.leq("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" <= "+this.compile(t.children[1],e)+")";break;case"op_or":o="("+this.compile(t.children[0],e)+" || "+this.compile(t.children[1],e)+")";break;case"op_and":o="("+this.compile(t.children[0],e)+" && "+this.compile(t.children[1],e)+")";break;case"op_not":o="!("+this.compile(t.children[0],e)+")";break;case"op_add":o=e?"$jc$.add("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" + "+this.compile(t.children[1],e)+")";break;case"op_sub":o=e?"$jc$.sub("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" - "+this.compile(t.children[1],e)+")";break;case"op_div":o=e?"$jc$.div("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" / "+this.compile(t.children[1],e)+")";break;case"op_mod":o=e?"$jc$.mod("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+", true)":"("+this.compile(t.children[0],e)+" % "+this.compile(t.children[1],e)+")";break;case"op_mul":o=e?"$jc$.mul("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+" * "+this.compile(t.children[1],e)+")";break;case"op_exp":o=e?"$jc$.pow("+this.compile(t.children[0],e)+", "+this.compile(t.children[1],e)+")":"("+this.compile(t.children[0],e)+"^"+this.compile(t.children[1],e)+")";break;case"op_neg":o=e?"$jc$.neg("+this.compile(t.children[0],e)+")":"(-"+this.compile(t.children[0],e)+")"}break;case"node_var":o=e?this.getvarJS(t.value,!1,t.withProps):t.value;break;case"node_const":case"node_const_bool":o=t.value;break;case"node_str":o="'"+t.value+"'"}return t.needsBrackets&&(o="{\n"+o+"\n}\n"),o},getName:function(t,e){var i="";return Type.exists(t)&&Type.exists(t.getName)?(i=t.getName(),Type.exists(i)&&""!==i||!e||(i=t.id)):e&&(i=t.id),i},X:function(t){return t.X()},Y:function(t){return t.Y()},V:function(t){return t.Value()},L:function(t){return t.L()},area:function(t){return Type.exists(t)&&Type.exists(t.Area)||this._error("Error: Can't calculate area."),t.Area()},dist:function(t,e){return Type.exists(t)&&Type.exists(t.Dist)||this._error("Error: Can't calculate distance."),t.Dist(e)},radius:function(t){return Type.exists(t)&&Type.exists(t.Radius)||this._error("Error: Can't calculate radius."),t.Radius()},add:function(t,e){var i,r,s;if(t=Type.evalSlider(t),e=Type.evalSlider(e),Interval.isInterval(t)||Interval.isInterval(e))s=Interval.add(t,e);else if(Type.isArray(t)&&Type.isArray(e))for(r=Math.min(t.length,e.length),s=[],i=0;i<r;i++)s[i]=t[i]+e[i];else Type.isNumber(t)&&Type.isNumber(e)?s=t+e:Type.isString(t)||Type.isString(e)?s=t.toString()+e.toString():this._error("Operation + not defined on operands "+typeof t+" and "+typeof e);return s},sub:function(t,e){var i,r,s;if(t=Type.evalSlider(t),e=Type.evalSlider(e),Interval.isInterval(t)||Interval.isInterval(e))s=Interval.sub(t,e);else if(Type.isArray(t)&&Type.isArray(e))for(r=Math.min(t.length,e.length),s=[],i=0;i<r;i++)s[i]=t[i]-e[i];else Type.isNumber(t)&&Type.isNumber(e)?s=t-e:this._error("Operation - not defined on operands "+typeof t+" and "+typeof e);return s},neg:function(t){var e,i,r;if(t=Type.evalSlider(t),Interval.isInterval(t))r=Interval.negative(t);else if(Type.isArray(t))for(i=t.length,r=[],e=0;e<i;e++)r[e]=-t[e];else Type.isNumber(t)?r=-t:this._error("Unary operation - not defined on operand "+typeof t);return r},mul:function(t,e){var i,r,s;if(t=Type.evalSlider(t),e=Type.evalSlider(e),Type.isArray(t)&&Type.isNumber(e)&&(i=t,e=t=e),Interval.isInterval(t)||Interval.isInterval(e))s=Interval.mul(t,e);else if(Type.isArray(t)&&Type.isArray(e))r=Math.min(t.length,e.length),s=Mat.innerProduct(t,e,r);else if(Type.isNumber(t)&&Type.isArray(e))for(r=e.length,s=[],i=0;i<r;i++)s[i]=t*e[i];else Type.isNumber(t)&&Type.isNumber(e)?s=t*e:this._error("Operation * not defined on operands "+typeof t+" and "+typeof e);return s},div:function(t,e){var i,r,s;if(t=Type.evalSlider(t),e=Type.evalSlider(e),Interval.isInterval(t)||Interval.isInterval(e))s=Interval.div(t,e);else if(Type.isArray(t)&&Type.isNumber(e))for(r=t.length,s=[],i=0;i<r;i++)s[i]=t[i]/e;else Type.isNumber(t)&&Type.isNumber(e)?s=t/e:this._error("Operation * not defined on operands "+typeof t+" and "+typeof e);return s},mod:function(t,e){var i,r,s;if(t=Type.evalSlider(t),e=Type.evalSlider(e),Interval.isInterval(t)||Interval.isInterval(e))return Interval.fmod(t,e);if(Type.isArray(t)&&Type.isNumber(e))for(r=t.length,s=[],i=0;i<r;i++)s[i]=Mat.mod(t[i],e,!0);else Type.isNumber(t)&&Type.isNumber(e)?s=Mat.mod(t,e,!0):this._error("Operation * not defined on operands "+typeof t+" and "+typeof e);return s},pow:function(t,e){return t=Type.evalSlider(t),e=Type.evalSlider(e),Interval.isInterval(t)||Interval.isInterval(e)?Interval.pow(t,e):Mat.pow(t,e)},lt:function(t,e){return Interval.isInterval(t)||Interval.isInterval(e)?Interval.lt(t,e):t<e},leq:function(t,e){return Interval.isInterval(t)||Interval.isInterval(e)?Interval.leq(t,e):t<=e},gt:function(t,e){return Interval.isInterval(t)||Interval.isInterval(e)?Interval.gt(t,e):t>e},geq:function(t,e){return Interval.isInterval(t)||Interval.isInterval(e)?Intervalt.geq(t,e):t>=e},randint:function(t,e,i){return Type.exists(i)||(i=1),Math.round(Math.random()*(e-t)/i)*i+t},DDD:function(t){console.log("Dummy derivative function. This should never appear!")},ifthen:function(t,e,i){return t?e:i},del:function(t){"object"==typeof t&&JXG.exists(t.type)&&JXG.exists(t.elementClass)&&this.board.removeObject(t)},use:function(t){var e,i,r=!1;if("string"==typeof t){for(e in JXG.boards)if(JXG.boards.hasOwnProperty(e)&&JXG.boards[e].container===t){i=JXG.boards[e],r=!0;break}}else i=t,r=!0;r?(this.board=i,this.builtIn.$board=i,this.builtIn.$board.src="$jc$.board"):this._error("Board '"+t+"' not found!")},findSymbol:function(t,e){var i,r;for(r=-1===(e=Type.def(e,-1))?this.scope:this.scopes[e];null!==r;){for(i in r.locals)if(r.locals.hasOwnProperty(i)&&r.locals[i]===t)return[i,r];r=r.previous}return[]},importModule:function(t){return priv.modules[t.toLowerCase()]},defineBuiltIn:function(){var t=this,e={PI:Math.PI,EULER:Math.E,D:t.DDD,X:t.X,Y:t.Y,V:t.V,L:t.L,acosh:Mat.acosh,acot:Mat.acot,asinh:Mat.asinh,binomial:Mat.binomial,cbrt:Mat.cbrt,cosh:Mat.cosh,cot:Mat.cot,deg:Geometry.trueAngle,A:t.area,area:t.area,dist:t.dist,R:t.radius,radius:t.radius,erf:Mat.erf,erfc:Mat.erfc,erfi:Mat.erfi,factorial:Mat.factorial,gcd:Mat.gcd,lb:Mat.log2,lcm:Mat.lcm,ld:Mat.log2,lg:Mat.log10,ln:Math.log,log:Mat.log,log10:Mat.log10,log2:Mat.log2,ndtr:Mat.ndtr,ndtri:Mat.ndtri,nthroot:Mat.nthroot,pow:Mat.pow,rad:Geometry.rad,ratpow:Mat.ratpow,trunc:Type.trunc,sinh:Mat.sinh,randint:t.randint,IfThen:t.ifthen,import:t.importModule,use:t.use,remove:t.del,$:t.getElementById,getName:t.getName,name:t.getName,$board:t.board,$log:t.log};return e.rad.sc=Geometry,e.deg.sc=Geometry,e.factorial.sc=Mat,e.X.src="$jc$.X",e.Y.src="$jc$.Y",e.V.src="$jc$.V",e.L.src="$jc$.L",e.acosh.src="JXG.Math.acosh",e.acot.src="JXG.Math.acot",e.asinh.src="JXG.Math.asinh",e.binomial.src="JXG.Math.binomial",e.cbrt.src="JXG.Math.cbrt",e.cot.src="JXG.Math.cot",e.cosh.src="JXG.Math.cosh",e.deg.src="JXG.Math.Geometry.trueAngle",e.erf.src="JXG.Math.erf",e.erfc.src="JXG.Math.erfc",e.erfi.src="JXG.Math.erfi",e.A.src="$jc$.area",e.area.src="$jc$.area",e.dist.src="$jc$.dist",e.R.src="$jc$.radius",e.radius.src="$jc$.radius",e.factorial.src="JXG.Math.factorial",e.gcd.src="JXG.Math.gcd",e.lb.src="JXG.Math.log2",e.lcm.src="JXG.Math.lcm",e.ld.src="JXG.Math.log2",e.lg.src="JXG.Math.log10",e.ln.src="Math.log",e.log.src="JXG.Math.log",e.log10.src="JXG.Math.log10",e.log2.src="JXG.Math.log2",e.ndtr.src="JXG.Math.ndtr",e.ndtri.src="JXG.Math.ndtri",e.nthroot.src="JXG.Math.nthroot",e.pow.src="JXG.Math.pow",e.rad.src="JXG.Math.Geometry.rad",e.ratpow.src="JXG.Math.ratpow",e.trunc.src="JXG.trunc",e.sinh.src="JXG.Math.sinh",e.randint.src="$jc$.randint",e.import.src="$jc$.importModule",e.use.src="$jc$.use",e.remove.src="$jc$.del",e.IfThen.src="$jc$.ifthen",e.$.src="(function (n) { return $jc$.board.select(n); })",e.getName.src="$jc$.getName",e.name.src="$jc$.getName",e.$board&&(e.$board.src="$jc$.board"),e.$log.src="$jc$.log",e},_debug:function(t){"object"==typeof console?console.log(t):Env.isBrowser&&document&&null!==document.getElementById("debug")&&(document.getElementById("debug").innerHTML+=t+"<br />")},_error:function(t){var e=new Error("Error("+this.line+"): "+t);throw e.line=this.line,e},_warn:function(t){"object"==typeof console?console.log("Warning("+this.line+"): "+t):Env.isBrowser&&document&&null!==document.getElementById(this.warnLog)&&(document.getElementById(this.warnLog).innerHTML+="Warning("+this.line+"): "+t+"<br />")},_log:function(t){"object"!=typeof window&&"object"==typeof self&&self.postMessage?self.postMessage({type:"log",msg:"Log: "+t.toString()}):console.log("Log: ",arguments)}});var parser=function(){var t=function(t,e,i,r){for(i=i||{},r=t.length;r--;i[t[r]]=e);return i},e=[2,14],i=[1,13],r=[1,37],s=[1,14],o=[1,15],n=[1,21],a=[1,16],h=[1,17],l=[1,33],c=[1,18],d=[1,19],u=[1,12],p=[1,59],f=[1,60],m=[1,58],g=[1,46],b=[1,48],v=[1,49],y=[1,50],C=[1,51],_=[1,52],P=[1,53],E=[1,54],S=[1,45],x=[1,38],O=[1,39],w=[5,7,8,14,15,16,17,19,20,21,23,26,27,50,51,58,65,74,75,76,77,78,79,80,82,91,93],T=[5,7,8,12,14,15,16,17,19,20,21,23,26,27,50,51,58,65,74,75,76,77,78,79,80,82,91,93],N=[8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,83,86],M=[2,48],A=[1,72],R=[10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,66,83,86],L=[1,78],k=[8,10,16,32,34,35,37,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,83,86],B=[1,82],I=[8,10,16,32,34,35,37,39,45,46,47,48,50,51,53,54,55,57,64,65,66,83,86],Y=[1,83],D=[1,84],j=[1,85],X=[8,10,16,32,34,35,37,39,41,42,43,50,51,53,54,55,57,64,65,66,83,86],U=[1,89],F=[1,90],J=[1,91],G=[1,92],z=[1,97],H=[8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,53,54,55,57,64,65,66,83,86],V=[1,103],$=[1,104],q=[8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,57,64,65,66,83,86],W=[1,105],Q=[1,106],Z=[1,107],K=[1,126],tt=[1,139],et=[83,86],it=[1,150],rt=[10,66,86],st=[8,10,16,20,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,82,83,86],ot=[1,167],nt=[10,86],at={trace:function(){},yy:{},symbols_:{error:2,Program:3,StatementList:4,EOF:5,IfStatement:6,IF:7,"(":8,Expression:9,")":10,Statement:11,ELSE:12,LoopStatement:13,WHILE:14,FOR:15,";":16,DO:17,UnaryStatement:18,USE:19,IDENTIFIER:20,DELETE:21,ReturnStatement:22,RETURN:23,EmptyStatement:24,StatementBlock:25,"{":26,"}":27,ExpressionStatement:28,AssignmentExpression:29,ConditionalExpression:30,LeftHandSideExpression:31,"=":32,LogicalORExpression:33,"?":34,":":35,LogicalANDExpression:36,"||":37,EqualityExpression:38,"&&":39,RelationalExpression:40,"==":41,"!=":42,"~=":43,AdditiveExpression:44,"<":45,">":46,"<=":47,">=":48,MultiplicativeExpression:49,"+":50,"-":51,UnaryExpression:52,"*":53,"/":54,"%":55,ExponentExpression:56,"^":57,"!":58,MemberExpression:59,CallExpression:60,PrimaryExpression:61,FunctionExpression:62,MapExpression:63,".":64,"[":65,"]":66,BasicLiteral:67,ObjectLiteral:68,ArrayLiteral:69,NullLiteral:70,BooleanLiteral:71,StringLiteral:72,NumberLiteral:73,NULL:74,TRUE:75,FALSE:76,STRING:77,NUMBER:78,NAN:79,INFINITY:80,ElementList:81,"<<":82,">>":83,PropertyList:84,Property:85,",":86,PropertyName:87,Arguments:88,AttributeList:89,Attribute:90,FUNCTION:91,ParameterDefinitionList:92,MAP:93,"->":94,$accept:0,$end:1},terminals_:{2:"error",5:"EOF",7:"IF",8:"(",10:")",12:"ELSE",14:"WHILE",15:"FOR",16:";",17:"DO",19:"USE",20:"IDENTIFIER",21:"DELETE",23:"RETURN",26:"{",27:"}",32:"=",34:"?",35:":",37:"||",39:"&&",41:"==",42:"!=",43:"~=",45:"<",46:">",47:"<=",48:">=",50:"+",51:"-",53:"*",54:"/",55:"%",57:"^",58:"!",64:".",65:"[",66:"]",74:"NULL",75:"TRUE",76:"FALSE",77:"STRING",78:"NUMBER",79:"NAN",80:"INFINITY",82:"<<",83:">>",86:",",91:"FUNCTION",93:"MAP",94:"->"},productions_:[0,[3,2],[6,5],[6,7],[13,5],[13,9],[13,7],[18,2],[18,2],[22,2],[22,3],[24,1],[25,3],[4,2],[4,0],[11,1],[11,1],[11,1],[11,1],[11,1],[11,1],[11,1],[28,2],[9,1],[29,1],[29,3],[30,1],[30,5],[33,1],[33,3],[36,1],[36,3],[38,1],[38,3],[38,3],[38,3],[40,1],[40,3],[40,3],[40,3],[40,3],[44,1],[44,3],[44,3],[49,1],[49,3],[49,3],[49,3],[56,1],[56,3],[52,1],[52,2],[52,2],[52,2],[31,1],[31,1],[59,1],[59,1],[59,1],[59,3],[59,4],[61,1],[61,1],[61,1],[61,1],[61,3],[67,1],[67,1],[67,1],[67,1],[70,1],[71,1],[71,1],[72,1],[73,1],[73,1],[73,1],[69,2],[69,3],[68,2],[68,3],[84,1],[84,3],[85,3],[87,1],[87,1],[87,1],[60,2],[60,3],[60,2],[60,4],[60,3],[88,2],[88,3],[89,1],[89,3],[90,1],[90,1],[81,1],[81,3],[62,4],[62,5],[63,5],[63,6],[92,1],[92,3]],performAction:function(t,e,i,r,s,o,n){var a=o.length-1;switch(s){case 1:return o[a-1];case 2:this.$=ht.createNode(lt(n[a-4]),"node_op","op_if",o[a-2],o[a]);break;case 3:this.$=ht.createNode(lt(n[a-6]),"node_op","op_if_else",o[a-4],o[a-2],o[a]);break;case 4:this.$=ht.createNode(lt(n[a-4]),"node_op","op_while",o[a-2],o[a]);break;case 5:this.$=ht.createNode(lt(n[a-8]),"node_op","op_for",o[a-6],o[a-4],o[a-2],o[a]);break;case 6:this.$=ht.createNode(lt(n[a-6]),"node_op","op_do",o[a-5],o[a-2]);break;case 7:this.$=ht.createNode(lt(n[a-1]),"node_op","op_use",o[a]);break;case 8:this.$=ht.createNode(lt(n[a-1]),"node_op","op_delete",o[a]);break;case 9:this.$=ht.createNode(lt(n[a-1]),"node_op","op_return",void 0);break;case 10:this.$=ht.createNode(lt(n[a-2]),"node_op","op_return",o[a-1]);break;case 11:case 14:this.$=ht.createNode(lt(n[a]),"node_op","op_none");break;case 12:this.$=o[a-1],this.$.needsBrackets=!0;break;case 13:this.$=ht.createNode(lt(n[a-1]),"node_op","op_none",o[a-1],o[a]);break;case 15:case 16:case 17:case 18:case 19:case 20:case 21:case 23:case 24:case 26:case 28:case 30:case 32:case 36:case 41:case 44:case 48:case 50:case 52:case 54:case 55:case 56:case 58:case 62:case 81:case 84:case 85:case 86:this.$=o[a];break;case 22:case 65:case 93:this.$=o[a-1];break;case 25:this.$=ht.createNode(lt(n[a-2]),"node_op","op_assign",o[a-2],o[a]),this.$.isMath=!1;break;case 27:this.$=ht.createNode(lt(n[a-4]),"node_op","op_conditional",o[a-4],o[a-2],o[a]),this.$.isMath=!1;break;case 29:this.$=ht.createNode(lt(n[a-2]),"node_op","op_or",o[a-2],o[a]),this.$.isMath=!1;break;case 31:this.$=ht.createNode(lt(n[a-2]),"node_op","op_and",o[a-2],o[a]),this.$.isMath=!1;break;case 33:this.$=ht.createNode(lt(n[a-2]),"node_op","op_eq",o[a-2],o[a]),this.$.isMath=!1;break;case 34:this.$=ht.createNode(lt(n[a-2]),"node_op","op_neq",o[a-2],o[a]),this.$.isMath=!1;break;case 35:this.$=ht.createNode(lt(n[a-2]),"node_op","op_approx",o[a-2],o[a]),this.$.isMath=!1;break;case 37:this.$=ht.createNode(lt(n[a-2]),"node_op","op_lt",o[a-2],o[a]),this.$.isMath=!1;break;case 38:this.$=ht.createNode(lt(n[a-2]),"node_op","op_gt",o[a-2],o[a]),this.$.isMath=!1;break;case 39:this.$=ht.createNode(lt(n[a-2]),"node_op","op_leq",o[a-2],o[a]),this.$.isMath=!1;break;case 40:this.$=ht.createNode(lt(n[a-2]),"node_op","op_geq",o[a-2],o[a]),this.$.isMath=!1;break;case 42:this.$=ht.createNode(lt(n[a-2]),"node_op","op_add",o[a-2],o[a]),this.$.isMath=!0;break;case 43:this.$=ht.createNode(lt(n[a-2]),"node_op","op_sub",o[a-2],o[a]),this.$.isMath=!0;break;case 45:this.$=ht.createNode(lt(n[a-2]),"node_op","op_mul",o[a-2],o[a]),this.$.isMath=!0;break;case 46:this.$=ht.createNode(lt(n[a-2]),"node_op","op_div",o[a-2],o[a]),this.$.isMath=!0;break;case 47:this.$=ht.createNode(lt(n[a-2]),"node_op","op_mod",o[a-2],o[a]),this.$.isMath=!0;break;case 49:this.$=ht.createNode(lt(n[a-2]),"node_op","op_exp",o[a-2],o[a]),this.$.isMath=!0;break;case 51:this.$=ht.createNode(lt(n[a-1]),"node_op","op_not",o[a]),this.$.isMath=!1;break;case 53:this.$=ht.createNode(lt(n[a-1]),"node_op","op_neg",o[a]),this.$.isMath=!0;break;case 57:case 63:case 64:case 66:case 67:case 68:case 97:this.$=o[a],this.$.isMath=!1;break;case 59:case 91:this.$=ht.createNode(lt(n[a-2]),"node_op","op_property",o[a-2],o[a]),this.$.isMath=!0;break;case 60:case 90:this.$=ht.createNode(lt(n[a-3]),"node_op","op_extvalue",o[a-3],o[a-1]),this.$.isMath=!0;break;case 61:this.$=ht.createNode(lt(n[a]),"node_var",o[a]);break;case 69:this.$=o[a],this.$.isMath=!0;break;case 70:this.$=ht.createNode(lt(n[a]),"node_const",null);break;case 71:this.$=ht.createNode(lt(n[a]),"node_const_bool",!0);break;case 72:this.$=ht.createNode(lt(n[a]),"node_const_bool",!1);break;case 73:this.$=ht.createNode(lt(n[a]),"node_str",o[a].substring(1,o[a].length-1));break;case 74:this.$=ht.createNode(lt(n[a]),"node_const",parseFloat(o[a]));break;case 75:this.$=ht.createNode(lt(n[a]),"node_const",NaN);break;case 76:this.$=ht.createNode(lt(n[a]),"node_const",1/0);break;case 77:this.$=ht.createNode(lt(n[a-1]),"node_op","op_array",[]);break;case 78:this.$=ht.createNode(lt(n[a-2]),"node_op","op_array",o[a-1]);break;case 79:this.$=ht.createNode(lt(n[a-1]),"node_op","op_emptyobject",{}),this.$.needsBrackets=!0;break;case 80:this.$=ht.createNode(lt(n[a-2]),"node_op","op_proplst_val",o[a-1]),this.$.needsBrackets=!0;break;case 82:this.$=ht.createNode(lt(n[a-2]),"node_op","op_proplst",o[a-2],o[a]);break;case 83:this.$=ht.createNode(lt(n[a-2]),"node_op","op_prop",o[a-2],o[a]);break;case 87:case 89:this.$=ht.createNode(lt(n[a-1]),"node_op","op_execfun",o[a-1],o[a]),this.$.isMath=!0;break;case 88:this.$=ht.createNode(lt(n[a-2]),"node_op","op_execfun",o[a-2],o[a-1],o[a],!0),this.$.isMath=!1;break;case 92:this.$=[];break;case 94:case 98:case 104:this.$=[o[a]];break;case 95:case 99:case 105:this.$=o[a-2].concat(o[a]);break;case 96:this.$=ht.createNode(lt(n[a]),"node_var",o[a]),this.$.isMath=!0;break;case 100:this.$=ht.createNode(lt(n[a-3]),"node_op","op_function",[],o[a]),this.$.isMath=!1;break;case 101:this.$=ht.createNode(lt(n[a-4]),"node_op","op_function",o[a-2],o[a]),this.$.isMath=!1;break;case 102:this.$=ht.createNode(lt(n[a-4]),"node_op","op_map",[],o[a]);break;case 103:this.$=ht.createNode(lt(n[a-5]),"node_op","op_map",o[a-3],o[a])}},table:[t([5,7,8,14,15,16,17,19,20,21,23,26,50,51,58,65,74,75,76,77,78,79,80,82,91,93],e,{3:1,4:2}),{1:[3]},{5:[1,3],6:6,7:i,8:r,9:20,11:4,13:7,14:s,15:o,16:n,17:a,18:8,19:h,20:l,21:c,22:9,23:d,24:11,25:5,26:u,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{1:[2,1]},t(w,[2,13]),t(T,[2,15]),t(T,[2,16]),t(T,[2,17]),t(T,[2,18]),t(T,[2,19]),t(T,[2,20]),t(T,[2,21]),t([7,8,14,15,16,17,19,20,21,23,26,27,50,51,58,65,74,75,76,77,78,79,80,82,91,93],e,{4:61}),{8:[1,62]},{8:[1,63]},{8:[1,64]},{6:6,7:i,8:r,9:20,11:65,13:7,14:s,15:o,16:n,17:a,18:8,19:h,20:l,21:c,22:9,23:d,24:11,25:5,26:u,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{20:[1,66]},{20:[1,67]},{8:r,9:69,16:[1,68],20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{16:[1,70]},t(T,[2,11]),t(N,[2,23]),t(N,[2,24]),t([8,10,16,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,64,65,66,83,86],M,{32:[1,71],57:A}),t([8,10,16,32,35,39,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,83,86],[2,26],{34:[1,73],37:[1,74]}),t(R,[2,54],{88:77,8:L,64:[1,75],65:[1,76]}),t(R,[2,55],{88:79,8:L,64:[1,81],65:[1,80]}),t(k,[2,28],{39:B}),t(N,[2,56]),t(N,[2,57]),t(N,[2,58]),t(I,[2,30],{41:Y,42:D,43:j}),t(N,[2,61]),t(N,[2,62]),t(N,[2,63]),t(N,[2,64]),{8:r,9:86,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:[1,87]},{8:[1,88]},t(X,[2,32],{45:U,46:F,47:J,48:G}),t(N,[2,66]),t(N,[2,67]),t(N,[2,68]),t(N,[2,69]),{20:z,72:98,73:99,77:C,78:_,79:P,80:E,83:[1,93],84:94,85:95,87:96},{8:r,20:l,29:102,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,66:[1,100],67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,81:101,82:S,91:x,93:O},t(H,[2,36],{50:V,51:$}),t(N,[2,70]),t(N,[2,71]),t(N,[2,72]),t(N,[2,73]),t(N,[2,74]),t(N,[2,75]),t(N,[2,76]),t(q,[2,41],{53:W,54:Q,55:Z}),t(N,[2,44]),t(N,[2,50]),{8:r,20:l,31:109,50:p,51:f,52:108,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,50:p,51:f,52:110,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,50:p,51:f,52:111,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{6:6,7:i,8:r,9:20,11:4,13:7,14:s,15:o,16:n,17:a,18:8,19:h,20:l,21:c,22:9,23:d,24:11,25:5,26:u,27:[1,112],28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,9:113,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,9:114,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,9:115,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{14:[1,116]},t(T,[2,7]),t(T,[2,8]),t(T,[2,9]),{16:[1,117]},t(T,[2,22]),{8:r,20:l,29:118,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,50:p,51:f,52:119,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,29:120,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,36:121,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{20:[1,122]},{8:r,9:123,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},t(N,[2,87],{89:124,90:125,68:127,20:K,82:S}),{8:r,10:[1,128],20:l,29:102,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,81:129,82:S,91:x,93:O},t(N,[2,89]),{8:r,9:130,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{20:[1,131]},{8:r,20:l,31:109,38:132,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,40:133,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,40:134,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,40:135,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{10:[1,136]},{10:[1,137],20:tt,92:138},{10:[1,140],20:tt,92:141},{8:r,20:l,31:109,44:142,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,44:143,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,44:144,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,44:145,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},t(N,[2,79]),{83:[1,146],86:[1,147]},t(et,[2,81]),{35:[1,148]},{35:[2,84]},{35:[2,85]},{35:[2,86]},t(N,[2,77]),{66:[1,149],86:it},t(rt,[2,98]),{8:r,20:l,31:109,49:151,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,49:152,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,50:p,51:f,52:153,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,50:p,51:f,52:154,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,31:109,50:p,51:f,52:155,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},t(N,[2,51]),t([8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,64,65,66,83,86],M,{57:A}),t(N,[2,52]),t(N,[2,53]),t([5,7,8,10,12,14,15,16,17,19,20,21,23,26,27,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,58,64,65,66,74,75,76,77,78,79,80,82,83,86,91,93],[2,12]),{10:[1,156]},{10:[1,157]},{16:[1,158]},{8:[1,159]},t(T,[2,10]),t(N,[2,25]),t(N,[2,49]),{35:[1,160]},t(k,[2,29],{39:B}),t(N,[2,59]),{66:[1,161]},t([8,10,16,32,34,35,37,39,41,42,43,45,46,47,48,50,51,53,54,55,57,64,65,66,83],[2,88],{86:[1,162]}),t(N,[2,94]),t(N,[2,96]),t(N,[2,97]),t(st,[2,92]),{10:[1,163],86:it},{66:[1,164]},t(N,[2,91]),t(I,[2,31],{41:Y,42:D,43:j}),t(X,[2,33],{45:U,46:F,47:J,48:G}),t(X,[2,34],{45:U,46:F,47:J,48:G}),t(X,[2,35],{45:U,46:F,47:J,48:G}),t(N,[2,65]),{25:165,26:u},{10:[1,166],86:ot},t(nt,[2,104]),{94:[1,168]},{10:[1,169],86:ot},t(H,[2,37],{50:V,51:$}),t(H,[2,38],{50:V,51:$}),t(H,[2,39],{50:V,51:$}),t(H,[2,40],{50:V,51:$}),t(N,[2,80]),{20:z,72:98,73:99,77:C,78:_,79:P,80:E,85:170,87:96},{8:r,20:l,29:171,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},t(N,[2,78]),{8:r,20:l,29:172,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},t(q,[2,42],{53:W,54:Q,55:Z}),t(q,[2,43],{53:W,54:Q,55:Z}),t(N,[2,45]),t(N,[2,46]),t(N,[2,47]),{6:6,7:i,8:r,9:20,11:173,13:7,14:s,15:o,16:n,17:a,18:8,19:h,20:l,21:c,22:9,23:d,24:11,25:5,26:u,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{6:6,7:i,8:r,9:20,11:174,13:7,14:s,15:o,16:n,17:a,18:8,19:h,20:l,21:c,22:9,23:d,24:11,25:5,26:u,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,9:175,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,9:176,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,20:l,29:177,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},t(N,[2,60]),{20:K,68:127,82:S,90:178},t(st,[2,93]),t(N,[2,90]),t(N,[2,100]),{25:179,26:u},{20:[1,180]},{8:r,9:181,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{94:[1,182]},t(et,[2,82]),t(et,[2,83]),t(rt,[2,99]),t(w,[2,2],{12:[1,183]}),t(T,[2,4]),{16:[1,184]},{10:[1,185]},t(N,[2,27]),t(N,[2,95]),t(N,[2,101]),t(nt,[2,105]),t(N,[2,102]),{8:r,9:186,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{6:6,7:i,8:r,9:20,11:187,13:7,14:s,15:o,16:n,17:a,18:8,19:h,20:l,21:c,22:9,23:d,24:11,25:5,26:u,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{8:r,9:188,20:l,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},{16:[1,189]},t(N,[2,103]),t(T,[2,3]),{10:[1,190]},t(T,[2,6]),{6:6,7:i,8:r,9:20,11:191,13:7,14:s,15:o,16:n,17:a,18:8,19:h,20:l,21:c,22:9,23:d,24:11,25:5,26:u,28:10,29:22,30:23,31:24,33:25,36:28,38:32,40:40,44:47,49:55,50:p,51:f,52:56,56:57,58:m,59:26,60:27,61:29,62:30,63:31,65:g,67:34,68:35,69:36,70:41,71:42,72:43,73:44,74:b,75:v,76:y,77:C,78:_,79:P,80:E,82:S,91:x,93:O},t(T,[2,5])],defaultActions:{3:[2,1],97:[2,84],98:[2,85],99:[2,86]},parseError:function(t,e){if(!e.recoverable){var i=new Error(t);throw i.hash=e,i}this.trace(t)},parse:function(t){var e=this,i=[0],r=[null],s=[],o=this.table,n="",a=0,h=0,l=0,c=2,d=1,u=s.slice.call(arguments,1),p=Object.create(this.lexer),f={yy:{}};for(var m in this.yy)Object.prototype.hasOwnProperty.call(this.yy,m)&&(f.yy[m]=this.yy[m]);p.setInput(t,f.yy),f.yy.lexer=p,f.yy.parser=this,void 0===p.yylloc&&(p.yylloc={});var g=p.yylloc;s.push(g);var b=p.options&&p.options.ranges;"function"==typeof f.yy.parseError?this.parseError=f.yy.parseError:this.parseError=Object.getPrototypeOf(this).parseError;for(var v,y,C,_,P,E,S,x,O,w=function(){var t;return"number"!=typeof(t=p.lex()||d)&&(t=e.symbols_[t]||t),t},T={};;){if(C=i[i.length-1],this.defaultActions[C]?_=this.defaultActions[C]:(null==v&&(v=w()),_=o[C]&&o[C][v]),void 0===_||!_.length||!_[0]){var N="";for(E in O=[],o[C])this.terminals_[E]&&E>c&&O.push("'"+this.terminals_[E]+"'");N=p.showPosition?"Parse error on line "+(a+1)+":\n"+p.showPosition()+"\nExpecting "+O.join(", ")+", got '"+(this.terminals_[v]||v)+"'":"Parse error on line "+(a+1)+": Unexpected "+(v==d?"end of input":"'"+(this.terminals_[v]||v)+"'"),this.parseError(N,{text:p.match,token:this.terminals_[v]||v,line:p.yylineno,loc:g,expected:O})}if(_[0]instanceof Array&&_.length>1)throw new Error("Parse Error: multiple actions possible at state: "+C+", token: "+v);switch(_[0]){case 1:i.push(v),r.push(p.yytext),s.push(p.yylloc),i.push(_[1]),v=null,y?(v=y,y=null):(h=p.yyleng,n=p.yytext,a=p.yylineno,g=p.yylloc,l>0&&l--);break;case 2:if(S=this.productions_[_[1]][1],T.$=r[r.length-S],T._$={first_line:s[s.length-(S||1)].first_line,last_line:s[s.length-1].last_line,first_column:s[s.length-(S||1)].first_column,last_column:s[s.length-1].last_column},b&&(T._$.range=[s[s.length-(S||1)].range[0],s[s.length-1].range[1]]),void 0!==(P=this.performAction.apply(T,[n,h,a,f.yy,_[1],r,s].concat(u))))return P;S&&(i=i.slice(0,-1*S*2),r=r.slice(0,-1*S),s=s.slice(0,-1*S)),i.push(this.productions_[_[1]][0]),r.push(T.$),s.push(T._$),x=o[i[i.length-2]][i[i.length-1]],i.push(x);break;case 3:return!0}}return!0}},ht={node:function(t,e,i){return{type:t,value:e,children:i}},createNode:function(t,e,i,r){var s,o=this.node(e,i,[]);for(s=3;s<arguments.length;s++)o.children.push(arguments[s]);return o.line=t[0],o.col=t[1],o.eline=t[2],o.ecol=t[3],o}},lt=function(t){return[t.first_line,t.first_column,t.last_line,t.last_column]},ct=function(){var t={EOF:1,parseError:function(t,e){if(!this.yy.parser)throw new Error(t);this.yy.parser.parseError(t,e)},setInput:function(t,e){return this.yy=e||this.yy||{},this._input=t,this._more=this._backtrack=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this.options.ranges&&(this.yylloc.range=[0,0]),this.offset=0,this},input:function(){var t=this._input[0];return this.yytext+=t,this.yyleng++,this.offset++,this.match+=t,this.matched+=t,t.match(/(?:\r\n?|\n).*/g)?(this.yylineno++,this.yylloc.last_line++):this.yylloc.last_column++,this.options.ranges&&this.yylloc.range[1]++,this._input=this._input.slice(1),t},unput:function(t){var e=t.length,i=t.split(/(?:\r\n?|\n)/g);this._input=t+this._input,this.yytext=this.yytext.substr(0,this.yytext.length-e),this.offset-=e;var r=this.match.split(/(?:\r\n?|\n)/g);this.match=this.match.substr(0,this.match.length-1),this.matched=this.matched.substr(0,this.matched.length-1),i.length-1&&(this.yylineno-=i.length-1);var s=this.yylloc.range;return this.yylloc={first_line:this.yylloc.first_line,last_line:this.yylineno+1,first_column:this.yylloc.first_column,last_column:i?(i.length===r.length?this.yylloc.first_column:0)+r[r.length-i.length].length-i[0].length:this.yylloc.first_column-e},this.options.ranges&&(this.yylloc.range=[s[0],s[0]+this.yyleng-e]),this.yyleng=this.yytext.length,this},more:function(){return this._more=!0,this},reject:function(){return this.options.backtrack_lexer?(this._backtrack=!0,this):this.parseError("Lexical error on line "+(this.yylineno+1)+". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},less:function(t){this.unput(this.match.slice(t))},pastInput:function(){var t=this.matched.substr(0,this.matched.length-this.match.length);return(t.length>20?"...":"")+t.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var t=this.match;return t.length<20&&(t+=this._input.substr(0,20-t.length)),(t.substr(0,20)+(t.length>20?"...":"")).replace(/\n/g,"")},showPosition:function(){var t=this.pastInput(),e=new Array(t.length+1).join("-");return t+this.upcomingInput()+"\n"+e+"^"},test_match:function(t,e){var i,r,s;if(this.options.backtrack_lexer&&(s={yylineno:this.yylineno,yylloc:{first_line:this.yylloc.first_line,last_line:this.last_line,first_column:this.yylloc.first_column,last_column:this.yylloc.last_column},yytext:this.yytext,match:this.match,matches:this.matches,matched:this.matched,yyleng:this.yyleng,offset:this.offset,_more:this._more,_input:this._input,yy:this.yy,conditionStack:this.conditionStack.slice(0),done:this.done},this.options.ranges&&(s.yylloc.range=this.yylloc.range.slice(0))),(r=t[0].match(/(?:\r\n?|\n).*/g))&&(this.yylineno+=r.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:r?r[r.length-1].length-r[r.length-1].match(/\r?\n?/)[0].length:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.matches=t,this.yyleng=this.yytext.length,this.options.ranges&&(this.yylloc.range=[this.offset,this.offset+=this.yyleng]),this._more=!1,this._backtrack=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],i=this.performAction.call(this,this.yy,this,e,this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),i)return i;if(this._backtrack){for(var o in s)this[o]=s[o];return!1}return!1},next:function(){if(this.done)return this.EOF;var t,e,i,r;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var s=this._currentRules(),o=0;o<s.length;o++)if((i=this._input.match(this.rules[s[o]]))&&(!e||i[0].length>e[0].length)){if(e=i,r=o,this.options.backtrack_lexer){if(!1!==(t=this.test_match(i,s[o])))return t;if(this._backtrack){e=!1;continue}return!1}if(!this.options.flex)break}return e?!1!==(t=this.test_match(e,s[r]))&&t:""===this._input?this.EOF:this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var t=this.next();return t||this.lex()},begin:function(t){this.conditionStack.push(t)},popState:function(){return this.conditionStack.length-1>0?this.conditionStack.pop():this.conditionStack[0]},_currentRules:function(){return this.conditionStack.length&&this.conditionStack[this.conditionStack.length-1]?this.conditions[this.conditionStack[this.conditionStack.length-1]].rules:this.conditions.INITIAL.rules},topState:function(t){return(t=this.conditionStack.length-1-Math.abs(t||0))>=0?this.conditionStack[t]:"INITIAL"},pushState:function(t){this.begin(t)},stateStackSize:function(){return this.conditionStack.length},options:{},performAction:function(t,e,i,r){switch(i){case 0:case 5:case 6:break;case 1:case 2:return 78;case 3:case 4:return 77;case 7:return 7;case 8:return 12;case 9:return 14;case 10:return 17;case 11:return 15;case 12:return 91;case 13:return 93;case 14:return 19;case 15:return 23;case 16:return 21;case 17:return 75;case 18:return 76;case 19:return 74;case 20:return 80;case 21:case 22:return 94;case 23:return 82;case 24:return 83;case 25:return 26;case 26:return 27;case 27:return 16;case 28:return"#";case 29:return 34;case 30:return 35;case 31:return 79;case 32:return 64;case 33:return 65;case 34:return 66;case 35:return 8;case 36:return 10;case 37:return 58;case 38:return 57;case 39:return 53;case 40:return 54;case 41:return 55;case 42:return 50;case 43:return 51;case 44:return 47;case 45:return 45;case 46:return 48;case 47:return 46;case 48:return 41;case 49:return 43;case 50:return 42;case 51:return 39;case 52:return 37;case 53:return 32;case 54:return 86;case 55:return 5;case 56:return 20;case 57:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:[0-9]+\.[0-9]*|[0-9]*\.[0-9]+\b)/,/^(?:[0-9]+)/,/^(?:"(\\["]|[^"])*")/,/^(?:'(\\[']|[^'])*')/,/^(?:\/\/.*)/,/^(?:\/\*(.|\n|\r)*?\*\/)/,/^(?:if\b)/,/^(?:else\b)/,/^(?:while\b)/,/^(?:do\b)/,/^(?:for\b)/,/^(?:function\b)/,/^(?:map\b)/,/^(?:use\b)/,/^(?:return\b)/,/^(?:delete\b)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:Infinity\b)/,/^(?:->)/,/^(?:=>)/,/^(?:<<)/,/^(?:>>)/,/^(?:\{)/,/^(?:\})/,/^(?:;)/,/^(?:#)/,/^(?:\?)/,/^(?::)/,/^(?:NaN\b)/,/^(?:\.)/,/^(?:\[)/,/^(?:\])/,/^(?:\()/,/^(?:\))/,/^(?:!)/,/^(?:\^)/,/^(?:\*)/,/^(?:\/)/,/^(?:%)/,/^(?:\+)/,/^(?:-)/,/^(?:<=)/,/^(?:<)/,/^(?:>=)/,/^(?:>)/,/^(?:==)/,/^(?:~=)/,/^(?:!=)/,/^(?:&&)/,/^(?:\|\|)/,/^(?:=)/,/^(?:,)/,/^(?:$)/,/^(?:[A-Za-z_\$][A-Za-z0-9_]*)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57],inclusive:!0}}};return t}();function dt(){this.yy={}}return at.lexer=ct,dt.prototype=at,at.Parser=dt,new dt}();return void 0!==require&&"undefined"!=typeof exports&&(exports.parser=parser,exports.Parser=parser.Parser,exports.parse=function(){return parser.parse.apply(parser,arguments)},exports.main=function(t){t[1]||(console.log("Usage: "+t[0]+" FILE"),process.exit(1));var e=require("fs").readFileSync(require("path").normalize(t[1]),"utf8");return exports.parser.parse(e)},"undefined"!=typeof module&&require.main===module&&exports.main(process.argv.slice(1))),parser.yy.parseError=parser.parseError,JXG.JessieCode})),define("base/composition",["jxg","utils/type"],(function(t,e){"use strict";return t.Composition=function(t){var i,r=this,s=["setAttribute","setParents","prepareUpdate","updateRenderer","update","fullUpdate","highlight","noHighlight"],o=function(t){return function(){var i;for(i in r.elements)r.elements.hasOwnProperty(i)&&e.exists(r.elements[i][t])&&r.elements[i][t].apply(r.elements[i],arguments);return r}};for(i=0;i<s.length;i++)this[s[i]]=o(s[i]);for(i in this.elements={},this.objects=this.elements,this.elementsByName={},this.objectsList=[],this.groups={},this.methodMap={setAttribute:"setAttribute",setProperty:"setAttribute",setParents:"setParents",add:"add",remove:"remove",select:"select"},t)t.hasOwnProperty(i)&&this.add(i,t[i]);this.dump=!0,this.subs={}},t.extend(t.Composition.prototype,{add:function(t,i){return!(e.exists(this[t])||!e.exists(i))&&(e.exists(i.id)?this.elements[i.id]=i:this.elements[t]=i,e.exists(i.name)&&(this.elementsByName[i.name]=i),i.on("attribute:name",this.nameListener,this),this.objectsList.push(i),this[t]=i,this.methodMap[t]=i,!0)},remove:function(t){var e,i=!1;for(e in this.elements)if(this.elements.hasOwnProperty(e)&&this.elements[e].id===this[t].id){i=!0;break}return i&&(delete this.elements[this[t].id],delete this[t]),i},nameListener:function(t,e,i){delete this.elementsByName[t],this.elementsByName[e]=i},select:function(i){return e.exists(t.Board)?t.Board.prototype.select.call(this,i):new t.Composition},getParents:function(){return this.parents},getType:function(){return this.elType},getAttributes:function(){var t,e={};for(t in this.subs)this.subs.hasOwnProperty(t)&&(e[t]=this.subs[t].visProp);return this.attr}}),t.Composition})),define("base/board",["jxg","base/constants","base/coords","options","math/numerics","math/math","math/geometry","math/complex","math/statistics","parser/jessiecode","utils/color","utils/type","utils/event","utils/env","base/composition"],(function(t,e,i,r,s,o,n,a,h,l,c,d,u,p,f){"use strict";return t.Board=function(i,s,o,n,a,h,c,f,m,g,b){if(this.BOARD_MODE_NONE=0,this.BOARD_MODE_DRAG=1,this.BOARD_MODE_MOVE_ORIGIN=2,this.BOARD_MODE_ZOOM=17,this.BOARD_QUALITY_LOW=1,this.BOARD_QUALITY_HIGH=2,d.exists(b.document)&&!1!==b.document?this.document=b.document:void 0!==document&&d.isObject(document)&&(this.document=document),this.container=i,this.containerObj=p.isBrowser?this.document.getElementById(this.container):null,p.isBrowser&&"no"!==s.type&&null===this.containerObj)throw new Error("\nJSXGraph: HTML container element '"+i+"' not found.");this.renderer=s,this.grids=[],this.options=d.deepCopy(r),this.attr=b,this.dimension=2,this.jc=new l,this.jc.use(this),this.origin={},this.origin.usrCoords=[1,0,0],this.origin.scrCoords=[1,n[0],n[1]],this.zoomX=a,this.zoomY=h,this.unitX=c*this.zoomX,this.unitY=f*this.zoomY,this.keepaspectratio=!1,this.canvasWidth=m,this.canvasHeight=g,d.exists(o)&&""!==o&&p.isBrowser&&!d.exists(this.document.getElementById(o))?this.id=o:this.id=this.generateId(),u.eventify(this),this.hooks=[],this.dependentBoards=[],this.inUpdate=!1,this.objects={},this.objectsList=[],this.groups={},this.animationObjects={},this.highlightedObjects={},this.numObjects=0,this.elementsByName={},this.mode=this.BOARD_MODE_NONE,this.updateQuality=this.BOARD_QUALITY_HIGH,this.isSuspendedRedraw=!1,this.calculateSnapSizes(),this.drag_dx=0,this.drag_dy=0,this.drag_position=[0,0],this.mouse={},this.touches=[],this.xmlString="",this.cPos=[],this.touchMoveLast=0,this.touchMoveLastId=1/0,this.positionAccessLast=0,this.downObjects=[],this.attr.showcopyright&&this.renderer.displayCopyright(e.licenseText,parseInt(this.options.text.fontSize,10)),this.needsFullUpdate=!1,this.reducedUpdate=!1,this.currentCBDef="none",this.geonextCompatibilityMode=!1,this.options.text.useASCIIMathML&&translateASCIIMath?init():this.options.text.useASCIIMathML=!1,this.hasMouseHandlers=!1,this.hasTouchHandlers=!1,this.hasPointerHandlers=!1,this.hasMouseUp=!1,this.hasTouchEnd=!1,this.hasPointerUp=!1,this._drag_offset=[0,0],this._inputDevice="mouse",this._board_touches=[],this.selectingMode=!1,this.isSelecting=!1,this._isScrolling=!1,this._isResizing=!1,this.selectingBox=[[0,0],[0,0]],this.mathLib=Math,this.mathLibJXG=t.Math,this.attr.registerevents&&this.addEventHandlers(),this.methodMap={update:"update",fullUpdate:"fullUpdate",on:"on",off:"off",trigger:"trigger",setView:"setBoundingBox",setBoundingBox:"setBoundingBox",migratePoint:"migratePoint",colorblind:"emulateColorblindness",suspendUpdate:"suspendUpdate",unsuspendUpdate:"unsuspendUpdate",clearTraces:"clearTraces",left:"clickLeftArrow",right:"clickRightArrow",up:"clickUpArrow",down:"clickDownArrow",zoomIn:"zoomIn",zoomOut:"zoomOut",zoom100:"zoom100",zoomElements:"zoomElements",remove:"removeObject",removeObject:"removeObject"}},t.extend(t.Board.prototype,{generateName:function(t){var i,r,s=this.attr.maxnamelength,o="",n="",a=[],h="";if(t.type===e.OBJECT_TYPE_TICKS)return"";for(i=d.isPoint(t)?["","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]:t.type===e.OBJECT_TYPE_ANGLE?["","&alpha;","&beta;","&gamma;","&delta;","&epsilon;","&zeta;","&eta;","&theta;","&iota;","&kappa;","&lambda;","&mu;","&nu;","&xi;","&omicron;","&pi;","&rho;","&sigma;","&tau;","&upsilon;","&phi;","&chi;","&psi;","&omega;"]:["","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"],d.isPoint(t)||t.elementClass===e.OBJECT_CLASS_LINE||t.type===e.OBJECT_TYPE_ANGLE||(o=t.type===e.OBJECT_TYPE_POLYGON?"P_{":t.elementClass===e.OBJECT_CLASS_CIRCLE?"k_{":t.elementClass===e.OBJECT_CLASS_TEXT?"t_{":"s_{",n="}"),r=0;r<s;r++)a[r]=0;for(;a[s-1]<i.length;){for(a[0]=1;a[0]<i.length;a[0]++){for(h=o,r=s;r>0;r--)h+=i[a[r-1]];if(!d.exists(this.elementsByName[h+n]))return h+n}for(a[0]=i.length,r=1;r<s;r++)a[r-1]===i.length&&(a[r-1]=1,a[r]+=1)}return""},generateId:function(){for(var e=1;d.exists(t.boards["jxgBoard"+e]);)e=Math.round(65535*Math.random());return"jxgBoard"+e},setId:function(t,e){var i,r=this.numObjects,s=t.id;if(this.numObjects+=1,""===s||!d.exists(s))for(s=this.id+e+r;d.exists(this.objects[s]);)i=Math.round(65535*Math.random()),s=this.id+e+r+"-"+i;return t.id=s,this.objects[s]=t,t._pos=this.objectsList.length,this.objectsList[this.objectsList.length]=t,s},finalizeAdding:function(t){!1===d.evaluate(t.visProp.visible)&&this.renderer.display(t,!1)},finalizeLabel:function(t){t.hasLabel&&!d.evaluate(t.label.visProp.islabel)&&!1===d.evaluate(t.label.visProp.visible)&&this.renderer.display(t.label,!1)},checkFrameRate:function(t){var e=!1,i=(new Date).getTime();return d.exists(t.pointerId)&&this.touchMoveLastId!==t.pointerId&&(e=!0,this.touchMoveLastId=t.pointerId),!e&&(i-this.touchMoveLast)*this.attr.maxframerate>=1e3&&(e=!0),e&&(this.touchMoveLast=i),e},getCoordsTopLeftCorner:function(){var t,e,i,r,s,o=this.document.documentElement||this.document.body.parentNode,n=this.document.body,a=this.containerObj;if(this.cPos.length>0&&(this.mode===this.BOARD_MODE_DRAG||this.mode===this.BOARD_MODE_MOVE_ORIGIN||(new Date).getTime()-this.positionAccessLast<1e3))return this.cPos;if(this.positionAccessLast=(new Date).getTime(),a.getBoundingClientRect){for(i=a.getBoundingClientRect(),r=1,s=a;s&&d.exists(s.parentNode);)d.exists(s.style)&&d.exists(s.style.zoom)&&""!==s.style.zoom&&(r*=parseFloat(s.style.zoom)),s=s.parentNode;return(t=[i.left*r,i.top*r])[0]+=p.getProp(a,"border-left-width"),t[1]+=p.getProp(a,"border-top-width"),"vml"!==this.renderer.type&&(t[0]+=p.getProp(a,"padding-left"),t[1]+=p.getProp(a,"padding-top")),this.cPos=t.slice(),this.cPos}return t=p.getOffset(a),e=this.document.documentElement.ownerDocument,!this.containerObj.currentStyle&&e.defaultView&&(t[0]+=p.getProp(o,"margin-left"),t[1]+=p.getProp(o,"margin-top"),t[0]+=p.getProp(o,"border-left-width"),t[1]+=p.getProp(o,"border-top-width"),t[0]+=p.getProp(o,"padding-left"),t[1]+=p.getProp(o,"padding-top")),n&&(t[0]+=p.getProp(n,"left"),t[1]+=p.getProp(n,"top")),"object"==typeof google&&google.translate&&(t[0]+=10,t[1]+=25),t[0]+=p.getProp(a,"border-left-width"),t[1]+=p.getProp(a,"border-top-width"),"vml"!==this.renderer.type&&(t[0]+=p.getProp(a,"padding-left"),t[1]+=p.getProp(a,"padding-top")),t[0]+=this.attr.offsetx,t[1]+=this.attr.offsety,this.cPos=t.slice(),this.cPos},getMousePosition:function(t,e){var i,r,s=this.getCoordsTopLeftCorner();return i=p.getPosition(t,e,this.document),d.exists(this.cssTransMat)||this.updateCSSTransforms(),r=[1,i[0]-s[0],i[1]-s[1]],(r=o.matVecMult(this.cssTransMat,r))[1]/=r[0],r[2]/=r[0],[r[1],r[2]]},initMoveOrigin:function(t,e){this.drag_dx=t-this.origin.scrCoords[1],this.drag_dy=e-this.origin.scrCoords[2],this.mode=this.BOARD_MODE_MOVE_ORIGIN,this.updateQuality=this.BOARD_QUALITY_LOW},initMoveObject:function(t,i,r,s){var o,n,a,l=[],c=[],u=this.objectsList.length,p={visProp:{layer:-1e4}};for(n=0;n<u;n++)a=(o=this.objectsList[n]).hasPoint&&o.hasPoint(t,i),o.visPropCalc.visible&&a&&(o.triggerEventHandlers([s+"down","down"],[r]),this.downObjects.push(o)),a&&o.isDraggable&&o.visPropCalc.visible&&(this.geonextCompatibilityMode&&(d.isPoint(o)||o.elementClass===e.OBJECT_CLASS_TEXT)||!this.geonextCompatibilityMode)&&!d.evaluate(o.visProp.fixed)&&(o.visProp.layer>p.visProp.layer||o.visProp.layer===p.visProp.layer&&o.lastDragTime.getTime()>=p.lastDragTime.getTime())&&(this.attr.ignorelabels&&d.exists(p.label)&&o===p.label||(p=o,l.push(p),d.exists(p.coords)?c.push(h.subtract(p.coords.scrCoords.slice(1),[t,i])):c.push([0,0])));return this.attr.drag.enabled&&l.length>0&&(this.mode=this.BOARD_MODE_DRAG),this.attr.takefirst?(l.length=1,this._drag_offset=c[0]):(l=l.slice(-1),this._drag_offset=c[c.length-1]),this._drag_offset||(this._drag_offset=[0,0]),"svg"===this.renderer.type&&d.exists(l[0])&&d.evaluate(l[0].visProp.dragtotopoflayer)&&1===l.length&&d.exists(l[0].rendNode)&&l[0].rendNode.parentNode.appendChild(l[0].rendNode),this.previousRotation=0,this.previousScale=1,l.length>=1&&(l[0].highlight(!0),this.triggerEventHandlers(["mousehit","hit"],[r,l[0]])),l},moveObject:function(t,r,s,o,n){var a,l,c,u=new i(e.COORDS_BY_SCREEN,this.getScrCoordsOfMouse(t,r),this);s&&s.obj&&((a=s.obj).coords&&(l=a.coords.scrCoords.slice()),this.drag_position=[u.scrCoords[1],u.scrCoords[2]],this.drag_position=h.add(this.drag_position,this._drag_offset),d.exists(a.coords)?a.setPositionDirectly(e.COORDS_BY_SCREEN,this.drag_position):(this.displayInfobox(!1),isNaN(s.targets[0].Xprev+s.targets[0].Yprev)||a.setPositionDirectly(e.COORDS_BY_SCREEN,[u.scrCoords[1],u.scrCoords[2]],[s.targets[0].Xprev,s.targets[0].Yprev]),s.targets[0].Xprev=u.scrCoords[1],s.targets[0].Yprev=u.scrCoords[2]),d.exists(a.coords)&&(a.prepareUpdate().update(!1).updateRenderer(),this.updateInfobox(a),a.prepareUpdate().update(!0).updateRenderer()),a.coords&&(c=a.coords.scrCoords),a.coords&&l[1]===c[1]&&l[2]===c[2]||(a.triggerEventHandlers([n+"drag","drag"],[o]),this.update()),a.highlight(!0),this.triggerEventHandlers(["mousehit","hit"],[o,a]),a.lastDragTime=new Date)},twoFingerMove:function(t,i,r){var s;d.exists(t)&&d.exists(t.obj)&&((s=t.obj).elementClass===e.OBJECT_CLASS_LINE||s.type===e.OBJECT_TYPE_POLYGON?this.twoFingerTouchObject(t.targets,s,i):s.elementClass===e.OBJECT_CLASS_CIRCLE&&this.twoFingerTouchCircle(t.targets,s,i),r&&s.triggerEventHandlers(["touchdrag","drag"],[r]))},twoFingerTouchObject:function(t,r,s){var a,h,l,c,u,p,f,m,g,b,v,y,C,_,P,E,S;if(d.exists(t[0])&&d.exists(t[1])&&!isNaN(t[0].Xprev+t[0].Yprev+t[1].Xprev+t[1].Yprev)){if(s===t[0].num?(P=t[1],E=t[0]):(P=t[0],E=t[1]),S=new i(e.COORDS_BY_SCREEN,[P.Xprev,P.Yprev],this).usrCoords,h=new i(e.COORDS_BY_SCREEN,[E.Xprev,E.Yprev],this).usrCoords,a=new i(e.COORDS_BY_SCREEN,[E.X,E.Y],this).usrCoords,c=o.crossProduct(S,h),l=o.crossProduct(S,a),f=o.crossProduct(c,l),Math.abs(f[0])<o.eps)return;if(p=n.rad(h.slice(1),S.slice(1),a.slice(1)),(m=this.create("transform",[p,[S[1],S[2]]],{type:"rotate"})).update(),d.evaluate(r.visProp.scalable)&&(u=n.distance(a,S)/n.distance(h,S),g=this.create("transform",[-S[1],-S[2]],{type:"translate"}),b=this.create("transform",[u,u],{type:"scale"}),v=this.create("transform",[S[1],S[2]],{type:"translate"}),m.melt(g).melt(b).melt(v)),r.elementClass===e.OBJECT_CLASS_LINE)y=[],r.point1.draggable()&&y.push(r.point1),r.point2.draggable()&&y.push(r.point2),m.applyOnce(y);else if(r.type===e.OBJECT_TYPE_POLYGON){for(y=[],_=r.vertices.length-1,C=0;C<_;++C)r.vertices[C].draggable()&&y.push(r.vertices[C]);m.applyOnce(y)}this.update(),r.highlight(!0)}},twoFingerTouchCircle:function(t,r,s){var o,a,h,l,c,u,p,f,m,g,b;"pointCircle"!==r.method&&"pointLine"!==r.method&&d.exists(t[0])&&d.exists(t[1])&&!isNaN(t[0].Xprev+t[0].Yprev+t[1].Xprev+t[1].Yprev)&&(s===t[0].num?(o=t[1],a=t[0]):(o=t[0],a=t[1]),c=new i(e.COORDS_BY_SCREEN,[o.Xprev,o.Yprev],this).usrCoords,l=new i(e.COORDS_BY_SCREEN,[a.Xprev,a.Yprev],this).usrCoords,h=new i(e.COORDS_BY_SCREEN,[a.X,a.Y],this).usrCoords,p=n.rad(l.slice(1),c.slice(1),h.slice(1)),f=this.create("transform",[-c[1],-c[2]],{type:"translate"}),m=this.create("transform",[p],{type:"rotate"}),f.melt(m),d.evaluate(r.visProp.scalable)&&(u=n.distance(c,h)/n.distance(c,l),g=this.create("transform",[u,u],{type:"scale"}),f.melt(g)),b=this.create("transform",[c[1],c[2]],{type:"translate"}),f.melt(b),r.center.draggable()&&f.applyOnce([r.center]),"twoPoints"===r.method?r.point2.draggable()&&f.applyOnce([r.point2]):"pointRadius"===r.method&&d.isNumber(r.updateRadius.origin)&&r.setRadius(r.radius*u),this.update(r.center),r.highlight(!0))},highlightElements:function(t,e,i,r){var s,o,n,a={},h=this.objectsList.length;for(s=0;s<h;s++)n=(o=this.objectsList[s]).id,d.exists(o.hasPoint)&&o.visPropCalc.visible&&o.hasPoint(t,e)&&(this.updateInfobox(o),d.exists(this.highlightedObjects[n])||(a[n]=o,o.highlight(),this.triggerEventHandlers(["mousehit","hit"],[i,o,r])),o.mouseover?o.triggerEventHandlers(["mousemove","move"],[i]):(o.triggerEventHandlers(["mouseover","over"],[i]),o.mouseover=!0));for(s=0;s<h;s++)n=(o=this.objectsList[s]).id,o.mouseover&&(a[n]||(o.triggerEventHandlers(["mouseout","out"],[i]),o.mouseover=!1))},saveStartPos:function(i,r){var s,o,n=[];if(i.type===e.OBJECT_TYPE_TICKS)n.push([1,NaN,NaN]);else if(i.elementClass===e.OBJECT_CLASS_LINE)n.push(i.point1.coords.usrCoords),n.push(i.point2.coords.usrCoords);else if(i.elementClass===e.OBJECT_CLASS_CIRCLE)n.push(i.center.coords.usrCoords),"twoPoints"===i.method&&n.push(i.point2.coords.usrCoords);else if(i.type===e.OBJECT_TYPE_POLYGON)for(o=i.vertices.length-1,s=0;s<o;s++)n.push(i.vertices[s].coords.usrCoords);else if(i.type===e.OBJECT_TYPE_SECTOR)n.push(i.point1.coords.usrCoords),n.push(i.point2.coords.usrCoords),n.push(i.point3.coords.usrCoords);else if(d.isPoint(i)||i.type===e.OBJECT_TYPE_GLIDER)n.push(i.coords.usrCoords);else if(i.elementClass===e.OBJECT_CLASS_CURVE)i.points.length>0&&n.push(i.points[0].usrCoords);else try{n.push(i.coords.usrCoords)}catch(e){t.debug("JSXGraph+ saveStartPos: obj.coords.usrCoords not available: "+e)}for(o=n.length,s=0;s<o;s++)r.Zstart.push(n[s][0]),r.Xstart.push(n[s][1]),r.Ystart.push(n[s][2])},mouseOriginMoveStart:function(t){var e,i;return(e=this._isRequiredKeyPressed(t,"pan"))&&(i=this.getMousePosition(t),this.initMoveOrigin(i[0],i[1])),e},mouseOriginMove:function(t){var e,i=this.mode===this.BOARD_MODE_MOVE_ORIGIN;return i&&(e=this.getMousePosition(t),this.moveOrigin(e[0],e[1],!0)),i},touchStartMoveOriginOneFinger:function(e){var i,r,s=e[t.touchProperty];return(i=this.attr.pan.enabled&&!this.attr.pan.needtwofingers&&1===s.length)&&(r=this.getMousePosition(e,0),this.initMoveOrigin(r[0],r[1])),i},touchOriginMove:function(t){var e,i=this.mode===this.BOARD_MODE_MOVE_ORIGIN;return i&&(e=this.getMousePosition(t,0),this.moveOrigin(e[0],e[1],!0)),i},originMoveEnd:function(){this.updateQuality=this.BOARD_QUALITY_HIGH,this.mode=this.BOARD_MODE_NONE},addEventHandlers:function(){if(p.supportsPointerEvents()?this.addPointerEventHandlers():(this.addMouseEventHandlers(),this.addTouchEventHandlers()),null!==this.containerObj&&(this.containerObj.oncontextmenu=function(t){return d.exists(t)&&t.preventDefault(),!1}),this.addFullscreenEventHandlers(),this.addKeyboardEventHandlers(),p.isBrowser){try{this.startResizeObserver()}catch(t){p.addEvent(window,"resize",this.resizeListener,this),this.startIntersectionObserver()}p.addEvent(window,"scroll",this.scrollListener,this)}},removeEventHandlers:function(){this.removeMouseEventHandlers(),this.removeTouchEventHandlers(),this.removePointerEventHandlers(),this.removeFullscreenEventHandlers(),this.removeKeyboardEventHandlers(),p.isBrowser&&(d.exists(this.resizeObserver)?this.stopResizeObserver():(p.removeEvent(window,"resize",this.resizeListener,this),this.stopIntersectionObserver()),p.removeEvent(window,"scroll",this.scrollListener,this))},addPointerEventHandlers:function(){if(!this.hasPointerHandlers&&p.isBrowser){var t=this.attr.movetarget||this.containerObj;window.navigator.msPointerEnabled?(p.addEvent(this.containerObj,"MSPointerDown",this.pointerDownListener,this),p.addEvent(t,"MSPointerMove",this.pointerMoveListener,this)):(p.addEvent(this.containerObj,"pointerdown",this.pointerDownListener,this),p.addEvent(t,"pointermove",this.pointerMoveListener,this)),p.addEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this),p.addEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this),null!==this.containerObj&&(this.containerObj.style.touchAction="none"),this.hasPointerHandlers=!0}},addMouseEventHandlers:function(){if(!this.hasMouseHandlers&&p.isBrowser){var t=this.attr.movetarget||this.containerObj;p.addEvent(this.containerObj,"mousedown",this.mouseDownListener,this),p.addEvent(t,"mousemove",this.mouseMoveListener,this),p.addEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this),p.addEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this),this.hasMouseHandlers=!0}},addTouchEventHandlers:function(t){if(!this.hasTouchHandlers&&p.isBrowser){var e=this.attr.movetarget||this.containerObj;p.addEvent(this.containerObj,"touchstart",this.touchStartListener,this),p.addEvent(e,"touchmove",this.touchMoveListener,this),this.hasTouchHandlers=!0}},addFullscreenEventHandlers:function(){var t,e=["fullscreenchange","mozfullscreenchange","webkitfullscreenchange","msfullscreenchange"],i=e.length;if(!this.hasFullsceenEventHandlers&&p.isBrowser){for(t=0;t<i;t++)p.addEvent(this.document,e[t],this.fullscreenListener,this);this.hasFullsceenEventHandlers=!0}},addKeyboardEventHandlers:function(){!this.hasKeyboardHandlers&&p.isBrowser&&(p.addEvent(this.containerObj,"keydown",this.keyDownListener,this),p.addEvent(this.containerObj,"focusin",this.keyFocusInListener,this),p.addEvent(this.containerObj,"focusout",this.keyFocusOutListener,this),this.hasKeyboardHandlers=!0)},removeKeyboardEventHandlers:function(){this.hasKeyboardHandlers&&p.isBrowser&&(p.removeEvent(this.containerObj,"keydown",this.keyDownListener,this),p.removeEvent(this.containerObj,"focusin",this.keyFocusInListener,this),p.removeEvent(this.containerObj,"focusout",this.keyFocusOutListener,this),this.hasKeyboardHandlers=!1)},removeFullscreenEventHandlers:function(){var t,e=["fullscreenchange","mozfullscreenchange","webkitfullscreenchange","msfullscreenchange"],i=e.length;if(this.hasFullsceenEventHandlers&&p.isBrowser){for(t=0;t<i;t++)p.removeEvent(this.document,e[t],this.fullscreenListener,this);this.hasFullsceenEventHandlers=!1}},removePointerEventHandlers:function(){if(this.hasPointerHandlers&&p.isBrowser){var t=this.attr.movetarget||this.containerObj;window.navigator.msPointerEnabled?(p.removeEvent(this.containerObj,"MSPointerDown",this.pointerDownListener,this),p.removeEvent(t,"MSPointerMove",this.pointerMoveListener,this)):(p.removeEvent(this.containerObj,"pointerdown",this.pointerDownListener,this),p.removeEvent(t,"pointermove",this.pointerMoveListener,this)),p.removeEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this),p.removeEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this),this.hasPointerUp&&(window.navigator.msPointerEnabled?p.removeEvent(this.document,"MSPointerUp",this.pointerUpListener,this):(p.removeEvent(this.document,"pointerup",this.pointerUpListener,this),p.removeEvent(this.document,"pointercancel",this.pointerUpListener,this)),this.hasPointerUp=!1),this.hasPointerHandlers=!1}},removeMouseEventHandlers:function(){if(this.hasMouseHandlers&&p.isBrowser){var t=this.attr.movetarget||this.containerObj;p.removeEvent(this.containerObj,"mousedown",this.mouseDownListener,this),p.removeEvent(t,"mousemove",this.mouseMoveListener,this),this.hasMouseUp&&(p.removeEvent(this.document,"mouseup",this.mouseUpListener,this),this.hasMouseUp=!1),p.removeEvent(this.containerObj,"mousewheel",this.mouseWheelListener,this),p.removeEvent(this.containerObj,"DOMMouseScroll",this.mouseWheelListener,this),this.hasMouseHandlers=!1}},removeTouchEventHandlers:function(){if(this.hasTouchHandlers&&p.isBrowser){var t=this.attr.movetarget||this.containerObj;p.removeEvent(this.containerObj,"touchstart",this.touchStartListener,this),p.removeEvent(t,"touchmove",this.touchMoveListener,this),this.hasTouchEnd&&(p.removeEvent(this.document,"touchend",this.touchEndListener,this),this.hasTouchEnd=!1),this.hasTouchHandlers=!1}},clickLeftArrow:function(){return this.moveOrigin(this.origin.scrCoords[1]+.1*this.canvasWidth,this.origin.scrCoords[2]),this},clickRightArrow:function(){return this.moveOrigin(this.origin.scrCoords[1]-.1*this.canvasWidth,this.origin.scrCoords[2]),this},clickUpArrow:function(){return this.moveOrigin(this.origin.scrCoords[1],this.origin.scrCoords[2]-.1*this.canvasHeight),this},clickDownArrow:function(){return this.moveOrigin(this.origin.scrCoords[1],this.origin.scrCoords[2]+.1*this.canvasHeight),this},gestureChangeListener:function(t){var r,s,o,a,h,l,c,u,p,f,m,g,b=!1,v=this.attr.zoom.factorx,y=this.attr.zoom.factory;return this.mode!==this.BOARD_MODE_ZOOM||(t.preventDefault(),l=n.distance([t.touches[0].clientX,t.touches[0].clientY],[t.touches[1].clientX,t.touches[1].clientY],2),void 0===t.scale&&(t.scale=l/this.prevDist),!!d.exists(this.prevCoords)&&(s=[t.touches[0].clientX-this.prevCoords[0][0],t.touches[0].clientY-this.prevCoords[0][1]],o=[t.touches[1].clientX-this.prevCoords[1][0],t.touches[1].clientY-this.prevCoords[1][1]],s[0]*s[0]+s[1]*s[1]<100&&o[0]*o[0]+o[1]*o[1]<100||(a=n.rad(s,[0,0],o),"pan"!==this.isPreviousGesture&&Math.abs(a)>.2*Math.PI&&Math.abs(a)<1.8*Math.PI&&(b=!0),"pan"===this.isPreviousGesture||b||(Math.abs(t.scale)<.77||Math.abs(t.scale)>1.3)&&(b=!0),h=t.scale/this.prevScale,this.prevScale=t.scale,this.prevCoords=[[t.touches[0].clientX,t.touches[0].clientY],[t.touches[1].clientX,t.touches[1].clientY]],r=new i(e.COORDS_BY_SCREEN,this.getMousePosition(t,0),this),this.attr.pan.enabled&&this.attr.pan.needtwofingers&&!b?(this.isPreviousGesture="pan",this.moveOrigin(r.scrCoords[1],r.scrCoords[2],!0)):this.attr.zoom.enabled&&Math.abs(h-1)<.5&&((this.attr.zoom.pinchhorizontal||this.attr.zoom.pinchvertical)&&(c=Math.abs(t.touches[0].clientX-t.touches[1].clientX),u=Math.abs(t.touches[0].clientY-t.touches[1].clientY),p=Math.abs(Math.atan2(u,c)),g=Math.PI*this.attr.zoom.pinchsensitivity/90),this.attr.zoom.pinchhorizontal&&p<g?(this.attr.zoom.factorx=h,this.attr.zoom.factory=1,f=0,m=0):this.attr.zoom.pinchvertical&&Math.abs(p-.5*Math.PI)<g?(this.attr.zoom.factorx=1,this.attr.zoom.factory=h,f=0,m=0):(this.attr.zoom.factorx=h,this.attr.zoom.factory=h,f=r.usrCoords[1],m=r.usrCoords[2]),this.zoomIn(f,m),this.attr.zoom.factorx=v,this.attr.zoom.factory=y)),!1))},gestureStartListener:function(t){var e;return t.preventDefault(),this.prevScale=1,this.prevDist=n.distance([t.touches[0].clientX,t.touches[0].clientY],[t.touches[1].clientX,t.touches[1].clientY],2),this.prevCoords=[[t.touches[0].clientX,t.touches[0].clientY],[t.touches[1].clientX,t.touches[1].clientY]],this.isPreviousGesture="none",e=this.getMousePosition(t,0),this.initMoveOrigin(e[0],e[1]),this.mode=this.BOARD_MODE_ZOOM,!1},_isRequiredKeyPressed:function(t,e){var i=this.attr[e];return!!i.enabled&&!(!(i.needshift&&t.shiftKey||!i.needshift&&!t.shiftKey)||!(i.needctrl&&t.ctrlKey||!i.needctrl&&!t.ctrlKey))},_isPointerRegistered:function(t){var e,i=this._board_touches.length;for(e=0;e<i;e++)if(this._board_touches[e].pointerId===t.pointerId)return!0;return!1},_pointerStorePosition:function(t){var e,i;for(e=0,i=!1;e<this._board_touches.length;e++)if(this._board_touches[e].pointerId===t.pointerId){this._board_touches[e].clientX=t.clientX,this._board_touches[e].clientY=t.clientY,i=!0;break}return!i&&this._board_touches.length<2&&this._board_touches.push({pointerId:t.pointerId,clientX:t.clientX,clientY:t.clientY}),this},_pointerRemoveTouches:function(t){var e;for(e=0;e<this._board_touches.length;e++)if(this._board_touches[e].pointerId===t.pointerId){this._board_touches.splice(e,1);break}return this},_pointerClearTouches:function(){this._board_touches.length>0&&this.dehighlightAll(),this.updateQuality=this.BOARD_QUALITY_HIGH,this.mode=this.BOARD_MODE_NONE,this._board_touches=[],this.touches=[]},_getPointerInputDevice:function(t){if(p.isBrowser){if("touch"===t.pointerType||window.navigator.msMaxTouchPoints&&window.navigator.msMaxTouchPoints>1)return"touch";if("mouse"===t.pointerType)return"mouse";if("pen"===t.pointerType)return"pen"}return"mouse"},pointerDownListener:function(t,e){var i,r,s,o,n,a,h,l,c,u;if(!e&&this._isPointerRegistered(t))return!1;if(!e&&t.isPrimary&&this._pointerClearTouches(),this.hasPointerUp||(window.navigator.msPointerEnabled?p.addEvent(this.document,"MSPointerUp",this.pointerUpListener,this):(p.addEvent(this.document,"pointerup",this.pointerUpListener,this),p.addEvent(this.document,"pointercancel",this.pointerUpListener,this)),this.hasPointerUp=!0),this.hasMouseHandlers&&this.removeMouseEventHandlers(),this.hasTouchHandlers&&this.removeTouchEventHandlers(),this.document.selection&&d.isFunction(this.document.selection.empty))this.document.selection.empty();else if(window.getSelection&&(a=window.getSelection()).removeAllRanges)try{a.removeAllRanges()}catch(t){}if(this._inputDevice=this._getPointerInputDevice(t),l=this._inputDevice,this.options.precision.hasPoint=this.options.precision[l],o=this.getMousePosition(t),this._testForSelection(t),this.selectingMode)return this._startSelecting(o),void this.triggerEventHandlers(["touchstartselecting","pointerstartselecting","startselecting"],[t]);if(this.attr.drag.enabled&&e?(n=[e],this.mode=this.BOARD_MODE_DRAG):n=this.initMoveObject(o[0],o[1],t,l),h={num:t.pointerId,X:o[0],Y:o[1],Xprev:NaN,Yprev:NaN,Xstart:[],Ystart:[],Zstart:[]},n.length>0){for(u=n[n.length-1],c=!1,i=0;i<this.touches.length;i++)if(this.touches[i].obj===u){r=i,s=this.touches[i].targets.push(h)-1,c=!0;break}c||(s=0,r=this.touches.push({obj:u,targets:[h]})-1),this.dehighlightAll(),u.highlight(!0),this.saveStartPos(u,this.touches[r].targets[s]),t&&t.preventDefault?t.preventDefault():window.event&&(window.event.returnValue=!1)}return this.touches.length>0&&(t.preventDefault(),t.stopPropagation()),!!p.isBrowser&&("touch"!==this._getPointerInputDevice(t)?this.mode===this.BOARD_MODE_NONE&&this.mouseOriginMoveStart(t):(this._pointerStorePosition(t),t.touches=this._board_touches,1===t.touches.length&&this.mode===this.BOARD_MODE_NONE&&this.touchStartMoveOriginOneFinger(t)||2!==t.touches.length||this.mode!==this.BOARD_MODE_NONE&&this.mode!==this.BOARD_MODE_MOVE_ORIGIN||(this.mode===this.BOARD_MODE_MOVE_ORIGIN&&this.originMoveEnd(),this.gestureStartListener(t))),this.triggerEventHandlers(["touchstart","down","pointerdown","MSPointerDown"],[t]),!1)},pointerMoveListener:function(t){var e,i,r,s,o;if("touch"===this._getPointerInputDevice(t)&&!this._isPointerRegistered(t))return this.BOARD_MODE_NONE;if(!this.checkFrameRate(t))return!1;if(this.mode!==this.BOARD_MODE_DRAG&&(this.dehighlightAll(),this.displayInfobox(!1)),this.mode!==this.BOARD_MODE_NONE&&(t.preventDefault(),t.stopPropagation()),this.updateQuality=this.BOARD_QUALITY_LOW,this._inputDevice=this._getPointerInputDevice(t),o=this._inputDevice,this.options.precision.hasPoint=this.options.precision[o],this.selectingMode)r=this.getMousePosition(t),this._moveSelecting(r),this.triggerEventHandlers(["touchmoveselecting","moveselecting","pointermoveselecting"],[t,this.mode]);else if(!this.mouseOriginMove(t))if(this.mode===this.BOARD_MODE_DRAG){for(e=0;e<this.touches.length;e++)for(s=this.touches[e].targets,i=0;i<s.length;i++)if(s[i].num===t.pointerId){r=this.getMousePosition(t),s[i].X=r[0],s[i].Y=r[1],1===s.length?this.moveObject(r[0],r[1],this.touches[e],t,o):2===s.length&&(this.twoFingerMove(this.touches[e],t.pointerId,t),s[i].Xprev=r[0],s[i].Yprev=r[1]);break}}else"touch"===this._getPointerInputDevice(t)&&(this._pointerStorePosition(t),2===this._board_touches.length&&(t.touches=this._board_touches,this.gestureChangeListener(t))),r=this.getMousePosition(t),this.highlightElements(r[0],r[1],t,-1);return this.triggerEventHandlers(["touchmove","move","pointermove","MSPointerMove"],[t,this.mode]),this.updateQuality=this.BOARD_QUALITY_HIGH,this.mode===this.BOARD_MODE_NONE},pointerUpListener:function(t){var e,i,r,s;if(this.triggerEventHandlers(["touchend","up","pointerup","MSPointerUp"],[t]),this.displayInfobox(!1),t)for(e=0;e<this.touches.length;e++)for(s=this.touches[e].targets,i=0;i<s.length;i++)if(s[i].num===t.pointerId){s.splice(i,1),0===s.length&&this.touches.splice(e,1);break}if(this.selectingMode)this._stopSelecting(t),this.triggerEventHandlers(["touchstopselecting","pointerstopselecting","stopselecting"],[t]);else for(e=this.downObjects.length-1;e>-1;e--){for(r=!1,i=0;i<this.touches.length;i++)this.touches[i].obj.id===this.downObjects[e].id&&(r=!0);r||(this.downObjects[e].triggerEventHandlers(["touchend","up","pointerup","MSPointerUp"],[t]),this.downObjects[e].snapToGrid(),this.downObjects[e].snapToPoints(),this.downObjects.splice(e,1))}return this.hasPointerUp&&(window.navigator.msPointerEnabled?p.removeEvent(this.document,"MSPointerUp",this.pointerUpListener,this):(p.removeEvent(this.document,"pointerup",this.pointerUpListener,this),p.removeEvent(this.document,"pointercancel",this.pointerUpListener,this)),this.hasPointerUp=!1),this.originMoveEnd(),this.update(),this._pointerClearTouches(),!0},touchStartListener:function(i){var s,o,n,a,h,l,c,u,f,m,g=this.options.precision.touch,b=i[t.touchProperty];for(this.hasTouchEnd||(p.addEvent(this.document,"touchend",this.touchEndListener,this),this.hasTouchEnd=!0),this.document.selection&&d.isFunction(this.document.selection.empty)?this.document.selection.empty():window.getSelection&&window.getSelection().removeAllRanges(),this._inputDevice="touch",this.options.precision.hasPoint=this.options.precision.touch,s=0;s<b.length;s++)b[s].jxg_isused=!1;for(s=0;s<this.touches.length;s++)for(m=this.touches[s].targets,a=0;a<m.length;a++){m[a].num=-1,g=this.options.precision.touch;do{for(h=0;h<b.length;h++)if(Math.abs(Math.pow(b[h].screenX-m[a].X,2)+Math.pow(b[h].screenY-m[a].Y,2))<g*g){m[a].num=h,m[a].X=b[h].screenX,m[a].Y=b[h].screenY,b[h].jxg_isused=!0;break}g*=2}while(-1===m[a].num&&g<this.options.precision.touchMax);-1===m[a].num&&(t.debug("i couldn't find a targettouches for target no "+a+" on "+this.touches[s].obj.name+" ("+this.touches[s].obj.id+"). Removed the target."),t.debug("eps = "+g+", touchMax = "+r.precision.touchMax),m.splice(s,1))}for(s=0;s<b.length;s++)if(!b[s].jxg_isused){if(o=this.getMousePosition(i,s),this.selectingMode)return this._startSelecting(o),this.triggerEventHandlers(["touchstartselecting","startselecting"],[i]),i.preventDefault(),i.stopPropagation(),this.options.precision.hasPoint=this.options.precision.mouse,this.touches.length>0;if(0!==(n=this.initMoveObject(o[0],o[1],i,"touch")).length)if(l=n[n.length-1],f={num:s,X:b[s].screenX,Y:b[s].screenY,Xprev:NaN,Yprev:NaN,Xstart:[],Ystart:[],Zstart:[]},d.isPoint(l)||l.elementClass===e.OBJECT_CLASS_TEXT||l.type===e.OBJECT_TYPE_TICKS||l.type===e.OBJECT_TYPE_IMAGE)u=[l],this.saveStartPos(l,u[0]),this.touches.push({obj:l,targets:u}),l.highlight(!0);else if(l.elementClass===e.OBJECT_CLASS_LINE||l.elementClass===e.OBJECT_CLASS_CIRCLE||l.elementClass===e.OBJECT_CLASS_CURVE||l.type===e.OBJECT_TYPE_POLYGON){for(c=!1,a=0;a<this.touches.length;a++)l.id===this.touches[a].obj.id&&(c=!0,1===this.touches[a].targets.length&&(this.saveStartPos(l,f),this.touches[a].targets.push(f)),b[s].jxg_isused=!0);c||(u=[f],this.saveStartPos(l,u[0]),this.touches.push({obj:l,targets:u}),l.highlight(!0))}b[s].jxg_isused=!0}return this.touches.length>0&&(i.preventDefault(),i.stopPropagation()),1===b.length&&this.mode===this.BOARD_MODE_NONE&&this.touchStartMoveOriginOneFinger(i)||2!==b.length||this.mode!==this.BOARD_MODE_NONE&&this.mode!==this.BOARD_MODE_MOVE_ORIGIN||(this.mode===this.BOARD_MODE_MOVE_ORIGIN&&this.originMoveEnd(),this.gestureStartListener(i)),this.options.precision.hasPoint=this.options.precision.mouse,this.triggerEventHandlers(["touchstart","down"],[i]),!1},touchMoveListener:function(e){var i,r,s,o,n=e[t.touchProperty];if(!this.checkFrameRate(e))return!1;if(this.mode!==this.BOARD_MODE_NONE&&(e.preventDefault(),e.stopPropagation()),this.mode!==this.BOARD_MODE_DRAG&&(this.dehighlightAll(),this.displayInfobox(!1)),this._inputDevice="touch",this.options.precision.hasPoint=this.options.precision.touch,this.updateQuality=this.BOARD_QUALITY_LOW,this.selectingMode){for(i=0;i<n.length;i++)if(!n[i].jxg_isused){r=this.getMousePosition(e,i),this._moveSelecting(r),this.triggerEventHandlers(["touchmoves","moveselecting"],[e,this.mode]);break}}else if(!this.touchOriginMove(e))if(this.mode===this.BOARD_MODE_DRAG){for(i=0;i<this.touches.length;i++)if(1===(o=this.touches[i].targets).length){if(n[o[0].num]){if((r=this.getMousePosition(e,o[0].num))[0]<0||r[0]>this.canvasWidth||r[1]<0||r[1]>this.canvasHeight)return;o[0].X=r[0],o[0].Y=r[1],this.moveObject(r[0],r[1],this.touches[i],e,"touch")}}else if(2===o.length&&o[0].num>-1&&o[1].num>-1&&n[o[0].num]&&n[o[1].num]){if(r=this.getMousePosition(e,o[0].num),s=this.getMousePosition(e,o[1].num),r[0]<0||r[0]>this.canvasWidth||r[1]<0||r[1]>this.canvasHeight||s[0]<0||s[0]>this.canvasWidth||s[1]<0||s[1]>this.canvasHeight)return;o[0].X=r[0],o[0].Y=r[1],o[1].X=s[0],o[1].Y=s[1],this.twoFingerMove(this.touches[i],o[0].num,e),this.twoFingerMove(this.touches[i],o[1].num),o[0].Xprev=r[0],o[0].Yprev=r[1],o[1].Xprev=s[0],o[1].Yprev=s[1]}}else 2===n.length&&this.gestureChangeListener(e),r=this.getMousePosition(e,0),this.highlightElements(r[0],r[1],e,-1);return this.mode!==this.BOARD_MODE_DRAG&&this.displayInfobox(!1),this.triggerEventHandlers(["touchmove","move"],[e,this.mode]),this.options.precision.hasPoint=this.options.precision.mouse,this.updateQuality=this.BOARD_QUALITY_HIGH,this.mode===this.BOARD_MODE_NONE},touchEndListener:function(i){var r,s,o,n,a,h,l=this.options.precision.touch,c=[],u=i&&i[t.touchProperty];if(this.triggerEventHandlers(["touchend","up"],[i]),this.displayInfobox(!1),this.selectingMode)this._stopSelecting(i),this.triggerEventHandlers(["touchstopselecting","stopselecting"],[i]);else if(u&&u.length>0){for(r=0;r<this.touches.length;r++)c[r]=this.touches[r];for(this.touches.length=0,r=0;r<u.length;r++)u[r].jxg_isused=!1;for(r=0;r<c.length;r++){for(n=!1,a=0,h=c[r].targets,s=0;s<h.length;s++)for(h[s].found=!1,o=0;o<u.length;o++)if(Math.abs(Math.pow(u[o].screenX-h[s].X,2)+Math.pow(u[o].screenY-h[s].Y,2))<l*l){h[s].found=!0,h[s].num=o,h[s].X=u[o].screenX,h[s].Y=u[o].screenY,a+=1;break}if(d.isPoint(c[r].obj)?n=h[0]&&h[0].found:c[r].obj.elementClass===e.OBJECT_CLASS_LINE?n=h[0]&&h[0].found||h[1]&&h[1].found:c[r].obj.elementClass===e.OBJECT_CLASS_CIRCLE&&(n=1===a||3===a),n)for(this.touches.push({obj:c[r].obj,targets:[]}),s=0;s<h.length;s++)h[s].found&&this.touches[this.touches.length-1].targets.push({num:h[s].num,X:h[s].screenX,Y:h[s].screenY,Xprev:NaN,Yprev:NaN,Xstart:h[s].Xstart,Ystart:h[s].Ystart,Zstart:h[s].Zstart});else c[r].obj.noHighlight()}}else this.touches.length=0;for(r=this.downObjects.length-1;r>-1;r--){for(n=!1,s=0;s<this.touches.length;s++)this.touches[s].obj.id===this.downObjects[r].id&&(n=!0);n||(this.downObjects[r].triggerEventHandlers(["touchup","up"],[i]),this.downObjects[r].snapToGrid(),this.downObjects[r].snapToPoints(),this.downObjects.splice(r,1))}return u&&0!==u.length||(this.hasTouchEnd&&(p.removeEvent(this.document,"touchend",this.touchEndListener,this),this.hasTouchEnd=!1),this.dehighlightAll(),this.updateQuality=this.BOARD_QUALITY_HIGH,this.originMoveEnd(),this.update()),!0},mouseDownListener:function(t){var e,i,r;if(this.document.selection&&d.isFunction(this.document.selection.empty)?this.document.selection.empty():window.getSelection&&window.getSelection().removeAllRanges(),!this.hasMouseUp)return p.addEvent(this.document,"mouseup",this.mouseUpListener,this),this.hasMouseUp=!0,this._inputDevice="mouse",this.options.precision.hasPoint=this.options.precision.mouse,e=this.getMousePosition(t),this._testForSelection(t),this.selectingMode?(this._startSelecting(e),void this.triggerEventHandlers(["mousestartselecting","startselecting"],[t])):(0===(i=this.initMoveObject(e[0],e[1],t,"mouse")).length?(this.mode=this.BOARD_MODE_NONE,r=!0):(this.mouse={obj:null,targets:[{X:e[0],Y:e[1],Xprev:NaN,Yprev:NaN}]},this.mouse.obj=i[i.length-1],this.dehighlightAll(),this.mouse.obj.highlight(!0),this.mouse.targets[0].Xstart=[],this.mouse.targets[0].Ystart=[],this.mouse.targets[0].Zstart=[],this.saveStartPos(this.mouse.obj,this.mouse.targets[0]),t&&t.preventDefault?t.preventDefault():window.event&&(window.event.returnValue=!1)),this.mode===this.BOARD_MODE_NONE&&(r=this.mouseOriginMoveStart(t)),this.triggerEventHandlers(["mousedown","down"],[t]),r)},mouseMoveListener:function(t){var e;if(!this.checkFrameRate(t))return!1;e=this.getMousePosition(t),this.updateQuality=this.BOARD_QUALITY_LOW,this.mode!==this.BOARD_MODE_DRAG&&(this.dehighlightAll(),this.displayInfobox(!1)),this.selectingMode?(this._moveSelecting(e),this.triggerEventHandlers(["mousemoveselecting","moveselecting"],[t,this.mode])):this.mouseOriginMove(t)||(this.mode===this.BOARD_MODE_DRAG?this.moveObject(e[0],e[1],this.mouse,t,"mouse"):this.highlightElements(e[0],e[1],t,-1),this.triggerEventHandlers(["mousemove","move"],[t,this.mode])),this.updateQuality=this.BOARD_QUALITY_HIGH},mouseUpListener:function(t){var e;if(!1===this.selectingMode&&this.triggerEventHandlers(["mouseup","up"],[t]),this.updateQuality=this.BOARD_QUALITY_HIGH,this.mouse&&this.mouse.obj&&(this.mouse.obj.snapToGrid(this.mouse.targets[0]),this.mouse.obj.snapToPoints()),this.originMoveEnd(),this.dehighlightAll(),this.update(),this.selectingMode)this._stopSelecting(t),this.triggerEventHandlers(["mousestopselecting","stopselecting"],[t]);else for(e=0;e<this.downObjects.length;e++)this.downObjects[e].triggerEventHandlers(["mouseup","up"],[t]);this.downObjects.length=0,this.hasMouseUp&&(p.removeEvent(this.document,"mouseup",this.mouseUpListener,this),this.hasMouseUp=!1),this.mouse=null},mouseWheelListener:function(t){if(!this.attr.zoom.wheel||!this._isRequiredKeyPressed(t,"zoom"))return!0;var r=(t=t||window.event).detail?-t.detail:t.wheelDelta/40,s=new i(e.COORDS_BY_SCREEN,this.getMousePosition(t),this);return r>0?this.zoomIn(s.usrCoords[1],s.usrCoords[2]):this.zoomOut(s.usrCoords[1],s.usrCoords[2]),this.triggerEventHandlers(["mousewheel"],[t]),t.preventDefault(),!1},keyDownListener:function(i){var r,s,o,n,a,h=i.target.id,l=0,c=0,u=d.evaluate(this.attr.keyboard.dx)/this.unitX,p=d.evaluate(this.attr.keyboard.dy)/this.unitY,f=!1;return!(!this.attr.keyboard.enabled||""===h)&&(r=h.replace(this.containerObj.id+"_",""),s=this.select(r),d.exists(s.coords)&&(a=s.coords.usrCoords.slice(1)),(d.evaluate(this.attr.keyboard.panshift)||d.evaluate(this.attr.keyboard.panctrl))&&(f=!0),d.evaluate(this.attr.keyboard.panshift)&&i.shiftKey||d.evaluate(this.attr.keyboard.panctrl)&&i.ctrlKey?38===i.keyCode?this.clickUpArrow():40===i.keyCode?this.clickDownArrow():37===i.keyCode?this.clickLeftArrow():39===i.keyCode&&this.clickRightArrow():(d.exists(s.visProp)&&(d.exists(s.visProp.snaptogrid)&&s.visProp.snaptogrid&&d.evaluate(s.visProp.snapsizex)&&d.evaluate(s.visProp.snapsizey)?(l=(o=s.getSnapSizes())[0],c=o[1],u=Math.max(l,u),p=Math.max(c,p)):d.exists(s.visProp.attracttogrid)&&s.visProp.attracttogrid&&d.evaluate(s.visProp.attractordistance)&&d.evaluate(s.visProp.attractorunit)&&(c=l=1.1*d.evaluate(s.visProp.attractordistance),"screen"===d.evaluate(s.visProp.attractorunit)&&(l/=this.unitX,c/=this.unitX),u=Math.max(l,u),p=Math.max(c,p))),38===i.keyCode?n=[0,p]:40===i.keyCode?n=[0,-p]:37===i.keyCode?n=[-u,0]:39===i.keyCode?n=[u,0]:f&&"+"===i.key?this.zoomIn():f&&"-"===i.key?this.zoomOut():f&&"o"===i.key&&this.zoom100(),n&&s.isDraggable&&s.visPropCalc.visible&&(this.geonextCompatibilityMode&&(d.isPoint(s)||s.elementClass===e.OBJECT_CLASS_TEXT)||!this.geonextCompatibilityMode)&&!d.evaluate(s.visProp.fixed)&&(d.exists(s.coords)&&(n[0]+=a[0],n[1]+=a[1]),s.setPosition(t.COORDS_BY_USER,n),d.exists(s.coords)&&this.updateInfobox(s),this.triggerEventHandlers(["hit"],[i,s]))),this.update(),!0)},keyFocusInListener:function(t){var e,i,r=t.target.id;if(!this.attr.keyboard.enabled||""===r)return!1;e=r.replace(this.containerObj.id+"_",""),i=this.select(e),d.exists(i.highlight)&&i.highlight(!0),d.exists(i.coords)&&this.updateInfobox(i),this.triggerEventHandlers(["hit"],[t,i])},keyFocusOutListener:function(t){if(!this.attr.keyboard.enabled)return!1;this.dehighlightAll(),this.displayInfobox(!1)},updateContainerDims:function(){var t,e,i,r;t=(i=this.containerObj.getBoundingClientRect()).width,e=i.height,window&&window.getComputedStyle&&(r=window.getComputedStyle(this.containerObj,null),t-=parseFloat(r.getPropertyValue("border-left-width"))+parseFloat(r.getPropertyValue("border-right-width")),e-=parseFloat(r.getPropertyValue("border-top-width"))+parseFloat(r.getPropertyValue("border-bottom-width"))),t<=0||e<=0||(isNaN(this.getBoundingBox()[0])&&this.setBoundingBox(this.attr.boundingbox,this.keepaspectratio,"keep"),d.exists(this._prevDim)&&this._prevDim.w===t&&this._prevDim.h===e||(this.resizeContainer(t,e,!0),this._prevDim={w:t,h:e}))},startResizeObserver:function(){var t=this;p.isBrowser&&this.attr.resize&&this.attr.resize.enabled&&(this.resizeObserver=new ResizeObserver((function(e){t._isResizing||(t._isResizing=!0,window.setTimeout((function(){try{t.updateContainerDims()}catch(e){t.stopResizeObserver()}finally{t._isResizing=!1}}),t.attr.resize.throttle))})),this.resizeObserver.observe(this.containerObj))},stopResizeObserver:function(){p.isBrowser&&this.attr.resize&&this.attr.resize.enabled&&d.exists(this.resizeObserver)&&this.resizeObserver.unobserve(this.containerObj)},resizeListener:function(){var t=this;p.isBrowser&&this.attr.resize&&this.attr.resize.enabled&&(this._isScrolling||this._isResizing||(this._isResizing=!0,window.setTimeout((function(){t.updateContainerDims(),t._isResizing=!1}),this.attr.resize.throttle)))},scrollListener:function(t){var e=this;p.isBrowser&&(this._isScrolling||(this._isScrolling=!0,window.setTimeout((function(){e._isScrolling=!1}),66)))},startIntersectionObserver:function(){var t=this;try{this.intersectionObserver=new IntersectionObserver((function(e){isNaN(t.getBoundingBox()[0])&&t.updateContainerDims()}),{root:null,rootMargin:"0px",threshold:.8}),this.intersectionObserver.observe(t.containerObj)}catch(t){console.log("JSXGraph: IntersectionObserver not available in this browser.")}},stopIntersectionObserver:function(){d.exists(this.intersectionObserver)&&this.intersectionObserver.unobserve(this.containerObj)},initInfobox:function(){var t=d.copyAttributes({},this.options,"infobox");return t.id=this.id+"_infobox",this.infobox=this.create("text",[0,0,"0,0"],t),this.infobox.distanceX=-20,this.infobox.distanceY=25,this.infobox.dump=!1,this.displayInfobox(!1),this},updateInfobox:function(t){var e,i,r,s,o,n=d.evaluate(t.visProp.showinfobox);return!d.evaluate(this.attr.showinfobox)&&"inherit"===n||!n||d.isPoint(t)&&(r=t.coords.usrCoords[1],s=t.coords.usrCoords[2],o=d.evaluate(t.visProp.infoboxdigits),this.infobox.setCoords(r+this.infobox.distanceX/this.unitX,s+this.infobox.distanceY/this.unitY),"string"!=typeof t.infoboxText?("auto"===o?(e=d.autoDigits(r),i=d.autoDigits(s)):d.isNumber(o)?(e=d.toFixed(r,o),i=d.toFixed(s,o)):(e=r,i=s),this.highlightInfobox(e,i,t)):this.highlightCustomInfobox(t.infoboxText,t),this.displayInfobox(!0)),this},displayInfobox:function(t){return this.infobox.hiddenByParent===t&&(this.infobox.hiddenByParent=!t,this.infobox.prepareUpdate().updateVisibility(t).updateRenderer()),this},showInfobox:function(t){return this.displayInfobox(t)},highlightInfobox:function(t,e,i){return this.highlightCustomInfobox("("+t+", "+e+")",i),this},highlightCustomInfobox:function(t,e){return this.infobox.setText(t),this},dehighlightAll:function(){var t,e,i=!1;for(t in this.highlightedObjects)this.highlightedObjects.hasOwnProperty(t)&&(e=this.highlightedObjects[t],(this.hasMouseHandlers||this.hasPointerHandlers)&&e.noHighlight(),i=!0);return this.highlightedObjects={},"canvas"===this.renderer.type&&i&&(this.prepareUpdate(),this.renderer.suspendRedraw(this),this.updateRenderer(),this.renderer.unsuspendRedraw()),this},getScrCoordsOfMouse:function(t,e){return[t,e]},getUsrCoordsOfMouse:function(t){var r=this.getCoordsTopLeftCorner(),s=p.getPosition(t,null,this.document),o=s[0]-r[0],n=s[1]-r[1];return new i(e.COORDS_BY_SCREEN,[o,n],this).usrCoords.slice(1)},getAllUnderMouse:function(t){var e=this.getAllObjectsUnderMouse(t);return e.push(this.getUsrCoordsOfMouse(t)),e},getAllObjectsUnderMouse:function(t){var e,i,r=this.getCoordsTopLeftCorner(),s=p.getPosition(t,null,this.document),o=s[0]-r[0],n=s[1]-r[1],a=[],h=this.objectsList.length;for(e=0;e<h;e++)(i=this.objectsList[e]).visPropCalc.visible&&i.hasPoint&&i.hasPoint(o,n)&&(a[a.length]=i);return a},updateCoords:function(){var t,e,i=this.objectsList.length;for(e=0;e<i;e++)t=this.objectsList[e],d.exists(t.coords)&&(d.evaluate(t.visProp.frozen)?t.coords.screen2usr():t.coords.usr2screen());return this},moveOrigin:function(t,r,s){var o,n,a,h;return d.exists(t)&&d.exists(r)&&(o=this.origin.scrCoords[1],n=this.origin.scrCoords[2],this.origin.scrCoords[1]=t,this.origin.scrCoords[2]=r,s&&(this.origin.scrCoords[1]-=this.drag_dx,this.origin.scrCoords[2]-=this.drag_dy),a=new i(e.COORDS_BY_SCREEN,[0,0],this).usrCoords,h=new i(e.COORDS_BY_SCREEN,[this.canvasWidth,this.canvasHeight],this).usrCoords,(a[1]<this.maxboundingbox[0]||a[2]>this.maxboundingbox[1]||h[1]>this.maxboundingbox[2]||h[2]<this.maxboundingbox[3])&&(this.origin.scrCoords[1]=o,this.origin.scrCoords[2]=n)),this.updateCoords().clearTraces().fullUpdate(),this.triggerEventHandlers(["boundingbox"]),this},addConditions:function(i){var r,s,o,n,a,h,l,u=[],p=i.indexOf("<data>"),f=i.indexOf("</data>"),m=function(t,i,r,s){return function(){var o,n;n=(o=t.select(i.id)).coords.usrCoords[s],2===s?o.setPositionDirectly(e.COORDS_BY_USER,[r(),n]):o.setPositionDirectly(e.COORDS_BY_USER,[n,r()]),o.prepareUpdate().update()}},g=function(t,e,i){return function(){var r,s;r=t.select(e.id),s=i(),r.setAttribute({visible:s})}},b=function(t,e,i,r){return function(){var s,o;s=t.select(e.id),o=i(),"strokewidth"===r?s.visProp.strokewidth=o:(o=c.rgba2rgbo(o),s.visProp[r+"color"]=o[0],s.visProp[r+"opacity"]=o[1])}},v=function(t,e,i){return function(){t.select(e.id).position=i()}},y=function(t,e,i){return function(){t.select(e.id).setStyle(i())}};if(!(p<0)){for(;p>=0;){if(s=(r=i.slice(p+6,f)).indexOf("="),o=r.slice(0,s),n=r.slice(s+1),s=o.indexOf("."),a=o.slice(0,s),h=this.elementsByName[d.unescapeHTML(a)],l=o.slice(s+1).replace(/\s+/g,"").toLowerCase(),n=d.createFunction(n,this,"",!0),d.exists(this.elementsByName[a]))switch(l){case"x":u.push(m(this,h,n,2));break;case"y":u.push(m(this,h,n,1));break;case"visible":u.push(g(this,h,n));break;case"position":u.push(v(this,h,n));break;case"stroke":u.push(b(this,h,n,"stroke"));break;case"style":u.push(y(this,h,n));break;case"strokewidth":u.push(b(this,h,n,"strokewidth"));break;case"fill":u.push(b(this,h,n,"fill"));break;case"label":break;default:t.debug("property '"+l+"' in conditions not yet implemented:"+n)}else t.debug("debug conditions: |"+a+"| undefined");p=(i=i.slice(f+7)).indexOf("<data>"),f=i.indexOf("</data>")}this.updateConditions=function(){var t;for(t=0;t<u.length;t++)u[t]();return this.prepareUpdate().updateElements(),!0},this.updateConditions()}},updateConditions:function(){return!1},calculateSnapSizes:function(){var t=new i(e.COORDS_BY_USER,[0,0],this),r=new i(e.COORDS_BY_USER,[this.options.grid.gridX,this.options.grid.gridY],this),s=t.scrCoords[1]-r.scrCoords[1],o=t.scrCoords[2]-r.scrCoords[2];for(this.options.grid.snapSizeX=this.options.grid.gridX;Math.abs(s)>25;)this.options.grid.snapSizeX*=2,s/=2;for(this.options.grid.snapSizeY=this.options.grid.gridY;Math.abs(o)>25;)this.options.grid.snapSizeY*=2,o/=2;return this},applyZoom:function(){return this.updateCoords().calculateSnapSizes().clearTraces().fullUpdate(),this},zoomIn:function(t,e){var i=this.getBoundingBox(),r=this.attr.zoom.factorx,s=this.attr.zoom.factory,o=(i[2]-i[0])*(1-1/r),n=(i[1]-i[3])*(1-1/s),a=.5,h=.5,l=this.attr.zoom.eps||this.attr.zoom.min||.001;return this.zoomX>this.attr.zoom.max&&r>1||this.zoomY>this.attr.zoom.max&&s>1||this.zoomX<l&&r<1||this.zoomY<l&&s<1?this:(d.isNumber(t)&&d.isNumber(e)&&(a=(t-i[0])/(i[2]-i[0]),h=(i[1]-e)/(i[1]-i[3])),this.setBoundingBox([i[0]+o*a,i[1]-n*h,i[2]-o*(1-a),i[3]+n*(1-h)],this.keepaspectratio,"update"),this.applyZoom())},zoomOut:function(t,e){var i=this.getBoundingBox(),r=this.attr.zoom.factorx,s=this.attr.zoom.factory,o=(i[2]-i[0])*(1-r),n=(i[1]-i[3])*(1-s),a=.5,h=.5,l=this.attr.zoom.eps||this.attr.zoom.min||.001;return this.zoomX<l||this.zoomY<l?this:(d.isNumber(t)&&d.isNumber(e)&&(a=(t-i[0])/(i[2]-i[0]),h=(i[1]-e)/(i[1]-i[3])),this.setBoundingBox([i[0]+o*a,i[1]-n*h,i[2]-o*(1-a),i[3]+n*(1-h)],this.keepaspectratio,"update"),this.applyZoom())},zoom100:function(){var t,e,i;return d.exists(this.attr.boundingbox)?this.setBoundingBox(this.attr.boundingbox,this.keepaspectratio,"reset"):(e=((t=this.getBoundingBox())[2]-t[0])*(1-this.zoomX)*.5,i=(t[1]-t[3])*(1-this.zoomY)*.5,this.setBoundingBox([t[0]+e,t[1]-i,t[2]-e,t[3]+i],this.keepaspectratio,"reset")),this.applyZoom()},zoomAllPoints:function(){var t,e,i,r,s=0,o=0,n=0,a=0,h=this.objectsList.length;for(t=0;t<h;t++)r=this.objectsList[t],d.isPoint(r)&&r.visPropCalc.visible&&(r.coords.usrCoords[1]<s?s=r.coords.usrCoords[1]:r.coords.usrCoords[1]>o&&(o=r.coords.usrCoords[1]),r.coords.usrCoords[2]>a?a=r.coords.usrCoords[2]:r.coords.usrCoords[2]<n&&(n=r.coords.usrCoords[2]));return 50,e=50/this.unitX,i=50/this.unitY,this.setBoundingBox([s-e,a+i,o+e,n-i],this.keepaspectratio,"update"),this.applyZoom()},zoomElements:function(t){var e,i,r,s,o,n,a,h=[1/0,-1/0,-1/0,1/0];if(!d.isArray(t)||0===t.length)return this;for(e=0;e<t.length;e++)i=this.select(t[e]).bounds(),d.isArray(i)&&(i[0]<h[0]&&(h[0]=i[0]),i[1]>h[1]&&(h[1]=i[1]),i[2]>h[2]&&(h[2]=i[2]),i[3]<h[3]&&(h[3]=i[3]));return d.isArray(h)&&(r=.5*(h[0]+h[2]),s=.5*(h[1]+h[3]),o=1.5*(h[2]-h[0])*.5,n=1.5*(h[1]-h[3])*.5,a=Math.max(o,n),this.setBoundingBox([r-a,s+a,r+a,s-a],this.keepaspectratio,"update")),this},setZoom:function(t,e){var i=this.attr.zoom.factorx,r=this.attr.zoom.factory;return this.attr.zoom.factorx=t/this.zoomX,this.attr.zoom.factory=e/this.zoomY,this.zoomIn(),this.attr.zoom.factorx=i,this.attr.zoom.factory=r,this},removeObject:function(i,r){var s,o;if(d.isArray(i)){for(o=0;o<i.length;o++)this.removeObject(i[o]);return this}if(i=this.select(i),!d.exists(i)||d.isString(i))return this;try{for(s in i.childElements)i.childElements.hasOwnProperty(s)&&i.childElements[s].board.removeObject(i.childElements[s]);for(s in i.objects)i.objects.hasOwnProperty(s)&&i.objects[s].board.removeObject(i.objects[s]);if(r)for(s in this.objects)this.objects.hasOwnProperty(s)&&d.exists(this.objects[s].childElements)&&d.exists(this.objects[s].childElements.hasOwnProperty(i.id))&&(delete this.objects[s].childElements[i.id],delete this.objects[s].descendants[i.id]);else if(d.exists(i.ancestors))for(s in i.ancestors)i.ancestors.hasOwnProperty(s)&&d.exists(i.ancestors[s].childElements)&&d.exists(i.ancestors[s].childElements.hasOwnProperty(i.id))&&(delete i.ancestors[s].childElements[i.id],delete i.ancestors[s].descendants[i.id]);if(i._pos>-1)for(this.objectsList.splice(i._pos,1),s=i._pos;s<this.objectsList.length;s++)this.objectsList[s]._pos--;else i.type!==e.OBJECT_TYPE_TURTLE&&t.debug("Board.removeObject: object "+i.id+" not found in list.");delete this.objects[i.id],delete this.elementsByName[i.name],i.visProp&&d.evaluate(i.visProp.trace)&&i.clearTrace(),d.exists(i.remove)&&i.remove()}catch(e){t.debug(i.id+": Could not be removed: "+e)}return this.update(),this},removeAncestors:function(t){var e;for(e in t.ancestors)t.ancestors.hasOwnProperty(e)&&this.removeAncestors(t.ancestors[e]);return this.removeObject(t),this},initGeonextBoard:function(){var t,e,i;return t=this.create("point",[0,0],{id:this.id+"g00e0",name:"Ursprung",withLabel:!1,visible:!1,fixed:!0}),e=this.create("point",[1,0],{id:this.id+"gX0e0",name:"Punkt_1_0",withLabel:!1,visible:!1,fixed:!0}),i=this.create("point",[0,1],{id:this.id+"gY0e0",name:"Punkt_0_1",withLabel:!1,visible:!1,fixed:!0}),this.create("line",[t,e],{id:this.id+"gXLe0",name:"X-Achse",withLabel:!1,visible:!1}),this.create("line",[t,i],{id:this.id+"gYLe0",name:"Y-Achse",withLabel:!1,visible:!1}),this},resizeContainer:function(t,e,i,r){var s;return r||(s=this.getBoundingBox()),this.canvasWidth=parseFloat(t),this.canvasHeight=parseFloat(e),i||(this.containerObj.style.width=this.canvasWidth+"px",this.containerObj.style.height=this.canvasHeight+"px"),this.renderer.resize(this.canvasWidth,this.canvasHeight),r||this.setBoundingBox(s,this.keepaspectratio,"keep"),this},showDependencies:function(){var t,e,i,r,s;for(t in e="<p>\n",this.objects)if(this.objects.hasOwnProperty(t)){for(i in s=0,this.objects[t].childElements)this.objects[t].childElements.hasOwnProperty(i)&&(s+=1);for(i in s>=0&&(e+="<strong>"+this.objects[t].id+":</strong> "),this.objects[t].childElements)this.objects[t].childElements.hasOwnProperty(i)&&(e+=this.objects[t].childElements[i].id+"("+this.objects[t].childElements[i].name+"), ");e+="<p>\n"}return e+="</p>\n",(r=window.open()).document.open(),r.document.write(e),r.document.close(),this},showXML:function(){var t=window.open("");return t.document.open(),t.document.write("<pre>"+d.escapeHTML(this.xmlString)+"</pre>"),t.document.close(),this},prepareUpdate:function(){var t,e,i=this.objectsList.length;for(t=0;t<i;t++)(e=this.objectsList[t]).needsUpdate=e.needsRegularUpdate||this.needsFullUpdate;for(t in this.groups)this.groups.hasOwnProperty(t)&&((e=this.groups[t]).needsUpdate=e.needsRegularUpdate||this.needsFullUpdate);return this},updateElements:function(t){var i,r;for(t=this.select(t),i=0;i<this.objectsList.length;i++)r=this.objectsList[i],this.needsFullUpdate&&r.elementClass===e.OBJECT_CLASS_TEXT&&r.updateSize(),r.update(!d.exists(t)||r.id!==t.id).updateVisibility();for(i in this.groups)this.groups.hasOwnProperty(i)&&this.groups[i].update(t);return this},updateRenderer:function(){var t,e=this.objectsList.length;if("canvas"===this.renderer.type)this.updateRendererCanvas();else for(t=0;t<e;t++)this.objectsList[t].updateRenderer();return this},updateRendererCanvas:function(){var t,e,i,r,s,o=this.objectsList.length,n=this.options.layer,a=this.options.layer.numlayers,h=Number.NEGATIVE_INFINITY;for(i=0;i<a;i++){for(s in r=Number.POSITIVE_INFINITY,n)n.hasOwnProperty(s)&&n[s]>h&&n[s]<r&&(r=n[s]);for(h=r,t=0;t<o;t++)(e=this.objectsList[t]).visProp.layer===r&&e.prepareUpdate().updateRenderer()}return this},addHook:function(e,i,r){return t.deprecated("Board.addHook()","Board.on()"),i=d.def(i,"update"),r=d.def(r,this),this.hooks.push([i,e]),this.on(i,e,r),this.hooks.length-1},addEvent:t.shortcut(t.Board.prototype,"on"),removeHook:function(e){return t.deprecated("Board.removeHook()","Board.off()"),this.hooks[e]&&(this.off(this.hooks[e][0],this.hooks[e][1]),this.hooks[e]=null),this},removeEvent:t.shortcut(t.Board.prototype,"off"),updateHooks:function(e){var i=Array.prototype.slice.call(arguments,0);return t.deprecated("Board.updateHooks()","Board.triggerEventHandlers()"),i[0]=d.def(i[0],"update"),this.triggerEventHandlers([i[0]],arguments),this},addChild:function(t){return d.exists(t)&&d.exists(t.containerObj)&&(this.dependentBoards.push(t),this.update()),this},removeChild:function(t){var e;for(e=this.dependentBoards.length-1;e>=0;e--)this.dependentBoards[e]===t&&this.dependentBoards.splice(e,1);return this},update:function(t){var e,i,r,s,o;if(this.inUpdate||this.isSuspendedUpdate)return this;for(this.inUpdate=!0,"all"===this.attr.minimizereflow&&this.containerObj&&"vml"!==this.renderer.type&&(o=document.activeElement,s=this.renderer.removeToInsertLater(this.containerObj)),"svg"===this.attr.minimizereflow&&"svg"===this.renderer.type&&(o=document.activeElement,s=this.renderer.removeToInsertLater(this.renderer.svgRoot)),this.prepareUpdate().updateElements(t).updateConditions(),this.renderer.suspendRedraw(this),this.updateRenderer(),this.renderer.unsuspendRedraw(),this.triggerEventHandlers(["update"],[]),s&&(s(),o.focus()),i=this.dependentBoards.length,e=0;e<i;e++)r=this.dependentBoards[e],d.exists(r)&&r!==this&&(r.updateQuality=this.updateQuality,r.prepareUpdate().updateElements().updateConditions(),r.renderer.suspendRedraw(),r.updateRenderer(),r.renderer.unsuspendRedraw(),r.triggerEventHandlers(["update"],[]));return this.inUpdate=!1,this},fullUpdate:function(){return this.needsFullUpdate=!0,this.update(),this.needsFullUpdate=!1,this},addGrid:function(){return this.create("grid",[]),this},removeGrids:function(){var t;for(t=0;t<this.grids.length;t++)this.removeObject(this.grids[t]);return this.grids.length=0,this.update(),this},create:function(e,i,r){var s,o;for(e=e.toLowerCase(),d.exists(i)||(i=[]),d.exists(r)||(r={}),o=0;o<i.length;o++)!d.isString(i[o])||"text"===e&&2===o||!("input"!==e&&"checkbox"!==e&&"button"!==e||2!==o&&3!==o)||"curve"===e&&o>0||(i[o]=this.select(i[o]));if(!d.isFunction(t.elements[e]))throw new Error("JSXGraph: create: Unknown element type given: "+e);return s=t.elements[e](this,i,r),d.exists(s)?(s.prepareUpdate&&s.update&&s.updateRenderer&&s.fullUpdate(),s):(t.debug("JSXGraph: create: failure creating "+e),s)},createElement:function(){return t.deprecated("Board.createElement()","Board.create()"),this.create.apply(this,arguments)},clearTraces:function(){var t;for(t=0;t<this.objectsList.length;t++)this.objectsList[t].clearTrace();return this.numTraces=0,this},suspendUpdate:function(){return this.inUpdate||(this.isSuspendedUpdate=!0),this},unsuspendUpdate:function(){return this.isSuspendedUpdate&&(this.isSuspendedUpdate=!1,this.fullUpdate()),this},setBoundingBox:function(t,e,i){var r,s,o,n,a=0,h=0,l=p.getDimensions(this.container,this.document);return d.isArray(t)?(t[0]<this.maxboundingbox[0]||t[1]>this.maxboundingbox[1]||t[2]>this.maxboundingbox[2]||t[3]<this.maxboundingbox[3]||(d.exists(i)||(i="reset"),o=this.unitX,n=this.unitY,this.canvasWidth=parseInt(l.width,10),this.canvasHeight=parseInt(l.height,10),s=this.canvasWidth,r=this.canvasHeight,e?(this.unitX=s/(t[2]-t[0]),this.unitY=r/(t[1]-t[3]),Math.abs(this.unitX)<Math.abs(this.unitY)?(this.unitY=Math.abs(this.unitX)*this.unitY/Math.abs(this.unitY),h=.5*(r/this.unitY-(t[1]-t[3]))):(this.unitX=Math.abs(this.unitY)*this.unitX/Math.abs(this.unitX),a=.5*(s/this.unitX-(t[2]-t[0]))),this.keepaspectratio=!0):(this.unitX=s/(t[2]-t[0]),this.unitY=r/(t[1]-t[3]),this.keepaspectratio=!1),this.moveOrigin(-this.unitX*(t[0]-a),this.unitY*(t[1]+h)),"update"===i?(this.zoomX*=this.unitX/o,this.zoomY*=this.unitY/n):"reset"===i&&(this.zoomX=d.exists(this.attr.zoomx)?this.attr.zoomx:1,this.zoomY=d.exists(this.attr.zoomy)?this.attr.zoomy:1)),this):this},getBoundingBox:function(){var t=new i(e.COORDS_BY_SCREEN,[0,0],this).usrCoords,r=new i(e.COORDS_BY_SCREEN,[this.canvasWidth,this.canvasHeight],this).usrCoords;return[t[1],t[2],r[1],r[2]]},addAnimation:function(t){var e=this;return this.animationObjects[t.id]=t,this.animationIntervalCode||(this.animationIntervalCode=window.setInterval((function(){e.animate()}),t.board.attr.animationdelay)),this},stopAllAnimation:function(){var t;for(t in this.animationObjects)this.animationObjects.hasOwnProperty(t)&&d.exists(this.animationObjects[t])&&(this.animationObjects[t]=null,delete this.animationObjects[t]);return window.clearInterval(this.animationIntervalCode),delete this.animationIntervalCode,this},animate:function(){var t,i,r,s,o,n,a,h,l=0,c=null;for(i in this.animationObjects)if(this.animationObjects.hasOwnProperty(i)&&d.exists(this.animationObjects[i])){if(l+=1,(r=this.animationObjects[i]).animationPath&&(s=d.isFunction(r.animationPath)?r.animationPath((new Date).getTime()-r.animationStart):r.animationPath.pop(),!d.exists(s)||!d.isArray(s)&&isNaN(s)?delete r.animationPath:(r.setPositionDirectly(e.COORDS_BY_USER,s),r.fullUpdate(),c=r)),r.animationData){for(o in a=0,r.animationData)r.animationData.hasOwnProperty(o)&&(n=r.animationData[o].pop(),d.exists(n)?(a+=1,(t={})[o]=n,r.setAttribute(t)):delete r.animationData[n]);0===a&&delete r.animationData}d.exists(r.animationData)||d.exists(r.animationPath)||(this.animationObjects[i]=null,delete this.animationObjects[i],d.exists(r.animationCallback)&&(h=r.animationCallback,r.animationCallback=null,h()))}return 0===l?(window.clearInterval(this.animationIntervalCode),delete this.animationIntervalCode):this.update(c),this},migratePoint:function(t,e,i){var r,s,o,n,a,h,l=!1;for(s in t=this.select(t),e=this.select(e),d.exists(t.label)&&(h=t.label.id,l=!0,this.removeObject(t.label)),t.childElements)if(t.childElements.hasOwnProperty(s)){for(o in n=!1,r=t.childElements[s])r.hasOwnProperty(o)&&r[o]===t&&(r[o]=e,n=!0);for(n&&delete t.childElements[s],a=0;a<r.parents.length;a++)r.parents[a]===t.id&&(r.parents[a]=e.id);e.addChild(r)}return i&&(l&&(delete e.childElements[h],delete e.descendants[h]),e.label&&this.removeObject(e.label),delete this.elementsByName[e.name],e.name=t.name,l&&e.createLabel()),this.removeObject(t),d.exists(e.name)&&""!==e.name&&(this.elementsByName[e.name]=e),this.fullUpdate(),this},emulateColorblindness:function(e){var i,r;if(d.exists(e)||(e="none"),this.currentCBDef===e)return this;for(i in this.objects)this.objects.hasOwnProperty(i)&&(r=this.objects[i],"none"!==e?("none"===this.currentCBDef&&(r.visPropOriginal={strokecolor:r.visProp.strokecolor,fillcolor:r.visProp.fillcolor,highlightstrokecolor:r.visProp.highlightstrokecolor,highlightfillcolor:r.visProp.highlightfillcolor}),r.setAttribute({strokecolor:c.rgb2cb(d.evaluate(r.visPropOriginal.strokecolor),e),fillcolor:c.rgb2cb(d.evaluate(r.visPropOriginal.fillcolor),e),highlightstrokecolor:c.rgb2cb(d.evaluate(r.visPropOriginal.highlightstrokecolor),e),highlightfillcolor:c.rgb2cb(d.evaluate(r.visPropOriginal.highlightfillcolor),e)})):d.exists(r.visPropOriginal)&&t.extend(r.visProp,r.visPropOriginal));return this.currentCBDef=e,this.update(),this},select:function(t,e){var i,r,s,o,n=t;if(null===n)return n;if(d.isString(n)&&""!==n)d.exists(this.objects[n])?n=this.objects[n]:d.exists(this.elementsByName[n])?n=this.elementsByName[n]:d.exists(this.groups[n])&&(n=this.groups[n]);else if(!e&&(d.isFunction(n)||d.isObject(n)&&!d.isFunction(n.setAttribute))){for(r={},o=(i=d.filterElements(this.objectsList,n)).length,s=0;s<o;s++)r[i[s].id]=i[s];n=new f(r)}else d.isObject(n)&&d.exists(n.id)&&!d.exists(this.objects[n.id])&&(n=null);return n},hasPoint:function(t,e){var i=t,r=e,s=this.getBoundingBox();return d.exists(t)&&d.isArray(t.usrCoords)&&(i=t.usrCoords[1],r=t.usrCoords[2]),!!(d.isNumber(i)&&d.isNumber(r)&&s[0]<i&&i<s[2]&&s[1]>r&&r>s[3])},updateCSSTransforms:function(){var t=this.containerObj,e=t,i=t;for(this.cssTransMat=p.getCSSTransformMatrix(e),e=e.offsetParent;e;){for(this.cssTransMat=o.matMatMult(p.getCSSTransformMatrix(e),this.cssTransMat),i=i.parentNode;i!==e;)this.cssTransMat=o.matMatMult(p.getCSSTransformMatrix(e),this.cssTransMat),i=i.parentNode;e=e.offsetParent}return this.cssTransMat=o.inverse(this.cssTransMat),this},startSelectionMode:function(){this.selectingMode=!0,this.selectionPolygon.setAttribute({visible:!0}),this.selectingBox=[[0,0],[0,0]],this._setSelectionPolygonFromBox(),this.selectionPolygon.fullUpdate()},stopSelectionMode:function(){return this.selectingMode=!1,this.selectionPolygon.setAttribute({visible:!1}),[this.selectionPolygon.vertices[0].coords,this.selectionPolygon.vertices[2].coords]},_startSelecting:function(t){this.isSelecting=!0,this.selectingBox=[[t[0],t[1]],[t[0],t[1]]],this._setSelectionPolygonFromBox()},_moveSelecting:function(t){this.isSelecting&&(this.selectingBox[1]=[t[0],t[1]],this._setSelectionPolygonFromBox(),this.selectionPolygon.fullUpdate())},_stopSelecting:function(t){var e=this.getMousePosition(t);this.isSelecting=!1,this.selectingBox[1]=[e[0],e[1]],this._setSelectionPolygonFromBox()},_setSelectionPolygonFromBox:function(){var e=this.selectingBox[0],i=this.selectingBox[1];this.selectionPolygon.vertices[0].setPositionDirectly(t.COORDS_BY_SCREEN,[e[0],e[1]]),this.selectionPolygon.vertices[1].setPositionDirectly(t.COORDS_BY_SCREEN,[e[0],i[1]]),this.selectionPolygon.vertices[2].setPositionDirectly(t.COORDS_BY_SCREEN,[i[0],i[1]]),this.selectionPolygon.vertices[3].setPositionDirectly(t.COORDS_BY_SCREEN,[i[0],e[1]])},_testForSelection:function(t){this._isRequiredKeyPressed(t,"selection")&&(d.exists(this.selectionPolygon)||this._createSelectionPolygon(this.attr),this.startSelectionMode())},_createSelectionPolygon:function(t){var e;return d.exists(this.selectionPolygon)||!0===(e=d.copyAttributes(t,r,"board","selection")).enabled&&(this.selectionPolygon=this.create("polygon",[[0,0],[0,0],[0,0],[0,0]],e)),this},__evt__down:function(t){},__evt__mousedown:function(t){},__evt__pendown:function(t){},__evt__pointerdown:function(t){},__evt__touchstart:function(t){},__evt__up:function(t){},__evt__mouseup:function(t){},__evt__pointerup:function(t){},__evt__touchend:function(t){},__evt__move:function(t,e){},__evt__mousemove:function(t,e){},__evt__penmove:function(t,e){},__evt__pointermove:function(t,e){},__evt__touchmove:function(t,e){},__evt__hit:function(t,e,i){},__evt__mousehit:function(t,e,i){},__evt__update:function(){},__evt__boundingbox:function(){},__evt__startselecting:function(){},__evt__mousestartselecting:function(){},__evt__pointerstartselecting:function(){},__evt__touchstartselecting:function(){},__evt__stopselecting:function(){},__evt__mousestopselecting:function(){},__evt__pointerstopselecting:function(){},__evt__touchstopselecting:function(){},__evt__moveselecting:function(){},__evt__mousemoveselecting:function(){},__evt__pointermoveselecting:function(){},__evt__touchmoveselecting:function(){},__evt:function(){},toFullscreen:function(t){var e,i,r;return t=t||this.container,this._fullscreen_inner_id=t,r=document.getElementById(t),e="fullscreenwrap_"+t,this.document.getElementById(e)?i=this.document.getElementById(e):((i=document.createElement("div")).classList.add("JXG_wrap_private"),i.setAttribute("id",e),r.parentNode.insertBefore(i,r),i.appendChild(r)),this._fullscreen_res=p._getScaleFactors(r),i.requestFullscreen=i.requestFullscreen||i.webkitRequestFullscreen||i.mozRequestFullScreen||i.msRequestFullscreen,i.requestFullscreen&&i.requestFullscreen(),this},fullscreenListener:function(t){var e,i,r;if(i=this._fullscreen_inner_id,d.exists(i)){if(document.fullscreenElement=document.fullscreenElement||document.webkitFullscreenElement||document.mozFullscreenElement||document.msFullscreenElement,r=document.getElementById(i),document.fullscreenElement)e=this._fullscreen_res,r._cssFullscreenStore={id:document.fullscreenElement.id,isFullscreen:!0,margin:r.style.margin,width:r.style.width,scale:e.scale,vshift:e.vshift},r.style.margin="",r.style.width=e.width+"px",p.scaleJSXGraphDiv(document.fullscreenElement.id,i,e.scale,e.vshift),document.fullscreenElement=null;else if(d.exists(r._cssFullscreenStore)){try{document.styleSheets[document.styleSheets.length-1].deleteRule(0)}catch(t){console.log("JSXGraph: Could not remove CSS rules for full screen mode")}r._cssFullscreenStore.isFullscreen=!1,r.style.margin=r._cssFullscreenStore.margin,r.style.width=r._cssFullscreenStore.width}this.updateCSSTransforms()}},createRoulette:function(t,e,i,r,o,n,h){var l=this;return new function(){var c,d=0,u=0,p=0,f=i,m=s.root((function(i){var r=t.X(f),s=t.Y(f),o=e.X(i),n=e.Y(i);return(r-o)*(r-o)+(s-n)*(s-n)}),[0,2*Math.PI]),g=0,b=0,v=l.create("transform",[function(){return d}],{type:"rotate"}),y=l.create("transform",[function(){return d},function(){return t.X(f)},function(){return t.Y(f)}],{type:"rotate"}),C=l.create("transform",[function(){return u},function(){return p}],{type:"translate"}),_=function(t,e,i){var r=s.D(t.X)(e),o=s.D(t.Y)(e),n=s.D(t.X)(i),a=s.D(t.Y)(i),h=s.D(t.X)(.5*(e+i)),l=s.D(t.Y)(.5*(e+i)),c=Math.sqrt(r*r+o*o),d=Math.sqrt(n*n+a*a);return(c+4*Math.sqrt(h*h+l*l)+d)*(i-e)/6},P=function(t){return c-_(e,m,t)},E=Math.PI/18,S=9*E,x=null;return this.rolling=function(){var i,n,x,O,w;c=_(t,f,g=f+o*r),b=s.root(P,m),i=new a(t.X(g),t.Y(g)),n=new a(e.X(b),e.Y(b)),x=new a(s.D(t.X)(g),s.D(t.Y)(g)),O=new a(s.D(e.X)(b),s.D(e.Y)(b)),w=a.C.div(x,O),d=Math.atan2(w.imaginary,w.real),w.div(a.C.abs(w)),w.mult(n),u=i.real-w.real,p=i.imaginary-w.imaginary,d<-E&&d>-S?(d=-E,y.applyOnce(h)):d>E&&d<S?(d=E,y.applyOnce(h)):(v.applyOnce(h),C.applyOnce(h),f=g,m=b),l.update()},this.start=function(){return n>0&&(x=window.setInterval(this.rolling,n)),this},this.stop=function(){return window.clearInterval(x),this},this}}}),t.Board})),define("renderer/svg",["jxg","options","renderer/abstract","base/constants","utils/type","utils/color","utils/base64","math/numerics"],(function(t,e,i,r,s,o,n,a){"use strict";return t.SVGRenderer=function(t,i){var r;for(this.type="svg",this.isIE=-1!==navigator.appVersion.indexOf("MSIE")||navigator.userAgent.match(/Trident\//),this.svgRoot=null,this.svgNamespace="http://www.w3.org/2000/svg",this.xlinkNamespace="http://www.w3.org/1999/xlink",this.container=t,this.container.style.MozUserSelect="none",this.container.style.userSelect="none",this.container.style.overflow="hidden",""===this.container.style.position&&(this.container.style.position="relative"),this.svgRoot=this.container.ownerDocument.createElementNS(this.svgNamespace,"svg"),this.svgRoot.style.overflow="hidden",this.svgRoot.style.display="block",this.resize(i.width,i.height),this.container.appendChild(this.svgRoot),this.defs=this.container.ownerDocument.createElementNS(this.svgNamespace,"defs"),this.svgRoot.appendChild(this.defs),this.filter=this.container.ownerDocument.createElementNS(this.svgNamespace,"filter"),this.filter.setAttributeNS(null,"id",this.container.id+"_f1"),this.filter.setAttributeNS(null,"width","300%"),this.filter.setAttributeNS(null,"height","300%"),this.filter.setAttributeNS(null,"filterUnits","userSpaceOnUse"),this.feOffset=this.container.ownerDocument.createElementNS(this.svgNamespace,"feOffset"),this.feOffset.setAttributeNS(null,"result","offOut"),this.feOffset.setAttributeNS(null,"in","SourceAlpha"),this.feOffset.setAttributeNS(null,"dx","5"),this.feOffset.setAttributeNS(null,"dy","5"),this.filter.appendChild(this.feOffset),this.feGaussianBlur=this.container.ownerDocument.createElementNS(this.svgNamespace,"feGaussianBlur"),this.feGaussianBlur.setAttributeNS(null,"result","blurOut"),this.feGaussianBlur.setAttributeNS(null,"in","offOut"),this.feGaussianBlur.setAttributeNS(null,"stdDeviation","3"),this.filter.appendChild(this.feGaussianBlur),this.feBlend=this.container.ownerDocument.createElementNS(this.svgNamespace,"feBlend"),this.feBlend.setAttributeNS(null,"in","SourceGraphic"),this.feBlend.setAttributeNS(null,"in2","blurOut"),this.feBlend.setAttributeNS(null,"mode","normal"),this.filter.appendChild(this.feBlend),this.defs.appendChild(this.filter),this.layer=[],r=0;r<e.layer.numlayers;r++)this.layer[r]=this.container.ownerDocument.createElementNS(this.svgNamespace,"g"),this.svgRoot.appendChild(this.layer[r]);this.supportsForeignObject=document.implementation.hasFeature("http://w3.org/TR/SVG11/feature#Extensibility","1.1"),this.supportsForeignObject&&(this.foreignObjLayer=this.container.ownerDocument.createElementNS(this.svgNamespace,"foreignObject"),this.foreignObjLayer.setAttribute("display","none"),this.foreignObjLayer.setAttribute("x",0),this.foreignObjLayer.setAttribute("y",0),this.foreignObjLayer.setAttribute("width","100%"),this.foreignObjLayer.setAttribute("height","100%"),this.foreignObjLayer.setAttribute("id",this.container.id+"_foreignObj"),this.svgRoot.appendChild(this.foreignObjLayer)),this.dashArray=["2, 2","5, 5","10, 10","20, 20","20, 10, 10, 10","20, 5, 10, 5"]},t.SVGRenderer.prototype=new i,t.extend(t.SVGRenderer.prototype,{_createArrowHead:function(t,e,i){var o,n,a,h,l=t.id+"Triangle";return s.exists(e)&&(l+=e),(o=this.createPrim("marker",l)).setAttributeNS(null,"stroke",s.evaluate(t.visProp.strokecolor)),o.setAttributeNS(null,"stroke-opacity",s.evaluate(t.visProp.strokeopacity)),o.setAttributeNS(null,"fill",s.evaluate(t.visProp.strokecolor)),o.setAttributeNS(null,"fill-opacity",s.evaluate(t.visProp.strokeopacity)),o.setAttributeNS(null,"stroke-width",0),o.setAttributeNS(null,"orient","auto"),o.setAttributeNS(null,"markerUnits","strokeWidth"),n=this.container.ownerDocument.createElementNS(this.svgNamespace,"path"),h=5,"End"===e?(a=0,2===i?n.setAttributeNS(null,"d","M 10,0 L 0,5 L 10,10 L 5,5 z"):3===i?n.setAttributeNS(null,"d","M 0,0 L 3.33,0 L 3.33,10 L 0,10 z"):4===i?(h=3.31,n.setAttributeNS(null,"d","M 0.00,3.31 C 3.53,3.84 7.13,4.50 10.00,6.63 C 9.33,5.52 8.67,4.42 8.00,3.31 C 8.67,2.21 9.33,1.10 10.00,0.00 C 7.13,2.13 3.53,2.79 0.00,3.31")):5===i?(h=3.28,n.setAttributeNS(null,"d","M 0.00,3.28 C 3.39,4.19 6.81,5.07 10.00,6.55 C 9.38,5.56 9.00,4.44 9.00,3.28 C 9.00,2.11 9.38,0.99 10.00,0.00 C 6.81,1.49 3.39,2.37 0.00,3.28")):6===i?(h=2.84,n.setAttributeNS(null,"d","M 0.00,2.84 C 3.39,3.59 6.79,4.35 10.00,5.68 C 9.67,4.73 9.33,3.78 9.00,2.84 C 9.33,1.89 9.67,0.95 10.00,0.00 C 6.79,1.33 3.39,2.09 0.00,2.84")):7===i?(h=5.2,n.setAttributeNS(null,"d","M 0.00,5.20 C 4.04,5.20 7.99,6.92 10.00,10.39 M 10.00,0.00 C 7.99,3.47 4.04,5.20 0.00,5.20")):n.setAttributeNS(null,"d","M 10,0 L 0,5 L 10,10 z"),/*!Type.exists(el.rendNode.getTotalLength) && */t.elementClass===r.OBJECT_CLASS_LINE&&(a=2===i?4.9:3===i?3.3:4===i||5===i||6===i?6.66:7===i?0:10)):(a=10,2===i?n.setAttributeNS(null,"d","M 0,0 L 10,5 L 0,10 L 5,5 z"):3===i?(a=3.3,n.setAttributeNS(null,"d","M 0,0 L 3.33,0 L 3.33,10 L 0,10 z")):4===i?(h=3.31,n.setAttributeNS(null,"d","M 10.00,3.31 C 6.47,3.84 2.87,4.50 0.00,6.63 C 0.67,5.52 1.33,4.42 2.00,3.31 C 1.33,2.21 0.67,1.10 0.00,0.00 C 2.87,2.13 6.47,2.79 10.00,3.31")):5===i?(h=3.28,n.setAttributeNS(null,"d","M 10.00,3.28 C 6.61,4.19 3.19,5.07 0.00,6.55 C 0.62,5.56 1.00,4.44 1.00,3.28 C 1.00,2.11 0.62,0.99 0.00,0.00 C 3.19,1.49 6.61,2.37 10.00,3.28")):6===i?(h=2.84,n.setAttributeNS(null,"d","M 10.00,2.84 C 6.61,3.59 3.21,4.35 0.00,5.68 C 0.33,4.73 0.67,3.78 1.00,2.84 C 0.67,1.89 0.33,0.95 0.00,0.00 C 3.21,1.33 6.61,2.09 10.00,2.84")):7===i?(h=5.2,n.setAttributeNS(null,"d","M 10.00,5.20 C 5.96,5.20 2.01,6.92 0.00,10.39 M 0.00,0.00 C 2.01,3.47 5.96,5.20 10.00,5.20")):n.setAttributeNS(null,"d","M 0,0 L 10,5 L 0,10 z"),/*!Type.exists(el.rendNode.getTotalLength) &&*/t.elementClass===r.OBJECT_CLASS_LINE&&(a=2===i?5.1:3===i?.02:4===i||5===i||6===i?3.33:7===i?10:.05)),7===i&&(o.setAttributeNS(null,"fill","none"),o.setAttributeNS(null,"stroke-width",1)),o.setAttributeNS(null,"refY",h),o.setAttributeNS(null,"refX",a),o.appendChild(n),o},_setArrowColor:function(t,e,i,r,o){t&&(s.isString(e)&&(7!==o?this._setAttribute((function(){t.setAttributeNS(null,"stroke",e),t.setAttributeNS(null,"fill",e),t.setAttributeNS(null,"stroke-opacity",i),t.setAttributeNS(null,"fill-opacity",i)}),r.visPropOld.fillcolor):this._setAttribute((function(){t.setAttributeNS(null,"fill","none"),t.setAttributeNS(null,"stroke",e),t.setAttributeNS(null,"stroke-opacity",i)}),r.visPropOld.fillcolor)),this.isIE&&r.rendNode.parentNode.insertBefore(r.rendNode,r.rendNode))},_setArrowWidth:function(t,e,i,r){var s,o;t&&(o=(s=e)*r,t.setAttributeNS(null,"viewBox","0 0 "+10*s+" "+10*s),t.setAttributeNS(null,"markerHeight",o),t.setAttributeNS(null,"markerWidth",o),t.setAttributeNS(null,"display","inherit"),this.isIE&&i.parentNode.insertBefore(i,i))},updateTicks:function(t){var e,i,r,o,n,a,h,l,c="",d=t.ticks.length,u=!0;for(e=0;e<d;e++){for(n=(r=t.ticks[e])[0],a=r[1],h=n.length,l=" M "+n[0]+" "+a[0],s.isNumber(n[0])||(u=!1),i=1;u&&i<h;++i)s.isNumber(n[i])?l+=" L "+n[i]+" "+a[i]:u=!1;u&&(c+=l)}o=t.rendNode,s.exists(o)||(o=this.createPrim("path",t.id),this.appendChildPrim(o,s.evaluate(t.visProp.layer)),t.rendNode=o),o.setAttributeNS(null,"stroke",s.evaluate(t.visProp.strokecolor)),o.setAttributeNS(null,"fill","none"),o.setAttributeNS(null,"stroke-opacity",s.evaluate(t.visProp.strokeopacity)),o.setAttributeNS(null,"stroke-width",s.evaluate(t.visProp.strokewidth)),this.updatePathPrim(o,c,t.board)},displayCopyright:function(t,e){var i,r=this.createPrim("text","licenseText");r.setAttributeNS(null,"x","20px"),r.setAttributeNS(null,"y",2+e+"px"),r.setAttributeNS(null,"style","font-family:Arial,Helvetica,sans-serif; font-size:"+e+"px; fill:#356AA0;  opacity:0.3;"),i=this.container.ownerDocument.createTextNode(t),r.appendChild(i),this.appendChildPrim(r,0)},drawInternalText:function(t){var e=this.createPrim("text",t.id);return e.style.whiteSpace="nowrap",t.rendNodeText=this.container.ownerDocument.createTextNode(""),e.appendChild(t.rendNodeText),this.appendChildPrim(e,s.evaluate(t.visProp.layer)),e},updateInternalText:function(t){var e,i=t.plaintext,r=t.getAnchorX(),o=t.getAnchorY();t.rendNode.getAttributeNS(null,"class")!==t.visProp.cssclass&&(t.rendNode.setAttributeNS(null,"class",s.evaluate(t.visProp.cssclass)),t.needsSizeUpdate=!0),isNaN(t.coords.scrCoords[1]+t.coords.scrCoords[2])||(e=t.coords.scrCoords[1],t.visPropOld.left!==r+e&&(t.rendNode.setAttributeNS(null,"x",e+"px"),"left"===r?t.rendNode.setAttributeNS(null,"text-anchor","start"):"right"===r?t.rendNode.setAttributeNS(null,"text-anchor","end"):"middle"===r&&t.rendNode.setAttributeNS(null,"text-anchor","middle"),t.visPropOld.left=r+e),e=t.coords.scrCoords[2],t.visPropOld.top!==o+e&&(t.rendNode.setAttributeNS(null,"y",e+.5*this.vOffsetText+"px"),"bottom"===o?t.rendNode.setAttributeNS(null,"dominant-baseline","text-after-edge"):"top"===o?t.rendNode.setAttributeNS(null,"dy","1.6ex"):"middle"===o&&t.rendNode.setAttributeNS(null,"dy","0.6ex"),t.visPropOld.top=o+e)),t.htmlStr!==i&&(t.rendNodeText.data=i,t.htmlStr=i),this.transformImage(t,t.transformations)},updateInternalTextStyle:function(t,e,i,r){this.setObjectFillColor(t,e,i)},drawImage:function(t){var e=this.createPrim("image",t.id);e.setAttributeNS(null,"preserveAspectRatio","none"),this.appendChildPrim(e,s.evaluate(t.visProp.layer)),t.rendNode=e,this.updateImage(t)},transformImage:function(t,e){var i,r=t.rendNode,s="";e.length>0&&(s+=" matrix("+[(i=this.joinTransforms(t,e))[1][1],i[2][1],i[1][2],i[2][2],i[1][0],i[2][0]].join(",")+") ",r.setAttributeNS(null,"transform",s))},updateImageURL:function(t){var e=s.evaluate(t.url);return t._src!==e&&(t.imgIsLoaded=!1,t.rendNode.setAttributeNS(this.xlinkNamespace,"xlink:href",e),t._src=e,!0)},updateImageStyle:function(t,e){var i=s.evaluate(e?t.visProp.highlightcssclass:t.visProp.cssclass);t.rendNode.setAttributeNS(null,"class",i)},drawForeignObject:function(t){t.rendNode=this.appendChildPrim(this.createPrim("foreignObject",t.id),s.evaluate(t.visProp.layer)),this.appendNodesToElement(t,"foreignObject"),this.updateForeignObject(t)},updateForeignObject:function(t){t._useUserSize?t.rendNode.style.overflow="hidden":t.rendNode.style.overflow="visible",this.updateRectPrim(t.rendNode,t.coords.scrCoords[1],t.coords.scrCoords[2]-t.size[1],t.size[0],t.size[1]),t.rendNode.innerHTML=t.content,this._updateVisual(t,{stroke:!0,dash:!0},!0)},appendChildPrim:function(t,i){return s.exists(i)?i>=e.layer.numlayers&&(i=e.layer.numlayers-1):i=0,this.layer[i].appendChild(t),t},createPrim:function(t,e){var i=this.container.ownerDocument.createElementNS(this.svgNamespace,t);return i.setAttributeNS(null,"id",this.container.id+"_"+e),i.style.position="absolute","path"===t&&(i.setAttributeNS(null,"stroke-linecap","round"),i.setAttributeNS(null,"stroke-linejoin","round"),i.setAttributeNS(null,"fill-rule","evenodd")),i},remove:function(t){s.exists(t)&&s.exists(t.parentNode)&&t.parentNode.removeChild(t)},setLayer:function(t,i){s.exists(i)?i>=e.layer.numlayers&&(i=e.layer.numlayers-1):i=0,this.layer[i].appendChild(t.rendNode)},makeArrows:function(t,e){var i,r=e.evFirst,o=e.evLast;t.visPropOld.firstarrow!==r||t.visPropOld.lastarrow!==o?(r?(i=t.rendNodeTriangleStart,s.exists(i)?this.defs.appendChild(i):(i=this._createArrowHead(t,"End",e.typeFirst),this.defs.appendChild(i),t.rendNodeTriangleStart=i,t.rendNode.setAttributeNS(null,"marker-start","url(#"+this.container.id+"_"+t.id+"TriangleEnd)"))):(i=t.rendNodeTriangleStart,s.exists(i)&&this.remove(i)),o?(i=t.rendNodeTriangleEnd,s.exists(i)?this.defs.appendChild(i):(i=this._createArrowHead(t,"Start",e.typeLast),this.defs.appendChild(i),t.rendNodeTriangleEnd=i,t.rendNode.setAttributeNS(null,"marker-end","url(#"+this.container.id+"_"+t.id+"TriangleStart)"))):(i=t.rendNodeTriangleEnd,s.exists(i)&&this.remove(i)),t.visPropOld.firstarrow=r,t.visPropOld.lastarrow=o):this.isIE&&t.visPropCalc.visible&&(r||o)&&t.rendNode.parentNode.insertBefore(t.rendNode,t.rendNode)},updateEllipsePrim:function(t,e,i,r,s){var o;o=2e5,e=Math.abs(e)<o?e:o*e/Math.abs(e),i=Math.abs(i)<o?i:o*i/Math.abs(i),r=Math.abs(r)<o?r:o*r/Math.abs(r),s=Math.abs(s)<o?s:o*s/Math.abs(s),t.setAttributeNS(null,"cx",e),t.setAttributeNS(null,"cy",i),t.setAttributeNS(null,"rx",Math.abs(r)),t.setAttributeNS(null,"ry",Math.abs(s))},updateLinePrim:function(t,e,i,r,s){var o;o=2e5,isNaN(e+i+r+s)||(e=Math.abs(e)<o?e:o*e/Math.abs(e),i=Math.abs(i)<o?i:o*i/Math.abs(i),r=Math.abs(r)<o?r:o*r/Math.abs(r),s=Math.abs(s)<o?s:o*s/Math.abs(s),t.setAttributeNS(null,"x1",e),t.setAttributeNS(null,"y1",i),t.setAttributeNS(null,"x2",r),t.setAttributeNS(null,"y2",s))},updatePathPrim:function(t,e){""===e&&(e="M 0 0"),t.setAttributeNS(null,"d",e)},updatePathStringPoint:function(t,e,i){var r="",s=t.coords.scrCoords,o=e*Math.sqrt(3)*.5,n=.5*e;return"x"===i?r=" M "+(s[1]-e)+" "+(s[2]-e)+" L "+(s[1]+e)+" "+(s[2]+e)+" M "+(s[1]+e)+" "+(s[2]-e)+" L "+(s[1]-e)+" "+(s[2]+e):"+"===i?r=" M "+(s[1]-e)+" "+s[2]+" L "+(s[1]+e)+" "+s[2]+" M "+s[1]+" "+(s[2]-e)+" L "+s[1]+" "+(s[2]+e):"<>"===i?r=" M "+(s[1]-e)+" "+s[2]+" L "+s[1]+" "+(s[2]+e)+" L "+(s[1]+e)+" "+s[2]+" L "+s[1]+" "+(s[2]-e)+" Z ":"^"===i?r=" M "+s[1]+" "+(s[2]-e)+" L "+(s[1]-o)+" "+(s[2]+n)+" L "+(s[1]+o)+" "+(s[2]+n)+" Z ":"v"===i?r=" M "+s[1]+" "+(s[2]+e)+" L "+(s[1]-o)+" "+(s[2]-n)+" L "+(s[1]+o)+" "+(s[2]-n)+" Z ":">"===i?r=" M "+(s[1]+e)+" "+s[2]+" L "+(s[1]-n)+" "+(s[2]-o)+" L "+(s[1]-n)+" "+(s[2]+o)+" Z ":"<"===i&&(r=" M "+(s[1]-e)+" "+s[2]+" L "+(s[1]+n)+" "+(s[2]-o)+" L "+(s[1]+n)+" "+(s[2]+o)+" Z "),r},updatePathStringPrim:function(t){var e,i,r,s=" M ",o=s,n=5e3,a="";if(t.numberPoints<=0)return"";if(r=Math.min(t.points.length,t.numberPoints),1===t.bezierDegree)for(e=0;e<r;e++)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?o=s:(i[1]=Math.max(Math.min(i[1],n),-5e3),i[2]=Math.max(Math.min(i[2],n),-5e3),a+=o+i[1]+" "+i[2],o=" L ");else if(3===t.bezierDegree)for(e=0;e<r;)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?o=s:(a+=o+i[1]+" "+i[2]," C "===o&&(e+=1,a+=" "+(i=t.points[e].scrCoords)[1]+" "+i[2],e+=1,a+=" "+(i=t.points[e].scrCoords)[1]+" "+i[2]),o=" C "),e+=1;return a},updatePathStringBezierPrim:function(t){var e,i,r,o,n,h,l,c=" M ",d=c,u=5e3,p="",f=s.evaluate(t.visProp.strokewidth),m="plot"!==s.evaluate(t.visProp.curvetype);if(t.numberPoints<=0)return"";for(m&&t.board.options.curve.RDPsmoothing&&(t.points=a.RamerDouglasPeucker(t.points,.5)),l=Math.min(t.points.length,t.numberPoints),i=1;i<3;i++)for(d=c,e=0;e<l;e++)o=t.points[e].scrCoords,isNaN(o[1])||isNaN(o[2])?d=c:(o[1]=Math.max(Math.min(o[1],u),-5e3),o[2]=Math.max(Math.min(o[2],u),-5e3),d===c?p+=d+o[1]+" "+o[2]:(r=2*i,p+=[d,n+.333*(o[1]-n)+f*(r*Math.random()-i)," ",h+.333*(o[2]-h)+f*(r*Math.random()-i)," ",n+.666*(o[1]-n)+f*(r*Math.random()-i)," ",h+.666*(o[2]-h)+f*(r*Math.random()-i)," ",o[1]," ",o[2]].join("")),d=" C ",n=o[1],h=o[2]);return p},updatePolygonPrim:function(t,e){var i,r,s="",o=e.vertices.length;for(t.setAttributeNS(null,"stroke","none"),"polygonalchain"===e.elType&&o++,i=0;i<o-1;i++){if(!e.vertices[i].isReal)return void t.setAttributeNS(null,"points","");s=s+(r=e.vertices[i].coords.scrCoords)[1]+","+r[2],i<o-2&&(s+=" ")}-1===s.indexOf("NaN")&&t.setAttributeNS(null,"points",s)},updateRectPrim:function(t,e,i,r,s){t.setAttributeNS(null,"x",e),t.setAttributeNS(null,"y",i),t.setAttributeNS(null,"width",r),t.setAttributeNS(null,"height",s)},setPropertyPrim:function(t,e,i){"stroked"!==e&&t.setAttributeNS(null,e,i)},display:function(t,e){var i;t&&t.rendNode&&(t.visPropOld.visible=e,i=t.rendNode,e?(i.setAttributeNS(null,"display","inline"),i.style.visibility="inherit"):(i.setAttributeNS(null,"display","none"),i.style.visibility="hidden"))},show:function(e){t.deprecated("Board.renderer.show()","Board.renderer.display()"),this.display(e,!0)},hide:function(e){t.deprecated("Board.renderer.hide()","Board.renderer.display()"),this.display(e,!1)},setBuffering:function(t,e){t.rendNode.setAttribute("buffered-rendering",e)},setDashStyle:function(t){var e=s.evaluate(t.visProp.dash),i=t.rendNode;e>0?i.setAttributeNS(null,"stroke-dasharray",this.dashArray[e-1]):i.hasAttributeNS(null,"stroke-dasharray")&&i.removeAttributeNS(null,"stroke-dasharray")},setGradient:function(t){var e,i,r,o=t.rendNode,n=s.evaluate(t.visProp.gradient);"linear"===n||"radial"===n?(e=this.createPrim(n+"Gradient",t.id+"_gradient"),i=this.createPrim("stop",t.id+"_gradient1"),r=this.createPrim("stop",t.id+"_gradient2"),e.appendChild(i),e.appendChild(r),this.defs.appendChild(e),o.setAttributeNS(null,"style","fill:url(#"+this.container.id+"_"+t.id+"_gradient)"),t.gradNode1=i,t.gradNode2=r,t.gradNode=e):o.removeAttributeNS(null,"style")},updateGradientAngle:function(t,e){var i=1,r=Math.cos(e),s=Math.sin(e);Math.abs(r)>Math.abs(s)?i/=Math.abs(r):i/=Math.abs(s),r>=0?(t.setAttributeNS(null,"x1",0),t.setAttributeNS(null,"x2",r*i)):(t.setAttributeNS(null,"x1",-r*i),t.setAttributeNS(null,"x2",0)),s>=0?(t.setAttributeNS(null,"y1",0),t.setAttributeNS(null,"y2",s*i)):(t.setAttributeNS(null,"y1",-s*i),t.setAttributeNS(null,"y2",0))},updateGradientCircle:function(t,e,i,r,s,o,n){t.setAttributeNS(null,"cx",100*e+"%"),t.setAttributeNS(null,"cy",100*i+"%"),t.setAttributeNS(null,"r",100*r+"%"),t.setAttributeNS(null,"fx",100*s+"%"),t.setAttributeNS(null,"fy",100*o+"%"),t.setAttributeNS(null,"fr",100*n+"%")},updateGradient:function(t){var e,i,r=t.gradNode1,o=t.gradNode2,n=s.evaluate(t.visProp.gradient);s.exists(r)&&s.exists(o)&&(i=(i=s.evaluate(t.visProp.fillopacity))>0?i:0,e=s.evaluate(t.visProp.fillcolor),r.setAttributeNS(null,"style","stop-color:"+e+";stop-opacity:"+i),o.setAttributeNS(null,"style","stop-color:"+s.evaluate(t.visProp.gradientsecondcolor)+";stop-opacity:"+s.evaluate(t.visProp.gradientsecondopacity)),r.setAttributeNS(null,"offset",100*s.evaluate(t.visProp.gradientstartoffset)+"%"),o.setAttributeNS(null,"offset",100*s.evaluate(t.visProp.gradientendoffset)+"%"),"linear"===n?this.updateGradientAngle(t.gradNode,s.evaluate(t.visProp.gradientangle)):"radial"===n&&this.updateGradientCircle(t.gradNode,s.evaluate(t.visProp.gradientcx),s.evaluate(t.visProp.gradientcy),s.evaluate(t.visProp.gradientr),s.evaluate(t.visProp.gradientfx),s.evaluate(t.visProp.gradientfy),s.evaluate(t.visProp.gradientfr)))},setObjectTransition:function(t,e){var i,o,n,a=["rendNode","rendNodeTriangleStart","rendNodeTriangleEnd"];if(void 0===e&&(e=s.evaluate(t.visProp.transitionduration)),e!==t.visPropOld.transitionduration){for(i=t.elementClass===r.OBJECT_CLASS_TEXT&&"html"===s.evaluate(t.visProp.display)?" color "+e+"ms, opacity "+e+"ms":" fill "+e+"ms, fill-opacity "+e+"ms, stroke "+e+"ms, stroke-opacity "+e+"ms",n=a.length,o=0;o<n;++o)t[a[o]]&&(t[a[o]].style.transition=i);t.visPropOld.transitionduration=e}},_setAttribute:function(t,e){""===e?t():window.setTimeout(t,1)},setObjectFillColor:function(e,i,r,n){var a,h,l,c,d=s.evaluate(i),u=s.evaluate(r),p=s.evaluate(e.visProp.gradient);u=u>0?u:0,e.visPropOld.fillcolor===d&&e.visPropOld.fillopacity===u&&null===p||(s.exists(d)&&!1!==d&&(9!==d.length?(h=d,c=u):(l=o.rgba2rgbo(d),h=l[0],c=u*l[1]),a=void 0===n?e.rendNode:n,"none"!==h&&this._setAttribute((function(){a.setAttributeNS(null,"fill",h)}),e.visPropOld.fillcolor),e.type===t.OBJECT_TYPE_IMAGE?this._setAttribute((function(){a.setAttributeNS(null,"opacity",c)}),e.visPropOld.fillopacity):("none"===h?(c=0,a.setAttributeNS(null,"pointer-events","visibleStroke")):a.setAttributeNS(null,"pointer-events","visiblePainted"),this._setAttribute((function(){a.setAttributeNS(null,"fill-opacity",c)}),e.visPropOld.fillopacity)),"linear"!==p&&"radial"!==p||this.updateGradient(e)),e.visPropOld.fillcolor=d,e.visPropOld.fillopacity=u)},setObjectStrokeColor:function(t,e,i){var n,a,h,l,c=s.evaluate(e),d=s.evaluate(i);d=d>0?d:0,t.visPropOld.strokecolor===c&&t.visPropOld.strokeopacity===d||(s.exists(c)&&!1!==c&&(9!==c.length?(n=c,h=d):(a=o.rgba2rgbo(c),n=a[0],h=d*a[1]),l=t.rendNode,t.elementClass===r.OBJECT_CLASS_TEXT?"html"===s.evaluate(t.visProp.display)?this._setAttribute((function(){l.style.color=n,l.style.opacity=h}),t.visPropOld.strokecolor):this._setAttribute((function(){l.setAttributeNS(null,"style","fill:"+n),l.setAttributeNS(null,"style","fill-opacity:"+h)}),t.visPropOld.strokecolor):this._setAttribute((function(){l.setAttributeNS(null,"stroke",n),l.setAttributeNS(null,"stroke-opacity",h)}),t.visPropOld.strokecolor),t.elementClass!==r.OBJECT_CLASS_CURVE&&t.elementClass!==r.OBJECT_CLASS_LINE||(s.evaluate(t.visProp.firstarrow)&&this._setArrowColor(t.rendNodeTriangleStart,n,h,t,t.visPropCalc.typeFirst),s.evaluate(t.visProp.lastarrow)&&this._setArrowColor(t.rendNodeTriangleEnd,n,h,t,t.visPropCalc.typeLast))),t.visPropOld.strokecolor=c,t.visPropOld.strokeopacity=d)},setObjectStrokeWidth:function(t,e){var i,r=s.evaluate(e);isNaN(r)||t.visPropOld.strokewidth===r||(i=t.rendNode,this.setPropertyPrim(i,"stroked","true"),s.exists(r)&&this.setPropertyPrim(i,"stroke-width",r+"px"),t.visPropOld.strokewidth=r)},setLineCap:function(t){var e=s.evaluate(t.visProp.linecap);void 0!==e&&""!==e&&t.visPropOld.linecap!==e&&s.exists(t.rendNode)&&(this.setPropertyPrim(t.rendNode,"stroke-linecap",e),t.visPropOld.linecap=e)},setShadow:function(t){var e=s.evaluate(t.visProp.shadow);t.visPropOld.shadow!==e&&(s.exists(t.rendNode)&&(e?t.rendNode.setAttributeNS(null,"filter","url(#"+this.container.id+"_f1)"):t.rendNode.removeAttributeNS(null,"filter")),t.visPropOld.shadow=e)},suspendRedraw:function(){},unsuspendRedraw:function(){},resize:function(t,e){this.svgRoot.setAttribute("width",parseFloat(t)),this.svgRoot.setAttribute("height",parseFloat(e))},createTouchpoints:function(t){var e,i,r,s;for(this.touchpoints=[],e=0;e<t;e++)i="touchpoint1_"+e,s=this.createPrim("path",i),this.appendChildPrim(s,19),s.setAttributeNS(null,"d","M 0 0"),this.touchpoints.push(s),this.setPropertyPrim(s,"stroked","true"),this.setPropertyPrim(s,"stroke-width","1px"),s.setAttributeNS(null,"stroke","#000000"),s.setAttributeNS(null,"stroke-opacity",1),s.setAttributeNS(null,"display","none"),r="touchpoint2_"+e,s=this.createPrim("ellipse",r),this.appendChildPrim(s,19),this.updateEllipsePrim(s,0,0,0,0),this.touchpoints.push(s),this.setPropertyPrim(s,"stroked","true"),this.setPropertyPrim(s,"stroke-width","1px"),s.setAttributeNS(null,"stroke","#000000"),s.setAttributeNS(null,"stroke-opacity",1),s.setAttributeNS(null,"fill","#ffffff"),s.setAttributeNS(null,"fill-opacity",0),s.setAttributeNS(null,"display","none")},showTouchpoint:function(t){this.touchpoints&&t>=0&&2*t<this.touchpoints.length&&(this.touchpoints[2*t].setAttributeNS(null,"display","inline"),this.touchpoints[2*t+1].setAttributeNS(null,"display","inline"))},hideTouchpoint:function(t){this.touchpoints&&t>=0&&2*t<this.touchpoints.length&&(this.touchpoints[2*t].setAttributeNS(null,"display","none"),this.touchpoints[2*t+1].setAttributeNS(null,"display","none"))},updateTouchpoint:function(t,e){var i,r;this.touchpoints&&t>=0&&2*t<this.touchpoints.length&&(i=e[0],r=e[1],this.touchpoints[2*t].setAttributeNS(null,"d","M "+(i-37)+" "+r+" L "+(i+37)+" "+r+" M "+i+" "+(r-37)+" L "+i+" "+(r+37)),this.updateEllipsePrim(this.touchpoints[2*t+1],e[0],e[1],25,25))},_getValuesOfDOMElements:function(t){var e=[];if(1===t.nodeType)for(t=t.firstChild;t;)void 0!==t.id&&void 0!==t.value&&e.push([t.id,t.value]),e=e.concat(this._getValuesOfDOMElements(t)),t=t.nextSibling;return e},_getDataUri:function(t,e){var i=new Image;i.onload=function(){var t=document.createElement("canvas");t.width=this.naturalWidth,t.height=this.naturalHeight,t.getContext("2d").drawImage(this,0,0),e(t.toDataURL("image/png")),t.remove()},i.src=t},_getImgDataURL:function(t){var e,i,r,s,o,n;if((i=(e=t.getElementsByTagName("image")).length)>0)for(r=document.createElement("canvas"),n=0;n<i;n++){e[n].setAttribute("crossorigin","anonymous"),s=r.getContext("2d"),r.width=e[n].getAttribute("width"),r.height=e[n].getAttribute("height");try{s.drawImage(e[n],0,0,r.width,r.height),o=r.toDataURL(),e[n].setAttribute("xlink:href",o)}catch(t){console.log("CORS problem! Image can not be used",t)}}return!0},dumpToDataURI:function(t){var e,i,r,o=this.svgRoot,a=window.btoa||n.encode,h=[];if(this.container.hasChildNodes()&&s.exists(this.foreignObjLayer))for(t||this.foreignObjLayer.setAttribute("display","inline");o.nextSibling;)h=h.concat(this._getValuesOfDOMElements(o.nextSibling)),this.foreignObjLayer.appendChild(o.nextSibling);if(this._getImgDataURL(o),o.setAttribute("xmlns","http://www.w3.org/2000/svg"),e=(new XMLSerializer).serializeToString(o),!0!==t)for(r=h.length,i=0;i<r;i++)e=e.replace('id="'+h[i][0]+'"','id="'+h[i][0]+'" value="'+h[i][1]+'"');if((e.match(/xmlns="http:\/\/www.w3.org\/2000\/svg"/g)||[]).length>1&&(e=e.replace(/xmlns="http:\/\/www.w3.org\/2000\/svg"/g,"")),e=e.replace(/&nbsp;/g," "),s.exists(this.foreignObjLayer)&&this.foreignObjLayer.hasChildNodes()){for(;this.foreignObjLayer.firstChild;)this.container.appendChild(this.foreignObjLayer.firstChild);this.foreignObjLayer.setAttribute("display","none")}return"data:image/svg+xml;base64,"+a(unescape(encodeURIComponent(e)))},dumpToCanvas:function(t,e,i,r){var s,o,n,a;return(n=document.getElementById(t)).width=n.width,a=n.getContext("2d"),void 0!==e&&void 0!==i&&(n.style.width=parseFloat(e)+"px",n.style.height=parseFloat(i)+"px",n.setAttribute("width",parseFloat(e)),n.setAttribute("height",parseFloat(i))),o=new Image,s=this.dumpToDataURI(r),o.src=s,"Promise"in window?new Promise((function(t,r){try{o.onload=function(){a.drawImage(o,0,0,e,i),t()}}catch(t){r(t)}})):(o.onload=function(){window.setTimeout((function(){try{a.drawImage(o,0,0,e,i)}catch(t){console.log("screenshots not longer supported on IE")}}),200)},this)},screenshot:function(t,e,i){var r,o,n,a,h,l,c,d,u,p,f,m=this.container.ownerDocument,g=this.container.parentNode,b=t.attr.screenshot,v=!1;return"no"===this.type||(c=b.scale*this.container.getBoundingClientRect().width,d=b.scale*this.container.getBoundingClientRect().height,void 0===e||""===e?(v=!0,(a=new Image).style.width=c+"px",a.style.height=d+"px"):(v=!1,a=m.getElementById(e)),v&&((r=m.createElement("div")).style.cssText=b.css,r.style.width=c+"px",r.style.height=d+"px",r.style.zIndex=this.container.style.zIndex+120,r.style.position="absolute",r.style.top=this.container.offsetTop+"px",r.style.left=this.container.offsetLeft+"px"),o=m.createElement("canvas"),n=Math.random().toString(36).substr(2,5),o.setAttribute("id",n),o.setAttribute("width",c),o.setAttribute("height",d),o.style.width=c+"px",o.style.height=c+"px",o.style.display="none",g.appendChild(o),v&&(h=m.createElement("span"),l=m.createTextNode("✖"),h.style.cssText=b.cssButton,h.appendChild(l),h.onclick=function(){r.parentNode.removeChild(r)},r.appendChild(a),r.appendChild(h),g.insertBefore(r,this.container.nextSibling)),u=document.getElementById(this.container.id+"_navigationbar"),s.exists(u)&&(p=u.style.display,u.style.display="none"),f=function(){a.src=o.toDataURL("image/png"),g.removeChild(o)},"Promise"in window?this.dumpToCanvas(n,c,d,i).then(f):(this.dumpToCanvas(n,c,d,i),window.setTimeout(f,200)),s.exists(u)&&(u.style.display=p)),this}}),t.SVGRenderer})),define("renderer/vml",["jxg","renderer/abstract","base/constants","utils/type","utils/color","math/math","math/numerics"],(function(t,e,i,r,s,o,n){"use strict";return t.VMLRenderer=function(e){this.type="vml",this.container=e,this.container.style.overflow="hidden",""===this.container.style.position&&(this.container.style.position="relative"),this.container.onselectstart=function(){return!1},this.resolution=10,r.exists(t.vmlStylesheet)||(e.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml"),t.vmlStylesheet=this.container.ownerDocument.createStyleSheet(),t.vmlStylesheet.addRule(".jxgvml","behavior:url(#default#VML)"));try{e.ownerDocument.namespaces.jxgvml||e.ownerDocument.namespaces.add("jxgvml","urn:schemas-microsoft-com:vml"),this.createNode=function(t){return e.ownerDocument.createElement("<jxgvml:"+t+' class="jxgvml">')}}catch(t){this.createNode=function(t){return e.ownerDocument.createElement("<"+t+' xmlns="urn:schemas-microsoft.com:vml" class="jxgvml">')}}this.dashArray=["Solid","1 1","ShortDash","Dash","LongDash","ShortDashDot","LongDashDot"]},t.VMLRenderer.prototype=new e,t.extend(t.VMLRenderer.prototype,{_setAttr:function(e,i,r,s){try{8===this.container.ownerDocument.documentMode?e[i]=r:e.setAttribute(i,r,s)}catch(e){t.debug("_setAttr: "+i+" "+r+"<br>\n")}},updateTicks:function(t){var e,i,s,o,n,a=this.resolution,h=[];for(i=t.ticks.length,e=0;e<i;e++)o=(s=t.ticks[e])[0],n=s[1],r.isNumber(o[0])&&r.isNumber(o[1])&&h.push(" m "+Math.round(a*o[0])+", "+Math.round(a*n[0])+" l "+Math.round(a*o[1])+", "+Math.round(a*n[1])+" ");r.exists(t.rendNode)||(t.rendNode=this.createPrim("path",t.id),this.appendChildPrim(t.rendNode,r.evaluate(t.visProp.layer))),this._setAttr(t.rendNode,"stroked","true"),this._setAttr(t.rendNode,"strokecolor",r.evaluate(t.visProp.strokecolor),1),this._setAttr(t.rendNode,"strokeweight",r.evaluate(t.visProp.strokewidth)),this._setAttr(t.rendNodeStroke,"opacity",100*r.evaluate(t.visProp.strokeopacity)+"%"),this.updatePathPrim(t.rendNode,h,t.board)},displayCopyright:function(t,e){var i,r;(i=this.createNode("textbox")).style.position="absolute",this._setAttr(i,"id",this.container.id+"_licenseText"),i.style.left=20,i.style.top=2,i.style.fontSize=e,i.style.color="#356AA0",i.style.fontFamily="Arial,Helvetica,sans-serif",this._setAttr(i,"opacity","30%"),i.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand', enabled = false) progid:DXImageTransform.Microsoft.Alpha(opacity = 30, enabled = true)",r=this.container.ownerDocument.createTextNode(t),i.appendChild(r),this.appendChildPrim(i,0)},drawInternalText:function(t){var e;return(e=this.createNode("textbox")).style.position="absolute",t.rendNodeText=this.container.ownerDocument.createTextNode(""),e.appendChild(t.rendNodeText),this.appendChildPrim(e,9),e.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand', enabled = false) progid:DXImageTransform.Microsoft.Alpha(opacity = 100, enabled = false)",e},updateInternalText:function(t){var e,i,r,s,n,a,h=t.plaintext,l=this.joinTransforms(t,t.transformations),c=[0,0],d=t.rendNode,u=[],p=t.getAnchorX(),f=t.getAnchorY();if(!isNaN(t.coords.scrCoords[1]+t.coords.scrCoords[2])){for("right"===p?c[0]=1:"middle"===p&&(c[0]=.5),"bottom"===f?c[1]=1:"middle"===f&&(c[1]=.5),u[0]=o.matVecMult(l,[1,t.coords.scrCoords[1]-c[0]*t.size[0],t.coords.scrCoords[2]+(1-c[1])*t.size[1]+this.vOffsetText]),u[0][1]/=u[0][0],u[0][2]/=u[0][0],u[1]=o.matVecMult(l,[1,t.coords.scrCoords[1]+(1-c[0])*t.size[0],t.coords.scrCoords[2]+(1-c[1])*t.size[1]+this.vOffsetText]),u[1][1]/=u[1][0],u[1][2]/=u[1][0],u[2]=o.matVecMult(l,[1,t.coords.scrCoords[1]+(1-c[0])*t.size[0],t.coords.scrCoords[2]-c[1]*t.size[1]+this.vOffsetText]),u[2][1]/=u[2][0],u[2][2]/=u[2][0],u[3]=o.matVecMult(l,[1,t.coords.scrCoords[1]-c[0]*t.size[0],t.coords.scrCoords[2]-c[1]*t.size[1]+this.vOffsetText]),u[3][1]/=u[3][0],u[3][2]/=u[3][0],i=u[0][1],s=u[0][1],r=u[0][2],n=u[0][2],a=1;a<4;a++)i=Math.max(i,u[a][1]),s=Math.min(s,u[a][1]),r=Math.max(r,u[a][2]),n=Math.min(n,u[a][2]);e=1===c[0]?Math.floor(t.board.canvasWidth-i):Math.floor(s),t.visPropOld.left!==p+e&&(1===c[0]?(t.rendNode.style.right=e+"px",t.rendNode.style.left="auto"):(t.rendNode.style.left=e+"px",t.rendNode.style.right="auto"),t.visPropOld.left=p+e),e=1===c[1]?Math.floor(t.board.canvasHeight-r):Math.floor(n),t.visPropOld.top!==f+e&&(1===c[1]?(t.rendNode.style.bottom=e+"px",t.rendNode.style.top="auto"):(t.rendNode.style.top=e+"px",t.rendNode.style.bottom="auto"),t.visPropOld.top=f+e)}t.htmlStr!==h&&(t.rendNodeText.data=h,t.htmlStr=h),d.filters.item(0).M11=l[1][1],d.filters.item(0).M12=l[1][2],d.filters.item(0).M21=l[2][1],d.filters.item(0).M22=l[2][2],d.filters.item(0).enabled=!0},drawImage:function(t){var e;(e=this.container.ownerDocument.createElement("img")).style.position="absolute",this._setAttr(e,"id",this.container.id+"_"+t.id),this.container.appendChild(e),this.appendChildPrim(e,r.evaluate(t.visProp.layer)),e.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand') progid:DXImageTransform.Microsoft.Alpha(opacity = 100, enabled = false)",t.rendNode=e,this.updateImage(t)},transformImage:function(t,e){var i,r,s,n,a,h,l=t.rendNode,c=[];if(e.length>0){for(i=this.joinTransforms(t,e),c[0]=o.matVecMult(i,t.coords.scrCoords),c[0][1]/=c[0][0],c[0][2]/=c[0][0],c[1]=o.matVecMult(i,[1,t.coords.scrCoords[1]+t.size[0],t.coords.scrCoords[2]]),c[1][1]/=c[1][0],c[1][2]/=c[1][0],c[2]=o.matVecMult(i,[1,t.coords.scrCoords[1]+t.size[0],t.coords.scrCoords[2]-t.size[1]]),c[2][1]/=c[2][0],c[2][2]/=c[2][0],c[3]=o.matVecMult(i,[1,t.coords.scrCoords[1],t.coords.scrCoords[2]-t.size[1]]),c[3][1]/=c[3][0],c[3][2]/=c[3][0],r=c[0][1],n=c[0][1],s=c[0][2],a=c[0][2],h=1;h<4;h++)r=Math.max(r,c[h][1]),n=Math.min(n,c[h][1]),s=Math.max(s,c[h][2]),a=Math.min(a,c[h][2]);l.style.left=Math.floor(n)+"px",l.style.top=Math.floor(a)+"px",l.filters.item(0).M11=i[1][1],l.filters.item(0).M12=i[1][2],l.filters.item(0).M21=i[2][1],l.filters.item(0).M22=i[2][2],l.filters.item(0).enabled=!0}},updateImageURL:function(t){var e=r.evaluate(t.url);this._setAttr(t.rendNode,"src",e)},appendChildPrim:function(t,e){return r.exists(e)||(e=0),t.style.zIndex=e,this.container.appendChild(t),t},appendNodesToElement:function(t,e){"shape"!==e&&"path"!==e&&"polygon"!==e||(t.rendNodePath=this.getElementById(t.id+"_path")),t.rendNodeFill=this.getElementById(t.id+"_fill"),t.rendNodeStroke=this.getElementById(t.id+"_stroke"),t.rendNodeShadow=this.getElementById(t.id+"_shadow"),t.rendNode=this.getElementById(t.id)},createPrim:function(t,e){var i,r,s=this.createNode("fill"),o=this.createNode("stroke"),n=this.createNode("shadow");return this._setAttr(s,"id",this.container.id+"_"+e+"_fill"),this._setAttr(o,"id",this.container.id+"_"+e+"_stroke"),this._setAttr(n,"id",this.container.id+"_"+e+"_shadow"),"circle"===t||"ellipse"===t?((i=this.createNode("oval")).appendChild(s),i.appendChild(o),i.appendChild(n)):"polygon"===t||"path"===t||"shape"===t||"line"===t?((i=this.createNode("shape")).appendChild(s),i.appendChild(o),i.appendChild(n),r=this.createNode("path"),this._setAttr(r,"id",this.container.id+"_"+e+"_path"),i.appendChild(r)):((i=this.createNode(t)).appendChild(s),i.appendChild(o),i.appendChild(n)),i.style.position="absolute",i.style.left="0px",i.style.top="0px",this._setAttr(i,"id",this.container.id+"_"+e),i},remove:function(t){r.exists(t)&&t.removeNode(!0)},makeArrows:function(t){var e,i=r.evaluate(t.visProp.firstarrow),s=r.evaluate(t.visProp.lastarrow);t.visPropOld.firstarrow===i&&t.visPropOld.lastarrow===s||(i?(e=t.rendNodeStroke,this._setAttr(e,"startarrow","block"),this._setAttr(e,"startarrowlength","long")):(e=t.rendNodeStroke,r.exists(e)&&this._setAttr(e,"startarrow","none")),s?(e=t.rendNodeStroke,this._setAttr(e,"id",this.container.id+"_"+t.id+"stroke"),this._setAttr(e,"endarrow","block"),this._setAttr(e,"endarrowlength","long")):(e=t.rendNodeStroke,r.exists(e)&&this._setAttr(e,"endarrow","none")),t.visPropOld.firstarrow=i,t.visPropOld.lastarrow=s)},updateEllipsePrim:function(t,e,i,r,s){t.style.left=Math.floor(e-r)+"px",t.style.top=Math.floor(i-s)+"px",t.style.width=Math.floor(2*Math.abs(r))+"px",t.style.height=Math.floor(2*Math.abs(s))+"px"},updateLinePrim:function(t,e,i,r,s,o){var n,a=this.resolution;isNaN(e+i+r+s)||(n=["m ",Math.floor(a*e),", ",Math.floor(a*i)," l ",Math.floor(a*r),", ",Math.floor(a*s)],this.updatePathPrim(t,n,o))},updatePathPrim:function(t,e,i){var r=i.canvasWidth,s=i.canvasHeight;e.length<=0&&(e=["m 0,0"]),t.style.width=r,t.style.height=s,this._setAttr(t,"coordsize",[Math.floor(this.resolution*r),Math.floor(this.resolution*s)].join(",")),this._setAttr(t,"path",e.join(""))},updatePathStringPoint:function(t,e,i){var r=[],s=Math.round,o=t.coords.scrCoords,n=e*Math.sqrt(3)*.5,a=.5*e,h=this.resolution;return"x"===i?r.push([" m ",s(h*(o[1]-e)),", ",s(h*(o[2]-e))," l ",s(h*(o[1]+e)),", ",s(h*(o[2]+e))," m ",s(h*(o[1]+e)),", ",s(h*(o[2]-e))," l ",s(h*(o[1]-e)),", ",s(h*(o[2]+e))].join("")):"+"===i?r.push([" m ",s(h*(o[1]-e)),", ",s(h*o[2])," l ",s(h*(o[1]+e)),", ",s(h*o[2])," m ",s(h*o[1]),", ",s(h*(o[2]-e))," l ",s(h*o[1]),", ",s(h*(o[2]+e))].join("")):"<>"===i?r.push([" m ",s(h*(o[1]-e)),", ",s(h*o[2])," l ",s(h*o[1]),", ",s(h*(o[2]+e))," l ",s(h*(o[1]+e)),", ",s(h*o[2])," l ",s(h*o[1]),", ",s(h*(o[2]-e))," x e "].join("")):"^"===i?r.push([" m ",s(h*o[1]),", ",s(h*(o[2]-e))," l ",s(h*(o[1]-n)),", ",s(h*(o[2]+a))," l ",s(h*(o[1]+n)),", ",s(h*(o[2]+a))," x e "].join("")):"v"===i?r.push([" m ",s(h*o[1]),", ",s(h*(o[2]+e))," l ",s(h*(o[1]-n)),", ",s(h*(o[2]-a))," l ",s(h*(o[1]+n)),", ",s(h*(o[2]-a))," x e "].join("")):">"===i?r.push([" m ",s(h*(o[1]+e)),", ",s(h*o[2])," l ",s(h*(o[1]-a)),", ",s(h*(o[2]-n))," l ",s(h*(o[1]-a)),", ",s(h*(o[2]+n))," l ",s(h*(o[1]+e)),", ",s(h*o[2])].join("")):"<"===i&&r.push([" m ",s(h*(o[1]-e)),", ",s(h*o[2])," l ",s(h*(o[1]+a)),", ",s(h*(o[2]-n))," l ",s(h*(o[1]+a)),", ",s(h*(o[2]+n))," x e "].join("")),r},updatePathStringPrim:function(t){var e,i,r=[],s=this.resolution,o=Math.round,n=" m ",a=n,h=Math.min(t.numberPoints,8192);if(t.numberPoints<=0)return"";if(h=Math.min(h,t.points.length),1===t.bezierDegree)for(e=0;e<h;e++)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?a=n:(i[1]>2e4?i[1]=2e4:i[1]<-2e4&&(i[1]=-2e4),i[2]>2e4?i[2]=2e4:i[2]<-2e4&&(i[2]=-2e4),r.push([a,o(s*i[1]),", ",o(s*i[2])].join("")),a=" l ");else if(3===t.bezierDegree)for(e=0;e<h;)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?a=n:(r.push([a,o(s*i[1]),", ",o(s*i[2])].join(""))," c "===a&&(e+=1,i=t.points[e].scrCoords,r.push([" ",o(s*i[1]),", ",o(s*i[2])].join("")),e+=1,i=t.points[e].scrCoords,r.push([" ",o(s*i[1]),", ",o(s*i[2])].join(""))),a=" c "),e+=1;return r.push(" e"),r},updatePathStringBezierPrim:function(t){var e,i,s,o,a,h,l=[],c=r.evaluate(t.visProp.strokewidth),d=this.resolution,u=Math.round,p=" m ",f=p,m="plot"!==r.evaluate(t.visProp.curvetype),g=Math.min(t.numberPoints,8192);if(t.numberPoints<=0)return"";for(m&&t.board.options.curve.RDPsmoothing&&(t.points=n.RamerDouglasPeucker(t.points,1)),g=Math.min(g,t.points.length),i=1;i<3;i++)for(f=p,e=0;e<g;e++)o=t.points[e].scrCoords,isNaN(o[1])||isNaN(o[2])?f=p:(o[1]>2e4?o[1]=2e4:o[1]<-2e4&&(o[1]=-2e4),o[2]>2e4?o[2]=2e4:o[2]<-2e4&&(o[2]=-2e4),f===p?l.push([f,u(d*o[1])," ",u(d*o[2])].join("")):(s=2*i,l.push([f,u(d*(a+.333*(o[1]-a)+c*(s*Math.random()-i)))," ",u(d*(h+.333*(o[2]-h)+c*(s*Math.random()-i)))," ",u(d*(a+.666*(o[1]-a)+c*(s*Math.random()-i)))," ",u(d*(h+.666*(o[2]-h)+c*(s*Math.random()-i)))," ",u(d*o[1])," ",u(d*o[2])].join(""))),f=" c ",a=o[1],h=o[2]);return l.push(" e"),l},updatePolygonPrim:function(t,e){var i,r,s=e.vertices.length,o=this.resolution,n=[];if(this._setAttr(t,"stroked","false"),r=e.vertices[0].coords.scrCoords,!isNaN(r[1]+r[2])){for(n.push(["m ",Math.floor(o*r[1]),",",Math.floor(o*r[2])," l "].join("")),i=1;i<s-1;i++){if(!e.vertices[i].isReal)return void this.updatePathPrim(t,"",e.board);if(r=e.vertices[i].coords.scrCoords,isNaN(r[1]+r[2]))return;n.push(Math.floor(o*r[1])+","+Math.floor(o*r[2])),i<s-2&&n.push(", ")}n.push(" x e"),this.updatePathPrim(t,n,e.board)}},updateRectPrim:function(t,e,i,r,s){t.style.left=Math.floor(e)+"px",t.style.top=Math.floor(i)+"px",r>=0&&(t.style.width=r+"px"),s>=0&&(t.style.height=s+"px")},setPropertyPrim:function(t,e,i){var s,o="";switch(e){case"stroke":o="strokecolor";break;case"stroke-width":o="strokeweight";break;case"stroke-dasharray":o="dashstyle"}""!==o&&(s=r.evaluate(i),this._setAttr(t,o,s))},display:function(t,e){t&&t.rendNode&&(t.visPropOld.visible=e,t.rendNode.style.visibility=e?"inherit":"hidden")},show:function(e){t.deprecated("Board.renderer.show()","Board.renderer.display()"),e&&e.rendNode&&(e.rendNode.style.visibility="inherit")},hide:function(e){t.deprecated("Board.renderer.hide()","Board.renderer.display()"),e&&e.rendNode&&(e.rendNode.style.visibility="hidden")},setDashStyle:function(t,e){var i;e.dash>=0&&(i=t.rendNodeStroke,this._setAttr(i,"dashstyle",this.dashArray[e.dash]))},setGradient:function(t){var e=t.rendNodeFill,i=r.evaluate(t.visProp.gradient);"linear"===i?(this._setAttr(e,"type","gradient"),this._setAttr(e,"color2",r.evaluate(t.visProp.gradientsecondcolor)),this._setAttr(e,"opacity2",r.evaluate(t.visProp.gradientsecondopacity)),this._setAttr(e,"angle",r.evaluate(t.visProp.gradientangle))):"radial"===i?(this._setAttr(e,"type","gradientradial"),this._setAttr(e,"color2",r.evaluate(t.visProp.gradientsecondcolor)),this._setAttr(e,"opacity2",r.evaluate(t.visProp.gradientsecondopacity)),this._setAttr(e,"focusposition",100*r.evaluate(t.visProp.gradientpositionx)+"%,"+100*r.evaluate(t.visProp.gradientpositiony)+"%"),this._setAttr(e,"focussize","0,0")):this._setAttr(e,"type","solid")},setObjectFillColor:function(t,e,o){var n,a,h,l=r.evaluate(e),c=r.evaluate(o),d=t.rendNode;c=c>0?c:0,t.visPropOld.fillcolor===l&&t.visPropOld.fillopacity===c||(r.exists(l)&&!1!==l&&(9!==l.length?(n=l,h=c):(n=(a=s.rgba2rgbo(l))[0],h=c*a[1]),"none"===n||!1===n?this._setAttr(t.rendNode,"filled","false"):(this._setAttr(t.rendNode,"filled","true"),this._setAttr(t.rendNode,"fillcolor",n),r.exists(h)&&t.rendNodeFill&&this._setAttr(t.rendNodeFill,"opacity",100*h+"%")),t.type===i.OBJECT_TYPE_IMAGE&&d.filters.length>1&&(d.filters.item(1).opacity=Math.round(100*h),d.filters.item(1).enabled=!0)),t.visPropOld.fillcolor=l,t.visPropOld.fillopacity=c)},setObjectStrokeColor:function(t,e,s){var o,n,a,h,l=r.evaluate(e),c=r.evaluate(s),d=t.rendNode;c=c>0?c:0,t.visPropOld.strokecolor===l&&t.visPropOld.strokeopacity===c||(r.exists(l)&&!1!==l&&(9!==l.length?(o=l,a=c):(o=(n=e.rgba2rgbo(l))[0],a=c*n[1]),t.elementClass===i.OBJECT_CLASS_TEXT?(d.filters.length>1&&(d.filters.item(1).opacity=Math.round(100*a),d.filters.item(1).enabled=!0),d.style.color=o):(!1!==o&&(this._setAttr(d,"stroked","true"),this._setAttr(d,"strokecolor",o)),h=t.rendNodeStroke,r.exists(a)&&t.type!==i.OBJECT_TYPE_IMAGE&&this._setAttr(h,"opacity",100*a+"%"))),t.visPropOld.strokecolor=l,t.visPropOld.strokeopacity=c)},setObjectStrokeWidth:function(t,e){var i,s=r.evaluate(e);isNaN(s)||t.visPropOld.strokewidth===s||(i=t.rendNode,this.setPropertyPrim(i,"stroked","true"),r.exists(s)&&(this.setPropertyPrim(i,"stroke-width",s),0===s&&r.exists(t.rendNodeStroke)&&this._setAttr(i,"stroked","false")),t.visPropOld.strokewidth=s)},setShadow:function(t){var e=t.rendNodeShadow,i=r.evaluate(t.visProp.shadow);e&&t.visPropOld.shadow!==i&&(i?(this._setAttr(e,"On","True"),this._setAttr(e,"Offset","3pt,3pt"),this._setAttr(e,"Opacity","60%"),this._setAttr(e,"Color","#aaaaaa")):this._setAttr(e,"On","False"),t.visPropOld.shadow=i)},suspendRedraw:function(){this.container.style.display="none"},unsuspendRedraw:function(){this.container.style.display=""}}),t.VMLRenderer})),define("renderer/canvas",["jxg","renderer/abstract","base/constants","utils/env","utils/type","utils/uuid","utils/color","base/coords","math/math","math/geometry","math/numerics"],(function(t,e,i,r,s,o,n,a,h,l,c){"use strict";return t.CanvasRenderer=function(t,e){if(this.type="canvas",this.canvasRoot=null,this.suspendHandle=null,this.canvasId=o.genUUID(),this.canvasNamespace=null,r.isBrowser)this.container=t,this.container.style.MozUserSelect="none",this.container.style.userSelect="none",this.container.style.overflow="hidden",""===this.container.style.position&&(this.container.style.position="relative"),this.container.innerHTML=['<canvas id="',this.canvasId,'" width="',e.width,'px" height="',e.height,'px"><',"/canvas>"].join(""),this.canvasRoot=this.container.ownerDocument.getElementById(this.canvasId),this.canvasRoot.style.display="block",this.context=this.canvasRoot.getContext("2d");else if(r.isNode())try{this.canvasId="object"==typeof module?module.require("canvas"):require("canvas"),this.canvasRoot=new this.canvasId(500,500),this.context=this.canvasRoot.getContext("2d")}catch(t){console.log("Warning: 'canvas' not found. You might need to call 'npm install canvas'")}this.dashArray=[[2,2],[5,5],[10,10],[20,20],[20,10,10,10],[20,5,10,5]]},t.CanvasRenderer.prototype=new e,t.extend(t.CanvasRenderer.prototype,{_drawPolygon:function(t,e,i){var r,s=t.length,o=this.context;if(s>0){if(i&&(o.lineWidth=0),o.beginPath(),o.moveTo(t[0][0],t[0][1]),1===e)for(r=1;r<s;r++)o.lineTo(t[r][0],t[r][1]);else for(r=1;r<s;r+=3)o.bezierCurveTo(t[r][0],t[r][1],t[r+1][0],t[r+1][1],t[r+2][0],t[r+2][1]);i?(o.lineTo(t[0][0],t[0][1]),o.closePath(),o.fill()):o.stroke()}},_fill:function(t){var e=this.context;e.save(),this._setColor(t,"fill")&&e.fill(),e.restore()},_rotatePoint:function(t,e,i){return[e*Math.cos(t)-i*Math.sin(t),e*Math.sin(t)+i*Math.cos(t)]},_rotateShape:function(t,e){var i,r=[],s=t.length;if(s<=0)return t;for(i=0;i<s;i++)r.push(this._rotatePoint(e,t[i][0],t[i][1]));return r},updateGradientAngle:function(t,e){var r,s,o,n,h,l,c,d,u,p,f,m,g=1,b=Math.cos(-e),v=Math.sin(-e),y=t.getBoundingBox();return Math.abs(b)>Math.abs(v)?g/=Math.abs(b):g/=Math.abs(v),b>=0?(o=0,n=b*g):(o=-b*g,n=0),v>=0?(h=0,l=v*g):(h=-v*g,l=0),r=new a(i.COORDS_BY_USER,[y[0],y[1]],t.board),f=(s=new a(i.COORDS_BY_USER,[y[2],y[3]],t.board)).scrCoords[1]-r.scrCoords[1],m=s.scrCoords[2]-r.scrCoords[2],c=r.scrCoords[1]+f*o,u=r.scrCoords[2]+m*h,d=r.scrCoords[1]+f*n,p=r.scrCoords[2]+m*l,this.context.createLinearGradient(c,u,d,p)},updateGradientCircle:function(t,e,r,s,o,n,h){var l,c,d,u,p,f,m,g,b,v,y=t.getBoundingBox();return l=new a(i.COORDS_BY_USER,[y[0],y[1]],t.board),b=(c=new a(i.COORDS_BY_USER,[y[2],y[3]],t.board)).scrCoords[1]-l.scrCoords[1],v=l.scrCoords[2]-c.scrCoords[2],d=l.scrCoords[1]+b*e,u=c.scrCoords[2]+v*r,f=l.scrCoords[1]+b*o,m=c.scrCoords[2]+v*n,p=s*(b+v)*.5,g=h*(b+v)*.5,this.context.createRadialGradient(f,m,g,d,u,p)},updateGradient:function(t){var e,i,r,o=s.evaluate(t.visProp.gradient);return i=(i=s.evaluate(t.visProp.fillopacity))>0?i:0,e=s.evaluate(t.visProp.fillcolor),"linear"===o?r=this.updateGradientAngle(t,s.evaluate(t.visProp.gradientangle)):"radial"===o&&(r=this.updateGradientCircle(t,s.evaluate(t.visProp.gradientcx),s.evaluate(t.visProp.gradientcy),s.evaluate(t.visProp.gradientr),s.evaluate(t.visProp.gradientfx),s.evaluate(t.visProp.gradientfy),s.evaluate(t.visProp.gradientfr))),r.addColorStop(s.evaluate(t.visProp.gradientstartoffset),e),r.addColorStop(s.evaluate(t.visProp.gradientendoffset),s.evaluate(t.visProp.gradientsecondcolor)),r},_setColor:function(t,e,i){var r,o,a,h,l,c,d,u,p=!0,f=t.visProp;return e=e||"stroke",i=i||e,r=this._getHighlighted(t),"linear"===(u=s.evaluate(t.visProp.gradient))||"radial"===u?(this.context[i+"Style"]=this.updateGradient(t),p):("none"!==(a=s.evaluate(f[r+e+"color"]))&&!1!==a?(c=(c=s.evaluate(f[r+e+"opacity"]))>0?c:0,9!==a.length?(l=a,d=c):(l=(h=n.rgba2rgbo(a))[0],d=c*h[1]),this.context.globalAlpha=d,this.context[i+"Style"]=l):p=!1,o=parseFloat(s.evaluate(f[r+"strokewidth"])),"stroke"!==e||isNaN(o)||(0===o?this.context.globalAlpha=0:this.context.lineWidth=o),"stroke"===e&&void 0!==f.linecap&&""!==f.linecap&&(this.context.lineCap=f.linecap),p)},_stroke:function(t){var e=this.context,i=s.evaluate(t.visProp.dash);e.save(),i>0?e.setLineDash&&e.setLineDash(this.dashArray[i]):this.context.lineDashArray=[],this._setColor(t,"stroke")&&e.stroke(),e.restore()},_translateShape:function(t,e,i){var r,s=[],o=t.length;if(o<=0)return t;for(r=0;r<o;r++)s.push([t[r][0]+e,t[r][1]+i]);return s},drawPoint:function(t){var e=s.evaluate(t.visProp.face),i=s.evaluate(t.visProp.size),r=t.coords.scrCoords,o=i*Math.sqrt(3)*.5,n=.5*i,a=parseFloat(s.evaluate(t.visProp.strokewidth))/2,h=this.context;if(t.visPropCalc.visible)switch(e){case"cross":case"x":h.beginPath(),h.moveTo(r[1]-i,r[2]-i),h.lineTo(r[1]+i,r[2]+i),h.moveTo(r[1]+i,r[2]-i),h.lineTo(r[1]-i,r[2]+i),h.lineCap="round",h.lineJoin="round",h.closePath(),this._stroke(t);break;case"circle":case"o":h.beginPath(),h.arc(r[1],r[2],i+1+a,0,2*Math.PI,!1),h.closePath(),this._fill(t),this._stroke(t);break;case"square":case"[]":if(i<=0)break;h.save(),this._setColor(t,"stroke","fill")&&h.fillRect(r[1]-i-a,r[2]-i-a,2*i+3*a,2*i+3*a),h.restore(),h.save(),this._setColor(t,"fill"),h.fillRect(r[1]-i+a,r[2]-i+a,2*i-a,2*i-a),h.restore();break;case"plus":case"+":h.beginPath(),h.moveTo(r[1]-i,r[2]),h.lineTo(r[1]+i,r[2]),h.moveTo(r[1],r[2]-i),h.lineTo(r[1],r[2]+i),h.lineCap="round",h.lineJoin="round",h.closePath(),this._stroke(t);break;case"diamond":case"<>":h.beginPath(),h.moveTo(r[1]-i,r[2]),h.lineTo(r[1],r[2]+i),h.lineTo(r[1]+i,r[2]),h.lineTo(r[1],r[2]-i),h.closePath(),this._fill(t),this._stroke(t);break;case"triangleup":case"a":case"^":h.beginPath(),h.moveTo(r[1],r[2]-i),h.lineTo(r[1]-o,r[2]+n),h.lineTo(r[1]+o,r[2]+n),h.closePath(),this._fill(t),this._stroke(t);break;case"triangledown":case"v":h.beginPath(),h.moveTo(r[1],r[2]+i),h.lineTo(r[1]-o,r[2]-n),h.lineTo(r[1]+o,r[2]-n),h.closePath(),this._fill(t),this._stroke(t);break;case"triangleleft":case"<":h.beginPath(),h.moveTo(r[1]-i,r[2]),h.lineTo(r[1]+n,r[2]-o),h.lineTo(r[1]+n,r[2]+o),h.closePath(),this._fill(t),this._stroke(t);break;case"triangleright":case">":h.beginPath(),h.moveTo(r[1]+i,r[2]),h.lineTo(r[1]-n,r[2]-o),h.lineTo(r[1]-n,r[2]+o),h.closePath(),this._fill(t),this._stroke(t)}},updatePoint:function(t){this.drawPoint(t)},drawArrows:function(t,e,r,o,n){var a,h,l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S,x,O,w=this.context,T=1,N=1,M=1,A=n.evFirst,R=n.evLast;if("none"!==s.evaluate(t.visProp.strokecolor)&&(A||R)){if(t.elementClass===i.OBJECT_CLASS_LINE)a=e.scrCoords[1],h=e.scrCoords[2],l=r.scrCoords[1],c=r.scrCoords[2],x=O=Math.atan2(c-h,l-a);else{if(a=t.points[0].scrCoords[1],h=t.points[0].scrCoords[2],(S=t.points.length-1)<1)return;l=t.points[t.points.length-1].scrCoords[1],c=t.points[t.points.length-1].scrCoords[2],C=t.points[1].scrCoords[1]-t.points[0].scrCoords[1],_=t.points[1].scrCoords[2]-t.points[0].scrCoords[2],P=t.points[S].scrCoords[1]-t.points[S-1].scrCoords[1],E=t.points[S].scrCoords[2]-t.points[S-1].scrCoords[2],A&&(x=Math.atan2(_,C)),R&&(O=Math.atan2(E,P))}if(d=s.evaluate(t.visProp[o+"strokewidth"]),A)if(u=d*n.sizeFirst,m=T=n.typeFirst,2===T)f=[[u,.5*-u],[0,0],[u,.5*u],[.5*u,0]];else if(3===T)f=[[u/3,.5*-u],[0,.5*-u],[0,.5*u],[u/3,.5*u]];else if(4===T)for(u/=10,N=3,y=(f=[[10,3.31],[6.47,3.84],[2.87,4.5],[0,6.63],[.67,5.52],[1.33,4.42],[2,3.31],[1.33,2.21],[.67,1.1],[0,0],[2.87,2.13],[6.47,2.79],[10,3.31]]).length,v=0;v<y;v++)f[v][0]*=-u,f[v][1]*=u,f[v][0]+=10*u,f[v][1]-=3.31*u;else if(5===T)for(u/=10,N=3,y=(f=[[10,3.28],[6.61,4.19],[3.19,5.07],[0,6.55],[.62,5.56],[1,4.44],[1,3.28],[1,2.11],[.62,.99],[0,0],[3.19,1.49],[6.61,2.37],[10,3.28]]).length,v=0;v<y;v++)f[v][0]*=-u,f[v][1]*=u,f[v][0]+=10*u,f[v][1]-=3.28*u;else if(6===T)for(u/=10,N=3,y=(f=[[10,2.84],[6.61,3.59],[3.21,4.35],[0,5.68],[.33,4.73],[.67,3.78],[1,2.84],[.67,1.89],[.33,.95],[0,0],[3.21,1.33],[6.61,2.09],[10,2.84]]).length,v=0;v<y;v++)f[v][0]*=-u,f[v][1]*=u,f[v][0]+=10*u,f[v][1]-=2.84*u;else if(7===T)for(u=d,N=3,y=(f=[[0,10.39],[2.01,6.92],[5.96,5.2],[10,5.2],[5.96,5.2],[2.01,3.47],[0,0]]).length,v=0;v<y;v++)f[v][0]*=-u,f[v][1]*=u,f[v][0]+=10*u,f[v][1]-=5.2*u;else f=[[u,.5*-u],[0,0],[u,.5*u]];if(R)if(u=d*n.sizeLast,g=T=n.typeLast,2===T)p=[[-u,.5*-u],[0,0],[-u,.5*u],[.5*-u,0]];else if(3===T)p=[[-u/3,.5*-u],[0,.5*-u],[0,.5*u],[-u/3,.5*u]];else if(4===T)for(u/=10,M=3,y=(p=[[10,3.31],[6.47,3.84],[2.87,4.5],[0,6.63],[.67,5.52],[1.33,4.42],[2,3.31],[1.33,2.21],[.67,1.1],[0,0],[2.87,2.13],[6.47,2.79],[10,3.31]]).length,v=0;v<y;v++)p[v][0]*=u,p[v][1]*=u,p[v][0]-=10*u,p[v][1]-=3.31*u;else if(5===T)for(u/=10,M=3,y=(p=[[10,3.28],[6.61,4.19],[3.19,5.07],[0,6.55],[.62,5.56],[1,4.44],[1,3.28],[1,2.11],[.62,.99],[0,0],[3.19,1.49],[6.61,2.37],[10,3.28]]).length,v=0;v<y;v++)p[v][0]*=u,p[v][1]*=u,p[v][0]-=10*u,p[v][1]-=3.28*u;else if(6===T)for(u/=10,M=3,y=(p=[[10,2.84],[6.61,3.59],[3.21,4.35],[0,5.68],[.33,4.73],[.67,3.78],[1,2.84],[.67,1.89],[.33,.95],[0,0],[3.21,1.33],[6.61,2.09],[10,2.84]]).length,v=0;v<y;v++)p[v][0]*=u,p[v][1]*=u,p[v][0]-=10*u,p[v][1]-=2.84*u;else if(7===T)for(u=d,M=3,y=(p=[[0,10.39],[2.01,6.92],[5.96,5.2],[10,5.2],[5.96,5.2],[2.01,3.47],[0,0]]).length,v=0;v<y;v++)p[v][0]*=u,p[v][1]*=u,p[v][0]-=10*u,p[v][1]-=5.2*u;else p=[[-u,.5*-u],[0,0],[-u,.5*u]];w.save(),this._setColor(t,"stroke","fill")&&(this._setColor(t,"stroke"),A&&(b=7!==m,this._drawPolygon(this._translateShape(this._rotateShape(f,x),a,h),N,b)),R&&(b=7!==g,this._drawPolygon(this._translateShape(this._rotateShape(p,O),l,c),M,b))),w.restore()}},drawLine:function(t){var e,r,o,n,h,c=new a(i.COORDS_BY_USER,t.point1.coords.usrCoords,t.board),d=new a(i.COORDS_BY_USER,t.point2.coords.usrCoords,t.board),u=null;t.visPropCalc.visible&&(o=this._getHighlighted(t),n=s.evaluate(t.visProp[o+"strokewidth"]),((h=this.getArrowHeadData(t,n,o)).evFirst||h.evLast)&&(u=-4),l.calcStraight(t,c,d,u),this.handleTouchpoints(t,c,d,h),e=new a(i.COORDS_BY_USER,c.usrCoords,t.board),r=new a(i.COORDS_BY_USER,d.usrCoords,t.board),this.getPositionArrowHead(t,c,d,h),this.context.beginPath(),this.context.moveTo(c.scrCoords[1],c.scrCoords[2]),this.context.lineTo(d.scrCoords[1],d.scrCoords[2]),this._stroke(t),(h.evFirst||h.evLast)&&this.drawArrows(t,e,r,o,h))},updateLine:function(t){this.drawLine(t)},drawTicks:function(){},updateTicks:function(t){var e,i,r,s,o,n,a=t.ticks.length,h=this.context;for(h.beginPath(),e=0;e<a;e++)for(r=(i=t.ticks[e])[0],s=i[1],o=r.length,h.moveTo(r[0],s[0]),n=1;n<o;++n)h.lineTo(r[n],s[n]);h.lineCap="round",this._stroke(t)},drawCurve:function(t){var e,i,r;s.evaluate(t.visProp.handdrawing)?this.updatePathStringBezierPrim(t):this.updatePathStringPrim(t),t.numberPoints>1&&(e=this._getHighlighted(t),i=s.evaluate(t.visProp[e+"strokewidth"]),((r=this.getArrowHeadData(t,i,e)).evFirst||r.evLast)&&this.drawArrows(t,null,null,e,r))},updateCurve:function(t){this.drawCurve(t)},drawEllipse:function(t){var e=t.center.coords.scrCoords[1],i=t.center.coords.scrCoords[2],r=t.board.unitX,s=t.board.unitY,o=2*t.Radius(),n=2*t.Radius(),a=o*r,h=n*s,l=e-a/2,c=i-h/2,d=a/2*.5522848,u=h/2*.5522848,p=l+a,f=c+h,m=l+a/2,g=c+h/2,b=this.context;o>0&&n>0&&!isNaN(e+i)&&(b.beginPath(),b.moveTo(l,g),b.bezierCurveTo(l,g-u,m-d,c,m,c),b.bezierCurveTo(m+d,c,p,g-u,p,g),b.bezierCurveTo(p,g+u,m+d,f,m,f),b.bezierCurveTo(m-d,f,l,g+u,l,g),b.closePath(),this._fill(t),this._stroke(t))},updateEllipse:function(t){return this.drawEllipse(t)},displayCopyright:function(t,e){var i=this.context;i.save(),i.font=e+"px Arial",i.fillStyle="#aaa",i.lineWidth=.5,i.fillText(t,10,2+e),i.restore()},drawInternalText:function(t){var e=s.evaluate(t.visProp.fontsize),i=s.evaluate(t.visProp.fontunit),r=t.getAnchorX(),o=t.getAnchorY(),n=this.context;return n.save(),this._setColor(t,"stroke","fill")&&!isNaN(t.coords.scrCoords[1]+t.coords.scrCoords[2])&&(n.font=(e>0?e:0)+i+" Arial",this.transformImage(t,t.transformations),"left"===r?n.textAlign="left":"right"===r?n.textAlign="right":"middle"===r&&(n.textAlign="center"),"bottom"===o?n.textBaseline="bottom":"top"===o?n.textBaseline="top":"middle"===o&&(n.textBaseline="middle"),n.fillText(t.plaintext,t.coords.scrCoords[1],t.coords.scrCoords[2])),n.restore(),null},updateInternalText:function(t){this.drawInternalText(t)},setObjectStrokeColor:function(t,e,r){var o,a,h,l,c=s.evaluate(e),d=s.evaluate(r);d=d>0?d:0,t.visPropOld.strokecolor===c&&t.visPropOld.strokeopacity===d||(s.exists(c)&&!1!==c&&(9!==c.length?(o=c,h=d):(o=(a=n.rgba2rgbo(c))[0],h=d*a[1]),l=t.rendNode,t.elementClass===i.OBJECT_CLASS_TEXT&&"html"===s.evaluate(t.visProp.display)&&(l.style.color=o,l.style.opacity=h)),t.visPropOld.strokecolor=c,t.visPropOld.strokeopacity=d)},drawImage:function(t){t.rendNode=new Image,t._src="",this.updateImage(t)},updateImage:function(t){var e=this.context,i=s.evaluate(t.visProp.fillopacity),r=s.bind((function(){t.imgIsLoaded=!0,t.size[0]<=0||t.size[1]<=0||(e.save(),e.globalAlpha=i,this.transformImage(t,t.transformations),e.drawImage(t.rendNode,t.coords.scrCoords[1],t.coords.scrCoords[2]-t.size[1],t.size[0],t.size[1]),e.restore())}),this);this.updateImageURL(t)?t.rendNode.onload=r:t.imgIsLoaded&&r()},transformImage:function(t,e){var i,r=e.length,s=this.context;r>0&&(i=this.joinTransforms(t,e),Math.abs(c.det(i))>=h.eps&&s.transform(i[1][1],i[2][1],i[1][2],i[2][2],i[1][0],i[2][0]))},updateImageURL:function(t){var e;return e=s.evaluate(t.url),t._src!==e&&(t.imgIsLoaded=!1,t.rendNode.src=e,t._src=e,!0)},remove:function(t){s.exists(t)&&s.exists(t.parentNode)&&t.parentNode.removeChild(t)},updatePathStringPrim:function(t){var e,i,r,s,o,n="M",a=n,h=5e3,l=this.context;if(!(t.numberPoints<=0)){if(o=Math.min(t.points.length,t.numberPoints),l.beginPath(),1===t.bezierDegree)for(e=0;e<o;e++)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?a=n:(i[1]>h?i[1]=h:i[1]<-5e3&&(i[1]=-5e3),i[2]>h?i[2]=h:i[2]<-5e3&&(i[2]=-5e3),a===n?l.moveTo(i[1],i[2]):l.lineTo(i[1],i[2]),a="L");else if(3===t.bezierDegree)for(e=0;e<o;)i=t.points[e].scrCoords,isNaN(i[1])||isNaN(i[2])?a=n:(a===n?l.moveTo(i[1],i[2]):(e+=1,r=t.points[e].scrCoords,e+=1,s=t.points[e].scrCoords,l.bezierCurveTo(i[1],i[2],r[1],r[2],s[1],s[2])),a="C"),e+=1;l.lineCap="round",this._fill(t),this._stroke(t)}},updatePathStringBezierPrim:function(t){var e,i,r,o,n,a,h,l="M",d=l,u=5e3,p=s.evaluate(t.visProp.strokewidth),f="plot"!==s.evaluate(t.visProp.curvetype),m=this.context;if(!(t.numberPoints<=0)){for(f&&t.board.options.curve.RDPsmoothing&&(t.points=c.RamerDouglasPeucker(t.points,.5)),h=Math.min(t.points.length,t.numberPoints),m.beginPath(),i=1;i<3;i++)for(d=l,e=0;e<h;e++)o=t.points[e].scrCoords,isNaN(o[1])||isNaN(o[2])?d=l:(o[1]>u?o[1]=u:o[1]<-5e3&&(o[1]=-5e3),o[2]>u?o[2]=u:o[2]<-5e3&&(o[2]=-5e3),d===l?m.moveTo(o[1],o[2]):(r=2*i,m.bezierCurveTo(n+.333*(o[1]-n)+p*(r*Math.random()-i),a+.333*(o[2]-a)+p*(r*Math.random()-i),n+.666*(o[1]-n)+p*(r*Math.random()-i),a+.666*(o[2]-a)+p*(r*Math.random()-i),o[1],o[2])),d="C",n=o[1],a=o[2]);m.lineCap="round",this._fill(t),this._stroke(t)}},updatePolygonPrim:function(t,e){var i,r,s,o=e.vertices.length,n=this.context,a=!0;if(!(o<=0)&&e.visPropCalc.visible){for("polygonalchain"===e.elType&&o++,n.beginPath(),r=0;!e.vertices[r].isReal&&r<o-1;)r++,a=!1;for(i=e.vertices[r].coords.scrCoords,n.moveTo(i[1],i[2]),s=r;s<o-1;s++)e.vertices[s].isReal||(a=!1),i=e.vertices[s].coords.scrCoords,n.lineTo(i[1],i[2]);n.closePath(),a&&this._fill(e)}},display:function(t,e){t&&t.rendNode&&(t.visPropOld.visible=e,t.rendNode.style.visibility=e?"inherit":"hidden")},show:function(e){t.deprecated("Board.renderer.show()","Board.renderer.display()"),s.exists(e.rendNode)&&(e.rendNode.style.visibility="inherit")},hide:function(e){t.deprecated("Board.renderer.hide()","Board.renderer.display()"),s.exists(e.rendNode)&&(e.rendNode.style.visibility="hidden")},setGradient:function(t){var e;e=(e=s.evaluate(t.visProp.fillopacity))>0?e:0},setShadow:function(t){t.visPropOld.shadow!==t.visProp.shadow&&(t.visPropOld.shadow=t.visProp.shadow)},highlight:function(t){return t.elementClass===i.OBJECT_CLASS_TEXT&&"html"===s.evaluate(t.visProp.display)?this.updateTextStyle(t,!0):(t.board.prepareUpdate(),t.board.renderer.suspendRedraw(t.board),t.board.updateRenderer(),t.board.renderer.unsuspendRedraw()),this},noHighlight:function(t){return t.elementClass===i.OBJECT_CLASS_TEXT&&"html"===s.evaluate(t.visProp.display)?this.updateTextStyle(t,!1):(t.board.prepareUpdate(),t.board.renderer.suspendRedraw(t.board),t.board.updateRenderer(),t.board.renderer.unsuspendRedraw()),this},suspendRedraw:function(e){this.context.save(),this.context.clearRect(0,0,this.canvasRoot.width,this.canvasRoot.height),e&&e.attr.showcopyright&&this.displayCopyright(t.licenseText,12)},unsuspendRedraw:function(){this.context.restore()},resize:function(t,e){this.container?(this.canvasRoot.style.width=parseFloat(t)+"px",this.canvasRoot.style.height=parseFloat(e)+"px",this.canvasRoot.setAttribute("width",2*parseFloat(t)+"px"),this.canvasRoot.setAttribute("height",2*parseFloat(e)+"px")):(this.canvasRoot.width=2*parseFloat(t),this.canvasRoot.height=2*parseFloat(e)),this.context=this.canvasRoot.getContext("2d"),this.context.scale(2,2)},removeToInsertLater:function(){return function(){}}}),t.CanvasRenderer})),define("renderer/no",["jxg","renderer/abstract"],(function(t,e){"use strict";return t.NoRenderer=function(){this.enhancedRendering=!1,this.type="no"},t.extend(t.NoRenderer.prototype,{drawPoint:function(t){},updatePoint:function(t){},changePointStyle:function(t){},drawLine:function(t){},updateLine:function(t){},drawTicks:function(t){},updateTicks:function(t){},drawCurve:function(t){},updateCurve:function(t){},drawEllipse:function(t){},updateEllipse:function(t){},drawPolygon:function(t){},updatePolygon:function(t){},displayCopyright:function(t,e){},drawInternalText:function(t){},updateInternalText:function(t){},drawText:function(t){},updateText:function(t){},updateTextStyle:function(t,e){},updateInternalTextStyle:function(t,e,i){},drawImage:function(t){},updateImage:function(t){},transformImage:function(t,e){},updateImageURL:function(t){},appendChildPrim:function(t,e){},appendNodesToElement:function(t,e){},createPrim:function(t,e){return null},remove:function(t){},makeArrows:function(t){},updateEllipsePrim:function(t,e,i,r,s){},updateLinePrim:function(t,e,i,r,s,o){},updatePathPrim:function(t,e,i){},updatePathStringPoint:function(t,e,i){},updatePathStringPrim:function(t){},updatePathStringBezierPrim:function(t){},updatePolygonPrim:function(t,e){},updateRectPrim:function(t,e,i,r,s){},setPropertyPrim:function(t,e,i){},display:function(t,e){t&&(t.visPropOld.visible=e)},show:function(t){},hide:function(t){},setBuffering:function(t,e){},setDashStyle:function(t){},setDraft:function(t){},removeDraft:function(t){},setGradient:function(t){},updateGradient:function(t){},setObjectTransition:function(t,e){},setObjectFillColor:function(t,e,i){},setObjectStrokeColor:function(t,e,i){},setObjectStrokeWidth:function(t,e){},setShadow:function(t){},highlight:function(t){},noHighlight:function(t){},suspendRedraw:function(){},unsuspendRedraw:function(){},drawZoomBar:function(t){},getElementById:function(t){return null},resize:function(t,e){},removeToInsertLater:function(){return function(){}}}),t.NoRenderer.prototype=new e,t.NoRenderer})),define("jsxgraph",["jxg","utils/env","utils/type","base/board","reader/file","options","renderer/svg","renderer/vml","renderer/canvas","renderer/no"],(function(t,e,i,r,s,o,n,a,h,l){"use strict";return t.JSXGraph={rendererType:(o.board.renderer="no",e.supportsVML()&&(o.board.renderer="vml",document.onmousemove=function(){var t;return document.body&&(t=document.body.scrollLeft,t+=document.body.scrollTop),t}),e.supportsCanvas()&&(o.board.renderer="canvas"),e.supportsSVG()&&(o.board.renderer="svg"),e.isNode()&&e.supportsCanvas()&&(o.board.renderer="canvas"),(e.isNode()||"no"===o.renderer)&&(o.text.display="internal",o.infobox.display="internal"),o.board.renderer),initRenderer:function(t,e,r,s){var o;if(i.exists(r)&&!1!==r||"object"!=typeof document||(r=document),"object"==typeof r&&null!==t)for(o=r.getElementById(t);o.firstChild;)o.removeChild(o.firstChild);else o=t;return void 0!==s&&"auto"!==s||(s=this.rendererType),"svg"===s?new n(o,e):"vml"===s?new a(o):"canvas"===s?new h(o,e):new l},_setAttributes:function(t){var e=i.copyAttributes(t,o,"board");return e.zoom=i.copyAttributes(e,o,"board","zoom"),e.pan=i.copyAttributes(e,o,"board","pan"),e.drag=i.copyAttributes(e,o,"board","drag"),e.keyboard=i.copyAttributes(e,o,"board","keyboard"),e.selection=i.copyAttributes(e,o,"board","selection"),e.navbar=i.copyAttributes(e.navbar,o,"navbar"),e.screenshot=i.copyAttributes(e,o,"board","screenshot"),e.resize=i.copyAttributes(e,o,"board","resize"),e.fullscreen=i.copyAttributes(e,o,"board","fullscreen"),e.movetarget=t.moveTarget||t.movetarget||o.board.moveTarget,e},_fillBoard:function(e,i,r){e.initInfobox(),e.maxboundingbox=i.maxboundingbox,e.resizeContainer(r.width,r.height,!0,!0),e._createSelectionPolygon(i),e.renderer.drawZoomBar(e,i.navbar),t.boards[e.id]=e},_setARIA:function(t,e){var i,r,s,o,n,a=e.document||document;"object"==typeof a&&(s=(i=a.getElementById(t)).parentNode,o=t+"_ARIAlabel",n=t+"_ARIAdescription",(r=a.createElement("div")).innerHTML=e.title,r.setAttribute("id",o),r.style.display="none",s.insertBefore(r,i),(r=a.createElement("div")).innerHTML=e.description,r.setAttribute("id",n),r.style.display="none",s.insertBefore(r,i),i.setAttribute("aria-labelledby",o),i.setAttribute("aria-describedby",n))},_removeARIANodes:function(t){var e,i;"object"==typeof(t.document||document)&&(i=t.containerObj.getAttribute("aria-labelledby"),(e=document.getElementById(i))&&e.parentNode&&e.parentNode.removeChild(e),i=t.containerObj.getAttribute("aria-describedby"),(e=document.getElementById(i))&&e.parentNode&&e.parentNode.removeChild(e))},initBoard:function(t,s){var n,a,h,l,c,d,u,p,f,m,g,b,v,y,C=0,_=0;return s=s||{},m=this._setAttributes(s),p=e.getDimensions(t,m.document),m.unitx||m.unity?(n=i.def(m.originx,150),a=i.def(m.originy,150),h=i.def(m.unitx,50),l=i.def(m.unity,50)):((f=m.boundingbox)[0]<m.maxboundingbox[0]&&(f[0]=m.maxboundingbox[0]),f[1]>m.maxboundingbox[1]&&(f[1]=m.maxboundingbox[1]),f[2]>m.maxboundingbox[2]&&(f[2]=m.maxboundingbox[2]),f[3]<m.maxboundingbox[3]&&(f[3]=m.maxboundingbox[3]),d=parseInt(p.width,10),u=parseInt(p.height,10),i.exists(f)&&m.keepaspectratio?(h=d/(f[2]-f[0]),l=u/(f[1]-f[3]),Math.abs(h)<Math.abs(l)?_=.5*(u/(l=Math.abs(h)*l/Math.abs(l))-(f[1]-f[3])):C=.5*(d/(h=Math.abs(l)*h/Math.abs(h))-(f[2]-f[0]))):(h=d/(f[2]-f[0]),l=u/(f[1]-f[3])),n=-h*(f[0]-C),a=l*(f[1]+_)),c=this.initRenderer(t,p,m.document,m.renderer),this._setARIA(t,m),(y=new r(t,c,m.id,[n,a],m.zoomfactor*m.zoomx,m.zoomfactor*m.zoomy,h,l,p.width,p.height,m)).keepaspectratio=m.keepaspectratio,this._fillBoard(y,m,p),y.suspendUpdate(),m.axis&&(g="object"==typeof m.axis?m.axis:{},b=i.deepCopy(o.board.defaultAxes.x,g),v=i.deepCopy(o.board.defaultAxes.y,g),m.defaultaxes.x&&(b=i.deepCopy(b,m.defaultaxes.x)),m.defaultaxes.y&&(v=i.deepCopy(v,m.defaultaxes.y)),y.defaultAxes={},y.defaultAxes.x=y.create("axis",[[0,0],[1,0]],b),y.defaultAxes.y=y.create("axis",[[0,0],[0,1]],v)),m.grid&&y.create("grid",[],"object"==typeof m.grid?m.grid:{}),y.unsuspendUpdate(),y},loadBoardFromFile:function(t,i,o,n,a){var h,l,c,d,u;return n=n||{},h=this._setAttributes(n),d=e.getDimensions(t,h.document),l=this.initRenderer(t,d,h.document,h.renderer),this._setARIA(t,h),c=new r(t,l,"",[150,150],1,1,50,50,d.width,d.height,h),this._fillBoard(c,h,d),u=h.encoding||"iso-8859-1",s.parseFileContent(i,c,o,!0,u,a),c},loadBoardFromString:function(t,i,o,n,a){var h,l,c,d;return n=n||{},h=this._setAttributes(n),d=e.getDimensions(t,h.document),l=this.initRenderer(t,d,h.document),this._setARIA(t,h),c=new r(t,l,"",[150,150],1,1,50,50,d.width,d.height,h),this._fillBoard(c,h,d),s.parseString(i,c,o,!0,a),c},freeBoard:function(e){var i;for(i in"string"==typeof e&&(e=t.boards[e]),this._removeARIANodes(e),e.removeEventHandlers(),e.suspendUpdate(),e.objects)e.objects.hasOwnProperty(i)&&e.objects[i].remove();for(;e.containerObj.firstChild;)e.containerObj.removeChild(e.containerObj.firstChild);for(i in e.objects)e.objects.hasOwnProperty(i)&&delete e.objects[i];delete e.renderer,e.jc.creator.clearCache(),delete e.jc,delete t.boards[e.id]},registerElement:function(e,i){t.deprecated("JXG.JSXGraph.registerElement()","JXG.registerElement()"),t.registerElement(e,i)}},e.isBrowser&&"object"==typeof window&&"object"==typeof document&&e.addEvent(window,"load",(function(){var e,r,s,o,n,a,h,l,c,d,u,p,f,m,g,b,v,y,C=!1,_=document.getElementsByTagName("script"),P=function(e,i,r){var s=t.JSXGraph.initBoard(n,{boundingbox:r,keepaspectratio:!0,grid:g,axis:m,showReload:!0});if(i.toLowerCase().indexOf("script")>-1)s.construct(e);else try{s.jc.parse(e)}catch(e){t.debug(e)}return s},E=function(e,i,r,s){return function(){var o;t.JSXGraph.freeBoard(e),(o=P(i,r,s)).reload=E(o,i,r,s)}};for(r=0;r<_.length;r++)if(e=_[r].getAttribute("type",!1),i.exists(e)&&("text/jessiescript"===e.toLowerCase()||"jessiescript"===e.toLowerCase()||"text/jessiecode"===e.toLowerCase()||"jessiecode"===e.toLowerCase())){if(p=_[r].getAttribute("class",!1)||"",l=_[r].getAttribute("width",!1)||"",c=_[r].getAttribute("height",!1)||"",d=_[r].getAttribute("maxwidth",!1)||"100%",u=_[r].getAttribute("aspectratio",!1)||"1/1",f=_[r].getAttribute("boundingbox",!1)||"-5, 5, 5, -5",n=_[r].getAttribute("container",!1),v=_[r].getAttribute("src",!1),4!==(f=f.split(",")).length)f=[-5,5,5,-5];else for(s=0;s<f.length;s++)f[s]=parseFloat(f[s]);if(m=i.str2Bool(_[r].getAttribute("axis",!1)||"false"),g=i.str2Bool(_[r].getAttribute("grid",!1)||"false"),i.exists(n))o=document.getElementById(n);else{n="jessiescript_autgen_jxg_"+r,(o=document.createElement("div")).setAttribute("id",n),h=""!==l?"width:"+l+";":"",h+=""!==c?"height:"+c+";":"",h+=""!==d?"max-width:"+d+";":"",h+=""!==u?"aspect-ratio:"+u+";":"",o.setAttribute("style",h),o.setAttribute("class","jxgbox "+p);try{document.body.insertBefore(o,_[r])}catch(t){"object"==typeof jQuery&&jQuery(o).insertBefore(_[r])}}b="",i.exists(v)?(C=!0,(y=new XMLHttpRequest).open("GET",v),y.overrideMimeType("text/plain; charset=x-user-defined"),y.addEventListener("load",(function(){if(!(this.status<400))throw new Error("\nJSXGraph: failed to load file",v,":",this.responseText);b=this.responseText+"\n"+b,(a=P(b,e,f)).reload=E(a,b,e,f)})),y.addEventListener("error",(function(t){throw new Error("\nJSXGraph: failed to load file",v,":",t)})),y.send()):C=!1,document.getElementById(n)?(b=(b=_[r].innerHTML).replace(/<!\[CDATA\[/g,"").replace(/\]\]>/g,""),_[r].innerHTML=b,C||((a=P(b,e,f)).reload=E(a,b,e,f))):t.debug("JSXGraph: Apparently the div injection failed. Can't create a board, sorry.")}}),window),t.JSXGraph})),define("base/point",["jxg","options","math/math","math/geometry","base/constants","base/element","utils/type","base/coordselement"],(function(t,e,i,r,s,o,n,a){"use strict";return t.Point=function(t,e,i){this.constructor(t,i,s.OBJECT_TYPE_POINT,s.OBJECT_CLASS_POINT),this.element=this.board.select(i.anchor),this.coordsConstructor(e),this.elType="point",this.id=this.board.setId(this,"P"),this.board.renderer.drawPoint(this),this.board.finalizeAdding(this),this.createLabel()},t.Point.prototype=new o,n.copyPrototypeMethods(t.Point,a,"coordsConstructor"),t.extend(t.Point.prototype,{hasPoint:function(t,e){var i,r,s,o=this.coords.scrCoords,a=n.evaluate(this.visProp.sizeunit);return n.isObject(n.evaluate(this.visProp.precision))?(s=this.board._inputDevice,r=n.evaluate(this.visProp.precision[s])):r=this.board.options.precision.hasPoint,i=parseFloat(n.evaluate(this.visProp.size)),"user"===a&&(i*=Math.sqrt(this.board.unitX*this.board.unitY)),(i+=.5*parseFloat(n.evaluate(this.visProp.strokewidth)))<r&&(i=r),Math.abs(o[1]-t)<i+2&&Math.abs(o[2]-e)<i+2},update:function(t){return this.needsUpdate?(this.updateCoords(t),n.evaluate(this.visProp.trace)&&this.cloneToBackground(!0),this):this},updateTransform:function(t){var e,i;if(0===this.transformations.length||null===this.baseElement)return this;for(this===this.baseElement?(e=this.transformations[0].apply(this.baseElement,"self"),this.coords.setCoordinates(s.COORDS_BY_USER,e)):e=this.transformations[0].apply(this.baseElement),this.coords.setCoordinates(s.COORDS_BY_USER,e),i=1;i<this.transformations.length;i++)this.coords.setCoordinates(s.COORDS_BY_USER,this.transformations[i].apply(this));return this},updateRenderer:function(){return this.updateRendererGeneric("updatePoint"),this},bounds:function(){return this.coords.usrCoords.slice(1).concat(this.coords.usrCoords.slice(1))},makeIntersection:function(t,e,i,o){var a;t=this.board.select(t),e=this.board.select(e),a=r.intersectionFunction(this.board,t,e,i,o,n.evaluate(this.visProp.alwaysintersect)),this.addConstraint([a]);try{t.addChild(this),e.addChild(this)}catch(i){throw new Error("JSXGraph: Can't create 'intersection' with parent types '"+typeof t+"' and '"+typeof e+"'.")}this.type=s.OBJECT_TYPE_INTERSECTION,this.elType="intersection",this.parents=[t.id,e.id,i,o],this.generatePolynomial=function(){var i=t.generatePolynomial(this),r=e.generatePolynomial(this);return 0===i.length||0===r.length?[]:[i[0],r[0]]},this.prepareUpdate().update()},setStyle:function(t){return this.visProp.face=["cross","cross","cross","circle","circle","circle","circle","square","square","square","plus","plus","plus"][t],this.visProp.size=[2,3,4,1,2,3,4,2,3,4,2,3,4][t],this.board.renderer.changePointStyle(this),this},normalizeFace:function(i){return t.deprecated("Point.normalizeFace()","JXG.normalizePointFace()"),e.normalizePointFace(i)},face:function(e){t.deprecated("Point.face()","Point.setAttribute()"),this.setAttribute({face:e})},size:function(e){t.deprecated("Point.size()","Point.setAttribute()"),this.setAttribute({size:e})},isOn:function(e,o){var a,h;return o=o||i.eps,n.isPoint(e)?this.Dist(e)<o:e.elementClass===s.OBJECT_CLASS_LINE?("segment"!==e.elType||n.evaluate(this.visProp.alwaysintersect)||(a=t.Math.Geometry.projectCoordsToSegment(this.coords.usrCoords,e.point1.coords.usrCoords,e.point2.coords.usrCoords))[1]>=0&&a[1]<=1)&&r.distPointLine(this.coords.usrCoords,e.stdform)<o:e.elementClass===s.OBJECT_CLASS_CIRCLE?n.evaluate(e.visProp.hasinnerpoints)?this.Dist(e.center)<e.Radius()+o:Math.abs(this.Dist(e.center)-e.Radius())<o:e.elementClass===s.OBJECT_CLASS_CURVE?(h=r.projectPointToCurve(this,e,this.board)[0],r.distance(this.coords.usrCoords,h.usrCoords,3)<o):e.type===s.OBJECT_TYPE_POLYGON?!(!n.evaluate(e.visProp.hasinnerpoints)||!e.pnpoly(this.coords.usrCoords[1],this.coords.usrCoords[2],t.COORDS_BY_USER))||(a=r.projectCoordsToPolygon(this.coords.usrCoords,e),r.distance(this.coords.usrCoords,a,3)<o):e.type===s.OBJECT_TYPE_TURTLE&&(h=r.projectPointToTurtle(this,e,this.board),r.distance(this.coords.usrCoords,h.usrCoords,3)<o)},cloneToBackground:function(){var t={};return t.id=this.id+"T"+this.numTraces,this.numTraces+=1,t.coords=this.coords,t.visProp=n.deepCopy(this.visProp,this.visProp.traceattributes,!0),t.visProp.layer=this.board.options.layer.trace,t.elementClass=s.OBJECT_CLASS_POINT,t.board=this.board,n.clearVisPropOld(t),t.visPropCalc={visible:n.evaluate(t.visProp.visible)},this.board.renderer.drawPoint(t),this.traces[t.id]=t.rendNode,this}}),t.createPoint=function(e,i,r){var s,o;if(o=n.copyAttributes(r,e.options,"point"),!(s=a.create(t.Point,e,i,o)))throw new Error("JSXGraph: Can't create point with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [x,y], [z,x,y], [element,transformation]");return s},t.createGlider=function(t,e,i){var r,s,o=n.copyAttributes(i,t.options,"glider");return s=1===e.length?[0,0]:e.slice(0,2),(r=t.create("point",s,o)).makeGlider(e[e.length-1]),r},t.createIntersectionPoint=function(t,e,i){var o,a,h,l,c,d,u=n.copyAttributes(i,t.options,"intersection");e.push(0,0),a=t.select(e[0]),h=t.select(e[1]),c=e[2]||0,d=e[3]||0,o=t.create("point",[0,0,0],u),l=r.intersectionFunction(t,a,h,c,d,o.visProp.alwaysintersect),o.addConstraint([l]);try{a.addChild(o),h.addChild(o)}catch(t){throw new Error("JSXGraph: Can't create 'intersection' with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.")}return o.type=s.OBJECT_TYPE_INTERSECTION,o.elType="intersection",o.setParents([a.id,h.id]),o.intersectionNumbers=[c,d],o.getParents=function(){return this.parents.concat(this.intersectionNumbers)},o.generatePolynomial=function(){var t=a.generatePolynomial(o),e=h.generatePolynomial(o);return 0===t.length||0===e.length?[]:[t[0],e[0]]},o},t.createOtherIntersectionPoint=function(t,e,o){var a,h,l,c;if(3!==e.length||!n.isPoint(e[2])||e[0].elementClass!==s.OBJECT_CLASS_LINE&&e[0].elementClass!==s.OBJECT_CLASS_CIRCLE||e[1].elementClass!==s.OBJECT_CLASS_LINE&&e[1].elementClass!==s.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create 'other intersection point' with parent types '"+typeof e[0]+"',  '"+typeof e[1]+"'and  '"+typeof e[2]+"'.\nPossible parent types: [circle|line,circle|line,point]");return h=t.select(e[0]),l=t.select(e[1]),c=t.select(e[2]),(a=t.create("point",[function(){var t=r.meet(h.stdform,l.stdform,0,h.board);return Math.abs(c.X()-t.usrCoords[1])>i.eps||Math.abs(c.Y()-t.usrCoords[2])>i.eps||Math.abs(c.Z()-t.usrCoords[0])>i.eps?t:r.meet(h.stdform,l.stdform,1,h.board)}],o)).type=s.OBJECT_TYPE_INTERSECTION,a.elType="otherintersection",a.setParents([h.id,l.id,c]),h.addChild(a),l.addChild(a),a.generatePolynomial=function(){var t=h.generatePolynomial(a),e=l.generatePolynomial(a);return 0===t.length||0===e.length?[]:[t[0],e[0]]},a},t.createPolePoint=function(e,i,r){var o,n,a,h,l,c,d;if(i.length>1&&(h=i[0].type===s.OBJECT_TYPE_CONIC||i[0].elementClass===s.OBJECT_CLASS_CIRCLE,l=i[1].type===s.OBJECT_TYPE_CONIC||i[1].elementClass===s.OBJECT_CLASS_CIRCLE,c=i[0].elementClass===s.OBJECT_CLASS_LINE,d=i[1].elementClass===s.OBJECT_CLASS_LINE),2!==i.length||!(h&&d||c&&l))throw new Error("JSXGraph: Can't create 'pole point' with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent type: [conic|circle,line], [line,conic|circle]");return d?(n=e.select(i[0]),a=e.select(i[1])):(n=e.select(i[1]),a=e.select(i[0])),(o=e.create("point",[function(){var e=n.quadraticform,i=a.stdform.slice(0,3);return[t.Math.Numerics.det([i,e[1],e[2]]),t.Math.Numerics.det([e[0],i,e[2]]),t.Math.Numerics.det([e[0],e[1],i])]}],r)).elType="polepoint",o.setParents([n.id,a.id]),n.addChild(o),a.addChild(o),o},t.registerElement("point",t.createPoint),t.registerElement("glider",t.createGlider),t.registerElement("intersection",t.createIntersectionPoint),t.registerElement("otherintersection",t.createOtherIntersectionPoint),t.registerElement("polepoint",t.createPolePoint),{Point:t.Point,createPoint:t.createPoint,createGlider:t.createGlider,createIntersection:t.createIntersectionPoint,createOtherIntersection:t.createOtherIntersectionPoint,createPolePoint:t.createPolePoint}})),define("base/line",["jxg","math/math","math/geometry","math/numerics","math/statistics","base/constants","base/coords","base/element","utils/type","base/point"],(function(t,e,i,r,s,o,n,a,h,l){"use strict";return t.Line=function(e,i,r,s){this.constructor(e,s,o.OBJECT_TYPE_LINE,o.OBJECT_CLASS_LINE),this.point1=this.board.select(i),this.point2=this.board.select(r),this.ticks=[],this.defaultTicks=null,this.parentPolygon=null,this.id=this.board.setId(this,"L"),this.board.renderer.drawLine(this),this.board.finalizeAdding(this),this.elType="line",this.point1._is_new?(this.addChild(this.point1),delete this.point1._is_new):this.point1.addChild(this),this.point2._is_new?(this.addChild(this.point2),delete this.point2._is_new):this.point2.addChild(this),this.inherits.push(this.point1,this.point2),this.updateStdform(),this.createLabel(),this.methodMap=t.deepCopy(this.methodMap,{point1:"point1",point2:"point2",getSlope:"getSlope",getRise:"getRise",getYIntersect:"getRise",getAngle:"getAngle",L:"L",length:"L"})},t.Line.prototype=new a,t.extend(t.Line.prototype,{hasPoint:function(t,r){var s,a,l,c,d,u,p,f,m,g=[],b=[1,t,r],v=h.evaluate(this.visProp.strokewidth);return h.isObject(h.evaluate(this.visProp.precision))?(m=this.board._inputDevice,f=h.evaluate(this.visProp.precision[m])):f=this.board.options.precision.hasPoint,f+=.5*v,g[0]=this.stdform[0]-this.stdform[1]*this.board.origin.scrCoords[1]/this.board.unitX+this.stdform[2]*this.board.origin.scrCoords[2]/this.board.unitY,g[1]=this.stdform[1]/this.board.unitX,g[2]=this.stdform[2]/-this.board.unitY,s=i.distPointLine(b,g),!(isNaN(s)||s>f)&&(!(!h.evaluate(this.visProp.straightfirst)||!h.evaluate(this.visProp.straightlast))||(l=this.point1.coords,c=this.point2.coords,a=[0,g[1],g[2]],a=e.crossProduct(a,b),(a=e.crossProduct(a,g))[1]/=a[0],a[2]/=a[0],a[0]=1,a=new n(o.COORDS_BY_SCREEN,a.slice(1),this.board).usrCoords,d=l.distance(o.COORDS_BY_USER,c),l=l.usrCoords.slice(0),c=c.usrCoords.slice(0),d<e.eps?u=0:(d===Number.POSITIVE_INFINITY&&(d=1/e.eps,Math.abs(c[0])<e.eps?(d/=i.distance([0,0,0],c),c=[1,l[1]+c[1]*d,l[2]+c[2]*d]):(d/=i.distance([0,0,0],l),l=[1,c[1]+l[1]*d,c[2]+l[2]*d])),d=c[p=1]-l[p],Math.abs(d)<e.eps&&(d=c[p=2]-l[p]),u=(a[p]-l[p])/d),!(!h.evaluate(this.visProp.straightfirst)&&u<0)&&!(!h.evaluate(this.visProp.straightlast)&&u>1)))},update:function(){var t;return this.needsUpdate?(this.constrained&&(h.isFunction(this.funps)?(t=this.funps())&&t.length&&2===t.length&&(this.point1=t[0],this.point2=t[1]):(h.isFunction(this.funp1)&&(t=this.funp1(),h.isPoint(t)?this.point1=t:t&&t.length&&2===t.length&&this.point1.setPositionDirectly(o.COORDS_BY_USER,t)),h.isFunction(this.funp2)&&(t=this.funp2(),h.isPoint(t)?this.point2=t:t&&t.length&&2===t.length&&this.point2.setPositionDirectly(o.COORDS_BY_USER,t)))),this.updateSegmentFixedLength(),this.updateStdform(),h.evaluate(this.visProp.trace)&&this.cloneToBackground(!0),this):this},updateSegmentFixedLength:function(){var t,i,r,s,n,a,l,c;return this.hasFixedLength?(t=this.point1.Dist(this.point2),i=this.fixedLength(),r=this.fixedLengthOldCoords[0].distance(o.COORDS_BY_USER,this.point1.coords),s=this.fixedLengthOldCoords[1].distance(o.COORDS_BY_USER,this.point2.coords),(r>e.eps||s>e.eps||t!==i)&&(n=this.point1.isDraggable&&this.point1.type!==o.OBJECT_TYPE_GLIDER&&!h.evaluate(this.point1.visProp.fixed),a=this.point2.isDraggable&&this.point2.type!==o.OBJECT_TYPE_GLIDER&&!h.evaluate(this.point2.visProp.fixed),t>e.eps?r>s&&a||r<=s&&a&&!n?(this.point2.setPositionDirectly(o.COORDS_BY_USER,[this.point1.X()+(this.point2.X()-this.point1.X())*i/t,this.point1.Y()+(this.point2.Y()-this.point1.Y())*i/t]),this.point2.fullUpdate()):(r<=s&&n||r>s&&n&&!a)&&(this.point1.setPositionDirectly(o.COORDS_BY_USER,[this.point2.X()+(this.point1.X()-this.point2.X())*i/t,this.point2.Y()+(this.point1.Y()-this.point2.Y())*i/t]),this.point1.fullUpdate()):(l=Math.random()-.5,c=Math.random()-.5,t=Math.sqrt(l*l+c*c),a?(this.point2.setPositionDirectly(o.COORDS_BY_USER,[this.point1.X()+l*i/t,this.point1.Y()+c*i/t]),this.point2.fullUpdate()):n&&(this.point1.setPositionDirectly(o.COORDS_BY_USER,[this.point2.X()+l*i/t,this.point2.Y()+c*i/t]),this.point1.fullUpdate())),this.fixedLengthOldCoords[0].setCoordinates(o.COORDS_BY_USER,this.point1.coords.usrCoords),this.fixedLengthOldCoords[1].setCoordinates(o.COORDS_BY_USER,this.point2.coords.usrCoords)),this):this},updateStdform:function(){var t=e.crossProduct(this.point1.coords.usrCoords,this.point2.coords.usrCoords);this.stdform[0]=t[0],this.stdform[1]=t[1],this.stdform[2]=t[2],this.stdform[3]=0,this.normalize()},updateRenderer:function(){return this.needsUpdate?(this.visPropCalc.visible&&(this.isReal=!isNaN(this.point1.coords.usrCoords[1]+this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[1]+this.point2.coords.usrCoords[2])&&e.innerProduct(this.stdform,this.stdform,3)>=e.eps*e.eps,this.isReal||this.updateVisibility(!1)),this.visPropCalc.visible&&this.board.renderer.updateLine(this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},generatePolynomial:function(t){var e=this.point1.symbolic.x,i=this.point1.symbolic.y,r=this.point2.symbolic.x,s=this.point2.symbolic.y,o=t.symbolic.x,n=t.symbolic.y;return[["(",i,")*(",o,")-(",i,")*(",r,")+(",n,")*(",r,")-(",e,")*(",n,")+(",e,")*(",s,")-(",o,")*(",s,")"].join("")]},getRise:function(){return Math.abs(this.stdform[2])>=e.eps?-this.stdform[0]/this.stdform[2]:1/0},getSlope:function(){return Math.abs(this.stdform[2])>=e.eps?-this.stdform[1]/this.stdform[2]:1/0},getAngle:function(){return Math.atan2(-this.stdform[1],this.stdform[2])},setStraight:function(t,e){return this.visProp.straightfirst=t,this.visProp.straightlast=e,this.board.renderer.updateLine(this),this},getTextAnchor:function(){return new n(o.COORDS_BY_USER,[.5*(this.point2.X()+this.point1.X()),.5*(this.point2.Y()+this.point1.Y())],this.board)},setLabelRelativeCoords:function(t){h.exists(this.label)&&(this.label.relativeCoords=new n(o.COORDS_BY_SCREEN,[t[0],-t[1]],this.board))},getLabelAnchor:function(){var t,r,s=0,a=new n(o.COORDS_BY_USER,this.point1.coords.usrCoords,this.board),l=new n(o.COORDS_BY_USER,this.point2.coords.usrCoords,this.board),c=h.evaluate(this.visProp.straightfirst),d=h.evaluate(this.visProp.straightlast);if((c||d)&&i.calcStraight(this,a,l,0),a=a.scrCoords,l=l.scrCoords,!h.exists(this.label))return new n(o.COORDS_BY_SCREEN,[NaN,NaN],this.board);switch(h.evaluate(this.label.visProp.position)){case"lft":case"llft":case"ulft":a[1]<=l[1]?(t=a[1],r=a[2]):(t=l[1],r=l[2]);break;case"rt":case"lrt":case"urt":a[1]>l[1]?(t=a[1],r=a[2]):(t=l[1],r=l[2]);break;default:t=.5*(a[1]+l[1]),r=.5*(a[2]+l[2])}return(c||d)&&(h.exists(this.label)&&(s=h.evaluate(this.label.visProp.fontsize)),Math.abs(t)<e.eps?t=s:this.board.canvasWidth+e.eps>t&&t>this.board.canvasWidth-s-e.eps&&(t=this.board.canvasWidth-s),e.eps+s>r&&r>-e.eps?r=s:this.board.canvasHeight+e.eps>r&&r>this.board.canvasHeight-s-e.eps&&(r=this.board.canvasHeight-s)),new n(o.COORDS_BY_SCREEN,[t,r],this.board)},cloneToBackground:function(){var t,e,i,r={};return r.id=this.id+"T"+this.numTraces,r.elementClass=o.OBJECT_CLASS_LINE,this.numTraces++,r.point1=this.point1,r.point2=this.point2,r.stdform=this.stdform,r.board=this.board,r.visProp=h.deepCopy(this.visProp,this.visProp.traceattributes,!0),r.visProp.layer=this.board.options.layer.trace,h.clearVisPropOld(r),r.visPropCalc={visible:h.evaluate(r.visProp.visible)},e=this.getSlope(),t=this.getRise(),r.getSlope=function(){return e},r.getRise=function(){return t},i=this.board.renderer.enhancedRendering,this.board.renderer.enhancedRendering=!0,this.board.renderer.drawLine(r),this.board.renderer.enhancedRendering=i,this.traces[r.id]=r.rendNode,this},addTransform:function(t){var e,i=h.isArray(t)?t:[t],r=i.length;for(e=0;e<r;e++)this.point1.transformations.push(i[e]),this.point2.transformations.push(i[e]);return this},snapToGrid:function(t){var e,r,a,l,c,d,u,p;return h.evaluate(this.visProp.snaptogrid)?this.parents.length<3?(this.point1.handleSnapToGrid(!0,!0),this.point2.handleSnapToGrid(!0,!0)):h.exists(t)&&(u=h.evaluate(this.visProp.snapsizex),p=h.evaluate(this.visProp.snapsizey),c=(e=new n(o.COORDS_BY_SCREEN,[t.Xprev,t.Yprev],this.board)).usrCoords[1],d=e.usrCoords[2],u<=0&&this.board.defaultAxes&&this.board.defaultAxes.x.defaultTicks&&(u=(l=this.board.defaultAxes.x.defaultTicks).ticksDelta*(h.evaluate(l.visProp.minorticks)+1)),p<=0&&this.board.defaultAxes&&this.board.defaultAxes.y.defaultTicks&&(p=(l=this.board.defaultAxes.y.defaultTicks).ticksDelta*(h.evaluate(l.visProp.minorticks)+1)),u>0&&p>0&&(r=i.projectPointToLine({coords:e},this,this.board),a=s.subtract([1,Math.round(c/u)*u,Math.round(d/p)*p],r.usrCoords),this.board.create("transform",a.slice(1),{type:"translate"}).applyOnce([this.point1,this.point2]))):(this.point1.handleSnapToGrid(!1,!0),this.point2.handleSnapToGrid(!1,!0)),this},snapToPoints:function(){var t=h.evaluate(this.visProp.snaptopoints);return this.parents.length<3&&(this.point1.handleSnapToPoints(t),this.point2.handleSnapToPoints(t)),this},X:function(t){var i,r=this.stdform[2];return i=Math.abs(this.point1.coords.usrCoords[0])>e.eps?this.point1.coords.usrCoords[1]:this.point2.coords.usrCoords[1],t=2*(t-.5),(1-Math.abs(t))*i-t*r},Y:function(t){var i,r=this.stdform[1];return i=Math.abs(this.point1.coords.usrCoords[0])>e.eps?this.point1.coords.usrCoords[2]:this.point2.coords.usrCoords[2],t=2*(t-.5),(1-Math.abs(t))*i+t*r},Z:function(t){var i=Math.abs(this.point1.coords.usrCoords[0])>e.eps?this.point1.coords.usrCoords[0]:this.point2.coords.usrCoords[0];return t=2*(t-.5),(1-Math.abs(t))*i},L:function(){return this.point1.Dist(this.point2)},minX:function(){return 0},maxX:function(){return 1},bounds:function(){var t=this.point1.coords.usrCoords,e=this.point2.coords.usrCoords;return[Math.min(t[1],e[1]),Math.max(t[2],e[2]),Math.max(t[1],e[1]),Math.min(t[2],e[2])]},remove:function(){this.removeAllTicks(),a.prototype.remove.call(this)}}),t.createLine=function(e,i,r){var s,o,n,a,c,d,u,p=[],f=!1,m=!1;if(2===i.length){if(h.isArray(i[0])&&i[0].length>1)d=h.copyAttributes(r,e.options,"line","point1"),n=e.create("point",i[0],d);else if(h.isString(i[0])||h.isPoint(i[0]))n=e.select(i[0]);else if(h.isFunction(i[0])&&h.isPoint(i[0]()))n=i[0](),m=!0;else if(h.isFunction(i[0])&&i[0]().length&&i[0]().length>=2)d=h.copyAttributes(r,e.options,"line","point1"),n=l.createPoint(e,i[0](),d),m=!0;else{if(!h.isObject(i[0])||!h.isTransformationOrArray(i[1]))throw new Error("JSXGraph: Can't create line with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]");f=!0,d=h.copyAttributes(r,e.options,"line","point1"),n=e.create("point",[i[0].point1,i[1]],d)}if(f)d=h.copyAttributes(r,e.options,"line","point2"),a=e.create("point",[i[0].point2,i[1]],d);else if(h.isArray(i[1])&&i[1].length>1)d=h.copyAttributes(r,e.options,"line","point2"),a=e.create("point",i[1],d);else if(h.isString(i[1])||h.isPoint(i[1]))a=e.select(i[1]);else if(h.isFunction(i[1])&&h.isPoint(i[1]()))a=i[1](),m=!0;else{if(!(h.isFunction(i[1])&&i[1]().length&&i[1]().length>=2))throw new Error("JSXGraph: Can't create line with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]");d=h.copyAttributes(r,e.options,"line","point2"),a=l.createPoint(e,i[1](),d),m=!0}d=h.copyAttributes(r,e.options,"line"),o=new t.Line(e,n,a,d),m?(o.constrained=!0,o.funp1=i[0],o.funp2=i[1]):f||(o.isDraggable=!0),o.setParents([n.id,a.id])}else if(3===i.length){for(u=!0,c=0;c<3;c++)if(h.isNumber(i[c]))p[c]=h.createFunction(i[c]);else{if(!h.isFunction(i[c]))throw new Error("JSXGraph: Can't create line with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"' and '"+typeof i[2]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]");p[c]=i[c],u=!1}d=h.copyAttributes(r,e.options,"line","point1"),n=u?e.create("point",[p[2]()*p[2]()+p[1]()*p[1](),p[2]()-p[1]()*p[0]()+p[2](),-p[1]()-p[2]()*p[0]()-p[1]()],d):e.create("point",[function(){return.5*(p[2]()*p[2]()+p[1]()*p[1]())},function(){return.5*(p[2]()-p[1]()*p[0]()+p[2]())},function(){return.5*(-p[1]()-p[2]()*p[0]()-p[1]())}],d),d=h.copyAttributes(r,e.options,"line","point2"),a=u?e.create("point",[p[2]()*p[2]()+p[1]()*p[1](),-p[1]()*p[0]()+p[2](),-p[2]()*p[0]()-p[1]()],d):e.create("point",[function(){return p[2]()*p[2]()+p[1]()*p[1]()},function(){return-p[1]()*p[0]()+p[2]()},function(){return-p[2]()*p[0]()-p[1]()}],d),n.prepareUpdate().update(),a.prepareUpdate().update(),d=h.copyAttributes(r,e.options,"line"),(o=new t.Line(e,n,a,d)).isDraggable=u,o.setParents([n,a])}else if(1===i.length&&h.isFunction(i[0])&&2===i[0]().length&&h.isPoint(i[0]()[0])&&h.isPoint(i[0]()[1]))s=i[0](),d=h.copyAttributes(r,e.options,"line"),(o=new t.Line(e,s[0],s[1],d)).constrained=!0,o.funps=i[0],o.setParents(s);else{if(!(1===i.length&&h.isFunction(i[0])&&3===i[0]().length&&h.isNumber(i[0]()[0])&&h.isNumber(i[0]()[1])&&h.isNumber(i[0]()[2])))throw new Error("JSXGraph: Can't create line with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]], [a,b,c]");s=i[0],d=h.copyAttributes(r,e.options,"line","point1"),n=e.create("point",[function(){var t=s();return[.5*(t[2]*t[2]+t[1]*t[1]),.5*(t[2]-t[1]*t[0]+t[2]),.5*(-t[1]-t[2]*t[0]-t[1])]}],d),d=h.copyAttributes(r,e.options,"line","point2"),a=e.create("point",[function(){var t=s();return[t[2]*t[2]+t[1]*t[1],-t[1]*t[0]+t[2],-t[2]*t[0]-t[1]]}],d),d=h.copyAttributes(r,e.options,"line"),(o=new t.Line(e,n,a,d)).constrained=!0,o.funps=i[0],o.setParents([n,a])}return o},t.registerElement("line",t.createLine),t.createSegment=function(t,e,i){var r,s;if(i.straightFirst=!1,i.straightLast=!1,s=h.copyAttributes(i,t.options,"segment"),r=t.create("line",e.slice(0,2),s),3===e.length){if(r.hasFixedLength=!0,h.isNumber(e[2]))r.fixedLength=function(){return e[2]};else{if(!h.isFunction(e[2]))throw new Error("JSXGraph: Can't create segment with third parent type '"+typeof e[2]+"'.\nPossible third parent types: number or function");r.fixedLength=e[2]}r.getParents=function(){return this.parents.concat(this.fixedLength())},r.fixedLengthOldCoords=[],r.fixedLengthOldCoords[0]=new n(o.COORDS_BY_USER,r.point1.coords.usrCoords.slice(1,3),t),r.fixedLengthOldCoords[1]=new n(o.COORDS_BY_USER,r.point2.coords.usrCoords.slice(1,3),t)}return r.elType="segment",r},t.registerElement("segment",t.createSegment),t.createArrow=function(t,e,i){var r,s;return i.straightFirst=!1,i.straightLast=!1,s=h.copyAttributes(i,t.options,"arrow"),(r=t.create("line",e,s)).type=o.OBJECT_TYPE_VECTOR,r.elType="arrow",r},t.registerElement("arrow",t.createArrow),t.createAxis=function(t,e,i){var r,s,n,a,l;if(!h.isArray(e[0])&&!h.isPoint(e[0])||!h.isArray(e[1])&&!h.isPoint(e[1]))throw new Error("JSXGraph: Can't create axis with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]");for(a in r=h.copyAttributes(i,t.options,"axis"),(n=t.create("line",e,r)).type=o.OBJECT_TYPE_AXIS,n.isDraggable=!1,n.point1.isDraggable=!1,n.point2.isDraggable=!1,n.ancestors)n.ancestors.hasOwnProperty(a)&&(n.ancestors[a].type=o.OBJECT_TYPE_AXISPOINT);return s=h.copyAttributes(i,t.options,"axis","ticks"),l=h.exists(s.ticksdistance)?s.ticksdistance:h.isArray(s.ticks)?s.ticks:1,n.defaultTicks=t.create("ticks",[n,l],s),n.defaultTicks.dump=!1,n.elType="axis",n.subs={ticks:n.defaultTicks},n.inherits.push(n.defaultTicks),n},t.registerElement("axis",t.createAxis),t.createTangent=function(t,i,s){var n,a,l,c,d;if(1===i.length)n=i[0],a=n.slideObject;else{if(2!==i.length)throw new Error("JSXGraph: Can't create tangent with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]");if(h.isPoint(i[0]))n=i[0],a=i[1];else{if(!h.isPoint(i[1]))throw new Error("JSXGraph: Can't create tangent with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [glider], [point,line|curve|circle|conic]");a=i[0],n=i[1]}}if(a.elementClass===o.OBJECT_CLASS_LINE?(d=t.create("line",[a.point1,a.point2],s)).glider=n:a.elementClass===o.OBJECT_CLASS_CURVE&&a.type!==o.OBJECT_TYPE_CONIC?"plot"!==h.evaluate(a.visProp.curvetype)?(d=t.create("line",[function(){var t=a.X,e=a.Y;return-n.X()*r.D(e)(n.position)+n.Y()*r.D(t)(n.position)},function(){return r.D(a.Y)(n.position)},function(){return-r.D(a.X)(n.position)}],s),n.addChild(d),d.glider=n):(d=t.create("line",[function(){var t,e,i,r,s,o,h,l,c,d,u=Math.floor(n.position);if(1===a.bezierDegree)u===a.numberPoints-1&&u--;else{if(3!==a.bezierDegree)return 0;u=3*Math.floor(n.position*(a.numberPoints-1)/3),i=(n.position*(a.numberPoints-1)-u)/3,u>=a.numberPoints-1&&(u=a.numberPoints-4,i=1)}return u<0?1:(1===a.bezierDegree?(t=a.points[u].usrCoords,e=a.points[u+1].usrCoords):(r=a.points[u].usrCoords,s=a.points[u+1].usrCoords,o=a.points[u+2].usrCoords,h=a.points[u+3].usrCoords,l=(1-i)*(1-i)*(s[1]-r[1])+2*(1-i)*i*(o[1]-s[1])+i*i*(h[1]-o[1]),c=(1-i)*(1-i)*(s[2]-r[2])+2*(1-i)*i*(o[2]-s[2])+i*i*(h[2]-o[2]),l/=d=Math.sqrt(l*l+c*c),c/=d,e=[1,(t=n.coords.usrCoords)[1]+l,t[2]+c]),t[2]*e[1]-t[1]*e[2])},function(){var t,e,i,r,s,o,h,l,c,d,u=Math.floor(n.position);if(1===a.bezierDegree)u===a.numberPoints-1&&u--;else{if(3!==a.bezierDegree)return 0;u=3*Math.floor(n.position*(a.numberPoints-1)/3),i=(n.position*(a.numberPoints-1)-u)/3,u>=a.numberPoints-1&&(u=a.numberPoints-4,i=1)}return u<0?0:(1===a.bezierDegree?(t=a.points[u].usrCoords,e=a.points[u+1].usrCoords):(r=a.points[u].usrCoords,s=a.points[u+1].usrCoords,o=a.points[u+2].usrCoords,h=a.points[u+3].usrCoords,l=(1-i)*(1-i)*(s[1]-r[1])+2*(1-i)*i*(o[1]-s[1])+i*i*(h[1]-o[1]),c=(1-i)*(1-i)*(s[2]-r[2])+2*(1-i)*i*(o[2]-s[2])+i*i*(h[2]-o[2]),l/=d=Math.sqrt(l*l+c*c),c/=d,e=[1,(t=n.coords.usrCoords)[1]+l,t[2]+c]),e[2]-t[2])},function(){var t,e,i,r,s,o,h,l,c,d,u=Math.floor(n.position);if(1===a.bezierDegree)u===a.numberPoints-1&&u--;else{if(3!==a.bezierDegree)return 0;u=3*Math.floor(n.position*(a.numberPoints-1)/3),i=(n.position*(a.numberPoints-1)-u)/3,u>=a.numberPoints-1&&(u=a.numberPoints-4,i=1)}return u<0?0:(1===a.bezierDegree?(t=a.points[u].usrCoords,e=a.points[u+1].usrCoords):(r=a.points[u].usrCoords,s=a.points[u+1].usrCoords,o=a.points[u+2].usrCoords,h=a.points[u+3].usrCoords,l=(1-i)*(1-i)*(s[1]-r[1])+2*(1-i)*i*(o[1]-s[1])+i*i*(h[1]-o[1]),c=(1-i)*(1-i)*(s[2]-r[2])+2*(1-i)*i*(o[2]-s[2])+i*i*(h[2]-o[2]),l/=d=Math.sqrt(l*l+c*c),c/=d,e=[1,(t=n.coords.usrCoords)[1]+l,t[2]+c]),t[1]-e[1])}],s),n.addChild(d),d.glider=n):a.type===o.OBJECT_TYPE_TURTLE?(d=t.create("line",[function(){var t=Math.floor(n.position);for(l=0;l<a.objects.length;l++)if((c=a.objects[l]).type===o.OBJECT_TYPE_CURVE){if(t<c.numberPoints)break;t-=c.numberPoints}return t===c.numberPoints-1&&t--,t<0?1:c.Y(t)*c.X(t+1)-c.X(t)*c.Y(t+1)},function(){var t=Math.floor(n.position);for(l=0;l<a.objects.length;l++)if((c=a.objects[l]).type===o.OBJECT_TYPE_CURVE){if(t<c.numberPoints)break;t-=c.numberPoints}return t===c.numberPoints-1&&t--,t<0?0:c.Y(t+1)-c.Y(t)},function(){var t=Math.floor(n.position);for(l=0;l<a.objects.length;l++)if((c=a.objects[l]).type===o.OBJECT_TYPE_CURVE){if(t<c.numberPoints)break;t-=c.numberPoints}return t===c.numberPoints-1&&t--,t<0?0:c.X(t)-c.X(t+1)}],s),n.addChild(d),d.glider=n):a.elementClass!==o.OBJECT_CLASS_CIRCLE&&a.type!==o.OBJECT_TYPE_CONIC||(d=t.create("line",[function(){return e.matVecMult(a.quadraticform,n.coords.usrCoords)[0]},function(){return e.matVecMult(a.quadraticform,n.coords.usrCoords)[1]},function(){return e.matVecMult(a.quadraticform,n.coords.usrCoords)[2]}],s),n.addChild(d),d.glider=n),!h.exists(d))throw new Error("JSXGraph: Couldn't create tangent with the given parents.");return d.elType="tangent",d.type=o.OBJECT_TYPE_TANGENT,d.setParents(i),d},t.createRadicalAxis=function(t,i,r){var s,n,a;if(2!==i.length||i[0].elementClass!==o.OBJECT_CLASS_CIRCLE||i[1].elementClass!==o.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create 'radical axis' with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent type: [circle,circle]");return n=t.select(i[0]),a=t.select(i[1]),(s=t.create("line",[function(){var t=n.stdform,i=a.stdform;return e.matVecMult(e.transpose([t.slice(0,3),i.slice(0,3)]),[i[3],-t[3]])}],r)).elType="radicalaxis",s.setParents([n.id,a.id]),n.addChild(s),a.addChild(s),s},t.createPolarLine=function(t,e,i){var r,s,n,a,l,c,d;if(e.length>1&&(a=e[0].type===o.OBJECT_TYPE_CONIC||e[0].elementClass===o.OBJECT_CLASS_CIRCLE,l=e[1].type===o.OBJECT_TYPE_CONIC||e[1].elementClass===o.OBJECT_CLASS_CIRCLE,c=h.isPoint(e[0]),d=h.isPoint(e[1])),2!==e.length||!(a&&d||c&&l))throw new Error("JSXGraph: Can't create 'polar line' with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent type: [conic|circle,point], [point,conic|circle]");return d?(s=t.select(e[0]),n=t.select(e[1])):(s=t.select(e[1]),n=t.select(e[0])),(r=t.create("tangent",[s,n],i)).elType="polarline",r},t.registerElement("tangent",t.createTangent),t.registerElement("polar",t.createTangent),t.registerElement("radicalaxis",t.createRadicalAxis),t.registerElement("polarline",t.createPolarLine),{Line:t.Line,createLine:t.createLine,createTangent:t.createTangent,createPolar:t.createTangent,createSegment:t.createSegment,createAxis:t.createAxis,createArrow:t.createArrow,createRadicalAxis:t.createRadicalAxis,createPolarLine:t.createPolarLine}})),define("base/group",["jxg","base/constants","math/math","math/geometry","utils/type"],(function(t,e,i,r,s){"use strict";return t.Group=function(t,i,r,o,n){var a,h,l,c;for(this.board=t,this.objects={},a=this.board.numObjects,this.board.numObjects+=1,""!==i&&s.exists(i)?this.id=i:this.id=this.board.id+"Group"+a,this.board.groups[this.id]=this,this.type=e.OBJECT_TYPE_POINT,this.elementClass=e.OBJECT_CLASS_POINT,""!==r&&s.exists(r)?this.name=r:this.name="group_"+this.board.generateName(this),delete this.type,this.coords={},this.needsRegularUpdate=n.needsregularupdate,this.rotationCenter="centroid",this.scaleCenter=null,this.rotationPoints=[],this.translationPoints=[],this.scalePoints=[],this.scaleDirections={},this.parents=[],h=s.isArray(o)?o:Array.prototype.slice.call(arguments,3),l=0;l<h.length;l++)c=this.board.select(h[l]),!s.evaluate(c.visProp.fixed)&&s.exists(c.coords)&&this.addPoint(c);this.methodMap={ungroup:"ungroup",add:"addPoint",addPoint:"addPoint",addPoints:"addPoints",addGroup:"addGroup",remove:"removePoint",removePoint:"removePoint",setAttribute:"setAttribute",setProperty:"setAttribute"}},t.extend(t.Group.prototype,{ungroup:function(){var t,e,i;for(t in this.objects)this.objects.hasOwnProperty(t)&&(e=this.objects[t].point,s.isArray(e.groups)&&(i=s.indexOf(e.groups,this.id))>=0&&delete e.groups[i]);return this.objects={},this},addParents:function(t){var e,i,r;for(i=(r=s.isArray(t)?t:arguments).length,e=0;e<i;++e)s.isId(this.board,r[e])?this.parents.push(r[e]):s.exists(r[e].id)&&this.parents.push(r[e].id);this.parents=s.uniqueArray(this.parents)},setParents:function(t){return this.parents=[],this.addParents(t),this},getParents:function(){return s.isArray(this.parents)?this.parents:[]},_updateCoordsCache:function(t){var e;""!==t&&s.exists(this.objects[t])&&(e=this.objects[t].point,this.coords[e.id]={usrCoords:e.coords.usrCoords.slice(0)})},update:function(){var t,e,o,n,a,h,l,c,d,u,p=null;if(!this.needsUpdate)return this;if("nothing"===(t=this._update_find_drag_type()).action)return this._updateCoordsCache(t.id),this;if(p=this.objects[t.id].point,"translation"===t.action)d=[p.coords.usrCoords[1]-this.coords[t.id].usrCoords[1],p.coords.usrCoords[2]-this.coords[t.id].usrCoords[2]];else if("rotation"===t.action||"scaling"===t.action){if(o="rotation"===t.action?"rotationCenter":"scaleCenter",s.isPoint(this[o]))u=this[o].coords.usrCoords.slice(1);else if("centroid"===this[o])u=this._update_centroid_center();else if(s.isArray(this[o]))u=this[o];else{if(!s.isFunction(this[o]))return this;u=this[o]()}if("rotation"===t.action)c=r.rad(this.coords[t.id].usrCoords.slice(1),u,this.objects[t.id].point),(d=this.board.create("transform",[c,u[0],u[1]],{type:"rotate"})).update();else{if("scaling"!==t.action)return this;if(a=r.distance(this.coords[t.id].usrCoords.slice(1),u),Math.abs(a)<i.eps)return this;a=r.distance(p.coords.usrCoords.slice(1),u)/a,h=this.scaleDirections[t.id].indexOf("x")>=0?a:1,l=this.scaleDirections[t.id].indexOf("y")>=0?a:1,(d=this.board.create("transform",[1,0,0,u[0]*(1-h),h,0,u[1]*(1-l),0,l],{type:"generic"})).update()}}for(e in this._update_apply_transformation(t,d),this.needsUpdate=!1,this.objects)if(this.objects.hasOwnProperty(e))for(n in this.objects[e].descendants)this.objects[e].descendants.hasOwnProperty(n)&&(this.objects[e].descendants.needsUpdate=this.objects[e].descendants.needsRegularUpdate||this.board.needsFullUpdate);for(e in this.board.updateElements(t),this.objects)this.objects.hasOwnProperty(e)&&this._updateCoordsCache(e);return this},_update_find_drag_type:function(){var t,r,o,n="nothing",a=[];for(t in this.objects)this.objects.hasOwnProperty(t)&&(r=this.objects[t].point).coords.distance(e.COORDS_BY_USER,this.coords[t])>i.eps&&a.push(r.id);return 0===a.length?{action:n,id:"",changed:a}:(o=a[0],r=this.objects[o].point,a.length>1?n="translation":s.isInArray(this.rotationPoints,r)&&s.exists(this.rotationCenter)?n="rotation":s.isInArray(this.scalePoints,r)&&s.exists(this.scaleCenter)?n="scaling":s.isInArray(this.translationPoints,r)&&(n="translation"),{action:n,id:o,changed:a})},_update_centroid_center:function(){var t,e,i;for(i in t=[0,0],e=0,this.coords)this.coords.hasOwnProperty(i)&&(t[0]+=this.coords[i].usrCoords[1],t[1]+=this.coords[i].usrCoords[2],++e);return e>0&&(t[0]/=e,t[1]/=e),t},_update_apply_transformation:function(t,r){var o,n;for(o in this.objects)this.objects.hasOwnProperty(o)&&(s.exists(this.board.objects[o])?(n=this.objects[o].point).id!==t.id?"translation"===t.action?s.isInArray(t.changed,n.id)||n.coords.setCoordinates(e.COORDS_BY_USER,[this.coords[o].usrCoords[1]+r[0],this.coords[o].usrCoords[2]+r[1]]):"rotation"!==t.action&&"scaling"!==t.action||r.applyOnce([n]):"rotation"!==t.action&&"scaling"!==t.action||n.coords.setCoordinates(e.COORDS_BY_USER,i.matVecMult(r.matrix,this.coords[n.id].usrCoords)):delete this.objects[o])},addPoint:function(t){return this.objects[t.id]={point:this.board.select(t)},this._updateCoordsCache(t.id),this.translationPoints.push(t),t.groups.push(this.id),t.groups=s.uniqueArray(t.groups),this},addPoints:function(t){var e;for(e=0;e<t.length;e++)this.addPoint(t[e]);return this},addGroup:function(t){var e;for(e in t.objects)t.objects.hasOwnProperty(e)&&this.addPoint(t.objects[e].point);return this},removePoint:function(t){return delete this.objects[t.id],this},setRotationCenter:function(t){return this.rotationCenter=t,this},setRotationPoints:function(t){return this._setActionPoints("rotation",t)},addRotationPoint:function(t){return this._addActionPoint("rotation",t)},removeRotationPoint:function(t){return this._removeActionPoint("rotation",t)},setTranslationPoints:function(t){return this._setActionPoints("translation",t)},addTranslationPoint:function(t){return this._addActionPoint("translation",t)},removeTranslationPoint:function(t){return this._removeActionPoint("translation",t)},setScaleCenter:function(t){return this.scaleCenter=t,this},setScalePoints:function(t,e){var i,r,o;for(o=(i=s.isArray(t)?t:arguments).length,r=0;r<o;++r)this.scaleDirections[this.board.select(i[r]).id]=e||"xy";return this._setActionPoints("scale",t)},addScalePoint:function(t,e){return this._addActionPoint("scale",t),this.scaleDirections[this.board.select(t).id]=e||"xy",this},removeScalePoint:function(t){return this._removeActionPoint("scale",t)},_setActionPoints:function(t,e){var i,r,o;for(o=(i=s.isArray(e)?e:arguments).length,this[t+"Points"]=[],r=0;r<o;++r)this._addActionPoint(t,i[r]);return this},_addActionPoint:function(t,e){return this[t+"Points"].push(this.board.select(e)),this},_removeActionPoint:function(t,e){var i=this[t+"Points"].indexOf(this.board.select(e));return i>-1&&this[t+"Points"].splice(i,1),this},setProperty:function(){t.deprecated("Group.setProperty","Group.setAttribute()"),this.setAttribute.apply(this,arguments)},setAttribute:function(){var t;for(t in this.objects)this.objects.hasOwnProperty(t)&&this.objects[t].point.setAttribute.apply(this.objects[t].point,arguments);return this}}),t.createGroup=function(e,i,r){var o=s.copyAttributes(r,e.options,"group"),n=new t.Group(e,o.id,o.name,i,o);return n.elType="group",n.setParents(i),n},t.registerElement("group",t.createGroup),{Group:t.Group,createGroup:t.createGroup}})),define("element/conic",["jxg","base/constants","base/coords","math/math","math/numerics","math/geometry","utils/type"],(function(t,e,i,r,s,o,n){"use strict";return t.createEllipse=function(t,r,s){var o,a,h,l,c,d,u,p=[],f=n.copyAttributes(s,t.options,"conic","foci"),m=n.copyAttributes(s,t.options,"conic","center"),g=n.copyAttributes(s,t.options,"conic");for(d=0;d<2;d++)if(r[d].length>1)p[d]=t.create("point",r[d],f);else if(n.isPoint(r[d]))p[d]=t.select(r[d]);else if(n.isFunction(r[d])&&n.isPoint(r[d]()))p[d]=r[d]();else{if(!n.isString(r[d]))throw new Error("JSXGraph: Can't create Ellipse with parent types '"+typeof r[0]+"' and '"+typeof r[1]+"'.\nPossible parent types: [point,point,point], [point,point,number|function]");p[d]=t.select(r[d])}if(n.isNumber(r[2]))c=n.createFunction(r[2],t);else if(n.isFunction(r[2])&&n.isNumber(r[2]()))c=r[2];else{if(n.isPoint(r[2]))l=t.select(r[2]);else if(r[2].length>1)l=t.create("point",r[2],f);else if(n.isFunction(r[2])&&n.isPoint(r[2]()))l=r[2]();else{if(!n.isString(r[2]))throw new Error("JSXGraph: Can't create Ellipse with parent types '"+typeof r[0]+"' and '"+typeof r[1]+"' and '"+typeof r[2]+"'.\nPossible parent types: [point,point,point], [point,point,number|function]");l=t.select(r[2])}c=function(){return l.Dist(p[0])+l.Dist(p[1])}}for(n.exists(r[4])||(r[4]=2*Math.PI),n.exists(r[3])||(r[3]=0),h=t.create("point",[function(){return.5*(p[0].X()+p[1].X())},function(){return.5*(p[0].Y()+p[1].Y())}],m),(a=t.create("curve",[function(t){return 0},function(t){return 0},r[3],r[4]],g)).majorAxis=c,u=a.hasPoint,o=function(t,e){var i,r,s,o,n,h,l,d,u;e||(r=(i=c())*i,s=p[0].X(),o=p[0].Y(),l=s-(n=p[1].X()),d=o-(h=p[1].Y()),u=(r-s*s-o*o+n*n+h*h)/(2*i),a.quadraticform=[[u*u-n*n-h*h,u*l/i+n,u*d/i+h],[u*l/i+n,l*l/r-1,l*d/r],[u*d/i+h,l*d/r,d*d/r-1]])},a.X=function(t,e){var i=c(),r=p[1].Dist(p[0]),s=.5*(r*r-i*i)/(r*Math.cos(t)-i),n=Math.atan2(p[1].Y()-p[0].Y(),p[1].X()-p[0].X());return e||o(0,e),p[0].X()+Math.cos(n+t)*s},a.Y=function(t,e){var i=c(),r=p[1].Dist(p[0]),s=.5*(r*r-i*i)/(r*Math.cos(t)-i),o=Math.atan2(p[1].Y()-p[0].Y(),p[1].X()-p[0].X());return p[0].Y()+Math.sin(o+t)*s},a.midpoint=a.center=h,a.type=e.OBJECT_TYPE_CONIC,a.subs={center:a.center},a.inherits.push(a.center,p[0],p[1]),n.isPoint(l)&&a.inherits.push(l),a.hasPoint=function(t,r){var s,o,a,h;return n.evaluate(this.visProp.hasinnerpoints)?(s=p[0].coords,o=p[1].coords,a=this.majorAxis(),(h=new i(e.COORDS_BY_SCREEN,[t,r],this.board)).distance(e.COORDS_BY_USER,s)+h.distance(e.COORDS_BY_USER,o)<=a):u.apply(this,arguments)},h.addChild(a),d=0;d<2;d++)n.isPoint(p[d])&&p[d].addChild(a);return n.isPoint(l)&&l.addChild(a),a.setParents(r),a},t.createHyperbola=function(t,i,r){var s,o,a,h,l,c,d=[],u=n.copyAttributes(r,t.options,"conic","foci"),p=n.copyAttributes(r,t.options,"conic","center"),f=n.copyAttributes(r,t.options,"conic");for(c=0;c<2;c++)if(i[c].length>1)d[c]=t.create("point",i[c],u);else if(n.isPoint(i[c]))d[c]=t.select(i[c]);else if(n.isFunction(i[c])&&n.isPoint(i[c]()))d[c]=i[c]();else{if(!n.isString(i[c]))throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [point,point,point], [point,point,number|function]");d[c]=t.select(i[c])}if(n.isNumber(i[2]))l=n.createFunction(i[2],t);else if(n.isFunction(i[2])&&n.isNumber(i[2]()))l=i[2];else{if(n.isPoint(i[2]))h=t.select(i[2]);else if(i[2].length>1)h=t.create("point",i[2],u);else if(n.isFunction(i[2])&&n.isPoint(i[2]()))h=i[2]();else{if(!n.isString(i[2]))throw new Error("JSXGraph: Can't create Hyperbola with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"' and '"+typeof i[2]+"'.\nPossible parent types: [point,point,point], [point,point,number|function]");h=t.select(i[2])}l=function(){return h.Dist(d[0])-h.Dist(d[1])}}for(n.exists(i[4])||(i[4]=1.0001*Math.PI),n.exists(i[3])||(i[3]=-1.0001*Math.PI),a=t.create("point",[function(){return.5*(d[0].X()+d[1].X())},function(){return.5*(d[0].Y()+d[1].Y())}],p),(o=t.create("curve",[function(t){return 0},function(t){return 0},i[3],i[4]],f)).majorAxis=l,s=function(t,e){var i,r,s,n,a,h,c,u,p;e||(r=(i=l())*i,s=d[0].X(),n=d[0].Y(),c=s-(a=d[1].X()),u=n-(h=d[1].Y()),p=(r-s*s-n*n+a*a+h*h)/(2*i),o.quadraticform=[[p*p-a*a-h*h,p*c/i+a,p*u/i+h],[p*c/i+a,c*c/r-1,c*u/r],[p*u/i+h,c*u/r,u*u/r-1]])},o.X=function(t,e){var i=l(),r=d[1].Dist(d[0]),o=.5*(r*r-i*i)/(r*Math.cos(t)+i),n=Math.atan2(d[1].Y()-d[0].Y(),d[1].X()-d[0].X());return e||s(0,e),d[0].X()+Math.cos(n+t)*o},o.Y=function(t,e){var i=l(),r=d[1].Dist(d[0]),s=.5*(r*r-i*i)/(r*Math.cos(t)+i),o=Math.atan2(d[1].Y()-d[0].Y(),d[1].X()-d[0].X());return d[0].Y()+Math.sin(o+t)*s},o.midpoint=o.center=a,o.subs={center:o.center},o.inherits.push(o.center,d[0],d[1]),n.isPoint(h)&&o.inherits.push(h),o.type=e.OBJECT_TYPE_CONIC,a.addChild(o),c=0;c<2;c++)n.isPoint(d[c])&&d[c].addChild(o);return n.isPoint(h)&&h.addChild(o),o.setParents(i),o},t.createParabola=function(t,i,r){var s,a,h,l,c=i[0],d=i[1],u=n.copyAttributes(r,t.options,"conic","foci"),p=n.copyAttributes(r,t.options,"conic","center"),f=n.copyAttributes(r,t.options,"conic");if(i[0].length>1)c=t.create("point",i[0],u);else if(n.isPoint(i[0]))c=t.select(i[0]);else if(n.isFunction(i[0])&&n.isPoint(i[0]()))c=i[0]();else{if(!n.isString(i[0]))throw new Error("JSXGraph: Can't create Parabola with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [point,line]");c=t.select(i[0])}return n.isArray(d)&&2===d.length&&(l=n.copyAttributes(r,t.options,"conic","line"),d=t.create("line",d,l)),n.exists(i[3])||(i[3]=2*Math.PI),n.exists(i[2])||(i[2]=0),h=t.create("point",[function(){return o.projectPointToLine(c,d,t).usrCoords}],p),(a=t.create("curve",[function(t){return 0},function(t){return 0},i[2],i[3]],f)).midpoint=a.center=h,a.subs={center:a.center},a.inherits.push(a.center),s=function(t,e){var i,r,s,o,n,h;e||(i=d.stdform[1],r=d.stdform[2],s=d.stdform[0],o=i*i+r*r,n=c.X(),h=c.Y(),a.quadraticform=[[s*s-o*(n*n+h*h),s*i+o*n,s*r+o*h],[s*i+o*n,-r*r,i*r],[s*r+o*h,i*r,-i*i]])},a.X=function(t,e){var i,r=d.getAngle(),n=o.distPointLine(c.coords.usrCoords,d.stdform),a=d.point1.coords.usrCoords,h=d.point2.coords.usrCoords,l=c.coords.usrCoords;return 0===a[0]?a=[1,h[1]+d.stdform[2],h[2]-d.stdform[1]]:0===h[0]&&(h=[1,a[1]+d.stdform[2],a[2]-d.stdform[1]]),i=((h[1]-a[1])*(l[2]-a[2])-(h[2]-a[2])*(l[1]-a[1])>=0?1:-1)*n/(1-Math.sin(t)),e||s(0,e),c.X()+Math.cos(t+r)*i},a.Y=function(t,e){var i,r=d.getAngle(),s=o.distPointLine(c.coords.usrCoords,d.stdform),n=d.point1.coords.usrCoords,a=d.point2.coords.usrCoords,h=c.coords.usrCoords;return 0===n[0]?n=[1,a[1]+d.stdform[2],a[2]-d.stdform[1]]:0===a[0]&&(a=[1,n[1]+d.stdform[2],n[2]-d.stdform[1]]),i=((a[1]-n[1])*(h[2]-n[2])-(a[2]-n[2])*(h[1]-n[1])>=0?1:-1)*s/(1-Math.sin(t)),c.Y()+Math.sin(t+r)*i},a.type=e.OBJECT_TYPE_CONIC,h.addChild(a),n.isPoint(c)&&(c.addChild(a),a.inherits.push(c)),d.addChild(a),a.setParents(i),a},t.createConic=function(t,i,o){var a,h,l,c,d,u,p,f,m,g,b,v,y,C,_=[[1,0,0],[0,1,0],[0,0,1]],P=[[1,0,0],[0,1,0],[0,0,1]],E=[],S=[],x=n.copyAttributes(o,t.options,"conic","point"),O=n.copyAttributes(o,t.options,"conic","center"),w=n.copyAttributes(o,t.options,"conic");if(5===i.length)C=!0;else{if(6!==i.length)throw new Error("JSXGraph: Can't create generic Conic with "+i.length+" parameters.");C=!1}if(C)for(v=0;v<5;v++)if(i[v].length>1)E[v]=t.create("point",i[v],x);else if(n.isPoint(i[v]))E[v]=t.select(i[v]);else if(n.isFunction(i[v])&&n.isPoint(i[v]()))E[v]=i[v]();else{if(!n.isString(i[v]))throw new Error("JSXGraph: Can't create Conic section with parent types '"+typeof i[v]+"'.\nPossible parent types: [point,point,point,point,point], [a00,a11,a22,a01,a02,a12]");E[v]=t.select(i[v])}else(y=[[0,0,0],[0,0,0],[0,0,0]])[0][0]=n.isFunction(i[2])?function(){return i[2]()}:function(){return i[2]},y[0][1]=n.isFunction(i[4])?function(){return i[4]()}:function(){return i[4]},y[0][2]=n.isFunction(i[5])?function(){return i[5]()}:function(){return i[5]},y[1][1]=n.isFunction(i[0])?function(){return i[0]()}:function(){return i[0]},y[1][2]=n.isFunction(i[3])?function(){return i[3]()}:function(){return i[3]},y[2][2]=n.isFunction(i[1])?function(){return i[1]()}:function(){return i[1]};if(d=function(t){var e,i;for(e=0;e<3;e++)for(i=e;i<3;i++)t[e][i]+=t[i][e];for(e=0;e<3;e++)for(i=0;i<e;i++)t[e][i]=t[i][e];return t},c=function(t,e){var i,r,s=[[0,0,0],[0,0,0],[0,0,0]];for(i=0;i<3;i++)for(r=0;r<3;r++)s[i][r]=t[i]*e[r];return d(s)},l=function(t,e,i){var s,o,n,a,h,l=[[0,0,0],[0,0,0],[0,0,0]];for(h=r.matVecMult(e,i),n=r.innerProduct(i,h),h=r.matVecMult(t,i),a=r.innerProduct(i,h),s=0;s<3;s++)for(o=0;o<3;o++)l[s][o]=n*t[s][o]-a*e[s][o];return l},h=t.create("curve",[function(t){return 0},function(t){return 0},0,2*Math.PI],w),a=function(t,e){var i,o,a,d;if(!e){if(C){for(i=0;i<5;i++)S[i]=E[i].coords.usrCoords;g=c(r.crossProduct(S[0],S[1]),r.crossProduct(S[2],S[3])),b=c(r.crossProduct(S[0],S[2]),r.crossProduct(S[1],S[3])),P=l(g,b,S[4])}else for(i=0;i<3;i++)for(o=i;o<3;o++)P[i][o]=y[i][o](),o>i&&(P[o][i]=P[i][o]);for(h.quadraticform=P,(u=s.Jacobi(P))[0][0][0]<0&&(u[0][0][0]*=-1,u[0][1][1]*=-1,u[0][2][2]*=-1),i=0;i<3;i++){for(a=0,o=0;o<3;o++)a+=u[1][o][i]*u[1][o][i];a=Math.sqrt(a)}_=u[1],m=Math.sqrt(Math.abs(u[0][0][0])),p=Math.sqrt(Math.abs(u[0][1][1])),f=Math.sqrt(Math.abs(u[0][2][2]))}return u[0][1][1]<=0&&u[0][2][2]<=0?d=r.matVecMult(_,[1/m,Math.cos(t)/p,Math.sin(t)/f]):u[0][1][1]<=0&&u[0][2][2]>0?d=r.matVecMult(_,[Math.cos(t)/m,1/p,Math.sin(t)/f]):u[0][2][2]<0&&(d=r.matVecMult(_,[Math.sin(t)/m,Math.cos(t)/p,1/f])),n.exists(d)?(d[1]/=d[0],d[2]/=d[0],d[0]=1):d=[1,NaN,NaN],d},h.X=function(t,e){return a(t,e)[1]},h.Y=function(t,e){return a(t,e)[2]},h.midpoint=t.create("point",[function(){var t=h.quadraticform;return[t[1][1]*t[2][2]-t[1][2]*t[1][2],t[1][2]*t[0][2]-t[2][2]*t[0][1],t[0][1]*t[1][2]-t[1][1]*t[0][2]]}],O),h.type=e.OBJECT_TYPE_CONIC,h.center=h.midpoint,h.subs={center:h.center},h.inherits.push(h.center),h.inherits=h.inherits.concat(E),C){for(v=0;v<5;v++)n.isPoint(E[v])&&E[v].addChild(h);h.setParents(i)}return h.addChild(h.center),h},t.registerElement("ellipse",t.createEllipse),t.registerElement("hyperbola",t.createHyperbola),t.registerElement("parabola",t.createParabola),t.registerElement("conic",t.createConic),{createEllipse:t.createEllipse,createHyperbola:t.createHyperbola,createParabola:t.createParabola,createConic:t.createConic}})),define("base/circle",["jxg","base/element","base/coords","base/constants","element/conic","parser/geonext","utils/type"],(function(t,e,i,r,s,o,n){"use strict";return t.Circle=function(t,e,i,s,o){this.constructor(t,o,r.OBJECT_TYPE_CIRCLE,r.OBJECT_CLASS_CIRCLE),this.method=e,this.midpoint=this.board.select(i),this.center=this.board.select(i),this.point2=null,this.radius=0,this.line=null,this.circle=null,this.points=[],"twoPoints"===e?(this.point2=t.select(s),this.radius=this.Radius()):"pointRadius"===e?(this.gxtterm=s,this.updateRadius=n.createFunction(s,this.board,null,!0),this.updateRadius()):"pointLine"===e?(this.line=t.select(s),this.radius=this.line.point1.coords.distance(r.COORDS_BY_USER,this.line.point2.coords)):"pointCircle"===e&&(this.circle=t.select(s),this.radius=this.circle.Radius()),this.id=this.board.setId(this,"C"),this.board.renderer.drawEllipse(this),this.board.finalizeAdding(this),this.createGradient(),this.elType="circle",this.createLabel(),n.exists(this.center._is_new)?(this.addChild(this.center),delete this.center._is_new):this.center.addChild(this),"pointRadius"===e?this.notifyParents(s):"pointLine"===e?this.line.addChild(this):"pointCircle"===e?this.circle.addChild(this):"twoPoints"===e&&(n.exists(this.point2._is_new)?(this.addChild(this.point2),delete this.point2._is_new):this.point2.addChild(this)),this.methodMap=n.deepCopy(this.methodMap,{setRadius:"setRadius",getRadius:"getRadius",Area:"Area",area:"Area",radius:"Radius",center:"center",line:"line",point2:"point2"})},t.Circle.prototype=new e,t.extend(t.Circle.prototype,{hasPoint:function(t,e){var s,o,a,h,l,c=this.center.coords.usrCoords,d=new i(r.COORDS_BY_SCREEN,[t,e],this.board),u=this.Radius();return n.isObject(n.evaluate(this.visProp.precision))?(o=this.board._inputDevice,s=n.evaluate(this.visProp.precision[o])):s=this.board.options.precision.hasPoint,a=c[1]-d.usrCoords[1],h=c[2]-d.usrCoords[2],l=Math.sqrt(a*a+h*h),s+=.5*n.evaluate(this.visProp.strokewidth),s/=Math.sqrt(this.board.unitX*this.board.unitY),n.evaluate(this.visProp.hasinnerpoints)?l<u+s:Math.abs(l-u)<s},generatePolynomial:function(t){var e=this.center.symbolic.x,i=this.center.symbolic.y,r=t.symbolic.x,s=t.symbolic.y,o=this.generateRadiusSquared();return""===o?[]:["(("+r+")-("+e+"))^2 + (("+s+")-("+i+"))^2 - ("+o+")"]},generateRadiusSquared:function(){var t,e,i,r,s="";return"twoPoints"===this.method?(t=this.center.symbolic.x,e=this.center.symbolic.y,s="(("+(i=this.point2.symbolic.x)+")-("+t+"))^2 + (("+(r=this.point2.symbolic.y)+")-("+e+"))^2"):"pointRadius"===this.method?n.isNumber(this.radius)&&(s=(this.radius*this.radius).toString()):"pointLine"===this.method?(i=this.line.point1.symbolic.x,r=this.line.point1.symbolic.y,s="(("+i+")-("+this.line.point2.symbolic.x+"))^2 + (("+r+")-("+this.line.point2.symbolic.y+"))^2"):"pointCircle"===this.method&&(s=this.circle.Radius()),s},update:function(){var t,e,s,o,a,h;if(this.needsUpdate)for(n.evaluate(this.visProp.trace)&&this.cloneToBackground(!0),"pointLine"===this.method?this.radius=this.line.point1.coords.distance(r.COORDS_BY_USER,this.line.point2.coords):"pointCircle"===this.method?this.radius=this.circle.Radius():"pointRadius"===this.method&&(this.radius=this.updateRadius()),this.updateStdform(),this.updateQuadraticform(),s=this.center.coords.usrCoords[0],t=this.center.coords.usrCoords[1]/s,e=this.center.coords.usrCoords[2]/s,s/=s,o=this.Radius(),a=.551915024494,this.numberPoints=13,this.dataX=[t+o,t+o,t+o*a,t,t-o*a,t-o,t-o,t-o,t-o*a,t,t+o*a,t+o,t+o],this.dataY=[e,e+o*a,e+o,e+o,e+o,e+o*a,e,e-o*a,e-o,e-o,e-o,e-o*a,e],this.bezierDegree=3,h=0;h<this.numberPoints;h++)this.points[h]=new i(r.COORDS_BY_USER,[this.dataX[h],this.dataY[h]],this.board);return this},updateQuadraticform:function(){var t=this.center,e=t.X(),i=t.Y(),r=this.Radius();this.quadraticform=[[e*e+i*i-r*r,-e,-i],[-e,1,0],[-i,0,1]]},updateStdform:function(){this.stdform[3]=.5,this.stdform[4]=this.Radius(),this.stdform[1]=-this.center.coords.usrCoords[1],this.stdform[2]=-this.center.coords.usrCoords[2],isFinite(this.stdform[4])||(this.stdform[0]=n.exists(this.point2)?-(this.stdform[1]*this.point2.coords.usrCoords[1]+this.stdform[2]*this.point2.coords.usrCoords[2]):0),this.normalize()},updateRenderer:function(){return this.needsUpdate?(this.visPropCalc.visible&&(this.isReal=!isNaN(this.center.coords.usrCoords[1]+this.center.coords.usrCoords[2]+this.Radius())&&this.center.isReal,this.isReal||this.updateVisibility(!1)),this.visPropCalc.visible&&this.board.renderer.updateEllipse(this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},notifyParents:function(t){n.isString(t)&&o.findDependencies(this,t,this.board)},setRadius:function(t){return this.updateRadius=n.createFunction(t,this.board,null,!0),this.board.update(),this},Radius:function(t){return n.exists(t)?(this.setRadius(t),this.Radius()):"twoPoints"===this.method?n.cmpArrays(this.point2.coords.usrCoords,[0,0,0])||n.cmpArrays(this.center.coords.usrCoords,[0,0,0])?NaN:this.center.Dist(this.point2):"pointLine"===this.method||"pointCircle"===this.method?this.radius:"pointRadius"===this.method?this.updateRadius():NaN},getRadius:function(){return t.deprecated("Circle.getRadius()","Circle.Radius()"),this.Radius()},getTextAnchor:function(){return this.center.coords},getLabelAnchor:function(){var t,e,s=this.Radius(),o=this.center.coords.usrCoords,a=.7071067811865476;switch(n.evaluate(this.visProp.label.position)){case"lft":t=o[1]-s,e=o[2];break;case"llft":t=o[1]-a*s,e=o[2]-a*s;break;case"rt":t=o[1]+s,e=o[2];break;case"lrt":t=o[1]+a*s,e=o[2]-a*s;break;case"urt":t=o[1]+a*s,e=o[2]+a*s;break;case"top":t=o[1],e=o[2]+s;break;case"bot":t=o[1],e=o[2]-s;break;default:t=o[1]-a*s,e=o[2]+a*s}return new i(r.COORDS_BY_USER,[t,e],this.board)},cloneToBackground:function(){var t,e=this.Radius(),i={id:this.id+"T"+this.numTraces,elementClass:r.OBJECT_CLASS_CIRCLE,center:{coords:this.center.coords},Radius:function(){return e},getRadius:function(){return e},board:this.board,visProp:n.deepCopy(this.visProp,this.visProp.traceattributes,!0)};return i.visProp.layer=this.board.options.layer.trace,this.numTraces++,n.clearVisPropOld(i),i.visPropCalc={visible:n.evaluate(i.visProp.visible)},t=this.board.renderer.enhancedRendering,this.board.renderer.enhancedRendering=!0,this.board.renderer.drawEllipse(i),this.board.renderer.enhancedRendering=t,this.traces[i.id]=i.rendNode,this},addTransform:function(t){var e,i=n.isArray(t)?t:[t],r=i.length;for(e=0;e<r;e++)this.center.transformations.push(i[e]),"twoPoints"===this.method&&this.point2.transformations.push(i[e]);return this},snapToGrid:function(){var t=n.evaluate(this.visProp.snaptogrid);return this.center.handleSnapToGrid(t,!0),"twoPoints"===this.method&&this.point2.handleSnapToGrid(t,!0),this},snapToPoints:function(){var t=n.evaluate(this.visProp.snaptopoints);return this.center.handleSnapToPoints(t),"twoPoints"===this.method&&this.point2.handleSnapToPoints(t),this},X:function(t){return this.Radius()*Math.cos(2*t*Math.PI)+this.center.coords.usrCoords[1]},Y:function(t){return this.Radius()*Math.sin(2*t*Math.PI)+this.center.coords.usrCoords[2]},Z:function(t){return 1},minX:function(){return 0},maxX:function(){return 1},Area:function(){var t=this.Radius();return t*t*Math.PI},bounds:function(){var t=this.center.coords.usrCoords,e=this.Radius();return[t[1]-e,t[2]+e,t[1]+e,t[2]-e]},getParents:function(){return 1===this.parents.length?this.parents.concat(this.radius):this.parents}}),t.createCircle=function(e,i,o){var a,h,l,c,d,u=["center","point2"];if(h=[],d=e.select(i[0]),n.isObject(d)&&d.elementClass===r.OBJECT_CLASS_CIRCLE&&n.isTransformationOrArray(i[1]))return c=n.copyAttributes(o,e.options,"circle"),(a=s.createEllipse(e,[d.center,d.center,function(){return 2*d.Radius()}],c)).addTransform(i[1]),a;for(l=0;l<i.length;l++)if(n.isPointType(e,i[l])){if(!1===(h=h.concat(n.providePoints(e,[i[l]],o,"circle",[u[l]])))[h.length-1])throw new Error("JSXGraph: Can't create circle from this type. Please provide a point type.")}else h.push(i[l]);if(c=n.copyAttributes(o,e.options,"circle"),2===h.length&&n.isPoint(h[0])&&n.isPoint(h[1]))a=new t.Circle(e,"twoPoints",h[0],h[1],c);else if((n.isNumber(h[0])||n.isFunction(h[0])||n.isString(h[0]))&&n.isPoint(h[1]))a=new t.Circle(e,"pointRadius",h[1],h[0],c);else if((n.isNumber(h[1])||n.isFunction(h[1])||n.isString(h[1]))&&n.isPoint(h[0]))a=new t.Circle(e,"pointRadius",h[0],h[1],c);else if(h[0].elementClass===r.OBJECT_CLASS_CIRCLE&&n.isPoint(h[1]))a=new t.Circle(e,"pointCircle",h[1],h[0],c);else if(h[1].elementClass===r.OBJECT_CLASS_CIRCLE&&n.isPoint(h[0]))a=new t.Circle(e,"pointCircle",h[0],h[1],c);else if(h[0].elementClass===r.OBJECT_CLASS_LINE&&n.isPoint(h[1]))a=new t.Circle(e,"pointLine",h[1],h[0],c);else if(h[1].elementClass===r.OBJECT_CLASS_LINE&&n.isPoint(h[0]))a=new t.Circle(e,"pointLine",h[0],h[1],c);else{if(!(3===i.length&&n.isPoint(h[0])&&n.isPoint(h[1])&&n.isPoint(h[2])))throw new Error("JSXGraph: Can't create circle with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [point,point], [point,number], [point,function], [point,circle], [point,point,point], [circle,transformation]");if(!t.elements.circumcircle)throw new Error("JSXGraph: Can't create circle with three points. Please include the circumcircle element (element/composition).");a=t.elements.circumcircle(e,h,c)}for(a.isDraggable=!0,a.setParents(h),a.elType="circle",l=0;l<h.length;l++)n.isPoint(h[l])&&a.inherits.push(h[l]);return a},t.registerElement("circle",t.createCircle),{Circle:t.Circle,createCircle:t.createCircle}})),define("base/polygon",["jxg","base/constants","base/coords","math/statistics","math/geometry","utils/type","base/element"],(function(t,e,i,r,s,o,n){"use strict";return t.Polygon=function(i,r,s){this.constructor(i,s,e.OBJECT_TYPE_POLYGON,e.OBJECT_CLASS_AREA);var n,a,h,l,c,d=o.copyAttributes(s,i.options,"polygon","borders");for(this.withLines=s.withlines,this.attr_line=d,this.vertices=[],n=0;n<r.length;n++)this.vertices[n]=this.board.select(r[n]);if(this.vertices.length>0&&this.vertices[this.vertices.length-1].id!==this.vertices[0].id&&this.vertices.push(this.vertices[0]),this.borders=[],this.withLines)for(h=this.vertices.length-1,l=0;l<h;l++)n=(l+1)%h,d.id=d.ids&&d.ids[n],d.name=d.names&&d.names[n],d.strokecolor=o.isArray(d.colors)&&d.colors[n%d.colors.length]||d.strokecolor,d.visible=o.exists(s.borders.visible)?s.borders.visible:s.visible,!1===d.strokecolor&&(d.strokecolor="none"),(a=i.create("segment",[this.vertices[n],this.vertices[n+1]],d)).dump=!1,this.borders[n]=a,a.parentPolygon=this;for(this.inherits.push(this.vertices,this.borders),this.id=this.board.setId(this,"Py"),n=0;n<this.vertices.length-1;n++)c=this.board.select(this.vertices[n]),o.exists(c._is_new)?(this.addChild(c),delete c._is_new):c.addChild(this);this.board.renderer.drawPolygon(this),this.board.finalizeAdding(this),this.createGradient(),this.elType="polygon",this.createLabel(),this.methodMap=t.deepCopy(this.methodMap,{borders:"borders",vertices:"vertices",A:"Area",Area:"Area",Perimeter:"Perimeter",L:"Perimeter",Length:"Perimeter",boundingBox:"boundingBox",bounds:"bounds",addPoints:"addPoints",insertPoints:"insertPoints",removePoints:"removePoints"})},t.Polygon.prototype=new n,t.extend(t.Polygon.prototype,{pnpoly:function(t,r,s){var o,n,a,h,l,c,d=this.vertices,u=!1;for(s===e.COORDS_BY_USER?(h=(c=new i(e.COORDS_BY_USER,[t,r],this.board)).scrCoords[1],l=c.scrCoords[2]):(h=t,l=r),o=0,n=(a=this.vertices.length)-2;o<a-1;n=o++)d[o].coords.scrCoords[2]>l!=d[n].coords.scrCoords[2]>l&&h<(d[n].coords.scrCoords[1]-d[o].coords.scrCoords[1])*(l-d[o].coords.scrCoords[2])/(d[n].coords.scrCoords[2]-d[o].coords.scrCoords[2])+d[o].coords.scrCoords[1]&&(u=!u);return u},hasPoint:function(t,e){var i,r;if(o.evaluate(this.visProp.hasinnerpoints)&&this.pnpoly(t,e))return!0;for(r=this.borders.length,i=0;i<r;i++)if(this.borders[i].hasPoint(t,e))return!0;return!1},updateRenderer:function(){var t,e;if(!this.needsUpdate)return this;if(this.visPropCalc.visible){for(e=this.vertices.length,this.isReal=!0,t=0;t<e;++t)if(!this.vertices[t].isReal){this.isReal=!1;break}this.isReal||this.updateVisibility(!1)}return this.visPropCalc.visible&&this.board.renderer.updatePolygon(this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this},getTextAnchor:function(){var t,r,s,o,n;if(0===this.vertices.length)return new i(e.COORDS_BY_USER,[1,0,0],this.board);for(s=t=this.vertices[0].X(),o=r=this.vertices[0].Y(),n=0;n<this.vertices.length;n++)this.vertices[n].X()<t&&(t=this.vertices[n].X()),this.vertices[n].X()>s&&(s=this.vertices[n].X()),this.vertices[n].Y()>r&&(r=this.vertices[n].Y()),this.vertices[n].Y()<o&&(o=this.vertices[n].Y());return new i(e.COORDS_BY_USER,[.5*(t+s),.5*(r+o)],this.board)},getLabelAnchor:t.shortcut(t.Polygon.prototype,"getTextAnchor"),cloneToBackground:function(){var t,e={};return e.id=this.id+"T"+this.numTraces,this.numTraces++,e.vertices=this.vertices,e.visProp=o.deepCopy(this.visProp,this.visProp.traceattributes,!0),e.visProp.layer=this.board.options.layer.trace,e.board=this.board,o.clearVisPropOld(e),e.visPropCalc={visible:o.evaluate(e.visProp.visible)},t=this.board.renderer.enhancedRendering,this.board.renderer.enhancedRendering=!0,this.board.renderer.drawPolygon(e),this.board.renderer.enhancedRendering=t,this.traces[e.id]=e.rendNode,this},hideElement:function(e){var i;if(t.deprecated("Element.hideElement()","Element.setDisplayRendNode()"),this.visPropCalc.visible=!1,this.board.renderer.display(this,!1),!e)for(i=0;i<this.borders.length;i++)this.borders[i].hideElement();this.hasLabel&&o.exists(this.label)&&(this.label.hiddenByParent=!0,this.label.visPropCalc.visible&&this.label.hideElement())},showElement:function(e){var i;if(t.deprecated("Element.showElement()","Element.setDisplayRendNode()"),this.visPropCalc.visible=!0,this.board.renderer.display(this,!0),!e)for(i=0;i<this.borders.length;i++)this.borders[i].showElement().updateRenderer();return o.exists(this.label)&&this.hasLabel&&this.label.hiddenByParent&&(this.label.hiddenByParent=!1,this.label.visPropCalc.visible||this.label.showElement().updateRenderer()),this},Area:function(){return Math.abs(s.signedPolygon(this.vertices,!0))},Perimeter:function(){var t,e=this.vertices.length,i=0;for(t=1;t<e;++t)i+=this.vertices[t].Dist(this.vertices[t-1]);return i},boundingBox:function(){var t,e,i=[0,0,0,0],r=this.vertices.length-1;if(0===r)return i;for(i[0]=this.vertices[0].X(),i[2]=i[0],i[1]=this.vertices[0].Y(),i[3]=i[1],t=1;t<r;++t)(e=this.vertices[t].X())<i[0]?i[0]=e:e>i[2]&&(i[2]=e),(e=this.vertices[t].Y())>i[1]?i[1]=e:e<i[3]&&(i[3]=e);return i},bounds:function(){return this.boundingBox()},remove:function(){var t;for(t=0;t<this.borders.length;t++)this.board.removeObject(this.borders[t]);n.prototype.remove.call(this)},findPoint:function(t){var e;if(!o.isPoint(t))return-1;for(e=0;e<this.vertices.length;e++)if(this.vertices[e].id===t.id)return e;return-1},addPoints:function(t){var e=Array.prototype.slice.call(arguments);return this.insertPoints.apply(this,[this.vertices.length-2].concat(e))},insertPoints:function(t,e){var i,r,s=[];if(0===arguments.length)return this;if(t<0||t>this.vertices.length-2)return this;for(i=1;i<arguments.length;i++)o.isPoint(arguments[i])&&s.push(arguments[i]);if(r=this.vertices.slice(0,t+1).concat(s),this.vertices=r.concat(this.vertices.slice(t+1)),this.withLines){for(r=this.borders.slice(0,t),this.board.removeObject(this.borders[t]),i=0;i<s.length;i++)r.push(this.board.create("segment",[this.vertices[t+i],this.vertices[t+i+1]],this.attr_line));r.push(this.board.create("segment",[this.vertices[t+s.length],this.vertices[t+s.length+1]],this.attr_line)),this.borders=r.concat(this.borders.slice(t+1))}return this.board.update(),this},removePoints:function(t){var e,i,r,s=[],n=[],a=[],h=[];for(this.vertices=this.vertices.slice(0,this.vertices.length-1),e=0;e<arguments.length;e++)r=arguments[e],o.isPoint(r)&&(r=this.findPoint(r)),o.isNumber(r)&&r>-1&&r<this.vertices.length&&-1===o.indexOf(a,r)&&a.push(r);for(e=0;e<a.length;e++)this.vertices[a[e]].removeChild(this);for(a=a.sort(),s=this.vertices.slice(),n=this.borders.slice(),this.withLines&&h.push([a[a.length-1]]),e=a.length-1;e>-1;e--)s[a[e]]=-1,this.withLines&&a[e]-1>a[e-1]&&(h[h.length-1][1]=a[e],h.push([a[e-1]]));for(this.withLines&&(h[h.length-1][1]=a[0]),this.vertices=[],e=0;e<s.length;e++)o.isPoint(s[e])&&this.vertices.push(s[e]);if(this.vertices[this.vertices.length-1].id!==this.vertices[0].id&&this.vertices.push(this.vertices[0]),this.withLines){for(e=0;e<h.length;e++){for(i=h[e][1]-1;i<h[e][0]+1;i++)i<0?(i=0,this.board.removeObject(this.borders[n.length-1]),n[n.length-1]=-1):i>n.length-1&&(i=n.length-1),this.board.removeObject(this.borders[i]),n[i]=-1;0!==h[e][1]&&h[e][0]!==s.length-1&&(n[h[e][0]-1]=this.board.create("segment",[s[Math.max(h[e][1]-1,0)],s[Math.min(h[e][0]+1,this.vertices.length-1)]],this.attr_line))}for(this.borders=[],e=0;e<n.length;e++)-1!==n[e]&&this.borders.push(n[e]);h[0][1]!==this.vertices.length-1&&0!==h[h.length-1][1]||this.borders.push(this.board.create("segment",[this.vertices[0],this.vertices[this.vertices.length-2]],this.attr_line))}return this.board.update(),this},getParents:function(){return this.setParents(this.vertices),this.parents},getAttributes:function(){var t,e=n.prototype.getAttributes.call(this);if(this.withLines)for(e.lines=e.lines||{},e.lines.ids=[],e.lines.colors=[],t=0;t<this.borders.length;t++)e.lines.ids.push(this.borders[t].id),e.lines.colors.push(this.borders[t].visProp.strokecolor);return e},snapToGrid:function(){var t,e;for(e=!!o.evaluate(this.visProp.snaptogrid),t=0;t<this.vertices.length;t++)this.vertices[t].handleSnapToGrid(e,!0)},setPositionDirectly:function(t,e,s){var o,n,a,h=new i(t,e,this.board),l=new i(t,s,this.board);for(a=this.vertices.length-1,n=0;n<a;n++)if(!this.vertices[n].draggable())return this;return o=r.subtract(h.usrCoords,l.usrCoords),this.board.create("transform",o.slice(1),{type:"translate"}).applyOnce(this.vertices.slice(0,-1)),this},sutherlandHodgman:function(e){var i,r,s,o,n,a,h,l=t.Math.Geometry.sortVertices(this.vertices),c=t.Math.Geometry.sortVertices(e.vertices),d=l.length-1,u=c.length-1,p=[],f=function(t,e,i){return(e[1]-t[1])*(i[2]-t[2])-(e[2]-t[2])*(i[1]-t[1])>=0};for(s=0;s<u;s++)p.push(c[s]);for(s=0;s<d;s++)for(r=p.slice(0),p=[],n=r[(i=r.length)-1],o=0;o<i;o++)a=r[o],f(l[s],l[s+1],a)?(f(l[s],l[s+1],n)||((h=t.Math.Geometry.meetSegmentSegment(n,a,l[s],l[s+1]))[0][1]/=h[0][0],h[0][2]/=h[0][0],h[0][0]=1,p.push(h[0])),p.push(a)):f(l[s],l[s+1],n)&&((h=t.Math.Geometry.meetSegmentSegment(n,a,l[s],l[s+1]))[0][1]/=h[0][0],h[0][2]/=h[0][0],h[0][0]=1,p.push(h[0])),n=a;return p},intersect:function(t){return this.sutherlandHodgman(t)}}),t.createPolygon=function(i,r,s){var n,a,h,l,c,d,u=[],p=!1;if(o.copyAttributes(s,i.options,"polygon"),null===(l=i.select(r[0]))&&(l=r[0]),o.isObject(l)&&l.type===e.OBJECT_TYPE_POLYGON&&o.isTransformationOrArray(r[1]))for(p=!0,h=l.vertices.length-1,d=o.copyAttributes(s,i.options,"polygon","vertices"),a=0;a<h;a++)d.withlabel&&(d.name=""===l.vertices[a].name?"":l.vertices[a].name+"'"),u.push(i.create("point",[l.vertices[a],r[1]],d));else if(!1===(u=o.providePoints(i,r,s,"polygon",["vertices"])))throw new Error("JSXGraph: Can't create polygon / polygonalchain with parent types other than 'point' and 'coordinate arrays' or a function returning an array of coordinates. Alternatively, a polygon and a transformation can be supplied");if(c=o.copyAttributes(s,i.options,"polygon"),(n=new t.Polygon(i,u,c)).isDraggable=!0,p)for(n.prepareUpdate().update().updateVisibility().updateRenderer(),h=l.vertices.length-1,a=0;a<h;a++)u[a].prepareUpdate().update().updateVisibility().updateRenderer();return n},t.createRegularPolygon=function(t,i,r){var s,n,a,h,l,c,d,u=[];if(a=i[(l=i.length)-1],o.isNumber(a)&&(3!==i.length||a<3))throw new Error("JSXGraph: A regular polygon needs two point types and a number > 2 as input.");if(o.isNumber(t.select(a))?(l--,c=!1):(a=l,c=!0),!1===(u=o.providePoints(t,i.slice(0,l),r,"regularpolygon",["vertices"])))throw new Error("JSXGraph: Can't create regular polygon with parent types other than 'point' and 'coordinate arrays' or a function returning an array of coordinates");for(d=o.copyAttributes(r,t.options,"regularpolygon","vertices"),n=2;n<a;n++)h=t.create("transform",[Math.PI*(2-(a-2)/a),u[n-1]],{type:"rotate"}),c?(u[n].addTransform(u[n-2],h),u[n].fullUpdate()):(o.isArray(d.ids)&&d.ids.length>=a-2&&(d.id=d.ids[n-2]),u[n]=t.create("point",[u[n-2],h],d),u[n].type=e.OBJECT_TYPE_CAS,u[n].isDraggable=!0,u[n].visProp.fixed=!1);return d=o.copyAttributes(r,t.options,"regularpolygon"),(s=t.create("polygon",u,d)).elType="regularpolygon",s},t.createPolygonalChain=function(t,e,i){var r,s;return r=o.copyAttributes(i,t.options,"polygonalchain"),(s=t.create("polygon",e,r)).elType="polygonalchain",s.vertices.pop(),t.removeObject(s.borders[s.borders.length-1]),s.borders.pop(),s},t.registerElement("polygon",t.createPolygon),t.registerElement("regularpolygon",t.createRegularPolygon),t.registerElement("polygonalchain",t.createPolygonalChain),{Polygon:t.Polygon,createPolygon:t.createPolygon,createRegularPolygon:t.createRegularPolygon}})),define("base/curve",["jxg","base/constants","base/coords","base/element","math/math","math/numerics","math/plot","math/geometry","parser/geonext","utils/type","math/qdt"],(function(t,e,i,r,s,o,n,a,h,l,c){"use strict";return t.Curve=function(t,i,r){this.constructor(t,r,e.OBJECT_TYPE_CURVE,e.OBJECT_CLASS_CURVE),this.points=[],this.numberPoints=l.evaluate(this.visProp.numberpointshigh),this.bezierDegree=1,this.dataX=null,this.dataY=null,this.ticks=[],this.qdt=null,l.exists(i[0])?this.varname=i[0]:this.varname="x",this.xterm=i[1],this.yterm=i[2],this.generateTerm(this.varname,this.xterm,this.yterm,i[3],i[4]),this.updateCurve(),this.id=this.board.setId(this,"G"),this.board.renderer.drawCurve(this),this.board.finalizeAdding(this),this.createGradient(),this.elType="curve",this.createLabel(),l.isString(this.xterm)&&this.notifyParents(this.xterm),l.isString(this.yterm)&&this.notifyParents(this.yterm),this.methodMap=l.deepCopy(this.methodMap,{generateTerm:"generateTerm",setTerm:"generateTerm",move:"moveTo",moveTo:"moveTo"})},t.Curve.prototype=new r,t.extend(t.Curve.prototype,{minX:function(){return"polar"===l.evaluate(this.visProp.curvetype)?0:new i(e.COORDS_BY_SCREEN,[.1*-this.board.canvasWidth,0],this.board,!1).usrCoords[1]},maxX:function(){return"polar"===l.evaluate(this.visProp.curvetype)?2*Math.PI:new i(e.COORDS_BY_SCREEN,[1.1*this.board.canvasWidth,0],this.board,!1).usrCoords[1]},X:function(t){return NaN},Y:function(t){return NaN},Z:function(t){return 1},hasPoint:function(t,r,o){var n,h,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S=[],x=l.evaluate(this.visProp.numberpointslow),O=(this.maxX()-this.minX())/x,w=1/0;if(l.isObject(l.evaluate(this.visProp.precision))?(y=this.board._inputDevice,v=l.evaluate(this.visProp.precision[y])):v=this.board.options.precision.hasPoint,t=(h=new i(e.COORDS_BY_SCREEN,[t,r],this.board,!1)).usrCoords[1],r=h.usrCoords[2],v+=.5*l.evaluate(this.visProp.strokewidth),v*=v,C=this.board.unitX*this.board.unitX,_=this.board.unitY*this.board.unitY,E=this.minX(),this.maxX(),l.exists(this._visibleArea)&&(E=this._visibleArea[0],O=(this._visibleArea[1]-E)/x),"parameter"===(P=l.evaluate(this.visProp.curvetype))||"polar"===P)for(this.transformations.length>0&&(this.updateTransformMatrix(),d=s.inverse(this.transformMat),t=(u=s.matVecMult(d,[1,t,r]))[1],r=u[2]),p=0,n=E;p<x;p++){if((w=(t-(f=this.X(n,true)))*(t-f)*C+(r-(m=this.Y(n,true)))*(r-m)*_)<=v)return!0;n+=O}else if("plot"===P||"functiongraph"===P){for((!l.exists(o)||o<0)&&(o=0),l.exists(this.qdt)&&l.evaluate(this.visProp.useqdt)&&3!==this.bezierDegree?c=(g=(b=this.qdt.query(new i(e.COORDS_BY_USER,[t,r],this.board))).points).length:(g=this.points,c=this.numberPoints-1),p=o;p<c;p++)if(3===this.bezierDegree?S.push(a.projectCoordsToBeziersegment([1,t,r],this,p)):b?(g[p].prev&&(S=a.projectCoordsToSegment([1,t,r],g[p].prev.usrCoords,g[p].usrCoords)),g[p].next&&g[p+1]!==g[p].next&&(S=a.projectCoordsToSegment([1,t,r],g[p].usrCoords,g[p].next.usrCoords))):S=a.projectCoordsToSegment([1,t,r],g[p].usrCoords,g[p+1].usrCoords),S[1]>=0&&S[1]<=1&&(t-S[0][1])*(t-S[0][1])*C+(r-S[0][2])*(r-S[0][2])*_<=v)return!0;return!1}return w<v},allocatePoints:function(){var t,r;if(r=this.numberPoints,this.points.length<this.numberPoints)for(t=this.points.length;t<r;t++)this.points[t]=new i(e.COORDS_BY_USER,[0,0],this.board,!1)},update:function(){return this.needsUpdate&&(l.evaluate(this.visProp.trace)&&this.cloneToBackground(!0),this.updateCurve()),this},updateRenderer:function(){return this.needsUpdate?(this.visPropCalc.visible&&(this.isReal=n.checkReal(this.points),this.isReal||this.updateVisibility(!1)),this.visPropCalc.visible&&this.board.renderer.updateCurve(this),this.hasLabel&&this.visPropCalc.visible&&this.label&&this.label.visPropCalc.visible&&this.isReal&&(this.label.update(),this.board.renderer.updateText(this.label)),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},updateDataArray:function(){},updateCurve:function(){var t,i,r,s,a,h,d=this.visProp.plotversion,u=!1;if(this.updateTransformMatrix(),this.updateDataArray(),i=this.minX(),r=this.maxX(),l.exists(this.dataX))for(this.numberPoints=this.dataX.length,t=this.numberPoints,this.allocatePoints(),h=0;h<t;h++)s=h,l.exists(this.dataY)?(a=h,this.points[h].setCoordinates(e.COORDS_BY_USER,[this.dataX[h],this.dataY[h]],!1)):(a=this.X(s),this.points[h].setCoordinates(e.COORDS_BY_USER,[this.dataX[h],this.Y(a,u)],!1)),this.points[h]._t=h,u=!0;else if(l.evaluate(this.visProp.doadvancedplot)?1===d||l.evaluate(this.visProp.doadvancedplotold)?n.updateParametricCurveOld(this,i,r):2===d?n.updateParametricCurve_v2(this,i,r):3===d?n.updateParametricCurve_v3(this,i,r):4===d?n.updateParametricCurve_v4(this,i,r):n.updateParametricCurve_v2(this,i,r):(this.board.updateQuality===this.board.BOARD_QUALITY_HIGH?this.numberPoints=l.evaluate(this.visProp.numberpointshigh):this.numberPoints=l.evaluate(this.visProp.numberpointslow),this.allocatePoints(),n.updateParametricCurveNaive(this,i,r,this.numberPoints)),t=this.numberPoints,l.evaluate(this.visProp.useqdt)&&this.board.updateQuality===this.board.BOARD_QUALITY_HIGH)for(this.qdt=new c(this.board.getBoundingBox()),h=0;h<this.points.length;h++)this.qdt.insert(this.points[h]),h>0&&(this.points[h].prev=this.points[h-1]),h<t-1&&(this.points[h].next=this.points[h+1]);for("plot"!==l.evaluate(this.visProp.curvetype)&&l.evaluate(this.visProp.rdpsmoothing)&&(this.points=o.RamerDouglasPeucker(this.points,.2),this.numberPoints=this.points.length),t=this.numberPoints,h=0;h<t;h++)this.updateTransform(this.points[h]);return this},updateTransformMatrix:function(){var t,e,i=this.transformations.length;for(this.transformMat=[[1,0,0],[0,1,0],[0,0,1]],e=0;e<i;e++)(t=this.transformations[e]).update(),this.transformMat=s.matMatMult(t.matrix,this.transformMat);return this},updateTransform:function(t){var i;return this.transformations.length>0&&(i=s.matVecMult(this.transformMat,t.usrCoords),t.setCoordinates(e.COORDS_BY_USER,i,!1,!0)),t},addTransform:function(t){var e,i=l.isArray(t)?t:[t],r=i.length;for(e=0;e<r;e++)this.transformations.push(i[e]);return this},interpolationFunctionFromArray:function(t){var e="data"+t,i=this;return function(t,r){var s,o,n,a,h=i[e],c=h.length,d=[];if(isNaN(t))return NaN;if(t<0)return l.isFunction(h[0])?h[0]():h[0];if(3===i.bezierDegree){if(t>=(c-1)/3)return l.isFunction(h[h.length-1])?h[h.length-1]():h[h.length-1];for(s=3*Math.floor(t),a=1-(n=t%1),o=0;o<4;o++)l.isFunction(h[s+o])?d[o]=h[s+o]():d[o]=h[s+o];return a*a*(a*d[0]+3*n*d[1])+(3*a*d[2]+n*d[3])*n*n}if((s=t>c-2?c-2:parseInt(Math.floor(t),10))===t)return l.isFunction(h[s])?h[s]():h[s];for(o=0;o<2;o++)l.isFunction(h[s+o])?d[o]=h[s+o]():d[o]=h[s+o];return d[0]+(d[1]-d[0])*(t-s)}},generateTerm:function(t,e,i,r,s){var o,n;l.isArray(e)?(this.dataX=e,this.numberPoints=this.dataX.length,this.X=this.interpolationFunctionFromArray.apply(this,["X"]),this.visProp.curvetype="plot",this.isDraggable=!0):(this.X=l.createFunction(e,this.board,t),l.isString(e)?this.visProp.curvetype="functiongraph":(l.isFunction(e)||l.isNumber(e))&&(this.visProp.curvetype="parameter"),this.isDraggable=!0),l.isArray(i)?(this.dataY=i,this.Y=this.interpolationFunctionFromArray.apply(this,["Y"])):this.Y=l.createFunction(i,this.board,t),l.isFunction(e)&&l.isArray(i)&&(o=l.createFunction(i[0],this.board,""),n=l.createFunction(i[1],this.board,""),this.X=function(t){return e(t)*Math.cos(t)+o()},this.Y=function(t){return e(t)*Math.sin(t)+n()},this.visProp.curvetype="polar"),l.exists(r)&&(this.minX=l.createFunction(r,this.board,"")),l.exists(s)&&(this.maxX=l.createFunction(s,this.board,""))},notifyParents:function(t){var e,i,r,s=!1;for(e in r={xterm:1,yterm:1})if(r.hasOwnProperty(e)&&this.hasOwnProperty(e)&&this[e].origin)for(i in s=!0,this[e].origin.deps)this[e].origin.deps.hasOwnProperty(i)&&this[e].origin.deps[i].addChild(this);s||h.findDependencies(this,t,this.board)},getLabelAnchor:function(){var t,r,s,o=.05*this.board.canvasWidth,n=.05*this.board.canvasHeight,h=.95*this.board.canvasWidth,c=.95*this.board.canvasHeight;switch(l.evaluate(this.visProp.label.position)){case"ulft":r=o,s=n;break;case"llft":r=o,s=c;break;case"rt":r=h,s=.5*c;break;case"lrt":r=h,s=c;break;case"urt":r=h,s=n;break;case"top":r=.5*h,s=n;break;case"bot":r=.5*h,s=c;break;default:r=o,s=.5*c}return t=new i(e.COORDS_BY_SCREEN,[r,s],this.board,!1),a.projectCoordsToCurve(t.usrCoords[1],t.usrCoords[2],0,this,this.board)[0]},cloneToBackground:function(){var t,i={id:this.id+"T"+this.numTraces,elementClass:e.OBJECT_CLASS_CURVE,points:this.points.slice(0),bezierDegree:this.bezierDegree,numberPoints:this.numberPoints,board:this.board,visProp:l.deepCopy(this.visProp,this.visProp.traceattributes,!0)};return i.visProp.layer=this.board.options.layer.trace,i.visProp.curvetype=this.visProp.curvetype,this.numTraces++,l.clearVisPropOld(i),i.visPropCalc={visible:l.evaluate(i.visProp.visible)},t=this.board.renderer.enhancedRendering,this.board.renderer.enhancedRendering=!0,this.board.renderer.drawCurve(i),this.board.renderer.enhancedRendering=t,this.traces[i.id]=i.rendNode,this},bounds:function(){var t,e,i,r=1/0,s=-1/0,n=1/0,a=-1/0,h=this.points.length;if(3===this.bezierDegree){for(t=0;t<h;t++)this.points[t].X=l.bind((function(){return this.usrCoords[1]}),this.points[t]),this.points[t].Y=l.bind((function(){return this.usrCoords[2]}),this.points[t]);return i=(e=o.bezier(this.points))[3](),r=o.fminbr((function(t){return e[0](t)}),[0,i]),s=o.fminbr((function(t){return-e[0](t)}),[0,i]),n=o.fminbr((function(t){return e[1](t)}),[0,i]),a=o.fminbr((function(t){return-e[1](t)}),[0,i]),r=e[0](r),s=e[0](s),n=e[1](n),[r,a=e[1](a),s,n]}for(t=0;t<h;t++)r>this.points[t].usrCoords[1]&&(r=this.points[t].usrCoords[1]),s<this.points[t].usrCoords[1]&&(s=this.points[t].usrCoords[1]),n>this.points[t].usrCoords[2]&&(n=this.points[t].usrCoords[2]),a<this.points[t].usrCoords[2]&&(a=this.points[t].usrCoords[2]);return[r,a,s,n]},getParents:function(){var t=[this.xterm,this.yterm,this.minX(),this.maxX()];return 0!==this.parents.length&&(t=this.parents),t},moveTo:function(t){var i,r=[];return this.points.length>0&&!l.evaluate(this.visProp.fixed)&&(i=this.points[0],r=3===t.length?[t[0]-i.usrCoords[0],t[1]-i.usrCoords[1],t[2]-i.usrCoords[2]]:[t[0]-i.usrCoords[1],t[1]-i.usrCoords[2]],this.setPosition(e.COORDS_BY_USER,r)),this},getTransformationSource:function(){var t,i;return l.exists(this._transformationSource)&&(i=this._transformationSource).elementClass===e.OBJECT_CLASS_CURVE&&(t=!0),[t,i]}}),t.createCurve=function(i,r,s){var o,n,a=l.copyAttributes(s,i.options,"curve");return o=i.select(r[0],!0),l.isObject(o)&&(o.type===e.OBJECT_TYPE_CURVE||o.type===e.OBJECT_TYPE_ANGLE||o.type===e.OBJECT_TYPE_ARC||o.type===e.OBJECT_TYPE_CONIC||o.type===e.OBJECT_TYPE_SECTOR)&&l.isTransformationOrArray(r[1])?(o.type===e.OBJECT_TYPE_SECTOR?a=l.copyAttributes(s,i.options,"sector"):o.type===e.OBJECT_TYPE_ARC?a=l.copyAttributes(s,i.options,"arc"):o.type===e.OBJECT_TYPE_ANGLE?(l.exists(s.withLabel)||(s.withLabel=!1),a=l.copyAttributes(s,i.options,"angle")):a=l.copyAttributes(s,i.options,"curve"),a=l.copyAttributes(a,i.options,"curve"),(n=new t.Curve(i,["x",[],[]],a)).updateDataArray=function(){var t,e=o.numberPoints;for(this.bezierDegree=o.bezierDegree,this.dataX=[],this.dataY=[],t=0;t<e;t++)this.dataX.push(o.points[t].usrCoords[1]),this.dataY.push(o.points[t].usrCoords[2]);return this},n.addTransform(r[1]),o.addChild(n),n.setParents([o]),n._transformationSource=o,n):(a=l.copyAttributes(s,i.options,"curve"),new t.Curve(i,["x"].concat(r),a))},t.registerElement("curve",t.createCurve),t.createFunctiongraph=function(e,i,r){var s,o=["x","x"].concat(i);return(s=l.copyAttributes(r,e.options,"curve")).curvetype="functiongraph",new t.Curve(e,o,s)},t.registerElement("functiongraph",t.createFunctiongraph),t.registerElement("plot",t.createFunctiongraph),t.createSpline=function(e,i,r){var s,n,a;return n=function(){var t,e=[],r=[];return[function(s,n){var a,h,c;if(!n){if(e=[],r=[],2===i.length&&l.isArray(i[0])&&l.isArray(i[1])&&i[0].length===i[1].length)for(a=0;a<i[0].length;a++)l.isFunction(i[0][a])?e.push(i[0][a]()):e.push(i[0][a]),l.isFunction(i[1][a])?r.push(i[1][a]()):r.push(i[1][a]);else for(a=0;a<i.length;a++)if(l.isPoint(i[a]))e.push(i[a].X()),r.push(i[a].Y());else if(l.isArray(i[a])&&2===i[a].length)for(h=0;h<i.length;h++)l.isFunction(i[h][0])?e.push(i[h][0]()):e.push(i[h][0]),l.isFunction(i[h][1])?r.push(i[h][1]()):r.push(i[h][1]);else l.isFunction(i[a])&&2===i[a]().length&&(c=i[a](),e.push(c[0]),r.push(c[1]));t=o.splineDef(e,r)}return o.splineEval(s,e,r,t)},function(){return e[0]},function(){return e[e.length-1]}]},(r=l.copyAttributes(r,e.options,"curve")).curvetype="functiongraph",a=n(),(s=new t.Curve(e,["x","x",a[0],a[1],a[2]],r)).setParents(i),s.elType="spline",s},t.registerElement("spline",t.createSpline),t.createCardinalSpline=function(e,i,r){var s,n,a,h,c,d,u,p,f,m,g="\nPossible parent types: [points:array, tau:number|function, type:string]";if(!l.exists(i[0])||!l.isArray(i[0]))throw new Error("JSXGraph: JXG.createCardinalSpline: argument 1 'points' has to be array of points or coordinate pairs"+g);if(!l.exists(i[1])||!l.isNumber(i[1])&&!l.isFunction(i[1]))throw new Error("JSXGraph: JXG.createCardinalSpline: argument 2 'tau' has to be number between [0,1] or function'"+g);if(!l.exists(i[2])||!l.isString(i[2]))throw new Error("JSXGraph: JXG.createCardinalSpline: argument 3 'type' has to be string 'uniform' or 'centripetal'"+g);if(r=l.copyAttributes(r,e.options,"curve"),(r=l.copyAttributes(r,e.options,"cardinalspline")).curvetype="parameter",d=i[0],u=[],!r.isarrayofcoordinates&&2===d.length&&l.isArray(d[0])&&l.isArray(d[1])&&d[0].length===d[1].length)for(p=0;p<d[0].length;p++)u[p]=[],l.isFunction(d[0][p])?u[p].push(d[0][p]()):u[p].push(d[0][p]),l.isFunction(d[1][p])?u[p].push(d[1][p]()):u[p].push(d[1][p]);else for(p=0;p<d.length;p++)l.isString(d[p])?u.push(e.select(d[p])):l.isPoint(d[p])?u.push(d[p]):l.isArray(d[p])&&2===d[p].length?(u[p]=[],l.isFunction(d[p][0])?u[p].push(d[p][0]()):u[p].push(d[p][0]),l.isFunction(d[p][1])?u[p].push(d[p][1]()):u[p].push(d[p][1])):l.isFunction(d[p])&&2===d[p]().length&&u.push(i[p]());if(!0===r.createpoints)a=l.providePoints(e,u,r,"cardinalspline",["points"]);else for(a=[],n=function(t){return{X:function(){return u[t][0]},Y:function(){return u[t][1]},Dist:function(t){var e=this.X()-t.X(),i=this.Y()-t.Y();return Math.sqrt(e*e+i*i)}}},p=0;p<u.length;p++)l.isPoint(u[p])?a.push(u[p]):a.push(n(p));for(h=i[1],c=i[2],m=["x"].concat(o.CardinalSpline(a,h,c)),s=new t.Curve(e,m,r),f=a.length,s.setParents(a),p=0;p<f;p++)d=a[p],l.isPoint(d)&&(l.exists(d._is_new)?(s.addChild(d),delete d._is_new):d.addChild(s));return s.elType="cardinalspline",s},t.registerElement("cardinalspline",t.createCardinalSpline),t.createMetapostSpline=function(e,i,r){var s,o,n,a,h,c,d,u,p="\nPossible parent types: [points:array, controls:object";if(!l.exists(i[0])||!l.isArray(i[0]))throw new Error("JSXGraph: JXG.createMetapostSpline: argument 1 'points' has to be array of points or coordinate pairs"+p);if(!l.exists(i[1])||!l.isObject(i[1]))throw new Error("JSXGraph: JXG.createMetapostSpline: argument 2 'controls' has to be a JavaScript object'"+p);if(r=l.copyAttributes(r,e.options,"curve"),(r=l.copyAttributes(r,e.options,"metapostspline")).curvetype="parameter",h=i[0],c=[],!r.isarrayofcoordinates&&2===h.length&&l.isArray(h[0])&&l.isArray(h[1])&&h[0].length===h[1].length)for(d=0;d<h[0].length;d++)c[d]=[],l.isFunction(h[0][d])?c[d].push(h[0][d]()):c[d].push(h[0][d]),l.isFunction(h[1][d])?c[d].push(h[1][d]()):c[d].push(h[1][d]);else for(d=0;d<h.length;d++)l.isString(h[d])?c.push(e.select(h[d])):l.isPoint(h[d])?c.push(h[d]):l.isArray(h[d])&&2===h[d].length?(c[d]=[],l.isFunction(h[d][0])?c[d].push(h[d][0]()):c[d].push(h[d][0]),l.isFunction(h[d][1])?c[d].push(h[d][1]()):c[d].push(h[d][1])):l.isFunction(h[d])&&2===h[d]().length&&c.push(i[d]());if(!0===r.createpoints)n=l.providePoints(e,c,r,"metapostspline",["points"]);else for(n=[],o=function(t){return{X:function(){return c[t][0]},Y:function(){return c[t][1]}}},d=0;d<c.length;d++)l.isPoint(c[d])?n.push(c[d]):n.push(o);for(a=i[1],(s=new t.Curve(e,["t",[],[],0,h.length-1],r)).updateDataArray=function(){var e,i,r=n.length,s=[];for(i=0;i<r;i++)s.push([n[i].X(),n[i].Y()]);e=t.Math.Metapost.curve(s,a),this.dataX=e[0],this.dataY=e[1]},s.bezierDegree=3,u=n.length,s.setParents(n),d=0;d<u;d++)l.isPoint(n[d])&&n[d].addChild(s);return s.elType="metapostspline",s},t.registerElement("metapostspline",t.createMetapostSpline),t.createRiemannsum=function(t,e,i){var r,s,n,a,h,c;if((c=l.copyAttributes(i,t.options,"riemannsum")).curvetype="plot",n=e[0],r=l.createFunction(e[1],t,""),!l.exists(r))throw new Error("JSXGraph: JXG.createRiemannsum: argument '2' n has to be number or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]");if(s=l.createFunction(e[2],t,"",!1),!l.exists(s))throw new Error("JSXGraph: JXG.createRiemannsum: argument 3 'type' has to be string or function.\nPossible parent types: [function,n:number|function,type,start:number|function,end:number|function]");return a=[[0],[0]].concat(e.slice(3)),(h=t.create("curve",a,c)).sum=0,h.Value=function(){return this.sum},h.updateDataArray=function(){var t=o.riemann(n,r(),s(),this.minX(),this.maxX());this.dataX=t[0],this.dataY=t[1],this.sum=t[2]},h},t.registerElement("riemannsum",t.createRiemannsum),t.createTracecurve=function(t,i,r){var s,o,n,a;if(2!==i.length)throw new Error("JSXGraph: Can't create trace curve with given parent'\nPossible parent types: [glider, point]");if(o=t.select(i[0]),n=t.select(i[1]),o.type!==e.OBJECT_TYPE_GLIDER||!l.isPoint(n))throw new Error("JSXGraph: Can't create trace curve with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [glider, point]");return(a=l.copyAttributes(r,t.options,"tracecurve")).curvetype="plot",(s=t.create("curve",[[0],[0]],a)).updateDataArray=function(){var t,i,r,s,h,l,c,d,u,p=a.numberpoints,f=o.position,m=o.slideObject,g=m.minX();for(i=(m.maxX()-g)/p,this.dataX=[],this.dataY=[],m.elementClass!==e.OBJECT_CLASS_CURVE&&p++,t=0;t<p;t++){for(s in r=g+t*i,l=m.X(r)/m.Z(r),c=m.Y(r)/m.Z(r),o.setPositionDirectly(e.COORDS_BY_USER,[l,c]),d=!1,this.board.objects)if(this.board.objects.hasOwnProperty(s)&&((h=this.board.objects[s])===o&&(d=!0),d&&h.needsRegularUpdate&&(u=h.visProp.trace,h.visProp.trace=!1,h.needsUpdate=!0,h.update(!0),h.visProp.trace=u,h===n)))break;this.dataX[t]=n.X(),this.dataY[t]=n.Y()}for(s in o.position=f,d=!1,this.board.objects)if(this.board.objects.hasOwnProperty(s)&&((h=this.board.objects[s])===o&&(d=!0),d&&h.needsRegularUpdate&&(u=h.visProp.trace,h.visProp.trace=!1,h.needsUpdate=!0,h.update(!0),h.visProp.trace=u,h===n)))break},s},t.registerElement("tracecurve",t.createTracecurve),t.createStepfunction=function(t,e,i){var r,s;if(2!==e.length)throw new Error("JSXGraph: Can't create step function with given parent'\nPossible parent types: [array, array|function]");return s=l.copyAttributes(i,t.options,"stepfunction"),(r=t.create("curve",e,s)).updateDataArray=function(){var t,e=0,i=this.xterm.length;if(this.dataX=[],this.dataY=[],0!==i)for(this.dataX[e]=this.xterm[0],this.dataY[e]=this.yterm[0],++e,t=1;t<i;++t)this.dataX[e]=this.xterm[t],this.dataY[e]=this.dataY[e-1],++e,this.dataX[e]=this.xterm[t],this.dataY[e]=this.yterm[t],++e},r},t.registerElement("stepfunction",t.createStepfunction),t.createDerivative=function(t,i,r){var s,n,a,h,c;if(1!==i.length&&i[0].class!==e.OBJECT_CLASS_CURVE)throw new Error("JSXGraph: Can't create derivative curve with given parent'\nPossible parent types: [curve]");return c=l.copyAttributes(r,t.options,"curve"),n=i[0],a=o.D(n.X),h=o.D(n.Y),(s=t.create("curve",[function(t){return n.X(t)},function(t){return h(t)/a(t)},n.minX(),n.maxX()],c)).setParents(n),s},t.registerElement("derivative",t.createDerivative),t.createCurveIntersection=function(e,i,r){var s;if(2!==i.length)throw new Error("JSXGraph: Can't create curve intersection with given parent'\nPossible parent types: [array, array|function]");return(s=e.create("curve",[[],[]],r)).updateDataArray=function(){var e=t.Math.Clip.intersection(i[0],i[1],this.board);this.dataX=e[0],this.dataY=e[1]},s},t.createCurveUnion=function(e,i,r){var s;if(2!==i.length)throw new Error("JSXGraph: Can't create curve union with given parent'\nPossible parent types: [array, array|function]");return(s=e.create("curve",[[],[]],r)).updateDataArray=function(){var e=t.Math.Clip.union(i[0],i[1],this.board);this.dataX=e[0],this.dataY=e[1]},s},t.createCurveDifference=function(e,i,r){var s;if(2!==i.length)throw new Error("JSXGraph: Can't create curve difference with given parent'\nPossible parent types: [array, array|function]");return(s=e.create("curve",[[],[]],r)).updateDataArray=function(){var e=t.Math.Clip.difference(i[0],i[1],this.board);this.dataX=e[0],this.dataY=e[1]},s},t.registerElement("curvedifference",t.createCurveDifference),t.registerElement("curveintersection",t.createCurveIntersection),t.registerElement("curveunion",t.createCurveUnion),t.createBoxPlot=function(t,e,i){var r,s,o,n=l.copyAttributes(i,t.options,"boxplot");if(3!==e.length)throw new Error("JSXGraph: Can't create box plot with given parent'\nPossible parent types: [array, number|function, number|function] containing quantiles, axis, width");if(e[0].length<5)throw new Error("JSXGraph: Can't create box plot with given parent[0]'\nparent[0] has to conatin at least 5 quantiles.");for(r=t.create("curve",[[],[]],n),o=e[0].length,r.Q=[],s=0;s<o;s++)r.Q[s]=l.createFunction(e[0][s],t,null,!0);return r.x=l.createFunction(e[1],t,null,!0),r.w=l.createFunction(e[2],t,null,!0),r.updateDataArray=function(){var t,e,i,r,s,o,n,a,h;n=l.evaluate(this.visProp.smallwidth),a=l.evaluate(this.visProp.dir),i=(h=this.x())-.5*this.w(),r=h-.5*this.w()*n,s=h+.5*this.w(),t=[h,r,o=h+.5*this.w()*n,h,h,i,i,s,s,h,NaN,i,s,NaN,h,h,r,o,h],e=[this.Q[0](),this.Q[0](),this.Q[0](),this.Q[0](),this.Q[1](),this.Q[1](),this.Q[3](),this.Q[3](),this.Q[1](),this.Q[1](),NaN,this.Q[2](),this.Q[2](),NaN,this.Q[3](),this.Q[4](),this.Q[4](),this.Q[4](),this.Q[4]()],"vertical"===a?(this.dataX=t,this.dataY=e):(this.dataX=e,this.dataY=t)},r},t.registerElement("boxplot",t.createBoxPlot),{Curve:t.Curve,createCardinalSpline:t.createCardinalSpline,createCurve:t.createCurve,createCurveDifference:t.createCurveDifference,createCurveIntersection:t.createCurveIntersection,createCurveUnion:t.createCurveUnion,createDerivative:t.createDerivative,createFunctiongraph:t.createFunctiongraph,createMetapostSpline:t.createMetapostSpline,createPlot:t.createFunctiongraph,createSpline:t.createSpline,createRiemannsum:t.createRiemannsum,createStepfunction:t.createStepfunction,createTracecurve:t.createTracecurve}})),define("element/arc",["jxg","math/geometry","math/math","base/coords","base/circle","utils/type","base/constants"],(function(t,e,i,r,s,o,n){"use strict";return t.createArc=function(a,h,l){var c,d,u;if(!1===(u=o.providePoints(a,h,l,"arc",["center","radiusPoint","anglePoint"]))||u.length<3)throw new Error("JSXGraph: Can't create Arc with parent types '"+typeof h[0]+"' and '"+typeof h[1]+"' and '"+typeof h[2]+"'.\nPossible parent types: [point,point,point], [arc, transformation]");return d=o.copyAttributes(l,a.options,"arc"),(c=a.create("curve",[[0],[0]],d)).elType="arc",c.setParents(u),c.type=n.OBJECT_TYPE_ARC,c.center=u[0],c.radiuspoint=u[1],c.point2=c.radiuspoint,c.anglepoint=u[2],c.point3=c.anglepoint,o.exists(c.center._is_new)?(c.addChild(c.center),delete c.center._is_new):c.center.addChild(c),o.exists(c.radiuspoint._is_new)?(c.addChild(c.radiuspoint),delete c.radiuspoint._is_new):c.radiuspoint.addChild(c),o.exists(c.anglepoint._is_new)?(c.addChild(c.anglepoint),delete c.anglepoint._is_new):c.anglepoint.addChild(c),c.useDirection=d.usedirection,c.updateDataArray=function(){var t,i,r,s,n,a=1,h=this.radiuspoint,l=this.center,c=this.anglepoint,d=o.evaluate(this.visProp.selection);i=e.rad(h,l,c),("minor"===d&&i>Math.PI||"major"===d&&i<Math.PI)&&(a=-1),this.useDirection&&(r=u[1].coords.usrCoords,s=u[3].coords.usrCoords,n=u[2].coords.usrCoords,(r[1]-n[1])*(r[2]-s[2])-(r[2]-n[2])*(r[1]-s[1])<0?(this.radiuspoint=u[1],this.anglepoint=u[2]):(this.radiuspoint=u[2],this.anglepoint=u[1])),h=h.coords.usrCoords,l=l.coords.usrCoords,c=c.coords.usrCoords,t=e.bezierArc(h,l,c,!1,a),this.dataX=t[0],this.dataY=t[1],this.bezierDegree=3,this.updateStdform(),this.updateQuadraticform()},c.Radius=function(){return this.radiuspoint.Dist(this.center)},c.getRadius=function(){return t.deprecated("Arc.getRadius()","Arc.Radius()"),this.Radius()},c.Value=function(){return this.Radius()*e.rad(this.radiuspoint,this.center,this.anglepoint)},c.hasPoint=function(t,s){var a,h,l,c,d,u,p,f=this.Radius();return o.evaluate(this.visProp.hasinnerpoints)?this.hasPointSector(t,s):(o.isObject(o.evaluate(this.visProp.precision))?(p=this.board._inputDevice,u=o.evaluate(this.visProp.precision[p])):u=this.board.options.precision.hasPoint,u/=Math.min(this.board.unitX,this.board.unitY),h=new r(n.COORDS_BY_SCREEN,[t,s],this.board),this.transformations.length>0&&(this.updateTransformMatrix(),c=i.inverse(this.transformMat),d=i.matVecMult(c,h.usrCoords),h=new r(n.COORDS_BY_USER,d,this.board)),a=this.center.coords.distance(n.COORDS_BY_USER,h),(l=Math.abs(a-f)<u)&&(l=e.coordsOnArc(this,h)),l)},c.hasPointSector=function(t,i){var s=new r(n.COORDS_BY_SCREEN,[t,i],this.board),o=this.Radius(),a=this.center.coords.distance(n.COORDS_BY_USER,s)<o;return a&&(a=e.coordsOnArc(this,s)),a},c.getTextAnchor=function(){return this.center.coords},c.getLabelAnchor=function(){var t,i,s,a,h,l=e.rad(this.radiuspoint,this.center,this.anglepoint),c=10/this.board.unitX,d=10/this.board.unitY,u=this.point2.coords.usrCoords,p=this.center.coords.usrCoords,f=u[1]-p[1],m=u[2]-p[2],g=o.evaluate(this.visProp.selection),b=this.label?this.label.visProp:this.visProp.label;return("minor"===g&&l>Math.PI||"major"===g&&l<Math.PI)&&(l=-(2*Math.PI-l)),s=(t=new r(n.COORDS_BY_USER,[p[1]+Math.cos(.5*l)*f-Math.sin(.5*l)*m,p[2]+Math.sin(.5*l)*f+Math.cos(.5*l)*m],this.board)).usrCoords[1]-p[1],a=t.usrCoords[2]-p[2],s=s*((h=Math.sqrt(s*s+a*a))+c)/h,a=a*(h+d)/h,i=[p[1]+s,p[2]+a],b.position=e.calcLabelQuadrant(e.rad([1,0],[0,0],i)),new r(n.COORDS_BY_USER,i,this.board)},c.updateQuadraticform=s.Circle.prototype.updateQuadraticform,c.updateStdform=s.Circle.prototype.updateStdform,c.methodMap=t.deepCopy(c.methodMap,{getRadius:"getRadius",radius:"Radius",center:"center",radiuspoint:"radiuspoint",anglepoint:"anglepoint",Value:"Value"}),c.prepareUpdate().update(),c},t.registerElement("arc",t.createArc),t.createSemicircle=function(t,e,i){var r,s,n,a;if(!1===(a=o.providePoints(t,e,i,"point"))||2!==a.length)throw new Error("JSXGraph: Can't create Semicircle with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point]");return n=o.copyAttributes(i,t.options,"semicircle","center"),(s=t.create("midpoint",a,n)).dump=!1,n=o.copyAttributes(i,t.options,"semicircle"),(r=t.create("arc",[s,a[1],a[0]],n)).elType="semicircle",r.setParents([a[0].id,a[1].id]),r.subs={midpoint:s},r.inherits.push(s),r.midpoint=r.center=s,r},t.registerElement("semicircle",t.createSemicircle),t.createCircumcircleArc=function(t,e,i){var r,s,n,a;if(!1===(a=o.providePoints(t,e,i,"point"))||3!==a.length)throw new Error("JSXGraph: create Circumcircle Arc with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]");return n=o.copyAttributes(i,t.options,"circumcirclearc","center"),(s=t.create("circumcenter",a,n)).dump=!1,(n=o.copyAttributes(i,t.options,"circumcirclearc")).usedirection=!0,(r=t.create("arc",[s,a[0],a[2],a[1]],n)).elType="circumcirclearc",r.setParents([a[0].id,a[1].id,a[2].id]),r.subs={center:s},r.inherits.push(s),r.center=s,r},t.registerElement("circumcirclearc",t.createCircumcircleArc),t.createMinorArc=function(e,i,r){return r.selection="minor",t.createArc(e,i,r)},t.registerElement("minorarc",t.createMinorArc),t.createMajorArc=function(e,i,r){return r.selection="major",t.createArc(e,i,r)},t.registerElement("majorarc",t.createMajorArc),{createArc:t.createArc,createSemicircle:t.createSemicircle,createCircumcircleArc:t.createCircumcircleArc,createMinorArc:t.createMinorArc,createMajorArc:t.createMajorArc}})),define("element/sector",["jxg","math/geometry","math/math","math/statistics","base/coords","base/constants","utils/type"],(function(t,e,i,r,s,o,n){"use strict";return t.createSector=function(a,h,l){var c,d,u,p,f,m,g="invalid";if(h[0].elementClass===o.OBJECT_CLASS_LINE&&h[1].elementClass===o.OBJECT_CLASS_LINE&&(n.isArray(h[2])||n.isNumber(h[2]))&&(n.isArray(h[3])||n.isNumber(h[3]))&&(n.isNumber(h[4])||n.isFunction(h[4])||n.isString(h[4])))g="2lines";else{if(!1===(m=n.providePoints(a,h,l,"sector",["center","radiusPoint","anglePoint"])))throw new Error("JSXGraph: Can't create Sector with parent types '"+typeof h[0]+"' and '"+typeof h[1]+"' and '"+typeof h[2]+"'.");g="3points"}if(d=n.copyAttributes(l,a.options,"sector"),(c=a.create("curve",[[0],[0]],d)).type=o.OBJECT_TYPE_SECTOR,c.elType="sector",c.autoRadius=function(){var t=20/c.board.unitX,e=1/0,i=50/c.board.unitX;return n.isPoint(c.center)&&(e=.3333*c.center.Dist(c.point2)),Math.max(t,Math.min(e,i))},"2lines"===g)c.Radius=function(){var t=n.evaluate(h[4]);return"auto"===t?this.autoRadius():t},c.line1=a.select(h[0]),c.line2=a.select(h[1]),c.line1.addChild(c),c.line2.addChild(c),c.setParents(h),c.point1={visProp:{}},c.point2={visProp:{}},c.point3={visProp:{}},p=e.meetLineLine(c.line1.stdform,c.line2.stdform,0,a),n.isArray(h[2])?(2===h[2].length&&(h[2]=[1].concat(h[2])),f=e.projectPointToLine({coords:{usrCoords:h[2]}},c.line1,a),f=r.subtract(f.usrCoords,p.usrCoords),c.direction1=i.innerProduct(f,[0,c.line1.stdform[2],-c.line1.stdform[1]],3)>=0?1:-1):c.direction1=h[2]>=0?1:-1,n.isArray(h[3])?(2===h[3].length&&(h[3]=[1].concat(h[3])),f=e.projectPointToLine({coords:{usrCoords:h[3]}},c.line2,a),f=r.subtract(f.usrCoords,p.usrCoords),c.direction2=i.innerProduct(f,[0,c.line2.stdform[2],-c.line2.stdform[1]],3)>=0?1:-1):c.direction2=h[3]>=0?1:-1,c.updateDataArray=function(){var t,n,a,h,l,d,u=[0,0,0];if(n=this.line1,a=this.line2,u=i.crossProduct(n.stdform,a.stdform),Math.abs(u[0])>i.eps*i.eps&&(u[1]/=u[0],u[2]/=u[0],u[0]/=u[0]),t=this.direction1*this.Radius(),h=r.add(u,[0,t*n.stdform[2],-t*n.stdform[1]]),t=this.direction2*this.Radius(),l=r.add(u,[0,t*a.stdform[2],-t*a.stdform[1]]),this.point2.coords=new s(o.COORDS_BY_USER,h,c.board),this.point1.coords=new s(o.COORDS_BY_USER,u,c.board),this.point3.coords=new s(o.COORDS_BY_USER,l,c.board),Math.abs(h[0])<i.eps||Math.abs(u[0])<i.eps||Math.abs(l[0])<i.eps)return this.dataX=[NaN],void(this.dataY=[NaN]);d=e.bezierArc(h,u,l,!0,1),this.dataX=d[0],this.dataY=d[1],this.bezierDegree=3},c.methodMap=t.deepCopy(c.methodMap,{radius:"Radius",getRadius:"Radius",setRadius:"setRadius"});else if("3points"===g){for(c.point1=m[0],c.point2=m[1],c.point3=m[2],u=0;u<3;u++)n.exists(m[u]._is_new)?(c.addChild(m[u]),delete m[u]._is_new):m[u].addChild(c);c.useDirection=l.usedirection,c.setParents(m),n.exists(m[3])&&(c.point4=m[3],c.point4.addChild(c)),c.methodMap=t.deepCopy(c.methodMap,{arc:"arc",center:"center",radiuspoint:"radiuspoint",anglepoint:"anglepoint",radius:"Radius",getRadius:"Radius",setRadius:"setRadius"}),c.updateDataArray=function(){var t,i,r,s,o,a=this.point2,h=this.point1,l=this.point3,c=1,d=n.evaluate(this.visProp.selection);if(!a.isReal||!h.isReal||!l.isReal)return this.dataX=[NaN],void(this.dataY=[NaN]);o=e.rad(a,h,l),("minor"===d&&o>Math.PI||"major"===d&&o<Math.PI)&&(c=-1),this.useDirection&&n.exists(this.point4)&&(i=this.point2.coords.usrCoords,r=this.point4.coords.usrCoords,s=this.point3.coords.usrCoords,(i[1]-s[1])*(i[2]-r[2])-(i[2]-s[2])*(i[1]-r[1])>=0&&(l=this.point2,a=this.point3)),a=a.coords.usrCoords,h=h.coords.usrCoords,l=l.coords.usrCoords,t=e.bezierArc(a,h,l,!0,c),this.dataX=t[0],this.dataY=t[1],this.bezierDegree=3},c.Radius=function(){return this.point2.Dist(this.point1)},(d=n.copyAttributes(l,a.options,"sector","arc")).withLabel=!1,d.name+="_arc",c.arc=a.create("arc",[c.point1,c.point2,c.point3],d),c.addChild(c.arc)}return c.center=c.point1,c.radiuspoint=c.point2,c.anglepoint=c.point3,c.hasPointCurve=function(t,i){var r,a,h,l,c,d,u=new s(o.COORDS_BY_SCREEN,[t,i],this.board),p=this.Radius(),f=this.center.coords.distance(o.COORDS_BY_USER,u),m=n.evaluate(this.visProp.selection);return n.isObject(n.evaluate(this.visProp.precision))?(c=this.board._inputDevice,l=n.evaluate(this.visProp.precision[c])):l=this.board.options.precision.hasPoint,l/=Math.min(this.board.unitX,this.board.unitY),(d=Math.abs(f-p)<l)&&(r=e.rad(this.point2,this.center,u.usrCoords.slice(1)),a=0,h=e.rad(this.point2,this.center,this.point3),("minor"===m&&h>Math.PI||"major"===m&&h<Math.PI)&&(a=h,h=2*Math.PI),(r<a||r>h)&&(d=!1)),d},c.hasPointSector=function(t,i){var r,a,h,l=new s(o.COORDS_BY_SCREEN,[t,i],this.board),c=this.Radius(),d=this.point1.coords.distance(o.COORDS_BY_USER,l)<c,u=n.evaluate(this.visProp.selection);return d&&(r=e.rad(this.radiuspoint,this.center,l.usrCoords.slice(1)),a=0,h=e.rad(this.radiuspoint,this.center,this.anglepoint),("minor"===u&&h>Math.PI||"major"===u&&h<Math.PI)&&(a=h,h=2*Math.PI),(r<a||r>h)&&(d=!1)),d},c.hasPoint=function(t,e){return n.evaluate(this.visProp.highlightonsector)||n.evaluate(this.visProp.hasinnerpoints)?this.hasPointSector(t,e):this.hasPointCurve(t,e)},c.getTextAnchor=function(){return this.point1.coords},c.getLabelAnchor=function(){var t,i,r,a,h,l=e.rad(this.point2,this.point1,this.point3),c=13/this.board.unitX,d=13/this.board.unitY,u=this.point2.coords.usrCoords,p=this.point1.coords.usrCoords,f=u[1]-p[1],m=u[2]-p[2],g=n.evaluate(this.visProp.selection),b=this.label?this.label.visProp:this.visProp.label;return("minor"===g&&l>Math.PI||"major"===g&&l<Math.PI)&&(l=-(2*Math.PI-l)),r=(t=new s(o.COORDS_BY_USER,[p[1]+Math.cos(.5*l)*f-Math.sin(.5*l)*m,p[2]+Math.sin(.5*l)*f+Math.cos(.5*l)*m],this.board)).usrCoords[1]-p[1],a=t.usrCoords[2]-p[2],r=r*((h=Math.sqrt(r*r+a*a))+c)/h,a=a*(h+d)/h,i=[p[1]+r,p[2]+a],b.position=e.calcLabelQuadrant(e.rad([1,0],[0,0],i)),new s(o.COORDS_BY_USER,i,this.board)},c.setRadius=function(t){c.Radius=function(){var e=n.evaluate(t);return"auto"===e?this.autoRadius():e}},c.getRadius=function(){return t.deprecated("Sector.getRadius()","Sector.Radius()"),this.Radius()},"3points"===g&&(c.setPositionDirectly=function(t,e,i){var o,n=new s(t,e,this.board),a=new s(t,i,this.board);return c.point1.draggable()&&c.point2.draggable()&&c.point3.draggable()?(o=r.subtract(n.usrCoords,a.usrCoords),this.board.create("transform",o.slice(1),{type:"translate"}).applyOnce([c.point1,c.point2,c.point3]),this):this}),c.prepareUpdate().update(),c},t.registerElement("sector",t.createSector),t.createCircumcircleSector=function(t,e,i){var r,s,o,a;if(!1===(a=n.providePoints(t,e,i,"point")))throw new Error("JSXGraph: Can't create circumcircle sector with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"' and '"+typeof e[2]+"'.");return(s=t.create("circumcenter",a.slice(0,3),o)).dump=!1,o=n.copyAttributes(i,t.options,"circumcirclesector"),(r=t.create("sector",[s,a[0],a[2],a[1]],o)).elType="circumcirclesector",r.setParents(a),r.center=s,r.subs={center:s},r},t.registerElement("circumcirclesector",t.createCircumcircleSector),t.createMinorSector=function(e,i,r){return r.selection="minor",t.createSector(e,i,r)},t.registerElement("minorsector",t.createMinorSector),t.createMajorSector=function(e,i,r){return r.selection="major",t.createSector(e,i,r)},t.registerElement("majorsector",t.createMajorSector),t.createAngle=function(t,r,a){var h,l,c,d,u,p,f="invalid";if(r[0].elementClass===o.OBJECT_CLASS_LINE&&r[1].elementClass===o.OBJECT_CLASS_LINE&&(n.isArray(r[2])||n.isNumber(r[2]))&&(n.isArray(r[3])||n.isNumber(r[3])))f="2lines";else{if(!1===(p=n.providePoints(t,r,a,"point")))throw new Error("JSXGraph: Can't create angle with parent types '"+typeof r[0]+"' and '"+typeof r[1]+"' and '"+typeof r[2]+"'.");f="3points"}if(c=n.copyAttributes(a,t.options,"angle"),n.exists(c.name)&&""!==c.name||(c.name=t.generateName({type:o.OBJECT_TYPE_ANGLE})),l=n.exists(c.radius)?c.radius:0,"2lines"===f?(r.push(l),(h=t.create("sector",r,c)).updateDataArraySector=h.updateDataArray,h.setAngle=function(t){},h.free=function(t){}):((h=t.create("sector",[p[1],p[0],p[2]],c)).arc.visProp.priv=!0,h.point=h.point2=h.radiuspoint=p[0],h.pointsquare=h.point3=h.anglepoint=p[2],h.Radius=function(){var t=n.evaluate(l);return"auto"===t?h.autoRadius():t},h.updateDataArraySector=function(){var t,i,r=this.point2,s=this.point1,o=this.point3,a=this.Radius(),h=s.Dist(r),l=1,c=n.evaluate(this.visProp.selection);i=e.rad(r,s,o),("minor"===c&&i>Math.PI||"major"===c&&i<Math.PI)&&(l=-1),r=r.coords.usrCoords,s=s.coords.usrCoords,o=o.coords.usrCoords,r=[1,s[1]+(r[1]-s[1])*a/h,s[2]+(r[2]-s[2])*a/h],o=[1,s[1]+(o[1]-s[1])*a/h,s[2]+(o[2]-s[2])*a/h],t=e.bezierArc(r,s,o,!0,l),this.dataX=t[0],this.dataY=t[1],this.bezierDegree=3},h.setAngle=function(t){var e,r,s,o=this.anglepoint,a=this.radiuspoint;return o.draggable()&&(e=this.board.create("transform",[t,this.center],{type:"rotate"}),o.addTransform(a,e),e.update(),o.moveTo(i.matVecMult(e.matrix,a.coords.usrCoords)),s=n.isFunction(t)?function(){return 2*Math.PI-t()}:function(){return 2*Math.PI-t},r=this.board.create("transform",[s,this.center],{type:"rotate"}),o.coords.on("update",(function(){r.update(),a.moveTo(i.matVecMult(r.matrix,o.coords.usrCoords))})),o.setParents(a)),this},h.free=function(){var t=this.anglepoint;return t.transformations.length>0&&(t.transformations.pop(),t.isDraggable=!0,t.parents=[],t.coords.off("update")),this},h.setParents(p)),n.exists(h.visProp.text)&&h.label.setText(n.evaluate(h.visProp.text)),h.elType="angle",h.type=o.OBJECT_TYPE_ANGLE,h.subs={},h.updateDataArraySquare=function(){var t,r,s,o,n,a,h,l,c=this.Radius();"2lines"===f&&this.updateDataArraySector(),t=this.point2,r=this.point1,s=this.point3,t=t.coords.usrCoords,r=r.coords.usrCoords,s=s.coords.usrCoords,o=e.distance(t,r,3),n=e.distance(s,r,3),t=[1,r[1]+(t[1]-r[1])*c/o,r[2]+(t[2]-r[2])*c/o],s=[1,r[1]+(s[1]-r[1])*c/n,r[2]+(s[2]-r[2])*c/n],a=i.crossProduct(s,r),h=[-t[1]*a[1]-t[2]*a[2],t[0]*a[1],t[0]*a[2]],a=i.crossProduct(t,r),l=[-s[1]*a[1]-s[2]*a[2],s[0]*a[1],s[0]*a[2]],(a=i.crossProduct(h,l))[1]/=a[0],a[2]/=a[0],this.dataX=[r[1],t[1],a[1],s[1],r[1]],this.dataY=[r[2],t[2],a[2],s[2],r[2]],this.bezierDegree=1},h.updateDataArrayNone=function(){this.dataX=[NaN],this.dataY=[NaN],this.bezierDegree=1},h.updateDataArray=function(){var t=n.evaluate(this.visProp.type),r=e.trueAngle(this.point2,this.point1,this.point3),s=n.evaluate(this.visProp.selection);("minor"===s&&r>180||"major"===s&&r<180)&&(r=360-r),Math.abs(r-90)<n.evaluate(this.visProp.orthosensitivity)+i.eps&&(t=n.evaluate(this.visProp.orthotype)),"none"===t?this.updateDataArrayNone():"square"===t?this.updateDataArraySquare():"sector"===t?this.updateDataArraySector():"sectordot"===t&&(this.updateDataArraySector(),this.dot.visProp.visible||this.dot.setAttribute({visible:!0})),(!this.visProp.visible||"sectordot"!==t&&this.dot.visProp.visible)&&this.dot.setAttribute({visible:!1})},d=n.copyAttributes(a,t.options,"angle","dot"),h.dot=t.create("point",[function(){var t,r,s,o,a,l,c,d,u;return n.exists(h.dot)&&!h.dot.visProp.visible?[0,0]:(t=h.point2.coords.usrCoords,r=h.point1.coords.usrCoords,s=h.Radius(),o=e.distance(t,r,3),a=e.rad(h.point2,h.point1,h.point3),("minor"===(u=n.evaluate(h.visProp.selection))&&a>Math.PI||"major"===u&&a<Math.PI)&&(a=-(2*Math.PI-a)),a*=.5,l=Math.cos(a),c=Math.sin(a),t=[1,r[1]+(t[1]-r[1])*s/o,r[2]+(t[2]-r[2])*s/o],d=[[1,0,0],[r[1]-.5*r[1]*l+.5*r[2]*c,.5*l,.5*-c],[r[2]-.5*r[1]*c-.5*r[2]*l,.5*c,.5*l]],i.matVecMult(d,t))}],d),h.dot.dump=!1,h.subs.dot=h.dot,"2lines"===f)for(u=0;u<2;u++)t.select(r[u]).addChild(h.dot);else for(u=0;u<3;u++)t.select(p[u]).addChild(h.dot);return h.getLabelAnchor=function(){var t,r,a,l,c,d,u,p,f,m=12,g=n.evaluate(h.visProp.selection),b=this.label?this.label.visProp:this.visProp.label;return n.exists(this.label.visProp.fontSize)&&(m=n.evaluate(this.label.visProp.fontSize)),m/=this.board.unitX,r=h.point2.coords.usrCoords,a=h.point1.coords.usrCoords,l=h.Radius(),c=e.distance(r,a,3),d=e.rad(h.point2,h.point1,h.point3),("minor"===g&&d>Math.PI||"major"===g&&d<Math.PI)&&(d=-(2*Math.PI-d)),d*=.5,u=Math.cos(d),p=Math.sin(d),r=[1,a[1]+(r[1]-a[1])*l/c,a[2]+(r[2]-a[2])*l/c],f=[[1,0,0],[a[1]-.5*a[1]*u+.5*a[2]*p,.5*u,.5*-p],[a[2]-.5*a[1]*p-.5*a[2]*u,.5*p,.5*u]],(t=i.matVecMult(f,r))[1]/=t[0],t[2]/=t[0],t[0]/=t[0],c=e.distance(t,a,3),t=[t[0],a[1]+(t[1]-a[1])*(l+m)/c,a[2]+(t[2]-a[2])*(l+m)/c],b.position=e.calcLabelQuadrant(e.rad([1,0],[0,0],t)),new s(o.COORDS_BY_USER,t,this.board)},h.Value=function(){return e.rad(this.point2,this.point1,this.point3)},h.methodMap=n.deepCopy(h.methodMap,{Value:"Value",setAngle:"setAngle",free:"free"}),h},t.registerElement("angle",t.createAngle),t.createNonreflexAngle=function(i,r,s){var o;return s.selection="minor",(o=t.createAngle(i,r,s)).Value=function(){var t=e.rad(this.point2,this.point1,this.point3);return t<Math.PI?t:2*Math.PI-t},o},t.registerElement("nonreflexangle",t.createNonreflexAngle),t.createReflexAngle=function(i,r,s){var o;return s.selection="major",(o=t.createAngle(i,r,s)).Value=function(){var t=e.rad(this.point2,this.point1,this.point3);return t>=Math.PI?t:2*Math.PI-t},o},t.registerElement("reflexangle",t.createReflexAngle),{createSector:t.createSector,createCircumcircleSector:t.createCircumcircleSector,createMinorSector:t.createMinorSector,createMajorSector:t.createMajorSector,createAngle:t.createAngle,createReflexAngle:t.createReflexAngle,createNonreflexAngle:t.createNonreflexAngle}})),define("base/transformation",["jxg","base/constants","math/math","utils/type"],(function(t,e,i,r){"use strict";return t.Transformation=function(t,i,r){this.elementClass=e.OBJECT_CLASS_OTHER,this.type=e.OBJECT_TYPE_TRANSFORMATION,this.matrix=[[1,0,0],[0,1,0],[0,0,1]],this.board=t,this.isNumericMatrix=!1,this.setMatrix(t,i,r),this.methodMap={apply:"apply",applyOnce:"applyOnce",bindTo:"bindTo",bind:"bindTo",melt:"melt"}},t.Transformation.prototype={},t.extend(t.Transformation.prototype,{update:function(){return this},setMatrix:function(t,e,s){var o;for(this.isNumericMatrix=!0,o=0;o<s.length;o++)if("number"!=typeof s[o]){this.isNumericMatrix=!1;break}if("translate"===e){if(2!==s.length)throw new Error("JSXGraph: translate transformation needs 2 parameters.");this.evalParam=r.createEvalFunction(t,s,2),this.update=function(){this.matrix[1][0]=this.evalParam(0),this.matrix[2][0]=this.evalParam(1)}}else if("scale"===e){if(2!==s.length)throw new Error("JSXGraph: scale transformation needs 2 parameters.");this.evalParam=r.createEvalFunction(t,s,2),this.update=function(){this.matrix[1][1]=this.evalParam(0),this.matrix[2][2]=this.evalParam(1)}}else if("reflect"===e)s.length<4&&(s[0]=t.select(s[0])),2===s.length&&(s[1]=t.select(s[1])),4===s.length&&(this.evalParam=r.createEvalFunction(t,s,4)),this.update=function(){var t,e,r,o,n,a,h,l;1===s.length?h=s[0].stdform:2===s.length?h=i.crossProduct(s[1].coords.usrCoords,s[0].coords.usrCoords):4===s.length&&(h=i.crossProduct([1,this.evalParam(2),this.evalParam(3)],[1,this.evalParam(0),this.evalParam(1)])),t=h[1],e=h[2],a=(l=[-(r=h[0])*t,-r*e,t*t+e*e])[2],o=l[0]/l[2],n=l[1]/l[2],t=-h[2],e=h[1],this.matrix[1][1]=(t*t-e*e)/a,this.matrix[1][2]=2*t*e/a,this.matrix[2][1]=this.matrix[1][2],this.matrix[2][2]=-this.matrix[1][1],this.matrix[1][0]=o*(1-this.matrix[1][1])-n*this.matrix[1][2],this.matrix[2][0]=n*(1-this.matrix[2][2])-o*this.matrix[2][1]};else if("rotate"===e)3===s.length?this.evalParam=r.createEvalFunction(t,s,3):s.length>0&&s.length<=2&&(this.evalParam=r.createEvalFunction(t,s,1),2!==s.length||r.isArray(s[1])||(s[1]=t.select(s[1]))),this.update=function(){var t,e,i=this.evalParam(0),o=Math.cos(i),n=Math.sin(i);this.matrix[1][1]=o,this.matrix[1][2]=-n,this.matrix[2][1]=n,this.matrix[2][2]=o,s.length>1&&(3===s.length?(t=this.evalParam(1),e=this.evalParam(2)):r.isArray(s[1])?(t=s[1][0],e=s[1][1]):(t=s[1].X(),e=s[1].Y()),this.matrix[1][0]=t*(1-o)+e*n,this.matrix[2][0]=e*(1-o)-t*n)};else if("shear"===e){if(2!==s.length)throw new Error("JSXGraph: shear transformation needs 2 parameters.");this.evalParam=r.createEvalFunction(t,s,2),this.update=function(){this.matrix[1][2]=this.evalParam(0),this.matrix[2][1]=this.evalParam(1)}}else if("generic"===e){if(9!==s.length)throw new Error("JSXGraph: generic transformation needs 9 parameters.");this.evalParam=r.createEvalFunction(t,s,9),this.update=function(){this.matrix[0][0]=this.evalParam(0),this.matrix[0][1]=this.evalParam(1),this.matrix[0][2]=this.evalParam(2),this.matrix[1][0]=this.evalParam(3),this.matrix[1][1]=this.evalParam(4),this.matrix[1][2]=this.evalParam(5),this.matrix[2][0]=this.evalParam(6),this.matrix[2][1]=this.evalParam(7),this.matrix[2][2]=this.evalParam(8)}}},apply:function(t,e){return this.update(),r.exists(e)?i.matVecMult(this.matrix,t.initialCoords.usrCoords):i.matVecMult(this.matrix,t.coords.usrCoords)},applyOnce:function(t){var s,o,n;for(r.isArray(t)||(t=[t]),o=t.length,n=0;n<o;n++)this.update(),s=i.matVecMult(this.matrix,t[n].coords.usrCoords),t[n].coords.setCoordinates(e.COORDS_BY_USER,s)},bindTo:function(t){var e,i;if(r.isArray(t))for(i=t.length,e=0;e<i;e++)t[e].transformations.push(this);else t.transformations.push(this)},setProperty:function(e){t.deprecated("Transformation.setProperty()","Transformation.setAttribute()")},setAttribute:function(t){},melt:function(t){var e,i,r,s,o,n,a=[];for(i=t.matrix.length,r=this.matrix[0].length,e=0;e<i;e++)a[e]=[];for(this.update(),t.update(),e=0;e<i;e++)for(n=0;n<r;n++){for(o=0,s=0;s<i;s++)o+=t.matrix[e][s]*this.matrix[s][n];a[e][n]=o}return this.update=function(){var t=this.matrix.length,i=this.matrix[0].length;for(e=0;e<t;e++)for(n=0;n<i;n++)this.matrix[e][n]=a[e][n]},this},getParents:function(){var t=[[].concat.apply([],this.matrix)];return 0!==this.parents.length&&(t=this.parents),t}}),t.createTransform=function(e,i,r){return new t.Transformation(e,r.type,i)},t.registerElement("transform",t.createTransform),{Transformation:t.Transformation,createTransform:t.createTransform}})),define("element/composition",["jxg","math/math","math/geometry","math/numerics","base/coords","utils/type","base/constants","base/point","base/line","base/circle","base/transformation","base/composition","base/curve","base/polygon"],(function(t,e,i,r,s,o,n,a,h,l,c,d,u,p){"use strict";return t.createOrthogonalProjection=function(t,e,r){var s,a,h,l;if(e[0]=t.select(e[0]),e[1]=t.select(e[1]),o.isPointType(t,e[0])&&e[1].elementClass===n.OBJECT_CLASS_LINE)a=o.providePoints(t,[e[0]],r,"point")[0],s=e[1];else{if(!o.isPointType(t,e[1])||e[0].elementClass!==n.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create perpendicular point with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,line]");a=o.providePoints(t,[e[1]],r,"point")[0],s=e[0]}return l=o.copyAttributes(r,t.options,"orthogonalprojection"),h=t.create("point",[function(){return i.projectPointToLine(a,s,t)}],l),o.exists(a._is_new)?(h.addChild(a),delete a._is_new):a.addChild(h),s.addChild(h),h.elType="orthogonalprojection",h.setParents([a.id,h.id]),h.update(),h.generatePolynomial=function(){var t=s.point1.symbolic.x,e=s.point1.symbolic.y,i=s.point2.symbolic.x,r=s.point2.symbolic.y,o=a.symbolic.x,n=a.symbolic.y,l=h.symbolic.x,c=h.symbolic.y;return["("+e+")*("+l+")-("+e+")*("+i+")+("+c+")*("+i+")-("+t+")*("+c+")+("+t+")*("+r+")-("+l+")*("+r+")","("+n+")*("+e+")-("+n+")*("+r+")-("+c+")*("+e+")+("+c+")*("+r+")+("+o+")*("+t+")-("+o+")*("+i+")-("+l+")*("+t+")+("+l+")*("+i+")"]},h},t.createPerpendicular=function(t,e,i){var r,s,a,l;if(e[0]=t.select(e[0]),e[1]=t.select(e[1]),o.isPointType(t,e[0])&&e[1].elementClass===n.OBJECT_CLASS_LINE)s=e[1],r=o.providePoints(t,[e[0]],i,"point")[0];else{if(!o.isPointType(t,e[1])||e[0].elementClass!==n.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create perpendicular with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [line,point]");s=e[0],r=o.providePoints(t,[e[1]],i,"point")[0]}return l=o.copyAttributes(i,t.options,"perpendicular"),(a=h.createLine(t,[function(){return s.stdform[2]*r.X()-s.stdform[1]*r.Y()},function(){return-s.stdform[2]*r.Z()},function(){return s.stdform[1]*r.Z()}],l)).elType="perpendicular",a.setParents([s.id,r.id]),o.exists(r._is_new)?(a.addChild(r),delete r._is_new):r.addChild(a),s.addChild(a),a},t.createPerpendicularPoint=function(t,e,r){var s,a,h;if(e[0]=t.select(e[0]),e[1]=t.select(e[1]),o.isPointType(t,e[0])&&e[1].elementClass===n.OBJECT_CLASS_LINE)a=o.providePoints(t,[e[0]],r,"point")[0],s=e[1];else{if(!o.isPointType(t,e[1])||e[0].elementClass!==n.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create perpendicular point with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,line]");a=o.providePoints(t,[e[1]],r,"point")[0],s=e[0]}return h=t.create("point",[function(){return i.perpendicular(s,a,t)[0]}],r),o.exists(a._is_new)?(h.addChild(a),delete a._is_new):a.addChild(h),s.addChild(h),h.elType="perpendicularpoint",h.setParents([a.id,s.id]),h.update(),h.generatePolynomial=function(){var t=s.point1.symbolic.x,e=s.point1.symbolic.y,i=s.point2.symbolic.x,r=s.point2.symbolic.y,o=a.symbolic.x,n=a.symbolic.y,l=h.symbolic.x,c=h.symbolic.y;return["("+e+")*("+l+")-("+e+")*("+i+")+("+c+")*("+i+")-("+t+")*("+c+")+("+t+")*("+r+")-("+l+")*("+r+")","("+n+")*("+e+")-("+n+")*("+r+")-("+c+")*("+e+")+("+c+")*("+r+")+("+o+")*("+t+")-("+o+")*("+i+")-("+l+")*("+t+")+("+l+")*("+i+")"]},h},t.createPerpendicularSegment=function(e,r,s){var a,l,c,d,u;if(r[0]=e.select(r[0]),r[1]=e.select(r[1]),o.isPointType(e,r[0])&&r[1].elementClass===n.OBJECT_CLASS_LINE)l=r[1],a=o.providePoints(e,[r[0]],s,"point")[0];else{if(!o.isPointType(e,r[1])||r[0].elementClass!==n.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create perpendicular with parent types '"+typeof r[0]+"' and '"+typeof r[1]+"'.\nPossible parent types: [line,point]");l=r[0],a=o.providePoints(e,[r[1]],s,"point")[0]}return u=o.copyAttributes(s,e.options,"perpendicularsegment","point"),(d=t.createPerpendicularPoint(e,[l,a],u)).dump=!1,o.exists(s.layer)||(s.layer=e.options.layer.line),u=o.copyAttributes(s,e.options,"perpendicularsegment"),(c=h.createLine(e,[function(){return i.perpendicular(l,a,e)[1]?[d,a]:[a,d]}],u)).point=d,o.exists(a._is_new)?(c.addChild(a),delete a._is_new):a.addChild(c),l.addChild(c),c.elType="perpendicularsegment",c.setParents([a.id,l.id]),c.subs={point:d},c.inherits.push(d),c},t.createMidpoint=function(t,i,r){var s,a,h,l,c;for(l=0;l<i.length;++l)i[l]=t.select(i[l]);if(2===i.length&&o.isPointType(t,i[0])&&o.isPointType(t,i[1]))i=o.providePoints(t,i,r,"point"),s=i[0],a=i[1];else{if(1!==i.length||i[0].elementClass!==n.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create midpoint.\nPossible parent types: [point,point], [line]");s=i[0].point1,a=i[0].point2}return c=o.copyAttributes(r,t.options,"midpoint"),h=t.create("point",[function(){var t=s.coords.usrCoords[1]+a.coords.usrCoords[1];return isNaN(t)||Math.abs(s.coords.usrCoords[0])<e.eps||Math.abs(a.coords.usrCoords[0])<e.eps?NaN:.5*t},function(){var t=s.coords.usrCoords[2]+a.coords.usrCoords[2];return isNaN(t)||Math.abs(s.coords.usrCoords[0])<e.eps||Math.abs(a.coords.usrCoords[0])<e.eps?NaN:.5*t}],c),o.exists(s._is_new)?(h.addChild(s),delete s._is_new):s.addChild(h),o.exists(a._is_new)?(h.addChild(a),delete a._is_new):a.addChild(h),h.elType="midpoint",h.setParents([s.id,a.id]),h.prepareUpdate().update(),h.generatePolynomial=function(){var t=s.symbolic.x,e=s.symbolic.y,i=a.symbolic.x,r=a.symbolic.y,o=h.symbolic.x,n=h.symbolic.y;return["("+e+")*("+o+")-("+e+")*("+i+")+("+n+")*("+i+")-("+t+")*("+n+")+("+t+")*("+r+")-("+o+")*("+r+")","("+t+")^2 - 2*("+t+")*("+o+")+("+e+")^2-2*("+e+")*("+n+")-("+i+")^2+2*("+i+")*("+o+")-("+r+")^2+2*("+r+")*("+n+")"]},h},t.createParallelPoint=function(t,e,i){var r,s,a,h,l;for(l=0;l<e.length;++l)e[l]=t.select(e[l]);if(3===e.length&&o.isPointType(t,e[0])&&o.isPointType(t,e[1])&&o.isPointType(t,e[2]))e=o.providePoints(t,e,i,"point"),r=e[0],s=e[1],a=e[2];else if(o.isPointType(t,e[0])&&e[1].elementClass===n.OBJECT_CLASS_LINE)a=o.providePoints(t,[e[0]],i,"point")[0],r=e[1].point1,s=e[1].point2;else{if(!o.isPointType(t,e[1])||e[0].elementClass!==n.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create parallel point with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [line,point], [point,point,point]");a=o.providePoints(t,[e[1]],i,"point")[0],r=e[0].point1,s=e[0].point2}return h=t.create("point",[function(){return a.coords.usrCoords[1]+s.coords.usrCoords[1]-r.coords.usrCoords[1]},function(){return a.coords.usrCoords[2]+s.coords.usrCoords[2]-r.coords.usrCoords[2]}],i),o.exists(r._is_new)?(h.addChild(r),delete r._is_new):r.addChild(h),o.exists(s._is_new)?(h.addChild(s),delete s._is_new):s.addChild(h),o.exists(a._is_new)?(h.addChild(a),delete a._is_new):a.addChild(h),h.elType="parallelpoint",h.setParents([r.id,s.id,a.id]),h.prepareUpdate().update(),h.generatePolynomial=function(){var t=r.symbolic.x,e=r.symbolic.y,i=s.symbolic.x,o=s.symbolic.y,n=a.symbolic.x,l=a.symbolic.y,c=h.symbolic.x,d=h.symbolic.y;return["("+o+")*("+c+")-("+o+")*("+n+")-("+e+")*("+c+")+("+e+")*("+n+")-("+d+")*("+i+")+("+d+")*("+t+")+("+l+")*("+i+")-("+l+")*("+t+")","("+d+")*("+t+")-("+d+")*("+n+")-("+o+")*("+t+")+("+o+")*("+n+")-("+c+")*("+e+")+("+c+")*("+l+")+("+i+")*("+e+")-("+i+")*("+l+")"]},h},t.createParallel=function(t,i,r){var s,n,a,h,l,c;for(l=0;l<i.length;++l)i[l]=t.select(i[l]);return s=null,3===i.length?(s=(i=o.providePoints(t,i,r,"point"))[2],h=function(){return e.crossProduct(i[0].coords.usrCoords,i[1].coords.usrCoords)}):o.isPointType(t,i[0])?(s=o.providePoints(t,[i[0]],r,"point")[0],h=function(){return i[1].stdform}):o.isPointType(t,i[1])&&(s=o.providePoints(t,[i[1]],r,"point")[0],h=function(){return i[0].stdform}),o.exists(r.layer)||(r.layer=t.options.layer.line),c=o.copyAttributes(r,t.options,"parallel","point"),(n=t.create("point",[function(){return e.crossProduct([1,0,0],h())}],c)).isDraggable=!0,c=o.copyAttributes(r,t.options,"parallel"),(a=t.create("line",[s,n],c)).elType="parallel",a.subs={point:n},a.inherits.push(n),a.setParents([i[0].id,i[1].id]),3===i.length&&a.addParents(i[2].id),a.point=n,a},t.createArrowParallel=function(e,i,r){var s;try{return r.firstArrow=!1,r.lastArrow=!0,(s=t.createParallel(e,i,r).setAttribute({straightFirst:!1,straightLast:!1})).elType="arrowparallel",s}catch(t){throw new Error("JSXGraph: Can't create arrowparallel with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [line,point], [point,point,point]")}},t.createNormal=function(t,i,s){var a,h,l,c,d,u,p,f,m;for(c=0;c<i.length;++c)i[c]=t.select(i[c]);if(1===i.length)a=i[0],h=a.slideObject;else{if(2!==i.length)throw new Error("JSXGraph: Can't create normal with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [point,line], [point,circle], [glider]");if(o.isPointType(t,i[0]))a=o.providePoints(t,[i[0]],s,"point")[0],h=i[1];else{if(!o.isPointType(t,i[1]))throw new Error("JSXGraph: Can't create normal with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [point,line], [point,circle], [glider]");h=i[0],a=o.providePoints(t,[i[1]],s,"point")[0]}}if(p=o.copyAttributes(s,t.options,"normal"),h.elementClass===n.OBJECT_CLASS_LINE)m=o.copyAttributes(s,t.options,"normal","point"),f=t.create("point",[function(){var t=e.crossProduct([1,0,0],h.stdform);return[t[0],-t[2],t[1]]}],m),f.isDraggable=!0,(l=t.create("line",[a,f],p)).point=f,l.subs={point:f},l.inherits.push(f);else if(h.elementClass===n.OBJECT_CLASS_CIRCLE)l=t.create("line",[h.midpoint,a],p);else if(h.elementClass===n.OBJECT_CLASS_CURVE)"plot"!==o.evaluate(h.visProp.curvetype)?(d=h.X,u=h.Y,l=t.create("line",[function(){return-a.X()*r.D(d)(a.position)-a.Y()*r.D(u)(a.position)},function(){return r.D(d)(a.position)},function(){return r.D(u)(a.position)}],p)):l=t.create("line",[function(){var t,e,i,r,s,o,n,l,c,d,u=Math.floor(a.position),p=a.position-u;if(1===h.bezierdegree)u===h.numberPoints-1&&(u-=1,p=1);else{if(3!==h.bezierDegree)return 0;u=3*Math.floor(a.position*(h.numberPoints-1)/3),i=(a.position*(h.numberPoints-1)-u)/3,u>=h.numberPoints-1&&(u=h.numberPoints-4,i=1)}return u<0?1:1===h.bezierDegree?(h.Y(u)+p*(h.Y(u+1)-h.Y(u)))*(h.Y(u)-h.Y(u+1))-(h.X(u)+p*(h.X(u+1)-h.X(u)))*(h.X(u+1)-h.X(u)):(r=h.points[u].usrCoords,s=h.points[u+1].usrCoords,o=h.points[u+2].usrCoords,n=h.points[u+3].usrCoords,l=(1-i)*(1-i)*(s[1]-r[1])+2*(1-i)*i*(o[1]-s[1])+i*i*(n[1]-o[1]),c=(1-i)*(1-i)*(s[2]-r[2])+2*(1-i)*i*(o[2]-s[2])+i*i*(n[2]-o[2]),l/=d=Math.sqrt(l*l+c*c),c/=d,e=[1,(t=a.coords.usrCoords)[1]-c,t[2]+l],t[2]*e[1]-t[1]*e[2])},function(){var t,e,i,r,s,o,n,l,c,d=Math.floor(a.position);if(1===h.bezierdegree)d===h.numberPoints-1&&(d-=1);else{if(3!==h.bezierDegree)return 0;d=3*Math.floor(a.position*(h.numberPoints-1)/3),e=(a.position*(h.numberPoints-1)-d)/3,d>=h.numberPoints-1&&(d=h.numberPoints-4,e=1)}return d<0?0:1===h.bezierDegree?h.X(d+1)-h.X(d):(i=h.points[d].usrCoords,r=h.points[d+1].usrCoords,s=h.points[d+2].usrCoords,o=h.points[d+3].usrCoords,n=(1-e)*(1-e)*(r[1]-i[1])+2*(1-e)*e*(s[1]-r[1])+e*e*(o[1]-s[1]),l=(1-e)*(1-e)*(r[2]-i[2])+2*(1-e)*e*(s[2]-r[2])+e*e*(o[2]-s[2]),n/=c=Math.sqrt(n*n+l*l),l/=c,[1,(t=a.coords.usrCoords)[1]-l,t[2]+n][2]-t[2])},function(){var t,e,i,r,s,o,n,l,c,d,u=Math.floor(a.position);if(1===h.bezierdegree)u===h.numberPoints-1&&(u-=1);else{if(3!==h.bezierDegree)return 0;u=3*Math.floor(a.position*(h.numberPoints-1)/3),i=(a.position*(h.numberPoints-1)-u)/3,u>=h.numberPoints-1&&(u=h.numberPoints-4,i=1)}return u<0?0:1===h.bezierDegree?h.Y(u+1)-h.Y(u):(r=h.points[u].usrCoords,s=h.points[u+1].usrCoords,o=h.points[u+2].usrCoords,n=h.points[u+3].usrCoords,l=(1-i)*(1-i)*(s[1]-r[1])+2*(1-i)*i*(o[1]-s[1])+i*i*(n[1]-o[1]),c=(1-i)*(1-i)*(s[2]-r[2])+2*(1-i)*i*(o[2]-s[2])+i*i*(n[2]-o[2]),l/=d=Math.sqrt(l*l+c*c),c/=d,e=[1,(t=a.coords.usrCoords)[1]-c,t[2]+l],t[1]-e[1])}],p);else{if(h.type!==n.OBJECT_TYPE_TURTLE)throw new Error("JSXGraph: Can't create normal with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [point,line], [point,circle], [glider]");l=t.create("line",[function(){var t,e,i=Math.floor(a.position),r=a.position-i;for(e=0;e<h.objects.length;e++)if((t=h.objects[e]).type===n.OBJECT_TYPE_CURVE){if(i<t.numberPoints)break;i-=t.numberPoints}return i===t.numberPoints-1&&(i-=1,r=1),i<0?1:(t.Y(i)+r*(t.Y(i+1)-t.Y(i)))*(t.Y(i)-t.Y(i+1))-(t.X(i)+r*(t.X(i+1)-t.X(i)))*(t.X(i+1)-t.X(i))},function(){var t,e,i=Math.floor(a.position);for(e=0;e<h.objects.length;e++)if((t=h.objects[e]).type===n.OBJECT_TYPE_CURVE){if(i<t.numberPoints)break;i-=t.numberPoints}return i===t.numberPoints-1&&(i-=1),i<0?0:t.X(i+1)-t.X(i)},function(){var t,e,i=Math.floor(a.position);for(e=0;e<h.objects.length;e++)if((t=h.objects[e]).type===n.OBJECT_TYPE_CURVE){if(i<t.numberPoints)break;i-=t.numberPoints}return i===t.numberPoints-1&&(i-=1),i<0?0:t.Y(i+1)-t.Y(i)}],p)}return l.elType="normal",l.setParents(i),o.exists(a._is_new)?(l.addChild(a),delete a._is_new):a.addChild(l),h.addChild(l),l},t.createBisector=function(t,e,r){var s,n,a,l;if(e=o.providePoints(t,e,r,"point"),o.isPoint(e[0])&&o.isPoint(e[1])&&o.isPoint(e[2])){for((l=o.copyAttributes(r,t.options,"bisector","point")).snapToGrid=!1,(s=t.create("point",[function(){return i.angleBisector(e[0],e[1],e[2],t)}],l)).dump=!1,a=0;a<3;a++)o.exists(e[a]._is_new)?(s.addChild(e[a]),delete e[a]._is_new):e[a].addChild(s);return o.exists(r.layer)||(r.layer=t.options.layer.line),l=o.copyAttributes(r,t.options,"bisector"),(n=h.createLine(t,[e[1],s],l)).point=s,n.elType="bisector",n.setParents(e),n.subs={point:s},n.inherits.push(s),n}throw new Error("JSXGraph: Can't create angle bisector with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [point,point,point]")},t.createAngularBisectorsOfTwoLines=function(t,e,i){var r,s,a,h,l=t.select(e[0]),c=t.select(e[1]);if(l.elementClass!==n.OBJECT_CLASS_LINE||c.elementClass!==n.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create angle bisectors of two lines with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'.\nPossible parent types: [line,line]");return o.exists(i.layer)||(i.layer=t.options.layer.line),a=o.copyAttributes(i,t.options,"bisectorlines","line1"),r=t.create("line",[function(){var t=Math.sqrt(l.stdform[1]*l.stdform[1]+l.stdform[2]*l.stdform[2]),e=Math.sqrt(c.stdform[1]*c.stdform[1]+c.stdform[2]*c.stdform[2]);return l.stdform[0]/t-c.stdform[0]/e},function(){var t=Math.sqrt(l.stdform[1]*l.stdform[1]+l.stdform[2]*l.stdform[2]),e=Math.sqrt(c.stdform[1]*c.stdform[1]+c.stdform[2]*c.stdform[2]);return l.stdform[1]/t-c.stdform[1]/e},function(){var t=Math.sqrt(l.stdform[1]*l.stdform[1]+l.stdform[2]*l.stdform[2]),e=Math.sqrt(c.stdform[1]*c.stdform[1]+c.stdform[2]*c.stdform[2]);return l.stdform[2]/t-c.stdform[2]/e}],a),o.exists(i.layer)||(i.layer=t.options.layer.line),a=o.copyAttributes(i,t.options,"bisectorlines","line2"),s=t.create("line",[function(){var t=Math.sqrt(l.stdform[1]*l.stdform[1]+l.stdform[2]*l.stdform[2]),e=Math.sqrt(c.stdform[1]*c.stdform[1]+c.stdform[2]*c.stdform[2]);return l.stdform[0]/t+c.stdform[0]/e},function(){var t=Math.sqrt(l.stdform[1]*l.stdform[1]+l.stdform[2]*l.stdform[2]),e=Math.sqrt(c.stdform[1]*c.stdform[1]+c.stdform[2]*c.stdform[2]);return l.stdform[1]/t+c.stdform[1]/e},function(){var t=Math.sqrt(l.stdform[1]*l.stdform[1]+l.stdform[2]*l.stdform[2]),e=Math.sqrt(c.stdform[1]*c.stdform[1]+c.stdform[2]*c.stdform[2]);return l.stdform[2]/t+c.stdform[2]/e}],a),h=new d({line1:r,line2:s}),r.dump=!1,s.dump=!1,h.elType="bisectorlines",h.setParents([l.id,c.id]),h.subs={line1:r,line2:s},h},t.createCircumcenter=function(t,e,r){var s,n,h,l,c;if(e=o.providePoints(t,e,r,"point"),o.isPoint(e[0])&&o.isPoint(e[1])&&o.isPoint(e[2])){for(h=e[0],l=e[1],c=e[2],s=a.createPoint(t,[function(){return i.circumcenter(h,l,c,t)}],r),n=0;n<3;n++)o.exists(e[n]._is_new)?(s.addChild(e[n]),delete e[n]._is_new):e[n].addChild(s);return s.elType="circumcenter",s.setParents(e),s.generatePolynomial=function(){var t=h.symbolic.x,e=h.symbolic.y,i=l.symbolic.x,r=l.symbolic.y,o=c.symbolic.x,n=c.symbolic.y,a=s.symbolic.x,d=s.symbolic.y;return[["((",a,")-(",t,"))^2+((",d,")-(",e,"))^2-((",a,")-(",i,"))^2-((",d,")-(",r,"))^2"].join(""),["((",a,")-(",t,"))^2+((",d,")-(",e,"))^2-((",a,")-(",o,"))^2-((",d,")-(",n,"))^2"].join("")]},s}throw new Error("JSXGraph: Can't create circumcircle midpoint with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]")},t.createIncenter=function(t,e,i){var r,a,h,l,c;if(!((e=o.providePoints(t,e,i,"point")).length>=3&&o.isPoint(e[0])&&o.isPoint(e[1])&&o.isPoint(e[2])))throw new Error("JSXGraph: Can't create incenter with parent types '"+typeof e[0]+"', '"+typeof e[1]+"' and '"+typeof e[2]+"'.\nPossible parent types: [point,point,point]");for(a=e[0],h=e[1],l=e[2],r=t.create("point",[function(){var e,i,r;return e=Math.sqrt((h.X()-l.X())*(h.X()-l.X())+(h.Y()-l.Y())*(h.Y()-l.Y())),i=Math.sqrt((a.X()-l.X())*(a.X()-l.X())+(a.Y()-l.Y())*(a.Y()-l.Y())),r=Math.sqrt((h.X()-a.X())*(h.X()-a.X())+(h.Y()-a.Y())*(h.Y()-a.Y())),new s(n.COORDS_BY_USER,[(e*a.X()+i*h.X()+r*l.X())/(e+i+r),(e*a.Y()+i*h.Y()+r*l.Y())/(e+i+r)],t)}],i),c=0;c<3;c++)o.exists(e[c]._is_new)?(r.addChild(e[c]),delete e[c]._is_new):e[c].addChild(r);return r.elType="incenter",r.setParents(e),r},t.createCircumcircle=function(e,i,r){var s,n,a,h;if(!1===(i=o.providePoints(e,i,r,"point")))throw new Error("JSXGraph: Can't create circumcircle with parent types '"+typeof i[0]+"', '"+typeof i[1]+"' and '"+typeof i[2]+"'.\nPossible parent types: [point,point,point]");try{for(a=o.copyAttributes(r,e.options,"circumcircle","center"),(s=t.createCircumcenter(e,i,a)).dump=!1,o.exists(r.layer)||(r.layer=e.options.layer.circle),a=o.copyAttributes(r,e.options,"circumcircle"),(n=l.createCircle(e,[s,i[0]],a)).elType="circumcircle",n.setParents(i),n.subs={center:s},n.inherits.push(n),h=0;h<3;h++)o.exists(i[h]._is_new)?(n.addChild(i[h]),delete i[h]._is_new):i[h].addChild(n)}catch(t){throw new Error("JSXGraph: Can't create circumcircle with parent types '"+typeof i[0]+"', '"+typeof i[1]+"' and '"+typeof i[2]+"'.\nPossible parent types: [point,point,point]")}return n},t.createIncircle=function(e,i,r){var s,n,a,h;if(!1===(i=o.providePoints(e,i,r,"point")))throw new Error("JSXGraph: Can't create circumcircle with parent types '"+typeof i[0]+"', '"+typeof i[1]+"' and '"+typeof i[2]+"'.\nPossible parent types: [point,point,point]");try{for(h=o.copyAttributes(r,e.options,"incircle","center"),(n=t.createIncenter(e,i,h)).dump=!1,o.exists(r.layer)||(r.layer=e.options.layer.circle),h=o.copyAttributes(r,e.options,"incircle"),(a=l.createCircle(e,[n,function(){var t=Math.sqrt((i[1].X()-i[2].X())*(i[1].X()-i[2].X())+(i[1].Y()-i[2].Y())*(i[1].Y()-i[2].Y())),e=Math.sqrt((i[0].X()-i[2].X())*(i[0].X()-i[2].X())+(i[0].Y()-i[2].Y())*(i[0].Y()-i[2].Y())),r=Math.sqrt((i[1].X()-i[0].X())*(i[1].X()-i[0].X())+(i[1].Y()-i[0].Y())*(i[1].Y()-i[0].Y())),s=(t+e+r)/2;return Math.sqrt((s-t)*(s-e)*(s-r)/s)}],h)).elType="incircle",a.setParents(i),s=0;s<3;s++)o.exists(i[s]._is_new)?(a.addChild(i[s]),delete i[s]._is_new):i[s].addChild(a);a.center=n,a.subs={center:a.center},a.inherits.push(n)}catch(t){throw new Error("JSXGraph: Can't create circumcircle with parent types '"+typeof i[0]+"', '"+typeof i[1]+"' and '"+typeof i[2]+"'.\nPossible parent types: [point,point,point]")}return a},t.createReflection=function(t,e,i){var r,s,d,f,m,g,b,v,y="\nPossible parent types: [point|line|curve|polygon|circle|arc|sector, line]";for(g=0;g<e.length;++g)e[g]=t.select(e[g]);if(b=o.copyAttributes(i,t.options,"reflection"),o.isPoint(e[0]))s=o.providePoints(t,[e[0]],v)[0];else{if(e[0].elementClass!==n.OBJECT_CLASS_CURVE&&e[0].elementClass!==n.OBJECT_CLASS_LINE&&e[0].type!==n.OBJECT_TYPE_POLYGON&&e[0].elementClass!==n.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create reflection element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+y);s=e[0]}if(e[1].elementClass!==n.OBJECT_CLASS_LINE)throw new Error("JSXGraph: Can't create reflected element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+y);if(r=e[1],m=c.createTransform(t,[r],{type:"reflect"}),o.isPoint(s))d=a.createPoint(t,[s,m],b);else if(s.elementClass===n.OBJECT_CLASS_CURVE)d=u.createCurve(t,[s,m],b);else if(s.elementClass===n.OBJECT_CLASS_LINE)d=h.createLine(t,[s,m],b);else if(s.type===n.OBJECT_TYPE_POLYGON)d=p.createPolygon(t,[s,m],b);else{if(s.elementClass!==n.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create reflected element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+y);"euclidean"===b.type.toLowerCase()?(v=o.copyAttributes(i,t.options,"reflection","center"),(f=a.createPoint(t,[s.center,m],v)).prepareUpdate().update().updateVisibility(o.evaluate(f.visProp.visible)).updateRenderer(),d=l.createCircle(t,[f,function(){return s.Radius()}],b)):d=l.createCircle(t,[s,m],b)}return o.exists(s._is_new)&&(d.addChild(s),delete s._is_new),r.addChild(d),d.elType="reflection",d.addParents(r),d.prepareUpdate().update(),o.isPoint(d)&&(d.generatePolynomial=function(){var t=r.point1.symbolic.x,e=r.point1.symbolic.y,i=r.point2.symbolic.x,o=r.point2.symbolic.y,n=s.symbolic.x,a=s.symbolic.y,h=d.symbolic.x,l=d.symbolic.y;return[["((",l,")-(",a,"))*((",e,")-(",o,"))+((",t,")-(",i,"))*((",h,")-(",n,"))"].join(""),["((",h,")-(",t,"))^2+((",l,")-(",e,"))^2-((",n,")-(",t,"))^2-((",a,")-(",e,"))^2"].join("")]}),d},t.createMirrorElement=function(t,e,i){var r,s,d,f,m,g,b,v,y="\nPossible parent types: [point|line|curve|polygon|circle|arc|sector, point]";for(s=0;s<e.length;++s)e[s]=t.select(e[s]);if(b=o.copyAttributes(i,t.options,"mirrorelement"),o.isPoint(e[0]))r=o.providePoints(t,[e[0]],b)[0];else{if(e[0].elementClass!==n.OBJECT_CLASS_CURVE&&e[0].elementClass!==n.OBJECT_CLASS_LINE&&e[0].type!==n.OBJECT_TYPE_POLYGON&&e[0].elementClass!==n.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create mirror element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+y);r=e[0]}if(!o.isPoint(e[1]))throw new Error("JSXGraph: Can't create mirror element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+y);if(v=o.copyAttributes(i,t.options,"mirrorelement","point"),d=o.providePoints(t,[e[1]],v)[0],g=c.createTransform(t,[Math.PI,d],{type:"rotate"}),o.isPoint(r))f=a.createPoint(t,[r,g],b);else if(r.elementClass===n.OBJECT_CLASS_CURVE)f=u.createCurve(t,[r,g],b);else if(r.elementClass===n.OBJECT_CLASS_LINE)f=h.createLine(t,[r,g],b);else if(r.type===n.OBJECT_TYPE_POLYGON)f=p.createPolygon(t,[r,g],b);else{if(r.elementClass!==n.OBJECT_CLASS_CIRCLE)throw new Error("JSXGraph: Can't create mirror element with parent types '"+typeof e[0]+"' and '"+typeof e[1]+"'."+y);"euclidean"===b.type.toLowerCase()?(v=o.copyAttributes(i,t.options,"mirrorelement","center"),(m=a.createPoint(t,[r.center,g],v)).prepareUpdate().update().updateVisibility(o.evaluate(m.visProp.visible)).updateRenderer(),f=l.createCircle(t,[m,function(){return r.Radius()}],b)):f=l.createCircle(t,[r,g],b)}return o.exists(r._is_new)&&(f.addChild(r),delete r._is_new),d.addChild(f),f.elType="mirrorelement",f.addParents(d),f.prepareUpdate().update(),f},t.createMirrorPoint=function(e,i,r){var s=t.createMirrorElement(e,i,r);return s.elType="mirrorpoint",s},t.createIntegral=function(e,i,a){var h,l,c,d,u,p,f,m,g,b,v,y,C,_,P=null;if(o.isArray(i[0])&&i[1].elementClass===n.OBJECT_CLASS_CURVE)h=i[0],l=i[1];else{if(!o.isArray(i[1])||i[0].elementClass!==n.OBJECT_CLASS_CURVE)throw new Error("JSXGraph: Can't create integral with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [[number|function,number|function],curve]");h=i[1],l=i[0]}return(c=o.copyAttributes(a,e.options,"integral")).withLabel=!1,_=e.create("curve",[[0],[0]],c),d=h[0],u=h[1],o.isFunction(d)?(f=function(){return l.Y(p())},d=(p=d)()):(p=d,f=l.Y(d)),o.isFunction(u)?(g=function(){return l.Y(m())},u=(m=u)()):(m=u,g=l.Y(u)),c=o.copyAttributes(a,e.options,"integral","curveLeft"),b=e.create("glider",[p,f,l],c),o.isFunction(p)&&b.hideElement(),c=o.copyAttributes(a,e.options,"integral","baseLeft"),v=e.create("point",[function(){return"y"===o.evaluate(_.visProp.axis)?0:b.X()},function(){return"y"===o.evaluate(_.visProp.axis)?b.Y():0}],c),c=o.copyAttributes(a,e.options,"integral","curveRight"),y=e.create("glider",[m,g,l],c),o.isFunction(m)&&y.hideElement(),c=o.copyAttributes(a,e.options,"integral","baseRight"),C=e.create("point",[function(){return"y"===o.evaluate(_.visProp.axis)?0:y.X()},function(){return"y"===o.evaluate(_.visProp.axis)?y.Y():0}],c),!1!==(c=o.copyAttributes(a,e.options,"integral")).withlabel&&"y"!==c.axis&&(c=o.copyAttributes(a,e.options,"integral","label"),c=o.copyAttributes(c,e.options,"label"),(P=e.create("text",[function(){var t=new s(n.COORDS_BY_SCREEN,[o.evaluate(this.visProp.offset[0])+this.board.origin.scrCoords[1],0],this.board,!1),e=this.board.getBoundingBox(),i=.1*(e[2]-e[0]),r=y.X();return r<e[0]?r=e[0]+i:r>e[2]&&(r=e[2]-i),r+t.usrCoords[1]},function(){var t=new s(n.COORDS_BY_SCREEN,[0,o.evaluate(this.visProp.offset[1])+this.board.origin.scrCoords[2]],this.board,!1),e=this.board.getBoundingBox(),i=.1*(e[1]-e[3]),r=y.Y();return r>e[1]?r=e[1]-i:r<e[3]&&(r=e[3]+i),r+t.usrCoords[2]},function(){var t=r.NewtonCotes([v.X(),C.X()],l.Y);return"&int; = "+o.toFixed(t,4)}],c)).dump=!1,b.addChild(P),y.addChild(P)),b.dump=!1,v.dump=!1,y.dump=!1,C.dump=!1,_.elType="integral",_.setParents([l.id,h]),_.subs={curveLeft:b,baseLeft:v,curveRight:y,baseRight:C},_.inherits.push(b,v,y,C),c.withLabel&&(_.subs.label=P,_.inherits.push(P)),_.Value=function(){return r.I([v.X(),C.X()],l.Y)},_.updateDataArray=function(){var t,e,i,r,s,n,a,h,c;if("y"===o.evaluate(this.visProp.axis)){for(b.Y()<y.Y()?(n=b.X(),h=b.Y(),a=y.X(),c=y.Y()):(n=y.X(),h=y.Y(),a=b.X(),c=b.Y()),r=Math.min(n,a),s=Math.max(n,a),t=[0,n],e=[h,h],i=0;i<l.numberPoints;i++)h<=l.points[i].usrCoords[2]&&r<=l.points[i].usrCoords[1]&&l.points[i].usrCoords[2]<=c&&l.points[i].usrCoords[1]<=s&&(t.push(l.points[i].usrCoords[1]),e.push(l.points[i].usrCoords[2]));t.push(a),e.push(c),t.push(0),e.push(c),t.push(0),e.push(h)}else{for(v.X()<C.X()?(r=v.X(),s=C.X()):(r=C.X(),s=v.X()),t=[r,r],e=[0,l.Y(r)],i=0;i<l.numberPoints;i++)r<=l.points[i].usrCoords[1]&&l.points[i].usrCoords[1]<=s&&(t.push(l.points[i].usrCoords[1]),e.push(l.points[i].usrCoords[2]));t.push(s),e.push(l.Y(s)),t.push(s),e.push(0),t.push(r),e.push(0)}this.dataX=t,this.dataY=e},b.addChild(_),y.addChild(_),v.addChild(_),C.addChild(_),_.baseLeft=v,_.baseRight=C,_.curveLeft=b,_.curveRight=y,_.methodMap=t.deepCopy(_.methodMap,{curveLeft:"curveLeft",baseLeft:"baseLeft",curveRight:"curveRight",baseRight:"baseRight",Value:"Value"}),_.label=P,_},t.createGrid=function(t,e,i){var r,a;return a=o.copyAttributes(i,t.options,"grid"),(r=t.create("curve",[[null],[null]],a)).elType="grid",r.type=n.OBJECT_TYPE_GRID,r.updateDataArray=function(){var e,i,a,h,l,c=o.evaluate(this.visProp.gridx),d=o.evaluate(this.visProp.gridy);for(h=o.isArray(this.visProp.topleft)?new s(o.evaluate(this.visProp.tltype)||n.COORDS_BY_USER,this.visProp.topleft,t):new s(n.COORDS_BY_SCREEN,[0,0],t),l=o.isArray(this.visProp.bottomright)?new s(o.evaluate(this.visProp.brtype)||n.COORDS_BY_USER,this.visProp.bottomright,t):new s(n.COORDS_BY_SCREEN,[t.canvasWidth,t.canvasHeight],t),t.options.grid.hasGrid=!0,r.dataX=[],r.dataY=[],e=Math.floor(h.usrCoords[2]/d)*d,i=Math.ceil(l.usrCoords[2]/d)*d,h.usrCoords[2]<l.usrCoords[2]&&(e=Math.ceil(l.usrCoords[2]/d)*d,i=Math.floor(h.usrCoords[2]/d)*d),a=e;a>i-d;a-=d)r.dataX.push(h.usrCoords[1],l.usrCoords[1],NaN),r.dataY.push(a,a,NaN);for(e=Math.ceil(h.usrCoords[1]/c)*c,i=Math.floor(l.usrCoords[1]/c)*c,h.usrCoords[1]>l.usrCoords[1]&&(e=Math.floor(l.usrCoords[1]/c)*c,i=Math.ceil(h.usrCoords[1]/c)*c),a=e;a<i+c;a+=c)r.dataX.push(a,a,NaN),r.dataY.push(h.usrCoords[2],l.usrCoords[2],NaN)},r.hasPoint=function(){return!1},t.grids.push(r),r},t.createInequality=function(t,r,s){var a,h,l;if(l=o.copyAttributes(s,t.options,"inequality"),r[0].elementClass===n.OBJECT_CLASS_LINE)(h=t.create("curve",[[],[]],l)).hasPoint=function(){return!1},h.updateDataArray=function(){var s,o,a,h=t.getBoundingBox(),c=l.inverse?-1:1,d=1.5*Math.max(h[2]-h[0],h[1]-h[3]),u={coords:{usrCoords:[1,(h[0]+h[2])/2,l.inverse?h[1]:h[3]]}},p=r[0].stdform.slice(1),f=p;a=1.5*Math.max(i.perpendicular(r[0],u,t)[0].distance(n.COORDS_BY_USER,u.coords),d),a*=c,u={coords:{usrCoords:[1,(h[0]+h[2])/2,(h[1]+h[3])/2]}},s=[1,(u=Math.abs(e.innerProduct(u.coords.usrCoords,r[0].stdform,3))>=e.eps?i.perpendicular(r[0],u,t)[0].usrCoords:u.coords.usrCoords)[1]+p[1]*d,u[2]-p[0]*d],o=[1,u[1]-f[1]*d,u[2]+f[0]*d],this.dataX=[s[1],s[1]+p[0]*a,o[1]+f[0]*a,o[1],s[1]],this.dataY=[s[2],s[2]+p[1]*a,o[2]+f[1]*a,o[2],s[2]]};else if(r[0].elementClass===n.OBJECT_CLASS_CURVE&&"functiongraph"===r[0].visProp.curvetype)(h=t.create("curve",[[],[]],l)).updateDataArray=function(){var t,e,i,s,n,a,h,l,c,d=this.board.getBoundingBox(),u=[],p=r[0].minX(),f=r[0].maxX(),m=.3*(d[1]-d[3]);if(t=o.evaluate(this.visProp.inverse)?1:3,this.dataX=[],this.dataY=[],0!==(s=r[0].points.length))for(d[1]+=m,d[3]-=m,i=-1;i<s-1;){for(n=i+1,e=s;n<s;n++)if(r[0].points[n].isReal()){e=n;break}if(e>=s)break;for(n=e,i=s-1;n<s-1;n++)if(!r[0].points[n+1].isReal()){i=n;break}for(l=r[0].points[e].usrCoords[1],c=r[0].points[i].usrCoords[1],a=d[0]<p?p:d[0],h=d[2]>f?f:d[2],a=0===e?a:Math.max(a,l),h=i===s-1?h:Math.min(h,c),h=i===s-1?f:c,(u=[]).push([1,a=0===e?p:l,d[t]]),u.push([1,a,r[0].points[e].usrCoords[2]]),n=e;n<=i;n++)u.push(r[0].points[n].usrCoords);for(u.push([1,h,r[0].points[i].usrCoords[2]]),u.push([1,h,d[t]]),u.push(u[0]),n=0;n<u.length;n++)this.dataX.push(u[n][1]),this.dataY.push(u[n][2]);i<s-1&&(this.dataX.push(NaN),this.dataY.push(NaN))}},h.hasPoint=function(){return!1};else if(a=o.createFunction(r[0]),!o.exists(a))throw new Error("JSXGraph: Can't create area with the given parents.\nPossible parent types: [line], [function]");return h.addParents(r[0]),h},t.registerElement("arrowparallel",t.createArrowParallel),t.registerElement("bisector",t.createBisector),t.registerElement("bisectorlines",t.createAngularBisectorsOfTwoLines),t.registerElement("msector",t.createMsector),t.registerElement("circumcircle",t.createCircumcircle),t.registerElement("circumcirclemidpoint",t.createCircumcenter),t.registerElement("circumcenter",t.createCircumcenter),t.registerElement("incenter",t.createIncenter),t.registerElement("incircle",t.createIncircle),t.registerElement("integral",t.createIntegral),t.registerElement("midpoint",t.createMidpoint),t.registerElement("mirrorelement",t.createMirrorElement),t.registerElement("mirrorpoint",t.createMirrorPoint),t.registerElement("normal",t.createNormal),t.registerElement("orthogonalprojection",t.createOrthogonalProjection),t.registerElement("parallel",t.createParallel),t.registerElement("parallelpoint",t.createParallelPoint),t.registerElement("perpendicular",t.createPerpendicular),t.registerElement("perpendicularpoint",t.createPerpendicularPoint),t.registerElement("perpendicularsegment",t.createPerpendicularSegment),t.registerElement("reflection",t.createReflection),t.registerElement("grid",t.createGrid),t.registerElement("inequality",t.createInequality),{createArrowParallel:t.createArrowParallel,createBisector:t.createBisector,createAngularBisectorOfTwoLines:t.createAngularBisectorsOfTwoLines,createCircumcircle:t.createCircumcircle,createCircumcenter:t.createCircumcenter,createIncenter:t.createIncenter,createIncircle:t.createIncircle,createIntegral:t.createIntegral,createMidpoint:t.createMidpoint,createMirrorElement:t.createMirrorElement,createMirrorPoint:t.createMirrorPoint,createNormal:t.createNormal,createOrthogonalProjection:t.createOrthogonalProjection,createParallel:t.createParallel,createParallelPoint:t.createParallelPoint,createPerpendicular:t.createPerpendicular,createPerpendicularPoint:t.createPerpendicularPoint,createPerpendicularSegmen:t.createPerpendicularSegment,createReflection:t.createReflection,createGrid:t.createGrid,createInequality:t.createInequality}})),define("element/locus",["jxg","math/symbolic","utils/type"],(function(t,e,i){"use strict";return t.createLocus=function(t,r,s){var o,n;if(!i.isArray(r)||1!==r.length||!i.isPoint(r[0]))throw new Error("JSXGraph: Can't create locus with parent of type other than point.\nPossible parent types: [point]");return n=r[0],(o=t.create("curve",[[null],[null]],s)).dontCallServer=!1,o.elType="locus",o.setParents([n.id]),o.updateDataArray=function(){var i,r,s;o.board.mode>0||(i=e.generatePolynomials(t,n,!0).join("|"))!==o.spe&&(o.spe=i,(r=function(t,e,i,r){var s;o.dataX=t,o.dataY=e,o.eq=i,o.ctime=r,o.generatePolynomial=(s=i,function(t){var e,i="("+t.symbolic.x+")",r="("+t.symbolic.y+")",o=[];for(e=0;e<s.length;e++)o[e]=s[e].replace(/\*\*/g,"^").replace(/x/g,i).replace(/y/g,r);return o})})((s=e.geometricLocusByGroebnerBase(t,n,r)).datax,s.datay,s.polynomial,s.exectime))},o},t.registerElement("locus",t.createLocus),{createLocus:t.createLocus}})),define("base/image",["jxg","base/constants","base/coords","base/element","math/math","utils/type","base/coordselement"],(function(t,e,i,r,s,o,n){"use strict";return t.Image=function(i,r,s,n,a){this.constructor(i,s,e.OBJECT_TYPE_IMAGE,e.OBJECT_CLASS_OTHER),this.element=this.board.select(s.anchor),this.coordsConstructor(r),this.W=o.createFunction(a[0],this.board,""),this.H=o.createFunction(a[1],this.board,""),this.usrSize=[this.W(),this.H()],this.size=[Math.abs(this.usrSize[0]*i.unitX),Math.abs(this.usrSize[1]*i.unitY)],this.url=n,this.elType="image",this.span=[this.coords.usrCoords.slice(0),[this.coords.usrCoords[0],this.W(),0],[this.coords.usrCoords[0],0,this.H()]],this.id=this.board.setId(this,"Im"),this.board.renderer.drawImage(this),this.board.finalizeAdding(this),this.methodMap=t.deepCopy(this.methodMap,{addTransformation:"addTransform",trans:"addTransform"})},t.Image.prototype=new r,o.copyPrototypeMethods(t.Image,n,"coordsConstructor"),t.extend(t.Image.prototype,{hasPoint:function(t,r){var n,a,h,l,c,d,u,p,f,m=this.transformations.length;return o.isObject(o.evaluate(this.visProp.precision))?(l=this.board._inputDevice,c=o.evaluate(this.visProp.precision[l])):c=this.board.options.precision.hasPoint,0===m?(n=t-this.coords.scrCoords[1],a=this.coords.scrCoords[2]-r,n>=-(h=c)&&n-this.size[0]<=h&&a>=-h&&a-this.size[1]<=h):(u=[(d=(d=new i(e.COORDS_BY_SCREEN,[t,r],this.board)).usrCoords)[0]-this.span[0][0],d[1]-this.span[0][1],d[2]-this.span[0][2]],0<=(p=(f=s.innerProduct)(u,this.span[1]))&&p<=f(this.span[1],this.span[1])&&0<=(p=f(u,this.span[2]))&&p<=f(this.span[2],this.span[2]))},update:function(t){return this.needsUpdate?(this.updateCoords(t),this.updateSize(),this.updateSpan(),this):this},updateRenderer:function(){return this.updateRendererGeneric("updateImage")},updateSize:function(){return this.usrSize=[this.W(),this.H()],this.size=[Math.abs(this.usrSize[0]*this.board.unitX),Math.abs(this.usrSize[1]*this.board.unitY)],this},updateSpan:function(){var t,e,i=this.transformations.length,r=[];if(0===i)this.span=[[this.Z(),this.X(),this.Y()],[this.Z(),this.W(),0],[this.Z(),0,this.H()]];else{for(r[0]=[this.Z(),this.X(),this.Y()],r[1]=[this.Z(),this.X()+this.W(),this.Y()],r[2]=[this.Z(),this.X(),this.Y()+this.H()],t=0;t<i;t++)for(e=0;e<3;e++)r[e]=s.matVecMult(this.transformations[t].matrix,r[e]);for(e=0;e<3;e++)r[e][1]/=r[e][0],r[e][2]/=r[e][0],r[e][0]/=r[e][0];for(e=1;e<3;e++)r[e][0]-=r[0][0],r[e][1]-=r[0][1],r[e][2]-=r[0][2];this.span=r}return this},addTransform:function(t){var e;if(o.isArray(t))for(e=0;e<t.length;e++)this.transformations.push(t[e]);else this.transformations.push(t);return this},getParents:function(){var t=[this.url,[this.Z(),this.X(),this.Y()],this.usrSize];return 0!==this.parents.length&&(t=this.parents),t},setSize:function(t,e){return this.W=o.createFunction(t,this.board,""),this.H=o.createFunction(e,this.board,""),this},W:function(){},H:function(){}}),t.createImage=function(e,i,r){var s,a,h=i[0],l=i[1],c=i[2];if(s=o.copyAttributes(r,e.options,"image"),!(a=n.create(t.Image,e,l,s,h,c)))throw new Error("JSXGraph: Can't create image with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [x,y], [z,x,y], [element,transformation]");return 0!==s.rotate&&a.addRotation(s.rotate),a},t.registerElement("image",t.createImage),{Image:t.Image,createImage:t.createImage}})),define("element/slider",["jxg","math/math","base/constants","base/coords","utils/type","base/point"],(function(t,e,i,r,s,o){"use strict";return t.createSlider=function(t,n,a){var h,l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S,x,O,w,T;return S=(T=s.copyAttributes(a,t.options,"slider")).withticks,E=T.withlabel,x=T.snapwidth,T=s.copyAttributes(a,t.options,"slider","point1"),f=t.create("point",n[0],T),T=s.copyAttributes(a,t.options,"slider","point2"),m=t.create("point",n[1],T),T=s.copyAttributes(a,t.options,"slider","baseline"),(g=t.create("segment",[f,m],T)).updateStdform(),h=f.coords.usrCoords.slice(1),l=m.coords.usrCoords.slice(1),c=n[2][0],d=n[2][1],u=n[2][2],p=u-c,w=-1===(O=s.evaluate(x))?d:Math.round(d/O)*O,v=h[0]+(l[0]-h[0])*(w-c)/(u-c),y=h[1]+(l[1]-h[1])*(w-c)/(u-c),(T=s.copyAttributes(a,t.options,"slider")).withLabel=!1,(C=t.create("glider",[v,y,g],T)).setAttribute({snapwidth:x}),T=s.copyAttributes(a,t.options,"slider","highline"),_=t.create("segment",[f,C],T),C.Value=function(){var t=this._smax-this._smin,e=s.evaluate(this.visProp.snapwidth);return-1===e?this.position*t+this._smin:Math.round((this.position*t+this._smin)/e)*e},C.methodMap=s.deepCopy(C.methodMap,{Value:"Value",setValue:"setValue",smax:"_smax",smin:"_smin",setMax:"setMax",setMin:"setMin"}),C._smax=u,C._smin=c,C.setMax=function(t){return this._smax=t,this},C.setValue=function(t){var i=this._smax-this._smin;return Math.abs(i)>e.eps?this.position=(t-this._smin)/i:this.position=0,this.position=Math.max(0,Math.min(1,this.position)),this},C.setMin=function(t){return this._smin=t,this},E&&(T=s.copyAttributes(a,t.options,"slider","label"),P=t.create("text",[function(){return.05*(m.X()-f.X())+m.X()},function(){return.05*(m.Y()-f.Y())+m.Y()},function(){var t,e=s.evaluate(C.visProp.digits),i=s.evaluate(C.visProp.suffixlabel),r=s.evaluate(C.visProp.unitlabel),o=s.evaluate(C.visProp.postlabel);return 2===e&&2!==s.evaluate(C.visProp.precision)&&(e=s.evaluate(C.visProp.precision)),t=null!==i?i:C.name&&""!==C.name?C.name+" = ":"",t+=s.toFixed(C.Value(),e),null!==r&&(t+=r),null!==o&&(t+=o),t}],T),C.label=P,C.visProp.withlabel=!0,C.hasLabel=!0),C.point1=f,C.point2=m,C.baseline=g,C.highline=_,S&&(T=s.copyAttributes(a,t.options,"slider","ticks"),s.exists(T.generatelabeltext)||(T.generateLabelText=function(t,i,r){var s=C.point1.Dist(C.point2),o=C._smin,n=C._smax,a=this.getDistanceFromZero(i,t)*(n-o)/s+o;return s<e.eps||Math.abs(a)<e.eps?"0":this.formatLabelText(a)}),2,b=t.create("ticks",[C.baseline,C.point1.Dist(f)/2,function(t){var r=C.point1.Dist(C.point2),s=C.point1.coords.distance(i.COORDS_BY_USER,t);return r<e.eps?0:s/r*p+c}],T),C.ticks=b),C.remove=function(){E&&t.removeObject(P),t.removeObject(_),t.removeObject(g),t.removeObject(m),t.removeObject(f),o.Point.prototype.remove.call(C)},f.dump=!1,m.dump=!1,g.dump=!1,_.dump=!1,C.elType="slider",C.parents=n,C.subs={point1:f,point2:m,baseLine:g,highLine:_},C.inherits.push(f,m,g,_),S&&(b.dump=!1,C.subs.ticks=b,C.inherits.push(b)),C.baseline.on("up",(function(t){var e,o;s.evaluate(C.visProp.moveonup)&&!s.evaluate(C.visProp.fixed)&&(e=g.board.getMousePosition(t,0),o=new r(i.COORDS_BY_SCREEN,e,this.board),C.moveTo([o.usrCoords[1],o.usrCoords[2]]))})),C.prepareUpdate().update(),t.isSuspendedUpdate||(C.updateVisibility().updateRenderer(),C.baseline.updateVisibility().updateRenderer(),C.highline.updateVisibility().updateRenderer(),S&&C.ticks.updateVisibility().updateRenderer()),C},t.registerElement("slider",t.createSlider),{createSlider:t.createSlider}})),define("element/measure",["jxg","utils/type","base/element"],(function(t,e,i){"use strict";return t.createTapemeasure=function(r,s,o){var n,a,h,l,c,d,u,p,f,m,g;return n=s[0],a=s[1],h=e.copyAttributes(o,r.options,"tapemeasure","point1"),p=r.create("point",n,h),h=e.copyAttributes(o,r.options,"tapemeasure","point2"),f=r.create("point",a,h),p.setAttribute({ignoredSnapToPoints:[f]}),f.setAttribute({ignoredSnapToPoints:[p]}),h=e.copyAttributes(o,r.options,"tapemeasure"),l=h.withticks,c=h.withlabel,2===(d=h.digits)&&2!==h.precision&&(d=h.precision),c&&(h.withlabel=!0),u=r.create("segment",[p,f],h),c&&(m=o.name&&""!==o.name?o.name+" = ":"",u.label.setText((function(){return m+e.toFixed(p.Dist(f),d)}))),l&&(h=e.copyAttributes(o,r.options,"tapemeasure","ticks"),g=r.create("ticks",[u,.1],h),u.inherits.push(g)),u.remove=function(){l&&u.removeTicks(g),r.removeObject(f),r.removeObject(p),i.prototype.remove.call(this)},u.Value=function(){return p.Dist(f)},p.dump=!1,f.dump=!1,u.elType="tapemeasure",u.getParents=function(){return[[p.X(),p.Y()],[f.X(),f.Y()]]},u.subs={point1:p,point2:f},l&&(g.dump=!1),u.methodMap=t.deepCopy(u.methodMap,{Value:"Value"}),u.prepareUpdate().update(),r.isSuspendedUpdate||(u.updateVisibility().updateRenderer(),u.point1.updateVisibility().updateRenderer(),u.point2.updateVisibility().updateRenderer()),u},t.registerElement("tapemeasure",t.createTapemeasure),{createTapemeasure:t.createTapemeasure}})),define("parser/datasource",["jxg","utils/type"],(function(t,e){"use strict";return t.DataSource=function(){return this.data=[],this.columnHeaders=[],this.rowHeaders=[],this},t.extend(t.DataSource.prototype,{loadFromArray:function(t,i,r){var s,o,n;if(e.isArray(i)&&(this.columnHeaders=i,i=!1),e.isArray(r)&&(this.rowHeaders=r,r=!1),this.data=[],i&&(this.columnHeaders=[]),r&&(this.rowHeaders=[]),e.exists(t)){for(this.data=[],s=0;s<t.length;s++)for(this.data[s]=[],o=0;o<t[s].length;o++)n=t[s][o],parseFloat(n).toString()===n?this.data[s][o]=parseFloat(n):this.data[s][o]="-"!==n?n:NaN;if(i&&(this.columnHeaders=this.data[0].slice(1),this.data=this.data.slice(1)),r)for(this.rowHeaders=[],s=0;s<this.data.length;s++)this.rowHeaders.push(this.data[s][0]),this.data[s]=this.data[s].slice(1)}return this},loadFromTable:function(t,i,r){var s,o,n,a,h;if(e.isArray(i)&&(this.columnHeaders=i,i=!1),e.isArray(r)&&(this.rowHeaders=r,r=!1),this.data=[],i&&(this.columnHeaders=[]),r&&(this.rowHeaders=[]),t=document.getElementById(t),e.exists(t)){for(s=t.getElementsByTagName("tr"),this.data=[],o=0;o<s.length;o++)for(a=s[o].getElementsByTagName("td"),this.data[o]=[],n=0;n<a.length;n++)h=a[n].innerHTML,parseFloat(h).toString()===h?this.data[o][n]=parseFloat(h):this.data[o][n]="-"!==h?h:NaN;if(i&&(this.columnHeaders=this.data[0].slice(1),this.data=this.data.slice(1)),r)for(this.rowHeaders=[],o=0;o<this.data.length;o++)this.rowHeaders.push(this.data[o][0]),this.data[o]=this.data[o].slice(1)}return this},addColumn:function(t,e,i){throw new Error("not implemented")},addRow:function(t,e,i){throw new Error("not implemented")},getColumn:function(t){var i,r=[];if(e.isString(t))for(i=0;i<this.columnHeaders.length;i++)if(t===this.columnHeaders[i]){t=i;break}for(i=0;i<this.data.length;i++)this.data[i].length>t&&(r[i]=parseFloat(this.data[i][t]));return r},getRow:function(t){var i,r;if(e.isString(t))for(r=0;r<this.rowHeaders.length;r++)if(t===this.rowHeaders[r]){t=r;break}for(i=[],r=0;r<this.data[t].length;r++)i[r]=this.data[t][r];return i}}),t.DataSource})),define("base/chart",["jxg","math/numerics","math/statistics","base/constants","base/coords","base/element","parser/datasource","utils/color","utils/type","utils/env","base/curve","base/point","base/text","base/polygon","element/sector","base/transformation","base/line","base/circle"],(function(t,e,i,r,s,o,n,a,h,l,c,d,u,p,f,m,g,b){"use strict";return t.Chart=function(t,e,i){var r,s,o,n,a,l;if(this.constructor(t,i),!h.isArray(e)||0===e.length)throw new Error("JSXGraph: Can't create a chart without data");if(this.elements=[],h.isNumber(e[0]))for(s=e,r=[],o=0;o<s.length;o++)r[o]=o+1;else if(1===e.length&&h.isArray(e[0]))for(s=e[0],r=[],l=h.evaluate(s).length,o=0;o<l;o++)r[o]=o+1;else 2===e.length&&(l=Math.min(e[0].length,e[1].length),r=e[0].slice(0,l),s=e[1].slice(0,l));if(h.isArray(s)&&0===s.length)throw new Error("JSXGraph: Can't create charts without data.");for(a=i.chartstyle.replace(/ /g,"").split(","),o=0;o<a.length;o++){switch(a[o]){case"bar":n=this.drawBar(t,r,s,i);break;case"line":n=this.drawLine(t,r,s,i);break;case"fit":n=this.drawFit(t,r,s,i);break;case"spline":n=this.drawSpline(t,r,s,i);break;case"pie":n=this.drawPie(t,s,i);break;case"point":n=this.drawPoints(t,r,s,i);break;case"radar":n=this.drawRadar(t,e,i)}this.elements.push(n)}return this.id=this.board.setId(this,"Chart"),this.elements},t.Chart.prototype=new o,t.extend(t.Chart.prototype,{drawLine:function(t,e,i,r){return r.fillcolor="none",r.highlightfillcolor="none",t.create("curve",[e,i],r)},drawSpline:function(t,e,i,r){return r.fillColor="none",r.highlightfillcolor="none",t.create("spline",[e,i],r)},drawFit:function(t,i,r,s){var o=s.degree;return o=Math.max(parseInt(o,10),1)||1,s.fillcolor="none",s.highlightfillcolor="none",t.create("functiongraph",[e.regressionPolynomial(o,i,r)],s)},drawBar:function(t,e,i,r){var s,o,n,a,l,c,d,u,p,f,m=[],g=[],b=function(t,i){return function(){return e[t]()-i*n}},v={fixed:!0,withLabel:!1,visible:!1,name:""};if((p=h.copyAttributes(r,t.options,"chart"))&&p.width)n=p.width;else{if(e.length<=1)n=1;else for(n=e[1]-e[0],s=1;s<e.length-1;s++)n=e[s+1]-e[s]<n?e[s+1]-e[s]:n;n*=.8}for(f=h.copyAttributes(r,t.options,"chart","label"),s=0;s<e.length;s++)h.isFunction(e[s])?(a=b(s,-.5),l=b(s,0),c=b(s,.5)):(a=e[s]-.5*n,l=e[s],c=e[s]+.5*n),d=h.isFunction(i[s])?i[s]():i[s],d=i[s],"horizontal"===p.dir?(g[0]=t.create("point",[0,a],v),g[1]=t.create("point",[d,a],v),g[2]=t.create("point",[d,c],v),g[3]=t.create("point",[0,c],v),h.exists(p.labels)&&h.exists(p.labels[s])&&(f.anchorY="middle",(o=t.create("text",[d,l,p.labels[s]],f)).visProp.anchorx=function(t){return function(){return t.X()>=0?"left":"right"}}(o))):(g[0]=t.create("point",[a,0],v),g[1]=t.create("point",[a,d],v),g[2]=t.create("point",[c,d],v),g[3]=t.create("point",[c,0],v),h.exists(p.labels)&&h.exists(p.labels[s])&&(f.anchorX="middle",(o=t.create("text",[l,d,p.labels[s]],f)).visProp.anchory=function(t){return function(){return t.Y()>=0?"bottom":"top"}}(o))),h.isArray(p.colors)&&(u=p.colors,p.fillcolor=u[s%u.length]),m[s]=t.create("polygon",g,p),h.exists(p.labels)&&h.exists(p.labels[s])&&(m[s].text=o);return m},drawPoints:function(t,e,i,r){var s,o=[],n=r.infoboxarray;for(r.fixed=!0,r.name="",s=0;s<e.length;s++)r.infoboxtext=!!n&&n[s%n.length],o[s]=t.create("point",[e[s],i[s]],r);return o},drawPie:function(t,e,o){var n,a,l=[],c=[],d=(i.sum(e),o.colors),u=o.highlightcolors,p=o.labels,f=o.radius||4,m=f,g=o.center||[0,0],b=g[0],v=g[1],y=function(t,i,r){return function(){var s,o,n,a=0;for(o=0;o<=t;o++)a+=parseFloat(h.evaluate(e[o]));for(s=a,o=t+1;o<e.length;o++)s+=parseFloat(h.evaluate(e[o]));return n=0!==s?2*Math.PI*a/s:0,m()*Math[i](n)+r}},C=function(t,e){var i=-this.point1.coords.usrCoords[1]+this.point2.coords.usrCoords[1],o=-this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[2];h.exists(this.label)&&(this.label.rendNode.style.fontSize=e*h.evaluate(this.label.visProp.fontsize)+"px",this.label.fullUpdate()),this.point2.coords=new s(r.COORDS_BY_USER,[this.point1.coords.usrCoords[1]+i*t,this.point1.coords.usrCoords[2]+o*t],this.board),this.fullUpdate()},_=function(){this.highlighted||(this.highlighted=!0,this.board.highlightedObjects[this.id]=this,this.board.renderer.highlight(this),C.call(this,1.1,2))},P=function(){this.highlighted&&(this.highlighted=!1,this.board.renderer.noHighlight(this),C.call(this,.9090909,1))},E={fixed:!0,withLabel:!1,visible:!1,name:""};if(!h.isArray(p))for(p=[],n=0;n<e.length;n++)p[n]="";for(h.isFunction(f)||(m=function(){return f}),o.highlightonsector=o.highlightonsector||!1,o.straightfirst=!1,o.straightlast=!1,a=t.create("point",[b,v],E),l[0]=t.create("point",[function(){return m()+b},function(){return v}],E),n=0;n<e.length;n++)l[n+1]=t.create("point",[y(n,"cos",b),y(n,"sin",v)],E),o.name=p[n],o.withlabel=""!==o.name,o.fillcolor=d&&d[n%d.length],o.labelcolor=d&&d[n%d.length],o.highlightfillcolor=u&&u[n%u.length],c[n]=t.create("sector",[a,l[n],l[n+1]],o),o.highlightonsector&&(c[n].hasPoint=c[n].hasPointSector),o.highlightbysize&&(c[n].highlight=_,c[n].noHighlight=P);return{sectors:c,points:l,midpoint:a}},drawRadar:function(e,i,o){var n,a,l,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S,x,O,w,T,N,M,A,R,L,k,B,I,Y,D,j,X,U,F,J,G,z,H,V,$,q=i.length,W=function(){var t,e,i,o,n=h.evaluate(this.visProp.label.offset).slice(0);return t=this.point1.X(),e=this.point2.X(),i=this.point1.Y(),o=this.point2.Y(),e<t&&(n[0]=-n[0]),o<i&&(n[1]=-n[1]),this.setLabelRelativeCoords(n),new s(r.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)},Q=function(t,i){var r,s,o;return r=e.create("transform",[-(_[i]-y[i]),0],{type:"translate"}),s=e.create("transform",[x/(P[i]+C[i]-(_[i]-y[i])),1],{type:"scale"}),r.melt(s),o=e.create("transform",[t],{type:"rotate"}),r.melt(o),r};if(q<=0)throw new Error("JSXGraph radar chart: no data");if(l=o.paramarray,!h.exists(l))throw new Error("JSXGraph radar chart: need paramArray attribute");if((c=l.length)<=1)throw new Error("JSXGraph radar chart: need more than one param in paramArray");for(n=0;n<q;n++)if(c!==i[n].length)throw new Error("JSXGraph radar chart: use data length equal to number of params ("+i[n].length+" != "+c+")");for(d=[],u=[],a=0;a<c;a++)d[a]=i[0][a],u[a]=d[a];for(n=1;n<q;n++)for(a=0;a<c;a++)i[n][a]>d[a]&&(d[a]=i[n][a]),i[n][a]<u[a]&&(u[a]=i[n][a]);for(p=[],f=[],n=0;n<q;n++)p[n]="",f[n]=[];for(m=[],g=[],b=o.startshiftratio||0,v=o.endshiftratio||0,n=0;n<c;n++)m[n]=(d[n]-u[n])*b,g[n]=(d[n]-u[n])*v;if(y=o.startshiftarray||m,C=o.endshiftarray||g,_=o.startarray||u,h.exists(o.start))for(n=0;n<c;n++)_[n]=o.start;if(P=o.endarray||d,h.exists(o.end))for(n=0;n<c;n++)P[n]=o.end;if(y.length!==c)throw new Error("JSXGraph radar chart: start shifts length is not equal to number of parameters");if(C.length!==c)throw new Error("JSXGraph radar chart: end shifts length is not equal to number of parameters");if(_.length!==c)throw new Error("JSXGraph radar chart: starts length is not equal to number of parameters");if(P.length!==c)throw new Error("JSXGraph radar chart: snds length is not equal to number of parameters");for(E=o.labelarray||p,S=o.colors,o.highlightcolors,x=o.radius||10,V=o.strokewidth||1,h.exists(o.highlightonsector)||(o.highlightonsector=!1),O={name:o.name,id:o.id,strokewidth:V,polystrokewidth:o.polystrokewidth||V,strokecolor:o.strokecolor||"black",straightfirst:!1,straightlast:!1,fillcolor:o.fillColor||"#FFFF88",fillopacity:o.fillOpacity||.4,highlightfillcolor:o.highlightFillColor||"#FF7400",highlightstrokecolor:o.highlightStrokeColor||"black",gradient:o.gradient||"none"},T=(w=o.center||[0,0])[0],N=w[1],M=e.create("point",[T,N],{name:"",fixed:!0,withlabel:!1,visible:!1}),Math.PI/2-Math.PI/c,R=A=o.startangle||0,L=[],k=[],n=0;n<c;n++)for(R+=2*Math.PI/c,I=x*Math.cos(R)+T,Y=x*Math.sin(R)+N,L[n]=e.create("point",[I,Y],{name:"",fixed:!0,withlabel:!1,visible:!1}),k[n]=e.create("line",[M,L[n]],{name:l[n],strokeColor:O.strokecolor,strokeWidth:O.strokewidth,strokeOpacity:1,straightFirst:!1,straightLast:!1,withLabel:!0,highlightStrokeColor:O.highlightstrokecolor}),k[n].getLabelAnchor=W,B=Q(R,n),a=0;a<i.length;a++)$=i[a][n],f[a][n]=e.create("point",[$,0],{name:"",fixed:!0,withlabel:!1,visible:!1}),f[a][n].addTransform(f[a][n],B);for(D=[],n=0;n<q;n++)for(O.labelcolor=S&&S[n%S.length],O.strokecolor=S&&S[n%S.length],O.fillcolor=S&&S[n%S.length],D[n]=e.create("polygon",f[n],{withLines:!0,withLabel:!1,fillColor:O.fillcolor,fillOpacity:O.fillopacity,highlightFillColor:O.highlightfillcolor}),a=0;a<c;a++)D[n].borders[a].setAttribute("strokecolor:"+S[n%S.length]),D[n].borders[a].setAttribute("strokewidth:"+O.polystrokewidth);switch(o.legendposition||"none"){case"right":X=o.legendleftoffset||2,U=o.legendtopoffset||1,this.legend=e.create("legend",[T+x+X,N+x-U],{labels:E,colors:S});break;case"none":break;default:t.debug("Unknown legend position")}if(j=[],o.showcircles){for(F=[],n=0;n<6;n++)F[n]=20*n;if(F[0]="0",(G=(J=o.circlelabelarray||F).length)<2)throw new Error("JSXGraph radar chart: too less circles in circleLabelArray");for(z=[],B=Q(A+Math.PI/c,0),O.fillcolor="none",O.highlightfillcolor="none",O.strokecolor=o.strokecolor||"black",O.strokewidth=o.circlestrokewidth||.5,O.layer=0,H=(P[0]-_[0])/(G-1),n=0;n<G;n++)z[n]=e.create("point",[_[0]+n*H,0],{name:J[n],size:0,fixed:!0,withLabel:!0,visible:!0}),z[n].addTransform(z[n],B),j[n]=e.create("circle",[M,z[n]],O)}return this.rendNode=D[0].rendNode,{circles:j,lines:k,points:f,midpoint:M,polygons:D}},updateRenderer:function(){return this},update:function(){return this.needsUpdate&&this.updateDataArray(),this},updateDataArray:function(){return this}}),t.createChart=function(e,i,r){var s,o,c,d,u,p,f,m,g,b,v,y,C,_,P,E,S=[],x=l.isBrowser?e.document.getElementById(i[0]):null;if(1===i.length&&h.isString(i[0])){if(h.exists(x)){if(g=h.copyAttributes(r,e.options,"chart"),s=(x=(new n).loadFromTable(i[0],g.withheaders,g.withheaders)).data,u=x.columnHeaders,o=x.rowHeaders,b=g.width,v=g.name,y=g.strokecolor,C=g.fillcolor,_=g.highlightstrokecolor,P=g.highlightfillcolor,e.suspendUpdate(),E=s.length,m=[],g.rows&&h.isArray(g.rows)){for(c=0;c<E;c++)for(d=0;d<g.rows.length;d++)if(g.rows[d]===c||g.withheaders&&g.rows[d]===o[c]){m.push(s[c]);break}}else m=s;for(E=m.length,c=0;c<E;c++){if(f=[],g.chartstyle&&-1!==g.chartstyle.indexOf("bar")){for(p=b||.8,f.push(1-p/2+(c+.5)*p/E),d=1;d<m[c].length;d++)f.push(f[d-1]+1);g.width=p/E}v&&v.length===E?g.name=v[c]:g.withheaders&&(g.name=u[c]),y&&y.length===E?g.strokecolor=y[c]:g.strokecolor=a.hsv2rgb((c+1)/E*360,.9,.6),C&&C.length===E?g.fillcolor=C[c]:g.fillcolor=a.hsv2rgb((c+1)/E*360,.9,1),_&&_.length===E?g.highlightstrokecolor=_[c]:g.highlightstrokecolor=a.hsv2rgb((c+1)/E*360,.9,1),P&&P.length===E?g.highlightfillcolor=P[c]:g.highlightfillcolor=a.hsv2rgb((c+1)/E*360,.9,.6),g.chartstyle&&-1!==g.chartstyle.indexOf("bar")?S.push(new t.Chart(e,[f,m[c]],g)):S.push(new t.Chart(e,[m[c]],g))}e.unsuspendUpdate()}return S}return g=h.copyAttributes(r,e.options,"chart"),new t.Chart(e,i,g)},t.registerElement("chart",t.createChart),t.Legend=function(t,e,i){var o;if(this.constructor(),o=h.copyAttributes(i,t.options,"legend"),this.board=t,this.coords=new s(r.COORDS_BY_USER,e,this.board),this.myAtts={},this.label_array=o.labelarray||o.labels,this.color_array=o.colorarray||o.colors,this.lines=[],this.myAtts.strokewidth=o.strokewidth||5,this.myAtts.straightfirst=!1,this.myAtts.straightlast=!1,this.myAtts.withlabel=!0,this.myAtts.fixed=!0,this.style=o.legendstyle||o.style,"vertical"!==this.style)throw new Error("JSXGraph: Unknown legend style: "+this.style);this.drawVerticalLegend(t,o)},t.Legend.prototype=new o,t.Legend.prototype.drawVerticalLegend=function(t,e){var i,o=e.linelength||1,n=(e.rowheight||20)/this.board.unitY,a=function(){return this.setLabelRelativeCoords(this.visProp.label.offset),new s(r.COORDS_BY_USER,[this.point2.X(),this.point2.Y()],this.board)};for(i=0;i<this.label_array.length;i++)this.myAtts.name=this.label_array[i],this.myAtts.strokecolor=this.color_array[i%this.color_array.length],this.myAtts.highlightstrokecolor=this.color_array[i%this.color_array.length],this.myAtts.label={offset:[10,0],strokeColor:this.color_array[i%this.color_array.length],strokeWidth:this.myAtts.strokewidth},this.lines[i]=t.create("line",[[this.coords.usrCoords[1],this.coords.usrCoords[2]-i*n],[this.coords.usrCoords[1]+o,this.coords.usrCoords[2]-i*n]],this.myAtts),this.lines[i].getLabelAnchor=a,this.lines[i].prepareUpdate().update().updateVisibility(h.evaluate(this.lines[i].visProp.visible)).updateRenderer()},t.createLegend=function(e,i,r){var s=[0,0];if(!h.exists(i)||2!==i.length)throw new Error("JSXGraph: Legend element needs two numbers as parameters");return s=i,new t.Legend(e,s,r)},t.registerElement("legend",t.createLegend),{Chart:t.Chart,Legend:t.Legend,createChart:t.createChart,createLegend:t.createLegend}})),define("base/turtle",["jxg","base/constants","base/element","utils/type"],(function(t,e,i,r){"use strict";return t.Turtle=function(t,i,s){var o,n,a;return this.constructor(t,s,e.OBJECT_TYPE_TURTLE,e.OBJECT_CLASS_OTHER),this.turtleIsHidden=!1,this.board=t,this.visProp.curveType="plot",this._attributes=r.copyAttributes(this.visProp,t.options,"turtle"),delete this._attributes.id,o=0,n=0,a=90,0!==i.length&&(3===i.length?(o=i[0],n=i[1],a=i[2]):2===i.length?r.isArray(i[0])?(o=i[0][0],n=i[0][1],a=i[1]):(o=i[0],n=i[1]):(o=i[0][0],n=i[0][1])),this.init(o,n,a),this.methodMap=r.deepCopy(this.methodMap,{forward:"forward",fd:"forward",back:"back",bk:"back",right:"right",rt:"right",left:"left",lt:"left",penUp:"penUp",pu:"penUp",penDown:"penDown",pd:"penDown",clearScreen:"clearScreen",cs:"clearScreen",clean:"clean",setPos:"setPos",home:"home",hideTurtle:"hideTurtle",ht:"hideTurtle",showTurtle:"showTurtle",st:"showTurtle",penSize:"setPenSize",penColor:"setPenColor",pushTurtle:"pushTurtle",push:"pushTurtle",popTurtle:"popTurtle",pop:"popTurtle",lookTo:"lookTo",pos:"pos",moveTo:"moveTo",X:"X",Y:"Y"}),this},t.Turtle.prototype=new i,t.extend(t.Turtle.prototype,{init:function(t,e,i){var r={fixed:!0,name:"",visible:!1,withLabel:!1};this.arrowLen=20/Math.sqrt(this.board.unitX*this.board.unitX+this.board.unitY*this.board.unitY),this.pos=[t,e],this.isPenDown=!0,this.dir=90,this.stack=[],this.objects=[],this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve),this.turtle=this.board.create("point",this.pos,r),this.objects.push(this.turtle),this.turtle2=this.board.create("point",[this.pos[0],this.pos[1]+this.arrowLen],r),this.objects.push(this.turtle2),this.visProp.arrow.lastArrow=!0,this.visProp.arrow.straightFirst=!1,this.visProp.arrow.straightLast=!1,this.arrow=this.board.create("line",[this.turtle,this.turtle2],this.visProp.arrow),this.objects.push(this.arrow),this.subs={arrow:this.arrow},this.inherits.push(this.arrow),this.right(90-i),this.board.update()},forward:function(t){if(0===t)return this;var e,i=t*Math.cos(this.dir*Math.PI/180),r=t*Math.sin(this.dir*Math.PI/180);return this.turtleIsHidden||((e=this.board.create("transform",[i,r],{type:"translate"})).applyOnce(this.turtle),e.applyOnce(this.turtle2)),this.isPenDown&&this.curve.dataX.length>=8192&&(this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve)),this.pos[0]+=i,this.pos[1]+=r,this.isPenDown&&(this.curve.dataX.push(this.pos[0]),this.curve.dataY.push(this.pos[1])),this.board.update(),this},back:function(t){return this.forward(-t)},right:function(t){(this.dir-=t,this.dir%=360,this.turtleIsHidden)||this.board.create("transform",[-t*Math.PI/180,this.turtle],{type:"rotate"}).applyOnce(this.turtle2);return this.board.update(),this},left:function(t){return this.right(-t)},penUp:function(){return this.isPenDown=!1,this},penDown:function(){return this.isPenDown=!0,this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve),this},clean:function(){var t,i;for(t=0;t<this.objects.length;t++)(i=this.objects[t]).type===e.OBJECT_TYPE_CURVE&&(this.board.removeObject(i),this.objects.splice(t,1));return this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve),this.board.update(),this},clearScreen:function(){var t,e,i=this.objects.length;for(t=0;t<i;t++)e=this.objects[t],this.board.removeObject(e);return this.init(0,0,90),this},setPos:function(t,i){return r.isArray(t)?this.pos=t:this.pos=[t,i],this.turtleIsHidden||(this.turtle.setPositionDirectly(e.COORDS_BY_USER,[t,i]),this.turtle2.setPositionDirectly(e.COORDS_BY_USER,[t,i+this.arrowLen]),this.board.create("transform",[-(this.dir-90)*Math.PI/180,this.turtle],{type:"rotate"}).applyOnce(this.turtle2)),this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve),this.board.update(),this},setPenSize:function(t){return this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.copyAttr("strokeWidth",t)),this.objects.push(this.curve),this},setPenColor:function(t){return this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.copyAttr("strokeColor",t)),this.objects.push(this.curve),this},setHighlightPenColor:function(t){return this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this.copyAttr("highlightStrokeColor",t)),this.objects.push(this.curve),this},setAttribute:function(t){var i,s,o,n=this.objects.length;for(i=0;i<n;i++)(s=this.objects[i]).type===e.OBJECT_TYPE_CURVE&&s.setAttribute(t);return o=this.visProp.id,this.visProp=r.deepCopy(this.curve.visProp),this.visProp.id=o,this._attributes=r.deepCopy(this.visProp),delete this._attributes.id,this},copyAttr:function(t,e){return this._attributes[t.toLowerCase()]=e,this._attributes},showTurtle:function(){return this.turtleIsHidden=!1,this.arrow.setAttribute({visible:!0}),this.visProp.arrow.visible=!1,this.setPos(this.pos[0],this.pos[1]),this.board.update(),this},hideTurtle:function(){return this.turtleIsHidden=!0,this.arrow.setAttribute({visible:!1}),this.visProp.arrow.visible=!1,this.board.update(),this},home:function(){return this.pos=[0,0],this.setPos(this.pos[0],this.pos[1]),this},pushTurtle:function(){return this.stack.push([this.pos[0],this.pos[1],this.dir]),this},popTurtle:function(){var t=this.stack.pop();return this.pos[0]=t[0],this.pos[1]=t[1],this.dir=t[2],this.setPos(this.pos[0],this.pos[1]),this},lookTo:function(t){var e,i,s,o,n;return r.isArray(t)?(e=this.pos[0],i=this.pos[1],s=t[0],o=t[1],n=Math.atan2(o-i,s-e),this.right(this.dir-180*n/Math.PI)):r.isNumber(t)&&this.right(this.dir-t),this},moveTo:function(t){var e,i,s;return r.isArray(t)&&(e=t[0]-this.pos[0],i=t[1]-this.pos[1],this.turtleIsHidden||((s=this.board.create("transform",[e,i],{type:"translate"})).applyOnce(this.turtle),s.applyOnce(this.turtle2)),this.isPenDown&&this.curve.dataX.length>=8192&&(this.curve=this.board.create("curve",[[this.pos[0]],[this.pos[1]]],this._attributes),this.objects.push(this.curve)),this.pos[0]=t[0],this.pos[1]=t[1],this.isPenDown&&(this.curve.dataX.push(this.pos[0]),this.curve.dataY.push(this.pos[1])),this.board.update()),this},fd:function(t){return this.forward(t)},bk:function(t){return this.back(t)},lt:function(t){return this.left(t)},rt:function(t){return this.right(t)},pu:function(){return this.penUp()},pd:function(){return this.penDown()},ht:function(){return this.hideTurtle()},st:function(){return this.showTurtle()},cs:function(){return this.clearScreen()},push:function(){return this.pushTurtle()},pop:function(){return this.popTurtle()},evalAt:function(t,i){var r,s,o,n,a=this.objects.length;for(r=0,s=0;r<a;r++)if((o=this.objects[r]).elementClass===e.OBJECT_CLASS_CURVE){if(s<=t&&t<s+o.numberPoints)return n=t-s,o[i](n);s+=o.numberPoints}return this[i]()},X:function(t){return r.exists(t)?this.evalAt(t,"X"):this.pos[0]},Y:function(t){return r.exists(t)?this.evalAt(t,"Y"):this.pos[1]},Z:function(t){return 1},minX:function(){return 0},maxX:function(){var t,i=this.objects.length,r=0;for(t=0;t<i;t++)this.objects[t].elementClass===e.OBJECT_CLASS_CURVE&&(r+=this.objects[t].numberPoints);return r},hasPoint:function(t,i){var r,s;for(r=0;r<this.objects.length;r++)if((s=this.objects[r]).type===e.OBJECT_TYPE_CURVE&&s.hasPoint(t,i))return!0;return!1}}),t.createTurtle=function(e,i,s){var o;return i=i||[],o=r.copyAttributes(s,e.options,"turtle"),new t.Turtle(e,i,o)},t.registerElement("turtle",t.createTurtle),{Turtle:t.Turtle,createTurtle:t.createTurtle}})),define("base/ticks",["jxg","math/math","math/geometry","math/numerics","base/constants","base/element","base/coords","utils/type","base/text"],(function(t,e,i,r,s,o,n,a,h){"use strict";return t.Ticks=function(t,i,r){if(this.constructor(t.board,r,s.OBJECT_TYPE_TICKS,s.OBJECT_CLASS_OTHER),this.line=t,this.board=this.line.board,this.ticksFunction=null,this.fixedTicks=null,this.equidistant=!1,this.labelsData=[],a.isFunction(i))throw this.ticksFunction=i,new Error("Function arguments are no longer supported.");a.isArray(i)?this.fixedTicks=i:((Math.abs(i)<e.eps||i<0)&&(i=r.defaultdistance),this.ticksFunction=this.makeTicksFunction(i),this.equidistant=!0),this.minTicksDistance=r.minticksdistance,this.ticks=[],this.ticksDelta=1,this.labels=[],this.labelData=[],this.labelCounter=0,this.id=this.line.addTicks(this),this.elType="ticks",this.inherits.push(this.labels),this.board.setId(this,"Ti")},t.Ticks.prototype=new o,t.extend(t.Ticks.prototype,{makeTicksFunction:function(t){return function(){var e,i,r;return a.evaluate(this.visProp.insertticks)?((r=(i=this.getLowerAndUpperBounds(this.getZeroCoordinates(),"ticksdistance")).upper-i.lower)<=6*(e=Math.pow(10,Math.floor(Math.log(.6*r)/Math.LN10)))&&(e*=.5),e):t}},hasPoint:function(t,i){var r,o,n,h,l=this.ticks&&this.ticks.length||0;if(a.isObject(a.evaluate(this.visProp.precision))?(h=this.board._inputDevice,n=a.evaluate(this.visProp.precision[h])):n=this.board.options.precision.hasPoint,n+=.5*a.evaluate(this.visProp.strokewidth),!a.evaluate(this.line.visProp.scalable)||this.line.elementClass===s.OBJECT_CLASS_CURVE)return!1;if(0!==this.line.stdform[1]&&0!==this.line.stdform[2]&&this.line.type!==s.OBJECT_TYPE_AXIS)return!1;for(r=0;r<l;r++)if((o=this.ticks[r])[2]&&!(0===this.line.stdform[1]&&Math.abs(o[0][0]-this.line.point1.coords.scrCoords[1])<e.eps||0===this.line.stdform[2]&&Math.abs(o[1][0]-this.line.point1.coords.scrCoords[2])<e.eps)&&(Math.abs(o[0][0]-o[0][1])>=1||Math.abs(o[1][0]-o[1][1])>=1))if(0===this.line.stdform[1]){if(Math.abs(i-.5*(o[1][0]+o[1][1]))<2*n&&o[0][0]-n<t&&t<o[0][1]+n)return!0}else if(0===this.line.stdform[2]&&Math.abs(t-.5*(o[0][0]+o[0][1]))<2*n&&o[1][0]-n<i&&i<o[1][1]+n)return!0;return!1},setPositionDirectly:function(t,i,r){var o,h,l=new n(t,i,this.board),c=new n(t,r,this.board),d=this.board.getBoundingBox();return this.line.type===s.OBJECT_TYPE_AXIS&&a.evaluate(this.line.visProp.scalable)?(Math.abs(this.line.stdform[1])<e.eps&&Math.abs(l.usrCoords[1]*c.usrCoords[1])>e.eps?(o=c.usrCoords[1]/l.usrCoords[1],d[0]*=o,d[2]*=o,this.board.setBoundingBox(d,this.board.keepaspectratio,"update")):Math.abs(this.line.stdform[2])<e.eps&&Math.abs(l.usrCoords[2]*c.usrCoords[2])>e.eps&&(h=c.usrCoords[2]/l.usrCoords[2],d[3]*=h,d[1]*=h,this.board.setBoundingBox(d,this.board.keepaspectratio,"update")),this):this},calculateTicksCoordinates:function(){var t,i,r,o;if(!(this.line.elementClass===s.OBJECT_CLASS_LINE&&(this.setTicksSizeVariables(),Math.abs(this.dx)<e.eps&&Math.abs(this.dy)<e.eps)))return t=this.getZeroCoordinates(),i=this.line.elementClass===s.OBJECT_CLASS_LINE?this.getLowerAndUpperBounds(t):{lower:this.line.minX(),upper:this.line.maxX()},"polar"===a.evaluate(this.visProp.type)&&(o=this.board.getBoundingBox(),r=Math.max(Math.sqrt(o[0]*o[0]+o[1]*o[1]),Math.sqrt(o[2]*o[2]+o[3]*o[3])),i.upper=r),this.ticks=[],this.labelsData=[],this.equidistant?this.generateEquidistantTicks(t,i):this.generateFixedTicks(t,i),this},setTicksSizeVariables:function(t){var i,s,o,n,h=.5*a.evaluate(this.visProp.majorheight),l=.5*a.evaluate(this.visProp.minorheight);a.exists(t)?(s=this.line.minX(),o=this.line.maxX(),(n=this.line.points.length)<2?(this.dxMaj=0,this.dyMaj=0):e.relDif(t,s)<e.eps?(this.dxMaj=this.line.points[0].usrCoords[2]-this.line.points[1].usrCoords[2],this.dyMaj=this.line.points[1].usrCoords[1]-this.line.points[0].usrCoords[1]):e.relDif(t,o)<e.eps?(this.dxMaj=this.line.points[n-2].usrCoords[2]-this.line.points[n-1].usrCoords[2],this.dyMaj=this.line.points[n-1].usrCoords[1]-this.line.points[n-2].usrCoords[1]):(this.dxMaj=-r.D(this.line.Y)(t),this.dyMaj=r.D(this.line.X)(t))):(this.dxMaj=this.line.stdform[1],this.dyMaj=this.line.stdform[2]),this.dxMin=this.dxMaj,this.dyMin=this.dyMaj,this.dx=this.dxMaj,this.dy=this.dyMaj,i=Math.sqrt(this.dxMaj*this.dxMaj*this.board.unitX*this.board.unitX+this.dyMaj*this.dyMaj*this.board.unitY*this.board.unitY),this.dxMaj*=h/i*this.board.unitX,this.dyMaj*=h/i*this.board.unitY,this.dxMin*=l/i*this.board.unitX,this.dyMin*=l/i*this.board.unitY,this.minStyle=a.evaluate(this.visProp.minorheight)<0?"infinite":"finite",this.majStyle=a.evaluate(this.visProp.majorheight)<0?"infinite":"finite"},getZeroCoordinates:function(){var t,e,r,o,h,l,c,d,u=a.evaluate(this.visProp.anchor);return this.line.elementClass===s.OBJECT_CLASS_LINE?this.line.type===s.OBJECT_TYPE_AXIS?i.projectPointToLine({coords:{usrCoords:[1,0,0]}},this.line,this.board):(r=this.line.point1.coords.usrCoords[0],t=this.line.point1.coords.usrCoords[1],e=this.line.point1.coords.usrCoords[2],l=this.line.point2.coords.usrCoords[0],o=this.line.point2.coords.usrCoords[1],h=this.line.point2.coords.usrCoords[2],"right"===u?this.line.point2.coords:"middle"===u?new n(s.COORDS_BY_USER,[.5*(r+l),.5*(t+o),.5*(e+h)],this.board):a.isNumber(u)?new n(s.COORDS_BY_USER,[r+(l-r)*u,t+(o-t)*u,e+(h-e)*u],this.board):this.line.point1.coords):(c=this.line.minX(),d=this.line.maxX(),"right"===u?d:"middle"===u?.5*(c+d):a.isNumber(u)?c*(1-u)+d*u:c)},getLowerAndUpperBounds:function(t,r){var o,h,l,c,d,u,p,f,m,g,b=a.evaluate(this.line.visProp.straightfirst),v=a.evaluate(this.line.visProp.straightlast),y=a.evaluate(this.visProp.includeboundaries);return this.line.elementClass===s.OBJECT_CLASS_CURVE?{lower:this.line.minX(),upper:this.line.maxX()}:(d=new n(s.COORDS_BY_USER,this.line.point1.coords.usrCoords,this.board),u=new n(s.COORDS_BY_USER,this.line.point2.coords.usrCoords,this.board),p=Math.abs(d.usrCoords[0])>=e.eps&&d.scrCoords[1]>=0&&d.scrCoords[1]<=this.board.canvasWidth&&d.scrCoords[2]>=0&&d.scrCoords[2]<=this.board.canvasHeight,f=Math.abs(u.usrCoords[0])>=e.eps&&u.scrCoords[1]>=0&&u.scrCoords[1]<=this.board.canvasWidth&&u.scrCoords[2]>=0&&u.scrCoords[2]<=this.board.canvasHeight,a.exists(r)||"tickdistance"===r?i.calcStraight(this.line,d,u,a.evaluate(this.line.visProp.margin)):i.calcLineDelimitingPoints(this.line,d,u),l=a.evaluate(this.line.visProp.firstarrow),c=a.evaluate(this.line.visProp.lastarrow),(l||c)&&(this.board.renderer.getPositionArrowHead(this.line,d,u,a.evaluate(this.line.visProp.strokewidth)),l&&d.setCoordinates(s.COORDS_BY_SCREEN,[d.scrCoords[1],d.scrCoords[2]]),c&&u.setCoordinates(s.COORDS_BY_SCREEN,[u.scrCoords[1],u.scrCoords[2]])),(m=this.getDistanceFromZero(t,d))<(g=this.getDistanceFromZero(t,u))?(o=m,b||!p||y||(o+=e.eps),h=g,v||!f||y||(h-=e.eps)):g<m?(o=g,v||!f||y||(o+=e.eps),h=m,b||!p||y||(h-=e.eps)):(o=0,h=0),{lower:o,upper:h})},getDistanceFromZero:function(t,i){var r,o,n,a,h;return r=this.line.point1.coords,o=this.line.point2.coords,h=t.distance(s.COORDS_BY_USER,i),n=[o.usrCoords[0]-r.usrCoords[0],o.usrCoords[1]-r.usrCoords[1],o.usrCoords[2]-r.usrCoords[2]],a=[i.usrCoords[0]-t.usrCoords[0],i.usrCoords[1]-t.usrCoords[1],i.usrCoords[2]-t.usrCoords[2]],e.innerProduct(n,a,3)<0&&(h*=-1),h},generateEquidistantTicks:function(t,i){var r,o,n=e.eps,h=this.equidistant?this.ticksFunction(1):this.ticksDelta,l=a.evaluate(this.visProp.insertticks),c=a.evaluate(this.visProp.minorticks);if(this.line.elementClass===s.OBJECT_CLASS_LINE&&(o=this.getXandYdeltas()),h*=a.evaluate(this.visProp.scale),l&&this.minTicksDistance>e.eps?(h=this.adjustTickDistance(h,t,o),h/=c+1):l||(h/=c+1),this.ticksDelta=h,!(h<e.eps)){for(r=0,a.evaluate(this.visProp.drawzero)||(r=h);r<=i.upper+n&&(r>=i.lower-n&&this.processTickPosition(t,r,h,o),r+=h,!(i.upper-r>1e4*h)););for(r=-h;r>=i.lower-n&&(r<=i.upper+n&&this.processTickPosition(t,r,h,o),!((r-=h)-i.lower>1e4*h)););}},adjustTickDistance:function(t,e,i){var r,o,h,l=1,c=a.evaluate(this.visProp.minorticks);if(this.line.elementClass===s.OBJECT_CLASS_CURVE)return t;if(this.getLowerAndUpperBounds(e,"ticksdistance"),r=e.usrCoords[1]+i.x*t,o=e.usrCoords[2]+i.y*t,h=e.distance(s.COORDS_BY_SCREEN,new n(s.COORDS_BY_USER,[r,o],this.board)),0===t)return 0;for(;h/(c+1)<this.minTicksDistance;)t*=1===l?2:5,l*=-1,r=e.usrCoords[1]+i.x*t,o=e.usrCoords[2]+i.y*t,h=e.distance(s.COORDS_BY_SCREEN,new n(s.COORDS_BY_USER,[r,o],this.board));return t},processTickPosition:function(t,e,i,r){var o,h,l,c,d=null;this.line.elementClass===s.OBJECT_CLASS_LINE?(o=t.usrCoords[1]+e*r.x,h=t.usrCoords[2]+e*r.y):(o=this.line.X(t+e),h=this.line.Y(t+e)),l=new n(s.COORDS_BY_USER,[o,h],this.board),this.line.elementClass===s.OBJECT_CLASS_CURVE&&(d=t+e,this.setTicksSizeVariables(d)),l.major=Math.round(e/i)%(a.evaluate(this.visProp.minorticks)+1)==0,3===(c=this.createTickPath(l,l.major)).length&&(this.ticks.push(c),l.major&&a.evaluate(this.visProp.drawlabels)?this.labelsData.push(this.generateLabelData(this.generateLabelText(l,t,d),l,this.ticks.length)):this.labelsData.push(null))},generateFixedTicks:function(t,i){var r,o,h,l,c,d,u,p,f=e.eps,m=a.isArray(this.visProp.labels),g=a.evaluate(this.visProp.drawlabels);for(this.line.elementClass===s.OBJECT_CLASS_LINE&&(p=this.getXandYdeltas()),h=0;h<this.fixedTicks.length;h++)this.line.elementClass===s.OBJECT_CLASS_LINE?(u=this.fixedTicks[h],c=t.usrCoords[1]+u*p.x,d=t.usrCoords[2]+u*p.y):(u=t+this.fixedTicks[h],c=this.line.X(u),d=this.line.Y(u)),r=new n(s.COORDS_BY_USER,[c,d],this.board),this.line.elementClass===s.OBJECT_CLASS_CURVE&&this.setTicksSizeVariables(u),3===(l=this.createTickPath(r,!0)).length&&u>=i.lower-f&&u<=i.upper+f&&(this.ticks.push(l),g&&(m||a.exists(this.visProp.labels[h]))?(o=m?a.evaluate(this.visProp.labels[h]):u,this.labelsData.push(this.generateLabelData(this.generateLabelText(r,t,o),r,h))):this.labelsData.push(null))},getXandYdeltas:function(){var t,i,r=this.line.point1.Dist(this.line.point2);return this.line.type===s.OBJECT_TYPE_AXIS?(t=this.line.point1.coords.usrCoords,i=this.line.point2.coords.usrCoords,(t[1]>i[1]||Math.abs(t[1]-i[1])<e.eps&&t[2]>i[2])&&(t=this.line.point2.coords.usrCoords,i=this.line.point1.coords.usrCoords)):(t=this.line.point1.coords.usrCoords,i=this.line.point2.coords.usrCoords),{x:(i[1]-t[1])/r,y:(i[2]-t[2])/r}},_isInsideCanvas:function(t,e,i){var r=this.board.canvasWidth,s=this.board.canvasHeight;return void 0===i&&(i=0),t[0]>=i&&t[0]<=r-i&&e[0]>=i&&e[0]<=s-i||t[1]>=i&&t[1]<=r-i&&e[1]>=i&&e[1]<=s-i},createTickPath:function(t,e){var r,s,o,n,h,l,c,d,u,p,f,m,g,b,v=[-2e6,-2e6],y=[-2e6,-2e6];if(r=t.scrCoords,e?(n=this.dxMaj,h=this.dyMaj,u=this.majStyle):(n=this.dxMin,h=this.dyMin,u=this.minStyle),s=[-h*r[1]-n*r[2],h,n],e&&"polar"===a.evaluate(this.visProp.type)){if(m=this.board.getBoundingBox(),b=(g=2*Math.PI)/180,r=t.usrCoords,(f=Math.sqrt(r[1]*r[1]+r[2]*r[2]))<Math.max(Math.sqrt(m[0]*m[0]+m[1]*m[1]),Math.sqrt(m[2]*m[2]+m[3]*m[3]))){for(v=[],y=[],p=0;p<=g;p+=b)v.push(this.board.origin.scrCoords[1]+f*Math.cos(p)*this.board.unitX),y.push(this.board.origin.scrCoords[2]+f*Math.sin(p)*this.board.unitY);return[v,y,e]}}else if("infinite"===u?(o=i.meetLineBoard(s,this.board),v[0]=o[0].scrCoords[1],v[1]=o[1].scrCoords[1],y[0]=o[0].scrCoords[2],y[1]=o[1].scrCoords[2]):(d=">"===a.evaluate(this.visProp.face)?Math.PI/4:"<"===a.evaluate(this.visProp.face)?-Math.PI/4:0,l=Math.cos(d)*n-Math.sin(d)*h,c=Math.sin(d)*n+Math.cos(d)*h,v[0]=r[1]+l*a.evaluate(this.visProp.tickendings[0]),y[0]=r[2]-c*a.evaluate(this.visProp.tickendings[0]),v[1]=r[1],y[1]=r[2],d=-d,l=Math.cos(d)*n-Math.sin(d)*h,c=Math.sin(d)*n+Math.cos(d)*h,v[2]=r[1]-l*a.evaluate(this.visProp.tickendings[1]),y[2]=r[2]+c*a.evaluate(this.visProp.tickendings[1])),this._isInsideCanvas(v,y))return[v,y,e];return[]},formatLabelText:function(t){var e,i=t.toString(),r=a.evaluate(this.visProp.scalesymbol);return a.isNumber(t)&&((i.length>a.evaluate(this.visProp.maxlabellength)||-1!==i.indexOf("e"))&&(e=a.evaluate(this.visProp.digits),3!==a.evaluate(this.visProp.precision)&&3===e&&(e=a.evaluate(this.visProp.precision)),i=t.toPrecision(e).toString()),a.evaluate(this.visProp.beautifulscientificticklabels)&&(i=this.beautifyScientificNotationLabel(i)),i.indexOf(".")>-1&&-1===i.indexOf("e")&&(i=(i=i.replace(/0+$/,"")).replace(/\.$/,""))),r.length>0&&("1"===i?i=r:"-1"===i?i="-"+r:"0"!==i&&(i+=r)),a.evaluate(this.visProp.useunicodeminus)&&(i=i.replace(/-/g,"−")),i},beautifyScientificNotationLabel:function(t){return-1===t.indexOf("e")?t:(parseFloat(t.substring(0,t.indexOf("e")))+t.substring(t.indexOf("e"))).replace(/e(.*)$/g,(function(t,e){var i="•10";return i+=e.replace(/-/g,"⁻").replace(/\+/g,"").replace(/0/g,"⁰").replace(/1/g,"¹").replace(/2/g,"²").replace(/3/g,"³").replace(/4/g,"⁴").replace(/5/g,"⁵").replace(/6/g,"⁶").replace(/7/g,"⁷").replace(/8/g,"⁸").replace(/9/g,"⁹")}))},generateLabelText:function(t,i,r){var s;if(!a.exists(r)){if(s=this.getDistanceFromZero(i,t),Math.abs(s)<e.eps)return"0";r=s/a.evaluate(this.visProp.scale)}return this.formatLabelText(r)},generateLabelData:function(t,e,i){var r,s,o,n;return n=a.evaluate(this.visProp.label.fontsize),r=[e.scrCoords[1],e.scrCoords[1]],s=[e.scrCoords[2],e.scrCoords[2]],o=void 0===n?12:n,o*=.5,this._isInsideCanvas(r,s,o)?(r=a.evaluate(this.visProp.label.offset[0]),s=a.evaluate(this.visProp.label.offset[1]),{x:e.usrCoords[1]+r/this.board.unitX,y:e.usrCoords[2]+s/this.board.unitY,t:t,i:i}):null},update:function(){return this.needsUpdate&&0!==this.board.canvasWidth&&0!==this.board.canvasHeight&&this.calculateTicksCoordinates(),this},updateRenderer:function(){return this.needsUpdate?(this.visPropCalc.visible&&this.board.renderer.updateTicks(this),this.updateRendererLabels(),this.setDisplayRendNode(),this.needsUpdate=!1,this):this},updateRendererLabels:function(){var t,e,i,r,s,o,n,l;for(i=this.labelsData.length,r=this.labels.length,t=0,e=0;t<i;t++)null!==this.labelsData[t]&&(n=this.labelsData[t],e<r?((o=this.labels[e]).setText(n.t),o.setCoords(n.x,n.y),e++):(this.labelCounter+=1,s={isLabel:!0,layer:this.board.options.layer.line,highlightStrokeColor:this.board.options.text.strokeColor,highlightStrokeWidth:this.board.options.text.strokeWidth,highlightStrokeOpacity:this.board.options.text.strokeOpacity,priv:this.visProp.priv},(s=a.deepCopy(s,this.visProp.label)).id=this.id+n.i+"Label"+this.labelCounter,(o=h.createText(this.board,[n.x,n.y,n.t],s)).isDraggable=!1,o.dump=!1,this.labels.push(o)),"inherit"===(l=a.evaluate(this.visProp.label.visible))&&(l=this.visPropCalc.visible),o.prepareUpdate().updateVisibility(l).updateRenderer(),o.distanceX=a.evaluate(this.visProp.label.offset[0]),o.distanceY=a.evaluate(this.visProp.label.offset[1]));for(e=i=e;e<r;e++)this.board.renderer.display(this.labels[e],!1),this.labels[e].visProp.visible=this.labels[e].visPropCalc.visible=!1;return this},hideElement:function(){var e;for(t.deprecated("Element.hideElement()","Element.setDisplayRendNode()"),this.visPropCalc.visible=!1,this.board.renderer.display(this,!1),e=0;e<this.labels.length;e++)a.exists(this.labels[e])&&this.labels[e].hideElement();return this},showElement:function(){var e;for(t.deprecated("Element.showElement()","Element.setDisplayRendNode()"),this.visPropCalc.visible=!0,this.board.renderer.display(this,!1),e=0;e<this.labels.length;e++)a.exists(this.labels[e])&&this.labels[e].showElement();return this}}),t.createTicks=function(e,i,r){var o,n,h=a.copyAttributes(r,e.options,"ticks");if(n=i.length<2?h.ticksdistance:i[1],i[0].elementClass!==s.OBJECT_CLASS_LINE&&i[0].elementClass!==s.OBJECT_CLASS_CURVE)throw new Error("JSXGraph: Can't create Ticks with parent types '"+typeof i[0]+"'.");return o=new t.Ticks(i[0],n,h),a.isFunction(h.generatelabelvalue)&&(o.generateLabelText=h.generatelabelvalue),a.isFunction(h.generatelabeltext)&&(o.generateLabelText=h.generatelabeltext),o.setParents(i[0]),o.isDraggable=!0,o.fullUpdate(i[0].visPropCalc.visible),o},t.createHatchmark=function(t,e,i){var r,o,n,h,l,c=[],d=a.copyAttributes(i,t.options,"hatch");if(e[0].elementClass!==s.OBJECT_CLASS_LINE&&e[0].elementClass!==s.OBJECT_CLASS_CURVE||"number"!=typeof e[1])throw new Error("JSXGraph: Can't create Hatch mark with parent types '"+typeof e[0]+"' and '"+typeof e[1]+" and ''"+typeof e[2]+"'.");for(n=.5*-(((r=e[1])-1)*(h=d.ticksdistance)),o=0;o<r;o++)c[o]=n+o*h;return(l=t.create("ticks",[e[0],c],d)).elType="hatch",l},t.registerElement("ticks",t.createTicks),t.registerElement("hash",t.createHatchmark),t.registerElement("hatch",t.createHatchmark),{Ticks:t.Ticks,createTicks:t.createTicks,createHashmark:t.createHatchmark,createHatchmark:t.createHatchmark}})),define("parser/ca",["jxg","base/constants","base/text","math/math","math/geometry","math/statistics","utils/type","utils/env"],(function(t,e,i,r,s,o,n,a){"use strict";return t.CA=function(t,e,i){this.node=t,this.createNode=e,this.parser=i},t.extend(t.CA.prototype,{findMapNode:function(t,e){var i,r,s;if("op_assign"===e.value&&e.children[0].value===t)return e.children[1];if(e.children)for(r=e.children.length,i=0;i<r;++i)if(null!==(s=this.findMapNode(t,e.children[i])))return s;return null},setMath:function(t){var e,i;if(("node_op"!=t.type||"op_add"!=t.value&&"op_sub"!=t.value&&"op_mul"!=t.value&&"op_div"!=t.value&&"op_neg"!=t.value&&"op_execfun"!=t.value&&"op_exp"!=t.value)&&"node_var"!=t.type&&"node_const"!=t.type||(t.isMath=!0),t.children)for(i=t.children.length,e=0;e<i;++e)this.setMath(t.children[e])},deriveElementary:function(t,e){var i,r=t.children[0].value,s=t.children[1];switch(r){case"abs":i=this.createNode("node_op","op_div",s[0],this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_mul",n.deepCopy(s[0]),n.deepCopy(s[0]))]));break;case"sqrt":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_mul",this.createNode("node_const",2),this.createNode(t.type,t.value,n.deepCopy(t.children[0]),n.deepCopy(t.children[1]))));break;case"sin":i=this.createNode("node_op","op_execfun",this.createNode("node_var","cos"),n.deepCopy(s));break;case"cos":i=this.createNode("node_op","op_neg",this.createNode("node_op","op_execfun",this.createNode("node_var","sin"),n.deepCopy(s)));break;case"tan":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_exp",this.createNode("node_op","op_execfun",this.createNode("node_var","cos"),n.deepCopy(s)),this.createNode("node_const",2)));break;case"cot":i=this.createNode("node_op","op_neg",this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_exp",this.createNode("node_op","op_execfun",this.createNode("node_var","sin"),n.deepCopy(s)),this.createNode("node_const",2))));break;case"exp":i=this.createNode(t.type,t.value,n.deepCopy(t.children[0]),n.deepCopy(t.children[1]));break;case"pow":i=this.createNode("node_op","op_mul",this.createNode("node_op","op_execfun",n.deepCopy(t.children[0]),n.deepCopy(t.children[1])),this.createNode("node_op","op_add",this.createNode("node_op","op_mul",this.derivative(t.children[1][0],e),this.createNode("node_op","op_div",n.deepCopy(t.children[1][1]),n.deepCopy(t.children[1][0]))),this.createNode("node_op","op_mul",this.derivative(t.children[1][1],e),this.createNode("node_op","op_execfun",this.createNode("node_var","log"),[n.deepCopy(t.children[1][0])]))));break;case"log":case"ln":i=this.createNode("node_op","op_div",this.createNode("node_const",1),n.deepCopy(s[0]));break;case"log2":case"lb":case"ld":i=this.createNode("node_op","op_mul",this.createNode("node_op","op_div",this.createNode("node_const",1),n.deepCopy(s[0])),this.createNode("node_const",1.4426950408889634));break;case"log10":case"lg":i=this.createNode("node_op","op_mul",this.createNode("node_op","op_div",this.createNode("node_const",1),n.deepCopy(s[0])),this.createNode("node_const",.43429448190325176));break;case"asin":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_sub",this.createNode("node_const",1),this.createNode("node_op","op_mul",n.deepCopy(s[0]),n.deepCopy(s[0])))]));break;case"acos":i=this.createNode("node_op","op_neg",this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_sub",this.createNode("node_const",1),this.createNode("node_op","op_mul",n.deepCopy(s[0]),n.deepCopy(s[0])))])));break;case"atan":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_add",this.createNode("node_const",1),this.createNode("node_op","op_mul",n.deepCopy(s[0]),n.deepCopy(s[0]))));break;case"acot":i=this.createNode("node_op","op_neg",this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_add",this.createNode("node_const",1),this.createNode("node_op","op_mul",n.deepCopy(s[0]),n.deepCopy(s[0])))));break;case"sinh":i=this.createNode("node_op","op_execfun",this.createNode("node_var","cosh"),[n.deepCopy(s[0])]);break;case"cosh":i=this.createNode("node_op","op_execfun",this.createNode("node_var","sinh"),[n.deepCopy(s[0])]);break;case"tanh":i=this.createNode("node_op","op_sub",this.createNode("node_const",1),this.createNode("node_op","op_exp",this.createNode("node_op","op_execfun",this.createNode("node_var","tanh"),[n.deepCopy(s[0])]),this.createNode("node_const",2)));break;case"asinh":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_add",this.createNode("node_op","op_mul",n.deepCopy(s[0]),n.deepCopy(s[0])),this.createNode("node_const",1))]));break;case"acosh":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_execfun",this.createNode("node_var","sqrt"),[this.createNode("node_op","op_sub",this.createNode("node_op","op_mul",n.deepCopy(s[0]),n.deepCopy(s[0])),this.createNode("node_const",1))]));break;case"atanh":i=this.createNode("node_op","op_div",this.createNode("node_const",1),this.createNode("node_op","op_sub",this.createNode("node_const",1),this.createNode("node_op","op_mul",n.deepCopy(s[0]),n.deepCopy(s[0]))));break;default:throw i=this.createNode("node_const",0),console.log('Derivative of "'+r+'" not yet implemented'),new Error("Error("+this.line+"): ")}return i},derivative:function(t,e){var i;switch(t.type){case"node_op":switch(t.value){case"op_execfun":i="pow"==t.children[0].value?this.deriveElementary(t,e):0===t.children[1].length?this.createNode("node_const",0):this.createNode("node_op","op_mul",this.deriveElementary(t,e),this.derivative(t.children[1][0],e));break;case"op_div":i=this.createNode("node_op","op_div",this.createNode("node_op","op_sub",this.createNode("node_op","op_mul",this.derivative(t.children[0],e),n.deepCopy(t.children[1])),this.createNode("node_op","op_mul",n.deepCopy(t.children[0]),this.derivative(t.children[1],e))),this.createNode("node_op","op_mul",n.deepCopy(t.children[1]),n.deepCopy(t.children[1])));break;case"op_mul":i=this.createNode("node_op","op_add",this.createNode("node_op","op_mul",n.deepCopy(t.children[0]),this.derivative(t.children[1],e)),this.createNode("node_op","op_mul",this.derivative(t.children[0],e),n.deepCopy(t.children[1])));break;case"op_neg":i=this.createNode("node_op","op_neg",this.derivative(t.children[0],e));break;case"op_add":case"op_sub":i=this.createNode("node_op",t.value,this.derivative(t.children[0],e),this.derivative(t.children[1],e));break;case"op_exp":i=this.createNode("node_op","op_mul",n.deepCopy(t),this.createNode("node_op","op_add",this.createNode("node_op","op_mul",this.derivative(t.children[0],e),this.createNode("node_op","op_div",n.deepCopy(t.children[1]),n.deepCopy(t.children[0]))),this.createNode("node_op","op_mul",this.derivative(t.children[1],e),this.createNode("node_op","op_execfun",this.createNode("node_var","log"),[n.deepCopy(t.children[0])]))))}break;case"node_var":i=t.value===e?this.createNode("node_const",1):this.createNode("node_const",0);break;case"node_const":i=this.createNode("node_const",0)}return i},expandDerivatives:function(t,e,i){var r,s,o,a,h,l,c,d,u,p,f;if(0,!t)return 0;for(this.line=t.line,this.col=t.col,r=t.children.length,s=0;s<r;++s)if(t.children[s]&&t.children[s].type)t.children[s]=this.expandDerivatives(t.children[s],t,i);else if(n.isArray(t.children[s]))for(o=0;o<t.children[s].length;++o)t.children[s][o]&&t.children[s][o].type&&(t.children[s][o]=this.expandDerivatives(t.children[s][o],t,i));if("node_op"===t.type)if("op_execfun"===t.value)if(t.children[0]&&"D"===t.children[0].value){if("node_var"==t.children[1][0].type?(d=t.children[1][0].value,p=(a=this.findMapNode(d,i)).children[0],u=t.children[1].length>=2?t.children[1][1].value:a.children[0][0],h=a.children[1]):(h=t.children[1][0],p=["x"],u=t.children[1].length>=2?t.children[1][1].value:"x"),c=h,(f=t.children[1].length>=3?t.children[1][2].value:1)>=1)for(;f>=1;)c=this.derivative(c,u),c=this.removeTrivialNodes(c),f--;l="node_op"==e.type&&"op_assign"==e.value?this.createNode("node_op","op_map",p,c):c,this.setMath(l),t.type=l.type,t.value=l.value,t.children[0]=l.children[0],t.children[1]=l.children[1]}return t},removeTrivialNodes:function(t){var e,i,r,s,o;if(n.isArray(t))for(i=t.length,e=0;e<i;++e)t[e]=this.removeTrivialNodes(t[e]);if("node_op"!=t.type||!t.children)return t;for(i=t.children.length,e=0;e<i;++e){this.mayNotBeSimplified=!1;do{t.children[e]=this.removeTrivialNodes(t.children[e])}while(this.mayNotBeSimplified)}switch(t.value){case"op_map":if(r=t.children[0],"node_var"==(s=t.children[1]).type)for(e=0;e<r.length;++e)if(r[e]==s.value){s.isMath=!0;break}break;case"op_add":if(r=t.children[0],s=t.children[1],"node_const"==r.type&&0===r.value)return s;if("node_const"==s.type&&0===s.value)return r;if("node_const"==r.type&&"node_const"==s.type)return r.value+=s.value,r;break;case"op_mul":if(r=t.children[0],s=t.children[1],"node_const"==r.type&&1==r.value)return s;if("node_const"==s.type&&1==s.value)return r;if("node_const"==r.type&&0===r.value)return r;if("node_const"==s.type&&0===s.value)return s;if("node_const"==s.type&&0===s.value)return s;if("node_op"==r.type&&"op_neg"==r.value&&"node_op"==s.type&&"op_neg"==s.value)return t.children=[r.children[0],s.children[0]],this.mayNotBeSimplified=!0,t;if("op_neg"==r.value&&"op_neg"!=s.value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_op","op_mul",r.children[0],s)],this.mayNotBeSimplified=!0,t;if("op_neg"!=r.value&&"op_neg"==s.value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_op","op_mul",r,s.children[0])],this.mayNotBeSimplified=!0,t;if("op_div"==r.value&&"node_const"==r.children[0].type&&1==r.children[0].value)return t.type="node_op",t.value="op_div",t.children=[s,r.children[1]],this.mayNotBeSimplified=!0,t;if("op_div"==s.value&&"node_const"==s.children[0].type&&1==s.children[0].value)return t.type="node_op",t.value="op_div",t.children=[r,s.children[1]],this.mayNotBeSimplified=!0,t;if("node_const"!=r.type&&"node_const"==s.type)return t.children=[s,r],this.mayNotBeSimplified=!0,t;if("node_const"!=r.type&&"node_op"==s.type&&"op_neg"==s.value&&"node_const"==s.children[0].type)return t.children=[s,r],this.mayNotBeSimplified=!0,t;if("node_op"==r.type&&"op_execfun"!=r.value&&("node_var"==s.type||"node_op"==s.type&&"op_execfun"==s.value))return t.children=[s,r],this.mayNotBeSimplified=!0,t;if("node_op"!=r.type&&"node_op"==s.type&&"op_neg"==s.value&&"node_var"==s.children[0].type)return t.children=[s,r],this.mayNotBeSimplified=!0,t;if("node_const"!=r.type&&"node_op"==s.type&&("op_mul"==s.value||"op_div"==s.value)&&"node_const"==s.children[0].type)return o=s.children[0],s.children[0]=r,t.children=[o,s],this.mayNotBeSimplified=!0,t;if("node_const"!=s.type&&"node_op"==r.type&&"op_mul"==r.value&&"node_const"==r.children[0].type)return t.children=[r.children[0],this.createNode("node_op","op_mul",r.children[1],s)],this.mayNotBeSimplified=!0,t;if("node_const"==r.type&&"node_const"==s.type)return r.value*=s.value,r;if("node_const"==r.type&&"node_op"==s.type&&("op_mul"==s.value||"op_div"==s.value)&&"node_const"==s.children[0].type)return s.children[0].value*=r.value,s;if(r.hash=this.parser.compile(r),s.hash=this.parser.compile(s),r.hash===s.hash)return t.value="op_exp",t.children[1]=this.createNode("node_const",2),t;if("node_const"==r.type&&"node_op"==s.type&&("op_mul"==s.value||"op_div"==s.value)&&"node_const"==s.children[0].type)return s.children[0].value*=r.value,s;if("node_op"==s.type&&"op_exp"==s.value&&(r.hash||(r.hash=this.parser.compile(r)),s.children[0].hash||(s.children[0].hash=this.parser.compile(s.children[0])),r.hash===s.children[0].hash))return s.children[1]=this.createNode("node_op","op_add",s.children[1],this.createNode("node_const",1)),this.mayNotBeSimplified=!0,s;if("node_op"==r.type&&"op_exp"==r.value&&"node_op"==s.type&&"op_exp"==s.value&&(r.children[0].hash=this.parser.compile(r.children[0]),s.children[0].hash=this.parser.compile(s.children[0]),r.children[0].hash===s.children[0].hash))return r.children[1]=this.createNode("node_op","op_add",r.children[1],s.children[1]),this.mayNotBeSimplified=!0,r;break;case"op_sub":if(r=t.children[0],s=t.children[1],"node_const"==r.type&&0===r.value)return t.value="op_neg",t.children[0]=s,t;if("node_const"==s.type&&0===s.value)return r;if("node_const"==r.type&&"node_const"==s.type&&r.value==s.value)return this.createNode("node_const",0);if("node_var"==r.type&&"node_var"==s.type&&r.value==s.value)return this.createNode("node_const",0);if("node_const"==r.type&&"node_const"==s.type)return r.value-=s.value,r;if("node_op"==r.type&&"op_mul"==r.value&&"node_op"==s.type&&"op_mul"==s.value&&(r.children[1].hash=this.parser.compile(r.children[1]),s.children[1].hash=this.parser.compile(s.children[1]),r.children[1].hash===s.children[1].hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_sub",r.children[0],s.children[0]),r.children[1]],this.mayNotBeSimplified=!0,t;if("node_op"==r.type&&"op_mul"==r.value&&(r.children[1].hash=this.parser.compile(r.children[1]),s.hash=this.parser.compile(s),r.children[1].hash===s.hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_sub",r.children[0],this.createNode("node_const",1)),s],this.mayNotBeSimplified=!0,t;if("node_op"==s.type&&"op_mul"==s.value&&(s.children[1].hash=this.parser.compile(s.children[1]),r.hash=this.parser.compile(r),s.children[1].hash===r.hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_sub",this.createNode("node_const",1),s.children[0]),r],this.mayNotBeSimplified=!0,t;break;case"op_neg":if("node_const"==(r=t.children[0]).type&&0===r.value)return r;if("node_op"==r.type&&"op_neg"==r.value)return r.children[0];break;case"op_div":if(r=t.children[0],s=t.children[1],"node_const"==r.type&&"node_const"==s.type&&r.value==s.value&&0!==r.value)return r.value=1,r;if("node_const"==r.type&&0===r.value&&"node_const"==s.type&&0!==s.value)return r.value=0,r;if("node_const"==r.type&&0===r.value&&("node_op"==s.type||"node_var"==s.type))return t.type="node_const",t.value=0,t;if("node_var"==r.type&&"node_var"==s.type&&r.value==s.value)return this.createNode("node_const",1);if("node_const"==r.type&&0!==r.value&&"node_const"==s.type&&0===s.value)return r.value>0?r.value=1/0:r.value=-1/0,r;if("node_op"==r.type&&"op_neg"==r.value&&"node_op"==s.type&&"op_neg"==s.value)return t.children=[r.children[0],s.children[0]],this.mayNotBeSimplified=!0,t;if("op_neg"==r.value&&"op_neg"!=s.value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_op","op_div",r.children[0],s)],this.mayNotBeSimplified=!0,t;if("op_neg"!=r.value&&"op_neg"==s.value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_op","op_div",r,s.children[0])],this.mayNotBeSimplified=!0,t;if("node_op"==r.type&&"op_exp"==r.value&&(s.hash||(s.hash=this.parser.compile(s)),r.children[0].hash||(r.children[0].hash=this.parser.compile(r.children[0])),s.hash===r.children[0].hash))return r.children[1]=this.createNode("node_op","op_sub",r.children[1],this.createNode("node_const",1)),this.mayNotBeSimplified=!0,r;if("node_const"!=s.type&&"node_op"==r.type&&"op_mul"==r.value&&"node_const"==r.children[0].type)return t.value="op_mul",t.children=[r.children[0],this.createNode("node_op","op_div",r.children[1],s)],this.mayNotBeSimplified=!0,t;if("node_op"==r.type&&"op_exp"==r.value&&"node_op"==s.type&&"op_exp"==s.value&&(r.children[0].hash=this.parser.compile(r.children[0]),s.children[0].hash=this.parser.compile(s.children[0]),r.children[0].hash===s.children[0].hash))return r.children[1]=this.createNode("node_op","op_sub",r.children[1],s.children[1]),this.mayNotBeSimplified=!0,r;break;case"op_exp":if(r=t.children[0],"node_const"==(s=t.children[1]).type&&0===s.value)return s.value=1,s;if("node_const"==s.type&&1==s.value)return r;if("node_const"==r.type&&1==r.value)return r;if("node_const"==r.type&&0===r.value&&"node_const"==s.type&&0!==s.value)return r;if("node_op"==r.type&&"op_exp"==r.value)return t.children=[r.children[0],this.createNode("node_op","op_mul",r.children[1],s)],t}switch(t.value){case"op_add":if(r=t.children[0],s=t.children[1],"node_const"==r.type&&"node_const"==s.type&&r.value==s.value)return r.value+=s.value,r;if("node_var"==r.type&&"node_var"==s.type&&r.value==s.value)return t.children[0]=this.createNode("node_const",2),t.value="op_mul",t;if("node_op"==r.type&&"op_neg"==r.value)return t.value="op_sub",t.children[0]=s,t.children[1]=r.children[0],this.mayNotBeSimplified=!0,t;if("node_op"==s.type&&"op_neg"==s.value)return t.value="op_sub",t.children[1]=s.children[0],this.mayNotBeSimplified=!0,t;if("node_op"==r.type&&"op_mul"==r.value&&"node_op"==s.type&&"op_mul"==s.value&&(r.children[1].hash=this.parser.compile(r.children[1]),s.children[1].hash=this.parser.compile(s.children[1]),r.children[1].hash===s.children[1].hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_add",r.children[0],s.children[0]),r.children[1]],this.mayNotBeSimplified=!0,t;if("node_op"==r.type&&"op_mul"==r.value&&(r.children[1].hash=this.parser.compile(r.children[1]),s.hash=this.parser.compile(s),r.children[1].hash===s.hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_add",r.children[0],this.createNode("node_const",1)),s],this.mayNotBeSimplified=!0,t;if("node_op"==s.type&&"op_mul"==s.value&&(s.children[1].hash=this.parser.compile(s.children[1]),r.hash=this.parser.compile(r),s.children[1].hash===r.hash))return t.value="op_mul",t.children=[this.createNode("node_op","op_add",this.createNode("node_const",1),s.children[0]),r],this.mayNotBeSimplified=!0,t;break;case"op_sub":if(r=t.children[0],"node_op"==(s=t.children[1]).type&&"op_neg"==s.value)return t.value="op_add",t.children[1]=s.children[0],this.mayNotBeSimplified=!0,t;break;case"op_execfun":return this.simplifyElementary(t)}return t},simplifyElementary:function(t){var e=t.children[0].value,i=t.children[1];if(0==i.length)return t;switch(e){case"sin":case"tan":if("node_const"==i[0].type&&0===i[0].value)return t.type="node_const",t.value=0,t;if("node_var"==i[0].type&&"PI"==i[0].value)return t.type="node_const",t.value=0,t;if("node_op"==i[0].type&&"op_mul"==i[0].value&&"node_const"==i[0].children[0].type&&i[0].children[0].value%1==0&&"node_var"==i[0].children[1].type&&"PI"==i[0].children[1].value)return t.type="node_const",t.value=0,t;break;case"cos":if("node_const"==i[0].type&&0===i[0].value)return t.type="node_const",t.value=1,t;if("node_var"==i[0].type&&"PI"==i[0].value)return t.type="node_op",t.value="op_neg",t.children=[this.createNode("node_const",1)],t;break;case"exp":if("node_const"==i[0].type&&0===i[0].value)return t.type="node_const",t.value=1,t;break;case"pow":if("node_const"==i[1].type&&0===i[1].value)return t.type="node_const",t.value=1,t}return t}}),t.CA})),define("utils/dump",["jxg","utils/type"],(function(t,e){"use strict";return t.Dump={addMarkers:function(t,i,r){var s,o,n;for(s in e.isArray(i)||(i=[i]),e.isArray(r)||(r=[r]),o=Math.min(i.length,r.length),i.length=o,r.length=o,t.objects)if(t.objects.hasOwnProperty(s))for(n=0;n<o;n++)t.objects[s][i[n]]=r[n]},deleteMarkers:function(t,i){var r,s,o;for(r in e.isArray(i)||(i=[i]),s=i.length,i.length=s,t.objects)if(t.objects.hasOwnProperty(r))for(o=0;o<s;o++)delete t.objects[r][i[o]]},str:function(t){return"string"==typeof t&&"function"!==t.substr(0,7)&&(t='"'+t+'"'),t},minimizeObject:function(i,r){var s,o,n,a={},h=e.deepCopy(i),l=[];for(n=1;n<arguments.length;n++)l.push(arguments[n]);for(a=e.deepCopy(a,t.Options.elements,!0),n=l.length;n>0;n--)a=e.deepCopy(a,l[n-1],!0);for(s in a)a.hasOwnProperty(s)&&(o=s.toLowerCase(),"object"!=typeof a[s]&&a[s]===h[o]&&delete h[o]);return h},prepareAttributes:function(e,i){var r,s;for(s in r=this.minimizeObject(i.getAttributes(),t.Options[i.elType]),i.subs)i.subs.hasOwnProperty(s)&&(r[s]=this.minimizeObject(i.subs[s].getAttributes(),t.Options[i.elType][s],t.Options[i.subs[s].elType]),r[s].id=i.subs[s].id,r[s].name=i.subs[s].name);return r.id=i.id,r.name=i.name,r},setBoundingBox:function(t,e,i){return t.push({obj:i,method:"setBoundingBox",params:[e.getBoundingBox(),e.keepaspectratio]}),t},dump:function(t){var i,r,s,o,n=[],a=[],h=t.objectsList.length;for(this.addMarkers(t,"dumped",!1),i=0;i<h;i++)if(s={},!(r=t.objectsList[i]).dumped&&r.dump){for(s.type=r.getType(),s.parents=r.getParents().slice(),"point"===s.type&&1===s.parents[0]&&(s.parents=s.parents.slice(1)),o=0;o<s.parents.length;o++)e.isString(s.parents[o])&&"'"!==s.parents[o][0]&&'"'!==s.parents[o][0]?s.parents[o]='"'+s.parents[o]+'"':e.isArray(s.parents[o])&&(s.parents[o]="["+s.parents[o].toString()+"]");s.attributes=this.prepareAttributes(t,r),"glider"===s.type&&r.onPolygon&&n.push({obj:r.id,prop:"onPolygon",val:!0}),a.push(s)}return this.deleteMarkers(t,"dumped"),{elements:a,props:n,methods:[]}},arrayToParamStr:function(t,e){var i,r=[];for(i=0;i<t.length;i++)r.push(e.call(this,t[i]));return r.join(", ")},toJCAN:function(t){var i,r,s;switch(typeof t){case"object":if(t){if(r=[],e.isArray(t)){for(i=0;i<t.length;i++)r.push(this.toJCAN(t[i]));return"["+r.join(",")+"]"}for(s in t)t.hasOwnProperty(s)&&r.push(s+": "+this.toJCAN(t[s]));return"<<"+r.join(", ")+">> "}return"null";case"string":return"'"+t.replace(/\\/g,"\\\\").replace(/(["'])/g,"\\$1")+"'";case"number":case"boolean":return t.toString();case"null":return"null"}},toJessie:function(t){var e,i,r,s=this.dump(t),o=[];for(s.methods=this.setBoundingBox(s.methods,t,"$board"),i=s.elements,e=0;e<i.length;e++)i[e].attributes.name.length>0&&o.push("// "+i[e].attributes.name),o.push("s"+e+" = "+i[e].type+"("+i[e].parents.join(", ")+") "+this.toJCAN(i[e].attributes).replace(/\n/,"\\n")+";"),"axis"===i[e].type&&(r=i[e].attributes.id,null===t.objects[r].defaultTicks&&o.push("s"+e+".removeAllTicks();")),o.push("");for(e=0;e<s.methods.length;e++)o.push(s.methods[e].obj+"."+s.methods[e].method+"("+this.arrayToParamStr(s.methods[e].params,this.toJCAN)+");"),o.push("");for(e=0;e<s.props.length;e++)o.push(s.props[e].obj+"."+s.props[e].prop+" = "+this.toJCAN(s.props[e].val)+";"),o.push("");return o.join("\n")},toJavaScript:function(t){var i,r,s,o=this.dump(t),n=[];for(o.methods=this.setBoundingBox(o.methods,t,"board"),r=o.elements,i=0;i<r.length;i++)n.push('board.create("'+r[i].type+'", ['+r[i].parents.join(", ")+"], "+e.toJSON(r[i].attributes)+");"),"axis"===r[i].type&&(s=r[i].attributes.id,null===t.objects[s].defaultTicks&&n.push('board.objects["'+s+'"].removeTicks(board.objects["'+s+'"].defaultTicks);'));for(i=0;i<o.methods.length;i++)n.push(o.methods[i].obj+"."+o.methods[i].method+"("+this.arrayToParamStr(o.methods[i].params,e.toJSON)+");"),n.push("");for(i=0;i<o.props.length;i++)n.push(o.props[i].obj+"."+o.props[i].prop+" = "+e.toJSON(o.props[i].val)+";"),n.push("");return n.join("\n")}},t.Dump})),define("element/comb",["jxg","utils/type","base/point"],(function(t,e,i){"use strict";return t.createComb=function(t,r,s){var o,n,a,h,l;if(2!==r.length)throw l=r.map((function(t){return"'"+typeof t+"'"})),new Error("JSXGraph: Can't create comb with parent types "+l.join(", ")+".\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]");if(e.isArray(r[0])&&r[0].length>1)h=e.copyAttributes(s,t.options,"comb","point1"),o=t.create("point",r[0],h);else if(e.isString(r[0])||e.isPoint(r[0]))o=t.select(r[0]);else if(e.isFunction(r[0])&&e.isPoint(r[0]()))o=r[0]();else{if(!(e.isFunction(r[0])&&r[0]().length&&r[0]().length>=2))throw new Error("JSXGraph: Can't create comb with parent types '"+typeof r[0]+"' and '"+typeof r[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]");h=e.copyAttributes(s,t.options,"comb","point1"),o=i.createPoint(t,r[0](),h)}if(e.isArray(r[1])&&r[1].length>1)h=e.copyAttributes(s,t.options,"comb","point2"),n=t.create("point",r[1],h);else if(e.isString(r[1])||e.isPoint(r[1]))n=t.select(r[1]);else if(e.isFunction(r[1])&&e.isPoint(r[1]()))n=r[1]();else{if(!(e.isFunction(r[1])&&r[1]().length&&r[1]().length>=2))throw new Error("JSXGraph: Can't create comb with parent types '"+typeof r[0]+"' and '"+typeof r[1]+"'.\nPossible parent types: [point,point], [[x1,y1],[x2,y2]]");h=e.copyAttributes(s,t.options,"comb","point2"),n=i.createPoint(t,r[1](),h)}return h=e.copyAttributes(s,t.options,"comb"),e.merge(h,e.copyAttributes(s,t.options,"comb","curve")),(a=t.create("curve",[[0],[0]],h)).updateDataArray=function(){var t,i,r,s,h,l,c,d,u,p,f=0,m=o.Dist(n),g=o,b=n;for(d=e.evaluate(a.visProp.frequency),u=-e.evaluate(a.visProp.angle),p=e.evaluate(a.visProp.width),e.evaluate(a.visProp.reverse)&&(g=n,b=o,u=-u),t=Math.cos(u),i=Math.sin(u),r=(b.X()-g.X())/m,s=(b.Y()-g.Y())/m,t*=p/Math.abs(i),i*=p/Math.abs(i),this.dataX=[],this.dataY=[];f<m;)h=g.X()+r*f,l=g.Y()+s*f,i*=c=Math.min(t,m-f)/Math.abs(t),t*=c,this.dataX.push(h),this.dataY.push(l),this.dataX.push(h+r*t+s*i),this.dataY.push(l-r*i+s*t),this.dataX.push(NaN),this.dataY.push(NaN),f+=d},a},t.registerElement("comb",t.createComb),{createComb:t.createComb}})),define("element/slopetriangle",["jxg","utils/type","base/constants","base/polygon"],(function(t,e,i,r){"use strict";var s=function(){r.Polygon.prototype.remove.call(this),this.board.removeObject(this.toppoint),this.board.removeObject(this.glider),this.board.removeObject(this.baseline),this.board.removeObject(this.basepoint),this.board.removeObject(this.label),this._isPrivateTangent&&this.board.removeObject(this.tangent)},o=function(){return this.tangent.getSlope()};return t.createSlopeTriangle=function(r,n,a){var h,l,c,d,u,p,f,m,g,b=!1;if(1===n.length&&n[0].type===i.OBJECT_TYPE_TANGENT)l=n[0],c=l.glider;else if(1===n.length&&n[0].type===i.OBJECT_TYPE_GLIDER)c=n[0],g=e.copyAttributes(a,r.options,"slopetriangle","tangent"),l=r.create("tangent",[c],g),b=!0;else{if(2!==n.length||n[0].elementClass!==i.OBJECT_CLASS_LINE||!e.isPoint(n[1]))throw new Error("JSXGraph: Can't create slope triangle with parent types '"+typeof n[0]+"'.");l=n[0],c=n[1]}return g=e.copyAttributes(a,r.options,"slopetriangle","basepoint"),f=r.create("point",[function(){return[c.X()+1,c.Y()]}],g),g=e.copyAttributes(a,r.options,"slopetriangle","baseline"),p=r.create("line",[c,f],g),g=e.copyAttributes(a,r.options,"slopetriangle","glider"),d=r.create("glider",[c.X()+1,c.Y(),p],g),g=e.copyAttributes(a,r.options,"slopetriangle","toppoint"),u=r.create("point",[function(){return[d.X(),d.Y()+(d.X()-c.X())*l.getSlope()]}],g),(g=e.copyAttributes(a,r.options,"slopetriangle")).borders=e.copyAttributes(g.borders,r.options,"slopetriangle","borders"),(h=r.create("polygon",[c,d,u],g)).Value=o,h.tangent=l,h._isPrivateTangent=b,h.borders[2].setArrow(!1,!1),g=e.copyAttributes(a,r.options,"slopetriangle","label"),(m=r.create("text",[function(){return d.X()+.1},function(){return.5*(d.Y()+u.Y())},function(){return""}],g))._setText((function(){return e.toFixed(h.Value(),e.evaluate(m.visProp.digits))})),m.fullUpdate(),h.glider=d,h.basepoint=f,h.baseline=p,h.toppoint=u,h.label=m,h.subs={glider:d,basePoint:f,baseLine:p,topPoint:u,label:m},h.inherits.push(d,f,p,u,m),h.methodMap=t.deepCopy(h.methodMap,{tangent:"tangent",glider:"glider",basepoint:"basepoint",baseline:"baseline",toppoint:"toppoint",label:"label",Value:"Value",V:"Value"}),h.remove=s,h},t.registerElement("slopetriangle",t.createSlopeTriangle),{createSlopeTriangle:t.createSlopeTriangle}})),define("element/checkbox",["jxg","utils/env","utils/type"],(function(t,e,i){"use strict";var r=function(){this._value=this.rendNodeCheckbox.checked,this.board.update()};return t.createCheckbox=function(s,o,n){var a,h,l=i.copyAttributes(n,s.options,"checkbox");return h=[o[0],o[1],'<span style="display:inline"><input type="checkbox" /><label for=""></label></span>'],(a=s.create("text",h,l)).type=i.OBJECT_TYPE_CHECKBOX,a.rendNodeCheckbox=a.rendNode.childNodes[0].childNodes[0],a.rendNodeLabel=a.rendNode.childNodes[0].childNodes[1],a.rendNodeTag=a.rendNodeCheckbox,a.rendNodeTag.disabled=!!l.disabled,a.rendNodeLabel.innerHTML=o[2],a.rendNodeCheckbox.id=a.rendNode.id+"_checkbox",a.rendNodeLabel.id=a.rendNode.id+"_label",a.rendNodeLabel.setAttribute("for",a.rendNodeCheckbox.id),a.visPropOld.fontsize="0px",s.renderer.updateTextStyle(a,!1),a.rendNodeCheckbox.checked=l.checked,a._value=l.checked,a.Value=function(){return this._value},a.update=function(){return this.needsUpdate&&(t.Text.prototype.update.call(this),this._value=this.rendNodeCheckbox.checked),this},e.addEvent(a.rendNodeCheckbox,"change",r,a),a},t.registerElement("checkbox",t.createCheckbox),{createCheckbox:t.createCheckbox}})),define("element/input",["jxg","utils/env","utils/type"],(function(t,e,i){"use strict";var r=function(t){this._value=this.rendNodeInput.value,this.board.update()};return t.createInput=function(s,o,n){var a,h,l=i.copyAttributes(n,s.options,"input");return h=[o[0],o[1],'<span style="display:inline; white-space:nowrap; padding:0px;"><span></span><input type="text" maxlength="'+l.maxlength+'" style="width:100%"/></span>'],(a=s.create("text",h,l)).type=i.OBJECT_TYPE_INPUT,a.rendNodeLabel=a.rendNode.childNodes[0].childNodes[0],a.rendNodeInput=a.rendNode.childNodes[0].childNodes[1],a.rendNodeLabel.innerHTML=o[3],a.rendNodeInput.value=o[2],a.rendNodeTag=a.rendNodeInput,a.rendNodeTag.disabled=!!l.disabled,a.rendNodeLabel.id=a.rendNode.id+"_label",a.rendNodeInput.id=a.rendNode.id+"_input",a._value=o[2],a.update=function(){return this.needsUpdate&&(t.Text.prototype.update.call(this),this._value=this.rendNodeInput.value),this},a.Value=function(){return this._value},a.set=function(t){return this._value=t,this.rendNodeInput.value=t,this},e.addEvent(a.rendNodeInput,"input",r,a),e.addEvent(a.rendNodeInput,"mousedown",(function(t){i.exists(t.stopPropagation)&&t.stopPropagation()}),a),e.addEvent(a.rendNodeInput,"touchstart",(function(t){i.exists(t.stopPropagation)&&t.stopPropagation()}),a),e.addEvent(a.rendNodeInput,"pointerdown",(function(t){i.exists(t.stopPropagation)&&t.stopPropagation()}),a),a.visPropOld.fontsize="0px",s.renderer.updateTextStyle(a,!1),a},t.registerElement("input",t.createInput),{createInput:t.createInput}})),define("element/button",["jxg","utils/env","utils/type"],(function(t,e,i){"use strict";var r=function(){this._handler&&this._handler(),this.board.update()};return t.createButton=function(s,o,n){var a,h,l=i.copyAttributes(n,s.options,"button");return h=[o[0],o[1],'<button type="button" style="width:100%;"></button>'],(a=s.create("text",h,l)).type=i.OBJECT_TYPE_BUTTON,a.rendNodeButton=a.rendNode.childNodes[0],a.rendNodeButton.id=a.rendNode.id+"_button",a.rendNodeButton.innerHTML=o[2],a.rendNodeTag=a.rendNodeButton,a.rendNodeTag.disabled=!!l.disabled,a.visPropOld.fontsize="0px",s.renderer.updateTextStyle(a,!1),o[3]&&(i.isString(o[3])?(a._jc=new t.JessieCode,a._jc.use(s),a._handler=function(){a._jc.parse(o[3])}):a._handler=o[3]),e.addEvent(a.rendNodeButton,"click",r,a),e.addEvent(a.rendNodeButton,"mousedown",(function(t){i.exists(t.stopPropagation)&&t.stopPropagation()}),a),e.addEvent(a.rendNodeButton,"touchstart",(function(t){i.exists(t.stopPropagation)&&t.stopPropagation()}),a),e.addEvent(a.rendNodeButton,"pointerdown",(function(t){i.exists(t.stopPropagation)&&t.stopPropagation()}),a),a},t.registerElement("button",t.createButton),{createButton:t.createButton}})),define("base/foreignobject",["jxg","base/constants","base/coords","base/element","math/math","utils/type","base/coordselement"],(function(t,e,i,r,s,o,n){"use strict";return t.ForeignObject=function(i,r,s,n,a){this.constructor(i,s,e.OBJECT_TYPE_FOREIGNOBJECT,e.OBJECT_CLASS_OTHER),this.element=this.board.select(s.anchor),this.coordsConstructor(r),this._useUserSize=!1,this.size=[1,1],o.exists(a)&&a.length>0&&(this._useUserSize=!0,this.W=o.createFunction(a[0],this.board,""),this.H=o.createFunction(a[1],this.board,""),this.usrSize=[this.W(),this.H()]),this.content=n,this.elType="foreignobject",this.id=this.board.setId(this,"Im"),this.board.renderer.drawForeignObject(this),this.board.finalizeAdding(this),this.methodMap=t.deepCopy(this.methodMap,{addTransformation:"addTransform",trans:"addTransform"})},t.ForeignObject.prototype=new r,o.copyPrototypeMethods(t.ForeignObject,n,"coordsConstructor"),t.extend(t.ForeignObject.prototype,{hasPoint:function(t,r){var n,a,h,l,c,d,u,p,f,m=this.transformations.length;return o.isObject(o.evaluate(this.visProp.precision))?(l=this.board._inputDevice,c=o.evaluate(this.visProp.precision[l])):c=this.board.options.precision.hasPoint,0===m?(n=t-this.coords.scrCoords[1],a=this.coords.scrCoords[2]-r,n>=-(h=c)&&n-this.size[0]<=h&&a>=-h&&a-this.size[1]<=h):(u=[(d=(d=new i(e.COORDS_BY_SCREEN,[t,r],this.board)).usrCoords)[0]-this.span[0][0],d[1]-this.span[0][1],d[2]-this.span[0][2]],0<=(p=(f=s.innerProduct)(u,this.span[1]))&&p<=f(this.span[1],this.span[1])&&0<=(p=f(u,this.span[2]))&&p<=f(this.span[2],this.span[2]))},update:function(t){return this.needsUpdate?(this.updateCoords(t),this.updateSize(),this):this},updateRenderer:function(){return this.updateRendererGeneric("updateForeignObject")},updateSize:function(){var t=[0,0];return this._useUserSize?(this.usrSize=[this.W(),this.H()],this.size=[Math.abs(this.usrSize[0]*this.board.unitX),Math.abs(this.usrSize[1]*this.board.unitY)]):this.rendNode.hasChildNodes()&&(t=this.rendNode.childNodes[0].getBoundingClientRect(),this.size=[t.width,t.height]),this},updateSpan:function(){var t,e,i=this.transformations.length,r=[];if(0===i)this.span=[[this.Z(),this.X(),this.Y()],[this.Z(),this.W(),0],[this.Z(),0,this.H()]];else{for(r[0]=[this.Z(),this.X(),this.Y()],r[1]=[this.Z(),this.X()+this.W(),this.Y()],r[2]=[this.Z(),this.X(),this.Y()+this.H()],t=0;t<i;t++)for(e=0;e<3;e++)r[e]=s.matVecMult(this.transformations[t].matrix,r[e]);for(e=0;e<3;e++)r[e][1]/=r[e][0],r[e][2]/=r[e][0],r[e][0]/=r[e][0];for(e=1;e<3;e++)r[e][0]-=r[0][0],r[e][1]-=r[0][1],r[e][2]-=r[0][2];this.span=r}return this},addTransform:function(t){var e;if(o.isArray(t))for(e=0;e<t.length;e++)this.transformations.push(t[e]);else this.transformations.push(t);return this},getParents:function(){var t=[this.url,[this.Z(),this.X(),this.Y()],this.usrSize];return 0!==this.parents.length&&(t=this.parents),t},setSize:function(t,e){return this.W=o.createFunction(t,this.board,""),this.H=o.createFunction(e,this.board,""),this._useUserSize=!0,this},W:function(){},H:function(){}}),t.createForeignObject=function(e,i,r){var s,a,h=i[0],l=i[1],c=[];if(i.length>=2&&(c=i[2]),s=o.copyAttributes(r,e.options,"foreignobject"),!(a=n.create(t.ForeignObject,e,l,s,h,c)))throw new Error("JSXGraph: Can't create foreignObject with parent types '"+typeof i[0]+"' and '"+typeof i[1]+"'.\nPossible parent types: [string, [x, y], [w, h]], [string, [x, y]], [element,transformation]");return a},t.registerElement("foreignobject",t.createForeignObject),t.registerElement("fo",t.createForeignObject),{ForeignObject:t.ForeignObject,createForeignobject:t.createForeignObject}})),define("../build/core.deps.js",["jxg","utils/env","base/constants","utils/type","utils/xml","utils/event","utils/expect","math/math","math/probfuncs","math/ia","math/extrapolate","math/qdt","math/numerics","math/nlp","math/plot","math/metapost","math/statistics","math/symbolic","math/geometry","math/clip","math/poly","math/complex","renderer/abstract","reader/file","parser/geonext","base/board","options","jsxgraph","base/element","base/coords","base/coordselement","base/point","base/line","base/group","base/circle","element/conic","base/polygon","base/curve","element/arc","element/sector","base/composition","element/composition","element/locus","base/text","base/image","element/slider","element/measure","base/chart","base/transformation","base/turtle","utils/color","base/ticks","utils/zip","utils/base64","utils/uuid","utils/encoding","server/server","parser/datasource","parser/jessiecode","parser/ca","utils/dump","renderer/svg","renderer/vml","renderer/canvas","renderer/no","element/comb","element/slopetriangle","element/checkbox","element/input","element/button","base/foreignobject"],(function(t,e){"use strict";return e.isBrowser?window.JXG=t:e.isNode()&&"object"==typeof module?module.exports=t:e.isWebWorker()&&(self.JXG=t),t})),require("../build/core.deps.js")}));