<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dash', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   block_dash
 * @copyright 2019 bdecent gmbh <https://bdecent.de>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['accordionfield1'] = 'Top left field';
$string['accordionfield1icon'] = 'Top left field icon';
$string['accordionfield2'] = 'Top right field';
$string['accordionfield2icon'] = 'Top right field icon';
$string['accordionfield3'] = 'Bottom left field';
$string['accordionfield3icon'] = 'Bottom left field icon';
$string['accordionfield4'] = 'Bottom right field';
$string['accordionfield4icon'] = 'Bottom right field icon';
$string['achieved'] = 'Achieved';
$string['activitybutton'] = "Activity button";
$string['activityprogress'] = 'Progress (completed / total activities)';
$string['activityprogressbar'] = 'Progress bar (completed / total activities)';
$string['addcontent'] = 'Add content';
$string['addjointable'] = 'Add {no} join table to form';
$string['addnewfield'] = 'Add new field';
$string['addtocontacts'] = 'Add to contacts';
$string['alpha_asc'] = 'Sort alphabetically A-Z';
$string['alpha_desc'] = 'Sort alphabetically Z-A';
$string['always'] = 'Always';
$string['anothertrailpath'] = "Another trial";
$string['arrows'] = 'Show arrows';
$string['arrows_help'] = 'Display arrow buttons for next/previous slide navigation.';
$string['asc'] = "ASC";
$string['attribute'] = 'Attribute';
$string['auto'] = "Auto";
$string['autoplay'] = 'Autoplay';
$string['autoplaySpeed'] = 'Autoplay speed (ms)';
$string['autoplaySpeed_help'] = 'Set the speed of the autoplay in milliseconds.';
$string['autoplay_help'] = 'Autoplay';
$string['availablefields'] = 'Available fields';
$string['availablefields_help'] = 'Choose all possible fields this data source will utilize. The user will be able to select which fields to include for their own purposes. For example, if you are displaying user information, try to include as many user fields as possible.';
$string['backgroundcolor'] = 'Background color';
$string['backgroundgradient'] = 'Background gradient';
$string['backgroundgradient_help'] = 'Generate a gradient: <a href="https://cssgradient.io/" target="_blank">cssgradient.io</a>. Paste the background property (linear-gradient)';
$string['backgroundimage'] = 'Background image';
$string['backgroundimage_help'] = 'Cover entire block background with this image';
$string['backgroundimagefield'] = 'Background image';
$string['backgroundimageurl'] = 'Background image URL';
$string['backgroundposition'] = 'Background Position';
$string['backgroundposition_help'] = 'Background image will focused on the given position';
$string['backgroundsize'] = 'Background Size';
$string['backgroundsize_help'] = 'Background image will displayed in the size';
$string['badgecolorfield'] = 'Badge color field';
$string['badgecolorfield_help'] = 'Choose a field that returns colors to be used for timeline item badges.';
$string['badges'] = 'Badges';
$string['badgestitle'] = 'Badges';
$string['between'] = 'Between';
$string['blockcontext'] = "Block";
$string['blocksnotfound'] = "The current dashboard does not contain any blocks.";
$string['blocktitle'] = 'Block title';
$string['blocktitle_help'] = 'Title displayed in block heading. Enter a short and descriptive title for what this block displays to the user.';
$string['blockwidth'] = 'Block width';
$string['bodyfield'] = 'Body field';
$string['bootstrapversion'] = 'Theme bootstrap version';
$string['bootstrapversion_desc'] = 'Choose the version of Bootstrap your theme supports. Moodle is typically 4, and Totara is 3.';
$string['border'] = 'Border';
$string['border_help'] = 'CSS border property value.';
$string['border_option'] = "Show border";
$string['border_option_help'] = "You can add the border of dash block.";
$string['bordervalue'] = "Border Value";
$string['buildown'] = 'Build your own';
$string['buildown_help'] = 'Datasources are highly configurable, You can use the datasources in various purpose. Filter, Sorting, Pagination features are supported';
$string['buynow'] = 'Buy now';
$string['calendareventsfallback'] = 'Calendar events fallback image';
$string['calendareventsfallback_desc'] = 'Upload a image to display as fallback for site and other type of events';
$string['campaign'] = 'Campaign';
$string['categories'] = 'Categories';
$string['categories_help'] = 'Categories datasource list the available categories.';
$string['category'] = 'Category name';
$string['categorycoursecount'] = 'Courses count';
$string['categoryimage'] = 'Category image';
$string['categoryimagelink'] = 'Category link';
$string['categoryimageurl'] = 'Category image url';
$string['categoryimgcategory'] = 'Image for category {$a->category}';
$string['categoryimgdesc'] = 'Add images for the categories';
$string['categoryimgfallback'] = 'Category fallback image';
$string['categoryimgfallbackdesc'] = 'Upload the image for the default fallback of categories. If new categories are created, the fallback image will be displayed until a new image is added for the category.';
$string['categoryimgheading'] = 'Category image';
$string['categoryimgheadingsub'] = 'Categories images';
$string['categoryurl'] = 'Category URL';
$string['centerMode'] = 'Center mode';
$string['centerMode_help'] = 'Enables centered view with partial prev/next slides. Use with odd numbered slidesToShow counts.';
$string['centerPadding'] = 'Center padding (px)';
$string['centerPadding_help'] = 'Side padding when in center mode (px).';
$string['centerbottom'] = "Center Bottom";
$string['centercenter'] = "Center Center";
$string['centertop'] = "Center Top";
$string['certificatecodelinked'] = 'Code linked';
$string['choosedatasource'] = 'Choose data source';
$string['choosefeature'] = 'Choose Feature';
$string['choosefilter'] = "Choose filter";
$string['chooseskill'] = 'Choose skill';
$string['circlepath'] = "Circle";
$string['cohorts'] = "Cohorts";
$string['columns'] = 'Columns';
$string['columns_help'] = 'The number of columns to display per row in the grid.';
$string['compentenciesnotfound'] = 'Competency not found.';
$string['competencyappearance'] = 'Competency appearances';
$string['competencycolor'] = 'Competency color';
$string['competencyframework'] = 'Competency framework';
$string['competencyheading'] = 'Setup competency appearance';
$string['competencyimage'] = 'Competency image';
$string['completedactivities'] = 'Completed activities';
$string['completedcourse'] = "Completed course";
$string['completedlearningpath'] = "Learning path complete. Good job!";
$string['completion:completed'] = 'Completed';
$string['completion:inprogress'] = 'In progress';
$string['completion:notstarted'] = 'Not yet started';
$string['conditionaddfields'] = 'Add {no} condition(s)';
$string['conditionsection'] = 'Condition setup';
$string['conditionstatichdr'] = 'Condition #0';
$string['conditionvalue'] = 'Value';
$string['conditionvalue_help'] = 'Condition Value - Enter the specific value against which the condition will be checked. This value is crucial in determining when the condition is met or satisfied. Enter the values with comma(,) for IN conditions';
$string['confirmleavegroup'] = 'Do you really want to leave the group {$a}';
$string['contacts'] = 'Contacts';
$string['contain'] = "Contain";
$string['contentdisplay'] = 'Display';
$string['contentdisplayallpage'] = 'All pages';
$string['contentdisplaysection'] = 'Section pages';
$string['contenteditor'] = 'Content';
$string['contentlayout'] = 'Content layout';
$string['contentmodaltitle'] = 'Update the dash content';
$string['contentsectiondisplay'] = 'Display sections';
$string['contentsections'] = 'Sections to display';
$string['contextcategory'] = 'Category';
$string['contextcourse'] = 'Course';
$string['contextid'] = 'Context';
$string['contextid_help'] = 'The context for this dashboard. Choose a specific course if you plan on limiting data results (Example: "Current course" filter). Otherwise choose System for general purposes.';
$string['contextlevel'] = "Context level";
$string['contextlinked'] = 'Context linked';
$string['contextmissing'] = 'Missing context';
$string['contextname'] = "Context name";
$string['contextsettings'] = 'Context settings';
$string['contextsystem'] = 'System';
$string['contexttype'] = 'Context type';
$string['contexturl'] = "Context URL";
$string['copy'] = "Copy";
$string['coredashboard'] = "Main dashboard";
$string['course_enrol_role'] = 'Role for enrol using enrolment widget';
$string['course_enrolments:abovecourseform'] = 'Above the courses';
$string['course_enrolments:belowcourseform'] = 'Below the courses';
$string['course_enrolments:disabled'] = 'Disabled';
$string['course_enrolments:displayaddcourse'] = 'Display add course form';
$string['course_enrolments:expandable'] = 'Expandable';
$string['course_enrolments:progress'] = 'Display progress';
$string['course_enrols:viewotherprofiledash'] = 'View the others profile dash block';
$string['course_enrols:viewprofiledash'] = 'View the profile dash block';
$string['coursebutton'] = 'Course button';
$string['coursecatcontext'] = "Course Category";
$string['coursecategories'] = 'Course categories';
$string['coursecontent'] = 'Course content';
$string['coursecontext'] = "Course";
$string['coursedata:past'] = 'Past';
$string['coursedate:future'] = 'Future';
$string['coursedate:present'] = 'Present';
$string['coursedates'] = 'Course dates';
$string['coursefullname'] = "Course full name";
$string['courseidnumber'] = "Course idnumber";
$string['courseimage'] = 'Course default image';
$string['courseimagedesc'] = 'Upload placeholder image to display as course image for empty course image.';
$string['courseimagelink'] = 'Course image link';
$string['courseinformation'] = 'Course information';
$string['courseoverviewfilesurl'] = 'Course image URL';
$string['courseredirecturl'] = 'Course redirect URL';
$string['courseredirecturldesc'] = 'Enter the URL to redirect the users from course index page.';
$string['courseshopurl'] = 'Course shop url';
$string['courseshortname'] = "Course short name";
$string['coursestafftitle'] = 'Course staff';
$string['coursestartdate'] = "Course start date";
$string['coursestartdate_asc'] = 'By course start date (newest first)';
$string['coursestartdate_desc'] = 'By course start date (oldest first)';
$string['coursesummary'] = 'Course summary';
$string['courseurl'] = 'Course URL';
$string['cover'] = "Cover";
$string['createcustomdatasource'] = 'Create custom data source';
$string['createcustomlayout'] = 'Create custom layout';
$string['createdashboard'] = 'Create dashboard';
$string['createddate'] = 'Created date';
$string['createlayout'] = 'Create custom layout';
$string['cssclass'] = 'CSS Class';
$string['cssclass_help'] = "Use a custom CSS class to apply multiple classes.";
$string['ctalink'] = 'Call to action link';
$string['currentcategory'] = 'Current Category';
$string['currentcourse'] = 'Current course';
$string['currentcoursecontext'] = 'Current course context';
$string['currentcoursegroups'] = 'Current course groups';
$string['currentcourseskills'] = 'Current course skills';
$string['currentlevel'] = 'Current level';
$string['custom'] = 'Custom';
$string['customcondition'] = 'Custom condition query';
$string['customdatasource'] = 'Custom data source';
$string['customdatasourcecreated'] = 'Data source <b>{$a->name}</b> successfully created.';
$string['customdatasourcedeleted'] = 'Delete custom data source';
$string['customdatasourceedited'] = 'Data source <b>{$a->name}</b> successfully edited.';
$string['customdatasources'] = 'Custom data sources';
$string['customfeaturetype'] = 'Custom feature type';
$string['customfield'] = '{$a->name}';
$string['customfields'] = 'Custom fields';
$string['customlayoutcreated'] = 'Custom layout <b>{$a->name}</b> successfully created.';
$string['customlayoutdeleted'] = 'Custom layout <b>{$a->name}</b> successfully deleted.';
$string['customlayoutedited'] = 'Custom layout <b>{$a->name}</b> successfully edited.';
$string['customsqlfield'] = 'SQL field';
$string['customsqlselect'] = 'SQL select';
$string['customurl'] = 'Custom URL';
$string['customurltext'] = "Custom URL Text";
$string['dash:addinstance'] = 'Add a new Dash block';
$string['dash:managecoursecatedashboards'] = 'Manage course categorydata sources';
$string['dash:managedatasource'] = 'Manage Datasources';
$string['dash:managewidget'] = 'Manage Widgets';
$string['dash:myaddinstance'] = 'Add a new Dash block to dashboard';
$string['dash:mygroups_addusers'] = 'Add users into groups';
$string['dash:mygroups_creategroup'] = 'Create groups in enrolled courses';
$string['dash:mygroups_leavegroup'] = 'Leave from groups';
$string['dash:mygroups_view'] = 'View my own groups';
$string['dash:mygroups_viewmembers'] = 'View members in assigned groups';
$string['dash:viewrestrictedblocks'] = 'View the restricted dash blocks';
$string['dashaddoncontentdesc'] = 'Choose from the following layouts';
$string['dashaddonpluginname'] = 'Dash addon name';
$string['dashbgimg'] = 'Background image';
$string['dashbgimg_help'] = 'This background image used as background for the dashboard.';
$string['dashboard'] = 'Dashboard';
$string['dashboardcreated'] = 'Dashboard <b>{$a->name}</b> successfully created';
$string['dashboarddeleted'] = 'Dashboard <b>{$a->name}</b> successfully deleted';
$string['dashboardduplicated'] = "Duplicated dashboard successfully";
$string['dashboardedited'] = 'Dashboard <b>{$a->name}</b> successfully edited';
$string['dashboardlink'] = 'Dashboard link';
$string['dashboards'] = 'Dashboards';
$string['dashicon'] = 'Icon';
$string['dashicon_help'] = 'This icon shows only in the dashboards data source.';
$string['dashthumbnailimg'] = 'Thumbnail image';
$string['dashthumbnailimg_help'] = "This thumbnail image shows only in dashboards data source";
$string['dashthumbnailimgurl'] = 'Thumbnail image URL';
$string['databaseerror'] = 'Database error. The content cannot be displayed.';
$string['datasource'] = 'Data source';
$string['datasource:competency_progress_widget'] = 'Skill competency widget';
$string['datasource:competency_widget'] = 'Skill graph widget';
$string['datasource:completion_widget'] = 'Course completions widget';
$string['datasource:completions_data_source'] = 'Course completions';
$string['datasource:completions_data_source_help'] = 'Users compelted courses list.';
$string['datasource:courses_data_source'] = 'Courses';
$string['datasource:courses_data_source_help'] = 'List of available courses for the current user.';
$string['datasource:dashboard_data_source'] = 'Dashboards';
$string['datasource:dashboard_data_source_help'] = 'List of Dashboard';
$string['datasource:enrolments_widget'] = 'Enrolments Widget';
$string['datasource:logstore_data_source'] = 'Site logs';
$string['datasource:logstore_data_source_help'] = 'Datasource of site logs';
$string['datasource:roleassignments_data_source'] = "Role assignments";
$string['datasource:sections_widget'] = 'Course sections widget';
$string['datasourcedesc'] = 'Add dynamic content with data sources and layouts';
$string['datasourcemissing'] = 'Data source missing';
$string['datasourcename'] = 'Data source name';
$string['datasources'] = 'Datasources';
$string['datecompleted'] = 'Date completed';
$string['daysuntilend'] = 'Days until end date';
$string['daysuntilstart'] = 'Days until start date';
$string['defaultexportdata'] = "Dash export data";
$string['defaultexportdata_help'] = "This setting allows the configuration to enable/disable the dash datasource export data.";
$string['defaultsortdirection'] = 'Sort direction';
$string['defaultsortfield'] = 'Sort by';
$string['defaultsortfield_help'] = 'Sort database results by this field. If layout supports user sorting, this will be the default.';
$string['delete'] = 'Delete';
$string['deletecondition'] = 'Delete this condition';
$string['deleteconfirm'] = 'Are you sure you want to delete dashboard <b>{$a->name}</b>?';
$string['deleteconfirmcustomdatasource'] = 'Are you sure you want to delete the <b>{$a->name}</b> custom data source?';
$string['deleteconfirmcustomlayout'] = 'Are you sure you want to delete the <b>{$a->name}</b> custom layout?';
$string['deletecustomdatasource'] = 'Delete custom data source';
$string['deletecustomlayout'] = 'Delete custom layout';
$string['deletedashboard'] = 'Delete dashboard';
$string['deletefield'] = 'Delete this field';
$string['deletejoin'] = 'Delete this join table';
$string['desc'] = "DESC";
$string['description'] = 'Description';
$string['designercustombgposition'] = "Custom Background Position";
$string['designercustombgsize'] = "Custom Background Size";
$string['desktop_learningpath'] = "Learning Path for Desktop";
$string['desktop_learningpath_desc'] = "";
$string['details_area'] = 'Details area';
$string['details_area_help'] = 'Choose how you want to display the details area.';
$string['details_area_locations'] = 'Details area locations';
$string['details_area_locations_help'] = 'Enter the details for each location you want to display in the details area.';
$string['details_area_size'] = 'Details area size';
$string['details_area_size_help'] = 'Choose how you want to size the details area.';
$string['details_bg_color'] = 'Details Background color';
$string['details_body_1'] = "Details Body 1";
$string['details_body_2'] = "Details Body 2";
$string['details_body_3'] = "Details Body 3";
$string['details_footer_left'] = "Details Footer left";
$string['details_footer_right'] = "Details Footer right";
$string['details_text_color'] = 'Details Text color';
$string['details_title'] = "Details Title";
$string['developerfield'] = '{$a}';
$string['developerfieldid'] = 'id';
$string['disableall'] = 'Disable all Dash output';
$string['disableall_help'] = 'Warning: For troubleshooting purposes or troubleshooting broken pages';
$string['disableallmessage'] = 'Dash output is disabled. Check Dash settings.';
$string['disabled'] = 'Disabled';
$string['displaycta'] = 'Display call to action';
$string['displaydashboardtitle'] = 'Display dashboard title';
$string['donut'] = 'Donut';
$string['dot'] = "Dot";
$string['dots'] = 'Show dots';
$string['dots_help'] = 'Display dot indicators for slide navigation.';
$string['downloadcertificate'] = 'Download certificate';
$string['downloadcsv'] = 'Download in CSV format';
$string['draggable'] = 'Draggable';
$string['draggable_help'] = 'Enables dragging and flicking of slides.';
$string['dragitem'] = 'Drag item';
$string['duedate'] = 'Due date';
$string['duplicatedashboard'] = "Duplicate dashboard";
$string['edit'] = 'Edit';
$string['editcontent'] = 'Edit content';
$string['editcustomdatasource'] = 'Edit data source';
$string['editcustomlayout'] = 'Edit custom layout';
$string['editdashboard'] = 'Edit dashboard';
$string['editpreferences'] = 'Edit preferences';
$string['editthisblock'] = 'Edit this block\'s settings to finish configuration.';
$string['edituserenrolment'] = 'Edit {$a}\'s enrolment';
$string['emptystateheading'] = 'Empty state';
$string['enableconditions'] = 'Enable conditions';
$string['enabledconditions'] = 'Limit data to';
$string['enabledfields'] = 'Enabled fields';
$string['enabledfilters'] = 'Enabled filters';
$string['enabledownload'] = "Export data";
$string['enabledownload_help'] = "This setting enables users to download the data in both CSV and XLS formats.";
$string['enablejoins'] = 'Enable joins';
$string['enroldate_asc'] = 'Sort by enrolment date (oldest first)';
$string['enroldate_desc'] = 'Sort by enrolment date (newest first)';
$string['enroldetails'] = "Enrolment details";
$string['enroled'] = 'Enrolled';
$string['enrollment'] = 'Enrollment';
$string['enrollment_options'] = 'Enrollment options';
$string['enrollmentmethod'] = 'Enrollment method';
$string['enrollmentmethodstatus'] = 'Enrollment method status';
$string['enrollmentoptions'] = 'Enrolment methods';
$string['enrollmentoptions:cost'] = 'From {$a->currency} {$a->cost}';
$string['enrollmentoptions:credits'] = '{$a} credits';
$string['enrollmentoptions:free'] = 'Free';
$string['enrollmentoptions:fromcredits'] = 'From {$a} credits';
$string['enrollmentoptions:seeoptions'] = 'See options';
$string['enrollments'] = 'Enrollments';
$string['enrollmentself'] = 'Self enrollments';
$string['enrollmentsnotself'] = 'Non-self enrollments';
$string['enrollmentstatus'] = 'Enrollment status';
$string['enrollmenttimeend'] = 'Enrollment end date';
$string['enrollmenttimestart'] = 'Enrollment start date';
$string['enrolmentmethod'] = "Enrolment method";
$string['enrolmentoptions'] = 'Enrolment options';
$string['enrolnow'] = 'Enrol Now';
$string['enterclasses'] = "Enter classes";
$string['even:icon'] = 'Event icon';
$string['event'] = 'Event';
$string['event:color'] = 'Event color';
$string['event:contextevent'] = 'Context of event';
$string['event:contextlinked'] = 'Context of event (linked) ';
$string['event:description'] = 'Description';
$string['event:duration'] = 'Event duration';
$string['event:durationinminutes'] = 'Event duration in minutes ';
$string['event:enddate'] = 'End date';
$string['event:endtime'] = 'End time';
$string['event:filterdate'] = 'Date';
$string['event:filterday'] = 'Day of week';
$string['event:gotoactivity'] = 'Go to activity';
$string['event:image'] = 'Event image';
$string['event:imagelinked'] = 'Event image (linked)';
$string['event:imageurl'] = 'Event Image URL';
$string['event:location'] = 'Location';
$string['event:repeated'] = 'Repeated event';
$string['event:startdate'] = 'Start date';
$string['event:starttime'] = 'Start time';
$string['event:status'] = 'Status';
$string['event:title'] = 'Event title';
$string['event:type'] = 'Event type';
$string['event:typecategory'] = 'Course category';
$string['event:typecourse'] = 'Course';
$string['event:typefilter'] = 'Event type filter';
$string['event:typegroup'] = 'Group';
$string['event:typeother'] = 'Other';
$string['event:typesite'] = 'Site';
$string['event:typeuser'] = 'User';
$string['event_desc_core_event_user_enrolment_created'] = '{$a->relateduserfullname} was enrolled in <a href="\'{$a->eventurl}\'" title="\'View {$a->contextname}\'">{$a->contextname}</a>';
$string['event_desc_generic'] = '{$a->userfullname} {$a->action} <a href="\'{$a->eventurl}\'" title="View \'{$a->contextname}\'">{$a->contextname}</a>';
$string['eventactivity:both'] = 'Incomplete and complete activities';
$string['eventactivity:incomplete'] = 'Incomplete activities only';
$string['eventactivitycompletion'] = 'Associated to an activity';
$string['eventbutton'] = 'Event button';
$string['eventclass'] = 'Event class';
$string['eventcolor'] = 'Event color';
$string['eventcontext'] = 'Context of event';
$string['eventdescription'] = 'Event description';
$string['eventicon'] = 'Event icon';
$string['eventlink'] = 'Event link';
$string['events'] = 'Events';
$string['eventstatus'] = 'Event status';
$string['eventtime'] = 'Event time';
$string['eventurl'] = 'Event URL';
$string['extracontent'] = 'Extra content';
$string['extralargeimage'] = "Extra large image";
$string['fade'] = 'Fade';
$string['fade_help'] = 'Enables fade effect on slides transition.';
$string['failed'] = 'Failed';
$string['field'] = 'Field';
$string['field:completedactivitiesinweek'] = 'Completed activities this week';
$string['field:completedcourses'] = 'Completed courses';
$string['field:completedcoursesinweek'] = 'Completed courses this week';
$string['field:courseimgsize'] = "Course image size";
$string['field:courseimgsize_help'] = 'Dot — 20x20 px dot, without the course image. <br>Tiny image — 35x35px.<br>Small image — 50x50px.<br>Medium image — 75x75px.<br>Large image — 100x100px.<br>Extra large image — 150x150px.';
$string['field:coursesinprogress'] = 'Courses in progress';
$string['field:currentcoursescount'] = 'Current courses';
$string['field:detailsarea'] = "Details area";
$string['field:detailsarea_help'] = "if true, displays a details area as modal upon clicking the course";
$string['field:earnedandtotalpoints'] = 'Earned/total skill points';
$string['field:earnedskillpoints'] = 'Earned skill points';
$string['field:enrolledprogress'] = 'Completed/total courses';
$string['field:finishelement'] = "Finish element";
$string['field:finishelement_help'] = "if true, adds the finish element at the End of the path";
$string['field:fullname'] = 'Show user\'s full name';
$string['field:futurecoursescount'] = 'Future courses';
$string['field:infoarea'] = "Info area";
$string['field:infoarea_help'] = "if true, show the info area";
$string['field:kpi'] = 'KPI {$a}';
$string['field:learningpathdesktop'] = "Path for Desktop";
$string['field:learningpathmobile'] = "Path for Mobile";
$string['field:learningpathtablet'] = "Path for Tablet";
$string['field:limit'] = "Limit";
$string['field:limit_help'] = "Limit";
$string['field:loginsthisweek'] = 'Logins this week';
$string['field:loginstreak'] = 'Login streak';
$string['field:numberofcontactreq'] = 'Number of contact requests';
$string['field:numberofdueactivities'] = 'Number of due activities';
$string['field:numberofoverdueactivities'] = 'Number of overdue activities';
$string['field:numberofunreadmsg'] = 'Number of unread messages';
$string['field:onlineuserscount'] = 'Number of users currently online';
$string['field:orderby'] = "Order by";
$string['field:orderby_help'] = "Order by";
$string['field:orderdirection'] = "Order direction";
$string['field:orderdirection_help'] = "Order direction";
$string['field:pastcoursescount'] = 'Past courses';
$string['field:profileimage'] = 'Show user profile image';
$string['field:profileuserinfo'] = 'Profile user info {$a}';
$string['field:sincelogindays'] = 'Number of days since last login';
$string['field:startelement'] = "Start element";
$string['field:startelement_help'] = " if true, adds the start element at the beginning of the path";
$string['field:teammemberscount'] = 'Number of team members';
$string['fieldalert'] = 'The chosen layout can not be customised';
$string['fieldalllevels'] = 'Display all levels';
$string['fieldattributeshdr'] = 'Transform field data format';
$string['fieldcurrentlevel'] = 'Display current level';
$string['fieldcustomdata'] = 'Additional format value';
$string['fieldcustomdata_help'] = 'Enter the additional data related to the selected attribute <b>For example: </b> 1. For the link attribute, enter the link and use the field values as parameters <br> 2. For the percent attribute, Use the outof value. For the grades use 10 otherwise it uses 100';
$string['fieldname'] = 'Field name';
$string['fieldnotfound'] = 'Field not found.';
$string['fields'] = 'Fields';
$string['fieldselect'] = 'Field SQL select';
$string['fieldssection'] = 'Fields setup';
$string['fieldstatichdr'] = 'Field #0';
$string['fieldtransformdata'] = 'Transform the format';
$string['fieldtransformdata_help'] = 'Transform the format of the value when displayed in the table';
$string['filter:friday'] = 'Friday';
$string['filter:monday'] = 'Monday';
$string['filter:saturday'] = 'Saturday';
$string['filter:sunday'] = 'Sunday';
$string['filter:thismonth'] = 'This month';
$string['filter:thisweek'] = 'This week';
$string['filter:thursday'] = 'Thursday';
$string['filter:today'] = 'Today';
$string['filter:tuesday'] = 'Tuesday';
$string['filter:upcoming'] = 'Upcoming';
$string['filter:wednesday'] = 'Wednesday';
$string['fit_content'] = 'Fit content';
$string['fit_content_help'] = 'Make the height of the details area the same as the card, and let the width be determined by the content.';
$string['fontcolor'] = 'Font color';
$string['fontcolor_help'] = 'CSS font color property (e.g. #ffffff, rgb(255, 255, 255), etc)';
$string['footercontent'] = 'Footer content';
$string['footercontent_help'] = 'Content displayed in the block footer.';
$string['footerfield'] = 'Footer field';
$string['footerrightfield'] = 'Footer field (right)';
$string['fullnamelinked'] = 'Fullname linked';
$string['generalsettings'] = 'General settings';
$string['generateattributes'] = 'Generate field attributes';
$string['generatefields'] = 'Generate fields';
$string['gotoevent'] = 'Go to event';
$string['gridsizeoptions'] = "Wide\nTall\nSquare";
$string['groupby'] = 'Group by';
$string['grouplabel'] = 'Group label';
$string['headercontent'] = 'Header content';
$string['headercontent_help'] = 'Content displayed in the block header.';
$string['headerfooter'] = 'Header & Footer';
$string['headingfield'] = 'Heading field';
$string['hidden'] = "Hidden";
$string['hidecompletedskills'] = 'Hide completed skills';
$string['hidecoursecategory'] = 'Do not show category/course index';
$string['hidecoursecategorydesc'] = "When a user tries to access the URL /course/index.php, they will be automatically redirected to the site's home page, unless a custom URL is specified below. If a URL is specified, users shall be redirected to that URL";
$string['hideindividualskills'] = 'Hide individual skills';
$string['hidemycourses'] = 'Hide my enrolled courses';
$string['hideshow'] = 'Hide/Show';
$string['hidetable'] = "Hide the table content.";
$string['hidetable_help'] = ' Enabling this option allows users to hide the table content in dash instance. Only the header and footer blocks will remain visible.';
$string['hidewhenempty'] = 'Hide when empty';
$string['hidewhenempty_desc'] = "Hide the dash block when it's empty.";
$string['higherthan'] = 'Higher than';
$string['iconfield'] = 'Icon field';
$string['imageoverlayfield'] = 'Image overlay field';
$string['imageoverlayfield_help'] = 'Content to display over image with solid background.';
$string['imageurlfield'] = 'Image URL field';
$string['imageurlfield_help'] = 'Choose an image URL field that will be used in each card in the grid.';
$string['includedblocks'] = 'Included blocks';
$string['includesubcategories'] = 'Include subcategories';
$string['includesubcategories_help'] = 'If checked, subcategories of chosen categories will also be included in results.';
$string['incomplete'] = 'Incomplete';
$string['infinite'] = 'Infinite loop';
$string['infinite_help'] = 'Enables infinite loop sliding.';
$string['initial'] = "Initial";
$string['invalididnumberunique'] = 'ID Number already exists.';
$string['invalidoperator'] = 'Invalid operator {$a->operator}.';
$string['invalidshortname'] = 'Invalid shortname. It must only contain letters a-zA-Z or hyphens (-).';
$string['invalidshortnametoolong'] = 'Invalid Shortname. Must be 16 characters or less.';
$string['invalidshortnameunique'] = 'This shortname is already used by another dashboard.';
$string['invalidwhereclause'] = 'Invalid where clause. No values provided.';
$string['label'] = 'Label';
$string['label:completedactivitiesinweek'] = 'Activities completed this week';
$string['label:completedcourses'] = 'Completed courses';
$string['label:completedcoursesinweek'] = 'Courses completed this week';
$string['label:coursesinprogress'] = 'Courses in progress';
$string['label:currentcoursescount'] = 'Current courses';
$string['label:earnedandtotalpoints'] = 'Earned/total points';
$string['label:earnedskillpoints'] = 'Points collected';
$string['label:enrolledprogress'] = 'Completed courses';
$string['label:futurecoursescount'] = 'Future courses';
$string['label:loginsthisweek'] = 'Logins this week';
$string['label:loginstreak'] = 'Day streak';
$string['label:numberofcontactreq'] = 'Contact requests';
$string['label:numberofdueactivities'] = 'Due activities';
$string['label:numberofoverdueactivities'] = 'Overdue activities';
$string['label:numberofunreadmsg'] = 'Unread messages';
$string['label:onlineuserscount'] = 'Users currently online';
$string['label:pastcoursescount'] = 'Past courses';
$string['label:sincelogindays'] = 'Days since last login';
$string['label:teammemberscount'] = 'Team members';
$string['largeimage'] = "Large image";
$string['layout'] = 'Layout';
$string['layoutaccordion'] = 'Accordion layout (with tables)';
$string['layoutaccordion2'] = 'Accordion layout';
$string['layoutcards'] = 'Grid layout';
$string['layoutdoesnotsupportfiltering'] = 'The chosen layout does not support filtering';
$string['layoutdoubleequal'] = 'Double equal';
$string['layoutdoubleleft'] = 'Double (1/3, 2/3) ';
$string['layoutdoubleright'] = 'Double (2/3, 1/3)';
$string['layoutfull'] = 'Full layout';
$string['layoutgrid'] = 'Table layout';
$string['layoutmode'] = "Layout mode";
$string['layoutmode_help'] = "Select which mode appers on the widget";
$string['layoutonestat'] = 'One figure + label layout';
$string['layouttimeline'] = 'Timeline layout';
$string['layouttriple'] = 'Triple equal';
$string['layouttwostat'] = 'One figure / other figure layout';
$string['layouttype'] = 'Layout type';
$string['leanringpath_infocontent'] = 'You have completed <b>{$a->completed}</b> out of <b> {$a->total} </b> courses. The next course in this learning path is: <b> {$a->nextcourse}</b>';
$string['learningpath:infoarea'] = 'Info area content';
$string['learningpath:path'] = 'Path';
$string['learningpathfinish'] = 'Finish';
$string['learningpathstart'] = 'Start';
$string['leftbottom'] = "Left Bottom";
$string['leftcenter'] = "Left Center";
$string['lefttop'] = "Left Top";
$string['like_item'] = 'Like item';
$string['like_item_help'] = 'Make the details area the same size as the card.';
$string['loggedinuser'] = 'Logged in user';
$string['loginstreakdays'] = 'Login streak days';
$string['loginstreakdaysdesc'] = 'Set the number of consecutive days required to maintain a streak.';
$string['lowerthan'] = 'Lower than';
$string['magicnotavailable'] = "The Magic authentication is not available for this site.";
$string['maindashboard'] = "Main dashboard";
$string['maintable'] = 'Select main table <b>(mnt)</b> ';
$string['maintable_help'] = 'Choose the main table for field generation';
$string['maintablenotconfigured'] = 'Main table not configured for the developer data source';
$string['managecapabilitymissing'] = 'Require capability "moodle/competency:competencymanage" to access the page is missing';
$string['managecompentency'] = 'Manage competencies appearance';
$string['managecustomdatasources'] = 'Manage custom data sources';
$string['managedashaddonplugins'] = "Manage addons";
$string['managedashboards'] = 'Manage dashboards';
$string['managedatasources'] = 'Manage data sources';
$string['managelayouts'] = 'Manage layouts';
$string['masonrycustomfield'] = "Dash settings";
$string['max'] = 'Max';
$string['maxlimit'] = 'Limit to';
$string['maxlimit_help'] = 'Limit query results to this maximum amount.';
$string['mediumimage'] = "Medium image";
$string['menu'] = "Menu order";
$string['messageurl'] = 'Message URL';
$string['minheight'] = 'Minimum height';
$string['minheight_help'] = 'Minimum height in pixels for block.';
$string['missingdatasource'] = "The datasources are missing. Please check them.";
$string['missingmustachetemplate'] = 'Missing mustache template.';
$string['mobile_learningpath'] = "Learning Path for Mobile";
$string['mobile_learningpath_desc'] = "";
$string['modifieddate'] = 'Last modified date';
$string['modulecontext'] = "Module";
$string['modulename'] = 'Module Name';
$string['mustachetemplate'] = 'Mustache template';
$string['mydashboards'] = 'My dashboards';
$string['myenrolledcourses'] = 'My enrolled courses';
$string['myparticipants'] = 'My participants / students';
$string['myprofiletable'] = 'Profile';
$string['myskills'] = 'My skills';
$string['newblock'] = 'New Dash';
$string['nextlevelpoints'] = 'Next level points';
$string['nextlevelstr'] = '{$a->points} points to become {$a->name}';
$string['nocampaignsareavailable'] = "No campaigns are available";
$string['nocategoryselected'] = 'No category selected';
$string['nocontactsavailable'] = 'No contacts available';
$string['nocourselearnigpath'] = "No courses have been added to the learning path yet.";
$string['nocourses'] = "No courses available";
$string['nocourseselected'] = 'No course selected';
$string['nodashboardsforuser'] = 'No dashboards are available at this time.';
$string['nogroupsavailable'] = 'No groups available';
$string['none'] = 'None';
$string['nonpublicdashboards'] = 'Hide public dashboards';
$string['notachieved'] = 'Not achieved';
$string['notauthorized'] = 'You do not have access to this dashboard.';
$string['notavailable'] = 'Not available';
$string['oneormoreblocks'] = "The dashboard requires more than one block.";
$string['onlywhensticky'] = 'Only when sticky';
$string['onpagenavigation'] = 'On page navigation';
$string['openmodule'] = 'Open module';
$string['operator'] = 'Operator';
$string['operatorcondition'] = 'Condition';
$string['operatorcondition_help'] = 'Conjunctive Operator - Choose between "AND" and "OR" to define how multiple conditions are combined. - "AND" requires that all conditions must be true for the overall condition to be met. - "OR" requires that at least one of the conditions must be true for the overall condition to be met.';
$string['operatorequal'] = '=';
$string['operatorgreaterthan'] = '>';
$string['operatorgreaterthanequal'] = '>=';
$string['operatorin'] = 'IN (...)';
$string['operatorinquery'] = 'IN (Query)';
$string['operatorlessthan'] = '<';
$string['operatorlessthanequal'] = '<=';
$string['operatorlike'] = 'LIKE';
$string['operatorlikebetween'] = 'LIKE %..%';
$string['operatornotequal'] = '!=';
$string['operatornotin'] = 'NOT IN (...)';
$string['operatornotlike'] = 'NOT LIKE';
$string['originalrolename'] = "Original name";
$string['otheraddons'] = 'Other addons';
$string['pagination_summary'] = 'Showing {$a->limit_from} - {$a->limit_to} of {$a->total}';
$string['parent'] = "Parent";
$string['parseerror'] = 'Parse error. The content cannot be displayed.';
$string['participationnotcurrent'] = "Not current";
$string['passed'] = 'Passed';
$string['permissions'] = 'Restrict access to';
$string['permissionscohort'] = 'Cohort';
$string['permissionsloggedin'] = 'Must be logged in';
$string['permissionspublic'] = 'Public';
$string['permissionsrole'] = 'Role';
$string['permissionsrolecontext'] = 'Role Context';
$string['permissionsrolecontext_help'] = 'Select the context for which the user\'s role should be checked (Any context or system context only)';
$string['perpage'] = 'Per page';
$string['perpage_help'] = 'Number of cards to display in grid per page.';
$string['persistenttablealias'] = 'Custom source main table';
$string['pictureofuserlinked'] = 'User picture (linked to profile)';
$string['pictureofuserurl'] = 'User picture URL';
$string['placeholderfields'] = 'Placeholder fields';
$string['placeholderfields_help'] = 'Select the fields and use those fields in the field additional custom values with {field_name}, this will be replaced with its corresponding values.';
$string['pluginname'] = 'Dash';
$string['privacy:metadata'] = 'The Dash block only shows information about courses and does not store data itself.';
$string['proficient'] = 'Proficient';
$string['programbg'] = "Enrol Program image";
$string['programbg_desc'] = "";
$string['programimagelink'] = 'Program image linked';
$string['programs:view'] = 'View programs';
$string['progress_help'] = 'Display the completion progress of the course';
$string['promotionoptions'] = "Featured\nNormal\nDimmed";
$string['querydebug'] = 'Query debug';
$string['querytemplate'] = 'Query template';
$string['querytemplate_help'] = 'This query will be used to';
$string['querytemplateinstructions'] = 'Placeholders: <ul><li><b>%%SELECT%%</b> - Replaced with all selects based on field definitions. Do not include your own selects!</li><li><b>%%WHERE%%</b> - Replaced with clauses generated from filters. You can safely add more clauses by appending AND after %%WHERE%%</li><li><b>%%GROUPBY%%</b> - Replaced with grouping field(s) depending on data source</li><li><b>%%ORDERBY%%</b> - Replaced with default sort or user selected sort (clicking the column heading in a table for example)</li></ul>';
$string['querytemplatetip'] = 'Tip: Press Ctrl + Space to show intellisense / autocomplete when typing your query.';
$string['readymatewidgets'] = 'Ready to use widgets';
$string['readymatewidgets_help'] = 'Use the bellow widgets, widgets are easy to use, there is no need to setup additional configurations.';
$string['recentcoursename'] = 'Recent course';
$string['redirecttodashboard'] = "Redirect to dashboard";
$string['relations'] = 'Relations';
$string['relations_help'] = 'Includes users assigned specific user context roles (e.g., mentor, parent, line manager, coach).';
$string['restrict_operator'] = 'Operator';
$string['restrictaccess'] = "Restrict access";
$string['restrictaccessheading'] = 'Restrict access';
$string['restrictbyactivitycompletion'] = 'Restrict by activity completion status';
$string['restrictbyactivitycompletion_help'] = 'This setting allows you to control content visibility based on the user\'s completion status for the selected activities. If the block is placed on the page of a specific activity, the user\'s completion status for that activity will be used.<br><b>Incomplete:</b> The block is visible only to users who have not completed all selected activities.<br><b>Complete:</b>The block is visible only to users who have completed all selected activities.<br><b>Passed:</b> The block is visible only to users who have completed all selected activities and achieved the passing grade for each.<br><b>Failed:</b>The block is visible only to users who have completed all selected activities but did not achieve the passing grade for at least one. ';
$string['restrictbycohort'] = 'Restrict by cohort';
$string['restrictbycohort_help'] = 'This setting allows you to control the visibility of content based on the user\'s cohort membership. Only users who are part of the specified cohorts will be able to see the content.';
$string['restrictbycoursecompletion'] = 'Restrict by course completion status';
$string['restrictbycoursecompletion_help'] = 'This setting allows you to control content visibility based on the user\'s enrollment and progress status in the course.<br><b>Not enrolled:</b> Content is visible only to users who are not enrolled in the course, such as guest users.<br><b>Enrolled:</b> Content is visible only to users who are enrolled in the course but have not yet completed any activity.<br><b>In progress:</b> Content is visible only to users who are enrolled in the course and have completed at least one activity.<br><b>Completed:</b> Content is visible only to users who are enrolled in the course and have completed all required activities to mark the course as completed.';
$string['restrictbygrade'] = 'Restrict by course grade';
$string['restrictbygrade_help'] = 'This setting allows you to control content visibility based on the user\'s total grade in the course. The block will only be visible if the user\'s course grade falls within the specified range.';
$string['restrictbygroup'] = 'Restrict by course group';
$string['restrictbygroup_help'] = 'This setting allows you to control the visibility of content based on the user\'s group membership within the current course. Only users who are part of the selected groups will be able to see the content.';
$string['restrictbyrole'] = 'Restrict by role';
$string['restrictbyrole_help'] = 'This setting allows you to control the visibility of content based on the user\'s assigned role within the any or site. Only users with the specified roles will be able to see the content.';
$string['restrictcurrentsection'] = "Automatically restrict to current section";
$string['restrictcurrentsection_desc'] = 'If a dash block with the content addon is added to a single-section page, it shall be automatically restricted to that section.';
$string['restrictrolecontext'] = 'Context';
$string['restrictrolecontext_help'] = 'Select the context for which the user\'s role should be checked (Any context or system context only)';
$string['resumecourse'] = "Resume course";
$string['resumelearningpath'] = "Resume learning path";
$string['rightbottom'] = "Right Bottom";
$string['rightcenter'] = "Right Center";
$string['righttop'] = "Right Top";
$string['role_assignments'] = "Role assignments";
$string['rolename'] = "Role name";
$string['rows'] = 'Rows';
$string['rows_help'] = 'Number of rows to display when using multiple rows with slidesPerRow option.';
$string['savechanges'] = "Save changes";
$string['secondarynav'] = 'Add to course navigation';
$string['selectactivity'] = 'Select activity';
$string['selectactivity_help'] = 'Select the activity for which the completion status should be checked.';
$string['selectcampaign'] = 'Select campaign';
$string['selectcategory'] = 'Select category';
$string['selectcourse'] = 'Select course';
$string['selectlayout'] = 'Select the content layout in preferences to add content';
$string['selfallocationwithkey'] = 'Sigup (Key required)';
$string['setup'] = 'Setup';
$string['shopurl'] = 'Shop URL';
$string['showheader'] = "Show header";
$string['showheader_help'] = "Hide the block title if editing is turned off.";
$string['showhiddencourses'] = 'Show hidden courses';
$string['skills'] = 'Skills';
$string['slidesPerRow'] = 'Slides per row';
$string['slidesPerRow_help'] = 'Number of slides to display in one row.';
$string['slidesToScroll'] = 'Slides to scroll';
$string['slidesToScroll_help'] = 'Number of slides to scroll at once.';
$string['slidesToShow'] = 'Slides to show';
$string['slidesToShow_help'] = 'Number of slides to display at once.';
$string['smallimage'] = "Small image";
$string['smart_coursebutton'] = 'Smart course button';
$string['sortalpha'] = 'Alphabetically';
$string['sortcoursestartdate'] = 'Course start date';
$string['sortenrolmentdate'] = 'Enrolment date';
$string['source'] = 'Source';
$string['speed'] = 'Transition speed (ms)';
$string['speed_help'] = 'Set the speed of the slide transition in milliseconds.';
$string['startcourse'] = "Start course";
$string['stattodisplay'] = 'Figure to display';
$string['stattodisplayother'] = 'Other figure to display';
$string['status'] = 'Status';
$string['status:all'] = 'All';
$string['status:completed'] = 'Completed';
$string['status:enrolled'] = 'Enrolled';
$string['status:inprogress'] = 'In Progress';
$string['status:notcompleted'] = 'Not completed';
$string['status:notenrolled'] = "Not enrolled";
$string['status:notyetstarted'] = 'Not yet started';
$string['strasc'] = "Asc";
$string['strcssclass'] = "CSS classes";
$string['strctacampaign'] = 'Registration';
$string['strctaenrolment'] = "View enrolment page";
$string['strcustom'] = "Custom";
$string['strcustomurl'] = "View URL";
$string['strdatasource'] = "datasource";
$string['strdesc'] = "Desc";
$string['strdisabled'] = "Disabled";
$string['strexpanding'] = "Expanding";
$string['strfloating'] = "Floating";
$string['strgrid'] = "Grid";
$string['strgridsize'] = "Grid size";
$string['strinfo'] = "Info";
$string['strmasonry'] = "Masonry";
$string['strmasonrysearch'] = "Search box";
$string['strmasonrysort'] = "Sorting";
$string['strmodal'] = "Modal";
$string['strpromotion'] = "Promotion";
$string['strrole'] = "Role";
$string['strshopurl'] = 'View shop';
$string['strslider'] = "Slider";
$string['styleoptions'] = "Styling options";
$string['styleoptions_help'] = 'In order to apply individual styles to items, you can use custom fields. Pick the custom fields that you should be applied as CSS class to the grid item. Note: You have to create CSS styles yourself, Dash does not come with predefined CSS styles (but we plan to add the in the next version).';
$string['subheadingfield'] = 'Subheading field';
$string['subheadingfieldicon'] = 'Subheading icon';
$string['suggestcohort'] = 'Suggest users that have same cohort';
$string['suggestcohort_desc'] = 'Display the users with same interests users contact list block';
$string['suggestcontacts'] = 'Suggested contacts';
$string['suggestgroups'] = 'Suggest users that have same groups';
$string['suggestgroups_desc'] = 'Display the users with same interests users contact list block';
$string['suggestinterests'] = 'Suggest users that have same interests';
$string['suggestinterests_desc'] = 'Display the users with same interests users contact list block';
$string['suggestion:cohort'] = 'Also member of {$a->cohort}';
$string['suggestion:groups'] = 'In your group {$a->group}';
$string['suggestion:interest'] = 'Also interested in {$a->interest}';
$string['suggestion:users'] = 'Recommended on this site';
$string['suggestusers'] = 'Suggest users that have same users';
$string['suggestusers_desc'] = 'Display the users with same interests users contact list block';
$string['supportsfieldvisibility'] = 'Supports field visibility';
$string['supportsfieldvisibility_help'] = 'When enabled, allow admin to conditionally enable and disable fields.';
$string['supportsfiltering'] = 'Supports filtering';
$string['supportsfiltering_help'] = 'When enabled allow filtering results. This is handled by data source.';
$string['supportspagination'] = 'Supports pagination';
$string['supportspagination_help'] = 'When enabled, results will be automatically paginated. Pagination bar will be displayed.';
$string['supportssorting'] = 'Supports sorting';
$string['supportssorting_help'] = 'When enabled, sorting is allowed (only with tables).';
$string['swipeToSlide'] = 'Swipe to slide';
$string['swipeToSlide_help'] = 'Enables swiping/dragging to slide to the closest slide after releasing touch.';
$string['system'] = 'System';
$string['systemcontext'] = "System";
$string['tabconditions'] = 'Conditions';
$string['tabfields'] = 'Fields';
$string['tabfilters'] = 'Filters';
$string['tabgeneral'] = 'General';
$string['tablealias_c'] = 'Course';
$string['tablealias_cc'] = 'Course category';
$string['tablealias_ccp'] = 'Course completion';
$string['tablealias_ctx'] = 'Context';
$string['tablealias_dd'] = 'Dashboard';
$string['tablealias_e'] = 'Enrollment method';
$string['tablealias_g'] = 'Group';
$string['tablealias_r'] = "Role";
$string['tablealias_ra'] = 'Role assignment';
$string['tablealias_sl'] = 'Site logs';
$string['tablealias_tsk'] = 'Skills';
$string['tablealias_u'] = 'User';
$string['tablealias_ue'] = 'User enrollment';
$string['tablejoin'] = 'Select Join table';
$string['tablejoin_help'] = 'Choose the table to join with main table. Use the alias for conditions.';
$string['tablejoinon'] = 'Enter condition query to join';
$string['tablejoinsalias'] = 'Table alias';
$string['tablejoinshdr'] = 'Join tables';
$string['tablejoinstatichdr'] = 'Joint table #{$a}';
$string['tablet_learningpath'] = "Learning Path for Tablet";
$string['tablet_learningpath_desc'] = "";
$string['tags'] = 'Tags';
$string['textcolor'] = 'Text color';
$string['timemodified'] = "Time modified";
$string['timesinceevent'] = 'Time since event';
$string['tinyimage'] = "Tiny image";
$string['titleoverride'] = 'Title override';
$string['totalactivities'] = 'Total activities';
$string['totalactivitiescompletion'] = 'Total activities (completion relevant)';
$string['totallevelpoints'] = 'Total level points';
$string['totalpoints'] = 'Total points';
$string['totalprogress'] = 'Total progress';
$string['transformformat'] = 'Transform format of {$a}';
$string['trialpath'] = "Trial";
$string['usercontext'] = "User";
$string['userprofilelink'] = 'User profile link';
$string['userprofileurl'] = 'User profile URL';
$string['users'] = 'Users';
$string['users_help'] = 'Users Datasource display the list of available users from the LMS';
$string['users_mycohort'] = "Users in one of my cohorts";
$string['userscompleted'] = 'Users completed';
$string['usersnotcompleted'] = 'Users not completed';
$string['userstat'] = 'User stat';
$string['variableWidth'] = 'Variable width';
$string['variableWidth_help'] = 'Enables variable width slides.';
$string['vertical'] = 'Vertical';
$string['verticalSwiping'] = 'Vertical swiping';
$string['verticalSwiping_help'] = 'Enables vertical swiping/dragging of slides.';
$string['vertical_help'] = 'Vertical slide orientation.';
$string['viewactivity'] = "View activity";
$string['viewcourse'] = 'View course';
$string['viewdetails'] = 'View details';
$string['viewprofile'] = 'View profile';
$string['viewprogram'] = 'View program';
$string['widget'] = 'Widget';
$string['widget:course_completions'] = 'Course completions';
$string['widget:course_completions_help'] = 'Course progress report.';
$string['widget:course_enrols'] = 'Enrolments Widget';
$string['widget:course_enrols_help'] = 'Display the list of enrolled courses with completion progress';
$string['widget:course_sections'] = 'Course sections';
$string['widget:course_sections_help'] = 'Use this widget to interact with your course sections effortlessly.';
$string['widget:groups:adduser'] = 'Add user';
$string['widget:groups:chat'] = 'Chat';
$string['widget:groups:creategroup'] = 'Create Group';
$string['widget:groups:groupmembers'] = 'View Members';
$string['widget:groups:leavegroup'] = 'Leave Group';
$string['widget:learningpath'] = 'Learning Path';
$string['widget:learningpath_help'] = 'List of courses available in the learning path.';
$string['widget:mycontacts'] = 'My Contacts';
$string['widget:mycontacts_help'] = 'List of users available in the contacts list.';
$string['widget:mygroups'] = 'My groups';
$string['widget:mygroups_help'] = 'List of assigned groups for the user, Can able to view other members in the group, add memebers to the group, Leave from the groups and more';
$string['widget:mylearning'] = 'My learning';
$string['widget:mylearning_help'] = 'List of user enrolled courses with basic course informations such as staffs and available badges and list of course sections and modules';
$string['widget:myprofile'] = 'My profile';
$string['widget:myprofile_help'] = 'Display the information about the user profile with important KPI';
$string['widget:skill_graph'] = 'Skill graph';
$string['widget:skill_graph_help'] = 'Competency breakdown report';
$string['widget:skilllevelvisuals'] = 'Skill level visuals';
$string['widget:skilllevelvisuals_help'] = 'Display the levels associated with the selected skill as images.';
$string['widget:skillprogress'] = 'Skill progress';
$string['widget:skillprogress_help'] = 'Skill Progress displays the user\'s overall progress in all selected skills, including the current level and points earned for each skill individually.';
$string['widgetsdesc'] = 'Pick a ready-to-use content widget and configure it';
$string['withroles'] = 'With role(s)';
$string['yourcurrentlevel'] = 'Your current level';
