<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * A field is a simple container for a single value within a row/collection.
 *
 * @package    block_dash
 * @copyright  2019 bdecent gmbh <https://bdecent.de>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_dash\local\data_grid\data;
/**
 * A field is a simple container for a single value within a row/collection.
 *
 * @package block_dash
 */
interface field_interface {

    /**
     * Get field name.
     *
     * @return string
     */
    public function get_name();

    /**
     * Get field value.
     *
     * @return mixed|string
     */
    public function get_value();

    /**
     * Get human readable field label.
     * @return string
     */
    public function get_label();
}
