/**
 * Add a create new group modal to the page.
 *
 * @module     core_group/newgroup
 * @class      PreferencesModal
 * @copyright  2017 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_dash/preferences_modal",["jquery","core/str","core/modal_factory","core/modal_events","core/fragment","core/ajax","block_dash/select2","core/notification"],(function($,Str,ModalFactory,ModalEvents,Fragment,Ajax,Select2,Notification){var PreferencesModal=function(selector,contextid,onCloseCallback){this.contextid=contextid,this.onCloseCallback=onCloseCallback,this.tab="",this.init(selector)};return PreferencesModal.prototype.modal=null,PreferencesModal.prototype.contextid=-1,PreferencesModal.prototype.init=function(selector){var triggers=$(selector);return Str.get_string("editpreferences","block_dash").then(function(title){return ModalFactory.create({type:ModalFactory.types.DEFAULT,title:title,body:this.getBody()},triggers)}.bind(this)).then(function(modal){return this.modal=modal,this.modal.setLarge(),this.modal.getRoot().on(ModalEvents.shown,function(){this.modal.setBody(this.getBody())}.bind(this)),this.modal.getRoot().on("change","#id_config_preferences_layout",this.submitFormAjax.bind(this,!1)),this.modal.getRoot().on("click","[data-action=cancel]",(()=>{this.modal.hide()})),this.modal.getRoot().on(ModalEvents.save,this.submitForm.bind(this)),this.modal.getRoot().on("submit","form",this.submitFormAjax.bind(this,!0)),this.modal.getRoot().on(ModalEvents.bodyRendered,function(){$("#fgroup_id_available_fields .felement > fieldset > div").sortable({items:".form-check-inline.fitem",handle:".drag-handle",axis:"y"}),this.initSelect2()}.bind(this)),this.modal.getRoot().on(ModalEvents.hidden,function(e){window.onbeforeunload=null,this.onCloseCallback&&this.onCloseCallback(e)}.bind(this)),this.modal.getRoot().on("click","[data-action=change-tab]",(e=>{this.changeTab($(e.target).data("tab"))})),this.modal}.bind(this))},PreferencesModal.prototype.changeTab=function(tab){this.tab=tab,this.submitFormAjax(!1)},PreferencesModal.prototype.getBody=function(formdata){void 0===formdata&&(formdata={});var params={jsonformdata:JSON.stringify(formdata),tab:this.tab};return Fragment.loadFragment("block_dash","block_preferences_form",this.contextid,params)},PreferencesModal.prototype.handleFormSubmissionResponse=function(formData,closeWhenDone,response){response.validationerrors||!closeWhenDone?this.modal.setBody(this.getBody(formData)):closeWhenDone&&this.modal.hide()},PreferencesModal.prototype.handleFormSubmissionFailure=function(data){this.modal.setBody(this.getBody(data))},PreferencesModal.prototype.submitFormAjax=function(closeWhenDone,e){e&&e.preventDefault();var invalid=$.merge(this.modal.getRoot().find('[aria-invalid="true"]'),this.modal.getRoot().find(".error"));if(invalid.length)invalid.first().focus();else{var formData=this.modal.getRoot().find("form").serialize();Ajax.call([{methodname:"block_dash_submit_preferences_form",args:{contextid:this.contextid,jsonformdata:JSON.stringify(formData)},done:this.handleFormSubmissionResponse.bind(this,formData,closeWhenDone),fail:this.handleFormSubmissionFailure.bind(this,formData)}])[0].fail(Notification.exception)}},PreferencesModal.prototype.getModal=function(){return this.modal},PreferencesModal.prototype.submitForm=function(e){e.preventDefault(),this.modal.getRoot().find("form").submit()},PreferencesModal.prototype.initSelect2=function(){this.modal.getRoot().find(".select2-form select").each((function(index,element){let placeholder=null;$(element).find("option[value='-1']")&&(placeholder={id:"-1",text:$(element).find("option[value='-1']").text()}),$(element).select2({dropdownParent:$(this).parent(),allowClear:!0,theme:"bootstrap4",placeholder:placeholder}).on("select2:unselecting",(function(){$(this).data("unselecting",!0)})).on("select2:opening",(function(e){$(this).data("unselecting")&&($(this).removeData("unselecting"),e.preventDefault())}))}))},PreferencesModal}));

//# sourceMappingURL=preferences_modal.min.js.map